/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.CollectionLoader;
import net.sf.hibernate.loader.OneToManyLoader;
import net.sf.hibernate.mapping.Array;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.IdentifierCollection;
import net.sf.hibernate.mapping.IndexedCollection;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.metadata.CollectionMetadata;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.sql.Delete;
import net.sf.hibernate.sql.Insert;
import net.sf.hibernate.sql.SelectFragment;
import net.sf.hibernate.sql.Update;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CollectionPersister
implements CollectionMetadata {
    private final String sqlDeleteString;
    private final String sqlInsertRowString;
    private final String sqlUpdateRowString;
    private final String sqlDeleteRowString;
    private final String sqlOrderByString;
    private final String sqlWhereString;
    private final String sqlOrderByStringTemplate;
    private final String sqlWhereStringTemplate;
    private final boolean hasOrder;
    private final boolean hasWhere;
    private final Type keyType;
    private final Type indexType;
    private final Type elementType;
    private final String[] keyColumnNames;
    private final String[] indexColumnNames;
    private final String[] elementColumnNames;
    private final String[] rowSelectColumnNames;
    private final String[] indexColumnAliases;
    private final String[] elementColumnAliases;
    private final String[] keyColumnAliases;
    private final Type rowSelectType;
    private final boolean primitiveArray;
    private final boolean array;
    private final boolean isOneToMany;
    private final String qualifiedTableName;
    private final boolean hasIndex;
    private final boolean isLazy;
    private final boolean isInverse;
    private final Class elementClass;
    private final CacheConcurrencyStrategy cache;
    private final PersistentCollectionType collectionType;
    private final int enableJoinedFetch;
    private final Class ownerClass;
    private final IdentifierGenerator identifierGenerator;
    private final String unquotedIdentifierColumnName;
    private final Type identifierType;
    private final boolean hasIdentifier;
    private final String identifierColumnName;
    private final String identifierColumnAlias;
    private final Dialect dialect;
    private final CollectionInitializer loader;
    private final String role;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$collection$CollectionPersister == null ? (class$net$sf$hibernate$collection$CollectionPersister = CollectionPersister.class$("net.sf.hibernate.collection.CollectionPersister")) : class$net$sf$hibernate$collection$CollectionPersister));
    private static final Set KEYWORDS = new HashSet();
    private static final String TEMPLATE = "$PlaceHolder";
    static /* synthetic */ Class class$net$sf$hibernate$collection$CollectionPersister;

    public CollectionPersister(Collection collection, Configuration datastore, SessionFactoryImplementor factory) throws MappingException, CacheException {
        Type selectColumns;
        String[] selectType;
        Table table;
        this.dialect = factory.getDialect();
        this.collectionType = collection.getType();
        this.role = collection.getRole();
        this.ownerClass = collection.getOwnerClass();
        Alias alias = new Alias("__");
        this.sqlOrderByString = collection.getOrderBy();
        this.hasOrder = this.sqlOrderByString != null;
        this.sqlOrderByStringTemplate = this.hasOrder ? CollectionPersister.renderOrderByStringTemplate(this.sqlOrderByString, this.dialect) : null;
        this.sqlWhereString = collection.getWhere();
        this.hasWhere = this.sqlWhereString != null;
        this.sqlWhereStringTemplate = this.hasWhere ? CollectionPersister.renderWhereStringTemplate(this.sqlWhereString, this.dialect) : null;
        this.cache = collection.getCache();
        this.keyType = collection.getKey().getType();
        Iterator iter = collection.getKey().getColumnIterator();
        int span = collection.getKey().getColumnSpan();
        this.keyColumnNames = new String[span];
        String[] keyAliases = new String[span];
        int k = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.keyColumnNames[k] = col.getQuotedName(this.dialect);
            keyAliases[k] = col.getAlias();
            ++k;
        }
        this.keyColumnAliases = alias.toAliasStrings(keyAliases);
        this.isOneToMany = collection.isOneToMany();
        this.primitiveArray = collection.isPrimitiveArray();
        this.array = collection.isArray();
        if (this.isOneToMany) {
            EntityType type = collection.getOneToMany().getType();
            this.elementType = type;
            PersistentClass associatedClass = datastore.getClassMapping(type.getPersistentClass());
            span = associatedClass.getIdentifier().getColumnSpan();
            iter = associatedClass.getKey().getColumnIterator();
            table = associatedClass.getTable();
            this.enableJoinedFetch = 1;
        } else {
            table = collection.getTable();
            this.elementType = collection.getElement().getType();
            span = collection.getElement().getColumnSpan();
            this.enableJoinedFetch = collection.getElement().getOuterJoinFetchSetting();
            iter = collection.getElement().getColumnIterator();
        }
        this.qualifiedTableName = table.getQualifiedName(this.dialect, factory.getDefaultSchema());
        String[] aliases = new String[span];
        this.elementColumnNames = new String[span];
        int j = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.elementColumnNames[j] = col.getQuotedName(this.dialect);
            aliases[j] = col.getAlias();
            ++j;
        }
        this.elementColumnAliases = alias.toAliasStrings(aliases);
        this.hasIndex = collection.isIndexed();
        if (this.hasIndex) {
            IndexedCollection indexedMap = (IndexedCollection)collection;
            this.indexType = indexedMap.getIndex().getType();
            int indexSpan = indexedMap.getIndex().getColumnSpan();
            iter = indexedMap.getIndex().getColumnIterator();
            this.indexColumnNames = new String[indexSpan];
            String[] indexAliases = new String[indexSpan];
            int i = 0;
            while (iter.hasNext()) {
                Column indexCol = (Column)iter.next();
                indexAliases[i] = indexCol.getAlias();
                this.indexColumnNames[i] = indexCol.getQuotedName(this.dialect);
                ++i;
            }
            selectType = this.indexColumnNames;
            selectColumns = this.indexType;
            this.indexColumnAliases = alias.toAliasStrings(indexAliases);
        } else {
            this.indexType = null;
            this.indexColumnNames = null;
            this.indexColumnAliases = null;
            selectType = this.elementColumnNames;
            selectColumns = this.elementType;
        }
        this.hasIdentifier = collection.isIdentified();
        if (this.hasIdentifier) {
            if (this.isOneToMany) {
                throw new MappingException("one-to-many collections with identifiers are not supported");
            }
            IdentifierCollection idColl = (IdentifierCollection)collection;
            this.identifierType = idColl.getIdentifier().getType();
            iter = idColl.getIdentifier().getColumnIterator();
            Column col = (Column)iter.next();
            this.identifierColumnName = col.getQuotedName(this.dialect);
            selectType = new String[]{this.identifierColumnName};
            selectColumns = this.identifierType;
            this.unquotedIdentifierColumnName = this.identifierColumnAlias = alias.toAliasString(col.getAlias());
            this.identifierGenerator = idColl.getIdentifier().createIdentifierGenerator(factory.getDialect());
        } else {
            this.identifierType = null;
            this.identifierColumnName = null;
            this.identifierColumnAlias = null;
            this.unquotedIdentifierColumnName = null;
            this.identifierGenerator = null;
        }
        this.rowSelectColumnNames = selectType;
        this.rowSelectType = selectColumns;
        this.sqlDeleteString = this.generateDeleteString();
        this.sqlInsertRowString = this.generateInsertRowString();
        this.sqlUpdateRowString = this.generateUpdateRowString();
        this.sqlDeleteRowString = this.generateDeleteRowString();
        this.isLazy = collection.isLazy();
        this.isInverse = collection.isInverse();
        this.elementClass = collection.isArray() ? ((Array)collection).getElementClass() : null;
        this.loader = this.createCollectionQuery(factory);
    }

    public CollectionInitializer getInitializer() {
        return this.loader;
    }

    private CollectionInitializer createCollectionQuery(SessionFactoryImplementor factory) throws MappingException {
        return this.isOneToMany() ? new OneToManyLoader(this, factory) : new CollectionLoader(this, factory);
    }

    public void cache(Serializable id, PersistentCollection coll, SessionImplementor s) throws HibernateException {
        if (this.cache != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching collection: " + this.role + '#' + id));
            }
            this.cache.put(id, coll.disassemble(this), s.getTimestamp());
        }
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public PersistentCollection getCachedCollection(Serializable id, Object owner, SessionImplementor s) throws HibernateException {
        Serializable cached;
        if (this.cache == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for collection in cache: " + this.role + '#' + id));
        }
        if ((cached = (Serializable)this.cache.get(id, s.getTimestamp())) == null) {
            return null;
        }
        return this.collectionType.assembleCachedCollection(s, this, cached, owner);
    }

    public void softlock(Serializable id) throws CacheException {
        if (this.cache != null) {
            this.cache.lock(id);
        }
    }

    public void releaseSoftlock(Serializable id) throws CacheException {
        if (this.cache != null) {
            this.cache.release(id);
        }
    }

    public PersistentCollectionType getType() {
        return this.collectionType;
    }

    public String getSQLWhereString(String alias) {
        return StringHelper.replace(this.sqlWhereStringTemplate, TEMPLATE, alias);
    }

    public String getSQLOrderByString(String alias) {
        return StringHelper.replace(this.sqlOrderByStringTemplate, TEMPLATE, alias);
    }

    private static String renderWhereStringTemplate(String sqlWhereString, Dialect dialect) {
        StringTokenizer tokens = new StringTokenizer(sqlWhereString, " =><!+-*/()',", true);
        StringBuffer result = new StringBuffer();
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            boolean isIdentifier;
            String token = tokens.nextToken();
            if ("'".equals(token)) {
                boolean bl = quoted = !quoted;
            }
            if (quoted) {
                result.append(token);
                continue;
            }
            boolean bl = isIdentifier = token.charAt(0) == '`' || Character.isLetter(token.charAt(0)) && !KEYWORDS.contains(token.toLowerCase());
            if (isIdentifier) {
                result.append(TEMPLATE).append('.').append(CollectionPersister.quote(token, dialect));
                continue;
            }
            result.append(token);
        }
        return result.toString();
    }

    private static String renderOrderByStringTemplate(String sqlOrderByString, Dialect dialect) {
        StringTokenizer tokens = new StringTokenizer(sqlOrderByString, ",");
        StringBuffer result = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String column = CollectionPersister.quote(tokens.nextToken().trim(), dialect);
            result.append(TEMPLATE).append('.').append(column);
            if (!tokens.hasMoreTokens()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static String quote(String column, Dialect dialect) {
        if (column.charAt(0) == '`') {
            return dialect.openQuote() + column.substring(1, column.length() - 1) + dialect.closeQuote();
        }
        return column;
    }

    public int enableJoinedFetch() {
        return this.enableJoinedFetch;
    }

    public boolean hasOrdering() {
        return this.hasOrder;
    }

    public boolean hasWhere() {
        return this.hasWhere;
    }

    private String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    private String getSQLInsertRowString() {
        return this.sqlInsertRowString;
    }

    private String getSQLUpdateRowString() {
        return this.sqlUpdateRowString;
    }

    private String getSQLDeleteRowString() {
        return this.sqlDeleteRowString;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getIndexType() {
        return this.indexType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Object readElement(ResultSet rs, Object owner, SessionImplementor session) throws HibernateException, SQLException {
        Object element = this.getElementType().nullSafeGet(rs, this.elementColumnAliases, session, owner);
        return element;
    }

    public Object readIndex(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object index = this.getIndexType().nullSafeGet(rs, this.indexColumnAliases, session, null);
        if (index == null) {
            throw new HibernateException("null index column for collection: " + this.role);
        }
        return index;
    }

    public Object readIdentifier(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object id = this.getIdentifierType().nullSafeGet(rs, this.unquotedIdentifierColumnName, session, null);
        if (id == null) {
            throw new HibernateException("null identifier column for collection: " + this.role);
        }
        return id;
    }

    public Object readKey(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        return this.getKeyType().nullSafeGet(rs, this.keyColumnAliases, session, null);
    }

    public void writeElement(PreparedStatement st, Object elt, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        this.getElementType().nullSafeSet(st, elt, 1 + (writeOrder ? 0 : this.keyColumnNames.length + (this.hasIndex ? this.indexColumnNames.length : 0) + (this.hasIdentifier ? 1 : 0)), session);
    }

    public void writeIndex(PreparedStatement st, Object idx, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        this.getIndexType().nullSafeSet(st, idx, 1 + this.keyColumnNames.length + (writeOrder ? this.elementColumnNames.length : 0), session);
    }

    public void writeIdentifier(PreparedStatement st, Object idx, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        this.getIdentifierType().nullSafeSet(st, idx, 1 + (writeOrder ? this.elementColumnNames.length : this.keyColumnNames.length), session);
    }

    private void writeRowSelect(PreparedStatement st, Object idx, SessionImplementor session) throws HibernateException, SQLException {
        this.rowSelectType.nullSafeSet(st, idx, 1 + (this.hasIdentifier ? 0 : this.keyColumnNames.length), session);
    }

    public void writeKey(PreparedStatement st, Serializable id, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        if (id == null) {
            throw new NullPointerException("null key for collection: " + this.role);
        }
        this.getKeyType().nullSafeSet(st, id, 1 + (writeOrder ? this.elementColumnNames.length : 0), session);
    }

    public boolean isPrimitiveArray() {
        return this.primitiveArray;
    }

    public boolean isArray() {
        return this.array;
    }

    public String selectClauseFragment(String alias) {
        SelectFragment frag = new SelectFragment().setSuffix("").addColumns(alias, this.elementColumnNames, this.elementColumnAliases);
        if (this.hasIndex) {
            frag.addColumns(alias, this.indexColumnNames, this.indexColumnAliases);
        }
        if (this.hasIdentifier) {
            frag.addColumn(alias, this.identifierColumnName, this.identifierColumnAlias);
        }
        return frag.toFragmentString().substring(2);
    }

    public String multiselectClauseFragment(String alias) {
        SelectFragment frag = new SelectFragment().setSuffix("").addColumns(alias, this.elementColumnNames, this.elementColumnAliases).addColumns(alias, this.keyColumnNames, this.keyColumnAliases);
        if (this.hasIndex) {
            frag.addColumns(alias, this.indexColumnNames, this.indexColumnAliases);
        }
        if (this.hasIdentifier) {
            frag.addColumn(alias, this.identifierColumnName, this.identifierColumnAlias);
        }
        return frag.toFragmentString().substring(2);
    }

    private String generateDeleteString() {
        if (this.isOneToMany) {
            Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null").setPrimaryKeyColumnNames(this.keyColumnNames);
            if (this.hasIndex) {
                update.addColumns(this.indexColumnNames, "null");
            }
            if (this.hasWhere) {
                update.setWhere(this.sqlWhereString);
            }
            return update.toStatementString();
        }
        Delete delete = new Delete().setTableName(this.qualifiedTableName).setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasWhere) {
            delete.setWhere(this.sqlWhereString);
        }
        return delete.toStatementString();
    }

    private String generateInsertRowString() {
        if (this.isOneToMany) {
            Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
            if (this.hasIndex) {
                update.addColumns(this.indexColumnNames);
            }
            return update.setPrimaryKeyColumnNames(this.elementColumnNames).toStatementString();
        }
        Insert insert = new Insert(null).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIndex) {
            insert.addColumns(this.indexColumnNames);
        }
        if (this.hasIdentifier) {
            insert.addColumn(this.identifierColumnName);
        }
        return insert.addColumns(this.elementColumnNames).toStatementString();
    }

    private String generateUpdateRowString() {
        if (this.isOneToMany) {
            return null;
        }
        Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.elementColumnNames);
        if (this.hasIdentifier) {
            update.setPrimaryKeyColumnNames(this.rowSelectColumnNames);
        } else {
            update.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.rowSelectColumnNames));
        }
        return update.toStatementString();
    }

    private String generateDeleteRowString() {
        String[] pkColumns = this.hasIdentifier ? this.rowSelectColumnNames : ArrayHelper.join(this.keyColumnNames, this.rowSelectColumnNames);
        if (this.isOneToMany) {
            Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null");
            if (this.hasIndex) {
                update.addColumns(this.indexColumnNames, "null");
            }
            return update.setPrimaryKeyColumnNames(pkColumns).toStatementString();
        }
        return new Delete().setTableName(this.qualifiedTableName).setPrimaryKeyColumnNames(pkColumns).toStatementString();
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    public boolean isOneToMany() {
        return this.isOneToMany;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isInverse() {
        return this.isInverse;
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public final void remove(Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isInverse) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting collection: " + this.role + "#" + id));
            }
            PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteString());
            try {
                this.writeKey(st, id, false, session);
                session.getBatcher().addToBatch(-1);
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"done deleting collection");
            }
        }
    }

    public final void recreate(PersistentCollection collection, Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isInverse) {
            Iterator entries;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inserting collection: " + this.role + "#" + id));
            }
            if ((entries = collection.entries()).hasNext()) {
                PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                int i = 0;
                try {
                    while (entries.hasNext()) {
                        Object entry = entries.next();
                        if (collection.entryExists(entry, i)) {
                            collection.preInsert(this, entry, i);
                            this.writeKey(st, id, false, session);
                            collection.writeTo(st, this, entry, i, false);
                            session.getBatcher().addToBatch(1);
                        }
                        ++i;
                    }
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"done inserting collection");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"collection was empty");
            }
        }
    }

    public final void deleteRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isInverse) {
            Iterator entries;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting rows of collection: " + this.role + "#" + id));
            }
            if ((entries = collection.getDeletes(this.elementType)).hasNext()) {
                PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                try {
                    while (entries.hasNext()) {
                        if (!this.hasIdentifier) {
                            this.writeKey(st, id, false, session);
                        }
                        this.writeRowSelect(st, entries.next(), session);
                        session.getBatcher().addToBatch(-1);
                    }
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"done deleting collection rows");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"no rows to delete");
            }
        }
    }

    private final void update(Serializable id, PersistentCollection collection, SessionImplementor session) throws SQLException, HibernateException {
        PreparedStatement st = null;
        Iterator entries = collection.entries();
        int i = 0;
        try {
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (collection.needsUpdating(entry, i, this.elementType)) {
                    if (st == null) {
                        st = session.getBatcher().prepareBatchStatement(this.getSQLUpdateRowString());
                    }
                    if (!this.hasIdentifier) {
                        this.writeKey(st, id, true, session);
                    }
                    collection.writeTo(st, this, entry, i, true);
                    session.getBatcher().addToBatch(1);
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    private final void updateOneToMany(Serializable id, PersistentCollection collection, SessionImplementor session) throws SQLException, HibernateException {
        PreparedStatement rmvst = null;
        int i = 0;
        Iterator entries = collection.entries();
        try {
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (collection.needsUpdating(entry, i, this.elementType)) {
                    if (rmvst == null) {
                        rmvst = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                    }
                    this.writeKey(rmvst, id, false, session);
                    this.writeIndex(rmvst, collection.getIndex(entry, i), false, session);
                    session.getBatcher().addToBatch(-1);
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        PreparedStatement insst = null;
        i = 0;
        entries = collection.entries();
        try {
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (collection.needsUpdating(entry, i, this.elementType)) {
                    if (insst == null) {
                        insst = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                    }
                    this.writeKey(insst, id, false, session);
                    collection.writeTo(insst, this, entry, i, false);
                    session.getBatcher().addToBatch(1);
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public final void updateRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isInverse) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating rows of collection: " + this.role + "#" + id));
            }
            if (this.isOneToMany) {
                this.updateOneToMany(id, collection, session);
            } else {
                this.update(id, collection, session);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"done updating rows");
            }
        }
    }

    public final void insertRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isInverse) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inserting rows of collection: " + this.role + "#" + id));
            }
            Iterator entries = collection.entries();
            PreparedStatement st = null;
            int i = 0;
            try {
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    if (collection.needsInserting(entry, i, this.elementType)) {
                        collection.preInsert(this, entry, i);
                        if (st == null) {
                            st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                        }
                        this.writeKey(st, id, false, session);
                        collection.writeTo(st, this, entry, i, false);
                        session.getBatcher().addToBatch(1);
                    }
                    ++i;
                }
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"done inserting rows");
            }
        }
    }

    public String getRole() {
        return this.role;
    }

    public Class getOwnerClass() {
        return this.ownerClass;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public boolean hasIdentifier() {
        return this.hasIdentifier;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        KEYWORDS.add("and");
        KEYWORDS.add("or");
        KEYWORDS.add("not");
        KEYWORDS.add("like");
        KEYWORDS.add("is");
        KEYWORDS.add("in");
        KEYWORDS.add("between");
        KEYWORDS.add("null");
    }
}

