/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArrayHolder
extends PersistentCollection {
    private Object array;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$collection$PersistentCollection == null ? (class$net$sf$hibernate$collection$PersistentCollection = ArrayHolder.class$("net.sf.hibernate.collection.PersistentCollection")) : class$net$sf$hibernate$collection$PersistentCollection));
    private transient Class elementClass;
    private transient List tempList;
    static /* synthetic */ Class class$net$sf$hibernate$collection$PersistentCollection;

    public ArrayHolder(SessionImplementor session, Object array) {
        super(session);
        this.array = array;
        this.initialized = true;
    }

    public Serializable snapshot(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable result = (Serializable)Array.newInstance(persister.getElementClass(), length);
        int i = 0;
        while (i < length) {
            Object elt = Array.get(this.array, i);
            try {
                Array.set(result, i, persister.getElementType().deepCopy(elt));
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)"Array element type error", (Throwable)iae);
                throw new HibernateException("Array element type error", iae);
            }
            ++i;
        }
        return result;
    }

    public ArrayHolder(SessionImplementor session, CollectionPersister persister) throws HibernateException {
        super(session);
        this.elementClass = persister.getElementClass();
    }

    public Object getArray() {
        return this.array;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        Serializable snapshot = this.getSnapshot();
        int xlen = Array.getLength(snapshot);
        if (xlen != Array.getLength(this.array)) {
            return false;
        }
        int i = 0;
        while (i < xlen) {
            if (elementType.isDirty(Array.get(snapshot, i), Array.get(this.array, i), this.session)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Iterator elements() {
        int length = Array.getLength(this.array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        int i = 0;
        while (i < length) {
            list.add(Array.get(this.array, i));
            ++i;
        }
        return list.iterator();
    }

    public boolean empty() {
        return false;
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.session);
        persister.writeIndex(st, new Integer(i), writeOrder, this.session);
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.session);
        int index = (Integer)persister.readIndex(rs, this.session);
        int i = this.tempList.size();
        while (i <= index) {
            this.tempList.add(i, null);
            ++i;
        }
        this.tempList.set(index, element);
        return element;
    }

    public Iterator entries() {
        return this.elements();
    }

    public void beginRead() {
        this.tempList = new ArrayList();
    }

    public void endRead() {
        this.array = Array.newInstance(this.elementClass, this.tempList.size());
        int i = 0;
        while (i < this.tempList.size()) {
            Array.set(this.array, i, this.tempList.get(i));
            ++i;
        }
        this.tempList = null;
    }

    public Object getInitialValue(boolean lazy) throws HibernateException {
        super.getInitialValue(false);
        this.session.addArrayHolder(this);
        return this.array;
    }

    public void beforeInitialize(CollectionPersister persister) {
    }

    public boolean isDirectlyAccessible() {
        return true;
    }

    public ArrayHolder(SessionImplementor session, CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        super(session);
        Serializable[] cached = (Serializable[])disassembled;
        this.array = Array.newInstance(persister.getElementClass(), cached.length);
        int i = 0;
        while (i < cached.length) {
            Array.set(this.array, i, persister.getElementType().assemble(cached[i], session, owner));
            ++i;
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable[] result = new Serializable[length];
        int i = 0;
        while (i < length) {
            result[i] = persister.getElementType().disassemble(Array.get(this.array, i), this.session);
            ++i;
        }
        return result;
    }

    public Object getCachedValue() {
        this.session.addArrayHolder(this);
        return this.array;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        int end;
        int i;
        int arraySize;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        Serializable sn = this.getSnapshot();
        int snSize = Array.getLength(sn);
        if (snSize > (arraySize = Array.getLength(this.array))) {
            i = arraySize;
            while (i < snSize) {
                deletes.add(new Integer(i));
                ++i;
            }
            end = arraySize;
        } else {
            end = snSize;
        }
        i = 0;
        while (i < end) {
            if (Array.get(this.array, i) == null && Array.get(sn, i) != null) {
                deletes.add(new Integer(i));
            }
            ++i;
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return Array.get(this.array, i) != null && (i >= Array.getLength(sn) || Array.get(sn, i) == null);
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return i < Array.getLength(sn) && Array.get(sn, i) != null && Array.get(this.array, i) != null && elemType.isDirty(Array.get(this.array, i), Array.get(sn, i), this.session);
    }

    public Object getIndex(Object entry, int i) {
        return new Integer(i);
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

