/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;

public class JavaTokenizer {
    private static final boolean scannerDebug = false;
    private boolean allowBinaryLiterals;
    private boolean allowUnderscoresInLiterals;
    private Source source;
    private final Log log;
    private final Tokens tokens;
    protected Tokens.TokenKind tk;
    protected int radix;
    protected Name name;
    protected int errPos = -1;
    protected UnicodeReader reader;
    protected ScannerFactory fac;
    private static final boolean hexFloatsWork = JavaTokenizer.hexFloatsWork();

    private static boolean hexFloatsWork() {
        try {
            Float.valueOf("0x1.0p1");
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected JavaTokenizer(ScannerFactory scannerFactory, CharBuffer charBuffer) {
        this(scannerFactory, new UnicodeReader(scannerFactory, charBuffer));
    }

    protected JavaTokenizer(ScannerFactory scannerFactory, char[] cArray, int n) {
        this(scannerFactory, new UnicodeReader(scannerFactory, cArray, n));
    }

    protected JavaTokenizer(ScannerFactory scannerFactory, UnicodeReader unicodeReader) {
        this.fac = scannerFactory;
        this.log = scannerFactory.log;
        this.tokens = scannerFactory.tokens;
        this.source = scannerFactory.source;
        this.reader = unicodeReader;
        this.allowBinaryLiterals = this.source.allowBinaryLiterals();
        this.allowUnderscoresInLiterals = this.source.allowUnderscoresInLiterals();
    }

    protected void lexError(int n, String string, Object ... objectArray) {
        this.log.error(n, string, objectArray);
        this.tk = Tokens.TokenKind.ERROR;
        this.errPos = n;
    }

    private void scanLitChar(int n) {
        if (this.reader.ch == '\\') {
            if (this.reader.peekChar() == '\\' && !this.reader.isUnicode()) {
                this.reader.skipChar();
                this.reader.putChar('\\', true);
            } else {
                this.reader.scanChar();
                switch (this.reader.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char c = this.reader.ch;
                        int n2 = this.reader.digit(n, 8);
                        this.reader.scanChar();
                        if ('0' <= this.reader.ch && this.reader.ch <= '7') {
                            n2 = n2 * 8 + this.reader.digit(n, 8);
                            this.reader.scanChar();
                            if (c <= '3' && '0' <= this.reader.ch && this.reader.ch <= '7') {
                                n2 = n2 * 8 + this.reader.digit(n, 8);
                                this.reader.scanChar();
                            }
                        }
                        this.reader.putChar((char)n2);
                        break;
                    }
                    case 'b': {
                        this.reader.putChar('\b', true);
                        break;
                    }
                    case 't': {
                        this.reader.putChar('\t', true);
                        break;
                    }
                    case 'n': {
                        this.reader.putChar('\n', true);
                        break;
                    }
                    case 'f': {
                        this.reader.putChar('\f', true);
                        break;
                    }
                    case 'r': {
                        this.reader.putChar('\r', true);
                        break;
                    }
                    case '\'': {
                        this.reader.putChar('\'', true);
                        break;
                    }
                    case '\"': {
                        this.reader.putChar('\"', true);
                        break;
                    }
                    case '\\': {
                        this.reader.putChar('\\', true);
                        break;
                    }
                    default: {
                        this.lexError(this.reader.bp, "illegal.esc.char", new Object[0]);
                        break;
                    }
                }
            }
        } else if (this.reader.bp != this.reader.buflen) {
            this.reader.putChar(true);
        }
    }

    private void scanDigits(int n, int n2) {
        int n3;
        char c;
        do {
            if (this.reader.ch != '_') {
                this.reader.putChar(false);
            } else if (!this.allowUnderscoresInLiterals) {
                this.lexError(n, "unsupported.underscore.lit", this.source.name);
                this.allowUnderscoresInLiterals = true;
            }
            c = this.reader.ch;
            n3 = this.reader.bp;
            this.reader.scanChar();
        } while (this.reader.digit(n, n2) >= 0 || this.reader.ch == '_');
        if (c == '_') {
            this.lexError(n3, "illegal.underscore", new Object[0]);
        }
    }

    private void scanHexExponentAndSuffix(int n) {
        if (this.reader.ch == 'p' || this.reader.ch == 'P') {
            this.reader.putChar(true);
            this.skipIllegalUnderscores();
            if (this.reader.ch == '+' || this.reader.ch == '-') {
                this.reader.putChar(true);
            }
            this.skipIllegalUnderscores();
            if (this.reader.digit(n, 10) >= 0) {
                this.scanDigits(n, 10);
                if (!hexFloatsWork) {
                    this.lexError(n, "unsupported.cross.fp.lit", new Object[0]);
                }
            } else {
                this.lexError(n, "malformed.fp.lit", new Object[0]);
            }
        } else {
            this.lexError(n, "malformed.fp.lit", new Object[0]);
        }
        if (this.reader.ch == 'f' || this.reader.ch == 'F') {
            this.reader.putChar(true);
            this.tk = Tokens.TokenKind.FLOATLITERAL;
            this.radix = 16;
        } else {
            if (this.reader.ch == 'd' || this.reader.ch == 'D') {
                this.reader.putChar(true);
            }
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
            this.radix = 16;
        }
    }

    private void scanFraction(int n) {
        this.skipIllegalUnderscores();
        if (this.reader.digit(n, 10) >= 0) {
            this.scanDigits(n, 10);
        }
        int n2 = this.reader.sp;
        if (this.reader.ch == 'e' || this.reader.ch == 'E') {
            this.reader.putChar(true);
            this.skipIllegalUnderscores();
            if (this.reader.ch == '+' || this.reader.ch == '-') {
                this.reader.putChar(true);
            }
            this.skipIllegalUnderscores();
            if (this.reader.digit(n, 10) >= 0) {
                this.scanDigits(n, 10);
                return;
            }
            this.lexError(n, "malformed.fp.lit", new Object[0]);
            this.reader.sp = n2;
        }
    }

    private void scanFractionAndSuffix(int n) {
        this.radix = 10;
        this.scanFraction(n);
        if (this.reader.ch == 'f' || this.reader.ch == 'F') {
            this.reader.putChar(true);
            this.tk = Tokens.TokenKind.FLOATLITERAL;
        } else {
            if (this.reader.ch == 'd' || this.reader.ch == 'D') {
                this.reader.putChar(true);
            }
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(int n, boolean bl) {
        this.radix = 16;
        Assert.check(this.reader.ch == '.');
        this.reader.putChar(true);
        this.skipIllegalUnderscores();
        if (this.reader.digit(n, 16) >= 0) {
            bl = true;
            this.scanDigits(n, 16);
        }
        if (!bl) {
            this.lexError(n, "invalid.hex.number", new Object[0]);
        } else {
            this.scanHexExponentAndSuffix(n);
        }
    }

    private void skipIllegalUnderscores() {
        if (this.reader.ch == '_') {
            this.lexError(this.reader.bp, "illegal.underscore", new Object[0]);
            while (this.reader.ch == '_') {
                this.reader.scanChar();
            }
        }
    }

    private void scanNumber(int n, int n2) {
        boolean bl;
        this.radix = n2;
        int n3 = n2 == 8 ? 10 : n2;
        int n4 = this.reader.digit(n, Math.max(10, n3));
        boolean bl2 = n4 >= 0;
        boolean bl3 = bl = n4 >= 0 && n4 < n3;
        if (bl2) {
            this.scanDigits(n, n3);
        }
        if (n2 == 16 && this.reader.ch == '.') {
            this.scanHexFractionAndSuffix(n, bl2);
        } else if (bl2 && n2 == 16 && (this.reader.ch == 'p' || this.reader.ch == 'P')) {
            this.scanHexExponentAndSuffix(n);
        } else if (n3 == 10 && this.reader.ch == '.') {
            this.reader.putChar(true);
            this.scanFractionAndSuffix(n);
        } else if (n3 == 10 && (this.reader.ch == 'e' || this.reader.ch == 'E' || this.reader.ch == 'f' || this.reader.ch == 'F' || this.reader.ch == 'd' || this.reader.ch == 'D')) {
            this.scanFractionAndSuffix(n);
        } else {
            if (!bl) {
                switch (n2) {
                    case 2: {
                        this.lexError(n, "invalid.binary.number", new Object[0]);
                        break;
                    }
                    case 16: {
                        this.lexError(n, "invalid.hex.number", new Object[0]);
                    }
                }
            }
            if (this.reader.ch == 'l' || this.reader.ch == 'L') {
                this.reader.scanChar();
                this.tk = Tokens.TokenKind.LONGLITERAL;
            } else {
                this.tk = Tokens.TokenKind.INTLITERAL;
            }
        }
    }

    private void scanIdent() {
        this.reader.putChar(true);
        block5: while (true) {
            switch (this.reader.ch) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u007f': {
                    this.reader.scanChar();
                    continue block5;
                }
                case '\u001a': {
                    if (this.reader.bp >= this.reader.buflen) {
                        this.name = this.reader.name();
                        this.tk = this.tokens.lookupKind(this.name);
                        return;
                    }
                    this.reader.scanChar();
                    continue block5;
                }
                default: {
                    boolean bl;
                    if (this.reader.ch < '\u0080') {
                        bl = false;
                    } else {
                        if (Character.isIdentifierIgnorable(this.reader.ch)) {
                            this.reader.scanChar();
                            continue block5;
                        }
                        int n = this.reader.peekSurrogates();
                        if (n >= 0) {
                            bl = Character.isJavaIdentifierPart(n);
                            if (bl) {
                                this.reader.putChar(true);
                            }
                        } else {
                            bl = Character.isJavaIdentifierPart(this.reader.ch);
                        }
                    }
                    if (bl) break;
                    this.name = this.reader.name();
                    this.tk = this.tokens.lookupKind(this.name);
                    return;
                }
            }
            this.reader.putChar(true);
        }
    }

    private boolean isSpecial(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.reader.putChar(false);
            Name name = this.reader.name();
            Tokens.TokenKind tokenKind = this.tokens.lookupKind(name);
            if (tokenKind == Tokens.TokenKind.IDENTIFIER) {
                --this.reader.sp;
                break;
            }
            this.tk = tokenKind;
            this.reader.scanChar();
        } while (this.isSpecial(this.reader.ch));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tokens.Token readToken() {
        List<Tokens.Comment> list;
        int n;
        int n2;
        block69: {
            this.reader.sp = 0;
            this.name = null;
            this.radix = 0;
            n2 = 0;
            n = 0;
            list = null;
            block28: while (true) {
                Tokens.Comment.CommentStyle commentStyle;
                int n3;
                n2 = this.reader.bp;
                switch (this.reader.ch) {
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        do {
                            this.reader.scanChar();
                        } while (this.reader.ch == ' ' || this.reader.ch == '\t' || this.reader.ch == '\f');
                        this.processWhiteSpace(n2, this.reader.bp);
                        continue block28;
                    }
                    case '\n': {
                        this.reader.scanChar();
                        this.processLineTerminator(n2, this.reader.bp);
                        continue block28;
                    }
                    case '\r': {
                        this.reader.scanChar();
                        if (this.reader.ch == '\n') {
                            this.reader.scanChar();
                        }
                        this.processLineTerminator(n2, this.reader.bp);
                        continue block28;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.scanIdent();
                        break block69;
                    }
                    case '0': {
                        this.reader.scanChar();
                        if (this.reader.ch == 'x' || this.reader.ch == 'X') {
                            this.reader.scanChar();
                            this.skipIllegalUnderscores();
                            this.scanNumber(n2, 16);
                            break block69;
                        }
                        if (this.reader.ch == 'b' || this.reader.ch == 'B') {
                            if (!this.allowBinaryLiterals) {
                                this.lexError(n2, "unsupported.binary.lit", this.source.name);
                                this.allowBinaryLiterals = true;
                            }
                            this.reader.scanChar();
                            this.skipIllegalUnderscores();
                            this.scanNumber(n2, 2);
                            break block69;
                        } else {
                            this.reader.putChar('0');
                            if (this.reader.ch == '_') {
                                n3 = this.reader.bp;
                                do {
                                    this.reader.scanChar();
                                } while (this.reader.ch == '_');
                                if (this.reader.digit(n2, 10) < 0) {
                                    this.lexError(n3, "illegal.underscore", new Object[0]);
                                }
                            }
                            this.scanNumber(n2, 8);
                        }
                        break block69;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(n2, 10);
                        break block69;
                    }
                    case '.': {
                        this.reader.scanChar();
                        if (this.reader.digit(n2, 10) >= 0) {
                            this.reader.putChar('.');
                            this.scanFractionAndSuffix(n2);
                            break block69;
                        }
                        if (this.reader.ch == '.') {
                            n3 = this.reader.bp;
                            this.reader.putChar('.');
                            this.reader.putChar('.', true);
                            if (this.reader.ch == '.') {
                                this.reader.scanChar();
                                this.reader.putChar('.');
                                this.tk = Tokens.TokenKind.ELLIPSIS;
                                break block69;
                            } else {
                                this.lexError(n3, "illegal.dot", new Object[0]);
                            }
                            break block69;
                        }
                        this.tk = Tokens.TokenKind.DOT;
                        break block69;
                    }
                    case ',': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.COMMA;
                        break block69;
                    }
                    case ';': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.SEMI;
                        break block69;
                    }
                    case '(': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LPAREN;
                        break block69;
                    }
                    case ')': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RPAREN;
                        break block69;
                    }
                    case '[': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LBRACKET;
                        break block69;
                    }
                    case ']': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RBRACKET;
                        break block69;
                    }
                    case '{': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LBRACE;
                        break block69;
                    }
                    case '}': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RBRACE;
                        break block69;
                    }
                    case '/': {
                        this.reader.scanChar();
                        if (this.reader.ch == '/') {
                            do {
                                this.reader.scanCommentChar();
                            } while (this.reader.ch != '\r' && this.reader.ch != '\n' && this.reader.bp < this.reader.buflen);
                            if (this.reader.bp >= this.reader.buflen) continue block28;
                            list = this.addComment(list, this.processComment(n2, this.reader.bp, Tokens.Comment.CommentStyle.LINE));
                            continue block28;
                        }
                        if (this.reader.ch == '*') {
                            n3 = 0;
                            this.reader.scanChar();
                            if (this.reader.ch == '*') {
                                commentStyle = Tokens.Comment.CommentStyle.JAVADOC;
                                this.reader.scanCommentChar();
                                if (this.reader.ch != '/') break;
                                n3 = 1;
                                break;
                            }
                            commentStyle = Tokens.Comment.CommentStyle.BLOCK;
                            break;
                        }
                        if (this.reader.ch == '=') {
                            this.tk = Tokens.TokenKind.SLASHEQ;
                            this.reader.scanChar();
                            break block69;
                        } else {
                            this.tk = Tokens.TokenKind.SLASH;
                        }
                        break block69;
                    }
                    case '\'': {
                        this.reader.scanChar();
                        if (this.reader.ch == '\'') {
                            this.lexError(n2, "empty.char.lit", new Object[0]);
                            this.reader.scanChar();
                            break block69;
                        }
                        if (this.reader.ch == '\r' || this.reader.ch == '\n') {
                            this.lexError(n2, "illegal.line.end.in.char.lit", new Object[0]);
                        }
                        this.scanLitChar(n2);
                        if (this.reader.ch == '\'') {
                            this.reader.scanChar();
                            this.tk = Tokens.TokenKind.CHARLITERAL;
                            break block69;
                        } else {
                            this.lexError(n2, "unclosed.char.lit", new Object[0]);
                        }
                        break block69;
                    }
                    case '\"': {
                        this.reader.scanChar();
                        while (this.reader.ch != '\"' && this.reader.ch != '\r' && this.reader.ch != '\n' && this.reader.bp < this.reader.buflen) {
                            this.scanLitChar(n2);
                        }
                        if (this.reader.ch == '\"') {
                            this.tk = Tokens.TokenKind.STRINGLITERAL;
                            this.reader.scanChar();
                            break block69;
                        } else {
                            this.lexError(n2, "unclosed.str.lit", new Object[0]);
                        }
                        break block69;
                    }
                    default: {
                        if (this.isSpecial(this.reader.ch)) {
                            this.scanOperator();
                            break block69;
                        }
                        int n4 = -1;
                        if (this.reader.ch < '\u0080') {
                            n3 = 0;
                        } else {
                            n4 = this.reader.peekSurrogates();
                            if (n4 >= 0) {
                                boolean bl = Character.isJavaIdentifierStart(n4);
                                n3 = bl ? 1 : 0;
                                if (bl) {
                                    this.reader.putChar(true);
                                }
                            } else {
                                n3 = Character.isJavaIdentifierStart(this.reader.ch) ? 1 : 0;
                            }
                        }
                        if (n3 != 0) {
                            this.scanIdent();
                            break block69;
                        }
                        if (this.reader.digit(n2, 10) >= 0) {
                            this.scanNumber(n2, 10);
                            break block69;
                        }
                        if (this.reader.bp == this.reader.buflen || this.reader.ch == '\u001a' && this.reader.bp + 1 == this.reader.buflen) {
                            this.tk = Tokens.TokenKind.EOF;
                            n2 = this.reader.buflen;
                            break block69;
                        } else {
                            String string;
                            if (n4 >= 0) {
                                char c = this.reader.ch;
                                this.reader.scanChar();
                                string = String.format("\\u%04x\\u%04x", c, (int)this.reader.ch);
                            } else {
                                string = ' ' < this.reader.ch && this.reader.ch < '\u007f' ? String.format("%s", Character.valueOf(this.reader.ch)) : String.format("\\u%04x", this.reader.ch);
                            }
                            this.lexError(n2, "illegal.char", string);
                            this.reader.scanChar();
                        }
                        break block69;
                    }
                }
                while (n3 == 0 && this.reader.bp < this.reader.buflen) {
                    if (this.reader.ch == '*') {
                        this.reader.scanChar();
                        if (this.reader.ch != '/') continue;
                        break;
                    }
                    this.reader.scanCommentChar();
                }
                if (this.reader.ch != '/') break;
                this.reader.scanChar();
                list = this.addComment(list, this.processComment(n2, this.reader.bp, commentStyle));
            }
            this.lexError(n2, "unclosed.comment", new Object[0]);
        }
        n = this.reader.bp;
        switch (this.tk.tag) {
            case DEFAULT: {
                return new Tokens.Token(this.tk, n2, n, list);
            }
            case NAMED: {
                return new Tokens.NamedToken(this.tk, n2, n, this.name, list);
            }
            case STRING: {
                return new Tokens.StringToken(this.tk, n2, n, this.reader.chars(), list);
            }
            case NUMERIC: {
                return new Tokens.NumericToken(this.tk, n2, n, this.reader.chars(), this.radix, list);
            }
        }
        throw new AssertionError();
    }

    List<Tokens.Comment> addComment(List<Tokens.Comment> list, Tokens.Comment comment) {
        return list == null ? List.of(comment) : list.prepend(comment);
    }

    public int errPos() {
        return this.errPos;
    }

    public void errPos(int n) {
        this.errPos = n;
    }

    protected Tokens.Comment processComment(int n, int n2, Tokens.Comment.CommentStyle commentStyle) {
        char[] cArray = this.reader.getRawCharacters(n, n2);
        return new BasicComment<UnicodeReader>(new UnicodeReader(this.fac, cArray, cArray.length), commentStyle);
    }

    protected void processWhiteSpace(int n, int n2) {
    }

    protected void processLineTerminator(int n, int n2) {
    }

    public Position.LineMap getLineMap() {
        return Position.makeLineMap(this.reader.getRawCharacters(), this.reader.buflen, false);
    }

    protected static class BasicComment<U extends UnicodeReader>
    implements Tokens.Comment {
        Tokens.Comment.CommentStyle cs;
        U comment_reader;
        protected boolean deprecatedFlag = false;
        protected boolean scanned = false;

        protected BasicComment(U u, Tokens.Comment.CommentStyle commentStyle) {
            this.comment_reader = u;
            this.cs = commentStyle;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public int getSourcePos(int n) {
            return -1;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.cs;
        }

        @Override
        public boolean isDeprecated() {
            if (!this.scanned && this.cs == Tokens.Comment.CommentStyle.JAVADOC) {
                this.scanDocComment();
            }
            return this.deprecatedFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scanDocComment() {
            try {
                boolean bl = false;
                ((UnicodeReader)this.comment_reader).bp += 3;
                ((UnicodeReader)this.comment_reader).ch = ((UnicodeReader)this.comment_reader).buf[((UnicodeReader)this.comment_reader).bp];
                block11: while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && (((UnicodeReader)this.comment_reader).ch == ' ' || ((UnicodeReader)this.comment_reader).ch == '\t' || ((UnicodeReader)this.comment_reader).ch == '\f')) {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && ((UnicodeReader)this.comment_reader).ch == '*') {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                        if (((UnicodeReader)this.comment_reader).ch != '/') continue;
                        return;
                    }
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && (((UnicodeReader)this.comment_reader).ch == ' ' || ((UnicodeReader)this.comment_reader).ch == '\t' || ((UnicodeReader)this.comment_reader).ch == '\f')) {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                    bl = false;
                    if (!this.deprecatedFlag) {
                        String string = "@deprecated";
                        int n = 0;
                        while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && ((UnicodeReader)this.comment_reader).ch == string.charAt(n)) {
                            ((UnicodeReader)this.comment_reader).scanCommentChar();
                            if (++n != string.length()) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (bl && ((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                        if (Character.isWhitespace(((UnicodeReader)this.comment_reader).ch)) {
                            this.deprecatedFlag = true;
                        } else if (((UnicodeReader)this.comment_reader).ch == '*') {
                            ((UnicodeReader)this.comment_reader).scanCommentChar();
                            if (((UnicodeReader)this.comment_reader).ch == '/') {
                                this.deprecatedFlag = true;
                                return;
                            }
                        }
                    }
                    block16: while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                        switch (((UnicodeReader)this.comment_reader).ch) {
                            case '*': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                if (((UnicodeReader)this.comment_reader).ch != '/') continue block16;
                                return;
                            }
                            case '\r': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                if (((UnicodeReader)this.comment_reader).ch != '\n') continue block11;
                            }
                            case '\n': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                continue block11;
                            }
                        }
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                }
                return;
            }
            finally {
                this.scanned = true;
            }
        }
    }
}

