/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.jvm.ClassFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.tools.JavaFileObject;

public class ModuleNameReader {
    private static final int INITIAL_BUFFER_SIZE = 65520;
    private byte[] buf = new byte[65520];
    private int bp;
    private int[] poolIdx;

    public String readModuleName(Path path) throws IOException, BadClassFile {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            String string = this.readModuleName(inputStream);
            return string;
        }
    }

    public String readModuleName(JavaFileObject javaFileObject) throws IOException, BadClassFile {
        try (InputStream inputStream = javaFileObject.openInputStream();){
            String string = this.readModuleName(inputStream);
            return string;
        }
    }

    public String readModuleName(InputStream inputStream) throws IOException, BadClassFile {
        this.bp = 0;
        this.buf = ModuleNameReader.readInputStream(this.buf, inputStream);
        int n = this.nextInt();
        if (n != -889275714) {
            throw new BadClassFile("illegal.start.of.class.file");
        }
        char c = this.nextChar();
        char c2 = this.nextChar();
        if (c2 < '5') {
            throw new BadClassFile("bad major version number for module: " + c2);
        }
        this.indexPool();
        char c3 = this.nextChar();
        if (c3 != '\u8000') {
            throw new BadClassFile("invalid access flags for module: 0x" + Integer.toHexString(c3));
        }
        char c4 = this.nextChar();
        this.checkZero(this.nextChar(), "super_class");
        this.checkZero(this.nextChar(), "interface_count");
        this.checkZero(this.nextChar(), "fields_count");
        this.checkZero(this.nextChar(), "methods_count");
        int n2 = this.nextChar();
        for (int i = 0; i < n2; ++i) {
            char c5 = this.nextChar();
            int n3 = this.nextInt();
            if (this.getUtf8Value(c5, false).equals("Module") && n3 > 2) {
                return this.getModuleName(this.nextChar());
            }
            this.bp += n3;
        }
        throw new BadClassFile("no Module attribute");
    }

    void checkZero(int n, String string) throws BadClassFile {
        if (n != 0) {
            throw new BadClassFile("invalid " + string + " for module: " + n);
        }
    }

    char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    void indexPool() throws BadClassFile {
        this.poolIdx = new int[this.nextChar()];
        int n = 1;
        block7: while (n < this.poolIdx.length) {
            this.poolIdx[n++] = this.bp;
            byte by = this.buf[this.bp++];
            switch (by) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.bp += 2;
                    continue block7;
                }
                case 15: {
                    this.bp += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.bp += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++n;
                    continue block7;
                }
            }
            throw new BadClassFile("malformed constant pool");
        }
    }

    String getUtf8Value(int n, boolean bl) throws BadClassFile {
        int n2 = this.poolIdx[n];
        if (this.buf[n2] == 1) {
            char c = this.getChar(n2 + 1);
            int n3 = n2 + 3;
            if (bl) {
                return new String(ClassFile.internalize(this.buf, n3, c));
            }
            return new String(this.buf, n3, (int)c);
        }
        throw new BadClassFile("bad name at index " + n);
    }

    String getModuleName(int n) throws BadClassFile {
        int n2 = this.poolIdx[n];
        if (this.buf[n2] == 19) {
            return this.getUtf8Value(this.getChar(n2 + 1), true);
        }
        throw new BadClassFile("bad module name at index " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readInputStream(byte[] byArray, InputStream inputStream) throws IOException {
        try {
            byArray = ModuleNameReader.ensureCapacity(byArray, inputStream.available());
            int n = inputStream.read(byArray);
            int n2 = 0;
            while (n != -1) {
                byArray = ModuleNameReader.ensureCapacity(byArray, n2 += n);
                n = inputStream.read(byArray, n2, byArray.length - n2);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] ensureCapacity(byte[] byArray, int n) {
        if (byArray.length <= n) {
            byte[] byArray2 = byArray;
            byArray = new byte[Integer.highestOneBit(n) << 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        return byArray;
    }

    public static class BadClassFile
    extends Exception {
        private static final long serialVersionUID = 0L;

        BadClassFile(String string) {
            super(string);
        }
    }
}

