/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.service;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.eyde.personalblog.service.PersonalBlogService;
import net.eyde.personalblog.service.SmtpAuthenticator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Email {
    private static Log log = LogFactory.getLog(Email.class);

    public static void sendMessage(String subject, String content, String toAddress, String mailHost) {
        log.debug((Object)"Sending email");
        Properties props = new Properties();
        try {
            props.put("mail.smtp.host", PersonalBlogService.getInstance().getPropertyManager().getProperty("mail.smtp.host"));
        }
        catch (Exception e) {
            log.error((Object)"Unable to get mail.host or weblog.pubEmail property");
            return;
        }
        SmtpAuthenticator x = new SmtpAuthenticator();
        Session sendMailSession = Session.getInstance((Properties)props, (Authenticator)x);
        sendMailSession.setDebug(true);
        MimeMessage newMessage = new MimeMessage(sendMailSession);
        try {
            newMessage.setFrom((Address)new InternetAddress(PersonalBlogService.getInstance().getPropertyManager().getProperty("weblog.email")));
            InternetAddress to = new InternetAddress(toAddress);
            newMessage.addRecipient(Message.RecipientType.TO, (Address)to);
            newMessage.setSubject(subject);
            newMessage.setText(content);
            Transport.send((Message)newMessage);
        }
        catch (Exception e) {
            log.error((Object)"problem sending email", (Throwable)e);
        }
    }
}

