// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -x c   -emit-llvm %s -o - -triple x86_64-linux-gnu | FileCheck %s
// RUN: %clang_cc1 -x c   -fsanitize=pointer-overflow -fno-sanitize-recover=pointer-overflow -emit-llvm %s -o - -triple x86_64-linux-gnu | FileCheck %s

// RUN: %clang_cc1 -x c++ -emit-llvm %s -o - -triple x86_64-linux-gnu | FileCheck %s
// RUN: %clang_cc1 -x c++ -fsanitize=pointer-overflow -fno-sanitize-recover=pointer-overflow -emit-llvm %s -o - -triple x86_64-linux-gnu | FileCheck %s

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

struct S {
  int x, y;
};

// CHECK-LABEL: @get_offset_of_y_naively(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i64 ptrtoint (ptr getelementptr ([[STRUCT_S:%.*]], ptr null, i32 0, i32 1) to i64)
//
uintptr_t get_offset_of_y_naively(void) {
  return ((uintptr_t)(&(((struct S *)0)->y)));
}

// CHECK-LABEL: @get_offset_of_y_via_builtin(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i64 4
//
uintptr_t get_offset_of_y_via_builtin(void) {
  return __builtin_offsetof(struct S, y);
}

#ifdef __cplusplus
}
#endif
