#![warn(unsafe_op_in_unsafe_fn)]
use pyo3_ffi::*;

// For benchmarking, all modules are public. The crate itself isn't distributed as a library,
// but is only meant to be accessed through its Python API.
pub mod common;
#[rustfmt::skip] // this module is autogenerated. No need to format it.
pub mod docstrings;
pub mod classes;
pub mod py;
pub mod pymodule;
pub mod tz;

use crate::pymodule::def::MODULE_DEF;

#[allow(clippy::missing_safety_doc)]
#[allow(non_snake_case)]
#[unsafe(no_mangle)]
#[cold]
pub unsafe extern "C" fn PyInit__whenever() -> *mut PyObject {
    unsafe { PyModuleDef_Init(&raw mut MODULE_DEF) }
}
