use std::sync::Arc;

use serde::{Deserialize, Serialize};
use strum::{EnumIter, EnumString, IntoStaticStr};

#[derive(
    Debug, PartialEq, Eq, Copy, Clone, EnumIter, EnumString, IntoStaticStr, Serialize, Deserialize,
)]
#[strum(serialize_all = "snake_case")]
pub enum IconName {
    Ai,
    AiAnthropic,
    AiBedrock,
    AiClaude,
    AiDeepSeek,
    AiEdit,
    AiGemini,
    AiGoogle,
    AiLmStudio,
    AiMistral,
    AiOllama,
    AiOpenAi,
    AiOpenAiCompat,
    AiOpenRouter,
    AiVZero,
    AiXAi,
    AiZed,
    ArrowCircle,
    ArrowDown,
    ArrowDown10,
    ArrowDownFromLine,
    ArrowDownRight,
    ArrowLeft,
    ArrowRight,
    ArrowRightLeft,
    ArrowUp,
    ArrowUpAlt,
    ArrowUpFromLine,
    ArrowUpRight,
    ArrowUpRightAlt,
    AudioOff,
    AudioOn,
    Backspace,
    Bell,
    BellDot,
    BellOff,
    BellRing,
    Binary,
    Blocks,
    BoltOutlined,
    BoltFilled,
    Book,
    BookCopy,
    BugOff,
    CaseSensitive,
    Chat,
    Check,
    CheckDouble,
    ChevronDown,
    /// This chevron indicates a popover menu.
    ChevronDownSmall,
    ChevronLeft,
    ChevronRight,
    ChevronUp,
    ChevronUpDown,
    Circle,
    CircleOff,
    CircleHelp,
    Close,
    Cloud,
    CloudDownload,
    Code,
    Cog,
    Command,
    Context,
    Control,
    Copilot,
    CopilotDisabled,
    CopilotError,
    CopilotInit,
    Copy,
    CountdownTimer,
    Crosshair,
    CursorIBeam,
    Dash,
    DatabaseZap,
    Debug,
    DebugBreakpoint,
    DebugContinue,
    DebugDisabledBreakpoint,
    DebugDisabledLogBreakpoint,
    DebugDetach,
    DebugIgnoreBreakpoints,
    DebugLogBreakpoint,
    DebugPause,
    DebugRestart,
    DebugStepBack,
    DebugStepInto,
    DebugStepOut,
    DebugStepOver,
    DebugStop,
    Delete,
    Diff,
    Disconnected,
    DocumentText,
    Download,
    EditorAtom,
    EditorCursor,
    EditorEmacs,
    EditorJetBrains,
    EditorSublime,
    EditorVsCode,
    Ellipsis,
    EllipsisVertical,
    Envelope,
    Equal,
    Eraser,
    Escape,
    Exit,
    ExpandDown,
    ExpandUp,
    ExpandVertical,
    ExternalLink,
    Eye,
    File,
    FileCode,
    FileCreate,
    FileDiff,
    FileDoc,
    FileGeneric,
    FileGit,
    FileLock,
    FileRust,
    FileSearch,
    FileText,
    FileToml,
    FileTree,
    Filter,
    Flame,
    Folder,
    FolderOpen,
    FolderX,
    Font,
    FontSize,
    FontWeight,
    ForwardArrow,
    Function,
    GenericClose,
    GenericMaximize,
    GenericMinimize,
    GenericRestore,
    GitBranch,
    GitBranchSmall,
    Github,
    Globe,
    Hammer,
    Hash,
    HistoryRerun,
    Image,
    Indicator,
    Info,
    InlayHint,
    Keyboard,
    Layout,
    Library,
    LightBulb,
    LineHeight,
    Link,
    ListCollapse,
    ListTodo,
    ListTree,
    ListX,
    LoadCircle,
    LocationEdit,
    LockOutlined,
    LspDebug,
    LspRestart,
    LspStop,
    MagnifyingGlass,
    MailOpen,
    Maximize,
    Menu,
    MenuAlt,
    Mic,
    MicMute,
    Minimize,
    Option,
    PageDown,
    PageUp,
    PanelLeft,
    PanelRight,
    Pencil,
    Person,
    PersonCircle,
    PhoneIncoming,
    Pin,
    PlayOutlined,
    PlayFilled,
    Plus,
    PocketKnife,
    Power,
    Public,
    PullRequest,
    Quote,
    RefreshTitle,
    Regex,
    ReplNeutral,
    Replace,
    ReplaceAll,
    ReplaceNext,
    ReplyArrowRight,
    Rerun,
    Return,
    RotateCcw,
    RotateCw,
    Route,
    Save,
    Scissors,
    Screen,
    ScrollText,
    SearchSelection,
    SelectAll,
    Send,
    Server,
    Settings,
    SettingsAlt,
    ShieldCheck,
    Shift,
    Slash,
    SlashSquare,
    Sliders,
    SlidersVertical,
    Snip,
    Space,
    Sparkle,
    SparkleAlt,
    SparkleFilled,
    Split,
    SplitAlt,
    SquareDot,
    SquareMinus,
    SquarePlus,
    Star,
    StarFilled,
    Stop,
    StopFilled,
    Supermaven,
    SupermavenDisabled,
    SupermavenError,
    SupermavenInit,
    SwatchBook,
    Tab,
    Terminal,
    TerminalAlt,
    TextSnippet,
    TextThread,
    Thread,
    ThreadFromSummary,
    ThumbsDown,
    ThumbsUp,
    TodoComplete,
    TodoPending,
    TodoProgress,
    ToolBulb,
    ToolCopy,
    ToolDeleteFile,
    ToolDiagnostics,
    ToolFolder,
    ToolHammer,
    ToolNotification,
    ToolPencil,
    ToolRead,
    ToolRegex,
    ToolSearch,
    ToolTerminal,
    ToolWeb,
    Trash,
    Triangle,
    TriangleRight,
    Undo,
    Unpin,
    Update,
    UserCheck,
    UserGroup,
    UserRoundPen,
    Visible,
    Wand,
    Warning,
    WholeWord,
    X,
    XCircle,
    ZedAssistant,
    ZedAssistantFilled,
    ZedBurnMode,
    ZedBurnModeOn,
    ZedMcpCustom,
    ZedMcpExtension,
    ZedPredict,
    ZedPredictDisabled,
    ZedPredictDown,
    ZedPredictError,
    ZedPredictUp,
    ZedXCopilot,
}

impl IconName {
    /// Returns the path to this icon.
    pub fn path(&self) -> Arc<str> {
        let file_stem: &'static str = self.into();
        format!("icons/{file_stem}.svg").into()
    }
}
