// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// Error thrown when rate limit is exceeded HTTP Status Code: 429 Too Many Requests Possible OAuth2ErrorCode values: - INVALID_REQUEST: Rate limiting, too many requests, abuse prevention Possible causes: - Too many token requests from the same client - Rate limiting based on client_id or IP address - Abuse prevention mechanisms triggered - Service protection against excessive token generation
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TooManyRequestsError {
    /// OAuth 2.0 error code indicating the specific type of error Will be INVALID_REQUEST for rate limiting scenarios
    pub error: crate::types::OAuth2ErrorCode,
    /// Detailed message about the rate limiting May include retry-after information or rate limit details
    pub message: ::std::string::String,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl TooManyRequestsError {
    /// OAuth 2.0 error code indicating the specific type of error Will be INVALID_REQUEST for rate limiting scenarios
    pub fn error(&self) -> &crate::types::OAuth2ErrorCode {
        &self.error
    }
}
impl TooManyRequestsError {
    /// Returns the error message.
    pub fn message(&self) -> &str {
        &self.message
    }
}
impl ::std::fmt::Display for TooManyRequestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "TooManyRequestsError")?;
        {
            ::std::write!(f, ": {}", &self.message)?;
        }
        Ok(())
    }
}
impl ::std::error::Error for TooManyRequestsError {}
impl ::aws_types::request_id::RequestId for crate::types::error::TooManyRequestsError {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for TooManyRequestsError {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl TooManyRequestsError {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsError`](crate::types::error::TooManyRequestsError).
    pub fn builder() -> crate::types::error::builders::TooManyRequestsErrorBuilder {
        crate::types::error::builders::TooManyRequestsErrorBuilder::default()
    }
}

/// A builder for [`TooManyRequestsError`](crate::types::error::TooManyRequestsError).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TooManyRequestsErrorBuilder {
    pub(crate) error: ::std::option::Option<crate::types::OAuth2ErrorCode>,
    pub(crate) message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl TooManyRequestsErrorBuilder {
    /// OAuth 2.0 error code indicating the specific type of error Will be INVALID_REQUEST for rate limiting scenarios
    /// This field is required.
    pub fn error(mut self, input: crate::types::OAuth2ErrorCode) -> Self {
        self.error = ::std::option::Option::Some(input);
        self
    }
    /// OAuth 2.0 error code indicating the specific type of error Will be INVALID_REQUEST for rate limiting scenarios
    pub fn set_error(mut self, input: ::std::option::Option<crate::types::OAuth2ErrorCode>) -> Self {
        self.error = input;
        self
    }
    /// OAuth 2.0 error code indicating the specific type of error Will be INVALID_REQUEST for rate limiting scenarios
    pub fn get_error(&self) -> &::std::option::Option<crate::types::OAuth2ErrorCode> {
        &self.error
    }
    /// Detailed message about the rate limiting May include retry-after information or rate limit details
    /// This field is required.
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    /// Detailed message about the rate limiting May include retry-after information or rate limit details
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    /// Detailed message about the rate limiting May include retry-after information or rate limit details
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`TooManyRequestsError`](crate::types::error::TooManyRequestsError).
    /// This method will fail if any of the following fields are not set:
    /// - [`error`](crate::types::error::builders::TooManyRequestsErrorBuilder::error)
    /// - [`message`](crate::types::error::builders::TooManyRequestsErrorBuilder::message)
    pub fn build(self) -> ::std::result::Result<crate::types::error::TooManyRequestsError, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::error::TooManyRequestsError {
            error: self.error.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "error",
                    "error was not specified but it is required when building TooManyRequestsError",
                )
            })?,
            message: self.message.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "message",
                    "message was not specified but it is required when building TooManyRequestsError",
                )
            })?,
            meta: self.meta.unwrap_or_default(),
        })
    }
}
