/* Generated by wayland-scanner 1.24.0 */

#ifndef COLOR_REPRESENTATION_V1_CLIENT_PROTOCOL_H
#define COLOR_REPRESENTATION_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @page page_color_representation_v1 The color_representation_v1 protocol
 * color representation protocol extension
 *
 * @section page_desc_color_representation_v1 Description
 *
 * This protocol extension delivers the metadata required to define alpha mode,
 * the color model, sub-sampling and quantization range used when interpreting
 * buffer contents. The main use case is defining how the YCbCr family of pixel
 * formats convert to RGB.
 *
 * Note that this protocol does not define the colorimetry of the resulting RGB
 * channels / tristimulus values. Without the help of other extensions the
 * resulting colorimetry is therefore implementation defined.
 *
 * If this extension is not used, the color representation used is compositor
 * implementation defined.
 *
 * Recommendation ITU-T H.273
 * "Coding-independent code points for video signal type identification"
 * shall be referred to as simply H.273 here.
 *
 * @section page_ifaces_color_representation_v1 Interfaces
 * - @subpage page_iface_wp_color_representation_manager_v1 - color
 * representation manager singleton
 * - @subpage page_iface_wp_color_representation_surface_v1 - color
 * representation extension to a surface
 * @section page_copyright_color_representation_v1 Copyright
 * <pre>
 *
 * Copyright 2022 Simon Ser
 * Copyright 2022 Red Hat, Inc.
 * Copyright 2022 Collabora, Ltd.
 * Copyright 2022-2025 Red Hat, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct wp_color_representation_manager_v1;
struct wp_color_representation_surface_v1;

#ifndef WP_COLOR_REPRESENTATION_MANAGER_V1_INTERFACE
#  define WP_COLOR_REPRESENTATION_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_color_representation_manager_v1
 * wp_color_representation_manager_v1
 * @section page_iface_wp_color_representation_manager_v1_desc Description
 *
 * A singleton global interface used for getting color representation
 * extensions for wl_surface. The extension interfaces allow setting the
 * color representation of surfaces.
 *
 * Compositors should never remove this global.
 * @section page_iface_wp_color_representation_manager_v1_api API
 * See @ref iface_wp_color_representation_manager_v1.
 */
/**
 * @defgroup iface_wp_color_representation_manager_v1 The
 * wp_color_representation_manager_v1 interface
 *
 * A singleton global interface used for getting color representation
 * extensions for wl_surface. The extension interfaces allow setting the
 * color representation of surfaces.
 *
 * Compositors should never remove this global.
 */
extern const struct wl_interface wp_color_representation_manager_v1_interface;
#endif
#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_INTERFACE
#  define WP_COLOR_REPRESENTATION_SURFACE_V1_INTERFACE
/**
 * @page page_iface_wp_color_representation_surface_v1
 * wp_color_representation_surface_v1
 * @section page_iface_wp_color_representation_surface_v1_desc Description
 *
 * A wp_color_representation_surface_v1 allows the client to set the color
 * representation metadata of a surface.
 *
 * By default, a surface does not have any color representation metadata set.
 * The reconstruction of R, G, B signals on such surfaces is compositor
 * implementation defined. The alpha mode is assumed to be
 * premultiplied_electrical when the alpha mode is unset.
 *
 * If the wl_surface associated with the wp_color_representation_surface_v1
 * is destroyed, the wp_color_representation_surface_v1 object becomes inert.
 * @section page_iface_wp_color_representation_surface_v1_api API
 * See @ref iface_wp_color_representation_surface_v1.
 */
/**
 * @defgroup iface_wp_color_representation_surface_v1 The
 * wp_color_representation_surface_v1 interface
 *
 * A wp_color_representation_surface_v1 allows the client to set the color
 * representation metadata of a surface.
 *
 * By default, a surface does not have any color representation metadata set.
 * The reconstruction of R, G, B signals on such surfaces is compositor
 * implementation defined. The alpha mode is assumed to be
 * premultiplied_electrical when the alpha mode is unset.
 *
 * If the wl_surface associated with the wp_color_representation_surface_v1
 * is destroyed, the wp_color_representation_surface_v1 object becomes inert.
 */
extern const struct wl_interface wp_color_representation_surface_v1_interface;
#endif

#ifndef WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM
#  define WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_representation_manager_v1
 * protocol errors
 */
enum wp_color_representation_manager_v1_error {
  /**
   * color representation surface exists already
   */
  WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_SURFACE_EXISTS = 1,
};
#endif /* WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM */

/**
 * @ingroup iface_wp_color_representation_manager_v1
 * @struct wp_color_representation_manager_v1_listener
 */
struct wp_color_representation_manager_v1_listener {
  /**
   * supported alpha modes
   *
   * When this object is created, it shall immediately send this
   * event once for each alpha mode the compositor supports.
   *
   * For the definition of the supported values, see the
   * wp_color_representation_surface_v1::alpha_mode enum.
   * @param alpha_mode supported alpha mode
   */
  void (*supported_alpha_mode)(void* data,
                               struct wp_color_representation_manager_v1*
                                   wp_color_representation_manager_v1,
                               uint32_t alpha_mode);
  /**
   * supported matrix coefficients and ranges
   *
   * When this object is created, it shall immediately send this
   * event once for each matrix coefficient and color range
   * combination the compositor supports.
   *
   * For the definition of the supported values, see the
   * wp_color_representation_surface_v1::coefficients and
   * wp_color_representation_surface_v1::range enums.
   * @param coefficients supported matrix coefficients
   * @param range full range flag
   */
  void (*supported_coefficients_and_ranges)(
      void* data,
      struct wp_color_representation_manager_v1*
          wp_color_representation_manager_v1,
      uint32_t coefficients, uint32_t range);
  /**
   * all features have been sent
   *
   * This event is sent when all supported features have been sent.
   */
  void (*done)(void* data, struct wp_color_representation_manager_v1*
                               wp_color_representation_manager_v1);
};

/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
static inline int wp_color_representation_manager_v1_add_listener(
    struct wp_color_representation_manager_v1*
        wp_color_representation_manager_v1,
    const struct wp_color_representation_manager_v1_listener* listener,
    void* data) {
  return wl_proxy_add_listener(
      (struct wl_proxy*)wp_color_representation_manager_v1,
      (void (**)(void))listener, data);
}

#define WP_COLOR_REPRESENTATION_MANAGER_V1_DESTROY 0
#define WP_COLOR_REPRESENTATION_MANAGER_V1_GET_SURFACE 1

/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_SUPPORTED_ALPHA_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_SUPPORTED_COEFFICIENTS_AND_RANGES_SINCE_VERSION \
  1
/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_GET_SURFACE_SINCE_VERSION 1

/** @ingroup iface_wp_color_representation_manager_v1 */
static inline void wp_color_representation_manager_v1_set_user_data(
    struct wp_color_representation_manager_v1*
        wp_color_representation_manager_v1,
    void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)wp_color_representation_manager_v1,
                         user_data);
}

/** @ingroup iface_wp_color_representation_manager_v1 */
static inline void* wp_color_representation_manager_v1_get_user_data(
    struct wp_color_representation_manager_v1*
        wp_color_representation_manager_v1) {
  return wl_proxy_get_user_data(
      (struct wl_proxy*)wp_color_representation_manager_v1);
}

static inline uint32_t wp_color_representation_manager_v1_get_version(
    struct wp_color_representation_manager_v1*
        wp_color_representation_manager_v1) {
  return wl_proxy_get_version(
      (struct wl_proxy*)wp_color_representation_manager_v1);
}

/**
 * @ingroup iface_wp_color_representation_manager_v1
 *
 * Destroy the wp_color_representation_manager_v1 object. This does not
 * affect any other objects in any way.
 */
static inline void wp_color_representation_manager_v1_destroy(
    struct wp_color_representation_manager_v1*
        wp_color_representation_manager_v1) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_representation_manager_v1,
      WP_COLOR_REPRESENTATION_MANAGER_V1_DESTROY, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_representation_manager_v1),
      WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_wp_color_representation_manager_v1
 *
 * If a wp_color_representation_surface_v1 object already exists for the
 * given wl_surface, the protocol error surface_exists is raised.
 *
 * This creates a new color wp_color_representation_surface_v1 object for
 * the given wl_surface.
 *
 * See the wp_color_representation_surface_v1 interface for more details.
 */
static inline struct wp_color_representation_surface_v1*
wp_color_representation_manager_v1_get_surface(
    struct wp_color_representation_manager_v1*
        wp_color_representation_manager_v1,
    struct wl_surface* surface) {
  struct wl_proxy* id;

  id = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_representation_manager_v1,
      WP_COLOR_REPRESENTATION_MANAGER_V1_GET_SURFACE,
      &wp_color_representation_surface_v1_interface,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_representation_manager_v1),
      0, NULL, surface);

  return (struct wp_color_representation_surface_v1*)id;
}

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM
#  define WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * protocol errors
 */
enum wp_color_representation_surface_v1_error {
  /**
   * unsupported alpha mode
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ALPHA_MODE = 1,
  /**
   * unsupported coefficients
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_COEFFICIENTS = 2,
  /**
   * the pixel format and a set value are incompatible
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_PIXEL_FORMAT = 3,
  /**
   * forbidden request on inert object
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_INERT = 4,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM
#  define WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * alpha mode
 *
 * Specifies how the alpha channel affects the color channels.
 */
enum wp_color_representation_surface_v1_alpha_mode {
  /**
   * premultiplied alpha in electrical values
   *
   * Electrical color channel values (after transfer function
   * encoding) are already multiplied with the alpha channel value.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_PREMULTIPLIED_ELECTRICAL = 0,
  /**
   * premultiplied alpha in optical values
   *
   * Optical color channel values (before transfer function
   * encoding) are already multiplied with the alpha channel value.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_PREMULTIPLIED_OPTICAL = 1,
  /**
   * straight alpha
   *
   * Alpha channel has not been pre-multiplied into color channels.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_STRAIGHT = 2,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM
#  define WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * named coefficients
 *
 * Named matrix coefficients used to encode well-known sets of
 * coefficients. H.273 is the authority, when it comes to the exact values
 * of coefficients and authoritative specifications, where an equivalent
 * code point exists.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * Descriptions do list the specifications for convenience.
 */
enum wp_color_representation_surface_v1_coefficients {
  /**
   * The identity matrix
   *
   * Coefficients as defined by - IEC 61966-2-1 sRGB - SMPTE ST
   * 428-1 (2019)
   *
   * Equivalent to H.273 MatrixCoefficients code point 0. Compatible
   * with pixel formats of the RGB family.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_IDENTITY = 1,
  /**
   * BT.709 matrix coefficients
   *
   * Coefficients as defined by - Rec. ITU-R BT.709-6 - Rec. ITU-R
   * BT.1361-0 conventional colour gamut system (historical) - Rec.
   * ITU-R BT.1361-0 conventional colour gamut system and extended
   * colour gamut system (historical) - IEC 61966-2-4 xvYCC709 -
   * SMPTE RP 177 (1993) Annex B
   *
   * Equivalent to H.273 MatrixCoefficients code point 1. Compatible
   * with pixel formats of the YCbCr family.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT709 = 2,
  /**
   * FCC matrix coefficients
   *
   * Coefficients as defined by - United States Federal
   * Communications Commission (2003) Title 47 Code of Federal
   * Regulations 73.682 (a) (20)
   *
   * Equivalent to H.273 MatrixCoefficients code point 4. Compatible
   * with pixel formats of the YCbCr family.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_FCC = 3,
  /**
   * BT.601-7 matrix coefficients
   *
   * Coefficients as defined by - Rec. ITU-R BT.470-6 System B, G
   * (historical) - Rec. ITU-R BT.601-7 625 - Rec. ITU-R BT.601-7 525
   * - Rec. ITU-R BT.1358-0 625 (historical) - Rec. ITU-R BT.1358-1
   * 525 or 625 (historical) - Rec. ITU-R BT.1700-0 625 PAL and 625
   * SECAM - Rec. ITU-R BT.1700-0 NTSC - IEC 61966-2-1 sYCC - IEC
   * 61966-2-4 xvYCC601 - SMPTE ST 170 (2004)
   *
   * Equivalent to H.273 MatrixCoefficients code point 5, 6.
   * Compatible with pixel formats of the YCbCr family.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT601 = 4,
  /**
   * SMPTE ST 240 matrix coefficients
   *
   * Coefficients as defined by - SMPTE ST 240 (1999)
   *
   * Equivalent to H.273 MatrixCoefficients code point 7. Compatible
   * with pixel formats of the YCbCr family.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_SMPTE240 = 5,
  /**
   * BT.2020 and BT.2100 YCbCr matrix coefficients
   *
   * Coefficients as defined by - Rec. ITU-R BT.2020-2
   * (non-constant luminance) - Rec. ITU-R BT.2100-2 Y′CbCr
   *
   * Equivalent to H.273 MatrixCoefficients code point 9. Compatible
   * with pixel formats of the YCbCr family.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT2020 = 6,
  /**
   * BT.2020 matrix coefficients for constant luminance
   *
   * Coefficients as defined by - Rec. ITU-R BT.2020-2 (constant
   * luminance)
   *
   * Equivalent to H.273 MatrixCoefficients code point 10. Compatible
   * with pixel formats of the YCbCr family.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT2020_CL = 7,
  /**
   * BT.2100 ICtCp matrix coefficients
   *
   * Coefficients as defined by - Rec. ITU-R BT.2100-2 ICTCP
   *
   * Equivalent to H.273 MatrixCoefficients code point 14. Compatible
   * with pixel formats of the YCbCr family.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ICTCP = 8,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM
#  define WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Color range values
 *
 * Possible color range values.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 */
enum wp_color_representation_surface_v1_range {
  /**
   * Full color range
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_FULL = 1,
  /**
   * Limited color range
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_LIMITED = 2,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM
#  define WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Chroma sample location for 4:2:0 YCbCr
 *
 * Chroma sample location as defined by H.273 Chroma420SampleLocType.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * The descriptions list the matching Vulkan VkChromaLocation combinations
 * for convenience.
 */
enum wp_color_representation_surface_v1_chroma_location {
  /**
   * Horizontal offset of 0, vertical offset of 0.5
   *
   * Corresponding to VkChromaLocations: - xChromaOffset:
   * VK_CHROMA_LOCATION_COSITED_EVEN - yChromaOffset:
   * VK_CHROMA_LOCATION_MIDPOINT
   *
   * Equivalent to H.273 Chroma420SampleLocType 0.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_0 = 1,
  /**
   * Horizontal offset of 0.5, vertical offset of 0.5
   *
   * Corresponding to VkChromaLocations: - xChromaOffset:
   * VK_CHROMA_LOCATION_MIDPOINT - yChromaOffset:
   * VK_CHROMA_LOCATION_MIDPOINT
   *
   * Equivalent to H.273 Chroma420SampleLocType 1.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_1 = 2,
  /**
   * Horizontal offset of 0, vertical offset of 0
   *
   * Corresponding to VkChromaLocations: - xChromaOffset:
   * VK_CHROMA_LOCATION_COSITED_EVEN - yChromaOffset:
   * VK_CHROMA_LOCATION_COSITED_EVEN
   *
   * Equivalent to H.273 Chroma420SampleLocType 2.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_2 = 3,
  /**
   * Horizontal offset of 0.5, vertical offset of 0
   *
   * Corresponding to VkChromaLocations: - xChromaOffset:
   * VK_CHROMA_LOCATION_MIDPOINT - yChromaOffset:
   * VK_CHROMA_LOCATION_COSITED_EVEN
   *
   * Equivalent to H.273 Chroma420SampleLocType 3.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_3 = 4,
  /**
   * Horizontal offset of 0, vertical offset of 1
   *
   * Equivalent to H.273 Chroma420SampleLocType 4.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_4 = 5,
  /**
   * Horizontal offset of 0.5, vertical offset of 1
   *
   * Equivalent to H.273 Chroma420SampleLocType 5.
   */
  WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_5 = 6,
};
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM */

#define WP_COLOR_REPRESENTATION_SURFACE_V1_DESTROY 0
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_ALPHA_MODE 1
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_COEFFICIENTS_AND_RANGE 2
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_CHROMA_LOCATION 3

/**
 * @ingroup iface_wp_color_representation_surface_v1
 */
#define WP_COLOR_REPRESENTATION_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_surface_v1
 */
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_ALPHA_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_surface_v1
 */
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_COEFFICIENTS_AND_RANGE_SINCE_VERSION \
  1
/**
 * @ingroup iface_wp_color_representation_surface_v1
 */
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_CHROMA_LOCATION_SINCE_VERSION 1

/** @ingroup iface_wp_color_representation_surface_v1 */
static inline void wp_color_representation_surface_v1_set_user_data(
    struct wp_color_representation_surface_v1*
        wp_color_representation_surface_v1,
    void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)wp_color_representation_surface_v1,
                         user_data);
}

/** @ingroup iface_wp_color_representation_surface_v1 */
static inline void* wp_color_representation_surface_v1_get_user_data(
    struct wp_color_representation_surface_v1*
        wp_color_representation_surface_v1) {
  return wl_proxy_get_user_data(
      (struct wl_proxy*)wp_color_representation_surface_v1);
}

static inline uint32_t wp_color_representation_surface_v1_get_version(
    struct wp_color_representation_surface_v1*
        wp_color_representation_surface_v1) {
  return wl_proxy_get_version(
      (struct wl_proxy*)wp_color_representation_surface_v1);
}

/**
 * @ingroup iface_wp_color_representation_surface_v1
 *
 * Destroy the wp_color_representation_surface_v1 object.
 *
 * Destroying this object unsets all the color representation metadata from
 * the surface. See the wp_color_representation_surface_v1 interface
 * description for how a compositor handles a surface without color
 * representation metadata. Unsetting is double-buffered state, see
 * wl_surface.commit.
 */
static inline void wp_color_representation_surface_v1_destroy(
    struct wp_color_representation_surface_v1*
        wp_color_representation_surface_v1) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_representation_surface_v1,
      WP_COLOR_REPRESENTATION_SURFACE_V1_DESTROY, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_representation_surface_v1),
      WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_wp_color_representation_surface_v1
 *
 * If this protocol object is inert, the protocol error inert is raised.
 *
 * Assuming an alpha channel exists, it is always linear. The alpha mode
 * determines whether and how the color channels include pre-multiplied
 * alpha. Using straight alpha might have performance benefits.
 *
 * Only alpha modes advertised by the compositor are allowed to be used as
 * argument for this request. The "alpha_mode" protocol error is raised
 * otherwise.
 *
 * Alpha mode is double buffered, see wl_surface.commit.
 */
static inline void wp_color_representation_surface_v1_set_alpha_mode(
    struct wp_color_representation_surface_v1*
        wp_color_representation_surface_v1,
    uint32_t alpha_mode) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_representation_surface_v1,
      WP_COLOR_REPRESENTATION_SURFACE_V1_SET_ALPHA_MODE, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_representation_surface_v1),
      0, alpha_mode);
}

/**
 * @ingroup iface_wp_color_representation_surface_v1
 *
 * If this protocol object is inert, the protocol error inert is raised.
 *
 * Set the matrix coefficients and video range which defines the formula
 * and the related constants used to derive red, green and blue signals.
 * Usually coefficients correspond to MatrixCoefficients code points in
 * H.273.
 *
 * Only combinations advertised by the compositor are allowed to be used as
 * argument for this request. The "coefficients" protocol error is raised
 * otherwise.
 *
 * A call to wl_surface.commit verifies that the pixel format and the
 * coefficients-range combination in the committed surface contents are
 * compatible, if contents exist. The "pixel_format" protocol error is
 * raised otherwise.
 *
 * A pixel format is compatible with the coefficients-range combination if
 * the related equations and conventions as defined in H.273 can produce
 * the color channels (RGB or YCbCr) of the pixel format.
 *
 * For the definition of the supported combination, see the
 * wp_color_representation_surface_v1::coefficients and
 * wp_color_representation_surface_v1::range enums.
 *
 * The coefficients-range combination is double-buffered, see
 * wl_surface.commit.
 */
static inline void
wp_color_representation_surface_v1_set_coefficients_and_range(
    struct wp_color_representation_surface_v1*
        wp_color_representation_surface_v1,
    uint32_t coefficients, uint32_t range) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_representation_surface_v1,
      WP_COLOR_REPRESENTATION_SURFACE_V1_SET_COEFFICIENTS_AND_RANGE, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_representation_surface_v1),
      0, coefficients, range);
}

/**
 * @ingroup iface_wp_color_representation_surface_v1
 *
 * If this protocol object is inert, the protocol error inert is raised.
 *
 * Set the chroma location type which defines the position of downsampled
 * chroma samples, corresponding to Chroma420SampleLocType code points in
 * H.273.
 *
 * A call to wl_surface.commit verifies that the pixel format and chroma
 * location type in the committed surface contents are compatible, if
 * contents exist. The "pixel_format" protocol error is raised otherwise.
 *
 * For the definition of the supported chroma location types, see the
 * wp_color_representation_surface_v1::chroma_location enum.
 *
 * The chroma location type is double-buffered, see wl_surface.commit.
 */
static inline void wp_color_representation_surface_v1_set_chroma_location(
    struct wp_color_representation_surface_v1*
        wp_color_representation_surface_v1,
    uint32_t chroma_location) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_representation_surface_v1,
      WP_COLOR_REPRESENTATION_SURFACE_V1_SET_CHROMA_LOCATION, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_representation_surface_v1),
      0, chroma_location);
}

#ifdef __cplusplus
}
#endif

#endif
