#!/bin/bash
# This script downloads and imports yaml-cpp
# It can be run on Linux, Mac OS X or Windows WSL.
# Actual integration into the build system is not done by this script.

set -xeuo pipefail

NAME=yaml-cpp
VERSION=0.6.3
BRANCH="${NAME}-${VERSION}"
GIT_REPO=https://github.com/jbeder/yaml-cpp.git

GIT_EXE=git
if grep -q Microsoft /proc/version; then
    GIT_EXE=git.exe
fi

DEST_DIR="$("${GIT_EXE}" rev-parse --show-toplevel)/src/third_party/${NAME}"
if grep -q Microsoft /proc/version; then
    DEST_DIR=$(wslpath -u "${DEST_DIR}")
fi

CLONE_DEST="${DEST_DIR}/${NAME}"
if grep -q Microsoft /proc/version; then
    CLONE_DEST=$(wslpath -m "${CLONE_DEST}")
fi

echo "dest: ${DEST_DIR}"

[[ -d ${CLONE_DEST} ]] && mv "${CLONE_DEST}" "${CLONE_DEST}.old"
"${GIT_EXE}" clone --branch="${BRANCH}" "${GIT_REPO}" "${CLONE_DEST}"


# Prune sources

echo "Prune tree"
rm -rf "${CLONE_DEST}/.git"
rm -rf "${CLONE_DEST}/test"
rm -rf "${CLONE_DEST}/util"
rm -rf "${CLONE_DEST}/docs"
rm -f "${CLONE_DEST}/BUILD.bazel"
rm -f "${CLONE_DEST}/WORKSPACE"
rm -f "${CLONE_DEST}/CMakeLists.txt"
rm -f "${CLONE_DEST}/"*.cmake*
rm -f "${CLONE_DEST}/yaml-cpp.pc.in"

[[ -d ${CLONE_DEST}.old ]] && rm -rf "${CLONE_DEST}.old"


# Generate the SConscript

( cat > "${DEST_DIR}/SConscript" ) << ___EOF___
# -*- mode: python; -*-
# NOTE: This file is auto-generated by "$(basename $0)" - DO NOT EDIT

Import("env")

# Create a new environment since this one doesn't build without errors when using -Wno-virtual-dtor
env = env.Clone()

try:
    env['CXXFLAGS'].remove('-Wnon-virtual-dtor')
    env['CCFLAGS'].remove('-Wall')
except ValueError:
    pass

env.InjectThirdParty('yaml', 'CPPDEFINES')

env.Library(
    target="yaml",
    source=[
        "yaml-cpp/src/binary.cpp",
        "yaml-cpp/src/convert.cpp",
        "yaml-cpp/src/directives.cpp",
        "yaml-cpp/src/emit.cpp",
        "yaml-cpp/src/emitfromevents.cpp",
        "yaml-cpp/src/emitter.cpp",
        "yaml-cpp/src/emitterstate.cpp",
        "yaml-cpp/src/emitterutils.cpp",
        "yaml-cpp/src/exceptions.cpp",
        "yaml-cpp/src/exp.cpp",
        "yaml-cpp/src/memory.cpp",
        "yaml-cpp/src/node.cpp",
        "yaml-cpp/src/node_data.cpp",
        "yaml-cpp/src/nodebuilder.cpp",
        "yaml-cpp/src/nodeevents.cpp",
        "yaml-cpp/src/null.cpp",
        "yaml-cpp/src/ostream_wrapper.cpp",
        "yaml-cpp/src/parse.cpp",
        "yaml-cpp/src/parser.cpp",
        "yaml-cpp/src/regex_yaml.cpp",
        "yaml-cpp/src/scanner.cpp",
        "yaml-cpp/src/scanscalar.cpp",
        "yaml-cpp/src/scantag.cpp",
        "yaml-cpp/src/scantoken.cpp",
        "yaml-cpp/src/simplekey.cpp",
        "yaml-cpp/src/singledocparser.cpp",
        "yaml-cpp/src/stream.cpp",
        "yaml-cpp/src/tag.cpp",
    ])
___EOF___

echo "Done"

