/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	example3iov1 "k8s.io/code-generator/examples/apiserver/apis/example3.io/v1"
	scheme "k8s.io/code-generator/examples/apiserver/clientset/versioned/scheme"
)

// TestTypesGetter has a method to return a TestTypeInterface.
// A group's client should implement this interface.
type TestTypesGetter interface {
	TestTypes(namespace string) TestTypeInterface
}

// TestTypeInterface has methods to work with TestType resources.
type TestTypeInterface interface {
	Create(ctx context.Context, testType *example3iov1.TestType, opts metav1.CreateOptions) (*example3iov1.TestType, error)
	Update(ctx context.Context, testType *example3iov1.TestType, opts metav1.UpdateOptions) (*example3iov1.TestType, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, testType *example3iov1.TestType, opts metav1.UpdateOptions) (*example3iov1.TestType, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*example3iov1.TestType, error)
	List(ctx context.Context, opts metav1.ListOptions) (*example3iov1.TestTypeList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *example3iov1.TestType, err error)
	TestTypeExpansion
}

// testTypes implements TestTypeInterface
type testTypes struct {
	*gentype.ClientWithList[*example3iov1.TestType, *example3iov1.TestTypeList]
}

// newTestTypes returns a TestTypes
func newTestTypes(c *ThirdExampleV1Client, namespace string) *testTypes {
	return &testTypes{
		gentype.NewClientWithList[*example3iov1.TestType, *example3iov1.TestTypeList](
			"testtypes",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *example3iov1.TestType { return &example3iov1.TestType{} },
			func() *example3iov1.TestTypeList { return &example3iov1.TestTypeList{} },
		),
	}
}
