//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1

import (
	unsafe "unsafe"

	appsv1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
	apps "k8s.io/kubernetes/pkg/apis/apps"
	core "k8s.io/kubernetes/pkg/apis/core"
	apiscorev1 "k8s.io/kubernetes/pkg/apis/core/v1"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*appsv1.ControllerRevision)(nil), (*apps.ControllerRevision)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ControllerRevision_To_apps_ControllerRevision(a.(*appsv1.ControllerRevision), b.(*apps.ControllerRevision), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.ControllerRevision)(nil), (*appsv1.ControllerRevision)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_ControllerRevision_To_v1_ControllerRevision(a.(*apps.ControllerRevision), b.(*appsv1.ControllerRevision), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.ControllerRevisionList)(nil), (*apps.ControllerRevisionList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ControllerRevisionList_To_apps_ControllerRevisionList(a.(*appsv1.ControllerRevisionList), b.(*apps.ControllerRevisionList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.ControllerRevisionList)(nil), (*appsv1.ControllerRevisionList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_ControllerRevisionList_To_v1_ControllerRevisionList(a.(*apps.ControllerRevisionList), b.(*appsv1.ControllerRevisionList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DaemonSetCondition)(nil), (*apps.DaemonSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetCondition_To_apps_DaemonSetCondition(a.(*appsv1.DaemonSetCondition), b.(*apps.DaemonSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.DaemonSetCondition)(nil), (*appsv1.DaemonSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DaemonSetCondition_To_v1_DaemonSetCondition(a.(*apps.DaemonSetCondition), b.(*appsv1.DaemonSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DaemonSetList)(nil), (*apps.DaemonSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetList_To_apps_DaemonSetList(a.(*appsv1.DaemonSetList), b.(*apps.DaemonSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.DaemonSetList)(nil), (*appsv1.DaemonSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DaemonSetList_To_v1_DaemonSetList(a.(*apps.DaemonSetList), b.(*appsv1.DaemonSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DaemonSetSpec)(nil), (*apps.DaemonSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetSpec_To_apps_DaemonSetSpec(a.(*appsv1.DaemonSetSpec), b.(*apps.DaemonSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DaemonSetStatus)(nil), (*apps.DaemonSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetStatus_To_apps_DaemonSetStatus(a.(*appsv1.DaemonSetStatus), b.(*apps.DaemonSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.DaemonSetStatus)(nil), (*appsv1.DaemonSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DaemonSetStatus_To_v1_DaemonSetStatus(a.(*apps.DaemonSetStatus), b.(*appsv1.DaemonSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DaemonSetUpdateStrategy)(nil), (*apps.DaemonSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetUpdateStrategy_To_apps_DaemonSetUpdateStrategy(a.(*appsv1.DaemonSetUpdateStrategy), b.(*apps.DaemonSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.DaemonSetUpdateStrategy)(nil), (*appsv1.DaemonSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(a.(*apps.DaemonSetUpdateStrategy), b.(*appsv1.DaemonSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DeploymentCondition)(nil), (*apps.DeploymentCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentCondition_To_apps_DeploymentCondition(a.(*appsv1.DeploymentCondition), b.(*apps.DeploymentCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.DeploymentCondition)(nil), (*appsv1.DeploymentCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DeploymentCondition_To_v1_DeploymentCondition(a.(*apps.DeploymentCondition), b.(*appsv1.DeploymentCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DeploymentList)(nil), (*apps.DeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentList_To_apps_DeploymentList(a.(*appsv1.DeploymentList), b.(*apps.DeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.DeploymentList)(nil), (*appsv1.DeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DeploymentList_To_v1_DeploymentList(a.(*apps.DeploymentList), b.(*appsv1.DeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DeploymentSpec)(nil), (*apps.DeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentSpec_To_apps_DeploymentSpec(a.(*appsv1.DeploymentSpec), b.(*apps.DeploymentSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DeploymentStatus)(nil), (*apps.DeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentStatus_To_apps_DeploymentStatus(a.(*appsv1.DeploymentStatus), b.(*apps.DeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.DeploymentStatus)(nil), (*appsv1.DeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DeploymentStatus_To_v1_DeploymentStatus(a.(*apps.DeploymentStatus), b.(*appsv1.DeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.DeploymentStrategy)(nil), (*apps.DeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(a.(*appsv1.DeploymentStrategy), b.(*apps.DeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.DeploymentStrategy)(nil), (*appsv1.DeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(a.(*apps.DeploymentStrategy), b.(*appsv1.DeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.ReplicaSet)(nil), (*apps.ReplicaSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSet_To_apps_ReplicaSet(a.(*appsv1.ReplicaSet), b.(*apps.ReplicaSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.ReplicaSet)(nil), (*appsv1.ReplicaSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_ReplicaSet_To_v1_ReplicaSet(a.(*apps.ReplicaSet), b.(*appsv1.ReplicaSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.ReplicaSetCondition)(nil), (*apps.ReplicaSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetCondition_To_apps_ReplicaSetCondition(a.(*appsv1.ReplicaSetCondition), b.(*apps.ReplicaSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.ReplicaSetCondition)(nil), (*appsv1.ReplicaSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_ReplicaSetCondition_To_v1_ReplicaSetCondition(a.(*apps.ReplicaSetCondition), b.(*appsv1.ReplicaSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.ReplicaSetList)(nil), (*apps.ReplicaSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetList_To_apps_ReplicaSetList(a.(*appsv1.ReplicaSetList), b.(*apps.ReplicaSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.ReplicaSetList)(nil), (*appsv1.ReplicaSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_ReplicaSetList_To_v1_ReplicaSetList(a.(*apps.ReplicaSetList), b.(*appsv1.ReplicaSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.ReplicaSetSpec)(nil), (*apps.ReplicaSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetSpec_To_apps_ReplicaSetSpec(a.(*appsv1.ReplicaSetSpec), b.(*apps.ReplicaSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.ReplicaSetSpec)(nil), (*appsv1.ReplicaSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_ReplicaSetSpec_To_v1_ReplicaSetSpec(a.(*apps.ReplicaSetSpec), b.(*appsv1.ReplicaSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.ReplicaSetStatus)(nil), (*apps.ReplicaSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetStatus_To_apps_ReplicaSetStatus(a.(*appsv1.ReplicaSetStatus), b.(*apps.ReplicaSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.ReplicaSetStatus)(nil), (*appsv1.ReplicaSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_ReplicaSetStatus_To_v1_ReplicaSetStatus(a.(*apps.ReplicaSetStatus), b.(*appsv1.ReplicaSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.RollingUpdateDaemonSet)(nil), (*apps.RollingUpdateDaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_RollingUpdateDaemonSet_To_apps_RollingUpdateDaemonSet(a.(*appsv1.RollingUpdateDaemonSet), b.(*apps.RollingUpdateDaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.RollingUpdateDaemonSet)(nil), (*appsv1.RollingUpdateDaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(a.(*apps.RollingUpdateDaemonSet), b.(*appsv1.RollingUpdateDaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.RollingUpdateDeployment)(nil), (*apps.RollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_RollingUpdateDeployment_To_apps_RollingUpdateDeployment(a.(*appsv1.RollingUpdateDeployment), b.(*apps.RollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.RollingUpdateDeployment)(nil), (*appsv1.RollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(a.(*apps.RollingUpdateDeployment), b.(*appsv1.RollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.RollingUpdateStatefulSetStrategy)(nil), (*apps.RollingUpdateStatefulSetStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_RollingUpdateStatefulSetStrategy_To_apps_RollingUpdateStatefulSetStrategy(a.(*appsv1.RollingUpdateStatefulSetStrategy), b.(*apps.RollingUpdateStatefulSetStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.RollingUpdateStatefulSetStrategy)(nil), (*appsv1.RollingUpdateStatefulSetStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(a.(*apps.RollingUpdateStatefulSetStrategy), b.(*appsv1.RollingUpdateStatefulSetStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.StatefulSet)(nil), (*apps.StatefulSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSet_To_apps_StatefulSet(a.(*appsv1.StatefulSet), b.(*apps.StatefulSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.StatefulSet)(nil), (*appsv1.StatefulSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_StatefulSet_To_v1_StatefulSet(a.(*apps.StatefulSet), b.(*appsv1.StatefulSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.StatefulSetCondition)(nil), (*apps.StatefulSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetCondition_To_apps_StatefulSetCondition(a.(*appsv1.StatefulSetCondition), b.(*apps.StatefulSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.StatefulSetCondition)(nil), (*appsv1.StatefulSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_StatefulSetCondition_To_v1_StatefulSetCondition(a.(*apps.StatefulSetCondition), b.(*appsv1.StatefulSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.StatefulSetList)(nil), (*apps.StatefulSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetList_To_apps_StatefulSetList(a.(*appsv1.StatefulSetList), b.(*apps.StatefulSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.StatefulSetList)(nil), (*appsv1.StatefulSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_StatefulSetList_To_v1_StatefulSetList(a.(*apps.StatefulSetList), b.(*appsv1.StatefulSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.StatefulSetOrdinals)(nil), (*apps.StatefulSetOrdinals)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetOrdinals_To_apps_StatefulSetOrdinals(a.(*appsv1.StatefulSetOrdinals), b.(*apps.StatefulSetOrdinals), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.StatefulSetOrdinals)(nil), (*appsv1.StatefulSetOrdinals)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_StatefulSetOrdinals_To_v1_StatefulSetOrdinals(a.(*apps.StatefulSetOrdinals), b.(*appsv1.StatefulSetOrdinals), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy)(nil), (*apps.StatefulSetPersistentVolumeClaimRetentionPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetPersistentVolumeClaimRetentionPolicy_To_apps_StatefulSetPersistentVolumeClaimRetentionPolicy(a.(*appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy), b.(*apps.StatefulSetPersistentVolumeClaimRetentionPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.StatefulSetPersistentVolumeClaimRetentionPolicy)(nil), (*appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_StatefulSetPersistentVolumeClaimRetentionPolicy_To_v1_StatefulSetPersistentVolumeClaimRetentionPolicy(a.(*apps.StatefulSetPersistentVolumeClaimRetentionPolicy), b.(*appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.StatefulSetStatus)(nil), (*apps.StatefulSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetStatus_To_apps_StatefulSetStatus(a.(*appsv1.StatefulSetStatus), b.(*apps.StatefulSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.StatefulSetStatus)(nil), (*appsv1.StatefulSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_StatefulSetStatus_To_v1_StatefulSetStatus(a.(*apps.StatefulSetStatus), b.(*appsv1.StatefulSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*appsv1.StatefulSetUpdateStrategy)(nil), (*apps.StatefulSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetUpdateStrategy_To_apps_StatefulSetUpdateStrategy(a.(*appsv1.StatefulSetUpdateStrategy), b.(*apps.StatefulSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*apps.StatefulSetUpdateStrategy)(nil), (*appsv1.StatefulSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(a.(*apps.StatefulSetUpdateStrategy), b.(*appsv1.StatefulSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*apps.DaemonSetSpec)(nil), (*appsv1.DaemonSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DaemonSetSpec_To_v1_DaemonSetSpec(a.(*apps.DaemonSetSpec), b.(*appsv1.DaemonSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*apps.DaemonSet)(nil), (*appsv1.DaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DaemonSet_To_v1_DaemonSet(a.(*apps.DaemonSet), b.(*appsv1.DaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*apps.DeploymentSpec)(nil), (*appsv1.DeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_DeploymentSpec_To_v1_DeploymentSpec(a.(*apps.DeploymentSpec), b.(*appsv1.DeploymentSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*apps.Deployment)(nil), (*appsv1.Deployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_Deployment_To_v1_Deployment(a.(*apps.Deployment), b.(*appsv1.Deployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*apps.StatefulSetSpec)(nil), (*appsv1.StatefulSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_apps_StatefulSetSpec_To_v1_StatefulSetSpec(a.(*apps.StatefulSetSpec), b.(*appsv1.StatefulSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*appsv1.DaemonSet)(nil), (*apps.DaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSet_To_apps_DaemonSet(a.(*appsv1.DaemonSet), b.(*apps.DaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*appsv1.Deployment)(nil), (*apps.Deployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Deployment_To_apps_Deployment(a.(*appsv1.Deployment), b.(*apps.Deployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*appsv1.StatefulSetSpec)(nil), (*apps.StatefulSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_StatefulSetSpec_To_apps_StatefulSetSpec(a.(*appsv1.StatefulSetSpec), b.(*apps.StatefulSetSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_ControllerRevision_To_apps_ControllerRevision(in *appsv1.ControllerRevision, out *apps.ControllerRevision, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = in.Data
	out.Revision = in.Revision
	return nil
}

// Convert_v1_ControllerRevision_To_apps_ControllerRevision is an autogenerated conversion function.
func Convert_v1_ControllerRevision_To_apps_ControllerRevision(in *appsv1.ControllerRevision, out *apps.ControllerRevision, s conversion.Scope) error {
	return autoConvert_v1_ControllerRevision_To_apps_ControllerRevision(in, out, s)
}

func autoConvert_apps_ControllerRevision_To_v1_ControllerRevision(in *apps.ControllerRevision, out *appsv1.ControllerRevision, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = in.Data
	out.Revision = in.Revision
	return nil
}

// Convert_apps_ControllerRevision_To_v1_ControllerRevision is an autogenerated conversion function.
func Convert_apps_ControllerRevision_To_v1_ControllerRevision(in *apps.ControllerRevision, out *appsv1.ControllerRevision, s conversion.Scope) error {
	return autoConvert_apps_ControllerRevision_To_v1_ControllerRevision(in, out, s)
}

func autoConvert_v1_ControllerRevisionList_To_apps_ControllerRevisionList(in *appsv1.ControllerRevisionList, out *apps.ControllerRevisionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]apps.ControllerRevision)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ControllerRevisionList_To_apps_ControllerRevisionList is an autogenerated conversion function.
func Convert_v1_ControllerRevisionList_To_apps_ControllerRevisionList(in *appsv1.ControllerRevisionList, out *apps.ControllerRevisionList, s conversion.Scope) error {
	return autoConvert_v1_ControllerRevisionList_To_apps_ControllerRevisionList(in, out, s)
}

func autoConvert_apps_ControllerRevisionList_To_v1_ControllerRevisionList(in *apps.ControllerRevisionList, out *appsv1.ControllerRevisionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]appsv1.ControllerRevision)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_apps_ControllerRevisionList_To_v1_ControllerRevisionList is an autogenerated conversion function.
func Convert_apps_ControllerRevisionList_To_v1_ControllerRevisionList(in *apps.ControllerRevisionList, out *appsv1.ControllerRevisionList, s conversion.Scope) error {
	return autoConvert_apps_ControllerRevisionList_To_v1_ControllerRevisionList(in, out, s)
}

func autoConvert_v1_DaemonSet_To_apps_DaemonSet(in *appsv1.DaemonSet, out *apps.DaemonSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_DaemonSetSpec_To_apps_DaemonSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_DaemonSetStatus_To_apps_DaemonSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_apps_DaemonSet_To_v1_DaemonSet(in *apps.DaemonSet, out *appsv1.DaemonSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_apps_DaemonSetSpec_To_v1_DaemonSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_apps_DaemonSetStatus_To_v1_DaemonSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_DaemonSetCondition_To_apps_DaemonSetCondition(in *appsv1.DaemonSetCondition, out *apps.DaemonSetCondition, s conversion.Scope) error {
	out.Type = apps.DaemonSetConditionType(in.Type)
	out.Status = core.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_DaemonSetCondition_To_apps_DaemonSetCondition is an autogenerated conversion function.
func Convert_v1_DaemonSetCondition_To_apps_DaemonSetCondition(in *appsv1.DaemonSetCondition, out *apps.DaemonSetCondition, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetCondition_To_apps_DaemonSetCondition(in, out, s)
}

func autoConvert_apps_DaemonSetCondition_To_v1_DaemonSetCondition(in *apps.DaemonSetCondition, out *appsv1.DaemonSetCondition, s conversion.Scope) error {
	out.Type = appsv1.DaemonSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_apps_DaemonSetCondition_To_v1_DaemonSetCondition is an autogenerated conversion function.
func Convert_apps_DaemonSetCondition_To_v1_DaemonSetCondition(in *apps.DaemonSetCondition, out *appsv1.DaemonSetCondition, s conversion.Scope) error {
	return autoConvert_apps_DaemonSetCondition_To_v1_DaemonSetCondition(in, out, s)
}

func autoConvert_v1_DaemonSetList_To_apps_DaemonSetList(in *appsv1.DaemonSetList, out *apps.DaemonSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]apps.DaemonSet, len(*in))
		for i := range *in {
			if err := Convert_v1_DaemonSet_To_apps_DaemonSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_DaemonSetList_To_apps_DaemonSetList is an autogenerated conversion function.
func Convert_v1_DaemonSetList_To_apps_DaemonSetList(in *appsv1.DaemonSetList, out *apps.DaemonSetList, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetList_To_apps_DaemonSetList(in, out, s)
}

func autoConvert_apps_DaemonSetList_To_v1_DaemonSetList(in *apps.DaemonSetList, out *appsv1.DaemonSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]appsv1.DaemonSet, len(*in))
		for i := range *in {
			if err := Convert_apps_DaemonSet_To_v1_DaemonSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_apps_DaemonSetList_To_v1_DaemonSetList is an autogenerated conversion function.
func Convert_apps_DaemonSetList_To_v1_DaemonSetList(in *apps.DaemonSetList, out *appsv1.DaemonSetList, s conversion.Scope) error {
	return autoConvert_apps_DaemonSetList_To_v1_DaemonSetList(in, out, s)
}

func autoConvert_v1_DaemonSetSpec_To_apps_DaemonSetSpec(in *appsv1.DaemonSetSpec, out *apps.DaemonSetSpec, s conversion.Scope) error {
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := apiscorev1.Convert_v1_PodTemplateSpec_To_core_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	if err := Convert_v1_DaemonSetUpdateStrategy_To_apps_DaemonSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	return nil
}

// Convert_v1_DaemonSetSpec_To_apps_DaemonSetSpec is an autogenerated conversion function.
func Convert_v1_DaemonSetSpec_To_apps_DaemonSetSpec(in *appsv1.DaemonSetSpec, out *apps.DaemonSetSpec, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetSpec_To_apps_DaemonSetSpec(in, out, s)
}

func autoConvert_apps_DaemonSetSpec_To_v1_DaemonSetSpec(in *apps.DaemonSetSpec, out *appsv1.DaemonSetSpec, s conversion.Scope) error {
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := apiscorev1.Convert_core_PodTemplateSpec_To_v1_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	if err := Convert_apps_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	// WARNING: in.TemplateGeneration requires manual conversion: does not exist in peer-type
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	return nil
}

func autoConvert_v1_DaemonSetStatus_To_apps_DaemonSetStatus(in *appsv1.DaemonSetStatus, out *apps.DaemonSetStatus, s conversion.Scope) error {
	out.CurrentNumberScheduled = in.CurrentNumberScheduled
	out.NumberMisscheduled = in.NumberMisscheduled
	out.DesiredNumberScheduled = in.DesiredNumberScheduled
	out.NumberReady = in.NumberReady
	out.ObservedGeneration = in.ObservedGeneration
	out.UpdatedNumberScheduled = in.UpdatedNumberScheduled
	out.NumberAvailable = in.NumberAvailable
	out.NumberUnavailable = in.NumberUnavailable
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]apps.DaemonSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_DaemonSetStatus_To_apps_DaemonSetStatus is an autogenerated conversion function.
func Convert_v1_DaemonSetStatus_To_apps_DaemonSetStatus(in *appsv1.DaemonSetStatus, out *apps.DaemonSetStatus, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetStatus_To_apps_DaemonSetStatus(in, out, s)
}

func autoConvert_apps_DaemonSetStatus_To_v1_DaemonSetStatus(in *apps.DaemonSetStatus, out *appsv1.DaemonSetStatus, s conversion.Scope) error {
	out.CurrentNumberScheduled = in.CurrentNumberScheduled
	out.NumberMisscheduled = in.NumberMisscheduled
	out.DesiredNumberScheduled = in.DesiredNumberScheduled
	out.NumberReady = in.NumberReady
	out.ObservedGeneration = in.ObservedGeneration
	out.UpdatedNumberScheduled = in.UpdatedNumberScheduled
	out.NumberAvailable = in.NumberAvailable
	out.NumberUnavailable = in.NumberUnavailable
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]appsv1.DaemonSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_apps_DaemonSetStatus_To_v1_DaemonSetStatus is an autogenerated conversion function.
func Convert_apps_DaemonSetStatus_To_v1_DaemonSetStatus(in *apps.DaemonSetStatus, out *appsv1.DaemonSetStatus, s conversion.Scope) error {
	return autoConvert_apps_DaemonSetStatus_To_v1_DaemonSetStatus(in, out, s)
}

func autoConvert_v1_DaemonSetUpdateStrategy_To_apps_DaemonSetUpdateStrategy(in *appsv1.DaemonSetUpdateStrategy, out *apps.DaemonSetUpdateStrategy, s conversion.Scope) error {
	out.Type = apps.DaemonSetUpdateStrategyType(in.Type)
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(apps.RollingUpdateDaemonSet)
		if err := Convert_v1_RollingUpdateDaemonSet_To_apps_RollingUpdateDaemonSet(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingUpdate = nil
	}
	return nil
}

// Convert_v1_DaemonSetUpdateStrategy_To_apps_DaemonSetUpdateStrategy is an autogenerated conversion function.
func Convert_v1_DaemonSetUpdateStrategy_To_apps_DaemonSetUpdateStrategy(in *appsv1.DaemonSetUpdateStrategy, out *apps.DaemonSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetUpdateStrategy_To_apps_DaemonSetUpdateStrategy(in, out, s)
}

func autoConvert_apps_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in *apps.DaemonSetUpdateStrategy, out *appsv1.DaemonSetUpdateStrategy, s conversion.Scope) error {
	out.Type = appsv1.DaemonSetUpdateStrategyType(in.Type)
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateDaemonSet)
		if err := Convert_apps_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingUpdate = nil
	}
	return nil
}

// Convert_apps_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy is an autogenerated conversion function.
func Convert_apps_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in *apps.DaemonSetUpdateStrategy, out *appsv1.DaemonSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_apps_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in, out, s)
}

func autoConvert_v1_Deployment_To_apps_Deployment(in *appsv1.Deployment, out *apps.Deployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_DeploymentSpec_To_apps_DeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_DeploymentStatus_To_apps_DeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_apps_Deployment_To_v1_Deployment(in *apps.Deployment, out *appsv1.Deployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_apps_DeploymentSpec_To_v1_DeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_apps_DeploymentStatus_To_v1_DeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_DeploymentCondition_To_apps_DeploymentCondition(in *appsv1.DeploymentCondition, out *apps.DeploymentCondition, s conversion.Scope) error {
	out.Type = apps.DeploymentConditionType(in.Type)
	out.Status = core.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_DeploymentCondition_To_apps_DeploymentCondition is an autogenerated conversion function.
func Convert_v1_DeploymentCondition_To_apps_DeploymentCondition(in *appsv1.DeploymentCondition, out *apps.DeploymentCondition, s conversion.Scope) error {
	return autoConvert_v1_DeploymentCondition_To_apps_DeploymentCondition(in, out, s)
}

func autoConvert_apps_DeploymentCondition_To_v1_DeploymentCondition(in *apps.DeploymentCondition, out *appsv1.DeploymentCondition, s conversion.Scope) error {
	out.Type = appsv1.DeploymentConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_apps_DeploymentCondition_To_v1_DeploymentCondition is an autogenerated conversion function.
func Convert_apps_DeploymentCondition_To_v1_DeploymentCondition(in *apps.DeploymentCondition, out *appsv1.DeploymentCondition, s conversion.Scope) error {
	return autoConvert_apps_DeploymentCondition_To_v1_DeploymentCondition(in, out, s)
}

func autoConvert_v1_DeploymentList_To_apps_DeploymentList(in *appsv1.DeploymentList, out *apps.DeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]apps.Deployment, len(*in))
		for i := range *in {
			if err := Convert_v1_Deployment_To_apps_Deployment(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_DeploymentList_To_apps_DeploymentList is an autogenerated conversion function.
func Convert_v1_DeploymentList_To_apps_DeploymentList(in *appsv1.DeploymentList, out *apps.DeploymentList, s conversion.Scope) error {
	return autoConvert_v1_DeploymentList_To_apps_DeploymentList(in, out, s)
}

func autoConvert_apps_DeploymentList_To_v1_DeploymentList(in *apps.DeploymentList, out *appsv1.DeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]appsv1.Deployment, len(*in))
		for i := range *in {
			if err := Convert_apps_Deployment_To_v1_Deployment(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_apps_DeploymentList_To_v1_DeploymentList is an autogenerated conversion function.
func Convert_apps_DeploymentList_To_v1_DeploymentList(in *apps.DeploymentList, out *appsv1.DeploymentList, s conversion.Scope) error {
	return autoConvert_apps_DeploymentList_To_v1_DeploymentList(in, out, s)
}

func autoConvert_v1_DeploymentSpec_To_apps_DeploymentSpec(in *appsv1.DeploymentSpec, out *apps.DeploymentSpec, s conversion.Scope) error {
	if err := metav1.Convert_Pointer_int32_To_int32(&in.Replicas, &out.Replicas, s); err != nil {
		return err
	}
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := apiscorev1.Convert_v1_PodTemplateSpec_To_core_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	if err := Convert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

// Convert_v1_DeploymentSpec_To_apps_DeploymentSpec is an autogenerated conversion function.
func Convert_v1_DeploymentSpec_To_apps_DeploymentSpec(in *appsv1.DeploymentSpec, out *apps.DeploymentSpec, s conversion.Scope) error {
	return autoConvert_v1_DeploymentSpec_To_apps_DeploymentSpec(in, out, s)
}

func autoConvert_apps_DeploymentSpec_To_v1_DeploymentSpec(in *apps.DeploymentSpec, out *appsv1.DeploymentSpec, s conversion.Scope) error {
	if err := metav1.Convert_int32_To_Pointer_int32(&in.Replicas, &out.Replicas, s); err != nil {
		return err
	}
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := apiscorev1.Convert_core_PodTemplateSpec_To_v1_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	if err := Convert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	// WARNING: in.RollbackTo requires manual conversion: does not exist in peer-type
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

func autoConvert_v1_DeploymentStatus_To_apps_DeploymentStatus(in *appsv1.DeploymentStatus, out *apps.DeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Conditions = *(*[]apps.DeploymentCondition)(unsafe.Pointer(&in.Conditions))
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	return nil
}

// Convert_v1_DeploymentStatus_To_apps_DeploymentStatus is an autogenerated conversion function.
func Convert_v1_DeploymentStatus_To_apps_DeploymentStatus(in *appsv1.DeploymentStatus, out *apps.DeploymentStatus, s conversion.Scope) error {
	return autoConvert_v1_DeploymentStatus_To_apps_DeploymentStatus(in, out, s)
}

func autoConvert_apps_DeploymentStatus_To_v1_DeploymentStatus(in *apps.DeploymentStatus, out *appsv1.DeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Conditions = *(*[]appsv1.DeploymentCondition)(unsafe.Pointer(&in.Conditions))
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	return nil
}

// Convert_apps_DeploymentStatus_To_v1_DeploymentStatus is an autogenerated conversion function.
func Convert_apps_DeploymentStatus_To_v1_DeploymentStatus(in *apps.DeploymentStatus, out *appsv1.DeploymentStatus, s conversion.Scope) error {
	return autoConvert_apps_DeploymentStatus_To_v1_DeploymentStatus(in, out, s)
}

func autoConvert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(in *appsv1.DeploymentStrategy, out *apps.DeploymentStrategy, s conversion.Scope) error {
	out.Type = apps.DeploymentStrategyType(in.Type)
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(apps.RollingUpdateDeployment)
		if err := Convert_v1_RollingUpdateDeployment_To_apps_RollingUpdateDeployment(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingUpdate = nil
	}
	return nil
}

// Convert_v1_DeploymentStrategy_To_apps_DeploymentStrategy is an autogenerated conversion function.
func Convert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(in *appsv1.DeploymentStrategy, out *apps.DeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(in, out, s)
}

func autoConvert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(in *apps.DeploymentStrategy, out *appsv1.DeploymentStrategy, s conversion.Scope) error {
	out.Type = appsv1.DeploymentStrategyType(in.Type)
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateDeployment)
		if err := Convert_apps_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingUpdate = nil
	}
	return nil
}

// Convert_apps_DeploymentStrategy_To_v1_DeploymentStrategy is an autogenerated conversion function.
func Convert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(in *apps.DeploymentStrategy, out *appsv1.DeploymentStrategy, s conversion.Scope) error {
	return autoConvert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(in, out, s)
}

func autoConvert_v1_ReplicaSet_To_apps_ReplicaSet(in *appsv1.ReplicaSet, out *apps.ReplicaSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ReplicaSetSpec_To_apps_ReplicaSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ReplicaSetStatus_To_apps_ReplicaSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ReplicaSet_To_apps_ReplicaSet is an autogenerated conversion function.
func Convert_v1_ReplicaSet_To_apps_ReplicaSet(in *appsv1.ReplicaSet, out *apps.ReplicaSet, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSet_To_apps_ReplicaSet(in, out, s)
}

func autoConvert_apps_ReplicaSet_To_v1_ReplicaSet(in *apps.ReplicaSet, out *appsv1.ReplicaSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_apps_ReplicaSetSpec_To_v1_ReplicaSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_apps_ReplicaSetStatus_To_v1_ReplicaSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_ReplicaSet_To_v1_ReplicaSet is an autogenerated conversion function.
func Convert_apps_ReplicaSet_To_v1_ReplicaSet(in *apps.ReplicaSet, out *appsv1.ReplicaSet, s conversion.Scope) error {
	return autoConvert_apps_ReplicaSet_To_v1_ReplicaSet(in, out, s)
}

func autoConvert_v1_ReplicaSetCondition_To_apps_ReplicaSetCondition(in *appsv1.ReplicaSetCondition, out *apps.ReplicaSetCondition, s conversion.Scope) error {
	out.Type = apps.ReplicaSetConditionType(in.Type)
	out.Status = core.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_ReplicaSetCondition_To_apps_ReplicaSetCondition is an autogenerated conversion function.
func Convert_v1_ReplicaSetCondition_To_apps_ReplicaSetCondition(in *appsv1.ReplicaSetCondition, out *apps.ReplicaSetCondition, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetCondition_To_apps_ReplicaSetCondition(in, out, s)
}

func autoConvert_apps_ReplicaSetCondition_To_v1_ReplicaSetCondition(in *apps.ReplicaSetCondition, out *appsv1.ReplicaSetCondition, s conversion.Scope) error {
	out.Type = appsv1.ReplicaSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_apps_ReplicaSetCondition_To_v1_ReplicaSetCondition is an autogenerated conversion function.
func Convert_apps_ReplicaSetCondition_To_v1_ReplicaSetCondition(in *apps.ReplicaSetCondition, out *appsv1.ReplicaSetCondition, s conversion.Scope) error {
	return autoConvert_apps_ReplicaSetCondition_To_v1_ReplicaSetCondition(in, out, s)
}

func autoConvert_v1_ReplicaSetList_To_apps_ReplicaSetList(in *appsv1.ReplicaSetList, out *apps.ReplicaSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]apps.ReplicaSet, len(*in))
		for i := range *in {
			if err := Convert_v1_ReplicaSet_To_apps_ReplicaSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ReplicaSetList_To_apps_ReplicaSetList is an autogenerated conversion function.
func Convert_v1_ReplicaSetList_To_apps_ReplicaSetList(in *appsv1.ReplicaSetList, out *apps.ReplicaSetList, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetList_To_apps_ReplicaSetList(in, out, s)
}

func autoConvert_apps_ReplicaSetList_To_v1_ReplicaSetList(in *apps.ReplicaSetList, out *appsv1.ReplicaSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]appsv1.ReplicaSet, len(*in))
		for i := range *in {
			if err := Convert_apps_ReplicaSet_To_v1_ReplicaSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_apps_ReplicaSetList_To_v1_ReplicaSetList is an autogenerated conversion function.
func Convert_apps_ReplicaSetList_To_v1_ReplicaSetList(in *apps.ReplicaSetList, out *appsv1.ReplicaSetList, s conversion.Scope) error {
	return autoConvert_apps_ReplicaSetList_To_v1_ReplicaSetList(in, out, s)
}

func autoConvert_v1_ReplicaSetSpec_To_apps_ReplicaSetSpec(in *appsv1.ReplicaSetSpec, out *apps.ReplicaSetSpec, s conversion.Scope) error {
	if err := metav1.Convert_Pointer_int32_To_int32(&in.Replicas, &out.Replicas, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := apiscorev1.Convert_v1_PodTemplateSpec_To_core_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ReplicaSetSpec_To_apps_ReplicaSetSpec is an autogenerated conversion function.
func Convert_v1_ReplicaSetSpec_To_apps_ReplicaSetSpec(in *appsv1.ReplicaSetSpec, out *apps.ReplicaSetSpec, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetSpec_To_apps_ReplicaSetSpec(in, out, s)
}

func autoConvert_apps_ReplicaSetSpec_To_v1_ReplicaSetSpec(in *apps.ReplicaSetSpec, out *appsv1.ReplicaSetSpec, s conversion.Scope) error {
	if err := metav1.Convert_int32_To_Pointer_int32(&in.Replicas, &out.Replicas, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := apiscorev1.Convert_core_PodTemplateSpec_To_v1_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_ReplicaSetSpec_To_v1_ReplicaSetSpec is an autogenerated conversion function.
func Convert_apps_ReplicaSetSpec_To_v1_ReplicaSetSpec(in *apps.ReplicaSetSpec, out *appsv1.ReplicaSetSpec, s conversion.Scope) error {
	return autoConvert_apps_ReplicaSetSpec_To_v1_ReplicaSetSpec(in, out, s)
}

func autoConvert_v1_ReplicaSetStatus_To_apps_ReplicaSetStatus(in *appsv1.ReplicaSetStatus, out *apps.ReplicaSetStatus, s conversion.Scope) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*[]apps.ReplicaSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_ReplicaSetStatus_To_apps_ReplicaSetStatus is an autogenerated conversion function.
func Convert_v1_ReplicaSetStatus_To_apps_ReplicaSetStatus(in *appsv1.ReplicaSetStatus, out *apps.ReplicaSetStatus, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetStatus_To_apps_ReplicaSetStatus(in, out, s)
}

func autoConvert_apps_ReplicaSetStatus_To_v1_ReplicaSetStatus(in *apps.ReplicaSetStatus, out *appsv1.ReplicaSetStatus, s conversion.Scope) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*[]appsv1.ReplicaSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_apps_ReplicaSetStatus_To_v1_ReplicaSetStatus is an autogenerated conversion function.
func Convert_apps_ReplicaSetStatus_To_v1_ReplicaSetStatus(in *apps.ReplicaSetStatus, out *appsv1.ReplicaSetStatus, s conversion.Scope) error {
	return autoConvert_apps_ReplicaSetStatus_To_v1_ReplicaSetStatus(in, out, s)
}

func autoConvert_v1_RollingUpdateDaemonSet_To_apps_RollingUpdateDaemonSet(in *appsv1.RollingUpdateDaemonSet, out *apps.RollingUpdateDaemonSet, s conversion.Scope) error {
	if err := metav1.Convert_Pointer_intstr_IntOrString_To_intstr_IntOrString(&in.MaxUnavailable, &out.MaxUnavailable, s); err != nil {
		return err
	}
	if err := metav1.Convert_Pointer_intstr_IntOrString_To_intstr_IntOrString(&in.MaxSurge, &out.MaxSurge, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_RollingUpdateDaemonSet_To_apps_RollingUpdateDaemonSet is an autogenerated conversion function.
func Convert_v1_RollingUpdateDaemonSet_To_apps_RollingUpdateDaemonSet(in *appsv1.RollingUpdateDaemonSet, out *apps.RollingUpdateDaemonSet, s conversion.Scope) error {
	return autoConvert_v1_RollingUpdateDaemonSet_To_apps_RollingUpdateDaemonSet(in, out, s)
}

func autoConvert_apps_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in *apps.RollingUpdateDaemonSet, out *appsv1.RollingUpdateDaemonSet, s conversion.Scope) error {
	if err := metav1.Convert_intstr_IntOrString_To_Pointer_intstr_IntOrString(&in.MaxUnavailable, &out.MaxUnavailable, s); err != nil {
		return err
	}
	if err := metav1.Convert_intstr_IntOrString_To_Pointer_intstr_IntOrString(&in.MaxSurge, &out.MaxSurge, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet is an autogenerated conversion function.
func Convert_apps_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in *apps.RollingUpdateDaemonSet, out *appsv1.RollingUpdateDaemonSet, s conversion.Scope) error {
	return autoConvert_apps_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in, out, s)
}

func autoConvert_v1_RollingUpdateDeployment_To_apps_RollingUpdateDeployment(in *appsv1.RollingUpdateDeployment, out *apps.RollingUpdateDeployment, s conversion.Scope) error {
	if err := metav1.Convert_Pointer_intstr_IntOrString_To_intstr_IntOrString(&in.MaxUnavailable, &out.MaxUnavailable, s); err != nil {
		return err
	}
	if err := metav1.Convert_Pointer_intstr_IntOrString_To_intstr_IntOrString(&in.MaxSurge, &out.MaxSurge, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_RollingUpdateDeployment_To_apps_RollingUpdateDeployment is an autogenerated conversion function.
func Convert_v1_RollingUpdateDeployment_To_apps_RollingUpdateDeployment(in *appsv1.RollingUpdateDeployment, out *apps.RollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_v1_RollingUpdateDeployment_To_apps_RollingUpdateDeployment(in, out, s)
}

func autoConvert_apps_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in *apps.RollingUpdateDeployment, out *appsv1.RollingUpdateDeployment, s conversion.Scope) error {
	if err := metav1.Convert_intstr_IntOrString_To_Pointer_intstr_IntOrString(&in.MaxUnavailable, &out.MaxUnavailable, s); err != nil {
		return err
	}
	if err := metav1.Convert_intstr_IntOrString_To_Pointer_intstr_IntOrString(&in.MaxSurge, &out.MaxSurge, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_RollingUpdateDeployment_To_v1_RollingUpdateDeployment is an autogenerated conversion function.
func Convert_apps_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in *apps.RollingUpdateDeployment, out *appsv1.RollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_apps_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in, out, s)
}

func autoConvert_v1_RollingUpdateStatefulSetStrategy_To_apps_RollingUpdateStatefulSetStrategy(in *appsv1.RollingUpdateStatefulSetStrategy, out *apps.RollingUpdateStatefulSetStrategy, s conversion.Scope) error {
	if err := metav1.Convert_Pointer_int32_To_int32(&in.Partition, &out.Partition, s); err != nil {
		return err
	}
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	return nil
}

// Convert_v1_RollingUpdateStatefulSetStrategy_To_apps_RollingUpdateStatefulSetStrategy is an autogenerated conversion function.
func Convert_v1_RollingUpdateStatefulSetStrategy_To_apps_RollingUpdateStatefulSetStrategy(in *appsv1.RollingUpdateStatefulSetStrategy, out *apps.RollingUpdateStatefulSetStrategy, s conversion.Scope) error {
	return autoConvert_v1_RollingUpdateStatefulSetStrategy_To_apps_RollingUpdateStatefulSetStrategy(in, out, s)
}

func autoConvert_apps_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(in *apps.RollingUpdateStatefulSetStrategy, out *appsv1.RollingUpdateStatefulSetStrategy, s conversion.Scope) error {
	if err := metav1.Convert_int32_To_Pointer_int32(&in.Partition, &out.Partition, s); err != nil {
		return err
	}
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	return nil
}

// Convert_apps_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy is an autogenerated conversion function.
func Convert_apps_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(in *apps.RollingUpdateStatefulSetStrategy, out *appsv1.RollingUpdateStatefulSetStrategy, s conversion.Scope) error {
	return autoConvert_apps_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(in, out, s)
}

func autoConvert_v1_StatefulSet_To_apps_StatefulSet(in *appsv1.StatefulSet, out *apps.StatefulSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_StatefulSetSpec_To_apps_StatefulSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_StatefulSetStatus_To_apps_StatefulSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_StatefulSet_To_apps_StatefulSet is an autogenerated conversion function.
func Convert_v1_StatefulSet_To_apps_StatefulSet(in *appsv1.StatefulSet, out *apps.StatefulSet, s conversion.Scope) error {
	return autoConvert_v1_StatefulSet_To_apps_StatefulSet(in, out, s)
}

func autoConvert_apps_StatefulSet_To_v1_StatefulSet(in *apps.StatefulSet, out *appsv1.StatefulSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_apps_StatefulSetSpec_To_v1_StatefulSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_apps_StatefulSetStatus_To_v1_StatefulSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_StatefulSet_To_v1_StatefulSet is an autogenerated conversion function.
func Convert_apps_StatefulSet_To_v1_StatefulSet(in *apps.StatefulSet, out *appsv1.StatefulSet, s conversion.Scope) error {
	return autoConvert_apps_StatefulSet_To_v1_StatefulSet(in, out, s)
}

func autoConvert_v1_StatefulSetCondition_To_apps_StatefulSetCondition(in *appsv1.StatefulSetCondition, out *apps.StatefulSetCondition, s conversion.Scope) error {
	out.Type = apps.StatefulSetConditionType(in.Type)
	out.Status = core.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_StatefulSetCondition_To_apps_StatefulSetCondition is an autogenerated conversion function.
func Convert_v1_StatefulSetCondition_To_apps_StatefulSetCondition(in *appsv1.StatefulSetCondition, out *apps.StatefulSetCondition, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetCondition_To_apps_StatefulSetCondition(in, out, s)
}

func autoConvert_apps_StatefulSetCondition_To_v1_StatefulSetCondition(in *apps.StatefulSetCondition, out *appsv1.StatefulSetCondition, s conversion.Scope) error {
	out.Type = appsv1.StatefulSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_apps_StatefulSetCondition_To_v1_StatefulSetCondition is an autogenerated conversion function.
func Convert_apps_StatefulSetCondition_To_v1_StatefulSetCondition(in *apps.StatefulSetCondition, out *appsv1.StatefulSetCondition, s conversion.Scope) error {
	return autoConvert_apps_StatefulSetCondition_To_v1_StatefulSetCondition(in, out, s)
}

func autoConvert_v1_StatefulSetList_To_apps_StatefulSetList(in *appsv1.StatefulSetList, out *apps.StatefulSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]apps.StatefulSet, len(*in))
		for i := range *in {
			if err := Convert_v1_StatefulSet_To_apps_StatefulSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_StatefulSetList_To_apps_StatefulSetList is an autogenerated conversion function.
func Convert_v1_StatefulSetList_To_apps_StatefulSetList(in *appsv1.StatefulSetList, out *apps.StatefulSetList, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetList_To_apps_StatefulSetList(in, out, s)
}

func autoConvert_apps_StatefulSetList_To_v1_StatefulSetList(in *apps.StatefulSetList, out *appsv1.StatefulSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]appsv1.StatefulSet, len(*in))
		for i := range *in {
			if err := Convert_apps_StatefulSet_To_v1_StatefulSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_apps_StatefulSetList_To_v1_StatefulSetList is an autogenerated conversion function.
func Convert_apps_StatefulSetList_To_v1_StatefulSetList(in *apps.StatefulSetList, out *appsv1.StatefulSetList, s conversion.Scope) error {
	return autoConvert_apps_StatefulSetList_To_v1_StatefulSetList(in, out, s)
}

func autoConvert_v1_StatefulSetOrdinals_To_apps_StatefulSetOrdinals(in *appsv1.StatefulSetOrdinals, out *apps.StatefulSetOrdinals, s conversion.Scope) error {
	out.Start = in.Start
	return nil
}

// Convert_v1_StatefulSetOrdinals_To_apps_StatefulSetOrdinals is an autogenerated conversion function.
func Convert_v1_StatefulSetOrdinals_To_apps_StatefulSetOrdinals(in *appsv1.StatefulSetOrdinals, out *apps.StatefulSetOrdinals, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetOrdinals_To_apps_StatefulSetOrdinals(in, out, s)
}

func autoConvert_apps_StatefulSetOrdinals_To_v1_StatefulSetOrdinals(in *apps.StatefulSetOrdinals, out *appsv1.StatefulSetOrdinals, s conversion.Scope) error {
	out.Start = in.Start
	return nil
}

// Convert_apps_StatefulSetOrdinals_To_v1_StatefulSetOrdinals is an autogenerated conversion function.
func Convert_apps_StatefulSetOrdinals_To_v1_StatefulSetOrdinals(in *apps.StatefulSetOrdinals, out *appsv1.StatefulSetOrdinals, s conversion.Scope) error {
	return autoConvert_apps_StatefulSetOrdinals_To_v1_StatefulSetOrdinals(in, out, s)
}

func autoConvert_v1_StatefulSetPersistentVolumeClaimRetentionPolicy_To_apps_StatefulSetPersistentVolumeClaimRetentionPolicy(in *appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy, out *apps.StatefulSetPersistentVolumeClaimRetentionPolicy, s conversion.Scope) error {
	out.WhenDeleted = apps.PersistentVolumeClaimRetentionPolicyType(in.WhenDeleted)
	out.WhenScaled = apps.PersistentVolumeClaimRetentionPolicyType(in.WhenScaled)
	return nil
}

// Convert_v1_StatefulSetPersistentVolumeClaimRetentionPolicy_To_apps_StatefulSetPersistentVolumeClaimRetentionPolicy is an autogenerated conversion function.
func Convert_v1_StatefulSetPersistentVolumeClaimRetentionPolicy_To_apps_StatefulSetPersistentVolumeClaimRetentionPolicy(in *appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy, out *apps.StatefulSetPersistentVolumeClaimRetentionPolicy, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetPersistentVolumeClaimRetentionPolicy_To_apps_StatefulSetPersistentVolumeClaimRetentionPolicy(in, out, s)
}

func autoConvert_apps_StatefulSetPersistentVolumeClaimRetentionPolicy_To_v1_StatefulSetPersistentVolumeClaimRetentionPolicy(in *apps.StatefulSetPersistentVolumeClaimRetentionPolicy, out *appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy, s conversion.Scope) error {
	out.WhenDeleted = appsv1.PersistentVolumeClaimRetentionPolicyType(in.WhenDeleted)
	out.WhenScaled = appsv1.PersistentVolumeClaimRetentionPolicyType(in.WhenScaled)
	return nil
}

// Convert_apps_StatefulSetPersistentVolumeClaimRetentionPolicy_To_v1_StatefulSetPersistentVolumeClaimRetentionPolicy is an autogenerated conversion function.
func Convert_apps_StatefulSetPersistentVolumeClaimRetentionPolicy_To_v1_StatefulSetPersistentVolumeClaimRetentionPolicy(in *apps.StatefulSetPersistentVolumeClaimRetentionPolicy, out *appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy, s conversion.Scope) error {
	return autoConvert_apps_StatefulSetPersistentVolumeClaimRetentionPolicy_To_v1_StatefulSetPersistentVolumeClaimRetentionPolicy(in, out, s)
}

func autoConvert_v1_StatefulSetSpec_To_apps_StatefulSetSpec(in *appsv1.StatefulSetSpec, out *apps.StatefulSetSpec, s conversion.Scope) error {
	if err := metav1.Convert_Pointer_int32_To_int32(&in.Replicas, &out.Replicas, s); err != nil {
		return err
	}
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := apiscorev1.Convert_v1_PodTemplateSpec_To_core_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	out.VolumeClaimTemplates = *(*[]core.PersistentVolumeClaim)(unsafe.Pointer(&in.VolumeClaimTemplates))
	out.ServiceName = in.ServiceName
	out.PodManagementPolicy = apps.PodManagementPolicyType(in.PodManagementPolicy)
	if err := Convert_v1_StatefulSetUpdateStrategy_To_apps_StatefulSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.MinReadySeconds = in.MinReadySeconds
	out.PersistentVolumeClaimRetentionPolicy = (*apps.StatefulSetPersistentVolumeClaimRetentionPolicy)(unsafe.Pointer(in.PersistentVolumeClaimRetentionPolicy))
	out.Ordinals = (*apps.StatefulSetOrdinals)(unsafe.Pointer(in.Ordinals))
	return nil
}

func autoConvert_apps_StatefulSetSpec_To_v1_StatefulSetSpec(in *apps.StatefulSetSpec, out *appsv1.StatefulSetSpec, s conversion.Scope) error {
	if err := metav1.Convert_int32_To_Pointer_int32(&in.Replicas, &out.Replicas, s); err != nil {
		return err
	}
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := apiscorev1.Convert_core_PodTemplateSpec_To_v1_PodTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	out.VolumeClaimTemplates = *(*[]corev1.PersistentVolumeClaim)(unsafe.Pointer(&in.VolumeClaimTemplates))
	out.ServiceName = in.ServiceName
	out.PodManagementPolicy = appsv1.PodManagementPolicyType(in.PodManagementPolicy)
	if err := Convert_apps_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.MinReadySeconds = in.MinReadySeconds
	out.PersistentVolumeClaimRetentionPolicy = (*appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy)(unsafe.Pointer(in.PersistentVolumeClaimRetentionPolicy))
	out.Ordinals = (*appsv1.StatefulSetOrdinals)(unsafe.Pointer(in.Ordinals))
	return nil
}

func autoConvert_v1_StatefulSetStatus_To_apps_StatefulSetStatus(in *appsv1.StatefulSetStatus, out *apps.StatefulSetStatus, s conversion.Scope) error {
	if err := metav1.Convert_int64_To_Pointer_int64(&in.ObservedGeneration, &out.ObservedGeneration, s); err != nil {
		return err
	}
	out.Replicas = in.Replicas
	out.ReadyReplicas = in.ReadyReplicas
	out.CurrentReplicas = in.CurrentReplicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.CurrentRevision = in.CurrentRevision
	out.UpdateRevision = in.UpdateRevision
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]apps.StatefulSetCondition)(unsafe.Pointer(&in.Conditions))
	out.AvailableReplicas = in.AvailableReplicas
	return nil
}

// Convert_v1_StatefulSetStatus_To_apps_StatefulSetStatus is an autogenerated conversion function.
func Convert_v1_StatefulSetStatus_To_apps_StatefulSetStatus(in *appsv1.StatefulSetStatus, out *apps.StatefulSetStatus, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetStatus_To_apps_StatefulSetStatus(in, out, s)
}

func autoConvert_apps_StatefulSetStatus_To_v1_StatefulSetStatus(in *apps.StatefulSetStatus, out *appsv1.StatefulSetStatus, s conversion.Scope) error {
	if err := metav1.Convert_Pointer_int64_To_int64(&in.ObservedGeneration, &out.ObservedGeneration, s); err != nil {
		return err
	}
	out.Replicas = in.Replicas
	out.ReadyReplicas = in.ReadyReplicas
	out.CurrentReplicas = in.CurrentReplicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.CurrentRevision = in.CurrentRevision
	out.UpdateRevision = in.UpdateRevision
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]appsv1.StatefulSetCondition)(unsafe.Pointer(&in.Conditions))
	out.AvailableReplicas = in.AvailableReplicas
	return nil
}

// Convert_apps_StatefulSetStatus_To_v1_StatefulSetStatus is an autogenerated conversion function.
func Convert_apps_StatefulSetStatus_To_v1_StatefulSetStatus(in *apps.StatefulSetStatus, out *appsv1.StatefulSetStatus, s conversion.Scope) error {
	return autoConvert_apps_StatefulSetStatus_To_v1_StatefulSetStatus(in, out, s)
}

func autoConvert_v1_StatefulSetUpdateStrategy_To_apps_StatefulSetUpdateStrategy(in *appsv1.StatefulSetUpdateStrategy, out *apps.StatefulSetUpdateStrategy, s conversion.Scope) error {
	out.Type = apps.StatefulSetUpdateStrategyType(in.Type)
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(apps.RollingUpdateStatefulSetStrategy)
		if err := Convert_v1_RollingUpdateStatefulSetStrategy_To_apps_RollingUpdateStatefulSetStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingUpdate = nil
	}
	return nil
}

// Convert_v1_StatefulSetUpdateStrategy_To_apps_StatefulSetUpdateStrategy is an autogenerated conversion function.
func Convert_v1_StatefulSetUpdateStrategy_To_apps_StatefulSetUpdateStrategy(in *appsv1.StatefulSetUpdateStrategy, out *apps.StatefulSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_v1_StatefulSetUpdateStrategy_To_apps_StatefulSetUpdateStrategy(in, out, s)
}

func autoConvert_apps_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(in *apps.StatefulSetUpdateStrategy, out *appsv1.StatefulSetUpdateStrategy, s conversion.Scope) error {
	out.Type = appsv1.StatefulSetUpdateStrategyType(in.Type)
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(appsv1.RollingUpdateStatefulSetStrategy)
		if err := Convert_apps_RollingUpdateStatefulSetStrategy_To_v1_RollingUpdateStatefulSetStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingUpdate = nil
	}
	return nil
}

// Convert_apps_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy is an autogenerated conversion function.
func Convert_apps_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(in *apps.StatefulSetUpdateStrategy, out *appsv1.StatefulSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_apps_StatefulSetUpdateStrategy_To_v1_StatefulSetUpdateStrategy(in, out, s)
}
