/*
Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Package options provide a central point for defining flags for kubeadm cobra commands,
no matter if hard coded commands or autogenerated command for phases.

New kubeadm flags should always be defined in this package as a constant before their usage,
in order to enforce naming consistency across different commands and to control flag proliferation.

In addition to defining the flags, the package also contains set of utilities for flag management.

For additional details about how flags are managed in phases, please refer to the
"k8s.io/kubernetes/cmd/kubeadm/app/cmd/phases/workflow" package.
*/
package options
