/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.StringUtils;

public class Parallel
extends Task
implements TaskContainer {
    private Vector nestedTasks = new Vector();
    private final Object semaphore = new Object();
    private int numThreads = 0;
    private int numThreadsPerProcessor = 0;
    private long timeout;
    private volatile boolean stillRunning;
    private boolean timedOut;
    private boolean failOnAny;
    private TaskList daemonTasks;
    private StringBuffer exceptionMessage;
    private int numExceptions = 0;
    private Throwable firstException;
    private Location firstLocation;
    static /* synthetic */ Class class$java$lang$Runtime;

    public void addDaemons(TaskList daemonTasks) {
        if (this.daemonTasks != null) {
            throw new BuildException("Only one daemon group is supported");
        }
        this.daemonTasks = daemonTasks;
    }

    public void setPollInterval(int pollInterval) {
    }

    public void setFailOnAny(boolean failOnAny) {
        this.failOnAny = failOnAny;
    }

    public void addTask(Task nestedTask) {
        this.nestedTasks.addElement(nestedTask);
    }

    public void setThreadsPerProcessor(int numThreadsPerProcessor) {
        this.numThreadsPerProcessor = numThreadsPerProcessor;
    }

    public void setThreadCount(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void execute() throws BuildException {
        this.updateThreadCounts();
        if (this.numThreads == 0) {
            this.numThreads = this.nestedTasks.size();
        }
        this.spinThreads();
    }

    private void updateThreadCounts() {
        int numProcessors;
        if (this.numThreadsPerProcessor != 0 && (numProcessors = this.getNumProcessors()) != 0) {
            this.numThreads = numProcessors * this.numThreadsPerProcessor;
        }
    }

    private void processExceptions(TaskRunnable[] runnables) {
        if (runnables == null) {
            return;
        }
        int i = 0;
        while (i < runnables.length) {
            Throwable t = runnables[i].getException();
            if (t != null) {
                ++this.numExceptions;
                if (this.firstException == null) {
                    this.firstException = t;
                }
                if (t instanceof BuildException && this.firstLocation == Location.UNKNOWN_LOCATION) {
                    this.firstLocation = ((BuildException)t).getLocation();
                }
                this.exceptionMessage.append(StringUtils.LINE_SEP);
                this.exceptionMessage.append(t.getMessage());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spinThreads() throws BuildException {
        int numTasks = this.nestedTasks.size();
        TaskRunnable[] runnables = new TaskRunnable[numTasks];
        this.stillRunning = true;
        this.timedOut = false;
        int threadNumber = 0;
        Enumeration e = this.nestedTasks.elements();
        while (e.hasMoreElements()) {
            Task nestedTask = (Task)e.nextElement();
            runnables[threadNumber] = new TaskRunnable(nestedTask);
            ++threadNumber;
        }
        int maxRunning = numTasks < this.numThreads ? numTasks : this.numThreads;
        TaskRunnable[] running = new TaskRunnable[maxRunning];
        threadNumber = 0;
        ThreadGroup group = new ThreadGroup("parallel");
        TaskRunnable[] daemons = null;
        if (this.daemonTasks != null && this.daemonTasks.tasks.size() != 0) {
            daemons = new TaskRunnable[this.daemonTasks.tasks.size()];
        }
        Object object = this.semaphore;
        synchronized (object) {
            int i;
            if (daemons != null) {
                i = 0;
                while (i < daemons.length) {
                    daemons[i] = new TaskRunnable((Task)this.daemonTasks.tasks.get(i));
                    Thread daemonThread = new Thread(group, daemons[i]);
                    daemonThread.setDaemon(true);
                    daemonThread.start();
                    ++i;
                }
            }
            i = 0;
            while (i < maxRunning) {
                running[i] = runnables[threadNumber++];
                Thread thread = new Thread(group, running[i]);
                thread.start();
                ++i;
            }
            if (this.timeout != 0L) {
                Thread timeoutThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public synchronized void run() {
                        try {
                            this.wait(Parallel.this.timeout);
                            Object object = Parallel.this.semaphore;
                            synchronized (object) {
                                Parallel.this.stillRunning = false;
                                Parallel.this.timedOut = true;
                                Parallel.this.semaphore.notifyAll();
                            }
                        }
                        catch (InterruptedException e) {}
                    }
                };
                timeoutThread.start();
            }
            block10: while (threadNumber < numTasks && this.stillRunning) {
                int i2 = 0;
                while (i2 < maxRunning) {
                    if (running[i2] == null || running[i2].finished) {
                        running[i2] = runnables[threadNumber++];
                        Thread thread = new Thread(group, running[i2]);
                        thread.start();
                        continue block10;
                    }
                    ++i2;
                }
                try {
                    this.semaphore.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            block12: while (this.stillRunning) {
                int i3 = 0;
                while (i3 < maxRunning) {
                    if (running[i3] != null && !running[i3].finished) {
                        try {
                            this.semaphore.wait();
                        }
                        catch (InterruptedException ie) {}
                        continue block12;
                    }
                    ++i3;
                }
                this.stillRunning = false;
            }
        }
        if (this.timedOut) {
            throw new BuildException("Parallel execution timed out");
        }
        this.exceptionMessage = new StringBuffer();
        this.numExceptions = 0;
        this.firstException = null;
        this.firstLocation = Location.UNKNOWN_LOCATION;
        this.processExceptions(daemons);
        this.processExceptions(runnables);
        if (this.numExceptions == 1) {
            if (this.firstException instanceof BuildException) {
                throw (BuildException)this.firstException;
            }
            throw new BuildException(this.firstException);
        }
        if (this.numExceptions > 1) {
            throw new BuildException(this.exceptionMessage.toString(), this.firstLocation);
        }
    }

    private int getNumProcessors() {
        try {
            Class[] paramTypes = new Class[]{};
            Method availableProcessors = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Parallel.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("availableProcessors", paramTypes);
            Object[] args = new Object[]{};
            Integer ret = (Integer)availableProcessors.invoke((Object)Runtime.getRuntime(), args);
            return ret;
        }
        catch (Exception e) {
            return 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TaskRunnable
    implements Runnable {
        private Throwable exception;
        private Task task;
        boolean finished;

        TaskRunnable(Task task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.perform();
            }
            catch (Throwable t) {
                this.exception = t;
            }
            finally {
                Object object = Parallel.this.semaphore;
                synchronized (object) {
                    this.finished = true;
                    if (Parallel.this.failOnAny) {
                        Parallel.this.stillRunning = false;
                    }
                    Parallel.this.semaphore.notifyAll();
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    public static class TaskList
    implements TaskContainer {
        private List tasks = new ArrayList();

        public void addTask(Task nestedTask) throws BuildException {
            this.tasks.add(nestedTask);
        }
    }
}

