/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;
import org.apache.harmony.jndi.provider.dns.QuestionRecord;
import org.apache.harmony.jndi.provider.dns.ResourceRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResolverCache {
    HashMap<String, Vector<CacheEntry>> names = new HashMap();
    private static ResolverCache instance = null;

    private ResolverCache() {
    }

    static ResolverCache getInstance() {
        if (instance == null) {
            instance = new ResolverCache();
        }
        return instance;
    }

    synchronized Enumeration<ResourceRecord> get(QuestionRecord question) {
        String name = question.getQName().toLowerCase();
        Vector<CacheEntry> vect = this.names.get(name);
        int qClass = question.getQClass();
        int qType = question.getQType();
        Vector<ResourceRecord> resVect = new Vector<ResourceRecord>();
        if (vect != null) {
            int i = 0;
            while (i < vect.size()) {
                CacheEntry curEntry = vect.elementAt(i);
                ResourceRecord curRR = curEntry.getRR();
                if (curEntry.getBestBefore() < System.currentTimeMillis()) {
                    vect.removeElementAt(i--);
                } else if (qClass != 255 && qClass == curRR.getRRClass() && qType != 255 && qType == curRR.getRRType()) {
                    resVect.addElement(curRR);
                }
                ++i;
            }
        }
        return resVect.elements();
    }

    synchronized void put(ResourceRecord record) {
        String name = record.getName().toLowerCase();
        Vector<CacheEntry> vect = this.names.get(name);
        long curTime = System.currentTimeMillis();
        CacheEntry entry = null;
        if (vect == null) {
            vect = new Vector();
            this.names.put(name, vect);
        }
        if (record.getTtl() >> 31 != 0L) {
            record.setTtl(0L);
        }
        if (record.getTtl() > 0L && record.getName().indexOf(42) == -1) {
            entry = new CacheEntry(record, curTime + record.getTtl());
            int i = 0;
            while (i < vect.size()) {
                CacheEntry exEntry = vect.elementAt(i);
                ResourceRecord exRec = exEntry.rr;
                if (ProviderMgr.namesAreEqual(record.getName(), exRec.getName()) && record.getRRClass() == exRec.getRRClass() && record.getRRType() == exRec.getRRType() && record.getRData() != null && exRec.getRData() != null && record.getRData().equals(exRec.getRData())) {
                    vect.remove(i);
                    break;
                }
                ++i;
            }
            vect.addElement(entry);
        }
    }

    synchronized void clear() {
        this.names = new HashMap();
    }

    static class CacheEntry {
        private ResourceRecord rr;
        private long bestBefore;

        public CacheEntry(ResourceRecord rr, long bestBefore) {
            this.rr = rr;
            this.bestBefore = bestBefore;
        }

        public long getBestBefore() {
            return this.bestBefore;
        }

        public ResourceRecord getRR() {
            return this.rr;
        }
    }
}

