/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTest
extends TestCase {
    static Calendar aCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    static long TIME_AN_HOUR = 3600000L;
    static long TIME_EPOCH = 0L;
    static long TIME_NOW = System.currentTimeMillis();
    static long TIME_NEGATIVE = -3600001L;
    static long TIME_TESTDATE1 = DateTest.getTime((int)1999, (int)11, (int)31, (int)23, (int)59, (int)59);
    static long TIME_TESTDATE2 = DateTest.getTime((int)2010, (int)5, (int)10, (int)20, (int)3, (int)16);
    static long TIME_TESTDATE3 = DateTest.getTime((int)1931, (int)3, (int)21, (int)1, (int)25, (int)1);
    static long TIME_LOWERLIMIT = Long.MIN_VALUE;
    static long TIME_UPPERLIMIT = Long.MAX_VALUE;
    static String SQL_DATESTRING1 = "1999-12-31";
    static String SQL_DATESTRING2 = "2010-06-10";
    static String SQL_DATESTRING3 = "1931-04-21";
    static String SQL_EPOCHSTRING = "1970-01-01";
    static String SQL_DATEDAY1 = "1970-01-02";
    static String SQL_NEGATIVE = "1969-12-31";
    static long[] TIME_ARRAY = new long[]{TIME_TESTDATE1, TIME_TESTDATE2, TIME_TESTDATE3, TIME_NEGATIVE, TIME_EPOCH};
    static String[] SQL_DATEARRAY = new String[]{SQL_DATESTRING1, SQL_DATESTRING2, SQL_DATESTRING3, SQL_NEGATIVE, SQL_EPOCHSTRING};
    static String[] SQL_NYARRAY = new String[]{"1999-12-31", "2010-06-10", "1931-04-20", "1969-12-31", "1969-12-31"};
    static String[] SQL_JAPANARRAY = new String[]{"2000-01-01", "2010-06-11", "1931-04-21", "1970-01-01", "1970-01-01"};
    static String[][] SQL_TZ_DATEARRAYS = new String[][]{SQL_DATEARRAY, SQL_NYARRAY, SQL_JAPANARRAY};
    static String TZ_LONDON = "Europe/London";
    static String TZ_PACIFIC = "America/Los_Angeles";
    static String TZ_JAPAN = "Asia/Tokyo";
    static String[] TIMEZONES = new String[]{TZ_LONDON, TZ_PACIFIC, TZ_JAPAN};

    private static long getTime(int n, int n2, int n3, int n4, int n5, int n6) {
        aCal.set(n, n2, n3, n4, n5, n6);
        return aCal.getTimeInMillis();
    }

    public void testDateintintint() {
        int[] nArray = new int[]{99, 8099, 9000, 99999, 99, 99, -1, -100};
        int[] nArray2 = new int[8];
        nArray2[0] = 11;
        nArray2[4] = 999;
        nArray2[7] = -111;
        int[] nArray3 = nArray2;
        int[] nArray4 = new int[8];
        nArray4[0] = 31;
        nArray4[5] = 999;
        nArray4[7] = -999;
        int[] nArray5 = nArray4;
        int n = 0;
        while (n < nArray.length) {
            Date date = new Date(nArray[n], nArray3[n], nArray5[n]);
            DateTest.assertNotNull((Object)date);
            ++n;
        }
    }

    public void testDatelong() {
        long[] lArray;
        long[] lArray2 = lArray = new long[]{TIME_TESTDATE1, TIME_TESTDATE2, TIME_TESTDATE3, TIME_NEGATIVE, TIME_LOWERLIMIT, TIME_UPPERLIMIT, TIME_EPOCH, TIME_NOW};
        int n = 0;
        int n2 = lArray2.length;
        while (n < n2) {
            long l = lArray2[n];
            Date date = new Date(l);
            DateTest.assertNotNull((Object)date);
            ++n;
        }
    }

    public void testGetHours() {
        Date date = new Date(TIME_TESTDATE1);
        try {
            date.getHours();
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetMinutes() {
        Date date = new Date(TIME_TESTDATE1);
        try {
            date.getMinutes();
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetSeconds() {
        Date date = new Date(TIME_TESTDATE1);
        try {
            date.getSeconds();
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetHours() {
        Date date = new Date(TIME_TESTDATE1);
        try {
            date.setHours(22);
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetMinutes() {
        Date date = new Date(TIME_TESTDATE1);
        try {
            date.setMinutes(54);
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetSeconds() {
        Date date = new Date(TIME_TESTDATE1);
        try {
            date.setSeconds(36);
            DateTest.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToString() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Date date = new Date(TIME_ARRAY[n]);
            DateTest.assertEquals((String)SQL_DATEARRAY[n], (String)date.toString());
            ++n;
        }
    }

    public void testSetTimelong() {
        int n = 0;
        while (n < TIMEZONES.length) {
            this.testSetTimelong(TIMEZONES[n], SQL_TZ_DATEARRAYS[n]);
            ++n;
        }
    }

    private void testSetTimelong(String string, String[] stringArray) {
        if (string != null) {
            TimeZone.setDefault(TimeZone.getTimeZone(string));
        }
        Date date = new Date(TIME_TESTDATE1);
        int n = 0;
        while (n < stringArray.length) {
            date.setTime(TIME_ARRAY[n]);
            DateTest.assertEquals((String)stringArray[n], (String)date.toString());
            ++n;
        }
    }

    public void testValueOf() {
        Date date;
        String string;
        String string2 = "ABCDEF";
        String string3 = "12321.43.56";
        Object var3_3 = null;
        String[] stringArray = new String[]{string2, string3, var3_3};
        String[] stringArray2 = SQL_DATEARRAY;
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            string = stringArray2[n];
            date = Date.valueOf(string);
            DateTest.assertEquals((String)string, (String)date.toString());
            ++n;
        }
        stringArray2 = stringArray;
        n = 0;
        n2 = stringArray2.length;
        while (n < n2) {
            string = stringArray2[n];
            try {
                date = Date.valueOf(string);
                DateTest.fail((String)"Should throw IllegalArgumentException.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void test_valueOf_IllegalArgumentException() {
        try {
            Date.valueOf("1996-10-07-01");
            DateTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Date.valueOf("-10-07-01");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("--01");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("1991--");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("-01-");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("-10-w2-01");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("07-w2-");
            DateTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Date.valueOf("1997-w2-w2");
            DateTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Date.valueOf("1996--01");
            DateTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

