//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfstream?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct CGPDFStream {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPDFStream {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("CGPDFStream", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfstreamref?language=objc)
pub type CGPDFStreamRef = *mut CGPDFStream;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfdataformat?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGPDFDataFormat(pub i32);
impl CGPDFDataFormat {
    #[doc(alias = "CGPDFDataFormatRaw")]
    pub const Raw: Self = Self(0);
    #[doc(alias = "CGPDFDataFormatJPEGEncoded")]
    pub const JPEGEncoded: Self = Self(1);
    #[doc(alias = "CGPDFDataFormatJPEG2000")]
    pub const JPEG2000: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPDFDataFormat {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPDFDataFormat {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CGPDFStream {
    #[doc(alias = "CGPDFStreamGetDictionary")]
    #[cfg(feature = "CGPDFDictionary")]
    #[inline]
    pub unsafe fn dictionary(stream: CGPDFStreamRef) -> CGPDFDictionaryRef {
        extern "C-unwind" {
            fn CGPDFStreamGetDictionary(stream: CGPDFStreamRef) -> CGPDFDictionaryRef;
        }
        unsafe { CGPDFStreamGetDictionary(stream) }
    }

    #[doc(alias = "CGPDFStreamCopyData")]
    #[inline]
    pub unsafe fn data(
        stream: CGPDFStreamRef,
        format: *mut CGPDFDataFormat,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CGPDFStreamCopyData(
                stream: CGPDFStreamRef,
                format: *mut CGPDFDataFormat,
            ) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CGPDFStreamCopyData(stream, format) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDictionary")]
    #[deprecated = "renamed to `CGPDFStream::dictionary`"]
    pub fn CGPDFStreamGetDictionary(stream: CGPDFStreamRef) -> CGPDFDictionaryRef;
}

#[deprecated = "renamed to `CGPDFStream::data`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFStreamCopyData(
    stream: CGPDFStreamRef,
    format: *mut CGPDFDataFormat,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CGPDFStreamCopyData(
            stream: CGPDFStreamRef,
            format: *mut CGPDFDataFormat,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CGPDFStreamCopyData(stream, format) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
