//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// The main material that this view displays.  Materials are dynamic, and their exact look depends on the view's effectiveAppearance, blendingMode, state, emphasized, and possibly other factors.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsvisualeffectmaterial?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSVisualEffectMaterial(pub NSInteger);
impl NSVisualEffectMaterial {
    /// The material used by window titlebars.
    #[doc(alias = "NSVisualEffectMaterialTitlebar")]
    pub const Titlebar: Self = Self(3);
    /// The material used in some table views, menus, etc., to indicate selection.
    #[doc(alias = "NSVisualEffectMaterialSelection")]
    pub const Selection: Self = Self(4);
    /// The material used by menus.
    #[doc(alias = "NSVisualEffectMaterialMenu")]
    pub const Menu: Self = Self(5);
    /// The material used in the background of NSPopover windows.
    #[doc(alias = "NSVisualEffectMaterialPopover")]
    pub const Popover: Self = Self(6);
    /// The material used in the background of window sidebars.
    #[doc(alias = "NSVisualEffectMaterialSidebar")]
    pub const Sidebar: Self = Self(7);
    /// The material used in various in-line header or footer views (e.g., by NSTableView).
    #[doc(alias = "NSVisualEffectMaterialHeaderView")]
    pub const HeaderView: Self = Self(10);
    /// The material used as the background of sheet windows.
    #[doc(alias = "NSVisualEffectMaterialSheet")]
    pub const Sheet: Self = Self(11);
    /// The material used by opaque window backgrounds.
    #[doc(alias = "NSVisualEffectMaterialWindowBackground")]
    pub const WindowBackground: Self = Self(12);
    /// The material used as the background of heads-up display (HUD) windows.
    #[doc(alias = "NSVisualEffectMaterialHUDWindow")]
    pub const HUDWindow: Self = Self(13);
    /// The material used as the background of full-screen modal UI.
    #[doc(alias = "NSVisualEffectMaterialFullScreenUI")]
    pub const FullScreenUI: Self = Self(15);
    /// The material used as the background of tool tips.
    #[doc(alias = "NSVisualEffectMaterialToolTip")]
    pub const ToolTip: Self = Self(17);
    /// The material used as the opaque background of content (e.g., by NSScrollView, NSTableView, NSCollectionView, etc.).
    #[doc(alias = "NSVisualEffectMaterialContentBackground")]
    pub const ContentBackground: Self = Self(18);
    /// The material used under window backgrounds.
    #[doc(alias = "NSVisualEffectMaterialUnderWindowBackground")]
    pub const UnderWindowBackground: Self = Self(21);
    /// The material used as the background behind document pages.
    #[doc(alias = "NSVisualEffectMaterialUnderPageBackground")]
    pub const UnderPageBackground: Self = Self(22);
    /// A default material appropriate for the view's effectiveAppearance.  You should instead choose an appropriate semantic material.
    #[doc(alias = "NSVisualEffectMaterialAppearanceBased")]
    #[deprecated = "Use a specific semantic material instead."]
    pub const AppearanceBased: Self = Self(0);
    /// A default material appropriate for the view's effectiveAppearance.  You should instead choose an appropriate semantic material.
    #[doc(alias = "NSVisualEffectMaterialLight")]
    #[deprecated = "Use a semantic material instead.  To force the appearance of a view hierarchy, set the `appearance` property to an appropriate NSAppearance value."]
    pub const Light: Self = Self(1);
    /// A default material appropriate for the view's effectiveAppearance.  You should instead choose an appropriate semantic material.
    #[doc(alias = "NSVisualEffectMaterialDark")]
    #[deprecated = "Use a semantic material instead.  To force the appearance of a view hierarchy, set the `appearance` property to an appropriate NSAppearance value."]
    pub const Dark: Self = Self(2);
    /// A default material appropriate for the view's effectiveAppearance.  You should instead choose an appropriate semantic material.
    #[doc(alias = "NSVisualEffectMaterialMediumLight")]
    #[deprecated = "Use a semantic material instead.  To force the appearance of a view hierarchy, set the `appearance` property to an appropriate NSAppearance value."]
    pub const MediumLight: Self = Self(8);
    /// A default material appropriate for the view's effectiveAppearance.  You should instead choose an appropriate semantic material.
    #[doc(alias = "NSVisualEffectMaterialUltraDark")]
    #[deprecated = "Use a semantic material instead.  To force the appearance of a view hierarchy, set the `appearance` property to an appropriate NSAppearance value."]
    pub const UltraDark: Self = Self(9);
}

unsafe impl Encode for NSVisualEffectMaterial {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSVisualEffectMaterial {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsvisualeffectblendingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSVisualEffectBlendingMode(pub NSInteger);
impl NSVisualEffectBlendingMode {
    /// Blend with the area behind the window (such as the Desktop or other windows).
    #[doc(alias = "NSVisualEffectBlendingModeBehindWindow")]
    pub const BehindWindow: Self = Self(0);
    /// Blend with the area behind the view in the window.
    #[doc(alias = "NSVisualEffectBlendingModeWithinWindow")]
    pub const WithinWindow: Self = Self(1);
}

unsafe impl Encode for NSVisualEffectBlendingMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSVisualEffectBlendingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsvisualeffectstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSVisualEffectState(pub NSInteger);
impl NSVisualEffectState {
    /// Use the active look only when the containing window is active.
    #[doc(alias = "NSVisualEffectStateFollowsWindowActiveState")]
    pub const FollowsWindowActiveState: Self = Self(0);
    /// Use the active look always.
    #[doc(alias = "NSVisualEffectStateActive")]
    pub const Active: Self = Self(1);
    /// Use the inactive look always.
    #[doc(alias = "NSVisualEffectStateInactive")]
    pub const Inactive: Self = Self(2);
}

unsafe impl Encode for NSVisualEffectState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSVisualEffectState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsvisualeffectview?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSView"))]
    pub struct NSVisualEffectView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSVisualEffectView {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSVisualEffectView {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSVisualEffectView {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSVisualEffectView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSVisualEffectView {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSVisualEffectView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSVisualEffectView {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSVisualEffectView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSVisualEffectView {
    extern_methods!(
        /// A value indicating which material is shown by the NSVisualEffectView.  See the comments on NSVisualEffectMaterial.  Defaults to NSVisualEffectMaterialAppearanceBased.  You should instead specify an appropriate semantic material value.  See the comments on NSVisualEffectMaterial.
        #[unsafe(method(material))]
        #[unsafe(method_family = none)]
        pub unsafe fn material(&self) -> NSVisualEffectMaterial;

        /// Setter for [`material`][Self::material].
        #[unsafe(method(setMaterial:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaterial(&self, material: NSVisualEffectMaterial);

        #[cfg(feature = "NSCell")]
        /// An NSBackgroundStyle value that most closely matches the look of the material shown by the NSVisualEffectView.
        #[unsafe(method(interiorBackgroundStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn interiorBackgroundStyle(&self) -> NSBackgroundStyle;

        /// A value controlling how the NSVisualEffectView generates its material.  See the comments on NSVisualEffectBlendingMode.  Not all materials support both blending modes, so NSVisualEffectView may fall back to a more appropriate blending mode as needed.  Defaults to NSVisualEffectBlendingModeBehindWindow.
        #[unsafe(method(blendingMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn blendingMode(&self) -> NSVisualEffectBlendingMode;

        /// Setter for [`blendingMode`][Self::blendingMode].
        #[unsafe(method(setBlendingMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBlendingMode(&self, blending_mode: NSVisualEffectBlendingMode);

        /// A value controlling when the NSVisualEffectView takes on the active look.  See the comments on NSVisualEffectState.  Defaults to NSVisualEffectStateFollowsWindowActiveState.
        #[unsafe(method(state))]
        #[unsafe(method_family = none)]
        pub unsafe fn state(&self) -> NSVisualEffectState;

        /// Setter for [`state`][Self::state].
        #[unsafe(method(setState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setState(&self, state: NSVisualEffectState);

        #[cfg(feature = "NSImage")]
        /// An image whose alpha channel is used to mask the material generated by the NSVisualEffectView.  (It does not also mask subviews.)  Defaults to nil.  It is best to set this to the smallest mask image possible and properly set the image's capInsets property to stretch it.  Setting the maskImage on an NSVisualEffectView that is the contentView of a window will correctly influence the window's shadow.
        #[unsafe(method(maskImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn maskImage(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`maskImage`][Self::maskImage].
        #[unsafe(method(setMaskImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaskImage(&self, mask_image: Option<&NSImage>);

        /// When YES, the material takes on the emphasized look.  Defaults to NO.  Some, but not all, materials change their look when emphasized.  This is used to indicate that an associated view has firstResponder status.
        #[unsafe(method(isEmphasized))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEmphasized(&self) -> bool;

        /// Setter for [`isEmphasized`][Self::isEmphasized].
        #[unsafe(method(setEmphasized:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEmphasized(&self, emphasized: bool);

        #[unsafe(method(viewDidMoveToWindow))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidMoveToWindow(&self);

        #[cfg(feature = "NSWindow")]
        #[unsafe(method(viewWillMoveToWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillMoveToWindow(&self, new_window: Option<&NSWindow>);
    );
}

/// Methods declared on superclass `NSView`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSVisualEffectView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSVisualEffectView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSVisualEffectView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
