//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// `NSToolbarItemGroup` is a subclass of `NSToolbarItem` which can be used to create sets of `NSToolbarItems` that are always attached to one another and that are added, removed, or reordered as a single unit.
/// Properties that get set on the parent toolbar item, such as label or view, apply to the entire item.
/// Otherwise, the individual properties are displayed adjacent to one another.
/// Subitems will inherit the group's action if no action is defined on the subitem and will validate based on that action when autovalidates is enabled.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nstoolbaritemgroupselectionmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSToolbarItemGroupSelectionMode(pub NSInteger);
impl NSToolbarItemGroupSelectionMode {
    #[doc(alias = "NSToolbarItemGroupSelectionModeSelectOne")]
    pub const SelectOne: Self = Self(0);
    #[doc(alias = "NSToolbarItemGroupSelectionModeSelectAny")]
    pub const SelectAny: Self = Self(1);
    #[doc(alias = "NSToolbarItemGroupSelectionModeMomentary")]
    pub const Momentary: Self = Self(2);
}

unsafe impl Encode for NSToolbarItemGroupSelectionMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSToolbarItemGroupSelectionMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstoolbaritemgroupcontrolrepresentation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSToolbarItemGroupControlRepresentation(pub NSInteger);
impl NSToolbarItemGroupControlRepresentation {
    #[doc(alias = "NSToolbarItemGroupControlRepresentationAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "NSToolbarItemGroupControlRepresentationExpanded")]
    pub const Expanded: Self = Self(1);
    #[doc(alias = "NSToolbarItemGroupControlRepresentationCollapsed")]
    pub const Collapsed: Self = Self(2);
}

unsafe impl Encode for NSToolbarItemGroupControlRepresentation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSToolbarItemGroupControlRepresentation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstoolbaritemgroup?language=objc)
    #[unsafe(super(NSToolbarItem, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSToolbarItem")]
    pub struct NSToolbarItemGroup;
);

#[cfg(feature = "NSToolbarItem")]
extern_conformance!(
    unsafe impl NSCopying for NSToolbarItemGroup {}
);

#[cfg(feature = "NSToolbarItem")]
unsafe impl CopyingHelper for NSToolbarItemGroup {
    type Result = Self;
}

#[cfg(feature = "NSToolbarItem")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSToolbarItemGroup {}
);

#[cfg(feature = "NSToolbarItem")]
impl NSToolbarItemGroup {
    extern_methods!(
        #[cfg(feature = "NSToolbar")]
        /// Convenience constructors for creating segmented control based toolbar items with images or text.
        /// The item returned will have a custom view for representing the control and automatically create subitems for the group.
        /// The labels array, if not nil, will be used to provide individual labels under the item for each segment of the control.
        /// When space in the toolbar is tight, the control may switch to a smaller alternate representation as necessary to remain in the toolbar.
        #[unsafe(method(groupWithItemIdentifier:titles:selectionMode:labels:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn groupWithItemIdentifier_titles_selectionMode_labels_target_action(
            item_identifier: &NSToolbarItemIdentifier,
            titles: &NSArray<NSString>,
            selection_mode: NSToolbarItemGroupSelectionMode,
            labels: Option<&NSArray<NSString>>,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSImage", feature = "NSToolbar"))]
        #[unsafe(method(groupWithItemIdentifier:images:selectionMode:labels:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn groupWithItemIdentifier_images_selectionMode_labels_target_action(
            item_identifier: &NSToolbarItemIdentifier,
            images: &NSArray<NSImage>,
            selection_mode: NSToolbarItemGroupSelectionMode,
            labels: Option<&NSArray<NSString>>,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Set or get the array of subitems for the toolbar item.
        /// By default, a `NSToolbarItemGroup` has an empty array of subitems.
        /// You should call this to set the subitems before returning the item to the toolbar.
        /// `NSToolbarItemGroups` may not contain other `NSToolbarItemGroups` as subitems.
        #[unsafe(method(subitems))]
        #[unsafe(method_family = none)]
        pub unsafe fn subitems(&self) -> Retained<NSArray<NSToolbarItem>>;

        /// Setter for [`subitems`][Self::subitems].
        #[unsafe(method(setSubitems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSubitems(&self, subitems: &NSArray<NSToolbarItem>);

        /// The style in which this item will be represented to the user.
        /// Defaults to `NSToolbarItemGroupControlRepresentationAutomatic`.
        #[unsafe(method(controlRepresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn controlRepresentation(&self) -> NSToolbarItemGroupControlRepresentation;

        /// Setter for [`controlRepresentation`][Self::controlRepresentation].
        #[unsafe(method(setControlRepresentation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setControlRepresentation(
            &self,
            control_representation: NSToolbarItemGroupControlRepresentation,
        );

        /// Get and set how selection is handled by the control.
        /// Only applies when using one of the constructors to create the item with a system defined control representation.
        #[unsafe(method(selectionMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectionMode(&self) -> NSToolbarItemGroupSelectionMode;

        /// Setter for [`selectionMode`][Self::selectionMode].
        #[unsafe(method(setSelectionMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectionMode(&self, selection_mode: NSToolbarItemGroupSelectionMode);

        /// The most recently selected item of the group, or -1 if nothing is selected.
        #[unsafe(method(selectedIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedIndex(&self) -> NSInteger;

        /// Setter for [`selectedIndex`][Self::selectedIndex].
        #[unsafe(method(setSelectedIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectedIndex(&self, selected_index: NSInteger);

        /// Get and set selection of individual subitems of the group item.
        #[unsafe(method(setSelected:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelected_atIndex(&self, selected: bool, index: NSInteger);

        #[unsafe(method(isSelectedAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isSelectedAtIndex(&self, index: NSInteger) -> bool;
    );
}

/// Methods declared on superclass `NSToolbarItem`.
#[cfg(feature = "NSToolbarItem")]
impl NSToolbarItemGroup {
    extern_methods!(
        #[cfg(feature = "NSToolbar")]
        /// Initialize the toolbar item with an identifier which is a development language string used by the toolbar and its delegate for identification purposes.
        #[unsafe(method(initWithItemIdentifier:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithItemIdentifier(
            this: Allocated<Self>,
            item_identifier: &NSToolbarItemIdentifier,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSToolbarItem")]
impl NSToolbarItemGroup {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
