/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

class BrowserFactory {
    private Class<?> chromiumClass;

    BrowserFactory() {
    }

    WebBrowser createWebBrowser(int style) {
        WebBrowser browser = null;
        if ((style & 0x20000) != 0 && (browser = this.createChromium()) != null) {
            return browser;
        }
        if (OS.IsWin32) {
            return this.createChromium();
        }
        if (GTK.GTK4) {
            return null;
        }
        boolean webkitInstalled = WebKit.IsInstalled();
        if (!webkitInstalled && (style & 0x20000) == 0) {
            return this.createChromium();
        }
        return new WebKit();
    }

    private WebBrowser createChromium() {
        if (!OS.isX11()) {
            System.err.println("SWT.CHROMIUM style is not supported in Wayland.");
            return null;
        }
        if (this.chromiumClass == null) {
            try {
                this.chromiumClass = Class.forName("org.eclipse.swt.browser.ChromiumImpl");
                return (WebBrowser)this.chromiumClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("SWT.CHROMIUM style was used but chromium.swt fragment/jar is missing from classpath.");
            }
            catch (IllegalAccessException | InstantiationException | NoClassDefFoundError e) {
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("SWT.CHROMIUM style was used but chromium.swt " + SWT.getPlatform() + " (or CEF binaries) fragment/jar is missing.");
            }
            catch (SWTError e) {
                System.err.println(e.getMessage());
            }
        }
        return null;
    }
}

