/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;

public final class RGBA
implements Serializable {
    public final RGB rgb;
    public int alpha;
    static final long serialVersionUID = 1049467103126495855L;

    public RGBA(int red, int green, int blue, int alpha) {
        if (alpha > 255 || alpha < 0) {
            SWT.error(5);
        }
        this.rgb = new RGB(red, green, blue);
        this.alpha = alpha;
    }

    public RGBA(float hue, float saturation, float brightness, float alpha) {
        if (alpha > 255.0f || alpha < 0.0f) {
            SWT.error(5);
        }
        this.rgb = new RGB(hue, saturation, brightness);
        this.alpha = (int)((double)alpha + 0.5);
    }

    public float[] getHSBA() {
        float[] hsb = this.rgb.getHSB();
        return new float[]{hsb[0], hsb[1], hsb[2], this.alpha};
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RGBA)) {
            return false;
        }
        RGBA rgba = (RGBA)object;
        return rgba.rgb.red == this.rgb.red && rgba.rgb.green == this.rgb.green && rgba.rgb.blue == this.rgb.blue && rgba.alpha == this.alpha;
    }

    public int hashCode() {
        return this.alpha << 24 | this.rgb.blue << 16 | this.rgb.green << 8 | this.rgb.red;
    }

    public String toString() {
        return "RGBA {" + this.rgb.red + ", " + this.rgb.green + ", " + this.rgb.blue + ", " + this.alpha + "}";
    }
}

