/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation._private;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class NSReflect {
    public static byte[] className(Class clazz) {
        return clazz.getName().replace('.', '/').getBytes();
    }

    public static String typeToSignature(Class clazz) {
        String string = clazz.getName();
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.equals("void")) {
            return "V";
        }
        if (string.charAt(0) == '[') {
            return string.replace('.', '/');
        }
        return "L" + string.replace('.', '/') + ";";
    }

    public static String typeToSignature(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(NSReflect.typeToSignature(classArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int isStatic(Member member) {
        if (Modifier.isStatic(member.getModifiers())) {
            return 1;
        }
        return 0;
    }

    public static byte[] name(Member member) {
        return member.getName().getBytes();
    }

    public static byte[][] name(Member[] memberArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        while (n < memberArray.length) {
            vector.addElement(NSReflect.name(memberArray[n]));
            ++n;
        }
        if (vector.size() > 0) {
            vector.toArray();
        }
        return null;
    }

    public static byte[] signature(Field field) {
        return NSReflect.typeToSignature(field.getType()).getBytes();
    }

    public static byte[][] signature(Field[] fieldArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        while (n < fieldArray.length) {
            vector.addElement(NSReflect.signature(fieldArray[n]));
            ++n;
        }
        if (vector.size() > 0) {
            vector.toArray();
        }
        return null;
    }

    public static byte[] signature(Method method) {
        return ("(" + NSReflect.typeToSignature(method.getParameterTypes()) + ")" + NSReflect.typeToSignature(method.getReturnType())).getBytes();
    }

    public static byte[][] signature(Method[] methodArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        while (n < methodArray.length) {
            vector.addElement(NSReflect.signature(methodArray[n]));
            ++n;
        }
        if (vector.size() > 0) {
            vector.toArray();
        }
        return null;
    }

    public static byte[] signature(Constructor constructor) {
        return ("(" + NSReflect.typeToSignature(constructor.getParameterTypes()) + ")V").getBytes();
    }

    public static byte[][] signature(Constructor[] constructorArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        while (n < constructorArray.length) {
            vector.addElement(NSReflect.signature(constructorArray[n]));
            ++n;
        }
        if (vector.size() > 0) {
            vector.toArray();
        }
        return null;
    }

    public static int hasSignature(Field field, byte[] byArray) {
        if (new String(byArray).equals(NSReflect.typeToSignature(field.getType()))) {
            return 1;
        }
        return 0;
    }

    public static int hasSignature(Method method, byte[] byArray) {
        if (new String(byArray).equals("(" + NSReflect.typeToSignature(method.getParameterTypes()) + ")" + NSReflect.typeToSignature(method.getReturnType()))) {
            return 1;
        }
        return 0;
    }

    public static int hasSignature(Constructor constructor, byte[] byArray) {
        if (new String(byArray).equals("(" + NSReflect.typeToSignature(constructor.getParameterTypes()) + ")V")) {
            return 1;
        }
        return 0;
    }

    public static Field[] fieldLookup(Class clazz, int n) {
        Field[] fieldArray;
        try {
            fieldArray = clazz.getDeclaredFields();
        }
        catch (Throwable throwable) {
            return null;
        }
        Vector<Field> vector = new Vector<Field>();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if (NSReflect.isStatic(fieldArray[n2]) == n) {
                vector.addElement(fieldArray[n2]);
            }
            ++n2;
        }
        if (vector.size() > 0) {
            return (Field[])vector.toArray();
        }
        return null;
    }

    public static Field fieldLookup(Class clazz, byte[] byArray, int n, int n2) {
        Field field = null;
        String string = new String(byArray);
        if (clazz == null) {
            return null;
        }
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (Throwable throwable) {
            field = null;
        }
        if (field == null) {
            if (n == 1 || n2 == 0) {
                return null;
            }
            return NSReflect.fieldLookup(clazz.getSuperclass(), byArray, 0, 1);
        }
        if (NSReflect.isStatic(field) == n) {
            return field;
        }
        return null;
    }

    public static Method[] methodLookup(Class clazz, int n) {
        Method[] methodArray;
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            return null;
        }
        Vector<Method> vector = new Vector<Method>();
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (NSReflect.isStatic(methodArray[n2]) == n) {
                vector.addElement(methodArray[n2]);
            }
            ++n2;
        }
        if (vector.size() > 0) {
            return (Method[])vector.toArray();
        }
        return null;
    }

    public static Method methodLookup(Class clazz, byte[] byArray, int n, int n2, int n3) {
        Method method = null;
        Method[] methodArray = null;
        String string = new String(byArray);
        if (clazz == null) {
            return null;
        }
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            methodArray = null;
        }
        if (methodArray != null) {
            int n4 = 0;
            while (n4 < methodArray.length) {
                method = methodArray[n4];
                if (string.equals(method.getName()) && (n < 0 || method.getParameterTypes().length == n)) break;
                method = null;
                ++n4;
            }
        }
        if (method == null) {
            if (n2 == 1 || n3 == 0) {
                return null;
            }
            return NSReflect.methodLookup(clazz.getSuperclass(), byArray, n, 0, 1);
        }
        if (NSReflect.isStatic(method) == n2) {
            return method;
        }
        return null;
    }

    public static Constructor[] constructorLookup(Class clazz) {
        Constructor<?>[] constructorArray;
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (Throwable throwable) {
            return null;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < constructorArray.length) {
            vector.addElement(constructorArray[n]);
            ++n;
        }
        if (vector.size() > 0) {
            return (Constructor[])vector.toArray();
        }
        return null;
    }

    public static Constructor constructorLookup(Class clazz, byte[] byArray) {
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = null;
        String string = new String(byArray);
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (Throwable throwable) {
            constructorArray = null;
        }
        if (constructorArray != null) {
            int n = 0;
            while (n < constructorArray.length) {
                constructor = constructorArray[n];
                if (string.equals(constructor.getName())) break;
                constructor = null;
                ++n;
            }
        }
        if (constructor == null) {
            return NSReflect.constructorLookup(clazz.getSuperclass(), byArray);
        }
        return constructor;
    }

    public static byte[] fieldSignature(Class clazz, byte[] byArray, int n, int n2) {
        Field field = NSReflect.fieldLookup(clazz, byArray, n, n2);
        if (field != null) {
            return NSReflect.signature(field);
        }
        return "".getBytes();
    }

    public static byte[] methodSignature(Class clazz, byte[] byArray, int n, int n2) {
        Method method = NSReflect.methodLookup(clazz, byArray, -1, n, n2);
        if (method != null) {
            byte[] byArray2 = NSReflect.signature(method);
            return byArray2;
        }
        return "".getBytes();
    }

    public static byte[] methodSignature(Class clazz, byte[] byArray, int n, int n2, int n3) {
        Method method = NSReflect.methodLookup(clazz, byArray, n, n2, n3);
        if (method != null) {
            byte[] byArray2 = NSReflect.signature(method);
            return byArray2;
        }
        return "".getBytes();
    }

    public static byte[] constructorSignature(Class clazz, byte[] byArray) {
        Constructor constructor = NSReflect.constructorLookup(clazz, byArray);
        if (constructor != null) {
            return NSReflect.signature(constructor);
        }
        return "".getBytes();
    }
}

