/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import com.apple.cocoa.foundation.NSRuntime;
import com.apple.cocoa.foundation.NSSize;
import java.awt.Dimension;

public class NSMutableSize
extends NSSize {
    private int _backingSize = 0;
    private boolean _freeSize = true;

    public NSMutableSize() {
        this(0.0f, 0.0f);
    }

    public NSMutableSize(float f, float f2) {
        this._backingSize = this.privateCreateBackingSize();
        this.setWidth(f);
        this.setHeight(f2);
    }

    public NSMutableSize(NSSize nSSize) {
        this(nSSize.width(), nSSize.height());
    }

    public NSMutableSize(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    private NSMutableSize(int n) {
        this._backingSize = n;
        this._freeSize = false;
    }

    protected void finalize() {
        if (this._freeSize && this._backingSize != 0) {
            this.privateDestroyBackingSize(this._backingSize);
        }
    }

    public float width() {
        return this.privateWidth(this._backingSize);
    }

    public float height() {
        return this.privateHeight(this._backingSize);
    }

    public void setWidth(float f) {
        if (f != f) {
            throw new IllegalArgumentException("cannot set NaN width");
        }
        this.privateSetWidth(this._backingSize, 0.0f == f ? 0.0f : f);
    }

    public void setHeight(float f) {
        if (f != f) {
            throw new IllegalArgumentException("cannot set NaN height");
        }
        this.privateSetHeight(this._backingSize, 0.0f == f ? 0.0f : f);
    }

    public Object clone() {
        return new NSMutableSize(this);
    }

    private native int privateCreateBackingSize();

    private native void privateDestroyBackingSize(int var1);

    private native float privateWidth(int var1);

    private native float privateHeight(int var1);

    private native void privateSetWidth(int var1, float var2);

    private native void privateSetHeight(int var1, float var2);

    static {
        NSRuntime.loadLibrary("ObjCJava");
        NSRuntime.loadLibrary("FoundationJava");
    }
}

