/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.CHOOSECOLOR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    static final int CUSTOM_COLOR_COUNT = 16;
    RGB rgb;
    RGB[] rgbs;
    int[] colors = new int[16];

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    long CCHookProc(long hdlg, long uiMsg, long lParam, long lpData) {
        switch ((int)uiMsg) {
            case 272: {
                if (this.title == null || this.title.length() == 0) break;
                TCHAR buffer = new TCHAR(0, this.title, true);
                OS.SetWindowText(hdlg, buffer);
            }
        }
        return 0L;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        long hwndOwner = this.parent.handle;
        long hwndParent = this.parent.handle;
        boolean enabled = false;
        int dialogOrientation = this.style & 0x6000000;
        int parentOrientation = this.parent.style & 0x6000000;
        if (dialogOrientation != parentOrientation) {
            int exStyle = 0x100000;
            if (dialogOrientation == 0x4000000) {
                exStyle |= 0x400000;
            }
            hwndOwner = OS.CreateWindowEx(exStyle, Shell.DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, hwndParent, 0L, OS.GetModuleHandle(null), null);
            enabled = OS.IsWindowEnabled(hwndParent);
            if (enabled) {
                OS.EnableWindow(hwndParent, false);
            }
        }
        Callback callback = new Callback(this, "CCHookProc", 4);
        long lpfnHook = callback.getAddress();
        Display display = this.parent.display;
        if (display.lpCustColors == 0L) {
            long hHeap = OS.GetProcessHeap();
            display.lpCustColors = OS.HeapAlloc(hHeap, 8, 64);
            for (int i = 0; i < 16; ++i) {
                this.colors[i] = 0xFFFFFF;
            }
            OS.MoveMemory(display.lpCustColors, this.colors, 64);
        }
        if (this.rgbs != null) {
            int i;
            int length = this.rgbs.length > 16 ? 16 : this.rgbs.length;
            for (i = 0; i < length; ++i) {
                RGB rgb = this.rgbs[i];
                int red = rgb.red & 0xFF;
                int green = rgb.green << 8 & 0xFF00;
                int blue = rgb.blue << 16 & 0xFF0000;
                this.colors[i] = red | green | blue;
            }
            for (i = length; i < 16; ++i) {
                this.colors[i] = 0xFFFFFF;
            }
            OS.MoveMemory(display.lpCustColors, this.colors, 64);
        }
        CHOOSECOLOR lpcc = new CHOOSECOLOR();
        lpcc.lStructSize = CHOOSECOLOR.sizeof;
        lpcc.Flags = 272;
        lpcc.lpfnHook = lpfnHook;
        lpcc.hwndOwner = hwndOwner;
        lpcc.lpCustColors = display.lpCustColors;
        if (this.rgb != null) {
            lpcc.Flags |= 1;
            int red = this.rgb.red & 0xFF;
            int green = this.rgb.green << 8 & 0xFF00;
            int blue = this.rgb.blue << 16 & 0xFF0000;
            lpcc.rgbResult = red | green | blue;
        }
        Dialog oldModal = null;
        if ((this.style & 0x30000) != 0) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        display.externalEventLoop = true;
        display.sendPreExternalEventDispatchEvent();
        boolean success = OS.ChooseColor(lpcc);
        display.externalEventLoop = false;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x30000) != 0) {
            display.setModalDialog(oldModal);
        }
        boolean customColor = false;
        OS.MoveMemory(this.colors, display.lpCustColors, this.colors.length * 4);
        for (int color : this.colors) {
            if (color == 0xFFFFFF) continue;
            customColor = true;
            break;
        }
        if (customColor) {
            this.rgbs = new RGB[16];
            for (int i = 0; i < this.colors.length; ++i) {
                int color = this.colors[i];
                int red = color & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color >> 16 & 0xFF;
                this.rgbs[i] = new RGB(red, green, blue);
            }
        }
        if (success) {
            int red = lpcc.rgbResult & 0xFF;
            int green = lpcc.rgbResult >> 8 & 0xFF;
            int blue = lpcc.rgbResult >> 16 & 0xFF;
            this.rgb = new RGB(red, green, blue);
        }
        callback.dispose();
        if (hwndParent != hwndOwner) {
            if (enabled) {
                OS.EnableWindow(hwndParent, true);
            }
            OS.SetActiveWindow(hwndParent);
            OS.DestroyWindow(hwndOwner);
        }
        if (!success) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    public void setRGBs(RGB[] rgbs) {
        if (rgbs != null) {
            for (RGB rgb : rgbs) {
                if (rgb != null) continue;
                this.error(5);
            }
        }
        this.rgbs = rgbs;
    }
}

