//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/api/v2/auth/common.proto

package auth

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on TlsParameters with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TlsParameters) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TlsParameters with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TlsParametersMultiError, or
// nil if none found.
func (m *TlsParameters) ValidateAll() error {
	return m.validate(true)
}

func (m *TlsParameters) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := TlsParameters_TlsProtocol_name[int32(m.GetTlsMinimumProtocolVersion())]; !ok {
		err := TlsParametersValidationError{
			field:  "TlsMinimumProtocolVersion",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := TlsParameters_TlsProtocol_name[int32(m.GetTlsMaximumProtocolVersion())]; !ok {
		err := TlsParametersValidationError{
			field:  "TlsMaximumProtocolVersion",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return TlsParametersMultiError(errors)
	}

	return nil
}

// TlsParametersMultiError is an error wrapping multiple validation errors
// returned by TlsParameters.ValidateAll() if the designated constraints
// aren't met.
type TlsParametersMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TlsParametersMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TlsParametersMultiError) AllErrors() []error { return m }

// TlsParametersValidationError is the validation error returned by
// TlsParameters.Validate if the designated constraints aren't met.
type TlsParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TlsParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TlsParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TlsParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TlsParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TlsParametersValidationError) ErrorName() string { return "TlsParametersValidationError" }

// Error satisfies the builtin error interface
func (e TlsParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTlsParameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TlsParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TlsParametersValidationError{}

// Validate checks the field values on PrivateKeyProvider with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *PrivateKeyProvider) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PrivateKeyProvider with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// PrivateKeyProviderMultiError, or nil if none found.
func (m *PrivateKeyProvider) ValidateAll() error {
	return m.validate(true)
}

func (m *PrivateKeyProvider) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetProviderName()) < 1 {
		err := PrivateKeyProviderValidationError{
			field:  "ProviderName",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *PrivateKeyProvider_Config:
		if v == nil {
			err := PrivateKeyProviderValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PrivateKeyProviderValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PrivateKeyProviderValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PrivateKeyProviderValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *PrivateKeyProvider_TypedConfig:
		if v == nil {
			err := PrivateKeyProviderValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, PrivateKeyProviderValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, PrivateKeyProviderValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return PrivateKeyProviderValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return PrivateKeyProviderMultiError(errors)
	}

	return nil
}

// PrivateKeyProviderMultiError is an error wrapping multiple validation errors
// returned by PrivateKeyProvider.ValidateAll() if the designated constraints
// aren't met.
type PrivateKeyProviderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PrivateKeyProviderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PrivateKeyProviderMultiError) AllErrors() []error { return m }

// PrivateKeyProviderValidationError is the validation error returned by
// PrivateKeyProvider.Validate if the designated constraints aren't met.
type PrivateKeyProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PrivateKeyProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PrivateKeyProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PrivateKeyProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PrivateKeyProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PrivateKeyProviderValidationError) ErrorName() string {
	return "PrivateKeyProviderValidationError"
}

// Error satisfies the builtin error interface
func (e PrivateKeyProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPrivateKeyProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PrivateKeyProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PrivateKeyProviderValidationError{}

// Validate checks the field values on TlsCertificate with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TlsCertificate) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TlsCertificate with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TlsCertificateMultiError,
// or nil if none found.
func (m *TlsCertificate) ValidateAll() error {
	return m.validate(true)
}

func (m *TlsCertificate) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetCertificateChain()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "CertificateChain",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "CertificateChain",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCertificateChain()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TlsCertificateValidationError{
				field:  "CertificateChain",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPrivateKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "PrivateKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "PrivateKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPrivateKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TlsCertificateValidationError{
				field:  "PrivateKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPrivateKeyProvider()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "PrivateKeyProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "PrivateKeyProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPrivateKeyProvider()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TlsCertificateValidationError{
				field:  "PrivateKeyProvider",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPassword()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "Password",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "Password",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPassword()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TlsCertificateValidationError{
				field:  "Password",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOcspStaple()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "OcspStaple",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TlsCertificateValidationError{
					field:  "OcspStaple",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOcspStaple()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TlsCertificateValidationError{
				field:  "OcspStaple",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetSignedCertificateTimestamp() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TlsCertificateValidationError{
						field:  fmt.Sprintf("SignedCertificateTimestamp[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TlsCertificateValidationError{
						field:  fmt.Sprintf("SignedCertificateTimestamp[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TlsCertificateValidationError{
					field:  fmt.Sprintf("SignedCertificateTimestamp[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return TlsCertificateMultiError(errors)
	}

	return nil
}

// TlsCertificateMultiError is an error wrapping multiple validation errors
// returned by TlsCertificate.ValidateAll() if the designated constraints
// aren't met.
type TlsCertificateMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TlsCertificateMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TlsCertificateMultiError) AllErrors() []error { return m }

// TlsCertificateValidationError is the validation error returned by
// TlsCertificate.Validate if the designated constraints aren't met.
type TlsCertificateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TlsCertificateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TlsCertificateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TlsCertificateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TlsCertificateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TlsCertificateValidationError) ErrorName() string { return "TlsCertificateValidationError" }

// Error satisfies the builtin error interface
func (e TlsCertificateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTlsCertificate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TlsCertificateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TlsCertificateValidationError{}

// Validate checks the field values on TlsSessionTicketKeys with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TlsSessionTicketKeys) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TlsSessionTicketKeys with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TlsSessionTicketKeysMultiError, or nil if none found.
func (m *TlsSessionTicketKeys) ValidateAll() error {
	return m.validate(true)
}

func (m *TlsSessionTicketKeys) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetKeys()) < 1 {
		err := TlsSessionTicketKeysValidationError{
			field:  "Keys",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetKeys() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TlsSessionTicketKeysValidationError{
						field:  fmt.Sprintf("Keys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TlsSessionTicketKeysValidationError{
						field:  fmt.Sprintf("Keys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TlsSessionTicketKeysValidationError{
					field:  fmt.Sprintf("Keys[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return TlsSessionTicketKeysMultiError(errors)
	}

	return nil
}

// TlsSessionTicketKeysMultiError is an error wrapping multiple validation
// errors returned by TlsSessionTicketKeys.ValidateAll() if the designated
// constraints aren't met.
type TlsSessionTicketKeysMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TlsSessionTicketKeysMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TlsSessionTicketKeysMultiError) AllErrors() []error { return m }

// TlsSessionTicketKeysValidationError is the validation error returned by
// TlsSessionTicketKeys.Validate if the designated constraints aren't met.
type TlsSessionTicketKeysValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TlsSessionTicketKeysValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TlsSessionTicketKeysValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TlsSessionTicketKeysValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TlsSessionTicketKeysValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TlsSessionTicketKeysValidationError) ErrorName() string {
	return "TlsSessionTicketKeysValidationError"
}

// Error satisfies the builtin error interface
func (e TlsSessionTicketKeysValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTlsSessionTicketKeys.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TlsSessionTicketKeysValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TlsSessionTicketKeysValidationError{}

// Validate checks the field values on CertificateValidationContext with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *CertificateValidationContext) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CertificateValidationContext with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CertificateValidationContextMultiError, or nil if none found.
func (m *CertificateValidationContext) ValidateAll() error {
	return m.validate(true)
}

func (m *CertificateValidationContext) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTrustedCa()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CertificateValidationContextValidationError{
					field:  "TrustedCa",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CertificateValidationContextValidationError{
					field:  "TrustedCa",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTrustedCa()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CertificateValidationContextValidationError{
				field:  "TrustedCa",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetVerifyCertificateSpki() {
		_, _ = idx, item

		if len(item) != 44 {
			err := CertificateValidationContextValidationError{
				field:  fmt.Sprintf("VerifyCertificateSpki[%v]", idx),
				reason: "value length must be 44 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	for idx, item := range m.GetVerifyCertificateHash() {
		_, _ = idx, item

		if l := len(item); l < 64 || l > 95 {
			err := CertificateValidationContextValidationError{
				field:  fmt.Sprintf("VerifyCertificateHash[%v]", idx),
				reason: "value length must be between 64 and 95 bytes, inclusive",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	for idx, item := range m.GetMatchSubjectAltNames() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CertificateValidationContextValidationError{
						field:  fmt.Sprintf("MatchSubjectAltNames[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CertificateValidationContextValidationError{
						field:  fmt.Sprintf("MatchSubjectAltNames[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CertificateValidationContextValidationError{
					field:  fmt.Sprintf("MatchSubjectAltNames[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetRequireOcspStaple()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CertificateValidationContextValidationError{
					field:  "RequireOcspStaple",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CertificateValidationContextValidationError{
					field:  "RequireOcspStaple",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRequireOcspStaple()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CertificateValidationContextValidationError{
				field:  "RequireOcspStaple",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRequireSignedCertificateTimestamp()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CertificateValidationContextValidationError{
					field:  "RequireSignedCertificateTimestamp",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CertificateValidationContextValidationError{
					field:  "RequireSignedCertificateTimestamp",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRequireSignedCertificateTimestamp()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CertificateValidationContextValidationError{
				field:  "RequireSignedCertificateTimestamp",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCrl()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CertificateValidationContextValidationError{
					field:  "Crl",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CertificateValidationContextValidationError{
					field:  "Crl",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCrl()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CertificateValidationContextValidationError{
				field:  "Crl",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for AllowExpiredCertificate

	if _, ok := CertificateValidationContext_TrustChainVerification_name[int32(m.GetTrustChainVerification())]; !ok {
		err := CertificateValidationContextValidationError{
			field:  "TrustChainVerification",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return CertificateValidationContextMultiError(errors)
	}

	return nil
}

// CertificateValidationContextMultiError is an error wrapping multiple
// validation errors returned by CertificateValidationContext.ValidateAll() if
// the designated constraints aren't met.
type CertificateValidationContextMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CertificateValidationContextMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CertificateValidationContextMultiError) AllErrors() []error { return m }

// CertificateValidationContextValidationError is the validation error returned
// by CertificateValidationContext.Validate if the designated constraints
// aren't met.
type CertificateValidationContextValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CertificateValidationContextValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CertificateValidationContextValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CertificateValidationContextValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CertificateValidationContextValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CertificateValidationContextValidationError) ErrorName() string {
	return "CertificateValidationContextValidationError"
}

// Error satisfies the builtin error interface
func (e CertificateValidationContextValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCertificateValidationContext.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CertificateValidationContextValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CertificateValidationContextValidationError{}
