"""
Regression tests for Django built-in views.
"""

from django.db import models


class Author(models.Model):
    name = models.CharField(max_length=100)

    def get_absolute_url(self):
        return "/authors/%s/" % self.id


class BaseArticle(models.Model):
    """
    An abstract article Model so that we can create article models with and
    without a get_absolute_url method (for create_update generic views tests).
    """

    title = models.CharField(max_length=100)
    slug = models.SlugField()
    author = models.ForeignKey(Author, models.CASCADE)

    class Meta:
        abstract = True


class Article(BaseArticle):
    date_created = models.DateTimeField()


class UrlArticle(BaseArticle):
    """
    An Article class with a get_absolute_url defined.
    """

    date_created = models.DateTimeField()

    def get_absolute_url(self):
        return "/urlarticles/%s/" % self.slug

    get_absolute_url.purge = True


class DateArticle(BaseArticle):
    """
    An article Model with a DateField instead of DateTimeField,
    for testing #7602
    """

    date_created = models.DateField()
