// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple arm64-none-linux-gnu -target-feature +neon -target-feature +fullfp16 -target-feature +v8.2a\
// RUN: -flax-vector-conversions=none -disable-O0-optnone -emit-llvm -o - %s \
// RUN: | opt -S -passes=mem2reg,sroa \
// RUN: | FileCheck --check-prefix=UNCONSTRAINED %s
// RUN: %clang_cc1 -triple arm64-none-linux-gnu -target-feature +neon -target-feature +fullfp16 -target-feature +v8.2a\
// RUN: -ffp-exception-behavior=maytrap -DEXCEPT=1 \
// RUN: -flax-vector-conversions=none -disable-O0-optnone -emit-llvm -o - %s \
// RUN: | opt -S -passes=mem2reg,sroa \
// RUN: | FileCheck --check-prefix=CONSTRAINED --implicit-check-not=fpexcept.maytrap %s

// REQUIRES: aarch64-registered-target

// Test that the constrained intrinsics are picking up the exception
// metadata from the AST instead of the global default from the command line.
// Any cases of "fpexcept.maytrap" in this test are clang bugs.

#if EXCEPT
#pragma float_control(except, on)
#endif

#include <arm_neon.h>

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vsqrt_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]]) #[[ATTR0:[0-9]+]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x i8> [[TMP1]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[VSQRT_I:%.*]] = call <4 x half> @llvm.sqrt.v4f16(<4 x half> [[TMP2]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[VSQRT_I]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vsqrt_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]]) #[[ATTR0:[0-9]+]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x i8> [[TMP1]] to <4 x half>
// CONSTRAINED-NEXT:    [[VSQRT_I:%.*]] = call <4 x half> @llvm.experimental.constrained.sqrt.v4f16(<4 x half> [[TMP2]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2:[0-9]+]]
// CONSTRAINED-NEXT:    ret <4 x half> [[VSQRT_I]]
//
float16x4_t test_vsqrt_f16(float16x4_t a) {
  return vsqrt_f16(a);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vsqrtq_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[TMP1]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[VSQRT_I:%.*]] = call <8 x half> @llvm.sqrt.v8f16(<8 x half> [[TMP2]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[VSQRT_I]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vsqrtq_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[TMP1]] to <8 x half>
// CONSTRAINED-NEXT:    [[VSQRT_I:%.*]] = call <8 x half> @llvm.experimental.constrained.sqrt.v8f16(<8 x half> [[TMP2]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[VSQRT_I]]
//
float16x8_t test_vsqrtq_f16(float16x8_t a) {
  return vsqrtq_f16(a);
}

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vfma_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.fma.v4f16(<4 x half> [[TMP7]], <4 x half> [[TMP8]], <4 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vfma_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.experimental.constrained.fma.v4f16(<4 x half> [[TMP7]], <4 x half> [[TMP8]], <4 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
float16x4_t test_vfma_f16(float16x4_t a, float16x4_t b, float16x4_t c) {
  return vfma_f16(a, b, c);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmaq_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[TMP7]], <8 x half> [[TMP8]], <8 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmaq_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> [[TMP7]], <8 x half> [[TMP8]], <8 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
float16x8_t test_vfmaq_f16(float16x8_t a, float16x8_t b, float16x8_t c) {
  return vfmaq_f16(a, b, c);
}

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vfms_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[FNEG_I:%.*]] = fneg <4 x half> [[B]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[FNEG_I]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.fma.v4f16(<4 x half> [[TMP7]], <4 x half> [[TMP8]], <4 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vfms_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[FNEG_I:%.*]] = fneg <4 x half> [[B]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[FNEG_I]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.experimental.constrained.fma.v4f16(<4 x half> [[TMP7]], <4 x half> [[TMP8]], <4 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
float16x4_t test_vfms_f16(float16x4_t a, float16x4_t b, float16x4_t c) {
  return vfms_f16(a, b, c);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmsq_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[FNEG_I:%.*]] = fneg <8 x half> [[B]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[FNEG_I]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[TMP7]], <8 x half> [[TMP8]], <8 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmsq_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[FNEG_I:%.*]] = fneg <8 x half> [[B]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[FNEG_I]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> [[TMP7]], <8 x half> [[TMP8]], <8 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
float16x8_t test_vfmsq_f16(float16x8_t a, float16x8_t b, float16x8_t c) {
  return vfmsq_f16(a, b, c);
}

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vfma_lane_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <4 x half> [[TMP6]], <4 x half> [[TMP6]], <4 x i32> <i32 3, i32 3, i32 3, i32 3>
// UNCONSTRAINED-NEXT:    [[FMLA:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[FMLA1:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[FMLA2:%.*]] = call <4 x half> @llvm.fma.v4f16(<4 x half> [[FMLA]], <4 x half> [[LANE]], <4 x half> [[FMLA1]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[FMLA2]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vfma_lane_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <4 x half> [[TMP6]], <4 x half> [[TMP6]], <4 x i32> <i32 3, i32 3, i32 3, i32 3>
// CONSTRAINED-NEXT:    [[FMLA:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CONSTRAINED-NEXT:    [[FMLA1:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// CONSTRAINED-NEXT:    [[FMLA2:%.*]] = call <4 x half> @llvm.experimental.constrained.fma.v4f16(<4 x half> [[FMLA]], <4 x half> [[LANE]], <4 x half> [[FMLA1]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <4 x half> [[FMLA2]]
//
float16x4_t test_vfma_lane_f16(float16x4_t a, float16x4_t b, float16x4_t c) {
  return vfma_lane_f16(a, b, c, 3);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmaq_lane_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <4 x half> [[TMP6]], <4 x half> [[TMP6]], <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
// UNCONSTRAINED-NEXT:    [[FMLA:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[FMLA1:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[FMLA2:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[FMLA]], <8 x half> [[LANE]], <8 x half> [[FMLA1]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[FMLA2]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmaq_lane_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <4 x half> [[TMP6]], <4 x half> [[TMP6]], <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
// CONSTRAINED-NEXT:    [[FMLA:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CONSTRAINED-NEXT:    [[FMLA1:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// CONSTRAINED-NEXT:    [[FMLA2:%.*]] = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> [[FMLA]], <8 x half> [[LANE]], <8 x half> [[FMLA1]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[FMLA2]]
//
float16x8_t test_vfmaq_lane_f16(float16x8_t a, float16x8_t b, float16x4_t c) {
  return vfmaq_lane_f16(a, b, c, 3);
}

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vfma_laneq_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <8 x half> [[TMP8]], <8 x half> [[TMP8]], <4 x i32> <i32 7, i32 7, i32 7, i32 7>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.fma.v4f16(<4 x half> [[LANE]], <4 x half> [[TMP7]], <4 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vfma_laneq_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <8 x half> [[TMP8]], <8 x half> [[TMP8]], <4 x i32> <i32 7, i32 7, i32 7, i32 7>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.experimental.constrained.fma.v4f16(<4 x half> [[LANE]], <4 x half> [[TMP7]], <4 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
float16x4_t test_vfma_laneq_f16(float16x4_t a, float16x4_t b, float16x8_t c) {
  return vfma_laneq_f16(a, b, c, 7);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmaq_laneq_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <8 x half> [[TMP8]], <8 x half> [[TMP8]], <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[LANE]], <8 x half> [[TMP7]], <8 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmaq_laneq_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <8 x half> [[TMP8]], <8 x half> [[TMP8]], <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> [[LANE]], <8 x half> [[TMP7]], <8 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
float16x8_t test_vfmaq_laneq_f16(float16x8_t a, float16x8_t b, float16x8_t c) {
  return vfmaq_laneq_f16(a, b, c, 7);
}

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vfma_n_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], half noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[C]], i32 0
// UNCONSTRAINED-NEXT:    [[VECINIT1:%.*]] = insertelement <4 x half> [[VECINIT]], half [[C]], i32 1
// UNCONSTRAINED-NEXT:    [[VECINIT2:%.*]] = insertelement <4 x half> [[VECINIT1]], half [[C]], i32 2
// UNCONSTRAINED-NEXT:    [[VECINIT3:%.*]] = insertelement <4 x half> [[VECINIT2]], half [[C]], i32 3
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[VECINIT3]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.fma.v4f16(<4 x half> [[TMP7]], <4 x half> [[TMP8]], <4 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vfma_n_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], half noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[C]], i32 0
// CONSTRAINED-NEXT:    [[VECINIT1:%.*]] = insertelement <4 x half> [[VECINIT]], half [[C]], i32 1
// CONSTRAINED-NEXT:    [[VECINIT2:%.*]] = insertelement <4 x half> [[VECINIT1]], half [[C]], i32 2
// CONSTRAINED-NEXT:    [[VECINIT3:%.*]] = insertelement <4 x half> [[VECINIT2]], half [[C]], i32 3
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[VECINIT3]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.experimental.constrained.fma.v4f16(<4 x half> [[TMP7]], <4 x half> [[TMP8]], <4 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
float16x4_t test_vfma_n_f16(float16x4_t a, float16x4_t b, float16_t c) {
  return vfma_n_f16(a, b, c);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmaq_n_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], half noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[C]], i32 0
// UNCONSTRAINED-NEXT:    [[VECINIT1:%.*]] = insertelement <8 x half> [[VECINIT]], half [[C]], i32 1
// UNCONSTRAINED-NEXT:    [[VECINIT2:%.*]] = insertelement <8 x half> [[VECINIT1]], half [[C]], i32 2
// UNCONSTRAINED-NEXT:    [[VECINIT3:%.*]] = insertelement <8 x half> [[VECINIT2]], half [[C]], i32 3
// UNCONSTRAINED-NEXT:    [[VECINIT4:%.*]] = insertelement <8 x half> [[VECINIT3]], half [[C]], i32 4
// UNCONSTRAINED-NEXT:    [[VECINIT5:%.*]] = insertelement <8 x half> [[VECINIT4]], half [[C]], i32 5
// UNCONSTRAINED-NEXT:    [[VECINIT6:%.*]] = insertelement <8 x half> [[VECINIT5]], half [[C]], i32 6
// UNCONSTRAINED-NEXT:    [[VECINIT7:%.*]] = insertelement <8 x half> [[VECINIT6]], half [[C]], i32 7
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[VECINIT7]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[TMP7]], <8 x half> [[TMP8]], <8 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmaq_n_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], half noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[C]], i32 0
// CONSTRAINED-NEXT:    [[VECINIT1:%.*]] = insertelement <8 x half> [[VECINIT]], half [[C]], i32 1
// CONSTRAINED-NEXT:    [[VECINIT2:%.*]] = insertelement <8 x half> [[VECINIT1]], half [[C]], i32 2
// CONSTRAINED-NEXT:    [[VECINIT3:%.*]] = insertelement <8 x half> [[VECINIT2]], half [[C]], i32 3
// CONSTRAINED-NEXT:    [[VECINIT4:%.*]] = insertelement <8 x half> [[VECINIT3]], half [[C]], i32 4
// CONSTRAINED-NEXT:    [[VECINIT5:%.*]] = insertelement <8 x half> [[VECINIT4]], half [[C]], i32 5
// CONSTRAINED-NEXT:    [[VECINIT6:%.*]] = insertelement <8 x half> [[VECINIT5]], half [[C]], i32 6
// CONSTRAINED-NEXT:    [[VECINIT7:%.*]] = insertelement <8 x half> [[VECINIT6]], half [[C]], i32 7
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[VECINIT7]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> [[TMP7]], <8 x half> [[TMP8]], <8 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
float16x8_t test_vfmaq_n_f16(float16x8_t a, float16x8_t b, float16_t c) {
  return vfmaq_n_f16(a, b, c);
}

// UNCONSTRAINED-LABEL: define dso_local half @test_vfmah_lane_f16(
// UNCONSTRAINED-SAME: half noundef [[A:%.*]], half noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[EXTRACT:%.*]] = extractelement <4 x half> [[C]], i32 3
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = call half @llvm.fma.f16(half [[B]], half [[EXTRACT]], half [[A]])
// UNCONSTRAINED-NEXT:    ret half [[TMP0]]
//
// CONSTRAINED-LABEL: define dso_local half @test_vfmah_lane_f16(
// CONSTRAINED-SAME: half noundef [[A:%.*]], half noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[EXTRACT:%.*]] = extractelement <4 x half> [[C]], i32 3
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = call half @llvm.experimental.constrained.fma.f16(half [[B]], half [[EXTRACT]], half [[A]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret half [[TMP0]]
//
float16_t test_vfmah_lane_f16(float16_t a, float16_t b, float16x4_t c) {
  return vfmah_lane_f16(a, b, c, 3);
}

// UNCONSTRAINED-LABEL: define dso_local half @test_vfmah_laneq_f16(
// UNCONSTRAINED-SAME: half noundef [[A:%.*]], half noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[EXTRACT:%.*]] = extractelement <8 x half> [[C]], i32 7
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = call half @llvm.fma.f16(half [[B]], half [[EXTRACT]], half [[A]])
// UNCONSTRAINED-NEXT:    ret half [[TMP0]]
//
// CONSTRAINED-LABEL: define dso_local half @test_vfmah_laneq_f16(
// CONSTRAINED-SAME: half noundef [[A:%.*]], half noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[EXTRACT:%.*]] = extractelement <8 x half> [[C]], i32 7
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = call half @llvm.experimental.constrained.fma.f16(half [[B]], half [[EXTRACT]], half [[A]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret half [[TMP0]]
//
float16_t test_vfmah_laneq_f16(float16_t a, float16_t b, float16x8_t c) {
  return vfmah_laneq_f16(a, b, c, 7);
}

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vfms_lane_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <4 x half> [[B]]
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[FNEG]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <4 x half> [[TMP6]], <4 x half> [[TMP6]], <4 x i32> <i32 3, i32 3, i32 3, i32 3>
// UNCONSTRAINED-NEXT:    [[FMLA:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[FMLA1:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[FMLA2:%.*]] = call <4 x half> @llvm.fma.v4f16(<4 x half> [[FMLA]], <4 x half> [[LANE]], <4 x half> [[FMLA1]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[FMLA2]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vfms_lane_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <4 x half> [[B]]
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[FNEG]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <4 x half> [[TMP6]], <4 x half> [[TMP6]], <4 x i32> <i32 3, i32 3, i32 3, i32 3>
// CONSTRAINED-NEXT:    [[FMLA:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CONSTRAINED-NEXT:    [[FMLA1:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// CONSTRAINED-NEXT:    [[FMLA2:%.*]] = call <4 x half> @llvm.experimental.constrained.fma.v4f16(<4 x half> [[FMLA]], <4 x half> [[LANE]], <4 x half> [[FMLA1]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <4 x half> [[FMLA2]]
//
float16x4_t test_vfms_lane_f16(float16x4_t a, float16x4_t b, float16x4_t c) {
  return vfms_lane_f16(a, b, c, 3);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmsq_lane_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <8 x half> [[B]]
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[FNEG]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <4 x half> [[TMP6]], <4 x half> [[TMP6]], <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
// UNCONSTRAINED-NEXT:    [[FMLA:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[FMLA1:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[FMLA2:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[FMLA]], <8 x half> [[LANE]], <8 x half> [[FMLA1]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[FMLA2]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmsq_lane_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <8 x half> [[B]]
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[FNEG]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <4 x half> [[TMP6]], <4 x half> [[TMP6]], <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
// CONSTRAINED-NEXT:    [[FMLA:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CONSTRAINED-NEXT:    [[FMLA1:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// CONSTRAINED-NEXT:    [[FMLA2:%.*]] = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> [[FMLA]], <8 x half> [[LANE]], <8 x half> [[FMLA1]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[FMLA2]]
//
float16x8_t test_vfmsq_lane_f16(float16x8_t a, float16x8_t b, float16x4_t c) {
  return vfmsq_lane_f16(a, b, c, 3);
}

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vfms_laneq_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <4 x half> [[B]]
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[FNEG]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <8 x half> [[TMP8]], <8 x half> [[TMP8]], <4 x i32> <i32 7, i32 7, i32 7, i32 7>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.fma.v4f16(<4 x half> [[LANE]], <4 x half> [[TMP7]], <4 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vfms_laneq_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <4 x half> [[B]]
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[FNEG]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <8 x half> [[TMP8]], <8 x half> [[TMP8]], <4 x i32> <i32 7, i32 7, i32 7, i32 7>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.experimental.constrained.fma.v4f16(<4 x half> [[LANE]], <4 x half> [[TMP7]], <4 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
float16x4_t test_vfms_laneq_f16(float16x4_t a, float16x4_t b, float16x8_t c) {
  return vfms_laneq_f16(a, b, c, 7);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmsq_laneq_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <8 x half> [[B]]
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[FNEG]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <8 x half> [[TMP8]], <8 x half> [[TMP8]], <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[LANE]], <8 x half> [[TMP7]], <8 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmsq_laneq_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <8 x half> [[B]]
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[FNEG]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CONSTRAINED-NEXT:    [[LANE:%.*]] = shufflevector <8 x half> [[TMP8]], <8 x half> [[TMP8]], <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> [[LANE]], <8 x half> [[TMP7]], <8 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
float16x8_t test_vfmsq_laneq_f16(float16x8_t a, float16x8_t b, float16x8_t c) {
  return vfmsq_laneq_f16(a, b, c, 7);
}

// UNCONSTRAINED-LABEL: define dso_local <4 x half> @test_vfms_n_f16(
// UNCONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], half noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <4 x half> [[B]]
// UNCONSTRAINED-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[C]], i32 0
// UNCONSTRAINED-NEXT:    [[VECINIT1:%.*]] = insertelement <4 x half> [[VECINIT]], half [[C]], i32 1
// UNCONSTRAINED-NEXT:    [[VECINIT2:%.*]] = insertelement <4 x half> [[VECINIT1]], half [[C]], i32 2
// UNCONSTRAINED-NEXT:    [[VECINIT3:%.*]] = insertelement <4 x half> [[VECINIT2]], half [[C]], i32 3
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[FNEG]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[VECINIT3]] to <4 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.fma.v4f16(<4 x half> [[TMP7]], <4 x half> [[TMP8]], <4 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <4 x half> @test_vfms_n_f16(
// CONSTRAINED-SAME: <4 x half> noundef [[A:%.*]], <4 x half> noundef [[B:%.*]], half noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <4 x half> [[B]]
// CONSTRAINED-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[C]], i32 0
// CONSTRAINED-NEXT:    [[VECINIT1:%.*]] = insertelement <4 x half> [[VECINIT]], half [[C]], i32 1
// CONSTRAINED-NEXT:    [[VECINIT2:%.*]] = insertelement <4 x half> [[VECINIT1]], half [[C]], i32 2
// CONSTRAINED-NEXT:    [[VECINIT3:%.*]] = insertelement <4 x half> [[VECINIT2]], half [[C]], i32 3
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[A]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[FNEG]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[VECINIT3]] to <4 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[TMP0]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <4 x half> @llvm.experimental.constrained.fma.v4f16(<4 x half> [[TMP7]], <4 x half> [[TMP8]], <4 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <4 x half> [[TMP9]]
//
float16x4_t test_vfms_n_f16(float16x4_t a, float16x4_t b, float16_t c) {
  return vfms_n_f16(a, b, c);
}

// UNCONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmsq_n_f16(
// UNCONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], half noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <8 x half> [[B]]
// UNCONSTRAINED-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[C]], i32 0
// UNCONSTRAINED-NEXT:    [[VECINIT1:%.*]] = insertelement <8 x half> [[VECINIT]], half [[C]], i32 1
// UNCONSTRAINED-NEXT:    [[VECINIT2:%.*]] = insertelement <8 x half> [[VECINIT1]], half [[C]], i32 2
// UNCONSTRAINED-NEXT:    [[VECINIT3:%.*]] = insertelement <8 x half> [[VECINIT2]], half [[C]], i32 3
// UNCONSTRAINED-NEXT:    [[VECINIT4:%.*]] = insertelement <8 x half> [[VECINIT3]], half [[C]], i32 4
// UNCONSTRAINED-NEXT:    [[VECINIT5:%.*]] = insertelement <8 x half> [[VECINIT4]], half [[C]], i32 5
// UNCONSTRAINED-NEXT:    [[VECINIT6:%.*]] = insertelement <8 x half> [[VECINIT5]], half [[C]], i32 6
// UNCONSTRAINED-NEXT:    [[VECINIT7:%.*]] = insertelement <8 x half> [[VECINIT6]], half [[C]], i32 7
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[FNEG]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[VECINIT7]] to <8 x i16>
// UNCONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// UNCONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// UNCONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[TMP7]], <8 x half> [[TMP8]], <8 x half> [[TMP6]])
// UNCONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
// CONSTRAINED-LABEL: define dso_local <8 x half> @test_vfmsq_n_f16(
// CONSTRAINED-SAME: <8 x half> noundef [[A:%.*]], <8 x half> noundef [[B:%.*]], half noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg <8 x half> [[B]]
// CONSTRAINED-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[C]], i32 0
// CONSTRAINED-NEXT:    [[VECINIT1:%.*]] = insertelement <8 x half> [[VECINIT]], half [[C]], i32 1
// CONSTRAINED-NEXT:    [[VECINIT2:%.*]] = insertelement <8 x half> [[VECINIT1]], half [[C]], i32 2
// CONSTRAINED-NEXT:    [[VECINIT3:%.*]] = insertelement <8 x half> [[VECINIT2]], half [[C]], i32 3
// CONSTRAINED-NEXT:    [[VECINIT4:%.*]] = insertelement <8 x half> [[VECINIT3]], half [[C]], i32 4
// CONSTRAINED-NEXT:    [[VECINIT5:%.*]] = insertelement <8 x half> [[VECINIT4]], half [[C]], i32 5
// CONSTRAINED-NEXT:    [[VECINIT6:%.*]] = insertelement <8 x half> [[VECINIT5]], half [[C]], i32 6
// CONSTRAINED-NEXT:    [[VECINIT7:%.*]] = insertelement <8 x half> [[VECINIT6]], half [[C]], i32 7
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[A]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[FNEG]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[VECINIT7]] to <8 x i16>
// CONSTRAINED-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP0]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CONSTRAINED-NEXT:    [[TMP6:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP7:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP8:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CONSTRAINED-NEXT:    [[TMP9:%.*]] = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> [[TMP7]], <8 x half> [[TMP8]], <8 x half> [[TMP6]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret <8 x half> [[TMP9]]
//
float16x8_t test_vfmsq_n_f16(float16x8_t a, float16x8_t b, float16_t c) {
  return vfmsq_n_f16(a, b, c);
}

// UNCONSTRAINED-LABEL: define dso_local half @test_vfmsh_lane_f16(
// UNCONSTRAINED-SAME: half noundef [[A:%.*]], half noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[CONV:%.*]] = fpext half [[B]] to float
// UNCONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg float [[CONV]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = fptrunc float [[FNEG]] to half
// UNCONSTRAINED-NEXT:    [[EXTRACT:%.*]] = extractelement <4 x half> [[C]], i32 3
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = call half @llvm.fma.f16(half [[TMP0]], half [[EXTRACT]], half [[A]])
// UNCONSTRAINED-NEXT:    ret half [[TMP1]]
//
// CONSTRAINED-LABEL: define dso_local half @test_vfmsh_lane_f16(
// CONSTRAINED-SAME: half noundef [[A:%.*]], half noundef [[B:%.*]], <4 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[CONV:%.*]] = call float @llvm.experimental.constrained.fpext.f32.f16(half [[B]], metadata !"fpexcept.strict") #[[ATTR2]]
// CONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg float [[CONV]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = call half @llvm.experimental.constrained.fptrunc.f16.f32(float [[FNEG]], metadata !"round.tonearest", metadata !"fpexcept.strict") #[[ATTR2]]
// CONSTRAINED-NEXT:    [[EXTRACT:%.*]] = extractelement <4 x half> [[C]], i32 3
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = call half @llvm.experimental.constrained.fma.f16(half [[TMP0]], half [[EXTRACT]], half [[A]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret half [[TMP1]]
//
float16_t test_vfmsh_lane_f16(float16_t a, float16_t b, float16x4_t c) {
  return vfmsh_lane_f16(a, b, c, 3);
}

// UNCONSTRAINED-LABEL: define dso_local half @test_vfmsh_laneq_f16(
// UNCONSTRAINED-SAME: half noundef [[A:%.*]], half noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// UNCONSTRAINED-NEXT:  [[ENTRY:.*:]]
// UNCONSTRAINED-NEXT:    [[CONV:%.*]] = fpext half [[B]] to float
// UNCONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg float [[CONV]]
// UNCONSTRAINED-NEXT:    [[TMP0:%.*]] = fptrunc float [[FNEG]] to half
// UNCONSTRAINED-NEXT:    [[EXTRACT:%.*]] = extractelement <8 x half> [[C]], i32 7
// UNCONSTRAINED-NEXT:    [[TMP1:%.*]] = call half @llvm.fma.f16(half [[TMP0]], half [[EXTRACT]], half [[A]])
// UNCONSTRAINED-NEXT:    ret half [[TMP1]]
//
// CONSTRAINED-LABEL: define dso_local half @test_vfmsh_laneq_f16(
// CONSTRAINED-SAME: half noundef [[A:%.*]], half noundef [[B:%.*]], <8 x half> noundef [[C:%.*]]) #[[ATTR0]] {
// CONSTRAINED-NEXT:  [[ENTRY:.*:]]
// CONSTRAINED-NEXT:    [[CONV:%.*]] = call float @llvm.experimental.constrained.fpext.f32.f16(half [[B]], metadata !"fpexcept.strict") #[[ATTR2]]
// CONSTRAINED-NEXT:    [[FNEG:%.*]] = fneg float [[CONV]]
// CONSTRAINED-NEXT:    [[TMP0:%.*]] = call half @llvm.experimental.constrained.fptrunc.f16.f32(float [[FNEG]], metadata !"round.tonearest", metadata !"fpexcept.strict") #[[ATTR2]]
// CONSTRAINED-NEXT:    [[EXTRACT:%.*]] = extractelement <8 x half> [[C]], i32 7
// CONSTRAINED-NEXT:    [[TMP1:%.*]] = call half @llvm.experimental.constrained.fma.f16(half [[TMP0]], half [[EXTRACT]], half [[A]], metadata !"round.tonearest", metadata !"fpexcept.maytrap") #[[ATTR2]]
// CONSTRAINED-NEXT:    ret half [[TMP1]]
//
float16_t test_vfmsh_laneq_f16(float16_t a, float16_t b, float16x8_t c) {
  return vfmsh_laneq_f16(a, b, c, 7);
}
