## Unreleased

Released YYYY-MM-DD.

### Added

* TODO (or remove section if none)

### Changed

* TODO (or remove section if none)

### Deprecated

* TODO (or remove section if none)

### Removed

* TODO (or remove section if none)

### Fixed

* TODO (or remove section if none)

### Security

* TODO (or remove section if none)

--------------------------------------------------------------------------------

## 0.4.10

Released 2025-07-03.

### Changed

* Updated to `libFuzzer` commit `6146a88f6049` (`release/20.x`).
* Fuzz targets taking raw byte slice inputs can now return `Corpus` results.

--------------------------------------------------------------------------------

## 0.4.9

Released 2025-01-28.

### Added

* The `example_init` demonstrates how to pass an initialization code block to
  the `fuzz_target!` macro.

### Changed

* The `fuzz_target!` macro now supports the generation of `LLVMFuzzerInitialize`
  to execute initialization code once before running the fuzzer. This change is
  not breaking and is completely backward compatible.

--------------------------------------------------------------------------------

## 0.4.8

Released 2024-11-07.

### Added

* Bindings to `LLVMFuzzerCustomCrossOver` through the `fuzz_crossover`
  macro. See the `example_crossover` directory in this crate's repo for a
  complete example.

### Changed

* Updated to `libFuzzer` commit `ab51eccf88f5321e7c60591c5546b254b6afab99`
  (`release/19.x`).

--------------------------------------------------------------------------------

## 0.4.7

Released 2023-08-10.

### Added

* Added the `link_libfuzzer` cargo feature. This feature is on by default and
  preserves the existing behavior of statically linking libfuzzer. You can
  disable it if you are linking your own version of libfuzzer some other way, or
  another library that provides the same ABI as libfuzzer.

--------------------------------------------------------------------------------

## 0.4.6

Released 2023-01-26.

### Fixed

* Fixed a potential name conflict in functions generated by the `fuzz_target!`
  macro.
* Fixed potential stale builds when updating custom libfuzzers to link against.

--------------------------------------------------------------------------------

## 0.4.5

Released 2022-10-18.

### Added

* Added the ability to tell libfuzzer whether to keep files inputs in the corpus
  or not. See the `Corpus` type and extended documentation for the
  `fuzz_target!` macro for details.

### Changed

* Ensured that there is always at least one inline-never frame on the stack per
  fuzz target. This helps prevent oss-fuzz from "deduplicating" different bugs
  from different fuzz targets into the same bug.

--------------------------------------------------------------------------------

## 0.4.4

Released 2022-09-01.

### Changed

* Updated to `libFuzzer` commit `df90d22` (`release/15.x`).
* LLVM 16's [upcoming change][llvm_cxx17] to build requirements to C++17
  necessitate reflecting those changes. (`libFuzzer` updates contain C++14 code)
* Drastically reduce build times by using parallel C++ compilation jobs
* Updated `rand` dependency from 0.8.3 to 0.8.5
* Updated `flate2` dependency from 1.0.20 to 1.0.24

[llvm_cxx17]: https://llvm.org/docs/ReleaseNotes.html#update-on-required-toolchains-to-build-llvm

--------------------------------------------------------------------------------

## 0.4.3

Released 2020-03-03.

### Changed

* Updated to `libFuzzer` commit `60e32a1`.

### Fixed

* Fixed an issue where the `fuzz_target!` macro would sometimes expand to
  versions of itself that were not `$crate` prefixed and would result in "error:
  cannot find macro `fuzz_target` in this scope" if the caller didn't import the
  macro but used the qualified version of it instead.

--------------------------------------------------------------------------------

## 0.4.2

Released 2020-05-26.

### Changed

* Improved performance of checking for whether `cargo fuzz` is requesting the
  `std::fmt::Debug` output of an input or not. This is always false during
  regular fuzzing, so making this check faster should give slightly better
  fuzzing throughput.

--------------------------------------------------------------------------------

## 0.4.1

Released 2020-05-13.

### Added

* Added support for defining custom mutators. See [the documentation for the
  `fuzz_mutator!`
  macro](https://docs.rs/libfuzzer-sys/0.4.1/libfuzzer_sys/macro.fuzz_mutator.html)
  for details.

### Changed

* Upgraded libfuzzer to llvm/llvm-project's 70cbc6d.

--------------------------------------------------------------------------------

## 0.4.0

Released 2021-02-24.

### Changed

* The public `arbitrary` dependency was updated to version 1.0.

--------------------------------------------------------------------------------

## 0.3.5

Released 2020-11-18.

### Changed

* [Upgrade libfuzzer to 7bf89c2](https://github.com/rust-fuzz/libfuzzer/pull/68)

--------------------------------------------------------------------------------

## 0.3.4

Released 2020-08-22.

### Changed

* Updated `arbitrary` dependency to 0.4.6

--------------------------------------------------------------------------------

## 0.3.3

Released 2020-07-27.

### Changed

* Upgraded libfuzzer to commit
  [4a4cafa](https://github.com/llvm/llvm-project/commit/4a4cafabc9067fced5890a245b03ef5897ad988b).

  Notably, this pulls in [the new Entropic engine for
  libFuzzer](https://mboehme.github.io/paper/FSE20.Entropy.pdf), which should
  boost fuzzing efficiency when enabled. You can enable Entropic by passing
  `-entropic=1` to your built fuzz targets (although, note that it is still
  labeled "experimental").

--------------------------------------------------------------------------------

## 0.3.2

Released 2020-03-18.

### Changed

* Upgraded the `arbitrary` dependency re-export to version 0.4.1.

--------------------------------------------------------------------------------

## 0.3.1

Released 2020-02-27.

### Changed

* Fixed a fuzzing performance issue where libfuzzer could unnecessarily spend
  time exploring all the ways that an `Arbitrary` implementation could fail to
  construct an instance of itself because the fuzzer provided too few bytes. See
  https://github.com/rust-fuzz/libfuzzer/issues/59 for details.

--------------------------------------------------------------------------------

## 0.3.0

Released 2019-01-22.

### Changed

* Now works with and re-exports `arbitrary` versions 0.4.x.

--------------------------------------------------------------------------------

## 0.2.1

Released 2019-01-16.

### Added

* Added support for the `CUSTOM_LIBFUZZER_STD_CXX=<lib>` environment variable
  during builds that already use a custom libFuzzer checkout with
  `CUSTOM_LIBFUZZER_PATH`. This allows you to explicitly choose to link LLVM or
  GNU C++ standard libraries.

--------------------------------------------------------------------------------

## 0.2.0

Released 2020-01-14.

### Changed

* Using `arbitrary` 0.3.x now. It is re-exported as `libfuzzer_sys::arbitrary`.

### Added

* You can enable support for `#[derive(Arbitrary)]` with the
  `"arbitrary-derive"` cargo feature. This is a synonym for the `arbitrary`
  crate's `"derive"` cargo feature.

--------------------------------------------------------------------------------

## 0.1.0
