// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct UpdateBucketMetadataJournalTableConfigurationInput {
    /// <p>The general purpose bucket that corresponds to the metadata configuration that you want to enable or disable journal table record expiration for.</p>
    pub bucket: ::std::option::Option<::std::string::String>,
    /// <p>The <code>Content-MD5</code> header for the journal table configuration.</p>
    pub content_md5: ::std::option::Option<::std::string::String>,
    /// <p>The checksum algorithm to use with your journal table configuration.</p>
    pub checksum_algorithm: ::std::option::Option<crate::types::ChecksumAlgorithm>,
    /// <p>The contents of your journal table configuration.</p>
    pub journal_table_configuration: ::std::option::Option<crate::types::JournalTableConfigurationUpdates>,
    /// <p>The expected owner of the general purpose bucket that corresponds to the metadata table configuration that you want to enable or disable journal table record expiration for.</p>
    pub expected_bucket_owner: ::std::option::Option<::std::string::String>,
}
impl UpdateBucketMetadataJournalTableConfigurationInput {
    /// <p>The general purpose bucket that corresponds to the metadata configuration that you want to enable or disable journal table record expiration for.</p>
    pub fn bucket(&self) -> ::std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The <code>Content-MD5</code> header for the journal table configuration.</p>
    pub fn content_md5(&self) -> ::std::option::Option<&str> {
        self.content_md5.as_deref()
    }
    /// <p>The checksum algorithm to use with your journal table configuration.</p>
    pub fn checksum_algorithm(&self) -> ::std::option::Option<&crate::types::ChecksumAlgorithm> {
        self.checksum_algorithm.as_ref()
    }
    /// <p>The contents of your journal table configuration.</p>
    pub fn journal_table_configuration(&self) -> ::std::option::Option<&crate::types::JournalTableConfigurationUpdates> {
        self.journal_table_configuration.as_ref()
    }
    /// <p>The expected owner of the general purpose bucket that corresponds to the metadata table configuration that you want to enable or disable journal table record expiration for.</p>
    pub fn expected_bucket_owner(&self) -> ::std::option::Option<&str> {
        self.expected_bucket_owner.as_deref()
    }
}
impl UpdateBucketMetadataJournalTableConfigurationInput {
    /// Creates a new builder-style object to manufacture [`UpdateBucketMetadataJournalTableConfigurationInput`](crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationInput).
    pub fn builder(
    ) -> crate::operation::update_bucket_metadata_journal_table_configuration::builders::UpdateBucketMetadataJournalTableConfigurationInputBuilder
    {
        crate::operation::update_bucket_metadata_journal_table_configuration::builders::UpdateBucketMetadataJournalTableConfigurationInputBuilder::default()
    }
}

/// A builder for [`UpdateBucketMetadataJournalTableConfigurationInput`](crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct UpdateBucketMetadataJournalTableConfigurationInputBuilder {
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
    pub(crate) content_md5: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_algorithm: ::std::option::Option<crate::types::ChecksumAlgorithm>,
    pub(crate) journal_table_configuration: ::std::option::Option<crate::types::JournalTableConfigurationUpdates>,
    pub(crate) expected_bucket_owner: ::std::option::Option<::std::string::String>,
}
impl UpdateBucketMetadataJournalTableConfigurationInputBuilder {
    /// <p>The general purpose bucket that corresponds to the metadata configuration that you want to enable or disable journal table record expiration for.</p>
    /// This field is required.
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The general purpose bucket that corresponds to the metadata configuration that you want to enable or disable journal table record expiration for.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket = input;
        self
    }
    /// <p>The general purpose bucket that corresponds to the metadata configuration that you want to enable or disable journal table record expiration for.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket
    }
    /// <p>The <code>Content-MD5</code> header for the journal table configuration.</p>
    pub fn content_md5(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_md5 = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The <code>Content-MD5</code> header for the journal table configuration.</p>
    pub fn set_content_md5(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_md5 = input;
        self
    }
    /// <p>The <code>Content-MD5</code> header for the journal table configuration.</p>
    pub fn get_content_md5(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_md5
    }
    /// <p>The checksum algorithm to use with your journal table configuration.</p>
    pub fn checksum_algorithm(mut self, input: crate::types::ChecksumAlgorithm) -> Self {
        self.checksum_algorithm = ::std::option::Option::Some(input);
        self
    }
    /// <p>The checksum algorithm to use with your journal table configuration.</p>
    pub fn set_checksum_algorithm(mut self, input: ::std::option::Option<crate::types::ChecksumAlgorithm>) -> Self {
        self.checksum_algorithm = input;
        self
    }
    /// <p>The checksum algorithm to use with your journal table configuration.</p>
    pub fn get_checksum_algorithm(&self) -> &::std::option::Option<crate::types::ChecksumAlgorithm> {
        &self.checksum_algorithm
    }
    /// <p>The contents of your journal table configuration.</p>
    /// This field is required.
    pub fn journal_table_configuration(mut self, input: crate::types::JournalTableConfigurationUpdates) -> Self {
        self.journal_table_configuration = ::std::option::Option::Some(input);
        self
    }
    /// <p>The contents of your journal table configuration.</p>
    pub fn set_journal_table_configuration(mut self, input: ::std::option::Option<crate::types::JournalTableConfigurationUpdates>) -> Self {
        self.journal_table_configuration = input;
        self
    }
    /// <p>The contents of your journal table configuration.</p>
    pub fn get_journal_table_configuration(&self) -> &::std::option::Option<crate::types::JournalTableConfigurationUpdates> {
        &self.journal_table_configuration
    }
    /// <p>The expected owner of the general purpose bucket that corresponds to the metadata table configuration that you want to enable or disable journal table record expiration for.</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.expected_bucket_owner = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The expected owner of the general purpose bucket that corresponds to the metadata table configuration that you want to enable or disable journal table record expiration for.</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.expected_bucket_owner = input;
        self
    }
    /// <p>The expected owner of the general purpose bucket that corresponds to the metadata table configuration that you want to enable or disable journal table record expiration for.</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        &self.expected_bucket_owner
    }
    /// Consumes the builder and constructs a [`UpdateBucketMetadataJournalTableConfigurationInput`](crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(
            crate::operation::update_bucket_metadata_journal_table_configuration::UpdateBucketMetadataJournalTableConfigurationInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                checksum_algorithm: self.checksum_algorithm,
                journal_table_configuration: self.journal_table_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            },
        )
    }
}
