//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardname?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type UIPasteboardName = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardnamegeneral?language=objc)
    pub static UIPasteboardNameGeneral: &'static UIPasteboardName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardnamefind?language=objc)
    pub static UIPasteboardNameFind: &'static NSString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpattern?language=objc)
// NS_TYPED_ENUM
pub type UIPasteboardDetectionPattern = NSString;

extern "C" {
    /// NSString value, suitable for implementing "Paste and Go"
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternprobableweburl?language=objc)
    pub static UIPasteboardDetectionPatternProbableWebURL: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// NSString value, suitable for implementing "Paste and Search"
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternprobablewebsearch?language=objc)
    pub static UIPasteboardDetectionPatternProbableWebSearch: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// NSNumber value
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternnumber?language=objc)
    pub static UIPasteboardDetectionPatternNumber: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// Array of DDMatchLink values
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternlink?language=objc)
    pub static UIPasteboardDetectionPatternLink: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// Array of DDMatchPhoneNumber values
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternphonenumber?language=objc)
    pub static UIPasteboardDetectionPatternPhoneNumber: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// Array of DDMatchEmailAddress values
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternemailaddress?language=objc)
    pub static UIPasteboardDetectionPatternEmailAddress: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// Array of DDMatchAddress values
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternpostaladdress?language=objc)
    pub static UIPasteboardDetectionPatternPostalAddress: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// Array of DDMatchCalendarEvent values
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatterncalendarevent?language=objc)
    pub static UIPasteboardDetectionPatternCalendarEvent: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// Array of DDMatchShipmentTrackingNumber values
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternshipmenttrackingnumber?language=objc)
    pub static UIPasteboardDetectionPatternShipmentTrackingNumber:
        &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// Array of DDMatchFlightNumber values
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternflightnumber?language=objc)
    pub static UIPasteboardDetectionPatternFlightNumber: &'static UIPasteboardDetectionPattern;
}

extern "C" {
    /// Array of DDMatchMoneyAmount values
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboarddetectionpatternmoneyamount?language=objc)
    pub static UIPasteboardDetectionPatternMoneyAmount: &'static UIPasteboardDetectionPattern;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardoption?language=objc)
// NS_TYPED_ENUM
pub type UIPasteboardOption = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardoptionexpirationdate?language=objc)
    pub static UIPasteboardOptionExpirationDate: &'static UIPasteboardOption;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardoptionlocalonly?language=objc)
    pub static UIPasteboardOptionLocalOnly: &'static UIPasteboardOption;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboard?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPasteboard;
);

unsafe impl Send for UIPasteboard {}

unsafe impl Sync for UIPasteboard {}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPasteboard {}
);

impl UIPasteboard {
    extern_methods!(
        #[unsafe(method(generalPasteboard))]
        #[unsafe(method_family = none)]
        pub unsafe fn generalPasteboard() -> Retained<UIPasteboard>;

        #[unsafe(method(pasteboardWithName:create:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteboardWithName_create(
            pasteboard_name: &UIPasteboardName,
            create: bool,
        ) -> Option<Retained<UIPasteboard>>;

        #[unsafe(method(pasteboardWithUniqueName))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteboardWithUniqueName() -> Retained<UIPasteboard>;

        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Retained<UIPasteboardName>;

        #[unsafe(method(removePasteboardWithName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removePasteboardWithName(pasteboard_name: &UIPasteboardName);

        #[unsafe(method(isPersistent))]
        #[unsafe(method_family = none)]
        pub unsafe fn isPersistent(&self) -> bool;

        #[deprecated = "Do not set persistence on pasteboards. This property is set automatically."]
        #[unsafe(method(setPersistent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPersistent(&self, persistent: bool);

        #[unsafe(method(changeCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeCount(&self) -> NSInteger;

        #[unsafe(method(itemProviders))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemProviders(&self) -> Retained<NSArray<NSItemProvider>>;

        /// Setter for [`itemProviders`][Self::itemProviders].
        #[unsafe(method(setItemProviders:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItemProviders(&self, item_providers: &NSArray<NSItemProvider>);

        #[unsafe(method(setItemProviders:localOnly:expirationDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItemProviders_localOnly_expirationDate(
            &self,
            item_providers: &NSArray<NSItemProvider>,
            local_only: bool,
            expiration_date: Option<&NSDate>,
        );

        #[unsafe(method(setObjects:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObjects(
            &self,
            objects: &NSArray<ProtocolObject<dyn NSItemProviderWriting>>,
        );

        #[unsafe(method(setObjects:localOnly:expirationDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObjects_localOnly_expirationDate(
            &self,
            objects: &NSArray<ProtocolObject<dyn NSItemProviderWriting>>,
            local_only: bool,
            expiration_date: Option<&NSDate>,
        );

        #[unsafe(method(pasteboardTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteboardTypes(&self) -> Retained<NSArray<NSString>>;

        #[unsafe(method(containsPasteboardTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn containsPasteboardTypes(&self, pasteboard_types: &NSArray<NSString>) -> bool;

        #[unsafe(method(dataForPasteboardType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataForPasteboardType(
            &self,
            pasteboard_type: &NSString,
        ) -> Option<Retained<NSData>>;

        #[unsafe(method(valueForPasteboardType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn valueForPasteboardType(
            &self,
            pasteboard_type: &NSString,
        ) -> Option<Retained<AnyObject>>;

        #[unsafe(method(setValue:forPasteboardType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setValue_forPasteboardType(
            &self,
            value: &AnyObject,
            pasteboard_type: &NSString,
        );

        #[unsafe(method(setData:forPasteboardType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setData_forPasteboardType(&self, data: &NSData, pasteboard_type: &NSString);

        #[unsafe(method(numberOfItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfItems(&self) -> NSInteger;

        #[unsafe(method(pasteboardTypesForItemSet:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pasteboardTypesForItemSet(
            &self,
            item_set: Option<&NSIndexSet>,
        ) -> Option<Retained<NSArray<NSArray<NSString>>>>;

        #[unsafe(method(containsPasteboardTypes:inItemSet:))]
        #[unsafe(method_family = none)]
        pub unsafe fn containsPasteboardTypes_inItemSet(
            &self,
            pasteboard_types: &NSArray<NSString>,
            item_set: Option<&NSIndexSet>,
        ) -> bool;

        #[unsafe(method(itemSetWithPasteboardTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemSetWithPasteboardTypes(
            &self,
            pasteboard_types: &NSArray<NSString>,
        ) -> Option<Retained<NSIndexSet>>;

        #[unsafe(method(valuesForPasteboardType:inItemSet:))]
        #[unsafe(method_family = none)]
        pub unsafe fn valuesForPasteboardType_inItemSet(
            &self,
            pasteboard_type: &NSString,
            item_set: Option<&NSIndexSet>,
        ) -> Option<Retained<NSArray>>;

        #[unsafe(method(dataForPasteboardType:inItemSet:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataForPasteboardType_inItemSet(
            &self,
            pasteboard_type: &NSString,
            item_set: Option<&NSIndexSet>,
        ) -> Option<Retained<NSArray<NSData>>>;

        #[unsafe(method(items))]
        #[unsafe(method_family = none)]
        pub unsafe fn items(&self) -> Retained<NSArray<NSDictionary<NSString, AnyObject>>>;

        /// Setter for [`items`][Self::items].
        #[unsafe(method(setItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItems(&self, items: &NSArray<NSDictionary<NSString, AnyObject>>);

        #[unsafe(method(addItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addItems(&self, items: &NSArray<NSDictionary<NSString, AnyObject>>);

        #[unsafe(method(setItems:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setItems_options(
            &self,
            items: &NSArray<NSDictionary<NSString, AnyObject>>,
            options: &NSDictionary<UIPasteboardOption, AnyObject>,
        );

        #[unsafe(method(string))]
        #[unsafe(method_family = none)]
        pub unsafe fn string(&self) -> Option<Retained<NSString>>;

        /// Setter for [`string`][Self::string].
        #[unsafe(method(setString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setString(&self, string: Option<&NSString>);

        #[unsafe(method(strings))]
        #[unsafe(method_family = none)]
        pub unsafe fn strings(&self) -> Option<Retained<NSArray<NSString>>>;

        /// Setter for [`strings`][Self::strings].
        #[unsafe(method(setStrings:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStrings(&self, strings: Option<&NSArray<NSString>>);

        #[unsafe(method(URL))]
        #[unsafe(method_family = none)]
        pub unsafe fn URL(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`URL`][Self::URL].
        #[unsafe(method(setURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setURL(&self, url: Option<&NSURL>);

        #[unsafe(method(URLs))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLs(&self) -> Option<Retained<NSArray<NSURL>>>;

        /// Setter for [`URLs`][Self::URLs].
        #[unsafe(method(setURLs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setURLs(&self, ur_ls: Option<&NSArray<NSURL>>);

        #[cfg(feature = "UIImage")]
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub unsafe fn image(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImage(&self, image: Option<&UIImage>);

        #[cfg(feature = "UIImage")]
        #[unsafe(method(images))]
        #[unsafe(method_family = none)]
        pub unsafe fn images(&self) -> Option<Retained<NSArray<UIImage>>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`images`][Self::images].
        #[unsafe(method(setImages:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImages(&self, images: Option<&NSArray<UIImage>>);

        #[cfg(feature = "UIColor")]
        #[unsafe(method(color))]
        #[unsafe(method_family = none)]
        pub unsafe fn color(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`color`][Self::color].
        #[unsafe(method(setColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setColor(&self, color: Option<&UIColor>);

        #[cfg(feature = "UIColor")]
        #[unsafe(method(colors))]
        #[unsafe(method_family = none)]
        pub unsafe fn colors(&self) -> Option<Retained<NSArray<UIColor>>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`colors`][Self::colors].
        #[unsafe(method(setColors:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setColors(&self, colors: Option<&NSArray<UIColor>>);

        #[unsafe(method(hasStrings))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasStrings(&self) -> bool;

        #[unsafe(method(hasURLs))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasURLs(&self) -> bool;

        #[unsafe(method(hasImages))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasImages(&self) -> bool;

        #[unsafe(method(hasColors))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasColors(&self) -> bool;

        #[cfg(feature = "block2")]
        /// Detects patterns in the first pasteboard item.
        ///
        ///
        /// Parameter `patterns`: Detect only these patterns.
        ///
        /// Parameter `completionHandler`: Receives which patterns were detected, or an error.
        #[unsafe(method(detectPatternsForPatterns:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn detectPatternsForPatterns_completionHandler(
            &self,
            patterns: &NSSet<UIPasteboardDetectionPattern>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSSet<UIPasteboardDetectionPattern>, *mut NSError),
            >,
        );

        #[cfg(feature = "block2")]
        /// Detects patterns in the specified pasteboard items.
        ///
        ///
        /// Parameter `patterns`: Detect only these patterns.
        ///
        /// Parameter `itemSet`: Specifies which pasteboard items by their position. Nil means all items.
        ///
        /// Parameter `completionHandler`: Receives which patterns were detected per item specified,
        /// or an error.
        #[unsafe(method(detectPatternsForPatterns:inItemSet:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn detectPatternsForPatterns_inItemSet_completionHandler(
            &self,
            patterns: &NSSet<UIPasteboardDetectionPattern>,
            item_set: Option<&NSIndexSet>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSArray<NSSet<UIPasteboardDetectionPattern>>, *mut NSError),
            >,
        );

        #[cfg(feature = "block2")]
        /// Detects patterns and corresponding values in the first pasteboard item.
        ///
        ///
        /// Parameter `patterns`: Detect only these patterns.
        ///
        /// Parameter `completionHandler`: Receives which patterns and values were detected, or an error.
        #[unsafe(method(detectValuesForPatterns:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn detectValuesForPatterns_completionHandler(
            &self,
            patterns: &NSSet<UIPasteboardDetectionPattern>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSDictionary<UIPasteboardDetectionPattern, AnyObject>, *mut NSError),
            >,
        );

        #[cfg(feature = "block2")]
        /// Detects patterns and corresponding values in the specified pasteboard items.
        ///
        ///
        /// Parameter `patterns`: Detect only these patterns.
        ///
        /// Parameter `itemSet`: Specifies which pasteboard items by their position. Nil means all items.
        ///
        /// Parameter `completionHandler`: Receives which patterns and values were detected per item specified,
        /// or an error.
        #[unsafe(method(detectValuesForPatterns:inItemSet:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn detectValuesForPatterns_inItemSet_completionHandler(
            &self,
            patterns: &NSSet<UIPasteboardDetectionPattern>,
            item_set: Option<&NSIndexSet>,
            completion_handler: &block2::DynBlock<
                dyn Fn(
                    *mut NSArray<NSDictionary<UIPasteboardDetectionPattern, AnyObject>>,
                    *mut NSError,
                ),
            >,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl UIPasteboard {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardchangednotification?language=objc)
    pub static UIPasteboardChangedNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardchangedtypesaddedkey?language=objc)
    pub static UIPasteboardChangedTypesAddedKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardchangedtypesremovedkey?language=objc)
    pub static UIPasteboardChangedTypesRemovedKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardremovednotification?language=objc)
    pub static UIPasteboardRemovedNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardtypeliststring?language=objc)
    pub static UIPasteboardTypeListString: &'static NSArray<NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardtypelisturl?language=objc)
    pub static UIPasteboardTypeListURL: &'static NSArray<NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardtypelistimage?language=objc)
    pub static UIPasteboardTypeListImage: &'static NSArray<NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardtypelistcolor?language=objc)
    pub static UIPasteboardTypeListColor: &'static NSArray<NSString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipasteboardtypeautomatic?language=objc)
    pub static UIPasteboardTypeAutomatic: &'static NSString;
}
