//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// A key for a collaboration mode restriction, used to specify the case where Share Sheet should not support some modes of sharing even if they are supported by the items being shared
    /// The object returned for this key should be an array of UIActivityCollaborationModeRestriction instances
    /// For supported behaviour, this array should have a maximum size of one less than the amount of possible Share Sheet modes
    /// Currently at most one object should be provided
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactivityitemsconfigurationmetadatakeycollaborationmoderestrictions?language=objc)
    #[cfg(feature = "UIActivityItemsConfigurationReading")]
    pub static UIActivityItemsConfigurationMetadataKeyCollaborationModeRestrictions:
        &'static UIActivityItemsConfigurationMetadataKey;
}

/// Represents the types of sharing (collaborating on an item vs. sending a copy of the item)
/// Share Sheet supports up to two modes, each of which corresponds to one of these types
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactivitycollaborationmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIActivityCollaborationMode(pub NSInteger);
impl UIActivityCollaborationMode {
    #[doc(alias = "UIActivityCollaborationModeSendCopy")]
    pub const SendCopy: Self = Self(0);
    #[doc(alias = "UIActivityCollaborationModeCollaborate")]
    pub const Collaborate: Self = Self(1);
}

unsafe impl Encode for UIActivityCollaborationMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIActivityCollaborationMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// Specifies whether any types of sharing should be disabled in Share Sheet, and if so, whether they should provide a reason when tapped
    /// If a reason is provided, the corresponding mode will show up as an option, but an alert explaining why it is disabled will show if it is chosen, and the mode will switch back to the supported one
    /// Optionally, an extra alert button can be provided for a "recovery suggestion". This can give a user a way to fix whatever is causing this type of sharing to be disabled
    /// If no reason is provided, the corresponding mode will not show up as an option
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactivitycollaborationmoderestriction?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIActivityCollaborationModeRestriction;
);

extern_conformance!(
    unsafe impl NSCoding for UIActivityCollaborationModeRestriction {}
);

extern_conformance!(
    unsafe impl NSCopying for UIActivityCollaborationModeRestriction {}
);

unsafe impl CopyingHelper for UIActivityCollaborationModeRestriction {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIActivityCollaborationModeRestriction {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UIActivityCollaborationModeRestriction {}
);

impl UIActivityCollaborationModeRestriction {
    extern_methods!(
        /// The type of sharing which should be disabled
        #[unsafe(method(disabledMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn disabledMode(&self) -> UIActivityCollaborationMode;

        /// The title of the alert if a reason for disabling is provided
        #[unsafe(method(alertTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertTitle(&self) -> Option<Retained<NSString>>;

        /// The message of the alert if a reason for disabling is provided
        #[unsafe(method(alertMessage))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertMessage(&self) -> Option<Retained<NSString>>;

        /// The label on the alert button which will simply confirm that the alert was viewed and dismiss it
        /// Defaults to "OK"
        #[unsafe(method(alertDismissButtonTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertDismissButtonTitle(&self) -> Option<Retained<NSString>>;

        /// The label on the recovery suggestion button if it is provided
        #[unsafe(method(alertRecoverySuggestionButtonTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertRecoverySuggestionButtonTitle(&self) -> Option<Retained<NSString>>;

        /// On tapping the recovery suggestion button (if it is provided), the user will be launched to this URL
        #[unsafe(method(alertRecoverySuggestionButtonLaunchURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertRecoverySuggestionButtonLaunchURL(&self) -> Option<Retained<NSURL>>;

        /// - Parameters:
        /// - disabledMode: The disabled type of sharing
        #[unsafe(method(initWithDisabledMode:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDisabledMode(
            this: Allocated<Self>,
            disabled_mode: UIActivityCollaborationMode,
        ) -> Retained<Self>;

        /// - Parameters:
        /// - disabledMode: The disabled type of sharing
        /// - alertTitle: The alert title
        /// - alertMessage: The alert message
        #[unsafe(method(initWithDisabledMode:alertTitle:alertMessage:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDisabledMode_alertTitle_alertMessage(
            this: Allocated<Self>,
            disabled_mode: UIActivityCollaborationMode,
            alert_title: &NSString,
            alert_message: &NSString,
        ) -> Retained<Self>;

        /// - Parameters:
        /// - disabledMode: The disabled type of sharing
        /// - alertTitle: The alert title
        /// - alertMessage: The alert message
        /// - alertDismissButtonTitle: The label on the default alert button
        #[unsafe(method(initWithDisabledMode:alertTitle:alertMessage:alertDismissButtonTitle:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDisabledMode_alertTitle_alertMessage_alertDismissButtonTitle(
            this: Allocated<Self>,
            disabled_mode: UIActivityCollaborationMode,
            alert_title: &NSString,
            alert_message: &NSString,
            alert_dismiss_button_title: &NSString,
        ) -> Retained<Self>;

        /// - Parameters:
        /// - disabledMode: The disabled type of sharing
        /// - alertTitle: The alert title
        /// - alertMessage: The alert message
        /// - alertDismissButtonTitle: The label on the default alert button
        /// - alertRecoverySuggestionButtonTitle: The label on the optional recovery suggestion button on the alert
        /// - alertRecoverySuggestionButtonLaunchURL: The URL which launches when the optional recovery suggestion button is tapped
        #[unsafe(method(initWithDisabledMode:alertTitle:alertMessage:alertDismissButtonTitle:alertRecoverySuggestionButtonTitle:alertRecoverySuggestionButtonLaunchURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDisabledMode_alertTitle_alertMessage_alertDismissButtonTitle_alertRecoverySuggestionButtonTitle_alertRecoverySuggestionButtonLaunchURL(
            this: Allocated<Self>,
            disabled_mode: UIActivityCollaborationMode,
            alert_title: &NSString,
            alert_message: &NSString,
            alert_dismiss_button_title: &NSString,
            alert_recovery_suggestion_button_title: &NSString,
            alert_recovery_suggestion_button_launch_url: &NSURL,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[unsafe(method(description))]
        #[unsafe(method_family = none)]
        pub unsafe fn description(&self) -> Retained<NSString>;
    );
}
