//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlprimitivetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLPrimitiveType(pub NSUInteger);
impl MTLPrimitiveType {
    #[doc(alias = "MTLPrimitiveTypePoint")]
    pub const Point: Self = Self(0);
    #[doc(alias = "MTLPrimitiveTypeLine")]
    pub const Line: Self = Self(1);
    #[doc(alias = "MTLPrimitiveTypeLineStrip")]
    pub const LineStrip: Self = Self(2);
    #[doc(alias = "MTLPrimitiveTypeTriangle")]
    pub const Triangle: Self = Self(3);
    #[doc(alias = "MTLPrimitiveTypeTriangleStrip")]
    pub const TriangleStrip: Self = Self(4);
}

unsafe impl Encode for MTLPrimitiveType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLPrimitiveType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlvisibilityresultmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLVisibilityResultMode(pub NSUInteger);
impl MTLVisibilityResultMode {
    #[doc(alias = "MTLVisibilityResultModeDisabled")]
    pub const Disabled: Self = Self(0);
    #[doc(alias = "MTLVisibilityResultModeBoolean")]
    pub const Boolean: Self = Self(1);
    #[doc(alias = "MTLVisibilityResultModeCounting")]
    pub const Counting: Self = Self(2);
}

unsafe impl Encode for MTLVisibilityResultMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLVisibilityResultMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlscissorrect?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLScissorRect {
    pub x: NSUInteger,
    pub y: NSUInteger,
    pub width: NSUInteger,
    pub height: NSUInteger,
}

unsafe impl Encode for MTLScissorRect {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <NSUInteger>::ENCODING,
            <NSUInteger>::ENCODING,
            <NSUInteger>::ENCODING,
            <NSUInteger>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLScissorRect {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlviewport?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLViewport {
    pub originX: c_double,
    pub originY: c_double,
    pub width: c_double,
    pub height: c_double,
    pub znear: c_double,
    pub zfar: c_double,
}

unsafe impl Encode for MTLViewport {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <c_double>::ENCODING,
            <c_double>::ENCODING,
            <c_double>::ENCODING,
            <c_double>::ENCODING,
            <c_double>::ENCODING,
            <c_double>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLViewport {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcullmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCullMode(pub NSUInteger);
impl MTLCullMode {
    #[doc(alias = "MTLCullModeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "MTLCullModeFront")]
    pub const Front: Self = Self(1);
    #[doc(alias = "MTLCullModeBack")]
    pub const Back: Self = Self(2);
}

unsafe impl Encode for MTLCullMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLCullMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlwinding?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLWinding(pub NSUInteger);
impl MTLWinding {
    #[doc(alias = "MTLWindingClockwise")]
    pub const Clockwise: Self = Self(0);
    #[doc(alias = "MTLWindingCounterClockwise")]
    pub const CounterClockwise: Self = Self(1);
}

unsafe impl Encode for MTLWinding {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLWinding {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldepthclipmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLDepthClipMode(pub NSUInteger);
impl MTLDepthClipMode {
    #[doc(alias = "MTLDepthClipModeClip")]
    pub const Clip: Self = Self(0);
    #[doc(alias = "MTLDepthClipModeClamp")]
    pub const Clamp: Self = Self(1);
}

unsafe impl Encode for MTLDepthClipMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLDepthClipMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtltrianglefillmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLTriangleFillMode(pub NSUInteger);
impl MTLTriangleFillMode {
    #[doc(alias = "MTLTriangleFillModeFill")]
    pub const Fill: Self = Self(0);
    #[doc(alias = "MTLTriangleFillModeLines")]
    pub const Lines: Self = Self(1);
}

unsafe impl Encode for MTLTriangleFillMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLTriangleFillMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldrawprimitivesindirectarguments?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLDrawPrimitivesIndirectArguments {
    pub vertexCount: u32,
    pub instanceCount: u32,
    pub vertexStart: u32,
    pub baseInstance: u32,
}

unsafe impl Encode for MTLDrawPrimitivesIndirectArguments {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLDrawPrimitivesIndirectArguments {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldrawindexedprimitivesindirectarguments?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLDrawIndexedPrimitivesIndirectArguments {
    pub indexCount: u32,
    pub instanceCount: u32,
    pub indexStart: u32,
    pub baseVertex: i32,
    pub baseInstance: u32,
}

unsafe impl Encode for MTLDrawIndexedPrimitivesIndirectArguments {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <i32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLDrawIndexedPrimitivesIndirectArguments {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlvertexamplificationviewmapping?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLVertexAmplificationViewMapping {
    pub viewportArrayIndexOffset: u32,
    pub renderTargetArrayIndexOffset: u32,
}

unsafe impl Encode for MTLVertexAmplificationViewMapping {
    const ENCODING: Encoding = Encoding::Struct("?", &[<u32>::ENCODING, <u32>::ENCODING]);
}

unsafe impl RefEncode for MTLVertexAmplificationViewMapping {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldrawpatchindirectarguments?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLDrawPatchIndirectArguments {
    pub patchCount: u32,
    pub instanceCount: u32,
    pub patchStart: u32,
    pub baseInstance: u32,
}

unsafe impl Encode for MTLDrawPatchIndirectArguments {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLDrawPatchIndirectArguments {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlquadtessellationfactorshalf?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLQuadTessellationFactorsHalf {
    pub edgeTessellationFactor: [u16; 4],
    pub insideTessellationFactor: [u16; 2],
}

unsafe impl Encode for MTLQuadTessellationFactorsHalf {
    const ENCODING: Encoding = Encoding::Struct("?", &[<[u16; 4]>::ENCODING, <[u16; 2]>::ENCODING]);
}

unsafe impl RefEncode for MTLQuadTessellationFactorsHalf {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtltriangletessellationfactorshalf?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLTriangleTessellationFactorsHalf {
    pub edgeTessellationFactor: [u16; 3],
    pub insideTessellationFactor: u16,
}

unsafe impl Encode for MTLTriangleTessellationFactorsHalf {
    const ENCODING: Encoding = Encoding::Struct("?", &[<[u16; 3]>::ENCODING, <u16>::ENCODING]);
}

unsafe impl RefEncode for MTLTriangleTessellationFactorsHalf {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Generic render stage enum
///
/// Can also be used for points at which a fence may be waited on or signaled.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlrenderstages?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLRenderStages(pub NSUInteger);
bitflags::bitflags! {
    impl MTLRenderStages: NSUInteger {
        #[doc(alias = "MTLRenderStageVertex")]
        const Vertex = 1<<0;
        #[doc(alias = "MTLRenderStageFragment")]
        const Fragment = 1<<1;
        #[doc(alias = "MTLRenderStageTile")]
        const Tile = 1<<2;
        #[doc(alias = "MTLRenderStageObject")]
        const Object = 1<<3;
        #[doc(alias = "MTLRenderStageMesh")]
        const Mesh = 1<<4;
    }
}

unsafe impl Encode for MTLRenderStages {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLRenderStages {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// MTLRenderCommandEncoder is a container for graphics rendering state and the code to translate the state into a command format that the device can execute.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlrendercommandencoder?language=objc)
    #[cfg(feature = "MTLCommandEncoder")]
    pub unsafe trait MTLRenderCommandEncoder: MTLCommandEncoder {
        #[cfg(feature = "MTLRenderPipeline")]
        /// Sets the current render pipeline state object.
        #[unsafe(method(setRenderPipelineState:))]
        #[unsafe(method_family = none)]
        fn setRenderPipelineState(
            &self,
            pipeline_state: &ProtocolObject<dyn MTLRenderPipelineState>,
        );

        /// Set the data (by copy) for a given vertex buffer binding point.  This will remove any existing MTLBuffer from the binding point.
        #[unsafe(method(setVertexBytes:length:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexBytes_length_atIndex(
            &self,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set a global buffer for all vertex shaders at the given bind point index.
        #[unsafe(method(setVertexBuffer:offset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexBuffer_offset_atIndex(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            index: NSUInteger,
        );

        /// Set the offset within the current global buffer for all vertex shaders at the given bind point index.
        #[unsafe(method(setVertexBufferOffset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexBufferOffset_atIndex(&self, offset: NSUInteger, index: NSUInteger);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set an array of global buffers for all vertex shaders with the given bind point range.
        #[unsafe(method(setVertexBuffers:offsets:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexBuffers_offsets_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// sets vertex buffer at specified index with provided offset and stride. Only
        /// call this when the buffer-index is part of the vertexDescriptor and has set
        /// its stride to `MTLBufferLayoutStrideDynamic`
        #[unsafe(method(setVertexBuffer:offset:attributeStride:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexBuffer_offset_attributeStride_atIndex(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            stride: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// sets an array of vertex buffers with provided offsets and strides with the
        /// given bind point range.
        /// only call this when at least one buffer is part of the
        /// vertexDescriptor, other buffers must set their value relative to the
        /// `attributeStrides` array to `MTLAttributeStrideStatic`
        #[unsafe(method(setVertexBuffers:offsets:attributeStrides:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexBuffers_offsets_attributeStrides_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            strides: NonNull<NSUInteger>,
            range: NSRange,
        );

        /// only call this when the buffer-index is part of the vertexDescriptor and
        /// has set its stride to `MTLBufferLayoutStrideDynamic`
        #[unsafe(method(setVertexBufferOffset:attributeStride:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexBufferOffset_attributeStride_atIndex(
            &self,
            offset: NSUInteger,
            stride: NSUInteger,
            index: NSUInteger,
        );

        /// only call this when the buffer-index is part of the vertexDescriptor and
        /// has set its stride to `MTLBufferLayoutStrideDynamic`
        #[unsafe(method(setVertexBytes:length:attributeStride:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexBytes_length_attributeStride_atIndex(
            &self,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            stride: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set a global texture for all vertex shaders at the given bind point index.
        #[unsafe(method(setVertexTexture:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexTexture_atIndex(
            &self,
            texture: Option<&ProtocolObject<dyn MTLTexture>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set an array of global textures for all vertex shaders with the given bind point range.
        #[unsafe(method(setVertexTextures:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexTextures_withRange(
            &self,
            textures: NonNull<*const ProtocolObject<dyn MTLTexture>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all vertex shaders at the given bind point index.
        #[unsafe(method(setVertexSamplerState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexSamplerState_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all vertex shaders with the given bind point range.
        #[unsafe(method(setVertexSamplerStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexSamplerStates_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all vertex shaders at the given bind point index.
        #[unsafe(method(setVertexSamplerState:lodMinClamp:lodMaxClamp:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexSamplerState_lodMinClamp_lodMaxClamp_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamp: c_float,
            lod_max_clamp: c_float,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all vertex shaders with the given bind point range.
        #[unsafe(method(setVertexSamplerStates:lodMinClamps:lodMaxClamps:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexSamplerStates_lodMinClamps_lodMaxClamps_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamps: NonNull<c_float>,
            lod_max_clamps: NonNull<c_float>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set a global visible function table for all vertex shaders at the given buffer bind point index.
        #[unsafe(method(setVertexVisibleFunctionTable:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexVisibleFunctionTable_atBufferIndex(
            &self,
            function_table: Option<&ProtocolObject<dyn MTLVisibleFunctionTable>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set an array of global visible function tables for all vertex shaders with the given buffer bind point range.
        #[unsafe(method(setVertexVisibleFunctionTables:withBufferRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexVisibleFunctionTables_withBufferRange(
            &self,
            function_tables: NonNull<*const ProtocolObject<dyn MTLVisibleFunctionTable>>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set a global intersection function table for all vertex shaders at the given buffer bind point index.
        #[unsafe(method(setVertexIntersectionFunctionTable:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexIntersectionFunctionTable_atBufferIndex(
            &self,
            intersection_function_table: Option<&ProtocolObject<dyn MTLIntersectionFunctionTable>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set an array of global intersection function tables for all vertex shaders with the given buffer bind point range.
        #[unsafe(method(setVertexIntersectionFunctionTables:withBufferRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexIntersectionFunctionTables_withBufferRange(
            &self,
            intersection_function_tables: NonNull<
                *const ProtocolObject<dyn MTLIntersectionFunctionTable>,
            >,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLResource"
        ))]
        /// Set a global acceleration structure for all vertex shaders at the given buffer bind point index.
        #[unsafe(method(setVertexAccelerationStructure:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexAccelerationStructure_atBufferIndex(
            &self,
            acceleration_structure: Option<&ProtocolObject<dyn MTLAccelerationStructure>>,
            buffer_index: NSUInteger,
        );

        /// Set the viewport, which is used to transform vertexes from normalized device coordinates to window coordinates.  Fragments that lie outside of the viewport are clipped, and optionally clamped for fragments outside of znear/zfar.
        #[unsafe(method(setViewport:))]
        #[unsafe(method_family = none)]
        fn setViewport(&self, viewport: MTLViewport);

        /// Specifies an array of viewports, which are used to transform vertices from normalized device coordinates to window coordinates based on [[ viewport_array_index ]] value specified in the vertex shader.
        #[unsafe(method(setViewports:count:))]
        #[unsafe(method_family = none)]
        unsafe fn setViewports_count(&self, viewports: NonNull<MTLViewport>, count: NSUInteger);

        /// The winding order of front-facing primitives.
        #[unsafe(method(setFrontFacingWinding:))]
        #[unsafe(method_family = none)]
        fn setFrontFacingWinding(&self, front_facing_winding: MTLWinding);

        /// Specifies the vertex amplification count and associated view mappings for each amplification ID.
        ///
        /// Parameter `count`: the amplification count. The maximum value is currently 2.
        ///
        /// Parameter `viewMappings`: an array of mapping elements.
        ///
        /// Each mapping element describes how to route the corresponding amplification ID to a specific viewport and render target array index by using offsets from the base array index provided by the [[render_target_array_index]] and/or [[viewport_array_index]] output attributes in the vertex shader. This allows a modicum of programmability for each amplified vertex to be routed to a different [[render_target_array_index]] and [[viewport_array_index]] even though these attribytes cannot be amplified themselves.
        #[unsafe(method(setVertexAmplificationCount:viewMappings:))]
        #[unsafe(method_family = none)]
        unsafe fn setVertexAmplificationCount_viewMappings(
            &self,
            count: NSUInteger,
            view_mappings: *const MTLVertexAmplificationViewMapping,
        );

        /// Controls if primitives are culled when front facing, back facing, or not culled at all.
        #[unsafe(method(setCullMode:))]
        #[unsafe(method_family = none)]
        fn setCullMode(&self, cull_mode: MTLCullMode);

        /// Controls what is done with fragments outside of the near or far planes.
        #[unsafe(method(setDepthClipMode:))]
        #[unsafe(method_family = none)]
        fn setDepthClipMode(&self, depth_clip_mode: MTLDepthClipMode);

        /// Depth Bias.
        #[unsafe(method(setDepthBias:slopeScale:clamp:))]
        #[unsafe(method_family = none)]
        fn setDepthBias_slopeScale_clamp(
            &self,
            depth_bias: c_float,
            slope_scale: c_float,
            clamp: c_float,
        );

        /// Specifies a rectangle for a fragment scissor test.  All fragments outside of this rectangle are discarded.
        #[unsafe(method(setScissorRect:))]
        #[unsafe(method_family = none)]
        fn setScissorRect(&self, rect: MTLScissorRect);

        /// Specifies an array of rectangles for a fragment scissor test. The specific rectangle used is based on the [[ viewport_array_index ]] value output by the vertex shader. Fragments that lie outside the scissor rectangle are discarded.
        #[unsafe(method(setScissorRects:count:))]
        #[unsafe(method_family = none)]
        unsafe fn setScissorRects_count(
            &self,
            scissor_rects: NonNull<MTLScissorRect>,
            count: NSUInteger,
        );

        /// Set how to rasterize triangle and triangle strip primitives.
        #[unsafe(method(setTriangleFillMode:))]
        #[unsafe(method_family = none)]
        fn setTriangleFillMode(&self, fill_mode: MTLTriangleFillMode);

        /// Set the data (by copy) for a given fragment buffer binding point.  This will remove any existing MTLBuffer from the binding point.
        #[unsafe(method(setFragmentBytes:length:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentBytes_length_atIndex(
            &self,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set a global buffer for all fragment shaders at the given bind point index.
        #[unsafe(method(setFragmentBuffer:offset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentBuffer_offset_atIndex(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            index: NSUInteger,
        );

        /// Set the offset within the current global buffer for all fragment shaders at the given bind point index.
        #[unsafe(method(setFragmentBufferOffset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentBufferOffset_atIndex(&self, offset: NSUInteger, index: NSUInteger);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set an array of global buffers for all fragment shaders with the given bind point range.
        #[unsafe(method(setFragmentBuffers:offsets:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentBuffers_offsets_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set a global texture for all fragment shaders at the given bind point index.
        #[unsafe(method(setFragmentTexture:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentTexture_atIndex(
            &self,
            texture: Option<&ProtocolObject<dyn MTLTexture>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set an array of global textures for all fragment shaders with the given bind point range.
        #[unsafe(method(setFragmentTextures:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentTextures_withRange(
            &self,
            textures: NonNull<*const ProtocolObject<dyn MTLTexture>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all fragment shaders at the given bind point index.
        #[unsafe(method(setFragmentSamplerState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentSamplerState_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all fragment shaders with the given bind point range.
        #[unsafe(method(setFragmentSamplerStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentSamplerStates_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all fragment shaders at the given bind point index.
        #[unsafe(method(setFragmentSamplerState:lodMinClamp:lodMaxClamp:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentSamplerState_lodMinClamp_lodMaxClamp_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamp: c_float,
            lod_max_clamp: c_float,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all fragment shaders with the given bind point range.
        #[unsafe(method(setFragmentSamplerStates:lodMinClamps:lodMaxClamps:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentSamplerStates_lodMinClamps_lodMaxClamps_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamps: NonNull<c_float>,
            lod_max_clamps: NonNull<c_float>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set a global visible function table for all fragment shaders at the given buffer bind point index.
        #[unsafe(method(setFragmentVisibleFunctionTable:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentVisibleFunctionTable_atBufferIndex(
            &self,
            function_table: Option<&ProtocolObject<dyn MTLVisibleFunctionTable>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set an array of global visible function tables for all fragment shaders with the given buffer bind point range.
        #[unsafe(method(setFragmentVisibleFunctionTables:withBufferRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentVisibleFunctionTables_withBufferRange(
            &self,
            function_tables: NonNull<*const ProtocolObject<dyn MTLVisibleFunctionTable>>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set a global intersection function table for all fragment shaders at the given buffer bind point index.
        #[unsafe(method(setFragmentIntersectionFunctionTable:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentIntersectionFunctionTable_atBufferIndex(
            &self,
            intersection_function_table: Option<&ProtocolObject<dyn MTLIntersectionFunctionTable>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set an array of global intersection function tables for all fragment shaders with the given buffer bind point range.
        #[unsafe(method(setFragmentIntersectionFunctionTables:withBufferRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentIntersectionFunctionTables_withBufferRange(
            &self,
            intersection_function_tables: NonNull<
                *const ProtocolObject<dyn MTLIntersectionFunctionTable>,
            >,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLResource"
        ))]
        /// Set a global acceleration structure for all fragment shaders at the given buffer bind point index.
        #[unsafe(method(setFragmentAccelerationStructure:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setFragmentAccelerationStructure_atBufferIndex(
            &self,
            acceleration_structure: Option<&ProtocolObject<dyn MTLAccelerationStructure>>,
            buffer_index: NSUInteger,
        );

        /// Set the constant blend color used across all blending on all render targets
        #[unsafe(method(setBlendColorRed:green:blue:alpha:))]
        #[unsafe(method_family = none)]
        fn setBlendColorRed_green_blue_alpha(
            &self,
            red: c_float,
            green: c_float,
            blue: c_float,
            alpha: c_float,
        );

        #[cfg(feature = "MTLDepthStencil")]
        /// Set the DepthStencil state object.
        #[unsafe(method(setDepthStencilState:))]
        #[unsafe(method_family = none)]
        fn setDepthStencilState(
            &self,
            depth_stencil_state: Option<&ProtocolObject<dyn MTLDepthStencilState>>,
        );

        /// Set the stencil reference value for both the back and front stencil buffers.
        #[unsafe(method(setStencilReferenceValue:))]
        #[unsafe(method_family = none)]
        fn setStencilReferenceValue(&self, reference_value: u32);

        /// Set the stencil reference value for the back and front stencil buffers independently.
        #[unsafe(method(setStencilFrontReferenceValue:backReferenceValue:))]
        #[unsafe(method_family = none)]
        fn setStencilFrontReferenceValue_backReferenceValue(
            &self,
            front_reference_value: u32,
            back_reference_value: u32,
        );

        /// Monitor if samples pass the depth and stencil tests.
        ///
        /// Parameter `mode`: Controls if the counter is disabled or moniters passing samples.
        ///
        /// Parameter `offset`: The offset relative to the occlusion query buffer provided when the command encoder was created.  offset must be a multiple of 8.
        #[unsafe(method(setVisibilityResultMode:offset:))]
        #[unsafe(method_family = none)]
        fn setVisibilityResultMode_offset(&self, mode: MTLVisibilityResultMode, offset: NSUInteger);

        #[cfg(feature = "MTLRenderPass")]
        /// If the the store action for a given color attachment was set to MTLStoreActionUnknown when the render command encoder was created,
        /// setColorStoreAction:atIndex: must be used to finalize the store action before endEncoding is called.
        ///
        /// Parameter `storeAction`: The desired store action for the given color attachment.  This may be set to any value other than MTLStoreActionUnknown.
        ///
        /// Parameter `colorAttachmentIndex`: The index of the color attachment
        #[unsafe(method(setColorStoreAction:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setColorStoreAction_atIndex(
            &self,
            store_action: MTLStoreAction,
            color_attachment_index: NSUInteger,
        );

        #[cfg(feature = "MTLRenderPass")]
        /// If the the store action for the depth attachment was set to MTLStoreActionUnknown when the render command encoder was created,
        /// setDepthStoreAction: must be used to finalize the store action before endEncoding is called.
        #[unsafe(method(setDepthStoreAction:))]
        #[unsafe(method_family = none)]
        unsafe fn setDepthStoreAction(&self, store_action: MTLStoreAction);

        #[cfg(feature = "MTLRenderPass")]
        /// If the the store action for the stencil attachment was set to MTLStoreActionUnknown when the render command encoder was created,
        /// setStencilStoreAction: must be used to finalize the store action before endEncoding is called.
        #[unsafe(method(setStencilStoreAction:))]
        #[unsafe(method_family = none)]
        unsafe fn setStencilStoreAction(&self, store_action: MTLStoreAction);

        #[cfg(feature = "MTLRenderPass")]
        /// If the the store action for a given color attachment was set to MTLStoreActionUnknown when the render command encoder was created,
        /// setColorStoreActionOptions:atIndex: may be used to finalize the store action options before endEncoding is called.
        ///
        /// Parameter `storeActionOptions`: The desired store action options for the given color attachment.
        ///
        /// Parameter `colorAttachmentIndex`: The index of the color attachment
        #[unsafe(method(setColorStoreActionOptions:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setColorStoreActionOptions_atIndex(
            &self,
            store_action_options: MTLStoreActionOptions,
            color_attachment_index: NSUInteger,
        );

        #[cfg(feature = "MTLRenderPass")]
        /// If the the store action for the depth attachment was set to MTLStoreActionUnknown when the render command encoder was created,
        /// setDepthStoreActionOptions: may be used to finalize the store action options before endEncoding is called.
        #[unsafe(method(setDepthStoreActionOptions:))]
        #[unsafe(method_family = none)]
        unsafe fn setDepthStoreActionOptions(&self, store_action_options: MTLStoreActionOptions);

        #[cfg(feature = "MTLRenderPass")]
        /// If the the store action for the stencil attachment was set to MTLStoreActionUnknown when the render command encoder was created,
        /// setStencilStoreActionOptions: may be used to finalize the store action options before endEncoding is called.
        #[unsafe(method(setStencilStoreActionOptions:))]
        #[unsafe(method_family = none)]
        unsafe fn setStencilStoreActionOptions(&self, store_action_options: MTLStoreActionOptions);

        /// Set the data (by copy) for a given object shader buffer binding point.  This will remove any existing MTLBuffer from the binding point.
        #[unsafe(method(setObjectBytes:length:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectBytes_length_atIndex(
            &self,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set a global buffer for all object shaders at the given bind point index.
        #[unsafe(method(setObjectBuffer:offset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectBuffer_offset_atIndex(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            index: NSUInteger,
        );

        /// Set the offset within the current global buffer for all object shaders at the given bind point index.
        #[unsafe(method(setObjectBufferOffset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectBufferOffset_atIndex(&self, offset: NSUInteger, index: NSUInteger);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set an array of global buffers for all object shaders with the given bind point range.
        #[unsafe(method(setObjectBuffers:offsets:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectBuffers_offsets_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set a global texture for all object shaders at the given bind point index.
        #[unsafe(method(setObjectTexture:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectTexture_atIndex(
            &self,
            texture: Option<&ProtocolObject<dyn MTLTexture>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set an array of global textures for all object shaders with the given bind point range.
        #[unsafe(method(setObjectTextures:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectTextures_withRange(
            &self,
            textures: NonNull<*const ProtocolObject<dyn MTLTexture>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all object shaders at the given bind point index.
        #[unsafe(method(setObjectSamplerState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectSamplerState_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all object shaders with the given bind point range.
        #[unsafe(method(setObjectSamplerStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectSamplerStates_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all object shaders at the given bind point index.
        #[unsafe(method(setObjectSamplerState:lodMinClamp:lodMaxClamp:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectSamplerState_lodMinClamp_lodMaxClamp_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamp: c_float,
            lod_max_clamp: c_float,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all object shaders with the given bind point range.
        #[unsafe(method(setObjectSamplerStates:lodMinClamps:lodMaxClamps:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectSamplerStates_lodMinClamps_lodMaxClamps_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamps: NonNull<c_float>,
            lod_max_clamps: NonNull<c_float>,
            range: NSRange,
        );

        /// Set the threadgroup memory byte length at the binding point specified by the index for all object shaders.
        #[unsafe(method(setObjectThreadgroupMemoryLength:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setObjectThreadgroupMemoryLength_atIndex(
            &self,
            length: NSUInteger,
            index: NSUInteger,
        );

        /// Set the data (by copy) for a given mesh shader buffer binding point.  This will remove any existing MTLBuffer from the binding point.
        #[unsafe(method(setMeshBytes:length:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshBytes_length_atIndex(
            &self,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set a global buffer for all mesh shaders at the given bind point index.
        #[unsafe(method(setMeshBuffer:offset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshBuffer_offset_atIndex(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            index: NSUInteger,
        );

        /// Set the offset within the current global buffer for all mesh shaders at the given bind point index.
        #[unsafe(method(setMeshBufferOffset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshBufferOffset_atIndex(&self, offset: NSUInteger, index: NSUInteger);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set an array of global buffers for all mesh shaders with the given bind point range.
        #[unsafe(method(setMeshBuffers:offsets:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshBuffers_offsets_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set a global texture for all mesh shaders at the given bind point index.
        #[unsafe(method(setMeshTexture:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshTexture_atIndex(
            &self,
            texture: Option<&ProtocolObject<dyn MTLTexture>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set an array of global textures for all mesh shaders with the given bind point range.
        #[unsafe(method(setMeshTextures:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshTextures_withRange(
            &self,
            textures: NonNull<*const ProtocolObject<dyn MTLTexture>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all mesh shaders at the given bind point index.
        #[unsafe(method(setMeshSamplerState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshSamplerState_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all mesh shaders with the given bind point range.
        #[unsafe(method(setMeshSamplerStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshSamplerStates_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all mesh shaders at the given bind point index.
        #[unsafe(method(setMeshSamplerState:lodMinClamp:lodMaxClamp:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshSamplerState_lodMinClamp_lodMaxClamp_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamp: c_float,
            lod_max_clamp: c_float,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all mesh shaders with the given bind point range.
        #[unsafe(method(setMeshSamplerStates:lodMinClamps:lodMaxClamps:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setMeshSamplerStates_lodMinClamps_lodMaxClamps_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamps: NonNull<c_float>,
            lod_max_clamps: NonNull<c_float>,
            range: NSRange,
        );

        #[cfg(feature = "MTLTypes")]
        /// Enqueue a grid of object (if present) or mesh shader threadgroups.
        ///
        /// The dimensions of the threadgroups and the grid are specified directly.
        ///
        /// Parameter `threadgroupsPerGrid`: The number of threadgroups in the object (if present) or mesh shader grid.
        ///
        /// Parameter `threadsPerObjectThreadgroup`: The number of threads in one object shader threadgroup. Ignored if object shader is not present.
        ///
        /// Parameter `threadsPerMeshThreadgroup`: The number of threads in one mesh shader threadgroup.
        #[unsafe(method(drawMeshThreadgroups:threadsPerObjectThreadgroup:threadsPerMeshThreadgroup:))]
        #[unsafe(method_family = none)]
        unsafe fn drawMeshThreadgroups_threadsPerObjectThreadgroup_threadsPerMeshThreadgroup(
            &self,
            threadgroups_per_grid: MTLSize,
            threads_per_object_threadgroup: MTLSize,
            threads_per_mesh_threadgroup: MTLSize,
        );

        #[cfg(feature = "MTLTypes")]
        /// Enqueue a grid of object (if present) of mesh shader threadgroups.
        ///
        /// The dimensions of the threadgroups and the grid are specified directly.
        /// The dimensions of threadsPerGrid does not have to be a multiple of threadsPerThreadgroup for object shaders.
        /// For mesh shaders, threadsPerGrid is rounded down to the neareset multiple of threadsPerMeshThreadgroup (in each dimension).
        ///
        /// Parameter `threadsPerGrid`: The number of threads in the object (if present) or mesh shader grid
        ///
        /// Parameter `threadsPerObjectThreadgroup`: The number of threads in one object shader threadgroup. Ignored if object shader is not present.
        ///
        /// Parameter `threadsPerMeshThreadgroup`: The number of threads in one mesh shader threadgroup.
        #[unsafe(method(drawMeshThreads:threadsPerObjectThreadgroup:threadsPerMeshThreadgroup:))]
        #[unsafe(method_family = none)]
        unsafe fn drawMeshThreads_threadsPerObjectThreadgroup_threadsPerMeshThreadgroup(
            &self,
            threads_per_grid: MTLSize,
            threads_per_object_threadgroup: MTLSize,
            threads_per_mesh_threadgroup: MTLSize,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLTypes"
        ))]
        /// Enqueue a grid of object (if present) or mesh shader threadgroups.
        ///
        /// The dimensions of the threadgroups are specified directly, the dimensions of the grid, in threadgroups, are read from a buffer by the GPU.
        ///
        /// Parameter `indirectBuffer`: A buffer object that the device will read the grid size from, see MTLDispatchThreadgroupsIndirectArguments.
        ///
        /// Parameter `indirectBufferOffset`: Byte offset within
        /// _indirectBuffer_to read arguments from.
        /// _indirectBufferOffset_must be a multiple of 4.
        ///
        /// Parameter `threadsPerObjectThreadgroup`: The number of threads in one object shader threadgroup. Ignored if object shader is not present.
        ///
        /// Parameter `threadsPerMeshThreadgroup`: The number of threads in one mesh shader threadgroup.
        #[unsafe(method(drawMeshThreadgroupsWithIndirectBuffer:indirectBufferOffset:threadsPerObjectThreadgroup:threadsPerMeshThreadgroup:))]
        #[unsafe(method_family = none)]
        unsafe fn drawMeshThreadgroupsWithIndirectBuffer_indirectBufferOffset_threadsPerObjectThreadgroup_threadsPerMeshThreadgroup(
            &self,
            indirect_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
            threads_per_object_threadgroup: MTLSize,
            threads_per_mesh_threadgroup: MTLSize,
        );

        /// Draw primitives without an index list.
        ///
        /// Parameter `primitiveType`: The type of primitives that elements are assembled into.
        ///
        /// Parameter `vertexStart`: For each instance, the first index to draw
        ///
        /// Parameter `vertexCount`: For each instance, the number of indexes to draw
        ///
        /// Parameter `instanceCount`: The number of instances drawn.
        #[unsafe(method(drawPrimitives:vertexStart:vertexCount:instanceCount:))]
        #[unsafe(method_family = none)]
        unsafe fn drawPrimitives_vertexStart_vertexCount_instanceCount(
            &self,
            primitive_type: MTLPrimitiveType,
            vertex_start: NSUInteger,
            vertex_count: NSUInteger,
            instance_count: NSUInteger,
        );

        /// Draw primitives without an index list.
        ///
        /// Parameter `primitiveType`: The type of primitives that elements are assembled into.
        ///
        /// Parameter `vertexStart`: For each instance, the first index to draw
        ///
        /// Parameter `vertexCount`: For each instance, the number of indexes to draw
        #[unsafe(method(drawPrimitives:vertexStart:vertexCount:))]
        #[unsafe(method_family = none)]
        unsafe fn drawPrimitives_vertexStart_vertexCount(
            &self,
            primitive_type: MTLPrimitiveType,
            vertex_start: NSUInteger,
            vertex_count: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLStageInputOutputDescriptor"
        ))]
        /// Draw primitives with an index list.
        ///
        /// Parameter `primitiveType`: The type of primitives that elements are assembled into.
        ///
        /// Parameter `indexCount`: The number of indexes to read from the index buffer for each instance.
        ///
        /// Parameter `indexType`: The type if indexes, either 16 bit integer or 32 bit integer.
        ///
        /// Parameter `indexBuffer`: A buffer object that the device will read indexes from.
        ///
        /// Parameter `indexBufferOffset`: Byte offset within
        /// _indexBuffer_to start reading indexes from.
        /// _indexBufferOffset_must be a multiple of the index size.
        ///
        /// Parameter `instanceCount`: The number of instances drawn.
        #[unsafe(method(drawIndexedPrimitives:indexCount:indexType:indexBuffer:indexBufferOffset:instanceCount:))]
        #[unsafe(method_family = none)]
        unsafe fn drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_instanceCount(
            &self,
            primitive_type: MTLPrimitiveType,
            index_count: NSUInteger,
            index_type: MTLIndexType,
            index_buffer: &ProtocolObject<dyn MTLBuffer>,
            index_buffer_offset: NSUInteger,
            instance_count: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLStageInputOutputDescriptor"
        ))]
        /// Draw primitives with an index list.
        ///
        /// Parameter `primitiveType`: The type of primitives that elements are assembled into.
        ///
        /// Parameter `indexCount`: The number of indexes to read from the index buffer for each instance.
        ///
        /// Parameter `indexType`: The type if indexes, either 16 bit integer or 32 bit integer.
        ///
        /// Parameter `indexBuffer`: A buffer object that the device will read indexes from.
        ///
        /// Parameter `indexBufferOffset`: Byte offset within
        /// _indexBuffer_to start reading indexes from.
        /// _indexBufferOffset_must be a multiple of the index size.
        #[unsafe(method(drawIndexedPrimitives:indexCount:indexType:indexBuffer:indexBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset(
            &self,
            primitive_type: MTLPrimitiveType,
            index_count: NSUInteger,
            index_type: MTLIndexType,
            index_buffer: &ProtocolObject<dyn MTLBuffer>,
            index_buffer_offset: NSUInteger,
        );

        /// Draw primitives without an index list.
        ///
        /// Parameter `primitiveType`: The type of primitives that elements are assembled into.
        ///
        /// Parameter `vertexStart`: For each instance, the first index to draw
        ///
        /// Parameter `vertexCount`: For each instance, the number of indexes to draw
        ///
        /// Parameter `instanceCount`: The number of instances drawn.
        ///
        /// Parameter `baseInstance`: Offset for instance_id.
        #[unsafe(method(drawPrimitives:vertexStart:vertexCount:instanceCount:baseInstance:))]
        #[unsafe(method_family = none)]
        unsafe fn drawPrimitives_vertexStart_vertexCount_instanceCount_baseInstance(
            &self,
            primitive_type: MTLPrimitiveType,
            vertex_start: NSUInteger,
            vertex_count: NSUInteger,
            instance_count: NSUInteger,
            base_instance: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLStageInputOutputDescriptor"
        ))]
        /// Draw primitives with an index list.
        ///
        /// Parameter `primitiveType`: The type of primitives that elements are assembled into.
        ///
        /// Parameter `indexCount`: The number of indexes to read from the index buffer for each instance.
        ///
        /// Parameter `indexType`: The type if indexes, either 16 bit integer or 32 bit integer.
        ///
        /// Parameter `indexBuffer`: A buffer object that the device will read indexes from.
        ///
        /// Parameter `indexBufferOffset`: Byte offset within
        /// _indexBuffer_to start reading indexes from.
        /// _indexBufferOffset_must be a multiple of the index size.
        ///
        /// Parameter `instanceCount`: The number of instances drawn.
        ///
        /// Parameter `baseVertex`: Offset for vertex_id. NOTE: this can be negative
        ///
        /// Parameter `baseInstance`: Offset for instance_id.
        #[unsafe(method(drawIndexedPrimitives:indexCount:indexType:indexBuffer:indexBufferOffset:instanceCount:baseVertex:baseInstance:))]
        #[unsafe(method_family = none)]
        unsafe fn drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_instanceCount_baseVertex_baseInstance(
            &self,
            primitive_type: MTLPrimitiveType,
            index_count: NSUInteger,
            index_type: MTLIndexType,
            index_buffer: &ProtocolObject<dyn MTLBuffer>,
            index_buffer_offset: NSUInteger,
            instance_count: NSUInteger,
            base_vertex: NSInteger,
            base_instance: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Draw primitives without an index list using an indirect buffer see MTLDrawPrimitivesIndirectArguments.
        ///
        /// Parameter `primitiveType`: The type of primitives that elements are assembled into.
        ///
        /// Parameter `indirectBuffer`: A buffer object that the device will read drawPrimitives arguments from, see MTLDrawPrimitivesIndirectArguments.
        ///
        /// Parameter `indirectBufferOffset`: Byte offset within
        /// _indirectBuffer_to start reading indexes from.
        /// _indirectBufferOffset_must be a multiple of 4.
        #[unsafe(method(drawPrimitives:indirectBuffer:indirectBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn drawPrimitives_indirectBuffer_indirectBufferOffset(
            &self,
            primitive_type: MTLPrimitiveType,
            indirect_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLStageInputOutputDescriptor"
        ))]
        /// Draw primitives with an index list using an indirect buffer see MTLDrawIndexedPrimitivesIndirectArguments.
        ///
        /// Parameter `primitiveType`: The type of primitives that elements are assembled into.
        ///
        /// Parameter `indexType`: The type if indexes, either 16 bit integer or 32 bit integer.
        ///
        /// Parameter `indexBuffer`: A buffer object that the device will read indexes from.
        ///
        /// Parameter `indexBufferOffset`: Byte offset within
        /// _indexBuffer_to start reading indexes from.
        /// _indexBufferOffset_must be a multiple of the index size.
        ///
        /// Parameter `indirectBuffer`: A buffer object that the device will read drawIndexedPrimitives arguments from, see MTLDrawIndexedPrimitivesIndirectArguments.
        ///
        /// Parameter `indirectBufferOffset`: Byte offset within
        /// _indirectBuffer_to start reading indexes from.
        /// _indirectBufferOffset_must be a multiple of 4.
        #[unsafe(method(drawIndexedPrimitives:indexType:indexBuffer:indexBufferOffset:indirectBuffer:indirectBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn drawIndexedPrimitives_indexType_indexBuffer_indexBufferOffset_indirectBuffer_indirectBufferOffset(
            &self,
            primitive_type: MTLPrimitiveType,
            index_type: MTLIndexType,
            index_buffer: &ProtocolObject<dyn MTLBuffer>,
            index_buffer_offset: NSUInteger,
            indirect_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
        );

        /// Ensure that following fragment shaders can read textures written by previous draw calls (in particular the framebuffer)
        #[deprecated]
        #[unsafe(method(textureBarrier))]
        #[unsafe(method_family = none)]
        unsafe fn textureBarrier(&self);

        #[cfg(feature = "MTLFence")]
        /// Update the fence to capture all GPU work so far enqueued by this encoder for the given stages.
        ///
        /// Unlike
        /// <st
        /// >updateFence:
        /// </st
        /// >, this method will update the fence when the given stage(s) complete, allowing for commands to overlap in execution.
        /// On iOS, render command encoder fence updates are always delayed until the end of the encoder.
        #[unsafe(method(updateFence:afterStages:))]
        #[unsafe(method_family = none)]
        fn updateFence_afterStages(
            &self,
            fence: &ProtocolObject<dyn MTLFence>,
            stages: MTLRenderStages,
        );

        #[cfg(feature = "MTLFence")]
        /// Prevent further GPU work until the fence is reached for the given stages.
        ///
        /// Unlike
        /// <st
        /// >waitForFence:
        /// </st
        /// >, this method will only block commands assoicated with the given stage(s), allowing for commands to overlap in execution.
        /// On iOS, render command encoder fence waits always occur the beginning of the encoder.
        #[unsafe(method(waitForFence:beforeStages:))]
        #[unsafe(method_family = none)]
        fn waitForFence_beforeStages(
            &self,
            fence: &ProtocolObject<dyn MTLFence>,
            stages: MTLRenderStages,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        #[unsafe(method(setTessellationFactorBuffer:offset:instanceStride:))]
        #[unsafe(method_family = none)]
        unsafe fn setTessellationFactorBuffer_offset_instanceStride(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            instance_stride: NSUInteger,
        );

        #[unsafe(method(setTessellationFactorScale:))]
        #[unsafe(method_family = none)]
        unsafe fn setTessellationFactorScale(&self, scale: c_float);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        #[unsafe(method(drawPatches:patchStart:patchCount:patchIndexBuffer:patchIndexBufferOffset:instanceCount:baseInstance:))]
        #[unsafe(method_family = none)]
        unsafe fn drawPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_instanceCount_baseInstance(
            &self,
            number_of_patch_control_points: NSUInteger,
            patch_start: NSUInteger,
            patch_count: NSUInteger,
            patch_index_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            patch_index_buffer_offset: NSUInteger,
            instance_count: NSUInteger,
            base_instance: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        #[unsafe(method(drawPatches:patchIndexBuffer:patchIndexBufferOffset:indirectBuffer:indirectBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn drawPatches_patchIndexBuffer_patchIndexBufferOffset_indirectBuffer_indirectBufferOffset(
            &self,
            number_of_patch_control_points: NSUInteger,
            patch_index_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            patch_index_buffer_offset: NSUInteger,
            indirect_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        #[unsafe(method(drawIndexedPatches:patchStart:patchCount:patchIndexBuffer:patchIndexBufferOffset:controlPointIndexBuffer:controlPointIndexBufferOffset:instanceCount:baseInstance:))]
        #[unsafe(method_family = none)]
        unsafe fn drawIndexedPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_controlPointIndexBuffer_controlPointIndexBufferOffset_instanceCount_baseInstance(
            &self,
            number_of_patch_control_points: NSUInteger,
            patch_start: NSUInteger,
            patch_count: NSUInteger,
            patch_index_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            patch_index_buffer_offset: NSUInteger,
            control_point_index_buffer: &ProtocolObject<dyn MTLBuffer>,
            control_point_index_buffer_offset: NSUInteger,
            instance_count: NSUInteger,
            base_instance: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        #[unsafe(method(drawIndexedPatches:patchIndexBuffer:patchIndexBufferOffset:controlPointIndexBuffer:controlPointIndexBufferOffset:indirectBuffer:indirectBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn drawIndexedPatches_patchIndexBuffer_patchIndexBufferOffset_controlPointIndexBuffer_controlPointIndexBufferOffset_indirectBuffer_indirectBufferOffset(
            &self,
            number_of_patch_control_points: NSUInteger,
            patch_index_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            patch_index_buffer_offset: NSUInteger,
            control_point_index_buffer: &ProtocolObject<dyn MTLBuffer>,
            control_point_index_buffer_offset: NSUInteger,
            indirect_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
        );

        /// The width of the tile for this render pass.
        #[unsafe(method(tileWidth))]
        #[unsafe(method_family = none)]
        unsafe fn tileWidth(&self) -> NSUInteger;

        /// The height of the tile for this render pass.
        #[unsafe(method(tileHeight))]
        #[unsafe(method_family = none)]
        unsafe fn tileHeight(&self) -> NSUInteger;

        /// Set the data (by copy) for a given tile buffer binding point.  This will remove any existing MTLBuffer from the binding point.
        #[unsafe(method(setTileBytes:length:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileBytes_length_atIndex(
            &self,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set a global buffer for all tile shaders at the given bind point index.
        #[unsafe(method(setTileBuffer:offset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileBuffer_offset_atIndex(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            index: NSUInteger,
        );

        /// Set the offset within the current global buffer for all tile shaders at the given bind point index.
        #[unsafe(method(setTileBufferOffset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileBufferOffset_atIndex(&self, offset: NSUInteger, index: NSUInteger);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set an array of global buffers for all tile shaders with the given bind point range.
        #[unsafe(method(setTileBuffers:offsets:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileBuffers_offsets_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set a global texture for all tile shaders at the given bind point index.
        #[unsafe(method(setTileTexture:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileTexture_atIndex(
            &self,
            texture: Option<&ProtocolObject<dyn MTLTexture>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set an array of global textures for all tile shaders with the given bind point range.
        #[unsafe(method(setTileTextures:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileTextures_withRange(
            &self,
            textures: NonNull<*const ProtocolObject<dyn MTLTexture>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all tile shaders at the given bind point index.
        #[unsafe(method(setTileSamplerState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileSamplerState_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all fragment shaders with the given bind point range.
        #[unsafe(method(setTileSamplerStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileSamplerStates_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all tile shaders at the given bind point index.
        #[unsafe(method(setTileSamplerState:lodMinClamp:lodMaxClamp:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileSamplerState_lodMinClamp_lodMaxClamp_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamp: c_float,
            lod_max_clamp: c_float,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all tile shaders with the given bind point range.
        #[unsafe(method(setTileSamplerStates:lodMinClamps:lodMaxClamps:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileSamplerStates_lodMinClamps_lodMaxClamps_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamps: NonNull<c_float>,
            lod_max_clamps: NonNull<c_float>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set a global visible function table for all tile shaders at the given buffer bind point index.
        #[unsafe(method(setTileVisibleFunctionTable:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileVisibleFunctionTable_atBufferIndex(
            &self,
            function_table: Option<&ProtocolObject<dyn MTLVisibleFunctionTable>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set an array of global visible function tables for all tile shaders with the given buffer bind point range.
        #[unsafe(method(setTileVisibleFunctionTables:withBufferRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileVisibleFunctionTables_withBufferRange(
            &self,
            function_tables: NonNull<*const ProtocolObject<dyn MTLVisibleFunctionTable>>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set a global intersection function table for all tile shaders at the given buffer bind point index.
        #[unsafe(method(setTileIntersectionFunctionTable:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileIntersectionFunctionTable_atBufferIndex(
            &self,
            intersection_function_table: Option<&ProtocolObject<dyn MTLIntersectionFunctionTable>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set an array of global intersection function tables for all tile shaders with the given buffer bind point range.
        #[unsafe(method(setTileIntersectionFunctionTables:withBufferRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileIntersectionFunctionTables_withBufferRange(
            &self,
            intersection_function_tables: NonNull<
                *const ProtocolObject<dyn MTLIntersectionFunctionTable>,
            >,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLResource"
        ))]
        /// Set a global acceleration structure for all tile shaders at the given buffer bind point index.
        #[unsafe(method(setTileAccelerationStructure:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTileAccelerationStructure_atBufferIndex(
            &self,
            acceleration_structure: Option<&ProtocolObject<dyn MTLAccelerationStructure>>,
            buffer_index: NSUInteger,
        );

        #[cfg(feature = "MTLTypes")]
        /// dispatch threads to perform a mid-render compute operation.
        #[unsafe(method(dispatchThreadsPerTile:))]
        #[unsafe(method_family = none)]
        unsafe fn dispatchThreadsPerTile(&self, threads_per_tile: MTLSize);

        /// Set the size of the threadgroup memory argument at the given bind point index and offset.
        #[unsafe(method(setThreadgroupMemoryLength:offset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setThreadgroupMemoryLength_offset_atIndex(
            &self,
            length: NSUInteger,
            offset: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Declare that a resource may be accessed by the render pass through an argument buffer
        ///
        /// This method does not protect against data hazards; these hazards must be addressed using an MTLFence. This method must be called before encoding any draw commands which may access the resource through an argument buffer. However, this method may cause color attachments to become decompressed. Therefore, this method should be called until as late as possible within a render command encoder. Declaring a minimal usage (i.e. read-only) may prevent color attachments from becoming decompressed on some devices.
        ///
        /// Note that calling useResource does not retain the resource. It is the responsiblity of the user to retain the resource until
        /// the command buffer has been executed.
        #[deprecated]
        #[unsafe(method(useResource:usage:))]
        #[unsafe(method_family = none)]
        fn useResource_usage(
            &self,
            resource: &ProtocolObject<dyn MTLResource>,
            usage: MTLResourceUsage,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Declare that an array of resources may be accessed through an argument buffer by the render pass
        ///
        /// This method does not protect against data hazards; these hazards must be addressed using an MTLFence. This method must be called before encoding any draw commands which may access the resources through an argument buffer. However, this method may cause color attachments to become decompressed. Therefore, this method should be called until as late as possible within a render command encoder. Declaring a minimal usage (i.e. read-only) may prevent color attachments from becoming decompressed on some devices.
        ///
        /// Note that calling useResources does not retain the resources. It is the responsiblity of the user to retain the resources until
        /// the command buffer has been executed.
        #[deprecated]
        #[unsafe(method(useResources:count:usage:))]
        #[unsafe(method_family = none)]
        unsafe fn useResources_count_usage(
            &self,
            resources: NonNull<NonNull<ProtocolObject<dyn MTLResource>>>,
            count: NSUInteger,
            usage: MTLResourceUsage,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Declare that a resource may be accessed by the render pass through an argument buffer
        ///
        /// For hazard tracked resources, this method protects against data hazards. This method must be called before encoding any draw commands which may access the resource through an argument buffer. However, this method may cause color attachments to become decompressed. Therefore, this method should be called until as late as possible within a render command encoder. Declaring a minimal usage (i.e. read-only) may prevent color attachments from becoming decompressed on some devices.
        ///
        /// Note that calling useResource does not retain the resource. It is the responsiblity of the user to retain the resource until
        /// the command buffer has been executed.
        #[unsafe(method(useResource:usage:stages:))]
        #[unsafe(method_family = none)]
        fn useResource_usage_stages(
            &self,
            resource: &ProtocolObject<dyn MTLResource>,
            usage: MTLResourceUsage,
            stages: MTLRenderStages,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Declare that an array of resources may be accessed through an argument buffer by the render pass
        ///
        /// For hazard tracked resources, this method protects against data hazards.  This method must be called before encoding any draw commands which may access the resources through an argument buffer. However, this method may cause color attachments to become decompressed. Therefore, this method should be called until as late as possible within a render command encoder. Declaring a minimal usage (i.e. read-only) may prevent color attachments from becoming decompressed on some devices.
        ///
        /// Note that calling useResources does not retain the resources. It is the responsiblity of the user to retain the resources until
        /// the command buffer has been executed.
        #[unsafe(method(useResources:count:usage:stages:))]
        #[unsafe(method_family = none)]
        unsafe fn useResources_count_usage_stages(
            &self,
            resources: NonNull<NonNull<ProtocolObject<dyn MTLResource>>>,
            count: NSUInteger,
            usage: MTLResourceUsage,
            stages: MTLRenderStages,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLHeap"))]
        /// Declare that the resources allocated from a heap may be accessed by the render pass through an argument buffer
        ///
        /// This method does not protect against data hazards; these hazards must be addressed using an MTLFence. This method must be called before encoding any draw commands which may access the resources allocated from the heap through an argument buffer. This method may cause all of the color attachments allocated from the heap to become decompressed. Therefore, it is recommended that the useResource:usage: or useResources:count:usage: methods be used for color attachments instead, with a minimal (i.e. read-only) usage.
        #[deprecated]
        #[unsafe(method(useHeap:))]
        #[unsafe(method_family = none)]
        fn useHeap(&self, heap: &ProtocolObject<dyn MTLHeap>);

        #[cfg(all(feature = "MTLAllocation", feature = "MTLHeap"))]
        /// Declare that the resources allocated from an array of heaps may be accessed by the render pass through an argument buffer
        ///
        /// This method does not protect against data hazards; these hazards must be addressed using an MTLFence. This method must be called before encoding any draw commands which may access the resources allocated from the heaps through an argument buffer. This method may cause all of the color attachments allocated from the heaps to become decompressed. Therefore, it is recommended that the useResource:usage: or useResources:count:usage: methods be used for color attachments instead, with a minimal (i.e. read-only) usage.
        #[deprecated]
        #[unsafe(method(useHeaps:count:))]
        #[unsafe(method_family = none)]
        unsafe fn useHeaps_count(
            &self,
            heaps: NonNull<NonNull<ProtocolObject<dyn MTLHeap>>>,
            count: NSUInteger,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLHeap"))]
        /// Declare that the resources allocated from a heap may be accessed by the render pass through an argument buffer
        ///
        /// If the heap is tracked, this method protects against hazard tracking; these hazards must be addressed using an MTLFence. This method must be called before encoding any draw commands which may access the resources allocated from the heap through an argument buffer. This method may cause all of the color attachments allocated from the heap to become decompressed. Therefore, it is recommended that the useResource:usage: or useResources:count:usage: methods be used for color attachments instead, with a minimal (i.e. read-only) usage.
        #[unsafe(method(useHeap:stages:))]
        #[unsafe(method_family = none)]
        fn useHeap_stages(&self, heap: &ProtocolObject<dyn MTLHeap>, stages: MTLRenderStages);

        #[cfg(all(feature = "MTLAllocation", feature = "MTLHeap"))]
        /// Declare that the resources allocated from an array of heaps may be accessed by the render pass through an argument buffer
        ///
        /// This method does not protect against data hazards; these hazards must be addressed using an MTLFence. This method must be called before encoding any draw commands which may access the resources allocated from the heaps through an argument buffer. This method may cause all of the color attachments allocated from the heaps to become decompressed. Therefore, it is recommended that the useResource:usage: or useResources:count:usage: methods be used for color attachments instead, with a minimal (i.e. read-only) usage.
        #[unsafe(method(useHeaps:count:stages:))]
        #[unsafe(method_family = none)]
        unsafe fn useHeaps_count_stages(
            &self,
            heaps: NonNull<NonNull<ProtocolObject<dyn MTLHeap>>>,
            count: NSUInteger,
            stages: MTLRenderStages,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// Execute commands in the buffer within the range specified.
        ///
        /// The same indirect command buffer may be executed any number of times within the same encoder.
        #[unsafe(method(executeCommandsInBuffer:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn executeCommandsInBuffer_withRange(
            &self,
            indirect_command_buffer: &ProtocolObject<dyn MTLIndirectCommandBuffer>,
            execution_range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// Execute commands in the buffer within the range specified by the indirect range buffer.
        ///
        /// Parameter `indirectRangeBuffer`: An indirect buffer from which the device reads the execution range parameter, as laid out in the MTLIndirectCommandBufferExecutionRange structure.
        ///
        /// Parameter `indirectBufferOffset`: The byte offset within indirectBuffer where the execution range parameter is located. Must be a multiple of 4 bytes.
        ///
        /// The same indirect command buffer may be executed any number of times within the same encoder.
        #[unsafe(method(executeCommandsInBuffer:indirectBuffer:indirectBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn executeCommandsInBuffer_indirectBuffer_indirectBufferOffset(
            &self,
            indirect_commandbuffer: &ProtocolObject<dyn MTLIndirectCommandBuffer>,
            indirect_range_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
        );

        /// Make stores to memory encoded before the barrier coherent with loads from memory encoded after the barrier.
        ///
        /// The barrier makes stores coherent that 1) are to a resource with a type in the given scope, and 2) happen at (or before) the stage given by afterStages. Only affects loads that happen at (or after) the stage given by beforeStages.
        #[unsafe(method(memoryBarrierWithScope:afterStages:beforeStages:))]
        #[unsafe(method_family = none)]
        unsafe fn memoryBarrierWithScope_afterStages_beforeStages(
            &self,
            scope: MTLBarrierScope,
            after: MTLRenderStages,
            before: MTLRenderStages,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Make stores to memory encoded before the barrier coherent with loads from memory encoded after the barrier.
        ///
        /// The barrier makes stores coherent that 1) are to resources in given array, and 2) happen at (or before) the stage given by afterStages. Only affects loads that happen at (or after) the stage give by beforeStages.
        #[unsafe(method(memoryBarrierWithResources:count:afterStages:beforeStages:))]
        #[unsafe(method_family = none)]
        unsafe fn memoryBarrierWithResources_count_afterStages_beforeStages(
            &self,
            resources: NonNull<NonNull<ProtocolObject<dyn MTLResource>>>,
            count: NSUInteger,
            after: MTLRenderStages,
            before: MTLRenderStages,
        );

        #[cfg(feature = "MTLCounters")]
        /// Sample hardware counters at this point in the render encoder and
        /// store the counter sample into the sample buffer at the specified index.
        ///
        /// Parameter `sampleBuffer`: The sample buffer to sample into
        ///
        /// Parameter `sampleIndex`: The index into the counter buffer to write the sample.
        ///
        /// Parameter `barrier`: Insert a barrier before taking the sample.  Passing
        /// YES will ensure that all work encoded before this operation in the encoder is
        /// complete but does not isolate the work with respect to other encoders.  Passing
        /// NO will allow the sample to be taken concurrently with other operations in this
        /// encoder.
        /// In general, passing YES will lead to more repeatable counter results but
        /// may negatively impact performance.  Passing NO will generally be higher performance
        /// but counter results may not be repeatable.
        #[unsafe(method(sampleCountersInBuffer:atSampleIndex:withBarrier:))]
        #[unsafe(method_family = none)]
        unsafe fn sampleCountersInBuffer_atSampleIndex_withBarrier(
            &self,
            sample_buffer: &ProtocolObject<dyn MTLCounterSampleBuffer>,
            sample_index: NSUInteger,
            barrier: bool,
        );
    }
);
