//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// A bitfield of options to create a stitched library
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlstitchedlibraryoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLStitchedLibraryOptions(pub NSUInteger);
bitflags::bitflags! {
    impl MTLStitchedLibraryOptions: NSUInteger {
        #[doc(alias = "MTLStitchedLibraryOptionNone")]
        const None = 0;
/// Library creation fails (i.e nil is returned) if:
/// - A lookup binary archive has been specified
/// - The library has not been found in the archive
        #[doc(alias = "MTLStitchedLibraryOptionFailOnBinaryArchiveMiss")]
        const FailOnBinaryArchiveMiss = 1<<0;
/// stores and tracks this library in a Metal Pipelines Script
/// This flag is optional and only supported in the context of binary archives.
///
/// This flag is required for inspecting and consuming binary archives with stitched libraries via the metal-source tool. It is not required for recompilation, nor for storing stitched libraries in binary archives. Set this flag only if you intend to use metal-source on a serialized binary archive.
        #[doc(alias = "MTLStitchedLibraryOptionStoreLibraryInMetalPipelinesScript")]
        const StoreLibraryInMetalPipelinesScript = 1<<1;
    }
}

unsafe impl Encode for MTLStitchedLibraryOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLStitchedLibraryOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// An attribute to be applied to the produced stitched function.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunctionstitchingattribute?language=objc)
    pub unsafe trait MTLFunctionStitchingAttribute: NSObjectProtocol {}
);

extern_class!(
    /// Applies the `__attribute__((always_inline))` attribute to the produced stitched function.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunctionstitchingattributealwaysinline?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLFunctionStitchingAttributeAlwaysInline;
);

extern_conformance!(
    unsafe impl MTLFunctionStitchingAttribute for MTLFunctionStitchingAttributeAlwaysInline {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLFunctionStitchingAttributeAlwaysInline {}
);

impl MTLFunctionStitchingAttributeAlwaysInline {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl MTLFunctionStitchingAttributeAlwaysInline {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// A node used in a graph for stitching.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunctionstitchingnode?language=objc)
    pub unsafe trait MTLFunctionStitchingNode: NSObjectProtocol + NSCopying {}
);

extern_class!(
    /// An indexed input node of the produced stitched function.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunctionstitchinginputnode?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLFunctionStitchingInputNode;
);

extern_conformance!(
    unsafe impl MTLFunctionStitchingNode for MTLFunctionStitchingInputNode {}
);

extern_conformance!(
    unsafe impl NSCopying for MTLFunctionStitchingInputNode {}
);

unsafe impl CopyingHelper for MTLFunctionStitchingInputNode {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLFunctionStitchingInputNode {}
);

impl MTLFunctionStitchingInputNode {
    extern_methods!(
        #[unsafe(method(argumentIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn argumentIndex(&self) -> NSUInteger;

        /// Setter for [`argumentIndex`][Self::argumentIndex].
        #[unsafe(method(setArgumentIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setArgumentIndex(&self, argument_index: NSUInteger);

        #[unsafe(method(initWithArgumentIndex:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithArgumentIndex(
            this: Allocated<Self>,
            argument: NSUInteger,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLFunctionStitchingInputNode {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// A function node that calls the specified function with arguments and ordering determined by data and control dependencies.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunctionstitchingfunctionnode?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLFunctionStitchingFunctionNode;
);

extern_conformance!(
    unsafe impl MTLFunctionStitchingNode for MTLFunctionStitchingFunctionNode {}
);

extern_conformance!(
    unsafe impl NSCopying for MTLFunctionStitchingFunctionNode {}
);

unsafe impl CopyingHelper for MTLFunctionStitchingFunctionNode {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLFunctionStitchingFunctionNode {}
);

impl MTLFunctionStitchingFunctionNode {
    extern_methods!(
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Retained<NSString>;

        /// Setter for [`name`][Self::name].
        #[unsafe(method(setName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setName(&self, name: &NSString);

        #[unsafe(method(arguments))]
        #[unsafe(method_family = none)]
        pub unsafe fn arguments(
            &self,
        ) -> Retained<NSArray<ProtocolObject<dyn MTLFunctionStitchingNode>>>;

        /// Setter for [`arguments`][Self::arguments].
        #[unsafe(method(setArguments:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setArguments(
            &self,
            arguments: &NSArray<ProtocolObject<dyn MTLFunctionStitchingNode>>,
        );

        #[unsafe(method(controlDependencies))]
        #[unsafe(method_family = none)]
        pub unsafe fn controlDependencies(
            &self,
        ) -> Retained<NSArray<MTLFunctionStitchingFunctionNode>>;

        /// Setter for [`controlDependencies`][Self::controlDependencies].
        #[unsafe(method(setControlDependencies:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setControlDependencies(
            &self,
            control_dependencies: &NSArray<MTLFunctionStitchingFunctionNode>,
        );

        #[unsafe(method(initWithName:arguments:controlDependencies:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithName_arguments_controlDependencies(
            this: Allocated<Self>,
            name: &NSString,
            arguments: &NSArray<ProtocolObject<dyn MTLFunctionStitchingNode>>,
            control_dependencies: &NSArray<MTLFunctionStitchingFunctionNode>,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLFunctionStitchingFunctionNode {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// A function graph that describes a directed acyclic graph.
    ///
    /// The return value of the output node will be used as the return value for the final stitched graph.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlfunctionstitchinggraph?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLFunctionStitchingGraph;
);

extern_conformance!(
    unsafe impl NSCopying for MTLFunctionStitchingGraph {}
);

unsafe impl CopyingHelper for MTLFunctionStitchingGraph {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLFunctionStitchingGraph {}
);

impl MTLFunctionStitchingGraph {
    extern_methods!(
        #[unsafe(method(functionName))]
        #[unsafe(method_family = none)]
        pub unsafe fn functionName(&self) -> Retained<NSString>;

        /// Setter for [`functionName`][Self::functionName].
        #[unsafe(method(setFunctionName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFunctionName(&self, function_name: &NSString);

        #[unsafe(method(nodes))]
        #[unsafe(method_family = none)]
        pub unsafe fn nodes(&self) -> Retained<NSArray<MTLFunctionStitchingFunctionNode>>;

        /// Setter for [`nodes`][Self::nodes].
        #[unsafe(method(setNodes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNodes(&self, nodes: &NSArray<MTLFunctionStitchingFunctionNode>);

        #[unsafe(method(outputNode))]
        #[unsafe(method_family = none)]
        pub unsafe fn outputNode(&self) -> Option<Retained<MTLFunctionStitchingFunctionNode>>;

        /// Setter for [`outputNode`][Self::outputNode].
        #[unsafe(method(setOutputNode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOutputNode(&self, output_node: Option<&MTLFunctionStitchingFunctionNode>);

        #[unsafe(method(attributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributes(
            &self,
        ) -> Retained<NSArray<ProtocolObject<dyn MTLFunctionStitchingAttribute>>>;

        /// Setter for [`attributes`][Self::attributes].
        #[unsafe(method(setAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributes(
            &self,
            attributes: &NSArray<ProtocolObject<dyn MTLFunctionStitchingAttribute>>,
        );

        #[unsafe(method(initWithFunctionName:nodes:outputNode:attributes:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFunctionName_nodes_outputNode_attributes(
            this: Allocated<Self>,
            function_name: &NSString,
            nodes: &NSArray<MTLFunctionStitchingFunctionNode>,
            output_node: Option<&MTLFunctionStitchingFunctionNode>,
            attributes: &NSArray<ProtocolObject<dyn MTLFunctionStitchingAttribute>>,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLFunctionStitchingGraph {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// A container for the graphs and functions needed to create the stitched functions described by the graphs.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlstitchedlibrarydescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLStitchedLibraryDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLStitchedLibraryDescriptor {}
);

unsafe impl CopyingHelper for MTLStitchedLibraryDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLStitchedLibraryDescriptor {}
);

impl MTLStitchedLibraryDescriptor {
    extern_methods!(
        #[unsafe(method(functionGraphs))]
        #[unsafe(method_family = none)]
        pub unsafe fn functionGraphs(&self) -> Retained<NSArray<MTLFunctionStitchingGraph>>;

        /// Setter for [`functionGraphs`][Self::functionGraphs].
        #[unsafe(method(setFunctionGraphs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFunctionGraphs(
            &self,
            function_graphs: &NSArray<MTLFunctionStitchingGraph>,
        );

        #[cfg(feature = "MTLLibrary")]
        #[unsafe(method(functions))]
        #[unsafe(method_family = none)]
        pub unsafe fn functions(&self) -> Retained<NSArray<ProtocolObject<dyn MTLFunction>>>;

        #[cfg(feature = "MTLLibrary")]
        /// Setter for [`functions`][Self::functions].
        #[unsafe(method(setFunctions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFunctions(&self, functions: &NSArray<ProtocolObject<dyn MTLFunction>>);

        #[cfg(feature = "MTLBinaryArchive")]
        /// The array of archives to be searched.
        ///
        /// Binary archives to be searched for precompiled stitched libraries during the compilation of this library.
        #[unsafe(method(binaryArchives))]
        #[unsafe(method_family = none)]
        pub unsafe fn binaryArchives(
            &self,
        ) -> Retained<NSArray<ProtocolObject<dyn MTLBinaryArchive>>>;

        #[cfg(feature = "MTLBinaryArchive")]
        /// Setter for [`binaryArchives`][Self::binaryArchives].
        #[unsafe(method(setBinaryArchives:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBinaryArchives(
            &self,
            binary_archives: &NSArray<ProtocolObject<dyn MTLBinaryArchive>>,
        );

        /// The options to use for this new MTLLibrary.
        #[unsafe(method(options))]
        #[unsafe(method_family = none)]
        pub unsafe fn options(&self) -> MTLStitchedLibraryOptions;

        /// Setter for [`options`][Self::options].
        #[unsafe(method(setOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOptions(&self, options: MTLStitchedLibraryOptions);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLStitchedLibraryDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
