// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListStreamConsumers`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_arn(impl Into<String>)`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::stream_arn) / [`set_stream_arn(Option<String>)`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::set_stream_arn):<br>required: **true**<br><p>The ARN of the Kinesis data stream for which you want to list the registered consumers. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p><br>
    ///   - [`next_token(impl Into<String>)`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::next_token) / [`set_next_token(Option<String>)`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::set_next_token):<br>required: **false**<br><p>When the number of consumers that are registered with the data stream is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of consumers that are registered with the data stream, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListStreamConsumers</code> to list the next set of registered consumers.</p> <p>Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify <code>NextToken</code> because the latter unambiguously identifies the stream.</p> <p>You can optionally specify a value for the <code>MaxResults</code> parameter when you specify <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of consumers that the operation returns if you don't specify <code>MaxResults</code>, the response will contain a new <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call to the <code>ListStreamConsumers</code> operation to list the next set of consumers.</p><important>  <p>Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an expired token in a call to <code>ListStreamConsumers</code>, you get <code>ExpiredNextTokenException</code>.</p> </important><br>
    ///   - [`max_results(i32)`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::max_results) / [`set_max_results(Option<i32>)`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::set_max_results):<br>required: **false**<br><p>The maximum number of consumers that you want a single call of <code>ListStreamConsumers</code> to return. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.</p><br>
    ///   - [`stream_creation_timestamp(DateTime)`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::stream_creation_timestamp) / [`set_stream_creation_timestamp(Option<DateTime>)`](crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::set_stream_creation_timestamp):<br>required: **false**<br><p>Specify this input parameter to distinguish data streams that have the same name. For example, if you create a data stream and then delete it, and you later create another data stream with the same name, you can use this input parameter to specify which of the two streams you want to list the consumers for.</p> <p>You can't specify this parameter if you specify the NextToken parameter.</p><br>
    /// - On success, responds with [`ListStreamConsumersOutput`](crate::operation::list_stream_consumers::ListStreamConsumersOutput) with field(s):
    ///   - [`consumers(Option<Vec::<Consumer>>)`](crate::operation::list_stream_consumers::ListStreamConsumersOutput::consumers): <p>An array of JSON objects. Each object represents one registered consumer.</p>
    ///   - [`next_token(Option<String>)`](crate::operation::list_stream_consumers::ListStreamConsumersOutput::next_token): <p>When the number of consumers that are registered with the data stream is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of registered consumers, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListStreamConsumers</code> to list the next set of registered consumers. For more information about the use of this pagination token when calling the <code>ListStreamConsumers</code> operation, see <code>ListStreamConsumersInput$NextToken</code>.</p><important>  <p>Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an expired token in a call to <code>ListStreamConsumers</code>, you get <code>ExpiredNextTokenException</code>.</p> </important>
    /// - On failure, responds with [`SdkError<ListStreamConsumersError>`](crate::operation::list_stream_consumers::ListStreamConsumersError)
    pub fn list_stream_consumers(&self) -> crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder {
        crate::operation::list_stream_consumers::builders::ListStreamConsumersFluentBuilder::new(self.handle.clone())
    }
}
