/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_km extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "KHR", "\u17db" },
            { "LSL", "\u17a1\u17bc\u1791\u17b8" },
            { "PHP", "PHP" },
            { "THB", "\u0e3f" },
            { "USD", "$" },
            { "aed", "\u178c\u17c0\u179a\u17a0\u17b6\u17c6\u200b\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u179a\u17bd\u1798" },
            { "afn", "\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1782\u17b6\u1793\u17b8\u200b\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1782\u17b6\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "all", "\u179b\u17b7\u1780\u200b\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8" },
            { "amd", "\u178a\u17d2\u179a\u17b6\u17c6\u200b\u17a2\u17b6\u1798\u17c1\u1793\u17b8" },
            { "ang", "\u17a0\u17d2\u1782\u17b8\u178c\u17b7\u1793\u200b\u17a0\u17bb\u179b\u17d2\u179b\u1784\u17cb\u200b\u17a2\u1784\u17cb\u1791\u17b8\u179b\u17c0\u1793" },
            { "aoa", "\u1780\u17d2\u179c\u17b6\u1793\u17cb\u17a0\u17d2\u179f\u17b6\u200b\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17c4\u17a1\u17b6" },
            { "ars", "\u1794\u17c9\u17c1\u179f\u17bd\u17a2\u17b6\u17a0\u17d2\u179f\u1784\u17cb\u1791\u17b8\u1793" },
            { "aud", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u179b\u17b8" },
            { "awg", "\u17a0\u17d2\u179c\u17d2\u179a\u17d0\u179a\u179a\u17b7\u1789\u200b\u17a2\u17b6\u179a\u17c9\u17bc\u1794\u17b6" },
            { "azn", "\u1798\u17c9\u17b6\u178e\u17b6\u178f\u200b\u17a2\u17b6\u179f\u17ca\u17c2\u1794\u17c3\u17a0\u17d2\u179f\u1784\u17cb" },
            { "bam", "\u1798\u17c9\u17b6\u1780\u200b\u17a2\u17b6\u1785\u200b\u1794\u1798\u17d2\u179b\u17c2\u1784\u200b\u1794\u17b6\u1793\u200b\u1794\u17bc\u179f\u17d2\u1793\u17b8" },
            { "bbd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1794\u17b6\u1794\u17b6\u178a\u17bb\u179f" },
            { "bdt", "\u178f\u17b6\u1780\u17b6\u200b\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c2\u179f" },
            { "bgn", "\u179b\u17b8\u179c\u200b\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1782\u17b6\u179a\u17b8" },
            { "bhd", "\u178c\u17b8\u178e\u17b6\u200b\u1794\u17b6\u179a\u17c9\u17c2\u1793" },
            { "bif", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb\u200b\u1794\u17ca\u17bc\u179a\u17bb\u1793\u178c\u17b8" },
            { "bmd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1794\u17ca\u17ba\u1798\u17bb\u1799\u178a\u17b6" },
            { "bnd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u1796\u17d2\u179a\u17bb\u1799\u178e\u17c1" },
            { "bob", "\u1794\u17bc\u179b\u17b8\u179c\u17b8\u178e\u17bc\u200b\u1794\u17bc\u179b\u17b8\u179c\u17b8" },
            { "brl", "\u179a\u17c0\u179b\u200b\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b" },
            { "bsd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1794\u17b6\u17a0\u17b6\u1798\u17c9\u17b6" },
            { "btn", "\u1789\u17bc\u179b\u178f\u17d2\u179a\u17b9\u1798\u200b\u1794\u17ca\u17bc\u178f\u17b6\u1793" },
            { "bwp", "\u1796\u17bc\u17a1\u17b6\u200b\u1794\u17bb\u178f\u179f\u17d2\u179c\u17b6\u178e\u17b6" },
            { "byn", "\u179a\u17c9\u17bc\u1794\u179b\u200b\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f" },
            { "byr", "\u179a\u17c9\u17bc\u1794\u179b\u200b\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f (2000\u20132016)" },
            { "bzd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1794\u17c1\u179b\u17b8" },
            { "cad", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1780\u17b6\u178e\u17b6\u178a\u17b6" },
            { "cdf", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb\u200b\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4" },
            { "chf", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb\u179f\u17d2\u179c\u17b8\u179f" },
            { "clp", "\u1794\u17c9\u17c1\u179f\u17bc\u1788\u17b8\u179b\u17b8" },
            { "cnh", "\u1799\u17d0\u1793\u1785\u17b7\u1793 (\u1780\u17d2\u179a\u17c5\u1794\u17d2\u179a\u1791\u17c1\u179f)" },
            { "cny", "\u1799\u17d0\u1793\u1785\u17b7\u1793" },
            { "cop", "\u1794\u17c9\u17c1\u179f\u17bc\u1780\u17bc\u17a1\u17bb\u17c6\u1794\u17ca\u17b8" },
            { "crc", "\u1780\u17bc\u17a1\u17bb\u1784\u200b\u1780\u17bc\u179f\u17d2\u178f\u17b6\u179a\u17b8\u1780\u17b6" },
            { "cuc", "\u1794\u17c9\u17c1\u179f\u17bc\u200b\u1782\u17bb\u1799\u1794\u17b6\u17a2\u17b6\u1785\u200b\u1794\u1798\u17d2\u179b\u17c2\u1784\u200b\u1794\u17b6\u1793" },
            { "cup", "\u1794\u17c9\u17c1\u179f\u17bc\u1782\u17bb\u1799\u1794\u17b6" },
            { "cve", "\u17a2\u17ca\u17b8\u179f\u17d2\u1780\u17bc\u178c\u17bc\u200b\u1780\u17b6\u1794\u17cb\u179c\u17c2\u179a" },
            { "czk", "\u1780\u17bc\u179a\u17bb\u178e\u17b6\u200b\u179f\u17b6\u1792\u17b6\u179a\u178e\u17c8\u200b\u1786\u17c1\u1780" },
            { "djf", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb\u200b\u1787\u17b8\u1794\u17ca\u17bc\u1791\u17b8" },
            { "dkk", "\u1780\u17d2\u179a\u17bc\u178e\u17c1\u200b\u178a\u17b6\u178e\u17b6\u1798\u17c9\u17b6\u1780\u17cb" },
            { "dop", "\u1794\u17c9\u17c1\u179f\u17bc\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780" },
            { "dzd", "\u178c\u17b8\u178e\u17b6\u200b\u17a2\u17b6\u179b\u17cb\u179f\u17ca\u17c1\u179a\u17b8" },
            { "egp", "\u1795\u17c4\u1793\u17a2\u17c1\u17a0\u17d2\u179f\u17ca\u17b8\u1794" },
            { "ern", "\u178e\u17b6\u1780\u17cb\u17a0\u17d2\u179c\u17b6\u17a2\u17c1\u179a\u17b8\u1791\u17d2\u179a\u17b6" },
            { "etb", "\u1794\u17ca\u17d0\u179a\u200b\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8" },
            { "eur", "\u17a2\u17ba\u179a\u17c9\u17bc" },
            { "fjd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u17a0\u17d2\u179c\u17b8\u1787\u17b8" },
            { "fkp", "\u1795\u17c4\u1793\u200b\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u1780\u17cb\u17a1\u17c2\u1793" },
            { "gbp", "\u1795\u17c4\u1793\u1785\u1780\u17d2\u179a\u1797\u1796\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "gel", "\u17a1\u17b6\u179a\u17b8\u200b\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "ghs", "\u179f\u17ca\u17b8\u178c\u17b8\u200b\u17a0\u17d2\u1782\u17b6\u178e\u17b6" },
            { "gip", "\u1795\u17c4\u1793\u200b\u17a0\u17d2\u179f\u17ca\u17b8\u1794\u17d2\u179a\u17b6\u179b\u17cb\u178f\u17b6" },
            { "gmd", "\u178a\u17b6\u17a1\u17b6\u179f\u17ca\u17b8\u200b\u17a0\u17d2\u1782\u17b6\u17c6\u1794\u17ca\u17b8" },
            { "gnf", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb\u200b\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "gtq", "\u17a0\u17d2\u1782\u17b8\u179f\u17d2\u179f\u17b6\u179b\u200b\u1780\u17d2\u179c\u17b6\u178f\u17c1\u1798\u17c9\u17b6\u17a1\u17b6" },
            { "gyd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u1793" },
            { "hkd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u17a0\u17bb\u1784\u1780\u17bb\u1784" },
            { "hnl", "\u179b\u17b7\u1798\u1796\u17b8\u179a\u17c9\u17b6\u200b\u17a0\u17bb\u1784\u178c\u17bc\u179a\u17c9\u17b6\u179f" },
            { "hrk", "\u1782\u17bc\u178e\u17b6\u200b\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u178f" },
            { "htg", "\u1782\u17c4\u178c\u17b8\u200b\u17a0\u17c3\u1791\u17b8" },
            { "huf", "\u17a0\u17d2\u179c\u17bc\u179a\u17b8\u1793\u200b\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8" },
            { "idr", "\u179a\u17bc\u1796\u17b8\u17a5\u178e\u17d2\u178c\u17bc\u178e\u17c1\u179f\u17ca\u17b8" },
            { "ils", "\u179f\u17ca\u17b8\u1782\u17c2\u179b\u1790\u17d2\u1798\u17b8\u17a2\u17ca\u17b8\u179f\u17d2\u179a\u17b6\u17a2\u17c2\u179b" },
            { "inr", "\u179a\u17bc\u1796\u17b8\u17a5\u178e\u17d2\u178c\u17b6" },
            { "iqd", "\u178c\u17b8\u178e\u17b6\u200b\u17a2\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17cb" },
            { "irr", "\u179a\u17c0\u179b\u200b\u17a2\u17ca\u17b8\u179a\u17c9\u1784\u17cb" },
            { "isk", "\u1780\u17d2\u179a\u17bc\u178e\u17b6\u200b\u17a2\u17ca\u17b8\u179f\u17d2\u179b\u1784\u17cb" },
            { "jmd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6\u17a2\u17ca\u17b8\u1780" },
            { "jod", "\u178c\u17b8\u178e\u17b6\u200b\u17a0\u17d2\u179f\u17ca\u1780\u178a\u17b6\u1793\u17b8" },
            { "jpy", "\u1799\u17c1\u1793\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "kes", "\u179f\u17ca\u17b8\u179b\u17b7\u1789\u200b\u1780\u17c1\u1793\u1799\u17c9\u17b6" },
            { "kgs", "\u179f\u17bb\u1798\u200b\u1780\u17c0\u17a0\u17d2\u179f\u17ca\u17b8\u179f\u17ca\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "khr", "\u179a\u17c0\u179b\u200b\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6" },
            { "kmf", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb\u200b\u1780\u17bc\u1798\u17d0\u179a" },
            { "kpw", "\u179c\u17c9\u17bb\u1793\u1780\u17bc\u179a\u17c9\u17c1\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "krw", "\u179c\u17c9\u17bb\u1793\u1780\u17bc\u179a\u17c9\u17c1\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "kwd", "\u178c\u17b8\u178e\u17b6\u200b\u1782\u17bb\u1799\u179c\u17c9\u17c2\u178f" },
            { "kyd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1780\u17c4\u17c7\u200b\u1780\u17c3\u1798\u17c9\u17c2\u1793" },
            { "kzt", "\u178f\u1784\u17cb\u17a0\u17d2\u1782\u17b8\u200b\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u1790\u17b6\u1793" },
            { "lak", "\u1782\u17b8\u1794\u200b\u17a1\u17b6\u179c" },
            { "lbp", "\u1795\u17c4\u1793\u200b\u179b\u17b8\u1794\u1784\u17cb" },
            { "lkr", "\u179a\u17bc\u1796\u17b8\u179f\u17d2\u179a\u17b8\u179b\u1784\u17d2\u1780\u17b6" },
            { "lrd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u179b\u17b8\u1794\u17ca\u17b8" },
            { "lsl", "\u17a1\u17bc\u1791\u17b8\u17a1\u17c1\u179f\u17bc\u178f\u17bc" },
            { "ltl", "\u179b\u17b8\u178f\u17b6\u200b\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8" },
            { "lvl", "\u17a1\u17b6\u178f\u17cb\u200b\u17a1\u17c1\u178f\u17bc\u1793\u17b8" },
            { "lyd", "\u178c\u17b8\u178e\u17b6\u200b\u179b\u17b8\u1794\u17ca\u17b8" },
            { "mad", "\u178c\u17c0\u179a\u17a0\u17b6\u17c6\u200b\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780" },
            { "mdl", "\u179b\u17bc\u200b\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8" },
            { "mga", "\u17a2\u17b6\u179a\u17c0\u179a\u17b8\u200b\u1798\u17c9\u17b6\u17a1\u17b6\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8" },
            { "mkd", "\u178c\u17b8\u178e\u17b6\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17bc\u1793\u17b8" },
            { "mmk", "\u1782\u17b8\u1799\u17c9\u17b6\u178f\u200b\u1797\u17bc\u1798\u17b6" },
            { "mnt", "\u1791\u17bc\u179a\u17b8\u1780\u200b\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8" },
            { "mop", "\u1794\u17c9\u17b6\u178f\u17b6\u1780\u17b6\u200b\u1798\u17c9\u17b6\u1780\u17b6\u179c" },
            { "mro", "\u17a2\u17ca\u17bc\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u200b\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8 (1973\u20132017)" },
            { "mru", "\u17a2\u17ca\u17bc\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u200b\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8" },
            { "mur", "\u179a\u17bc\u1796\u17b8\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8" },
            { "mvr", "\u179a\u17c9\u17bc\u17a0\u17d2\u179c\u17b8\u1799\u17c9\u17b6\u200b\u1798\u17c9\u17b6\u179b\u17cb\u178c\u17b8\u179c" },
            { "mwk", "\u1780\u17d2\u179c\u17b6\u1785\u17b6\u200b\u1798\u17c9\u17b6\u17a1\u17b6\u179c\u17b8" },
            { "mxn", "\u1794\u17c9\u17c1\u179f\u17bc\u1798\u17c9\u17b7\u1780\u179f\u17b7\u1780" },
            { "myr", "\u179a\u17b8\u1784\u17a0\u17d2\u1782\u17b8\u178f\u200b\u1798\u17c9\u17b6\u17a1\u17c1\u179f\u17ca\u17b8" },
            { "mzn", "\u1798\u17b8\u1791\u17b8\u1781\u179b\u200b\u1798\u17c9\u17bc\u179f\u17c6\u1794\u17ca\u17b7\u1780" },
            { "nad", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u178e\u17b6\u1798\u17b8\u1794\u17ca\u17b8" },
            { "ngn", "\u178e\u17c3\u179a\u17c9\u17b6\u200b\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "nio", "\u1781\u178c\u17bc\u1794\u17b6\u200b\u1793\u17b8\u1780\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1780\u17b6" },
            { "nok", "\u1780\u17d2\u179a\u17bc\u178e\u17c1\u200b\u1793\u17d0\u179a\u179c\u17c9\u17c1" },
            { "npr", "\u179a\u17bc\u1796\u17b8\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb" },
            { "nzd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1793\u17bc\u179c\u17c2\u179b\u179f\u17c1\u17a1\u1784\u17cb" },
            { "omr", "\u179a\u17c0\u179b\u200b\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8" },
            { "pab", "\u1794\u17b6\u179b\u17cb\u1794\u17c9\u17c5\u200b\u1794\u17c9\u17b6\u178e\u17b6\u1798\u17c9\u17b6" },
            { "pen", "\u1789\u17bc\u179c\u17c9\u17bc\u179f\u17bc\u179b\u200b\u1794\u17c9\u17c1\u179a\u17bc" },
            { "pgk", "\u1782\u17b8\u178e\u17b6\u1794\u17c9\u17b6\u1796\u17bd\u1789\u17bc\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "php", "\u1794\u17c9\u17c1\u179f\u17bc\u17a0\u17d2\u179c\u17b8\u179b\u17b8\u1796\u17b8\u1793" },
            { "pkr", "\u179a\u17bc\u1796\u17b8\u1794\u17c9\u17b6\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "pln", "\u17a0\u17d2\u179f\u17bc\u1791\u17b8\u200b\u1794\u17c9\u17bc\u17a1\u17bc\u1789" },
            { "pyg", "\u17a0\u17d2\u1782\u17bc\u179a\u17b8\u1793\u17b8\u200b\u1794\u17c9\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799" },
            { "qar", "\u179a\u17b8\u1799\u17c9\u17b6\u179b\u1780\u17b6\u178f\u17b6" },
            { "ron", "\u179b\u17bc\u200b\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8" },
            { "rsd", "\u178c\u17b8\u178e\u17b6\u179f\u17ca\u17c2\u1794" },
            { "rub", "\u179a\u17c9\u17bc\u1794\u179b\u200b\u179a\u17bb\u179f\u17d2\u179f\u17ca\u17b8" },
            { "rwf", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb\u200b\u179a\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6" },
            { "sar", "\u179a\u17b8\u1799\u17c9\u17b6\u179b\u200b\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u179f\u17b6\u17a2\u17bc\u178c\u17b8\u178f" },
            { "sbd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1780\u17c4\u17c7\u200b\u179f\u17bc\u17a1\u17bc\u1798\u17c9\u17bb\u1784" },
            { "scr", "\u179a\u17bc\u1796\u17b8\u200b\u179f\u17b8\u179f\u17d2\u17a0\u17c2\u179b" },
            { "sdg", "\u1795\u17c4\u1793\u200b\u179f\u17ca\u17bc\u178a\u1784\u17cb" },
            { "sek", "\u1780\u17d2\u179a\u17bc\u178e\u17b6\u200b\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178f" },
            { "sgd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u200b\u179f\u17b7\u1784\u17d2\u17a0\u1794\u17bc\u179a\u17b8" },
            { "shp", "\u1795\u17c4\u1793\u200b\u179f\u17b6\u17c6\u1784\u17a0\u17c1\u17a1\u17c1\u178e\u17b6" },
            { "sle", "\u179b\u17b8\u17a2\u17ca\u17bb\u1793\u200b\u179f\u17c0\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793" },
            { "sll", "\u179b\u17b8\u17a2\u17ca\u17bb\u1793\u200b\u179f\u17c0\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793 (1964\u20142022)" },
            { "sos", "\u179f\u17ca\u17b8\u179b\u17b7\u1789\u200b\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8" },
            { "srd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u179f\u17bc\u179a\u17b8\u178e\u17b6\u1798" },
            { "ssp", "\u1795\u17c4\u1793\u200b\u179f\u17ca\u17bc\u178a\u1784\u17cb\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "std", "\u178c\u17bc\u1794\u17d2\u179a\u17b6\u200b\u179f\u17c5\u178f\u17bc\u1798\u17c9\u17c1 \u1793\u17b7\u1784\u1794\u17d2\u179a\u17b6\u17c6\u1784\u179f\u17ca\u17b8\u1794 (1977\u20132017)" },
            { "stn", "\u178c\u17bc\u1794\u17d2\u179a\u17b6\u200b\u179f\u17c5\u178f\u17bc\u1798\u17c9\u17c1 \u1793\u17b7\u1784\u1794\u17d2\u179a\u17b6\u17c6\u1784\u179f\u17ca\u17b8\u1794" },
            { "syp", "\u1795\u17c4\u1793\u200b\u179f\u17ca\u17b8\u179a\u17b8" },
            { "szl", "\u179b\u17b8\u17a1\u17b6\u1784\u17a0\u17d2\u1782\u17b8\u1793\u17b8\u200b\u179f\u17d2\u179c\u17b6\u179f\u17ca\u17b8\u17a1\u1784\u17cb" },
            { "thb", "\u1794\u17b6\u178f\u200b\u1790\u17c3" },
            { "tjs", "\u179f\u17bc\u1798\u17bb\u1793\u17b8\u200b\u178f\u17b6\u17a0\u17d2\u179f\u17ca\u17b8\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "tmt", "\u1798\u17c9\u17b6\u178e\u17b6\u178f\u200b\u178f\u17bd\u1780\u1798\u17c9\u17c1\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "tnd", "\u178c\u17b8\u178e\u17b6\u1791\u17bb\u1799\u1793\u17c1\u179f\u17ca\u17b8" },
            { "top", "\u1794\u17c9\u17b6\u17a2\u1784\u17cb\u1780\u17b6\u200b\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6" },
            { "try", "\u179b\u17b8\u179a\u17c9\u17b6\u1791\u17bd\u179a\u1782\u17b8" },
            { "ttd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1791\u17d2\u179a\u17b8\u1793\u17b8\u178a\u17b6\u178a \u1793\u17b7\u1784\u178f\u17bc\u1794\u17b6\u17a0\u17d2\u1782\u17c4" },
            { "twd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u178f\u17c3\u179c\u17c9\u17b6\u1793\u17cb" },
            { "tzs", "\u179f\u17ca\u17b8\u179b\u17b7\u1789\u200b\u178f\u1784\u17cb\u179f\u17b6\u1793\u17b8" },
            { "uah", "\u17a0\u17ca\u17bc\u1793\u17b8\u1799\u17c9\u17b6\u200b\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793" },
            { "ugx", "\u179f\u17ca\u17b8\u179b\u17b7\u1789\u200b\u17a2\u17ca\u17bc\u17a0\u17d2\u1782\u1784\u17cb\u178a\u17b6" },
            { "usd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "uyu", "\u1794\u17c9\u17c1\u179f\u17bc\u17a2\u17ca\u17bb\u1799\u179a\u17bc\u17a0\u17d2\u1782\u17b6\u1799" },
            { "uzs", "\u179f\u17bb\u1798\u17a2\u17ca\u17bc\u1794\u17c1\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "vef", "\u1794\u17ca\u17bc\u179b\u17b8\u179c\u17c9\u17b6\u200b\u179c\u17c9\u17c1\u178e\u17c1\u179f\u17ca\u17bb\u1799\u17a2\u17c1\u17a1\u17b6 (2008\u20132018)" },
            { "ves", "\u1794\u17ca\u17bc\u179b\u17b8\u179c\u17c9\u17b6\u200b\u179c\u17c9\u17c1\u178e\u17c1\u179f\u17ca\u17bb\u1799\u17a2\u17c1\u17a1\u17b6" },
            { "vnd", "\u178a\u17bb\u1784\u200b\u179c\u17c0\u178f\u178e\u17b6\u1798" },
            { "vuv", "\u179c\u17c9\u17b6\u1791\u17bc\u179c\u17c9\u17b6\u1793\u17bc\u17a2\u17b6\u1791\u17bc" },
            { "wst", "\u178f\u17b6\u17a1\u17b6\u200b\u179f\u17b6\u1798\u17d0\u179a" },
            { "xaf", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb CFA \u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "xcd", "\u178a\u17bb\u179b\u17d2\u179b\u17b6\u179a\u200b\u1780\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u1793\u200b\u1781\u17b6\u1784\u200b\u1780\u17be\u178f" },
            { "xof", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb CFA \u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "xpf", "\u17a0\u17d2\u179c\u17d2\u179a\u1784\u17cb CFP" },
            { "xxx", "\u179a\u17bc\u1794\u17b7\u1799\u1794\u17d0\u178e\u17d2\u178e\u200b\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "yer", "\u179a\u17c0\u179b\u200b\u1799\u17c1\u1798\u17c9\u17c2\u1793" },
            { "zar", "\u179a\u17c9\u1784\u17cb\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "zmk", "\u1780\u17d2\u179c\u17b6\u1785\u17b6 \u179f\u17c6\u1794\u17ca\u17b8 (1968\u20132012)" },
            { "zmw", "\u1780\u17d2\u179c\u17b6\u1785\u17b6\u17a0\u17d2\u179f\u17c6\u1794\u17ca\u17b8" },
        };
        return data;
    }
}
