//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-uniform-type-identifiers")]
#[cfg(target_vendor = "apple")]
use objc2_uniform_type_identifiers::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceiconcreationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWorkspaceIconCreationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSWorkspaceIconCreationOptions: NSUInteger {
        #[doc(alias = "NSExcludeQuickDrawElementsIconCreationOption")]
        const ExcludeQuickDrawElementsIconCreationOption = 1<<1;
        #[doc(alias = "NSExclude10_4ElementsIconCreationOption")]
        const Exclude10_4ElementsIconCreationOption = 1<<2;
    }
}

unsafe impl Encode for NSWorkspaceIconCreationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWorkspaceIconCreationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspace?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSWorkspace;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSWorkspace {}
);

impl NSWorkspace {
    extern_methods!(
        #[unsafe(method(sharedWorkspace))]
        #[unsafe(method_family = none)]
        pub unsafe fn sharedWorkspace() -> Retained<NSWorkspace>;

        #[unsafe(method(notificationCenter))]
        #[unsafe(method_family = none)]
        pub unsafe fn notificationCenter(&self) -> Retained<NSNotificationCenter>;

        #[unsafe(method(openURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openURL(&self, url: &NSURL) -> bool;

        #[cfg(all(feature = "NSRunningApplication", feature = "block2"))]
        #[unsafe(method(openURL:configuration:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openURL_configuration_completionHandler(
            &self,
            url: &NSURL,
            configuration: &NSWorkspaceOpenConfiguration,
            completion_handler: Option<
                &block2::DynBlock<dyn Fn(*mut NSRunningApplication, *mut NSError)>,
            >,
        );

        #[cfg(all(feature = "NSRunningApplication", feature = "block2"))]
        #[unsafe(method(openURLs:withApplicationAtURL:configuration:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openURLs_withApplicationAtURL_configuration_completionHandler(
            &self,
            urls: &NSArray<NSURL>,
            application_url: &NSURL,
            configuration: &NSWorkspaceOpenConfiguration,
            completion_handler: Option<
                &block2::DynBlock<dyn Fn(*mut NSRunningApplication, *mut NSError)>,
            >,
        );

        #[cfg(all(feature = "NSRunningApplication", feature = "block2"))]
        #[unsafe(method(openApplicationAtURL:configuration:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openApplicationAtURL_configuration_completionHandler(
            &self,
            application_url: &NSURL,
            configuration: &NSWorkspaceOpenConfiguration,
            completion_handler: Option<
                &block2::DynBlock<dyn Fn(*mut NSRunningApplication, *mut NSError)>,
            >,
        );

        #[unsafe(method(selectFile:inFileViewerRootedAtPath:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectFile_inFileViewerRootedAtPath(
            &self,
            full_path: Option<&NSString>,
            root_full_path: &NSString,
        ) -> bool;

        #[unsafe(method(activateFileViewerSelectingURLs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn activateFileViewerSelectingURLs(&self, file_ur_ls: &NSArray<NSURL>);

        #[unsafe(method(showSearchResultsForQueryString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showSearchResultsForQueryString(&self, query_string: &NSString) -> bool;

        #[unsafe(method(noteFileSystemChanged:))]
        #[unsafe(method_family = none)]
        pub unsafe fn noteFileSystemChanged_(&self, path: &NSString);

        #[unsafe(method(isFilePackageAtPath:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFilePackageAtPath(&self, full_path: &NSString) -> bool;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(iconForFile:))]
        #[unsafe(method_family = none)]
        pub unsafe fn iconForFile(&self, full_path: &NSString) -> Retained<NSImage>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(iconForFiles:))]
        #[unsafe(method_family = none)]
        pub unsafe fn iconForFiles(
            &self,
            full_paths: &NSArray<NSString>,
        ) -> Option<Retained<NSImage>>;

        #[cfg(all(feature = "NSImage", feature = "objc2-uniform-type-identifiers"))]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(iconForContentType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn iconForContentType(&self, content_type: &UTType) -> Retained<NSImage>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(setIcon:forFile:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIcon_forFile_options(
            &self,
            image: Option<&NSImage>,
            full_path: &NSString,
            options: NSWorkspaceIconCreationOptions,
        ) -> bool;

        #[unsafe(method(fileLabels))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileLabels(&self) -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSColor")]
        #[unsafe(method(fileLabelColors))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileLabelColors(&self) -> Retained<NSArray<NSColor>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(recycleURLs:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn recycleURLs_completionHandler(
            &self,
            ur_ls: &NSArray<NSURL>,
            handler: Option<
                &block2::DynBlock<dyn Fn(NonNull<NSDictionary<NSURL, NSURL>>, *mut NSError)>,
            >,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(duplicateURLs:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn duplicateURLs_completionHandler(
            &self,
            ur_ls: &NSArray<NSURL>,
            handler: Option<
                &block2::DynBlock<dyn Fn(NonNull<NSDictionary<NSURL, NSURL>>, *mut NSError)>,
            >,
        );

        #[unsafe(method(getFileSystemInfoForPath:isRemovable:isWritable:isUnmountable:description:type:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getFileSystemInfoForPath_isRemovable_isWritable_isUnmountable_description_type(
            &self,
            full_path: &NSString,
            removable_flag: *mut Bool,
            writable_flag: *mut Bool,
            unmountable_flag: *mut Bool,
            description: Option<&mut Option<Retained<NSString>>>,
            file_system_type: Option<&mut Option<Retained<NSString>>>,
        ) -> bool;

        #[unsafe(method(unmountAndEjectDeviceAtPath:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unmountAndEjectDeviceAtPath(&self, path: &NSString) -> bool;

        #[unsafe(method(unmountAndEjectDeviceAtURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unmountAndEjectDeviceAtURL_error(
            &self,
            url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(extendPowerOffBy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn extendPowerOffBy(&self, requested: NSInteger) -> NSInteger;

        #[unsafe(method(hideOtherApplications))]
        #[unsafe(method_family = none)]
        pub unsafe fn hideOtherApplications(&self);

        #[unsafe(method(URLForApplicationWithBundleIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLForApplicationWithBundleIdentifier(
            &self,
            bundle_identifier: &NSString,
        ) -> Option<Retained<NSURL>>;

        #[unsafe(method(URLsForApplicationsWithBundleIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLsForApplicationsWithBundleIdentifier(
            &self,
            bundle_identifier: &NSString,
        ) -> Retained<NSArray<NSURL>>;

        #[unsafe(method(URLForApplicationToOpenURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLForApplicationToOpenURL(&self, url: &NSURL) -> Option<Retained<NSURL>>;

        #[unsafe(method(URLsForApplicationsToOpenURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLsForApplicationsToOpenURL(&self, url: &NSURL) -> Retained<NSArray<NSURL>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(setDefaultApplicationAtURL:toOpenContentTypeOfFileAtURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultApplicationAtURL_toOpenContentTypeOfFileAtURL_completionHandler(
            &self,
            application_url: &NSURL,
            url: &NSURL,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(setDefaultApplicationAtURL:toOpenURLsWithScheme:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultApplicationAtURL_toOpenURLsWithScheme_completionHandler(
            &self,
            application_url: &NSURL,
            url_scheme: &NSString,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(setDefaultApplicationAtURL:toOpenFileAtURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultApplicationAtURL_toOpenFileAtURL_completionHandler(
            &self,
            application_url: &NSURL,
            url: &NSURL,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(URLForApplicationToOpenContentType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLForApplicationToOpenContentType(
            &self,
            content_type: &UTType,
        ) -> Option<Retained<NSURL>>;

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(URLsForApplicationsToOpenContentType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn URLsForApplicationsToOpenContentType(
            &self,
            content_type: &UTType,
        ) -> Retained<NSArray<NSURL>>;

        #[cfg(all(feature = "block2", feature = "objc2-uniform-type-identifiers"))]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(setDefaultApplicationAtURL:toOpenContentType:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultApplicationAtURL_toOpenContentType_completionHandler(
            &self,
            application_url: &NSURL,
            content_type: &UTType,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );

        #[cfg(feature = "NSRunningApplication")]
        #[unsafe(method(frontmostApplication))]
        #[unsafe(method_family = none)]
        pub unsafe fn frontmostApplication(&self) -> Option<Retained<NSRunningApplication>>;

        #[cfg(feature = "NSRunningApplication")]
        #[unsafe(method(menuBarOwningApplication))]
        #[unsafe(method_family = none)]
        pub unsafe fn menuBarOwningApplication(&self) -> Option<Retained<NSRunningApplication>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSWorkspace {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceopenconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSWorkspaceOpenConfiguration;
);

extern_conformance!(
    unsafe impl NSCopying for NSWorkspaceOpenConfiguration {}
);

unsafe impl CopyingHelper for NSWorkspaceOpenConfiguration {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSWorkspaceOpenConfiguration {}
);

impl NSWorkspaceOpenConfiguration {
    extern_methods!(
        #[unsafe(method(configuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn configuration() -> Retained<Self>;

        #[unsafe(method(promptsUserIfNeeded))]
        #[unsafe(method_family = none)]
        pub unsafe fn promptsUserIfNeeded(&self) -> bool;

        /// Setter for [`promptsUserIfNeeded`][Self::promptsUserIfNeeded].
        #[unsafe(method(setPromptsUserIfNeeded:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPromptsUserIfNeeded(&self, prompts_user_if_needed: bool);

        #[unsafe(method(addsToRecentItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn addsToRecentItems(&self) -> bool;

        /// Setter for [`addsToRecentItems`][Self::addsToRecentItems].
        #[unsafe(method(setAddsToRecentItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAddsToRecentItems(&self, adds_to_recent_items: bool);

        #[unsafe(method(activates))]
        #[unsafe(method_family = none)]
        pub unsafe fn activates(&self) -> bool;

        /// Setter for [`activates`][Self::activates].
        #[unsafe(method(setActivates:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setActivates(&self, activates: bool);

        #[unsafe(method(hides))]
        #[unsafe(method_family = none)]
        pub unsafe fn hides(&self) -> bool;

        /// Setter for [`hides`][Self::hides].
        #[unsafe(method(setHides:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHides(&self, hides: bool);

        #[unsafe(method(hidesOthers))]
        #[unsafe(method_family = none)]
        pub unsafe fn hidesOthers(&self) -> bool;

        /// Setter for [`hidesOthers`][Self::hidesOthers].
        #[unsafe(method(setHidesOthers:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHidesOthers(&self, hides_others: bool);

        #[unsafe(method(isForPrinting))]
        #[unsafe(method_family = none)]
        pub unsafe fn isForPrinting(&self) -> bool;

        /// Setter for [`isForPrinting`][Self::isForPrinting].
        #[unsafe(method(setForPrinting:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setForPrinting(&self, for_printing: bool);

        #[unsafe(method(createsNewApplicationInstance))]
        #[unsafe(method_family = none)]
        pub unsafe fn createsNewApplicationInstance(&self) -> bool;

        /// Setter for [`createsNewApplicationInstance`][Self::createsNewApplicationInstance].
        #[unsafe(method(setCreatesNewApplicationInstance:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCreatesNewApplicationInstance(
            &self,
            creates_new_application_instance: bool,
        );

        #[unsafe(method(allowsRunningApplicationSubstitution))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsRunningApplicationSubstitution(&self) -> bool;

        /// Setter for [`allowsRunningApplicationSubstitution`][Self::allowsRunningApplicationSubstitution].
        #[unsafe(method(setAllowsRunningApplicationSubstitution:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsRunningApplicationSubstitution(
            &self,
            allows_running_application_substitution: bool,
        );

        #[unsafe(method(arguments))]
        #[unsafe(method_family = none)]
        pub unsafe fn arguments(&self) -> Retained<NSArray<NSString>>;

        /// Setter for [`arguments`][Self::arguments].
        #[unsafe(method(setArguments:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setArguments(&self, arguments: &NSArray<NSString>);

        #[unsafe(method(environment))]
        #[unsafe(method_family = none)]
        pub unsafe fn environment(&self) -> Retained<NSDictionary<NSString, NSString>>;

        /// Setter for [`environment`][Self::environment].
        #[unsafe(method(setEnvironment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEnvironment(&self, environment: &NSDictionary<NSString, NSString>);

        #[unsafe(method(appleEvent))]
        #[unsafe(method_family = none)]
        pub unsafe fn appleEvent(&self) -> Option<Retained<NSAppleEventDescriptor>>;

        /// Setter for [`appleEvent`][Self::appleEvent].
        #[unsafe(method(setAppleEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAppleEvent(&self, apple_event: Option<&NSAppleEventDescriptor>);

        #[unsafe(method(requiresUniversalLinks))]
        #[unsafe(method_family = none)]
        pub unsafe fn requiresUniversalLinks(&self) -> bool;

        /// Setter for [`requiresUniversalLinks`][Self::requiresUniversalLinks].
        #[unsafe(method(setRequiresUniversalLinks:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRequiresUniversalLinks(&self, requires_universal_links: bool);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSWorkspaceOpenConfiguration {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedesktopimageoptionkey?language=objc)
// NS_TYPED_ENUM
pub type NSWorkspaceDesktopImageOptionKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedesktopimagescalingkey?language=objc)
    pub static NSWorkspaceDesktopImageScalingKey: &'static NSWorkspaceDesktopImageOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedesktopimageallowclippingkey?language=objc)
    pub static NSWorkspaceDesktopImageAllowClippingKey: &'static NSWorkspaceDesktopImageOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedesktopimagefillcolorkey?language=objc)
    pub static NSWorkspaceDesktopImageFillColorKey: &'static NSWorkspaceDesktopImageOptionKey;
}

/// NSDesktopImages.
impl NSWorkspace {
    extern_methods!(
        #[cfg(feature = "NSScreen")]
        #[unsafe(method(setDesktopImageURL:forScreen:options:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDesktopImageURL_forScreen_options_error(
            &self,
            url: &NSURL,
            screen: &NSScreen,
            options: &NSDictionary<NSWorkspaceDesktopImageOptionKey, AnyObject>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "NSScreen")]
        #[unsafe(method(desktopImageURLForScreen:))]
        #[unsafe(method_family = none)]
        pub unsafe fn desktopImageURLForScreen(&self, screen: &NSScreen)
            -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSScreen")]
        #[unsafe(method(desktopImageOptionsForScreen:))]
        #[unsafe(method_family = none)]
        pub unsafe fn desktopImageOptionsForScreen(
            &self,
            screen: &NSScreen,
        ) -> Option<Retained<NSDictionary<NSWorkspaceDesktopImageOptionKey, AnyObject>>>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceauthorizationtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWorkspaceAuthorizationType(pub NSInteger);
impl NSWorkspaceAuthorizationType {
    #[doc(alias = "NSWorkspaceAuthorizationTypeCreateSymbolicLink")]
    pub const CreateSymbolicLink: Self = Self(0);
    #[doc(alias = "NSWorkspaceAuthorizationTypeSetAttributes")]
    pub const SetAttributes: Self = Self(1);
    #[doc(alias = "NSWorkspaceAuthorizationTypeReplaceFile")]
    pub const ReplaceFile: Self = Self(2);
}

unsafe impl Encode for NSWorkspaceAuthorizationType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSWorkspaceAuthorizationType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceauthorization?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSWorkspaceAuthorization;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSWorkspaceAuthorization {}
);

impl NSWorkspaceAuthorization {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl NSWorkspaceAuthorization {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// NSWorkspaceAuthorization.
impl NSWorkspace {
    extern_methods!(
        #[cfg(feature = "block2")]
        #[unsafe(method(requestAuthorizationOfType:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn requestAuthorizationOfType_completionHandler(
            &self,
            r#type: NSWorkspaceAuthorizationType,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSWorkspaceAuthorization, *mut NSError),
            >,
        );
    );
}

mod private_NSFileManagerNSWorkspaceAuthorization {
    pub trait Sealed {}
}

/// Category "NSWorkspaceAuthorization" on [`NSFileManager`].
#[doc(alias = "NSWorkspaceAuthorization")]
pub unsafe trait NSFileManagerNSWorkspaceAuthorization:
    ClassType + Sized + private_NSFileManagerNSWorkspaceAuthorization::Sealed
{
    extern_methods!(
        #[unsafe(method(fileManagerWithAuthorization:))]
        #[unsafe(method_family = none)]
        unsafe fn fileManagerWithAuthorization(
            authorization: &NSWorkspaceAuthorization,
        ) -> Retained<Self>;
    );
}

impl private_NSFileManagerNSWorkspaceAuthorization::Sealed for NSFileManager {}
unsafe impl NSFileManagerNSWorkspaceAuthorization for NSFileManager {}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceapplicationkey?language=objc)
    pub static NSWorkspaceApplicationKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacewilllaunchapplicationnotification?language=objc)
    pub static NSWorkspaceWillLaunchApplicationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidlaunchapplicationnotification?language=objc)
    pub static NSWorkspaceDidLaunchApplicationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidterminateapplicationnotification?language=objc)
    pub static NSWorkspaceDidTerminateApplicationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidhideapplicationnotification?language=objc)
    pub static NSWorkspaceDidHideApplicationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidunhideapplicationnotification?language=objc)
    pub static NSWorkspaceDidUnhideApplicationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidactivateapplicationnotification?language=objc)
    pub static NSWorkspaceDidActivateApplicationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacediddeactivateapplicationnotification?language=objc)
    pub static NSWorkspaceDidDeactivateApplicationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacevolumelocalizednamekey?language=objc)
    pub static NSWorkspaceVolumeLocalizedNameKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacevolumeurlkey?language=objc)
    pub static NSWorkspaceVolumeURLKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacevolumeoldlocalizednamekey?language=objc)
    pub static NSWorkspaceVolumeOldLocalizedNameKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacevolumeoldurlkey?language=objc)
    pub static NSWorkspaceVolumeOldURLKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidmountnotification?language=objc)
    pub static NSWorkspaceDidMountNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidunmountnotification?language=objc)
    pub static NSWorkspaceDidUnmountNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacewillunmountnotification?language=objc)
    pub static NSWorkspaceWillUnmountNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidrenamevolumenotification?language=objc)
    pub static NSWorkspaceDidRenameVolumeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacewillpoweroffnotification?language=objc)
    pub static NSWorkspaceWillPowerOffNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacewillsleepnotification?language=objc)
    pub static NSWorkspaceWillSleepNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidwakenotification?language=objc)
    pub static NSWorkspaceDidWakeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacescreensdidsleepnotification?language=objc)
    pub static NSWorkspaceScreensDidSleepNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacescreensdidwakenotification?language=objc)
    pub static NSWorkspaceScreensDidWakeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacesessiondidbecomeactivenotification?language=objc)
    pub static NSWorkspaceSessionDidBecomeActiveNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacesessiondidresignactivenotification?language=objc)
    pub static NSWorkspaceSessionDidResignActiveNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidchangefilelabelsnotification?language=objc)
    pub static NSWorkspaceDidChangeFileLabelsNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceactivespacedidchangenotification?language=objc)
    pub static NSWorkspaceActiveSpaceDidChangeNotification: &'static NSNotificationName;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacefileoperationname?language=objc)
// NS_TYPED_ENUM
pub type NSWorkspaceFileOperationName = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacelaunchoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSWorkspaceLaunchOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSWorkspaceLaunchOptions: NSUInteger {
        #[doc(alias = "NSWorkspaceLaunchAndPrint")]
#[deprecated = "Use -[NSWorkspaceOpenConfiguration setForPrinting:YES] instead."]
        const AndPrint = 0x00000002;
        #[doc(alias = "NSWorkspaceLaunchWithErrorPresentation")]
#[deprecated = "Use -[NSWorkspaceOpenConfiguration setPromptsUserIfNeeded:YES] instead."]
        const WithErrorPresentation = 0x00000040;
        #[doc(alias = "NSWorkspaceLaunchInhibitingBackgroundOnly")]
#[deprecated = "This option does nothing."]
        const InhibitingBackgroundOnly = 0x00000080;
        #[doc(alias = "NSWorkspaceLaunchWithoutAddingToRecents")]
#[deprecated = "Use -[NSWorkspaceOpenConfiguration setAddsToRecentItems:YES] instead."]
        const WithoutAddingToRecents = 0x00000100;
        #[doc(alias = "NSWorkspaceLaunchWithoutActivation")]
#[deprecated = "Use -[NSWorkspaceOpenConfiguration setActivates:NO] instead."]
        const WithoutActivation = 0x00000200;
        #[doc(alias = "NSWorkspaceLaunchAsync")]
#[deprecated = "When using NSWorkspaceOpenConfiguration, all launches are asynchronous."]
        const Async = 0x00010000;
        #[doc(alias = "NSWorkspaceLaunchNewInstance")]
#[deprecated = "Use -[NSWorkspaceOpenConfiguration setCreatesNewApplicationInstance:YES] instead."]
        const NewInstance = 0x00080000;
        #[doc(alias = "NSWorkspaceLaunchAndHide")]
#[deprecated = "Use -[NSWorkspaceOpenConfiguration setHides:YES] instead."]
        const AndHide = 0x00100000;
        #[doc(alias = "NSWorkspaceLaunchAndHideOthers")]
#[deprecated = "Use -[NSWorkspaceOpenConfiguration setHidesOthers:YES] instead."]
        const AndHideOthers = 0x00200000;
        #[doc(alias = "NSWorkspaceLaunchDefault")]
#[deprecated = "Use NSWorkspaceOpenConfiguration instead."]
        const Default = NSWorkspaceLaunchOptions::Async.0;
        #[doc(alias = "NSWorkspaceLaunchAllowingClassicStartup")]
#[deprecated = "The Classic environment is no longer supported."]
        const AllowingClassicStartup = 0x00020000;
        #[doc(alias = "NSWorkspaceLaunchPreferringClassic")]
#[deprecated = "The Classic environment is no longer supported."]
        const PreferringClassic = 0x00040000;
    }
}

unsafe impl Encode for NSWorkspaceLaunchOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSWorkspaceLaunchOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacelaunchconfigurationkey?language=objc)
// NS_TYPED_ENUM
pub type NSWorkspaceLaunchConfigurationKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacelaunchconfigurationappleevent?language=objc)
    pub static NSWorkspaceLaunchConfigurationAppleEvent: &'static NSWorkspaceLaunchConfigurationKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacelaunchconfigurationarguments?language=objc)
    pub static NSWorkspaceLaunchConfigurationArguments: &'static NSWorkspaceLaunchConfigurationKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacelaunchconfigurationenvironment?language=objc)
    pub static NSWorkspaceLaunchConfigurationEnvironment:
        &'static NSWorkspaceLaunchConfigurationKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacelaunchconfigurationarchitecture?language=objc)
    pub static NSWorkspaceLaunchConfigurationArchitecture:
        &'static NSWorkspaceLaunchConfigurationKey;
}

/// NSDeprecated.
impl NSWorkspace {
    extern_methods!(
        #[deprecated = "Use -[NSWorkspace openURL:] instead."]
        #[unsafe(method(openFile:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openFile(&self, full_path: &NSString) -> bool;

        #[deprecated = "Use -[NSWorkspace openURLs:withApplicationAtURL:configuration:completionHandler:] instead."]
        #[unsafe(method(openFile:withApplication:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openFile_withApplication(
            &self,
            full_path: &NSString,
            app_name: Option<&NSString>,
        ) -> bool;

        #[deprecated = "Use -[NSWorkspace openURLs:withApplicationAtURL:configuration:completionHandler:] instead."]
        #[unsafe(method(openFile:withApplication:andDeactivate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openFile_withApplication_andDeactivate(
            &self,
            full_path: &NSString,
            app_name: Option<&NSString>,
            flag: bool,
        ) -> bool;

        #[deprecated = "Use -[NSWorkspace openApplicationAtURL:configuration:completionHandler:] instead."]
        #[unsafe(method(launchApplication:))]
        #[unsafe(method_family = none)]
        pub unsafe fn launchApplication(&self, app_name: &NSString) -> bool;

        #[cfg(feature = "NSRunningApplication")]
        #[deprecated = "Use -[NSWorkspace openApplicationAtURL:configuration:completionHandler:] instead."]
        #[unsafe(method(launchApplicationAtURL:options:configuration:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn launchApplicationAtURL_options_configuration_error(
            &self,
            url: &NSURL,
            options: NSWorkspaceLaunchOptions,
            configuration: &NSDictionary<NSWorkspaceLaunchConfigurationKey, AnyObject>,
        ) -> Result<Retained<NSRunningApplication>, Retained<NSError>>;

        #[cfg(feature = "NSRunningApplication")]
        #[deprecated = "Use -[NSWorkspace openURL:configuration:completionHandler:] instead."]
        #[unsafe(method(openURL:options:configuration:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn openURL_options_configuration_error(
            &self,
            url: &NSURL,
            options: NSWorkspaceLaunchOptions,
            configuration: &NSDictionary<NSWorkspaceLaunchConfigurationKey, AnyObject>,
        ) -> Result<Retained<NSRunningApplication>, Retained<NSError>>;

        #[cfg(feature = "NSRunningApplication")]
        #[deprecated = "Use -[NSWorkspace openURLs:withApplicationAtURL:configuration:completionHandler:] instead."]
        #[unsafe(method(openURLs:withApplicationAtURL:options:configuration:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn openURLs_withApplicationAtURL_options_configuration_error(
            &self,
            urls: &NSArray<NSURL>,
            application_url: &NSURL,
            options: NSWorkspaceLaunchOptions,
            configuration: &NSDictionary<NSWorkspaceLaunchConfigurationKey, AnyObject>,
        ) -> Result<Retained<NSRunningApplication>, Retained<NSError>>;

        #[deprecated = "Use -[NSWorkspace openApplicationAtURL:configuration:completionHandler:] instead."]
        #[unsafe(method(launchApplication:showIcon:autolaunch:))]
        #[unsafe(method_family = none)]
        pub unsafe fn launchApplication_showIcon_autolaunch(
            &self,
            app_name: &NSString,
            show_icon: bool,
            autolaunch: bool,
        ) -> bool;

        #[deprecated = "Use -[NSWorkspace URLForApplicationWithBundleIdentifier:] instead."]
        #[unsafe(method(fullPathForApplication:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fullPathForApplication(
            &self,
            app_name: &NSString,
        ) -> Option<Retained<NSString>>;

        #[deprecated = "Use -[NSWorkspace URLForApplicationWithBundleIdentifier:] instead."]
        #[unsafe(method(absolutePathForAppBundleWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn absolutePathForAppBundleWithIdentifier(
            &self,
            bundle_identifier: &NSString,
        ) -> Option<Retained<NSString>>;

        #[deprecated = "Use -[NSWorkspace openApplicationAtURL:configuration:completionHandler:] instead."]
        #[unsafe(method(launchAppWithBundleIdentifier:options:additionalEventParamDescriptor:launchIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn launchAppWithBundleIdentifier_options_additionalEventParamDescriptor_launchIdentifier(
            &self,
            bundle_identifier: &NSString,
            options: NSWorkspaceLaunchOptions,
            descriptor: Option<&NSAppleEventDescriptor>,
            identifier: Option<&mut Option<Retained<NSNumber>>>,
        ) -> bool;

        #[deprecated = "Use -[NSWorkspace openURLs:withApplicationAtURL:configuration:completionHandler:] instead."]
        #[unsafe(method(openURLs:withAppBundleIdentifier:options:additionalEventParamDescriptor:launchIdentifiers:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openURLs_withAppBundleIdentifier_options_additionalEventParamDescriptor_launchIdentifiers(
            &self,
            urls: &NSArray<NSURL>,
            bundle_identifier: Option<&NSString>,
            options: NSWorkspaceLaunchOptions,
            descriptor: Option<&NSAppleEventDescriptor>,
            identifiers: Option<&mut Option<Retained<NSArray<NSNumber>>>>,
        ) -> bool;

        #[deprecated]
        #[unsafe(method(openTempFile:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openTempFile(&self, full_path: &NSString) -> bool;

        #[deprecated]
        #[unsafe(method(findApplications))]
        #[unsafe(method_family = none)]
        pub unsafe fn findApplications(&self);

        #[deprecated]
        #[unsafe(method(noteUserDefaultsChanged))]
        #[unsafe(method_family = none)]
        pub unsafe fn noteUserDefaultsChanged(&self);

        #[cfg(feature = "NSImage")]
        #[deprecated]
        #[unsafe(method(slideImage:from:to:))]
        #[unsafe(method_family = none)]
        pub unsafe fn slideImage_from_to(
            &self,
            image: &NSImage,
            from_point: NSPoint,
            to_point: NSPoint,
        );

        #[deprecated]
        #[unsafe(method(checkForRemovableMedia))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkForRemovableMedia(&self);

        #[deprecated]
        #[unsafe(method(noteFileSystemChanged))]
        #[unsafe(method_family = none)]
        pub unsafe fn noteFileSystemChanged(&self);

        #[deprecated]
        #[unsafe(method(fileSystemChanged))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileSystemChanged(&self) -> bool;

        #[deprecated]
        #[unsafe(method(userDefaultsChanged))]
        #[unsafe(method_family = none)]
        pub unsafe fn userDefaultsChanged(&self) -> bool;

        #[deprecated]
        #[unsafe(method(mountNewRemovableMedia))]
        #[unsafe(method_family = none)]
        pub unsafe fn mountNewRemovableMedia(&self) -> Option<Retained<NSArray>>;

        #[deprecated = "Use -[NSWorkspace frontmostApplication] instead."]
        #[unsafe(method(activeApplication))]
        #[unsafe(method_family = none)]
        pub unsafe fn activeApplication(&self) -> Option<Retained<NSDictionary>>;

        #[deprecated = "Use -[NSFileManager mountedVolumeURLsIncludingResourceValuesForKeys:options:] instead."]
        #[unsafe(method(mountedLocalVolumePaths))]
        #[unsafe(method_family = none)]
        pub unsafe fn mountedLocalVolumePaths(&self) -> Option<Retained<NSArray>>;

        #[deprecated = "Use -[NSFileManager mountedVolumeURLsIncludingResourceValuesForKeys:options:] instead."]
        #[unsafe(method(mountedRemovableMedia))]
        #[unsafe(method_family = none)]
        pub unsafe fn mountedRemovableMedia(&self) -> Option<Retained<NSArray>>;

        #[deprecated = "Use -[NSWorkspace runningApplications] instead."]
        #[unsafe(method(launchedApplications))]
        #[unsafe(method_family = none)]
        pub unsafe fn launchedApplications(&self) -> Option<Retained<NSArray>>;

        #[cfg(all(feature = "NSImage", feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use -[NSWorkspace openURL:] instead."]
        #[unsafe(method(openFile:fromImage:at:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openFile_fromImage_at_inView(
            &self,
            full_path: &NSString,
            image: Option<&NSImage>,
            point: NSPoint,
            view: Option<&NSView>,
        ) -> bool;

        #[deprecated]
        #[unsafe(method(performFileOperation:source:destination:files:tag:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performFileOperation_source_destination_files_tag(
            &self,
            operation: &NSWorkspaceFileOperationName,
            source: &NSString,
            destination: &NSString,
            files: &NSArray,
            tag: *mut NSInteger,
        ) -> bool;

        #[deprecated = "Use -[NSWorkspace URLForApplicationToOpenURL:] to get the URL of an application that will open a given item, or -[NSURL getResourceValue:forKey:error:] with NSURLContentTypeKey to get the type of the given item."]
        #[unsafe(method(getInfoForFile:application:type:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getInfoForFile_application_type(
            &self,
            full_path: &NSString,
            app_name: Option<&mut Option<Retained<NSString>>>,
            r#type: Option<&mut Option<Retained<NSString>>>,
        ) -> bool;

        #[cfg(feature = "NSImage")]
        #[deprecated = "Use -[NSWorkspace iconForContentType:] instead."]
        #[unsafe(method(iconForFileType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn iconForFileType(&self, file_type: &NSString) -> Retained<NSImage>;

        #[deprecated = "Use -[NSURL getResourceValue:forKey:error:] with NSURLContentTypeKey instead."]
        #[unsafe(method(typeOfFile:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn typeOfFile_error(
            &self,
            absolute_file_path: &NSString,
        ) -> Result<Retained<NSString>, Retained<NSError>>;

        #[deprecated = "Use UTType.localizedDescription instead."]
        #[unsafe(method(localizedDescriptionForType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedDescriptionForType(
            &self,
            type_name: &NSString,
        ) -> Option<Retained<NSString>>;

        #[deprecated = "Use UTType.preferredFilenameExtension instead."]
        #[unsafe(method(preferredFilenameExtensionForType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredFilenameExtensionForType(
            &self,
            type_name: &NSString,
        ) -> Option<Retained<NSString>>;

        #[deprecated = "Use +[UTType typesWithTag:tagClass:conformingToType:] to get a list of candidate types, then check if the input type conforms to any of them."]
        #[unsafe(method(filenameExtension:isValidForType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn filenameExtension_isValidForType(
            &self,
            filename_extension: &NSString,
            type_name: &NSString,
        ) -> bool;

        #[deprecated = "Use -[UTType conformsToType:] instead."]
        #[unsafe(method(type:conformsToType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn type_conformsToType(
            &self,
            first_type_name: &NSString,
            second_type_name: &NSString,
        ) -> bool;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacemoveoperation?language=objc)
    pub static NSWorkspaceMoveOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacecopyoperation?language=objc)
    pub static NSWorkspaceCopyOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacelinkoperation?language=objc)
    pub static NSWorkspaceLinkOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacecompressoperation?language=objc)
    pub static NSWorkspaceCompressOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedecompressoperation?language=objc)
    pub static NSWorkspaceDecompressOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceencryptoperation?language=objc)
    pub static NSWorkspaceEncryptOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedecryptoperation?language=objc)
    pub static NSWorkspaceDecryptOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedestroyoperation?language=objc)
    pub static NSWorkspaceDestroyOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacerecycleoperation?language=objc)
    pub static NSWorkspaceRecycleOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspaceduplicateoperation?language=objc)
    pub static NSWorkspaceDuplicateOperation: &'static NSWorkspaceFileOperationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsworkspacedidperformfileoperationnotification?language=objc)
    pub static NSWorkspaceDidPerformFileOperationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsplainfiletype?language=objc)
    pub static NSPlainFileType: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdirectoryfiletype?language=objc)
    pub static NSDirectoryFileType: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsapplicationfiletype?language=objc)
    pub static NSApplicationFileType: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfilesystemfiletype?language=objc)
    pub static NSFilesystemFileType: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsshellcommandfiletype?language=objc)
    pub static NSShellCommandFileType: &'static NSString;
}
