// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::write_get_object_response::_write_get_object_response_output::WriteGetObjectResponseOutputBuilder;

pub use crate::operation::write_get_object_response::_write_get_object_response_input::WriteGetObjectResponseInputBuilder;

impl crate::operation::write_get_object_response::builders::WriteGetObjectResponseInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::write_get_object_response::WriteGetObjectResponseOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::write_get_object_response::WriteGetObjectResponseError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.write_get_object_response();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `WriteGetObjectResponse`.
///
/// <note>
/// <p>This operation is not supported for directory buckets.</p>
/// </note>
/// <p>Passes transformed objects to a <code>GetObject</code> operation when using Object Lambda access points. For information about Object Lambda access points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html">Transforming objects with Object Lambda access points</a> in the <i>Amazon S3 User Guide</i>.</p>
/// <p>This operation supports metadata that can be returned by <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>, in addition to <code>RequestRoute</code>, <code>RequestToken</code>, <code>StatusCode</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>. The <code>GetObject</code> response metadata is supported so that the <code>WriteGetObjectResponse</code> caller, typically an Lambda function, can provide the same metadata when it internally invokes <code>GetObject</code>. When <code>WriteGetObjectResponse</code> is called by a customer-owned Lambda function, the metadata returned to the end user <code>GetObject</code> call might differ from what Amazon S3 would normally return.</p>
/// <p>You can include any number of metadata headers. When including a metadata header, it should be prefaced with <code>x-amz-meta</code>. For example, <code>x-amz-meta-my-custom-header: MyCustomValue</code>. The primary use case for this is to forward <code>GetObject</code> metadata.</p>
/// <p>Amazon Web Services provides some prebuilt Lambda functions that you can use with S3 Object Lambda to detect and redact personally identifiable information (PII) and decompress S3 objects. These Lambda functions are available in the Amazon Web Services Serverless Application Repository, and can be selected through the Amazon Web Services Management Console when you create your Object Lambda access point.</p>
/// <p>Example 1: PII Access Control - This Lambda function uses Amazon Comprehend, a natural language processing (NLP) service using machine learning to find insights and relationships in text. It automatically detects personally identifiable information (PII) such as names, addresses, dates, credit card numbers, and social security numbers from documents in your Amazon S3 bucket.</p>
/// <p>Example 2: PII Redaction - This Lambda function uses Amazon Comprehend, a natural language processing (NLP) service using machine learning to find insights and relationships in text. It automatically redacts personally identifiable information (PII) such as names, addresses, dates, credit card numbers, and social security numbers from documents in your Amazon S3 bucket.</p>
/// <p>Example 3: Decompression - The Lambda function S3ObjectLambdaDecompression, is equipped to decompress objects stored in S3 in one of six compressed file formats including bzip2, gzip, snappy, zlib, zstandard and ZIP.</p>
/// <p>For information on how to view and use these functions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-examples.html">Using Amazon Web Services built Lambda functions</a> in the <i>Amazon S3 User Guide</i>.</p>
#[derive(::std::fmt::Debug)]
pub struct WriteGetObjectResponseFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::write_get_object_response::builders::WriteGetObjectResponseInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::write_get_object_response::WriteGetObjectResponseOutput,
        crate::operation::write_get_object_response::WriteGetObjectResponseError,
    > for WriteGetObjectResponseFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::write_get_object_response::WriteGetObjectResponseOutput,
            crate::operation::write_get_object_response::WriteGetObjectResponseError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl WriteGetObjectResponseFluentBuilder {
    /// Creates a new `WriteGetObjectResponseFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the WriteGetObjectResponse as a reference.
    pub fn as_input(&self) -> &crate::operation::write_get_object_response::builders::WriteGetObjectResponseInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::write_get_object_response::WriteGetObjectResponseOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::write_get_object_response::WriteGetObjectResponseError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::write_get_object_response::WriteGetObjectResponse::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::write_get_object_response::WriteGetObjectResponse::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::write_get_object_response::WriteGetObjectResponseOutput,
        crate::operation::write_get_object_response::WriteGetObjectResponseError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>Route prefix to the HTTP URL generated.</p>
    pub fn request_route(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.request_route(input.into());
        self
    }
    /// <p>Route prefix to the HTTP URL generated.</p>
    pub fn set_request_route(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_request_route(input);
        self
    }
    /// <p>Route prefix to the HTTP URL generated.</p>
    pub fn get_request_route(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_request_route()
    }
    /// <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    pub fn request_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.request_token(input.into());
        self
    }
    /// <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    pub fn set_request_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_request_token(input);
        self
    }
    /// <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    pub fn get_request_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_request_token()
    }
    /// <p>The object data.</p>
    pub fn body(mut self, input: ::aws_smithy_types::byte_stream::ByteStream) -> Self {
        self.inner = self.inner.body(input);
        self
    }
    /// <p>The object data.</p>
    pub fn set_body(mut self, input: ::std::option::Option<::aws_smithy_types::byte_stream::ByteStream>) -> Self {
        self.inner = self.inner.set_body(input);
        self
    }
    /// <p>The object data.</p>
    pub fn get_body(&self) -> &::std::option::Option<::aws_smithy_types::byte_stream::ByteStream> {
        self.inner.get_body()
    }
    /// <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request. The following is a list of status codes.</p>
    /// <ul>
    /// <li>
    /// <p><code>200 - OK</code></p></li>
    /// <li>
    /// <p><code>206 - Partial Content</code></p></li>
    /// <li>
    /// <p><code>304 - Not Modified</code></p></li>
    /// <li>
    /// <p><code>400 - Bad Request</code></p></li>
    /// <li>
    /// <p><code>401 - Unauthorized</code></p></li>
    /// <li>
    /// <p><code>403 - Forbidden</code></p></li>
    /// <li>
    /// <p><code>404 - Not Found</code></p></li>
    /// <li>
    /// <p><code>405 - Method Not Allowed</code></p></li>
    /// <li>
    /// <p><code>409 - Conflict</code></p></li>
    /// <li>
    /// <p><code>411 - Length Required</code></p></li>
    /// <li>
    /// <p><code>412 - Precondition Failed</code></p></li>
    /// <li>
    /// <p><code>416 - Range Not Satisfiable</code></p></li>
    /// <li>
    /// <p><code>500 - Internal Server Error</code></p></li>
    /// <li>
    /// <p><code>503 - Service Unavailable</code></p></li>
    /// </ul>
    pub fn status_code(mut self, input: i32) -> Self {
        self.inner = self.inner.status_code(input);
        self
    }
    /// <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request. The following is a list of status codes.</p>
    /// <ul>
    /// <li>
    /// <p><code>200 - OK</code></p></li>
    /// <li>
    /// <p><code>206 - Partial Content</code></p></li>
    /// <li>
    /// <p><code>304 - Not Modified</code></p></li>
    /// <li>
    /// <p><code>400 - Bad Request</code></p></li>
    /// <li>
    /// <p><code>401 - Unauthorized</code></p></li>
    /// <li>
    /// <p><code>403 - Forbidden</code></p></li>
    /// <li>
    /// <p><code>404 - Not Found</code></p></li>
    /// <li>
    /// <p><code>405 - Method Not Allowed</code></p></li>
    /// <li>
    /// <p><code>409 - Conflict</code></p></li>
    /// <li>
    /// <p><code>411 - Length Required</code></p></li>
    /// <li>
    /// <p><code>412 - Precondition Failed</code></p></li>
    /// <li>
    /// <p><code>416 - Range Not Satisfiable</code></p></li>
    /// <li>
    /// <p><code>500 - Internal Server Error</code></p></li>
    /// <li>
    /// <p><code>503 - Service Unavailable</code></p></li>
    /// </ul>
    pub fn set_status_code(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_status_code(input);
        self
    }
    /// <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request. The following is a list of status codes.</p>
    /// <ul>
    /// <li>
    /// <p><code>200 - OK</code></p></li>
    /// <li>
    /// <p><code>206 - Partial Content</code></p></li>
    /// <li>
    /// <p><code>304 - Not Modified</code></p></li>
    /// <li>
    /// <p><code>400 - Bad Request</code></p></li>
    /// <li>
    /// <p><code>401 - Unauthorized</code></p></li>
    /// <li>
    /// <p><code>403 - Forbidden</code></p></li>
    /// <li>
    /// <p><code>404 - Not Found</code></p></li>
    /// <li>
    /// <p><code>405 - Method Not Allowed</code></p></li>
    /// <li>
    /// <p><code>409 - Conflict</code></p></li>
    /// <li>
    /// <p><code>411 - Length Required</code></p></li>
    /// <li>
    /// <p><code>412 - Precondition Failed</code></p></li>
    /// <li>
    /// <p><code>416 - Range Not Satisfiable</code></p></li>
    /// <li>
    /// <p><code>500 - Internal Server Error</code></p></li>
    /// <li>
    /// <p><code>503 - Service Unavailable</code></p></li>
    /// </ul>
    pub fn get_status_code(&self) -> &::std::option::Option<i32> {
        self.inner.get_status_code()
    }
    /// <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. The regular expression (regex) value is <code>"^\[A-Z\]\[a-zA-Z\]+$"</code>.</code></p>
    pub fn error_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.error_code(input.into());
        self
    }
    /// <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. The regular expression (regex) value is <code>"^\[A-Z\]\[a-zA-Z\]+$"</code>.</code></p>
    pub fn set_error_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_error_code(input);
        self
    }
    /// <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. The regular expression (regex) value is <code>"^\[A-Z\]\[a-zA-Z\]+$"</code>.</code></p>
    pub fn get_error_code(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_error_code()
    }
    /// <p>Contains a generic description of the error condition. Returned in the <message>
    /// tag of the error XML response for a corresponding
    /// <code>GetObject</code> call. Cannot be used with a successful
    /// <code>StatusCode</code> header or when the transformed object is provided in body.
    /// </message></p>
    pub fn error_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.error_message(input.into());
        self
    }
    /// <p>Contains a generic description of the error condition. Returned in the <message>
    /// tag of the error XML response for a corresponding
    /// <code>GetObject</code> call. Cannot be used with a successful
    /// <code>StatusCode</code> header or when the transformed object is provided in body.
    /// </message></p>
    pub fn set_error_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_error_message(input);
        self
    }
    /// <p>Contains a generic description of the error condition. Returned in the <message>
    /// tag of the error XML response for a corresponding
    /// <code>GetObject</code> call. Cannot be used with a successful
    /// <code>StatusCode</code> header or when the transformed object is provided in body.
    /// </message></p>
    pub fn get_error_message(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_error_message()
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn accept_ranges(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.accept_ranges(input.into());
        self
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn set_accept_ranges(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_accept_ranges(input);
        self
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn get_accept_ranges(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_accept_ranges()
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn cache_control(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.cache_control(input.into());
        self
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn set_cache_control(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_cache_control(input);
        self
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn get_cache_control(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_cache_control()
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn content_disposition(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_disposition(input.into());
        self
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn set_content_disposition(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_disposition(input);
        self
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn get_content_disposition(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_disposition()
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    pub fn content_encoding(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_encoding(input.into());
        self
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    pub fn set_content_encoding(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_encoding(input);
        self
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    pub fn get_content_encoding(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_encoding()
    }
    /// <p>The language the content is in.</p>
    pub fn content_language(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_language(input.into());
        self
    }
    /// <p>The language the content is in.</p>
    pub fn set_content_language(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_language(input);
        self
    }
    /// <p>The language the content is in.</p>
    pub fn get_content_language(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_language()
    }
    /// <p>The size of the content body in bytes.</p>
    pub fn content_length(mut self, input: i64) -> Self {
        self.inner = self.inner.content_length(input);
        self
    }
    /// <p>The size of the content body in bytes.</p>
    pub fn set_content_length(mut self, input: ::std::option::Option<i64>) -> Self {
        self.inner = self.inner.set_content_length(input);
        self
    }
    /// <p>The size of the content body in bytes.</p>
    pub fn get_content_length(&self) -> &::std::option::Option<i64> {
        self.inner.get_content_length()
    }
    /// <p>The portion of the object returned in the response.</p>
    pub fn content_range(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_range(input.into());
        self
    }
    /// <p>The portion of the object returned in the response.</p>
    pub fn set_content_range(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_range(input);
        self
    }
    /// <p>The portion of the object returned in the response.</p>
    pub fn get_content_range(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_range()
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_type(input.into());
        self
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_type(input);
        self
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_type()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    /// <p></p>
    pub fn checksum_crc32(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.checksum_crc32(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    /// <p></p>
    pub fn set_checksum_crc32(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_checksum_crc32(input);
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    /// <p></p>
    pub fn get_checksum_crc32(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_checksum_crc32()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_crc32_c(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.checksum_crc32_c(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn set_checksum_crc32_c(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_checksum_crc32_c(input);
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn get_checksum_crc32_c(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_checksum_crc32_c()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the part. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn checksum_crc64_nvme(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.checksum_crc64_nvme(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the part. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_checksum_crc64_nvme(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_checksum_crc64_nvme(input);
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the part. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_checksum_crc64_nvme(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_checksum_crc64_nvme()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 160-bit <code>SHA1</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_sha1(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.checksum_sha1(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 160-bit <code>SHA1</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn set_checksum_sha1(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_checksum_sha1(input);
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 160-bit <code>SHA1</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn get_checksum_sha1(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_checksum_sha1()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 256-bit <code>SHA256</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_sha256(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.checksum_sha256(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 256-bit <code>SHA256</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn set_checksum_sha256(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_checksum_sha256(input);
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 256-bit <code>SHA256</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn get_checksum_sha256(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_checksum_sha256()
    }
    /// <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    pub fn delete_marker(mut self, input: bool) -> Self {
        self.inner = self.inner.delete_marker(input);
        self
    }
    /// <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    pub fn set_delete_marker(mut self, input: ::std::option::Option<bool>) -> Self {
        self.inner = self.inner.set_delete_marker(input);
        self
    }
    /// <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    pub fn get_delete_marker(&self) -> &::std::option::Option<bool> {
        self.inner.get_delete_marker()
    }
    /// <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    pub fn e_tag(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.e_tag(input.into());
        self
    }
    /// <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    pub fn set_e_tag(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_e_tag(input);
        self
    }
    /// <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    pub fn get_e_tag(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_e_tag()
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn expires(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.expires(input);
        self
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn set_expires(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_expires(input);
        self
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn get_expires(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_expires()
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide the object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p>
    pub fn expiration(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.expiration(input.into());
        self
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide the object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p>
    pub fn set_expiration(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_expiration(input);
        self
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide the object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p>
    pub fn get_expiration(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_expiration()
    }
    /// <p>The date and time that the object was last modified.</p>
    pub fn last_modified(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.last_modified(input);
        self
    }
    /// <p>The date and time that the object was last modified.</p>
    pub fn set_last_modified(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_last_modified(input);
        self
    }
    /// <p>The date and time that the object was last modified.</p>
    pub fn get_last_modified(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_last_modified()
    }
    /// <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    pub fn missing_meta(mut self, input: i32) -> Self {
        self.inner = self.inner.missing_meta(input);
        self
    }
    /// <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    pub fn set_missing_meta(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_missing_meta(input);
        self
    }
    /// <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    pub fn get_missing_meta(&self) -> &::std::option::Option<i32> {
        self.inner.get_missing_meta()
    }
    ///
    /// Adds a key-value pair to `Metadata`.
    ///
    /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
    ///
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn metadata(mut self, k: impl ::std::convert::Into<::std::string::String>, v: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.metadata(k.into(), v.into());
        self
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn set_metadata(mut self, input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>) -> Self {
        self.inner = self.inner.set_metadata(input);
        self
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn get_metadata(&self) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.inner.get_metadata()
    }
    /// <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    pub fn object_lock_mode(mut self, input: crate::types::ObjectLockMode) -> Self {
        self.inner = self.inner.object_lock_mode(input);
        self
    }
    /// <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    pub fn set_object_lock_mode(mut self, input: ::std::option::Option<crate::types::ObjectLockMode>) -> Self {
        self.inner = self.inner.set_object_lock_mode(input);
        self
    }
    /// <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    pub fn get_object_lock_mode(&self) -> &::std::option::Option<crate::types::ObjectLockMode> {
        self.inner.get_object_lock_mode()
    }
    /// <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    pub fn object_lock_legal_hold_status(mut self, input: crate::types::ObjectLockLegalHoldStatus) -> Self {
        self.inner = self.inner.object_lock_legal_hold_status(input);
        self
    }
    /// <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    pub fn set_object_lock_legal_hold_status(mut self, input: ::std::option::Option<crate::types::ObjectLockLegalHoldStatus>) -> Self {
        self.inner = self.inner.set_object_lock_legal_hold_status(input);
        self
    }
    /// <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    pub fn get_object_lock_legal_hold_status(&self) -> &::std::option::Option<crate::types::ObjectLockLegalHoldStatus> {
        self.inner.get_object_lock_legal_hold_status()
    }
    /// <p>The date and time when Object Lock is configured to expire.</p>
    pub fn object_lock_retain_until_date(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.object_lock_retain_until_date(input);
        self
    }
    /// <p>The date and time when Object Lock is configured to expire.</p>
    pub fn set_object_lock_retain_until_date(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_object_lock_retain_until_date(input);
        self
    }
    /// <p>The date and time when Object Lock is configured to expire.</p>
    pub fn get_object_lock_retain_until_date(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_object_lock_retain_until_date()
    }
    /// <p>The count of parts this object has.</p>
    pub fn parts_count(mut self, input: i32) -> Self {
        self.inner = self.inner.parts_count(input);
        self
    }
    /// <p>The count of parts this object has.</p>
    pub fn set_parts_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_parts_count(input);
        self
    }
    /// <p>The count of parts this object has.</p>
    pub fn get_parts_count(&self) -> &::std::option::Option<i32> {
        self.inner.get_parts_count()
    }
    /// <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    pub fn replication_status(mut self, input: crate::types::ReplicationStatus) -> Self {
        self.inner = self.inner.replication_status(input);
        self
    }
    /// <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    pub fn set_replication_status(mut self, input: ::std::option::Option<crate::types::ReplicationStatus>) -> Self {
        self.inner = self.inner.set_replication_status(input);
        self
    }
    /// <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    pub fn get_replication_status(&self) -> &::std::option::Option<crate::types::ReplicationStatus> {
        self.inner.get_replication_status()
    }
    /// <p>If present, indicates that the requester was successfully charged for the request.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn request_charged(mut self, input: crate::types::RequestCharged) -> Self {
        self.inner = self.inner.request_charged(input);
        self
    }
    /// <p>If present, indicates that the requester was successfully charged for the request.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_request_charged(mut self, input: ::std::option::Option<crate::types::RequestCharged>) -> Self {
        self.inner = self.inner.set_request_charged(input);
        self
    }
    /// <p>If present, indicates that the requester was successfully charged for the request.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_request_charged(&self) -> &::std::option::Option<crate::types::RequestCharged> {
        self.inner.get_request_charged()
    }
    /// <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    pub fn restore(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.restore(input.into());
        self
    }
    /// <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    pub fn set_restore(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_restore(input);
        self
    }
    /// <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    pub fn get_restore(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_restore()
    }
    /// <p>The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn server_side_encryption(mut self, input: crate::types::ServerSideEncryption) -> Self {
        self.inner = self.inner.server_side_encryption(input);
        self
    }
    /// <p>The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn set_server_side_encryption(mut self, input: ::std::option::Option<crate::types::ServerSideEncryption>) -> Self {
        self.inner = self.inner.set_server_side_encryption(input);
        self
    }
    /// <p>The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn get_server_side_encryption(&self) -> &::std::option::Option<crate::types::ServerSideEncryption> {
        self.inner.get_server_side_encryption()
    }
    /// <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    pub fn sse_customer_algorithm(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.sse_customer_algorithm(input.into());
        self
    }
    /// <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    pub fn set_sse_customer_algorithm(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_sse_customer_algorithm(input);
        self
    }
    /// <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    pub fn get_sse_customer_algorithm(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_sse_customer_algorithm()
    }
    /// <p>If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key that was used for stored in Amazon S3 object.</p>
    pub fn ssekms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.ssekms_key_id(input.into());
        self
    }
    /// <p>If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key that was used for stored in Amazon S3 object.</p>
    pub fn set_ssekms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_ssekms_key_id(input);
        self
    }
    /// <p>If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key that was used for stored in Amazon S3 object.</p>
    pub fn get_ssekms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_ssekms_key_id()
    }
    /// <p>128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    pub fn sse_customer_key_md5(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.sse_customer_key_md5(input.into());
        self
    }
    /// <p>128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    pub fn set_sse_customer_key_md5(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_sse_customer_key_md5(input);
        self
    }
    /// <p>128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    pub fn get_sse_customer_key_md5(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_sse_customer_key_md5()
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    pub fn storage_class(mut self, input: crate::types::StorageClass) -> Self {
        self.inner = self.inner.storage_class(input);
        self
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    pub fn set_storage_class(mut self, input: ::std::option::Option<crate::types::StorageClass>) -> Self {
        self.inner = self.inner.set_storage_class(input);
        self
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    pub fn get_storage_class(&self) -> &::std::option::Option<crate::types::StorageClass> {
        self.inner.get_storage_class()
    }
    /// <p>The number of tags, if any, on the object.</p>
    pub fn tag_count(mut self, input: i32) -> Self {
        self.inner = self.inner.tag_count(input);
        self
    }
    /// <p>The number of tags, if any, on the object.</p>
    pub fn set_tag_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_tag_count(input);
        self
    }
    /// <p>The number of tags, if any, on the object.</p>
    pub fn get_tag_count(&self) -> &::std::option::Option<i32> {
        self.inner.get_tag_count()
    }
    /// <p>An ID used to reference a specific version of the object.</p>
    pub fn version_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.version_id(input.into());
        self
    }
    /// <p>An ID used to reference a specific version of the object.</p>
    pub fn set_version_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_version_id(input);
        self
    }
    /// <p>An ID used to reference a specific version of the object.</p>
    pub fn get_version_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_version_id()
    }
    /// <p>Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(mut self, input: bool) -> Self {
        self.inner = self.inner.bucket_key_enabled(input);
        self
    }
    /// <p>Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn set_bucket_key_enabled(mut self, input: ::std::option::Option<bool>) -> Self {
        self.inner = self.inner.set_bucket_key_enabled(input);
        self
    }
    /// <p>Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn get_bucket_key_enabled(&self) -> &::std::option::Option<bool> {
        self.inner.get_bucket_key_enabled()
    }
}
