<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:db="http://docbook.org/ns/docbook" xmlns:pgis="http://postgis.net/pgis"
><!-- ********************************************************************
 ********************************************************************
	 Copyright 2010, Regina Obe
	 License: BSD-3-Clause
	 Purpose: This is an xsl transform that generates an sql test script from xml docs to test all the raster related functions we have documented
			using a garden variety of rasters.  Its intent is to flag major crashes.
	 ******************************************************************** -->
	<xsl:output method="text" />
	<xsl:variable name='testversion'>3.6.0</xsl:variable>
	<xsl:variable name='fnexclude'>AddRasterColumn AddRasterConstraints DropRasterConstraints DropRasterColumn DropRasterTable</xsl:variable>
	<!--This is just a place holder to state functions not supported in 1.3 or tested separately -->

	<xsl:variable name='var_format'>'GDAL'</xsl:variable>
	<xsl:variable name='var_srid'>3395</xsl:variable>
	<xsl:variable name='var_band'>1</xsl:variable>
	<xsl:variable name='var_integer1'>1</xsl:variable>
	<xsl:variable name='var_integer2'>2</xsl:variable>
	<xsl:variable name='var_float1'>1.5</xsl:variable>
	<xsl:variable name='var_float2'>1.75</xsl:variable>
	<xsl:variable name='var_distance'>100</xsl:variable>
	<xsl:variable name='var_NDRXDR'>XDR</xsl:variable>
	<xsl:variable name='var_text'>'monkey'</xsl:variable>
	<xsl:variable name='var_varchar'>'test'</xsl:variable>
	<xsl:variable name='var_options'>NULL::text</xsl:variable>
	<xsl:variable name="var_onerasteruserfunc">'monkey_oneuserfunc(float,integer[],text[])'::regprocedure</xsl:variable>
	<xsl:variable name='var_pixeltype'>'1BB'</xsl:variable>
	<xsl:variable name='var_pixeltypenoq'>8BUI</xsl:variable>
	<xsl:variable name='var_pixelvalue'>0</xsl:variable>
	<xsl:variable name='var_rastercolumn'>'rast'</xsl:variable>
	<xsl:variable name='var_rastertable'>'pgis_rgarden_1bb'</xsl:variable>
	<xsl:variable name='var_boolean'>false</xsl:variable>
	<xsl:variable name='var_logtable'>raster_garden_log36</xsl:variable>
	<xsl:variable name='var_pixeltypes'>{8BUI,1BB}</xsl:variable>
	<xsl:variable name='var_pixelvalues'>{255,0}</xsl:variable>
	<xsl:variable name='var_algorithm'>'Lanczos'</xsl:variable>
	<xsl:variable name='var_pt'>ST_Centroid(rast1.rast::geometry)</xsl:variable>
	<xsl:variable name='var_addbandarg'>ROW(NULL, '8BUI', 255, 0)::addbandarg</xsl:variable>
	<xsl:variable name='var_addbandargset'>ARRAY[ROW(1, '1BB'::text, 0, NULL),ROW(2, '4BUI'::text, 0, NULL)]::addbandarg[]</xsl:variable>

	<xsl:variable name='var_reclassarg'>ROW(2, '0-100:1-10, 101-500:11-150,501 - 10000: 151-254', '8BUI', 255)</xsl:variable>
	<xsl:variable name='var_georefcoords'>'2 0 0 3 0.5 0.5'</xsl:variable>
	<xsl:variable name='var_logupdatesql'>UPDATE <xsl:value-of select="$var_logtable" /> SET log_end = clock_timestamp()
		FROM (SELECT logid FROM <xsl:value-of select="$var_logtable" /> ORDER BY logid DESC limit 1) As foo
		WHERE <xsl:value-of select="$var_logtable" />.logid = foo.logid  AND <xsl:value-of select="$var_logtable" />.log_end IS NULL;</xsl:variable>

	<xsl:variable name='var_logresultsasxml'>INSERT INTO <xsl:value-of select="$var_logtable" />_output(logid, log_output)
				SELECT logid, query_to_xml(log_sql, false,false,'') As log_output
				    FROM <xsl:value-of select="$var_logtable" /> ORDER BY logid DESC LIMIT 1;</xsl:variable>

	<pgis:gardens>
		<pgis:gset ID='PointSet' GeometryType='POINT'>(SELECT ST_SetSRID(ST_Point(i,j),4326) As the_geom
		FROM (SELECT a*1.11111111 FROM generate_series(-10,50,10) As a) As i(i)
			CROSS JOIN generate_series(40,70, 15) j
			ORDER BY i,j
			)</pgis:gset>
		<pgis:gset ID='LineSet' GeometryType='LINESTRING'>(SELECT ST_MakeLine(ST_SetSRID(ST_Point(i,j),4326),ST_SetSRID(ST_Point(j,i),4326))  As the_geom
		FROM (SELECT a*1.11111111 FROM generate_series(-10,50,10) As a) As i(i)
			CROSS JOIN generate_series(40,70, 15) As j
			WHERE NOT(i = j)
			ORDER BY i, i*j)</pgis:gset>
		<pgis:gset ID='PolySet' GeometryType='POLYGON'>(SELECT ST_Buffer(ST_SetSRID(ST_Point(i,j),4326), j*0.05)  As the_geom
		FROM (SELECT a*1.11111111 FROM generate_series(-10,50,10) As a) As i(i)
			CROSS JOIN generate_series(40,70, 20) As j
			ORDER BY i, i*j, j)</pgis:gset>

		<pgis:gset ID="SingleNULL" GeometryType="GEOMETRY" createtable="false">(SELECT CAST(Null As geometry) As the_geom)</pgis:gset>
		<pgis:gset ID="MultipleNULLs" GeometryType="GEOMETRY" createtable="false">(SELECT CAST(Null As geometry) As the_geom FROM generate_series(1,4) As foo)</pgis:gset>

		<pgis:gset ID="Infinite Polygons" GeometryType="POLYGON" createtable="true">(SELECT '0106000020E61000000100000001030000000100000005000000000000000000F07F000000000000F07F000000000000F07F000000000000F07F000000000000F07F000000000000F07F000000000000F07F000000000000F07F000000000000F07F000000000000F07F'::geometry  AS the_geom
		)
		</pgis:gset>
	</pgis:gardens>
	<!--changed all to no skew so they pass the world tests -->
	<pgis:pixeltypes>
		 <pgis:pixeltype ID="1BB" PixType="1BB" createtable="true" nodata="0">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '1BB'), i, (i+1),0),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="2BUI" PixType="2BUI" createtable="true" nodata="2">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '2BUI'), i, (i+1),1),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="4BUI" PixType="4BUI" createtable="true" nodata="15">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '4BUI'), i, (i+1),14),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="8BSI" PixType="8BSI" createtable="true" nodata="-56">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '8BSI'), i, (i+1),-50),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="8BUI" PixType="8BUI" createtable="true" nodata="255">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '8BUI'), i, (i+1),150),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="16BSI" PixType="16BSI" createtable="true" nodata="0">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '16BSI'), i, (i+1),-6000),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="16BUI" PixType="16BUI" createtable="true" nodata="65535">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '16BUI'), i, (i+1),64567),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="32BSI" PixType="32BSI" createtable="true" nodata="-4294967295">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '32BSI'), i, (i+1),-429496),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="32BUI" PixType="32BUI" createtable="true" nodata="4294967295">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '32BUI'), i, (i+1),42949),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="32BF" PixType="32BF" createtable="true" nodata="-4294.967295">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '32BF'), i, (i+1),-4294),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		  <pgis:pixeltype ID="64BF" PixType="64BF" createtable="true" nodata="429496.7295">
		 	(SELECT ST_SetSRID(ST_SetValue(ST_AddBand(ST_MakeEmptyRaster( 10, 10, (i-1)*10, (i-1)*10, 0.0005, -0.0005, 0*i, 0*i), '64BF'), i, (i+1),42949.12345),4326) As rast
		 		FROM generate_series(1,2) As i)
		 </pgis:pixeltype>
		 <pgis:pixeltype ID="NULLRaster" PixType="null" createtable="true" nodata="NULL">
		 	(SELECT NULL::raster As rast
		 		FROM generate_series(1,3) As i)
		 </pgis:pixeltype>
	</pgis:pixeltypes>
        <!-- We deal only with the reference chapter -->
        <xsl:template match="/">
<!-- Create logging table -->
<!-- Create logging tables -->
DROP TABLE IF EXISTS <xsl:value-of select="$var_logtable" />;
CREATE TABLE <xsl:value-of select="$var_logtable" />(logid serial PRIMARY KEY, log_label text, spatial_class text DEFAULT 'raster', func text, g1 text, g2 text, log_start timestamp, log_end timestamp, log_sql text);
DROP TABLE IF EXISTS <xsl:value-of select="$var_logtable" />_output;
CREATE TABLE <xsl:value-of select="$var_logtable" />_output(logid integer PRIMARY KEY, log_output xml);
			<xsl:apply-templates select="/db:book/db:chapter[@xml:id='RT_reference']" />
           
        </xsl:template>
	<xsl:template match='db:chapter'>
<!-- define a table we call pgis_rgarden_mega that will contain a raster column with a band for all types of pixels we support -->
DROP TABLE IF EXISTS pgis_rgarden_mega;
CREATE TABLE pgis_rgarden_mega(rid serial PRIMARY KEY, rast raster);
<!--define map algebra functions -->
CREATE OR REPLACE FUNCTION monkey_oneuserfunc(pixel FLOAT, pos INTEGER[], VARIADIC args TEXT[])RETURNS FLOAT
    AS $$ BEGIN
        RETURN 0.0;
    END; $$ LANGUAGE plpgsql IMMUTABLE;
<!--Start Test table creation -->
		<xsl:for-each select="document('')//pgis:pixeltypes/pgis:pixeltype[not(contains(@createtable,'false'))]">
			<xsl:variable name='log_label'>create table Test <xsl:value-of select="@PixType" /></xsl:variable>
SELECT '<xsl:value-of select="$log_label" />: Start Testing';
<xsl:variable name='var_sql'>CREATE TABLE pgis_rgarden_<xsl:value-of select="@ID" />(rid serial PRIMARY KEY);
   ALTER TABLE pgis_rgarden_<xsl:value-of select="@ID" /> ADD COLUMN rast raster;
   ALTER TABLE pgis_rgarden_<xsl:value-of select="@ID" /> ADD COLUMN r_rasttothrow raster;</xsl:variable>
INSERT INTO <xsl:value-of select="$var_logtable" />(log_label,  func, g1, log_start,log_sql)
VALUES('<xsl:value-of select="$log_label" /> add raster column','add raster column', '<xsl:value-of select="@PixType" />', clock_timestamp(),
	  '<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1"><xsl:value-of select="$var_sql" /></xsl:with-param></xsl:call-template>');
BEGIN;
	<xsl:value-of select="$var_sql" />
	<xsl:value-of select="$var_logupdatesql" />
COMMIT;<xsl:text>
</xsl:text>
INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, g1, log_start,log_sql)
VALUES('<xsl:value-of select="$log_label" /> insert data raster','insert data', '<xsl:value-of select="@PixType" />', clock_timestamp(),
  '<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1">INSERT INTO pgis_rgarden_<xsl:value-of select="@ID" />(rast, r_rasttothrow)
	SELECT rast, rast
	FROM (<xsl:value-of select="." />) As foo;</xsl:with-param></xsl:call-template>');
BEGIN;
	INSERT INTO pgis_rgarden_<xsl:value-of select="@ID" />(rast, r_rasttothrow)
	SELECT rast, rast
	FROM (<xsl:value-of select="." />) As foo;
	<xsl:value-of select="$var_logupdatesql" />
COMMIT;
<!-- test constraints -->
INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, g1, log_start,log_sql)
VALUES('<xsl:value-of select="$log_label" /> apply raster constraints','apply raster constraints', '<xsl:value-of select="@PixType" />', clock_timestamp(),
  '<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1">SELECT AddRasterConstraints(CAST(lower('pgis_rgarden_<xsl:value-of select="@ID" />') AS name), CAST('rast' AS name));</xsl:with-param></xsl:call-template>');
BEGIN;
	SELECT AddRasterConstraints(CAST(lower('pgis_rgarden_<xsl:value-of select="@ID" />') As name), CAST('rast' AS name));
	<xsl:value-of select="$var_logupdatesql" />
COMMIT;

INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, g1, log_start,log_sql)
VALUES('<xsl:value-of select="$log_label" /> drop raster constraints','drop raster constraints', '<xsl:value-of select="@PixType" />', clock_timestamp(),
  '<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1">SELECT DropRasterConstraints(CAST(lower('pgis_rgarden_<xsl:value-of select="@ID" />') AS name), CAST('rast' AS name));</xsl:with-param></xsl:call-template>');
BEGIN;
	SELECT DropRasterConstraints(CAST(lower('pgis_rgarden_<xsl:value-of select="@ID" />') As name), CAST('rast' AS name));
	<xsl:value-of select="$var_logupdatesql" />
COMMIT;
		</xsl:for-each>
<!--End Test table creation  -->


<!--Start test on operators  -->
	<xsl:for-each select="db:section[contains(@xml:id,'RT_Operator')]/db:refentry">
		<xsl:sort select="@id"/>
		<xsl:for-each select="db:refsynopsisdiv/db:funcsynopsis/db:funcprototype">
			<xsl:variable name='fnname'><xsl:value-of select="db:funcdef/db:function"/></xsl:variable>
			<xsl:variable name='fndef'><xsl:value-of select="db:funcdef"/></xsl:variable>
			<xsl:for-each select="document('')//pgis:pixeltypes/pgis:pixeltype">
			<!--Store first garden sql raster from -->
					<xsl:variable name="from1"><xsl:value-of select="." /></xsl:variable>
					<xsl:variable name='pix1type'><xsl:value-of select="@PixType"/></xsl:variable>
					<xsl:variable name='log_label'><xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" /> against other types</xsl:variable>
		SELECT '<xsl:value-of select="$log_label" />: Start Testing ';
						<xsl:for-each select="document('')//pgis:pixeltypes/pgis:pixeltype">
		<xsl:choose>
			  <xsl:when test="contains($fndef, 'geometry')">
			 SELECT 'Geometry <xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />: Start Testing <xsl:value-of select="$geom1type" />, <xsl:value-of select="@GeometryType" />';
			 <xsl:variable name='var_sql'>SELECT foo1.the_geom <xsl:value-of select="$fnname" /> foo2.the_geom
						FROM (<xsl:value-of select="$from1" />) As foo1 CROSS JOIN (<xsl:value-of select="." />) As foo2;</xsl:variable>
			 INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, g1, g2, log_start,log_sql)
			  	VALUES('<xsl:value-of select="$log_label" /> Geometry <xsl:value-of select="$geom1type" /><xsl:text> </xsl:text><xsl:value-of select="@PixType" />','<xsl:value-of select="$fnname" />', '<xsl:value-of select="$geom1type" />','<xsl:value-of select="@GeometryType" />', clock_timestamp(),
			  	'<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1"><xsl:value-of select="$var_sql" /></xsl:with-param></xsl:call-template>');

			BEGIN;
				<!--  log query result to output table -->
				<xsl:value-of select="$var_logresultsasxml" />
				<xsl:value-of select="$var_logupdatesql" />
			COMMIT;
			</xsl:when>
			<xsl:otherwise>
			<xsl:variable name='var_sql'>SELECT rast1.rast <xsl:value-of select="$fnname" /> rast2.rast
				FROM (<xsl:value-of select="$from1" />) As rast1 CROSS JOIN (<xsl:value-of select="." />) As rast2;</xsl:variable>
			SELECT 'Raster <xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />: Start Testing <xsl:value-of select="$pix1type" />, <xsl:value-of select="@PixType" />';
			 INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, g1, g2, log_start, log_sql)
			  	VALUES('<xsl:value-of select="$log_label" /> Raster <xsl:value-of select="$pix1type" /><xsl:text> </xsl:text><xsl:value-of select="@PixType" />','<xsl:value-of select="$fnname" />', '<xsl:value-of select="$pix1type" />','<xsl:value-of select="@PixType" />', clock_timestamp(),
			  		'<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1"><xsl:value-of select="$var_sql" /></xsl:with-param></xsl:call-template>');

			BEGIN;
				<!--  log query result to output table -->
				<xsl:value-of select="$var_logresultsasxml" />
				<xsl:value-of select="$var_logupdatesql" />
			COMMIT;
			</xsl:otherwise>
		</xsl:choose>
					</xsl:for-each>
		SELECT '<xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />: End Testing <xsl:value-of select="@PixType" /> against other types';
				</xsl:for-each>
			</xsl:for-each>
	</xsl:for-each>
<!--End test on operators -->

<!-- Start regular function checks excluding operators -->
		<xsl:for-each select="db:section[not(contains(@xml:id,'Operator'))]/db:refentry">
		<xsl:sort select="@id"/>

			<xsl:for-each select="db:refsynopsisdiv/db:funcsynopsis/db:funcprototype">
<!--Create dummy parameters to be used later -->
				<xsl:variable name='fnfakeparams'><xsl:call-template name="replaceparams"><xsl:with-param name="func" select="." /></xsl:call-template></xsl:variable>
				<xsl:variable name='fnargs'><xsl:call-template name="listparams"><xsl:with-param name="func" select="." /></xsl:call-template></xsl:variable>
				<xsl:variable name='fnname'><xsl:value-of select="db:funcdef/db:function"/></xsl:variable>
				<xsl:variable name='fndef'><xsl:value-of select="db:funcdef"/></xsl:variable>
				<xsl:variable name='numparams'><xsl:value-of select="count(db:paramdef/db:parameter)" /></xsl:variable>
				<xsl:variable name='numparamgeoms'><xsl:value-of select="count(db:paramdef/db:type[contains(text(),'geometry') or contains(text(),'geography') or contains(text(),'box') ]) + count(db:paramdef/db:parameter[contains(text(),'WKT')]) + count(db:paramdef/db:parameter[contains(text(),'geomgml')])" /></xsl:variable>
				<xsl:variable name='numparamrasts'><xsl:value-of select="count(db:paramdef/db:type[contains(text(),'raster') ] )" /></xsl:variable>
				<xsl:variable name='log_label'><xsl:value-of select="db:funcdef/db:function" />(<xsl:value-of select="$fnargs" />) </xsl:variable>

				<xsl:variable name="geoftype">
				  <!--Conditionally instantiate a value to be assigned to the variable -->
				  <xsl:choose>
				  	<xsl:when test="contains(db:paramdef, 'raster ')">
					  <xsl:value-of select="Raster"/>
					</xsl:when>
					<xsl:when test="contains(db:paramdef, 'geometry ')">
					  <xsl:value-of select="Geometry"/>
					</xsl:when>
					<xsl:when test="contains(db:paramdef, 'geography ')">
					  <xsl:value-of select="Geography"/>
					</xsl:when>
					<xsl:otherwise>
					  <xsl:value-of select="Other"/>
					</xsl:otherwise>
				  </xsl:choose>
				</xsl:variable>

				<!-- is a window or aggregate function -->
				<xsl:variable name='over_clause'>
					 <xsl:choose>
					 	<xsl:when test="db:paramdef/db:type[contains(text(),'set')]">
					 		<xsl:value-of select="'OVER(ORDER BY random())'"/>
					 	</xsl:when>
					<xsl:otherwise>
					  <xsl:value-of select="''"/>
					</xsl:otherwise>
				  </xsl:choose>
				</xsl:variable>

				SELECT 'Start Considering <xsl:value-of select="db:funcdef/db:function" /> <xsl:value-of select="$geoftype" />';

				<!-- For each function prototype generate a test sql statement -->
				<xsl:choose>
<!--Test functions that take no arguments or take no geometries -->
	<xsl:when test="$numparamrasts = '0' and not(contains($fnexclude,db:funcdef/db:function))">SELECT  'Starting <xsl:value-of select="db:funcdef/db:function" />(<xsl:value-of select="$fnargs" />)';
	<xsl:variable name='var_sql'>SELECT  <xsl:value-of select="db:funcdef/db:function" />(<xsl:value-of select="$fnfakeparams" />);</xsl:variable>
INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, log_start, log_sql)
			  	VALUES('<xsl:value-of select="$log_label" />','<xsl:value-of select="$fnname" />', clock_timestamp(),
			  	'<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1"><xsl:value-of select="$var_sql" /></xsl:with-param></xsl:call-template>');

	BEGIN;
		<!--  log query result to output table -->
		<xsl:value-of select="$var_logresultsasxml" />
		<!-- log completion -->
		<xsl:value-of select="$var_logupdatesql" />
	COMMIT;
SELECT  'Ending <xsl:value-of select="db:funcdef/db:function" />(<xsl:value-of select="$fnargs" />)';
	</xsl:when>
<!--Start Test aggregate and unary functions -->
<!-- put functions that take only one raster no need to cross with another raster collection, these are unary raster, aggregates, and so forth -->
	<xsl:when test="$numparamrasts = '1' and $numparamgeoms = '0' and not(contains($fnexclude,db:funcdef/db:function))" >
		SELECT '<xsl:value-of select="$fnname" />';
		<xsl:for-each select="document('')//pgis:pixeltypes/pgis:pixeltype">
		SELECT '<xsl:value-of select="$geoftype" /> <xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />: Start Testing <xsl:value-of select="@PixType" /> with 1 rast param';
			<xsl:choose>
			  <xsl:when test="contains($fndef, 'raster ') or contains($fndef, 'geometry ')">
	 <!-- If output is raster show ewkt convexhull rep -->
	 		INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, g1, log_start, log_sql)
			  	VALUES('<xsl:value-of select="$log_label" /> <xsl:value-of select="$geoftype" /> <xsl:text> </xsl:text><xsl:value-of select="@ID" /><xsl:text> </xsl:text><xsl:value-of select="@PixType" />','<xsl:value-of select="$fnname" />', '<xsl:value-of select="@PixType" />', clock_timestamp(),
			  		'<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1">SELECT ST_AsEWKT(ST_ConvexHull(<xsl:value-of select="$fnname" />(<xsl:value-of select="$fnfakeparams" />) <xsl:value-of select="$over_clause" />)) FROM (<xsl:value-of select="." />) As rast1 LIMIT 3;</xsl:with-param></xsl:call-template>'
			  	);
			  </xsl:when>
			  <xsl:otherwise>
				SELECT 'Other <xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />: Start Testing <xsl:value-of select="@GeometryType" />';
				 <!-- If output is geometry show ewkt rep -->
				INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, g1, log_start, log_sql)
			  	VALUES('<xsl:value-of select="$log_label" /> <xsl:value-of select="$geoftype" /> <xsl:text> </xsl:text><xsl:value-of select="@ID" /><xsl:text> </xsl:text><xsl:value-of select="@PixType" />','<xsl:value-of select="$fnname" />', '<xsl:value-of select="@PixType" />', clock_timestamp(),
			  		'<xsl:call-template name="escapesinglequotes"><xsl:with-param name="arg1">SELECT <xsl:value-of select="$fnname" />(<xsl:value-of select="$fnfakeparams" />) FROM (<xsl:value-of select="." />) As rast1 LIMIT 3;</xsl:with-param></xsl:call-template>'
			  	);
			  </xsl:otherwise>
			</xsl:choose>

		BEGIN;
		<!--  log query result to output table -->
		<xsl:value-of select="$var_logresultsasxml" />
			<!-- log completion -->
		<xsl:value-of select="$var_logupdatesql" />
		  COMMIT;
		  SELECT '<xsl:value-of select="$fnname" /><xsl:text> </xsl:text> <xsl:value-of select="@ID" />: End Testing <xsl:value-of select="@PixType" />';
			<xsl:text>

			</xsl:text>
		</xsl:for-each>
	</xsl:when>

<!--Functions more than 1 args not already covered this will cross every raster pixel type with every other -->
	<xsl:when test="not(contains($fnexclude,db:funcdef/db:function))">
		<xsl:for-each select="document('')//pgis:pixeltypes/pgis:pixeltype">
<!-- log to results table -->
		SELECT '<xsl:value-of select="$geoftype" /> <xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />: Start Testing <xsl:value-of select="@PixType" />';

	<!--Store first garden sql rast  from -->
					<xsl:variable name="from1"><xsl:value-of select="." /></xsl:variable>
					<xsl:variable name='pix1type'><xsl:value-of select="@PixType"/></xsl:variable>

		SELECT '<xsl:value-of select="$fnname" /> <xsl:text> </xsl:text><xsl:value-of select="@ID" />(<xsl:value-of select="$fnargs" />): Start Testing <xsl:value-of select="$pix1type" /> against other types';
						<xsl:for-each select="document('')//pgis:pixeltypes/pgis:pixeltype">

			INSERT INTO <xsl:value-of select="$var_logtable" />(log_label, func, g1, g2, log_start)
			  	VALUES('<xsl:value-of select="$log_label" /> <xsl:value-of select="$pix1type" /> <xsl:text> </xsl:text><xsl:value-of select="@ID" /><xsl:text> </xsl:text>','<xsl:value-of select="$fnname" />', '<xsl:value-of select="$pix1type" />','<xsl:value-of select="@PixType" />', clock_timestamp());
			BEGIN;
					<xsl:choose>
						<xsl:when test="$numparamrasts > '1'">
						SELECT 'Raster <xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="$pix1type" />(<xsl:value-of select="$fnargs" />): Start Testing <xsl:value-of select="$pix1type" />, <xsl:value-of select="@PixType" />';
			<!-- If input is raster show wkt rep -->
			  <xsl:if test="contains($fndef, 'raster ') or contains($fndef, 'geometry ')">
	 <!-- If output is raster or geometry show ewkt convexhull rep -->
			SELECT ST_ConvexHull(<xsl:value-of select="$fnname" />(<xsl:value-of select="$fnfakeparams" />) )
			</xsl:if>
	<!-- else just output it -->
			<xsl:if test="not(contains($fndef, 'raster ') or contains($fndef, 'geometry ') )">
		SELECT <xsl:value-of select="$fnname" />(<xsl:value-of select="$fnfakeparams" />)
			</xsl:if>
			, ST_AsText(ST_ConvexHull(rast1.rast)) As ref1_geom, ST_AsText(ST_ConvexHull(rast2.rast)) As ref2_geom
					  </xsl:when>
					  <xsl:when test="$numparamgeoms > '0'">
						SELECT '<xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />(<xsl:value-of select="$fnargs" />): Start Testing <xsl:value-of select="$pix1type" />, <xsl:value-of select="@GeometryType" />';
			<!-- If input is geometry show ewkt rep -->
			  <xsl:if test="contains(db:funcdef, 'raster ') or contains(db:funcdef, 'geometry ')">
	 <!-- If output is raster or geometry show ewkt convexhull rep -->
			SELECT ST_ConvexHull(<xsl:value-of select="$fnname" />(<xsl:value-of select="$fnfakeparams" />) )
			</xsl:if>
	<!-- else just output it -->
			<xsl:if test="not(contains(db:funcdef, 'raster ') or contains(db:funcdef, 'geometry ') )">
		SELECT <xsl:value-of select="$fnname" />(<xsl:value-of select="$fnfakeparams" />)
			</xsl:if>
			, ST_AsEWKT(rast1.rast::geometry) As ref1_geom, ST_AsEWKT(rast2.rast::geometry) As ref2_geom
					  </xsl:when>
					  <xsl:otherwise>
						SELECT 'Other <xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />(<xsl:value-of select="$fnargs" />): Start Testing <xsl:value-of select="$pix1type" />, <xsl:value-of select="@GeometryType" />';
			<!-- If input is geography show wkt rep -->
			SELECT ST_AsText(<xsl:value-of select="$fnname" />(<xsl:value-of select="$fnfakeparams" />))
					  </xsl:otherwise>
					</xsl:choose>
					FROM (<xsl:value-of select="$from1" />) As rast1 CROSS JOIN (<xsl:value-of select="." />) As rast2
					LIMIT 2;
			<!-- log completion -->
			<xsl:value-of select="$var_logupdatesql" />
	COMMIT;
	SELECT '<xsl:value-of select="$fnname" />(<xsl:value-of select="$fnargs" />) <xsl:text> </xsl:text> <xsl:value-of select="@ID" />: End Testing <xsl:value-of select="$pix1type" />, <xsl:value-of select="@PixType" />';
		<xsl:text>

		</xsl:text>
			</xsl:for-each>
SELECT '<xsl:value-of select="$fnname" /><xsl:text> </xsl:text><xsl:value-of select="@ID" />(<xsl:value-of select="$fnargs" />): End Testing <xsl:value-of select="@PixType" /> against other types';
		</xsl:for-each>
		</xsl:when>
	</xsl:choose>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<!--macro to replace func args with dummy var args -->
	<xsl:template name="replaceparams">
		<xsl:param name="func" />
		<xsl:for-each select="$func">
			<xsl:for-each select="db:paramdef">
				<xsl:choose>
				     <!-- ignore output parameters -->
				    <xsl:when test="contains(db:parameter,'OUT')"></xsl:when>
				    <xsl:when test="contains(db:parameter, 'algorithm')">
						<xsl:value-of select="$var_algorithm" />
					</xsl:when>

					<xsl:when test="contains(db:parameter, 'georefcoords')">
						<xsl:value-of select="$var_georefcoords" />
					</xsl:when>
					<xsl:when test="(db:type = 'integer[]'  )">
						ARRAY[<xsl:value-of select="$var_integer1" />]
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'index') or contains(db:parameter, 'band') or contains(db:parameter, 'nband')">
						<xsl:value-of select="$var_band" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'rastercolumn')">
						<xsl:value-of select="$var_rastercolumn" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'rastertable')">
						<xsl:value-of select="$var_rastertable" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'format')">
						<xsl:value-of select="$var_format" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'options')">
						<xsl:value-of select="$var_options" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'pt')">
						<xsl:value-of select="$var_pt" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'pixeltype')">
						<xsl:value-of select="$var_pixeltype" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'distance')">
						<xsl:value-of select="$var_distance" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'srid')">
						<xsl:value-of select="$var_srid" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'position')">
						<xsl:value-of select="$var_position" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'NDR')">
						'<xsl:value-of select="$var_NDRXDR" />'
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'onerasteruserfunc')">
						<xsl:value-of select="$var_onerasteruserfunc" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'version') and position() = 2">
						<xsl:value-of select="$var_version1" />
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'addbandargset')">
						<xsl:value-of select="$var_addbandargset" />
					</xsl:when>
					<xsl:when test="(contains(db:type,'box') or db:type = 'geometry' or db:type = 'geometry ' or contains(type,'geometry set')) and (position() = 1 or count($func/paramdef/db:type[contains(text(),'geometry') or contains(text(),'box') or contains(text(), 'WKT') or contains(text(), 'bytea')]) = '1')">
						<xsl:text>rast1.rast::geometry</xsl:text>
					</xsl:when>
					<xsl:when test="(db:type = 'geography' or db:type = 'geography ' or contains(db:type,'geography set')) and (position() = 1 or count($func/paramdef/db:type[contains(text(),'geography')]) = '1' )">
						<xsl:text>rast1.rast::geometry::geography</xsl:text>
					</xsl:when>


					<xsl:when test="contains(db:type,'box') or db:type = 'geometry' or db:type = 'geometry '">
						<xsl:text>rast2.rast::geometry</xsl:text>
					</xsl:when>
					<xsl:when test="db:type = 'geography' or db:type = 'geography '">
						<xsl:text>geography(rast2.rast::geometry)</xsl:text>
					</xsl:when>
					<xsl:when test="contains(db:type,'raster[]') and (position() = 1) ">
						<xsl:text>ARRAY[rast1.rast]</xsl:text>
					</xsl:when>
					<xsl:when test="contains(db:type, 'raster[]') ">
						<xsl:text>ARRAY[rast2.rast]</xsl:text>
					</xsl:when>
					<xsl:when test="(db:type = 'raster' or db:type = 'raster ' or contains(db:type, 'raster set') or contains(db:type, 'setof raster') ) and (position() = 1) ">
						<xsl:text>rast1.rast</xsl:text>
					</xsl:when>
					<xsl:when test="db:type = 'raster' or db:type = 'raster ' or contains(db:type, 'raster set') or contains(db:type, 'setof raster')">
						<xsl:text>rast2.rast</xsl:text>
					</xsl:when>
					<xsl:when test="db:type = 'raster' or db:type = 'raster ' or contains(db:type, 'raster set') or contains(db:type, 'setof raster')">
						<xsl:text>rast2.rast</xsl:text>
					</xsl:when>
					<xsl:when test="contains(db:type, 'geometry[]') and count($func/db:paramdef/db:type[contains(text(),'geometry') or contains(text(),'box') or contains(text(), 'WKT') or contains(text(), 'bytea')]) = '1'">
						ARRAY[foo1.the_geom]
					</xsl:when>
					<xsl:when test="contains(db:type, 'geometry[]')">
						ARRAY[foo2.the_geom]
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'EWKT')">
						<xsl:text>ST_AsEWKT(foo1.the_geom)</xsl:text>
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'WKT')">
						<xsl:text>ST_AsText(foo1.the_geom)</xsl:text>
					</xsl:when>
					<xsl:when test="contains(db:parameter, 'EWKB')">
						<xsl:text>ST_AsEWKB(foo1.the_geom)</xsl:text>
					</xsl:when>
					<xsl:when test="contains(db:type, 'bytea')">
						<xsl:text>ST_AsBinary(foo1.the_geom)</xsl:text>
					</xsl:when>
					<xsl:when test="contains(db:type, 'float') or contains(db:type, 'double')">
						<xsl:value-of select="$var_float1" />
					</xsl:when>
					<xsl:when test="contains(db:type, 'spheroid')">
						<xsl:value-of select="$var_spheroid" />
					</xsl:when>
					<xsl:when test="contains(db:type, 'integer') and position() = 2">
						<xsl:value-of select="$var_integer1" />
					</xsl:when>
					<xsl:when test="contains(db:type, 'integer')">
						<xsl:value-of select="$var_integer2" />
					</xsl:when>
					<xsl:when test="contains(db:type,'reclassarg')">
						<xsl:value-of select="$var_reclassarg" />
					</xsl:when>

					<xsl:when test="contains(db:type, 'text')">
						<xsl:value-of select="$var_text" />
					</xsl:when>
					<xsl:when test="contains(db:type, 'varchar')">
						<xsl:value-of select="$var_varchar" />
					</xsl:when>
					<xsl:when test="contains(db:type,'timestamp') or db:type = 'date'">
						<xsl:text>'2009-01-01'</xsl:text>
					</xsl:when>
					<xsl:when test="contains(db:type,'boolean')">
						<xsl:value-of select="$var_boolean" />
					</xsl:when>
				</xsl:choose>
				<!-- put a comma before an arg if it is not the first argument in a function and it is not an OUT parameter nor does it precede an OUT parameter -->
				<xsl:if test="position()&lt;last() and not(contains(db:parameter,'OUT')) and not(contains(following-sibling::db:paramdef[1],'OUT'))"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<!--macro to pull out function db:parameter names so we can provide a pretty arg list prefix for each function -->
	<xsl:template name="listparams">
		<xsl:param name="func" />
		<xsl:for-each select="$func">
			<xsl:if test="count(db:paramdef/db:parameter) &gt; 0"> </xsl:if>
			<xsl:for-each select="db:paramdef">
				<xsl:choose>
					<xsl:when test="count(db:parameter) &gt; 0">
						<xsl:value-of select="db:parameter" />
					</xsl:when>
				</xsl:choose>
				<xsl:if test="position()&lt;last()"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<!-- copied from http://www.thedumbterminal.co.uk/php/knowledgebase/?action=view&id=94 -->
    <xsl:template name="escapesinglequotes">
     <xsl:param name="arg1"/>
     <xsl:variable name="apostrophe">'</xsl:variable>
     <xsl:choose>
      <!-- this string has at least on single quote -->
      <xsl:when test="contains($arg1, $apostrophe)">
      <xsl:if test="string-length(normalize-space(substring-before($arg1, $apostrophe))) > 0"><xsl:value-of select="substring-before($arg1, $apostrophe)" disable-output-escaping="yes"/>''</xsl:if>
       <xsl:call-template name="escapesinglequotes">
        <xsl:with-param name="arg1"><xsl:value-of select="substring-after($arg1, $apostrophe)" disable-output-escaping="yes"/></xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <!-- no quotes found in string, just print it -->
      <xsl:when test="string-length(normalize-space($arg1)) > 0"><xsl:value-of select="normalize-space($arg1)"/></xsl:when>
     </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
