/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.StringSubstitutorTest;
import org.apache.commons.text.io.StringSubstitutorReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringSubstitutorFilterReaderTest
extends StringSubstitutorTest {
    private StringSubstitutorReader createReader(StringSubstitutor substitutor, String template) {
        return new StringSubstitutorReader((Reader)new StringReader(template), substitutor);
    }

    @Override
    protected void doTestNoReplace(StringSubstitutor substitutor, String replaceTemplate) throws IOException {
        super.doTestNoReplace(substitutor, replaceTemplate);
        this.doTestNoReplaceInSteps(replaceTemplate, substitutor);
    }

    private void doTestNoReplaceInSteps(String replaceTemplate, StringSubstitutor substitutor) throws IOException {
        int targetSize;
        this.doTestReplaceInCharSteps(substitutor, replaceTemplate, replaceTemplate, false);
        boolean minTargetSize = true;
        int maxTargetSize = 8192;
        for (targetSize = 1; targetSize <= maxTargetSize; ++targetSize) {
            this.doTestReplaceInCharArraySteps(substitutor, replaceTemplate, replaceTemplate, false, targetSize);
        }
        maxTargetSize = 400;
        for (targetSize = 1; targetSize <= maxTargetSize; ++targetSize) {
            for (int targetIndex = 0; targetIndex < targetSize; ++targetIndex) {
                this.doTestReplaceInCharArrayAtSteps(substitutor, replaceTemplate, replaceTemplate, false, targetIndex, targetSize);
            }
        }
    }

    @Override
    protected void doTestReplace(StringSubstitutor sub, String expectedResult, String replaceTemplate, boolean substring) throws IOException {
        this.doTestReplaceInCharSteps(sub, expectedResult, replaceTemplate, substring);
        super.doTestReplace(sub, expectedResult, replaceTemplate, substring);
    }

    private void doTestReplaceInCharArrayAtSteps(StringSubstitutor substitutor, String expectedResult, String replaceTemplate, boolean substring, int targetIndex, int targetSize) throws IOException {
        StringWriter actualResultWriter = new StringWriter();
        StringWriter expectedResultWriter = new StringWriter();
        AtomicInteger index = new AtomicInteger();
        int expectedResultLen = StringUtils.length((CharSequence)expectedResult);
        try (Reader expectedResultReader = this.toReader(expectedResult);
             StringSubstitutorReader actualReader = new StringSubstitutorReader(this.toReader(replaceTemplate), substitutor);){
            int actualCount;
            char[] actualCh = new char[targetSize];
            char[] expectedCh = new char[targetSize];
            while ((actualCount = actualReader.read(actualCh, targetIndex, targetSize - targetIndex)) != -1) {
                int expectedCount = expectedResultReader.read(expectedCh, targetIndex, targetSize - targetIndex);
                if (expectedCount != -1) {
                    expectedResultWriter.write(expectedCh, targetIndex, expectedCount);
                }
                if (expectedCount == actualCount) {
                    Assertions.assertEquals((int)expectedCount, (int)actualCount, () -> String.format("Step size %,d", targetSize));
                    Assertions.assertArrayEquals((char[])expectedCh, (char[])actualCh, () -> String.format("[%,d] '%s' != '%s', result so far: \"%s\"", index.get(), String.valueOf(expectedCh), String.valueOf(actualCh), actualResultWriter.toString()));
                } else if (actualCount < expectedCount) {
                    Assertions.assertTrue((boolean)expectedResultWriter.toString().startsWith(actualResultWriter.toString()));
                }
                if (actualCount != -1) {
                    actualResultWriter.write(actualCh, targetIndex, actualCount);
                } else {
                    Assertions.assertEquals((int)expectedCount, (int)actualCount, () -> String.format("Step size %,d", targetSize));
                }
                index.incrementAndGet();
                Assertions.assertFalse((index.get() > expectedResultLen ? 1 : 0) != 0, () -> "Index: " + index.get());
                Arrays.fill(actualCh, '\u0000');
                Arrays.fill(expectedCh, '\u0000');
            }
        }
        Assertions.assertEquals((Object)Objects.toString(expectedResult, ""), (Object)actualResultWriter.toString());
    }

    private void doTestReplaceInCharArraySteps(StringSubstitutor substitutor, String expectedResult, String replaceTemplate, boolean substring, int targetSize) throws IOException {
        StringWriter actualResultWriter = new StringWriter();
        StringWriter expectedResultWriter = new StringWriter();
        AtomicInteger index = new AtomicInteger();
        int expectedResultLen = StringUtils.length((CharSequence)expectedResult);
        try (Reader expectedResultReader = this.toReader(expectedResult);
             StringSubstitutorReader actualReader = new StringSubstitutorReader(this.toReader(replaceTemplate), substitutor);){
            int actualCount;
            char[] actualCh = new char[targetSize];
            char[] expectedCh = new char[targetSize];
            while ((actualCount = actualReader.read(actualCh)) != -1) {
                int expectedCount = expectedResultReader.read(expectedCh);
                if (expectedCount != -1) {
                    expectedResultWriter.write(expectedCh, 0, expectedCount);
                }
                if (expectedCount == actualCount) {
                    Assertions.assertEquals((int)expectedCount, (int)actualCount, () -> String.format("Step size %,d", targetSize));
                    Assertions.assertArrayEquals((char[])expectedCh, (char[])actualCh, () -> String.format("[%,d] '%s' != '%s', result so far: \"%s\"", index.get(), String.valueOf(expectedCh), String.valueOf(actualCh), actualResultWriter.toString()));
                } else if (actualCount < expectedCount) {
                    Assertions.assertTrue((boolean)expectedResultWriter.toString().startsWith(actualResultWriter.toString()));
                }
                if (actualCount != -1) {
                    actualResultWriter.write(actualCh, 0, actualCount);
                } else {
                    Assertions.assertEquals((int)expectedCount, (int)actualCount, () -> String.format("Step size %,d", targetSize));
                }
                index.incrementAndGet();
                Assertions.assertFalse((index.get() > expectedResultLen ? 1 : 0) != 0, () -> "Index: " + index.get());
                Arrays.fill(actualCh, '\u0000');
                Arrays.fill(expectedCh, '\u0000');
            }
        }
        Assertions.assertEquals((Object)Objects.toString(expectedResult, ""), (Object)actualResultWriter.toString());
    }

    private void doTestReplaceInCharSteps(StringSubstitutor substitutor, String expectedResult, String replaceTemplate, boolean substring) throws IOException {
        StringWriter actualResultWriter = new StringWriter();
        AtomicInteger index = new AtomicInteger();
        int expectedResultLen = StringUtils.length((CharSequence)expectedResult);
        try (Reader expectedResultReader = this.toReader(expectedResult);
             StringSubstitutorReader actualReader = new StringSubstitutorReader(this.toReader(replaceTemplate), substitutor);){
            int actualCh;
            while ((actualCh = actualReader.read()) != -1) {
                int expectedCh = expectedResultReader.read();
                int actualCh2 = actualCh;
                Assertions.assertEquals((int)expectedCh, (int)actualCh, () -> String.format("[%,d] '%s' != '%s', result so far: \"%s\"", index.get(), this.toStringChar(expectedCh), this.toStringChar(actualCh2), actualResultWriter.toString()));
                if (actualCh != -1) {
                    actualResultWriter.write(actualCh);
                }
                index.incrementAndGet();
                Assertions.assertFalse((index.get() > expectedResultLen ? 1 : 0) != 0, () -> "Index: " + index.get());
            }
        }
        Assertions.assertEquals((Object)Objects.toString(expectedResult, ""), (Object)actualResultWriter.toString());
    }

    private int getMinExpressionLength(StringSubstitutor substitutor) {
        return substitutor.getVariablePrefixMatcher().size() + 1 + substitutor.getVariableSuffixMatcher().size();
    }

    @Override
    protected String replace(StringSubstitutor substitutor, String source) throws IOException {
        if (source == null) {
            return null;
        }
        try (StringSubstitutorReader reader = this.createReader(substitutor, source);){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }

    @Test
    public void testReadMixedBufferLengths1ToVarLenPlusNoReplace() throws IOException {
        StringSubstitutor substitutor = new StringSubstitutor(this.values);
        String template = "123456";
        Assertions.assertTrue(("123456".length() > this.getMinExpressionLength(substitutor) + 1 ? 1 : 0) != 0);
        try (StringSubstitutorReader reader = this.createReader(substitutor, "123456");){
            Assertions.assertEquals((int)49, (int)reader.read());
            char[] cbuf = new char["123456".length() - 1];
            reader.read(cbuf);
            String result = String.valueOf(cbuf);
            Assertions.assertEquals((Object)"123456".substring(1), (Object)result);
        }
    }

    @Test
    public void testReadMixedBufferLengthsReplace() throws IOException {
        String template = "${aa}${bb}";
        StringSubstitutor substitutor = new StringSubstitutor(this.values);
        try (StringSubstitutorReader reader = this.createReader(substitutor, "${aa}${bb}");){
            Assertions.assertEquals((int)49, (int)reader.read());
            char[] cbuf = new char[3];
            Assertions.assertEquals((int)0, (int)reader.read(cbuf, 0, 0));
            reader.read(cbuf);
            String result = String.valueOf(cbuf);
            Assertions.assertEquals((Object)"122", (Object)result, () -> String.format("length %,d", result.length()));
        }
    }

    @Test
    public void testReadMixedBufferLengthsVarLenPlusToNoReplace() throws IOException {
        StringSubstitutor substitutor = new StringSubstitutor(this.values);
        String template = "123456";
        Assertions.assertTrue(("123456".length() > this.getMinExpressionLength(substitutor) + 1 ? 1 : 0) != 0);
        try (StringSubstitutorReader reader = this.createReader(substitutor, "123456");){
            int endIndex = "123456".length() - 1;
            char[] cbuf = new char[endIndex];
            reader.read(cbuf);
            String result = String.valueOf(cbuf);
            Assertions.assertEquals((Object)"123456".substring(0, endIndex), (Object)result);
            Assertions.assertEquals((int)54, (int)reader.read());
        }
    }

    private Reader toReader(String expectedResult) {
        return expectedResult != null ? new StringReader(expectedResult) : new NullReader();
    }

    private String toStringChar(int ch) {
        switch (ch) {
            case -1: {
                return "EOS";
            }
            case 0: {
                return "NUL";
            }
        }
        return String.valueOf((char)ch);
    }
}

