/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import org.ops4j.pax.exam.options.AbstractUrlProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;

public class WrappedUrlProvisionOption
extends AbstractUrlProvisionOption<WrappedUrlProvisionOption> {
    private String bundleSymbolicName;
    private String bundleVersion;
    private String[] imports;
    private String[] exports;
    private String[] instructions;
    private OverwriteMode overwriteMode;

    public WrappedUrlProvisionOption(String url) {
        super(url);
    }

    public WrappedUrlProvisionOption(UrlReference url) {
        super(url);
    }

    @Override
    public String getURL() {
        StringBuilder options = new StringBuilder();
        if (this.overwriteMode != null) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("overwrite=").append((Object)this.overwriteMode);
        }
        if (this.bundleSymbolicName != null) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("Bundle-SymbolicName").append("=").append(this.bundleSymbolicName);
        }
        if (this.bundleVersion != null) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("Bundle-Version").append("=").append(this.bundleVersion);
        }
        if (this.imports != null && this.imports.length > 0) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("Import-Package").append("=");
            for (String entry : this.imports) {
                options.append(entry).append(",");
            }
            options.delete(options.length() - 1, options.length());
        }
        if (this.exports != null && this.exports.length > 0) {
            if (options.length() > 0) {
                options.append("&");
            }
            options.append("Export-Package").append("=");
            for (String entry : this.exports) {
                options.append(entry).append(",");
            }
            options.delete(options.length() - 1, options.length());
        }
        if (this.instructions != null && this.instructions.length > 0) {
            for (String entry : this.instructions) {
                if (options.length() > 0) {
                    options.append("&");
                }
                options.append(entry);
            }
        }
        if (options.length() > 0) {
            options.insert(0, "$");
        }
        return "wrap:" + super.getURL() + options.toString();
    }

    public WrappedUrlProvisionOption bundleSymbolicName(String _bundleSymbolicName) {
        this.bundleSymbolicName = _bundleSymbolicName;
        return this;
    }

    public WrappedUrlProvisionOption bundleVersion(String _bundleVersion) {
        this.bundleVersion = _bundleVersion;
        return this;
    }

    public WrappedUrlProvisionOption imports(String ... _imports) {
        this.imports = _imports;
        return this;
    }

    public WrappedUrlProvisionOption exports(String ... _exports) {
        this.exports = _exports;
        return this;
    }

    public WrappedUrlProvisionOption overwriteManifest(OverwriteMode mode) {
        this.overwriteMode = mode;
        return this;
    }

    public WrappedUrlProvisionOption instructions(String ... _instructions) {
        this.instructions = _instructions;
        return this;
    }

    @Override
    protected WrappedUrlProvisionOption itself() {
        return this;
    }

    public static enum OverwriteMode {
        KEEP,
        MERGE,
        FULL;

    }
}

