option(RTNEURAL_USE_AVX "Enables AVX SIMD Support" OFF)
if(NOT RTNEURAL_USE_AVX)
    target_compile_definitions(RTNeural PUBLIC RTNEURAL_DEFAULT_ALIGNMENT=16)
else()
    message(STATUS "RTNeural -- Attempting to enable AVX...")

    include(CheckCXXCompilerFlag)
    if(MSVC)
        CHECK_CXX_COMPILER_FLAG("/arch:AVX2" COMPILER_OPT_ARCH_AVX_SUPPORTED)
        if(COMPILER_OPT_ARCH_AVX_SUPPORTED)
            message(STATUS "RTNeural -- AVX2 flags enabled for MSVC compiler!")
            target_compile_options(RTNeural PUBLIC /arch:AVX2)
            target_compile_definitions(RTNeural PUBLIC RTNEURAL_AVX_ENABLED=1)
            target_compile_definitions(RTNeural PUBLIC RTNEURAL_DEFAULT_ALIGNMENT=32)
        else()
            message(STATUS "RTNeural -- Unable to add AVX2 flags for MSVC compiler!")
            target_compile_definitions(RTNeural PUBLIC RTNEURAL_DEFAULT_ALIGNMENT=16)
        endif()
    else()
        CHECK_CXX_COMPILER_FLAG("-mavx2 -mfma" COMPILER_OPT_ARCH_NATIVE_SUPPORTED)
        if (COMPILER_OPT_ARCH_NATIVE_SUPPORTED)
            message(STATUS "RTNeural -- AVX2 flags enabled for ${CMAKE_CXX_COMPILER_ID} compiler!")
            target_compile_options(RTNeural PUBLIC -mavx2 -mfma)
            target_compile_definitions(RTNeural PUBLIC RTNEURAL_AVX_ENABLED=1)
            target_compile_definitions(RTNeural PUBLIC RTNEURAL_DEFAULT_ALIGNMENT=32)
        else()
            message(STATUS "RTNeural -- Unable to enable AVX2 flags for ${CMAKE_CXX_COMPILER_ID} compiler!")
            target_compile_definitions(RTNeural PUBLIC RTNEURAL_DEFAULT_ALIGNMENT=16)
        endif()
    endif()
endif()
