
// copicatrecord_2_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  1.500000
 // --table_div  90.560287
 // --table_op  0.025000

struct tablecopicatrecord_2 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablecopicatrecord_2_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablecopicatrecord_2&() const { return *(tablecopicatrecord_2*)this; }
};

 static tablecopicatrecord_2_imp<2048> copicatrecord_2_table __rt_data = {
	0,-0.498741,34.1167,2048, {
	0.000000000000,-0.000134668088,-0.000495240002,-0.001015667437,-0.001648979644,
	-0.002361773567,-0.003130295546,-0.003937654695,-0.004771841032,-0.005624315928,
	-0.006489009593,-0.007361608063,-0.008239046083,-0.009119146443,-0.010000363471,
	-0.010881600602,-0.011762080642,-0.012641253500,-0.013518730575,-0.014394238091,
	-0.015267583916,-0.016138633965,-0.017007295420,-0.017873504801,-0.018737219479,
	-0.019598411646,-0.020457064022,-0.021313166808,-0.022166715517,-0.023017709432,
	-0.023866150510,-0.024712042600,-0.025555390895,-0.026396201532,-0.027234481315,
	-0.028070237515,-0.028903477730,-0.029734209780,-0.030562441643,-0.031388181397,
	-0.032211437187,-0.033032217200,-0.033850529644,-0.034666382740,-0.035479784705,
	-0.036290743755,-0.037099268091,-0.037905365903,-0.038709045363,-0.039510314626,
	-0.040309181827,-0.041105655082,-0.041899742486,-0.042691452113,-0.043480792016,
	-0.044267770226,-0.045052394752,-0.045834673582,-0.046614614683,-0.047392225999,
	-0.048167515451,-0.048940490942,-0.049711160349,-0.050479531530,-0.051245612318,
	-0.052009410528,-0.052770933951,-0.053530190355,-0.054287187490,-0.055041933080,
	-0.055794434829,-0.056544700420,-0.057292737514,-0.058038553748,-0.058782156741,
	-0.059523554087,-0.060262753361,-0.060999762114,-0.061734587878,-0.062467238160,
	-0.063197720448,-0.063926042208,-0.064652210885,-0.065376233900,-0.066098118655,
	-0.066817872531,-0.067535502884,-0.068251017053,-0.068964422353,-0.069675726078,
	-0.070384935501,-0.071092057873,-0.071797100425,-0.072500070366,-0.073200974884,
	-0.073899821146,-0.074596616296,-0.075291367460,-0.075984081741,-0.076674766221,
	-0.077363427961,-0.078050074001,-0.078734711361,-0.079417347038,-0.080097988011,
	-0.080776641235,-0.081453313646,-0.082128012159,-0.082800743668,-0.083471515045,
	-0.084140333145,-0.084807204797,-0.085472136814,-0.086135135986,-0.086796209083,
	-0.087455362853,-0.088112604027,-0.088767939312,-0.089421375396,-0.090072918947,
	-0.090722576612,-0.091370355017,-0.092016260769,-0.092660300453,-0.093302480637,
	-0.093942807865,-0.094581288664,-0.095217929537,-0.095852736972,-0.096485717432,
	-0.097116877363,-0.097746223191,-0.098373761320,-0.098999498136,-0.099623440005,
	-0.100245593272,-0.100865964263,-0.101484559283,-0.102101384620,-0.102716446541,
	-0.103329751291,-0.103941305099,-0.104551114172,-0.105159184700,-0.105765522850,
	-0.106370134772,-0.106973026597,-0.107574204435,-0.108173674376,-0.108771442494,
	-0.109367514842,-0.109961897452,-0.110554596339,-0.111145617499,-0.111734966907,
	-0.112322650522,-0.112908674280,-0.113493044103,-0.114075765888,-0.114656845520,
	-0.115236288859,-0.115814101749,-0.116390290016,-0.116964859467,-0.117537815888,
	-0.118109165049,-0.118678912700,-0.119247064574,-0.119813626383,-0.120378603823,
	-0.120942002570,-0.121503828283,-0.122064086601,-0.122622783146,-0.123179923520,
	-0.123735513310,-0.124289558083,-0.124842063386,-0.125393034752,-0.125942477691,
	-0.126490397700,-0.127036800256,-0.127581690816,-0.128125074822,-0.128666957697,
	-0.129207344847,-0.129746241659,-0.130283653504,-0.130819585733,-0.131354043682,
	-0.131887032667,-0.132418557989,-0.132948624929,-0.133477238753,-0.134004404708,
	-0.134530128023,-0.135054413912,-0.135577267570,-0.136098694176,-0.136618698890,
	-0.137137286857,-0.137654463203,-0.138170233038,-0.138684601456,-0.139197573532,
	-0.139709154326,-0.140219348879,-0.140728162217,-0.141235599348,-0.141741665265,
	-0.142246364942,-0.142749703338,-0.143251685395,-0.143752316038,-0.144251600177,
	-0.144749542703,-0.145246148493,-0.145741422406,-0.146235369285,-0.146727993958,
	-0.147219301235,-0.147709295910,-0.148197982763,-0.148685366554,-0.149171452031,
	-0.149656243923,-0.150139746945,-0.150621965795,-0.151102905155,-0.151582569691,
	-0.152060964054,-0.152538092879,-0.153013960785,-0.153488572375,-0.153961932238,
	-0.154434044945,-0.154904915053,-0.155374547103,-0.155842945622,-0.156310115118,
	-0.156776060087,-0.157240785008,-0.157704294347,-0.158166592550,-0.158627684053,
	-0.159087573275,-0.159546264617,-0.160003762470,-0.160460071205,-0.160915195182,
	-0.161369138745,-0.161821906220,-0.162273501923,-0.162723930152,-0.163173195190,
	-0.163621301308,-0.164068252760,-0.164514053786,-0.164958708611,-0.165402221446,
	-0.165844596487,-0.166285837916,-0.166725949901,-0.167164936593,-0.167602802133,
	-0.168039550643,-0.168475186235,-0.168909713004,-0.169343135030,-0.169775456383,
	-0.170206681115,-0.170636813266,-0.171065856860,-0.171493815909,-0.171920694410,
	-0.172346496347,-0.172771225689,-0.173194886392,-0.173617482398,-0.174039017635,
	-0.174459496019,-0.174878921449,-0.175297297813,-0.175714628984,-0.176130918824,
	-0.176546171179,-0.176960389882,-0.177373578752,-0.177785741598,-0.178196882211,
	-0.178607004371,-0.179016111846,-0.179424208389,-0.179831297739,-0.180237383626,
	-0.180642469761,-0.181046559848,-0.181449657573,-0.181851766612,-0.182252890627,
	-0.182653033267,-0.183052198169,-0.183450388957,-0.183847609242,-0.184243862621,
	-0.184639152680,-0.185033482993,-0.185426857120,-0.185819278607,-0.186210750992,
	-0.186601277795,-0.186990862528,-0.187379508688,-0.187767219761,-0.188153999221,
	-0.188539850527,-0.188924777129,-0.189308782463,-0.189691869954,-0.190074043013,
	-0.190455305040,-0.190835659424,-0.191215109540,-0.191593658753,-0.191971310414,
	-0.192348067863,-0.192723934430,-0.193098913429,-0.193473008166,-0.193846221934,
	-0.194218558014,-0.194590019675,-0.194960610175,-0.195330332760,-0.195699190666,
	-0.196067187114,-0.196434325317,-0.196800608475,-0.197166039776,-0.197530622399,
	-0.197894359508,-0.198257254259,-0.198619309795,-0.198980529248,-0.199340915740,
	-0.199700472380,-0.200059202266,-0.200417108487,-0.200774194119,-0.201130462227,
	-0.201485915866,-0.201840558079,-0.202194391900,-0.202547420350,-0.202899646440,
	-0.203251073170,-0.203601703529,-0.203951540497,-0.204300587041,-0.204648846118,
	-0.204996320675,-0.205343013648,-0.205688927962,-0.206034066533,-0.206378432265,
	-0.206722028051,-0.207064856777,-0.207406921314,-0.207748224525,-0.208088769264,
	-0.208428558372,-0.208767594681,-0.209105881013,-0.209443420180,-0.209780214983,
	-0.210116268213,-0.210451582652,-0.210786161071,-0.211120006231,-0.211453120883,
	-0.211785507768,-0.212117169618,-0.212448109154,-0.212778329088,-0.213107832121,
	-0.213436620946,-0.213764698245,-0.214092066690,-0.214418728944,-0.214744687660,
	-0.215069945482,-0.215394505044,-0.215718368970,-0.216041539875,-0.216364020365,
	-0.216685813035,-0.217006920472,-0.217327345254,-0.217647089947,-0.217966157110,
	-0.218284549292,-0.218602269034,-0.218919318866,-0.219235701308,-0.219551418875,
	-0.219866474067,-0.220180869380,-0.220494607298,-0.220807690298,-0.221120120845,
	-0.221431901398,-0.221743034406,-0.222053522308,-0.222363367536,-0.222672572512,
	-0.222981139648,-0.223289071350,-0.223596370013,-0.223903038025,-0.224209077763,
	-0.224514491597,-0.224819281888,-0.225123450989,-0.225427001242,-0.225729934983,
	-0.226032254539,-0.226333962228,-0.226635060359,-0.226935551233,-0.227235437143,
	-0.227534720374,-0.227833403201,-0.228131487893,-0.228428976707,-0.228725871896,
	-0.229022175701,-0.229317890359,-0.229613018094,-0.229907561125,-0.230201521662,
	-0.230494901908,-0.230787704055,-0.231079930290,-0.231371582791,-0.231662663727,
	-0.231953175260,-0.232243119543,-0.232532498724,-0.232821314939,-0.233109570320,
	-0.233397266988,-0.233684407058,-0.233970992637,-0.234257025824,-0.234542508710,
	-0.234827443378,-0.235111831906,-0.235395676360,-0.235678978802,-0.235961741284,
	-0.236243965853,-0.236525654546,-0.236806809393,-0.237087432418,-0.237367525637,
	-0.237647091057,-0.237926130678,-0.238204646495,-0.238482640493,-0.238760114651,
	-0.239037070940,-0.239313511324,-0.239589437760,-0.239864852198,-0.240139756579,
	-0.240414152839,-0.240688042907,-0.240961428702,-0.241234312139,-0.241506695125,
	-0.241778579559,-0.242049967333,-0.242320860334,-0.242591260440,-0.242861169523,
	-0.243130589448,-0.243399522072,-0.243667969247,-0.243935932816,-0.244203414617,
	-0.244470416481,-0.244736940231,-0.245002987684,-0.245268560650,-0.245533660934,
	-0.245798290331,-0.246062450633,-0.246326143622,-0.246589371075,-0.246852134763,
	-0.247114436450,-0.247376277893,-0.247637660842,-0.247898587042,-0.248159058231,
	-0.248419076139,-0.248678642491,-0.248937759007,-0.249196427397,-0.249454649369,
	-0.249712426620,-0.249969760845,-0.250226653729,-0.250483106954,-0.250739122193,
	-0.250994701115,-0.251249845381,-0.251504556647,-0.251758836563,-0.252012686771,
	-0.252266108909,-0.252519104608,-0.252771675492,-0.253023823182,-0.253275549290,
	-0.253526855423,-0.253777743181,-0.254028214160,-0.254278269950,-0.254527912131,
	-0.254777142284,-0.255025961977,-0.255274372778,-0.255522376245,-0.255769973933,
	-0.256017167389,-0.256263958156,-0.256510347770,-0.256756337762,-0.257001929657,
	-0.257247124975,-0.257491925229,-0.257736331926,-0.257980346571,-0.258223970659,
	-0.258467205681,-0.258710053123,-0.258952514466,-0.259194591183,-0.259436284745,
	-0.259677596614,-0.259918528248,-0.260159081100,-0.260399256618,-0.260639056243,
	-0.260878481411,-0.261117533554,-0.261356214097,-0.261594524460,-0.261832466059,
	-0.262070040303,-0.262307248597,-0.262544092340,-0.262780572925,-0.263016691743,
	-0.263252450175,-0.263487849600,-0.263722891393,-0.263957576920,-0.264191907544,
	-0.264425884624,-0.264659509512,-0.264892783555,-0.265125708097,-0.265358284475,
	-0.265590514021,-0.265822398064,-0.266053937924,-0.266285134921,-0.266515990367,
	-0.266746505569,-0.266976681831,-0.267206520450,-0.267436022720,-0.267665189928,
	-0.267894023358,-0.268122524288,-0.268350693993,-0.268578533742,-0.268806044798,
	-0.269033228421,-0.269260085865,-0.269486618382,-0.269712827216,-0.269938713607,
	-0.270164278792,-0.270389524002,-0.270614450464,-0.270839059400,-0.271063352027,
	-0.271287329558,-0.271510993202,-0.271734344163,-0.271957383639,-0.272180112826,
	-0.272402532913,-0.272624645088,-0.272846450530,-0.273067950417,-0.273289145921,
	-0.273510038211,-0.273730628449,-0.273950917796,-0.274170907406,-0.274390598430,
	-0.274609992014,-0.274829089299,-0.275047891424,-0.275266399522,-0.275484614722,
	-0.275702538148,-0.275920170921,-0.276137514158,-0.276354568970,-0.276571336466,
	-0.276787817749,-0.277004013919,-0.277219926072,-0.277435555298,-0.277650902684,
	-0.277865969315,-0.278080756268,-0.278295264619,-0.278509495439,-0.278723449794,
	-0.278937128748,-0.279150533359,-0.279363664682,-0.279576523767,-0.279789111662,
	-0.280001429409,-0.280213478048,-0.280425258614,-0.280636772136,-0.280848019644,
	-0.281059002160,-0.281269720703,-0.281480176290,-0.281690369932,-0.281900302637,
	-0.282109975408,-0.282319389248,-0.282528545151,-0.282737444112,-0.282946087118,
	-0.283154475156,-0.283362609206,-0.283570490247,-0.283778119253,-0.283985497195,
	-0.284192625039,-0.284399503748,-0.284606134282,-0.284812517596,-0.285018654644,
	-0.285224546374,-0.285430193730,-0.285635597654,-0.285840759085,-0.286045678956,
	-0.286250358199,-0.286454797740,-0.286658998504,-0.286862961410,-0.287066687377,
	-0.287270177316,-0.287473432138,-0.287676452749,-0.287879240052,-0.288081794948,
	-0.288284118331,-0.288486211095,-0.288688074129,-0.288889708320,-0.289091114549,
	-0.289292293696,-0.289493246638,-0.289693974246,-0.289894477390,-0.290094756936,
	-0.290294813747,-0.290494648682,-0.290694262598,-0.290893656348,-0.291092830780,
	-0.291291786743,-0.291490525078,-0.291689046627,-0.291887352225,-0.292085442708,
	-0.292283318904,-0.292480981643,-0.292678431747,-0.292875670038,-0.293072697335,
	-0.293269514451,-0.293466122200,-0.293662521389,-0.293858712824,-0.294054697308,
	-0.294250475640,-0.294446048618,-0.294641417033,-0.294836581677,-0.295031543338,
	-0.295226302799,-0.295420860842,-0.295615218247,-0.295809375787,-0.296003334236,
	-0.296197094363,-0.296390656936,-0.296584022718,-0.296777192470,-0.296970166949,
	-0.297162946912,-0.297355533110,-0.297547926293,-0.297740127207,-0.297932136595,
	-0.298123955200,-0.298315583759,-0.298507023006,-0.298698273675,-0.298889336495,
	-0.299080212194,-0.299270901494,-0.299461405118,-0.299651723784,-0.299841858208,
	-0.300031809103,-0.300221577179,-0.300411163145,-0.300600567704,-0.300789791560,
	-0.300978835413,-0.301167699958,-0.301356385891,-0.301544893903,-0.301733224683,
	-0.301921378918,-0.302109357291,-0.302297160484,-0.302484789175,-0.302672244040,
	-0.302859525752,-0.303046634983,-0.303233572400,-0.303420338670,-0.303606934456,
	-0.303793360418,-0.303979617215,-0.304165705501,-0.304351625931,-0.304537379155,
	-0.304722965820,-0.304908386574,-0.305093642058,-0.305278732914,-0.305463659781,
	-0.305648423293,-0.305833024084,-0.306017462786,-0.306201740027,-0.306385856433,
	-0.306569812629,-0.306753609234,-0.306937246870,-0.307120726152,-0.307304047694,
	-0.307487212109,-0.307670220006,-0.307853071993,-0.308035768675,-0.308218310654,
	-0.308400698531,-0.308582932903,-0.308765014368,-0.308946943517,-0.309128720943,
	-0.309310347234,-0.309491822978,-0.309673148758,-0.309854325157,-0.310035352755,
	-0.310216232130,-0.310396963858,-0.310577548511,-0.310757986662,-0.310938278878,
	-0.311118425727,-0.311298427774,-0.311478285581,-0.311657999709,-0.311837570715,
	-0.312016999156,-0.312196285586,-0.312375430556,-0.312554434617,-0.312733298316,
	-0.312912022198,-0.313090606806,-0.313269052683,-0.313447360367,-0.313625530396,
	-0.313803563305,-0.313981459627,-0.314159219892,-0.314336844630,-0.314514334369,
	-0.314691689632,-0.314868910943,-0.315045998823,-0.315222953790,-0.315399776362,
	-0.315576467054,-0.315753026378,-0.315929454846,-0.316105752967,-0.316281921248,
	-0.316457960194,-0.316633870308,-0.316809652091,-0.316985306044,-0.317160832663,
	-0.317336232444,-0.317511505881,-0.317686653465,-0.317861675687,-0.318036573033,
	-0.318211345991,-0.318385995045,-0.318560520677,-0.318734923367,-0.318909203595,
	-0.319083361837,-0.319257398568,-0.319431314261,-0.319605109388,-0.319778784419,
	-0.319952339820,-0.320125776059,-0.320299093599,-0.320472292902,-0.320645374430,
	-0.320818338640,-0.320991185991,-0.321163916938,-0.321336531933,-0.321509031429,
	-0.321681415877,-0.321853685723,-0.322025841416,-0.322197883400,-0.322369812117,
	-0.322541628011,-0.322713331520,-0.322884923082,-0.323056403134,-0.323227772111,
	-0.323399030446,-0.323570178570,-0.323741216913,-0.323912145903,-0.324082965967,
	-0.324253677529,-0.324424281013,-0.324594776839,-0.324765165428,-0.324935447199,
	-0.325105622568,-0.325275691949,-0.325445655758,-0.325615514404,-0.325785268299,
	-0.325954917852,-0.326124463469,-0.326293905557,-0.326463244519,-0.326632480757,
	-0.326801614673,-0.326970646666,-0.327139577133,-0.327308406472,-0.327477135076,
	-0.327645763340,-0.327814291654,-0.327982720410,-0.328151049995,-0.328319280797,
	-0.328487413201,-0.328655447593,-0.328823384354,-0.328991223866,-0.329158966509,
	-0.329326612660,-0.329494162698,-0.329661616997,-0.329828975931,-0.329996239874,
	-0.330163409195,-0.330330484264,-0.330497465451,-0.330664353121,-0.330831147640,
	-0.330997849372,-0.331164458680,-0.331330975924,-0.331497401465,-0.331663735661,
	-0.331829978869,-0.331996131444,-0.332162193741,-0.332328166113,-0.332494048911,
	-0.332659842486,-0.332825547185,-0.332991163357,-0.333156691348,-0.333322131503,
	-0.333487484164,-0.333652749675,-0.333817928375,-0.333983020605,-0.334148026702,
	-0.334312947004,-0.334477781846,-0.334642531561,-0.334807196484,-0.334971776946,
	-0.335136273277,-0.335300685806,-0.335465014861,-0.335629260770,-0.335793423856,
	-0.335957504444,-0.336121502857,-0.336285419416,-0.336449254442,-0.336613008254,
	-0.336776681169,-0.336940273505,-0.337103785576,-0.337267217696,-0.337430570179,
	-0.337593843337,-0.337757037479,-0.337920152915,-0.338083189954,-0.338246148901,
	-0.338409030063,-0.338571833745,-0.338734560249,-0.338897209878,-0.339059782933,
	-0.339222279714,-0.339384700519,-0.339547045646,-0.339709315391,-0.339871510049,
	-0.340033629915,-0.340195675282,-0.340357646440,-0.340519543682,-0.340681367296,
	-0.340843117570,-0.341004794793,-0.341166399250,-0.341327931226,-0.341489391005,
	-0.341650778871,-0.341812095104,-0.341973339986,-0.342134513796,-0.342295616813,
	-0.342456649313,-0.342617611574,-0.342778503870,-0.342939326476,-0.343100079664,
	-0.343260763708,-0.343421378877,-0.343581925442,-0.343742403671,-0.343902813834,
	-0.344063156195,-0.344223431021,-0.344383638578,-0.344543779127,-0.344703852933,
	-0.344863860257,-0.345023801359,-0.345183676499,-0.345343485936,-0.345503229927,
	-0.345662908729,-0.345822522598,-0.345982071787,-0.346141556552,-0.346300977143,
	-0.346460333814,-0.346619626814,-0.346778856394,-0.346938022801,-0.347097126285,
	-0.347256167091,-0.347415145465,-0.347574061653,-0.347732915897,-0.347891708442,
	-0.348050439529,-0.348209109399,-0.348367718293,-0.348526266449,-0.348684754106,
	-0.348843181501,-0.349001548870,-0.349159856450,-0.349318104474,-0.349476293176,
	-0.349634422789,-0.349792493545,-0.349950505674,-0.350108459408,-0.350266354974,
	-0.350424192601,-0.350581972516,-0.350739694947,-0.350897360117,-0.351054968253,
	-0.351212519578,-0.351370014315,-0.351527452685,-0.351684834911,-0.351842161212,
	-0.351999431808,-0.352156646917,-0.352313806758,-0.352470911547,-0.352627961500,
	-0.352784956833,-0.352941897759,-0.353098784493,-0.353255617247,-0.353412396233,
	-0.353569121662,-0.353725793744,-0.353882412688,-0.354038978704,-0.354195491998,
	-0.354351952778,-0.354508361251,-0.354664717620,-0.354821022092,-0.354977274869,
	-0.355133476154,-0.355289626150,-0.355445725058,-0.355601773078,-0.355757770410,
	-0.355913717254,-0.356069613807,-0.356225460267,-0.356381256830,-0.356537003693,
	-0.356692701050,-0.356848349096,-0.357003948024,-0.357159498028,-0.357314999298,
	-0.357470452027,-0.357625856406,-0.357781212623,-0.357936520868,-0.358091781330,
	-0.358246994196,-0.358402159652,-0.358557277885,-0.358712349081,-0.358867373423,
	-0.359022351096,-0.359177282284,-0.359332167168,-0.359487005930,-0.359641798752,
	-0.359796545813,-0.359951247294,-0.360105903373,-0.360260514229,-0.360415080039,
	-0.360569600980,-0.360724077228,-0.360878508958,-0.361032896345,-0.361187239564,
	-0.361341538788,-0.361495794189,-0.361650005939,-0.361804174210,-0.361958299173,
	-0.362112380997,-0.362266419851,-0.362420415906,-0.362574369327,-0.362728280283,
	-0.362882148941,-0.363035975466,-0.363189760023,-0.363343502779,-0.363497203896,
	-0.363650863537,-0.363804481867,-0.363958059046,-0.364111595237,-0.364265090600,
	-0.364418545295,-0.364571959482,-0.364725333320,-0.364878666968,-0.365031960582,
	-0.365185214321,-0.365338428340,-0.365491602795,-0.365644737842,-0.365797833636,
	-0.365950890329,-0.366103908076,-0.366256887029,-0.366409827341,-0.366562729164,
	-0.366715592647,-0.366868417942,-0.367021205198,-0.367173954564,-0.367326666190,
	-0.367479340223,-0.367631976811,-0.367784576100,-0.367937138236,-0.368089663366,
	-0.368242151635,-0.368394603187,-0.368547018165,-0.368699396714,-0.368851738977,
	-0.369004045095,-0.369156315210,-0.369308549463,-0.369460747995,-0.369612910947,
	-0.369765038457,-0.369917130664,-0.370069187707,-0.370221209723,-0.370373196850,
	-0.370525149225,-0.370677066983,-0.370828950261,-0.370980799193,-0.371132613914,
	-0.371284394558,-0.371436141259,-0.371587854149,-0.371739533361,-0.371891179027,
	-0.372042791278,-0.372194370246,-0.372345916059,-0.372497428850,-0.372648908745,
	-0.372800355875,-0.372951770368,-0.373103152351,-0.373254501952,-0.373405819298,
	-0.373557104514,-0.373708357727,-0.373859579061,-0.374010768642,-0.374161926594,
	-0.374313053040,-0.374464148104,-0.374615211909,-0.374766244576,-0.374917246229,
	-0.375068216987,-0.375219156972,-0.375370066304,-0.375520945103,-0.375671793489,
	-0.375822611580,-0.375973399495,-0.376124157351,-0.376274885267,-0.376425583359,
	-0.376576251744,-0.376726890538,-0.376877499856,-0.377028079814,-0.377178630527,
	-0.377329152108,-0.377479644672,-0.377630108331,-0.377780543199,-0.377930949389,
	-0.378081327011,-0.378231676178,-0.378381997001,-0.378532289591,-0.378682554057,
	-0.378832790509,-0.378982999057,-0.379133179809,-0.379283332875,-0.379433458361,
	-0.379583556377,-0.379733627027,-0.379883670421,-0.380033686663,-0.380183675859,
	-0.380333638116,-0.380483573538,-0.380633482229,-0.380783364295,-0.380933219838,
	-0.381083048961,-0.381232851769,-0.381382628363,-0.381532378845,-0.381682103318,
	-0.381831801882,-0.381981474638,-0.382131121687,-0.382280743129,-0.382430339064,
	-0.382579909590,-0.382729454806,-0.382878974812,-0.383028469705,-0.383177939583,
	-0.383327384542,-0.383476804681,-0.383626200095,-0.383775570881,-0.383924917134,
	-0.384074238949,-0.384223536422,-0.384372809647,-0.384522058719,-0.384671283730,
	-0.384820484775,-0.384969661947,-0.385118815338,-0.385267945040,-0.385417051146,
	-0.385566133747,-0.385715192933,-0.385864228797,-0.386013241429,-0.386162230917,
	-0.386311197354,-0.386460140826,-0.386609061424,-0.386757959237,-0.386906834352,
	-0.387055686857,-0.387204516840,-0.387353324388,-0.387502109588,-0.387650872527,
	-0.387799613290,-0.387948331964,-0.388097028634,-0.388245703384,-0.388394356301,
	-0.388542987467,-0.388691596968,-0.388840184886,-0.388988751306,-0.389137296311,
	-0.389285819982,-0.389434322403,-0.389582803655,-0.389731263820,-0.389879702980,
	-0.390028121216,-0.390176518608,-0.390324895237,-0.390473251182,-0.390621586524,
	-0.390769901342,-0.390918195715,-0.391066469721,-0.391214723440,-0.391362956949,
	-0.391511170326,-0.391659363648,-0.391807536994,-0.391955690439,-0.392103824060,
	-0.392251937933,-0.392400032135,-0.392548106740,-0.392696161825,-0.392844197463,
	-0.392992213731,-0.393140210702,-0.393288188450,-0.393436147049,-0.393584086572,
	-0.393732007093,-0.393879908685,-0.394027791419,-0.394175655369,-0.394323500606,
	-0.394471327202,-0.394619135229,-0.394766924757,-0.394914695857,-0.395062448600,
	-0.395210183056,-0.395357899294,-0.395505597385,-0.395653277398,-0.395800939402,
	-0.395948583466,-0.396096209658,-0.396243818046,-0.396391408698,-0.396538981683,
	-0.396686537067,-0.396834074917,-0.396981595301,-0.397129098284,-0.397276583934,
	-0.397424052316,-0.397571503496,-0.397718937539,-0.397866354510,-0.398013754475,
	-0.398161137498,-0.398308503643,-0.398455852975,-0.398603185557,-0.398750501454,
	-0.398897800727,-0.399045083441,-0.399192349658,-0.399339599441,-0.399486832852,
	-0.399634049952,-0.399781250805,-0.399928435471,-0.400075604011,-0.400222756487,
	-0.400369892959,-0.400517013488,-0.400664118133,-0.400811206956,-0.400958280016,
	-0.401105337371,-0.401252379083,-0.401399405208,-0.401546415807,-0.401693410938,
	-0.401840390658,-0.401987355027,-0.402134304101,-0.402281237939,-0.402428156597,
	-0.402575060133,-0.402721948603,-0.402868822064,-0.403015680573,-0.403162524186,
	-0.403309352958,-0.403456166944,-0.403602966202,-0.403749750785,-0.403896520748,
	-0.404043276147,-0.404190017036,-0.404336743468,-0.404483455499,-0.404630153181,
	-0.404776836569,-0.404923505716,-0.405070160675,-0.405216801499,-0.405363428240,
	-0.405510040951,-0.405656639684,-0.405803224492,-0.405949795426,-0.406096352537,
	-0.406242895877,-0.406389425498,-0.406535941450,-0.406682443783,-0.406828932549,
	-0.406975407797,-0.407121869578,-0.407268317942,-0.407414752938,-0.407561174615,
	-0.407707583023,-0.407853978212,-0.408000360229,-0.408146729123,-0.408293084944,
	-0.408439427738,-0.408585757554,-0.408732074440,-0.408878378444,-0.409024669612,
	-0.409170947992,-0.409317213631,-0.409463466576,-0.409609706873,-0.409755934569,
	-0.409902149710,-0.410048352342,-0.410194542511,-0.410340720261,-0.410486885640,
	-0.410633038692,-0.410779179461,-0.410925307994,-0.411071424334,-0.411217528525,
	-0.411363620613,-0.411509700642,-0.411655768654,-0.411801824694,-0.411947868806,
	-0.412093901032,-0.412239921416,-0.412385930001,-0.412531926830,-0.412677911944,
	-0.412823885387,-0.412969847201,-0.413115797427,-0.413261736108,-0.413407663286,
	-0.413553579001,-0.413699483295,-0.413845376210,-0.413991257786,-0.414137128063,
	-0.414282987084,-0.414428834887,-0.414574671514,-0.414720497004,-0.414866311397,
	-0.415012114734,-0.415157907053,-0.415303688394,-0.415449458796,-0.415595218298,
	-0.415740966940,-0.415886704760,-0.416032431795,-0.416178148086,-0.416323853670,
	-0.416469548585,-0.416615232869,-0.416760906559,-0.416906569694,-0.417052222310,
	-0.417197864445,-0.417343496136,-0.417489117420,-0.417634728333,-0.417780328913,
	-0.417925919195,-0.418071499215,-0.418217069011,-0.418362628617,-0.418508178071,
	-0.418653717406,-0.418799246659,-0.418944765865,-0.419090275060,-0.419235774277,
	-0.419381263553,-0.419526742921,-0.419672212417,-0.419817672074,-0.419963121927,
	-0.420108562011,-0.420253992358,-0.420399413003,-0.420544823980,-0.420690225321,
	-0.420835617061,-0.420980999232,-0.421126371868,-0.421271735001,-0.421417088664,
	-0.421562432890,-0.421707767711,-0.421853093160,-0.421998409268,-0.422143716069,
	-0.422289013592,-0.422434301872,-0.422579580938,-0.422724850823,-0.422870111558,
	-0.423015363174,-0.423160605701,-0.423305839172,-0.423451063617,-0.423596279065,
	-0.423741485549,-0.423886683098,-0.424031871743,-0.424177051513,-0.424322222438,
	-0.424467384549,-0.424612537875,-0.424757682445,-0.424902818289,-0.425047945437,
	-0.425193063917,-0.425338173758,-0.425483274990,-0.425628367641,-0.425773451739,
	-0.425918527314,-0.426063594393,-0.426208653005,-0.426353703178,-0.426498744940,
	-0.426643778319,-0.426788803342,-0.426933820037,-0.427078828432,-0.427223828554,
	-0.427368820430,-0.427513804087,-0.427658779553,-0.427803746853,-0.427948706016,
	-0.428093657067,-0.428238600032,-0.428383534940,-0.428528461814,-0.428673380683,
	-0.428818291571,-0.428963194504,-0.429108089509,-0.429252976611,-0.429397855836,
	-0.429542727209,-0.429687590754,-0.429832446498,-0.429977294466,-0.430122134682,
	-0.430266967172,-0.430411791959,-0.430556609069,-0.430701418526,-0.430846220354,
	-0.430991014578,-0.431135801222,-0.431280580310,-0.431425351866,-0.431570115913,
	-0.431714872476,-0.431859621577,-0.432004363241,-0.432149097491,-0.432293824349,
	-0.432438543840,-0.432583255986,-0.432727960810,-0.432872658335,-0.433017348584,
	-0.433162031579,-0.433306707343,-0.433451375898,-0.433596037266,-0.433740691470,
	-0.433885338532,-0.434029978474,-0.434174611317,-0.434319237083,-0.434463855795,
	-0.434608467473,-0.434753072139,-0.434897669814,-0.435042260520,-0.435186844278,
	-0.435331421109,-0.435475991033,-0.435620554072,-0.435765110247,-0.435909659577,
	-0.436054202084,-0.436198737788,-0.436343266710,-0.436487788869,-0.436632304286,
	-0.436776812981,-0.436921314974,-0.437065810284,-0.437210298932,-0.437354780937,
	-0.437499256319,-0.437643725097,-0.437788187290,-0.437932642918,-0.438077092001,
	-0.438221534557,-0.438365970605,-0.438510400164,-0.438654823253,-0.438799239890,
	-0.438943650095,-0.439088053886,-0.439232451281,-0.439376842299,-0.439521226958,
	-0.439665605277,-0.439809977272,-0.439954342963,-0.440098702367,-0.440243055502,
	-0.440387402386,-0.440531743036,-0.440676077470,-0.440820405706,-0.440964727761,
	-0.441109043652,-0.441253353396,-0.441397657011,-0.441541954513,-0.441686245920,
	-0.441830531249,-0.441974810515,-0.442119083737,-0.442263350930,-0.442407612111,
	-0.442551867297,-0.442696116503,-0.442840359747,-0.442984597045,-0.443128828411,
	-0.443273053864,-0.443417273418,-0.443561487089,-0.443705694894,-0.443849896847,
	-0.443994092965,-0.444138283263,-0.444282467757,-0.444426646462,-0.444570819393,
	-0.444714986566,-0.444859147995,-0.445003303696,-0.445147453684,-0.445291597974,
	-0.445435736580,-0.445579869518,-0.445723996802,-0.445868118446,-0.446012234465,
	-0.446156344875,-0.446300449688,-0.446444548919,-0.446588642584,-0.446732730695,
	-0.446876813267,-0.447020890313,-0.447164961849,-0.447309027887,-0.447453088442,
	-0.447597143527,-0.447741193155,-0.447885237342,-0.448029276099,-0.448173309440,
	-0.448317337379,-0.448461359930,-0.448605377104,-0.448749388916,-0.448893395378,
	-0.449037396504,-0.449181392306,-0.449325382797,-0.449469367990,-0.449613347898,
	-0.449757322534,-0.449901291910,-0.450045256038,-0.450189214931,-0.450333168601,
	-0.450477117061,-0.450621060323,-0.450764998399,-0.450908931302,-0.451052859042,
	-0.451196781633,-0.451340699086,-0.451484611413,-0.451628518626,-0.451772420736,
	-0.451916317755,-0.452060209695,-0.452204096568,-0.452347978384,-0.452491855155,
	-0.452635726892,-0.452779593608,-0.452923455312,-0.453067312016,-0.453211163731,
	-0.453355010469,-0.453498852239,-0.453642689054,-0.453786520923,-0.453930347857,
	-0.454074169868,-0.454217986966,-0.454361799161,-0.454505606465,-0.454649408886,
	-0.454793206436,-0.454936999126,-0.455080786965,-0.455224569964,-0.455368348132,
	-0.455512121480,-0.455655890018,-0.455799653756,-0.455943412704,-0.456087166872,
	-0.456230916269,-0.456374660905,-0.456518400790,-0.456662135934,-0.456805866346,
	-0.456949592035,-0.457093313012,-0.457237029285,-0.457380740864,-0.457524447758,
	-0.457668149976,-0.457811847528,-0.457955540422,-0.458099228669,-0.458242912275,
	-0.458386591252,-0.458530265607,-0.458673935350,-0.458817600488,-0.458961261032,
	-0.459104916989,-0.459248568369,-0.459392215179,-0.459535857429,-0.459679495126,
	-0.459823128280,-0.459966756898,-0.460110380989,-0.460254000561,-0.460397615623,
	-0.460541226182,-0.460684832247,-0.460828433825,-0.460972030925,-0.461115623555,
	-0.461259211722,-0.461402795435,-0.461546374700,-0.461689949527,-0.461833519922,
	-0.461977085893,-0.462120647448,-0.462264204594,-0.462407757340,-0.462551305691,
	-0.462694849656,-0.462838389243,-0.462981924457,-0.463125455307,-0.463268981800,
	-0.463412503943,-0.463556021743,-0.463699535207,-0.463843044342,-0.463986549155,
	-0.464130049653,-0.464273545843,-0.464417037731,-0.464560525325,-0.464704008631,
	-0.464847487656,-0.464990962407,-0.465134432889,-0.465277899110,-0.465421361076,
	-0.465564818794,-0.465708272269,-0.465851721509,-0.465995166520,-0.466138607307,
	-0.466282043878,-0.466425476238,-0.466568904393,-0.466712328349,-0.466855748114,
	-0.466999163692,-0.467142575089,-0.467285982312,-0.467429385366,-0.467572784257,
	-0.467716178991,-0.467859569574,-0.468002956011,-0.468146338309,-0.468289716471,
	-0.468433090506,-0.468576460416,-0.468719826210,-0.468863187890,-0.469006545464,
	-0.469149898936,-0.469293248313,-0.469436593598,-0.469579934797,-0.469723271916,
	-0.469866604960,-0.470009933933,-0.470153258841,-0.470296579689,-0.470439896482,
	-0.470583209225,-0.470726517923,-0.470869822580,-0.471013123202,-0.471156419793,
	-0.471299712358,-0.471443000901,-0.471586285429,-0.471729565944,-0.471872842452,
	-0.472016114957,-0.472159383464,-0.472302647977,-0.472445908501,-0.472589165040,
	-0.472732417599,-0.472875666181,-0.473018910792,-0.473162151435,-0.473305388115,
	-0.473448620835,-0.473591849601,-0.473735074415,-0.473878295283,-0.474021512208,
	-0.474164725194,-0.474307934245,-0.474451139366,-0.474594340559,-0.474737537829,
	-0.474880731180,-0.475023920616,-0.475167106139,-0.475310287755,-0.475453465466,
	-0.475596639277,-0.475739809191,-0.475882975211,-0.476026137341,-0.476169295584,
	-0.476312449945,-0.476455600426,-0.476598747031,-0.476741889763,-0.476885028626,
	-0.477028163622,-0.477171294756,-0.477314422030,-0.477457545448,-0.477600665012,
	-0.477743780727,-0.477886892594,-0.478030000618,-0.478173104800,-0.478316205145,
	-0.478459301655,-0.478602394333,-0.478745483181,-0.478888568204,-0.479031649403,
	-0.479174726782,-0.479317800343,-0.479460870089,-0.479603936023,-0.479746998147,
	-0.479890056465,-0.480033110978,-0.480176161689,-0.480319208601,-0.480462251717,
	-0.480605291038,-0.480748326568,-0.480891358308,-0.481034386262,-0.481177410432,
	-0.481320430819,-0.481463447427,-0.481606460257,-0.481749469312,-0.481892474593,
	-0.482035476105,-0.482178473847,-0.482321467823,-0.482464458035,-0.482607444484,
	-0.482750427174,-0.482893406105,-0.483036381279,-0.483179352700,-0.483322320368,
	-0.483465284286,-0.483608244455,-0.483751200878,-0.483894153556,-0.484037102491,
	-0.484180047684,-0.484322989138,-0.484465926854,-0.484608860834,-0.484751791080,
	-0.484894717592,-0.485037640374,-0.485180559425,-0.485323474749,-0.485466386346,
	-0.485609294218,-0.485752198366,-0.485895098792,-0.486037995497,-0.486180888482,
	-0.486323777750,-0.486466663301,-0.486609545136,-0.486752423257,-0.486895297666,
	-0.487038168362,-0.487181035349,-0.487323898626,-0.487466758194,-0.487609614056,
	-0.487752466212,-0.487895314663,-0.488038159410,-0.488181000454,-0.488323837797,
	-0.488466671439,-0.488609501381,-0.488752327623,-0.488895150168,-0.489037969016,
	-0.489180784168,-0.489323595623,-0.489466403385,-0.489609207452,-0.489752007826,
	-0.489894804508,-0.490037597498,-0.490180386796,-0.490323172405,-0.490465954323,
	-0.490608732553,-0.490751507094,-0.490894277946,-0.491037045112,-0.491179808590,
	-0.491322568382,-0.491465324488,-0.491608076908,-0.491750825643,-0.491893570693,
	-0.492036312059,-0.492179049741,-0.492321783739,-0.492464514053,-0.492607240685,
	-0.492749963633,-0.492892682899,-0.493035398483,-0.493178110384,-0.493320818603,
	-0.493463523141,-0.493606223996,-0.493748921170,-0.493891614662,-0.494034304473,
	-0.494176990602,-0.494319673050,-0.494462351816,-0.494605026901,-0.494747698304,
	-0.494890366026,-0.495033030066,-0.495175690424,-0.495318347100,-0.495461000094,
	-0.495603649406,-0.495746295035,-0.495888936982,-0.496031575246,-0.496174209826,
	-0.496316840724,-0.496459467937,-0.496602091466,-0.496744711311,-0.496887327472,
	-0.497029939947,-0.497172548736,-0.497315153840,-0.497457755257,-0.497600352988,
	-0.497742947031,-0.497885537386,-0.498028124054,-0.498170707032,-0.498313286321,
	-0.498455861919,-0.498598433828,-0.498741002045
	}
};

double always_inline copicatrecord_2clip(double x) {
    double f = fabs(x);
    f = f * copicatrecord_2_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = copicatrecord_2_table.data[0];
    } else if (i >= copicatrecord_2_table.size-1) {
        f = copicatrecord_2_table.data[copicatrecord_2_table.size-1];
    } else {
    f -= i;
    f = copicatrecord_2_table.data[i]*(1-f) + copicatrecord_2_table.data[i+1]*f;
    }
    return copysign(f, x);
}

