// Automatically generated from the Unicode version 13.0.0 character database.

#![allow(dead_code)]

/// The version of the Unicode Character Database used to generate character properties.
pub const UNICODE_VERSION: (u8, u8, u8) = (13, 0, 0);

/// Unicode general category property.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum Category {
    Other = 0,
    Control = 1,
    Format = 2,
    Unassigned = 3,
    PrivateUse = 4,
    Surrogate = 5,
    Letter = 6,
    CasedLetter = 7,
    LowercaseLetter = 8,
    ModifierLetter = 9,
    OtherLetter = 10,
    TitlecaseLetter = 11,
    UppercaseLetter = 12,
    Mark = 13,
    SpacingMark = 14,
    EnclosingMark = 15,
    NonspacingMark = 16,
    Number = 17,
    DecimalNumber = 18,
    LetterNumber = 19,
    OtherNumber = 20,
    Punctuation = 21,
    ConnectorPunctuation = 22,
    DashPunctuation = 23,
    ClosePunctuation = 24,
    FinalPunctuation = 25,
    InitialPunctuation = 26,
    OtherPunctuation = 27,
    OpenPunctuation = 28,
    Symbol = 29,
    CurrencySymbol = 30,
    ModifierSymbol = 31,
    MathSymbol = 32,
    OtherSymbol = 33,
    Separator = 34,
    LineSeparator = 35,
    ParagraphSeparator = 36,
    SpaceSeparator = 37,
}

/// Unicode block property.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u16)]
pub enum Block {
    Adlam = 0,
    AegeanNumbers = 1,
    Ahom = 2,
    AlchemicalSymbols = 3,
    AlphabeticPresentationForms = 4,
    AnatolianHieroglyphs = 5,
    AncientGreekMusicalNotation = 6,
    AncientGreekNumbers = 7,
    AncientSymbols = 8,
    Arabic = 9,
    ArabicExtendedA = 10,
    ArabicMathematicalAlphabeticSymbols = 11,
    ArabicPresentationFormsA = 12,
    ArabicPresentationFormsB = 13,
    ArabicSupplement = 14,
    Armenian = 15,
    Arrows = 16,
    BasicLatin = 17,
    Avestan = 18,
    Balinese = 19,
    Bamum = 20,
    BamumSupplement = 21,
    BassaVah = 22,
    Batak = 23,
    Bengali = 24,
    Bhaiksuki = 25,
    BlockElements = 26,
    Bopomofo = 27,
    BopomofoExtended = 28,
    BoxDrawing = 29,
    Brahmi = 30,
    BraillePatterns = 31,
    Buginese = 32,
    Buhid = 33,
    ByzantineMusicalSymbols = 34,
    Carian = 35,
    CaucasianAlbanian = 36,
    Chakma = 37,
    Cham = 38,
    Cherokee = 39,
    CherokeeSupplement = 40,
    ChessSymbols = 41,
    Chorasmian = 42,
    CJKUnifiedIdeographs = 43,
    CJKCompatibility = 44,
    CJKCompatibilityForms = 45,
    CJKCompatibilityIdeographs = 46,
    CJKCompatibilityIdeographsSupplement = 47,
    CJKUnifiedIdeographsExtensionA = 48,
    CJKUnifiedIdeographsExtensionB = 49,
    CJKUnifiedIdeographsExtensionC = 50,
    CJKUnifiedIdeographsExtensionD = 51,
    CJKUnifiedIdeographsExtensionE = 52,
    CJKUnifiedIdeographsExtensionF = 53,
    CJKUnifiedIdeographsExtensionG = 54,
    CJKRadicalsSupplement = 55,
    CJKStrokes = 56,
    HangulCompatibilityJamo = 57,
    ControlPictures = 58,
    Coptic = 59,
    CopticEpactNumbers = 60,
    CountingRodNumerals = 61,
    Cuneiform = 62,
    CurrencySymbols = 63,
    CypriotSyllabary = 64,
    Cyrillic = 65,
    CyrillicExtendedA = 66,
    CyrillicExtendedB = 67,
    CyrillicExtendedC = 68,
    CyrillicSupplement = 69,
    Deseret = 70,
    Devanagari = 71,
    DevanagariExtended = 72,
    CombiningDiacriticalMarks = 73,
    CombiningDiacriticalMarksExtended = 74,
    CombiningDiacriticalMarksSupplement = 75,
    Dingbats = 76,
    DivesAkuru = 77,
    Dogra = 78,
    DominoTiles = 79,
    Duployan = 80,
    EarlyDynasticCuneiform = 81,
    EgyptianHieroglyphFormatControls = 82,
    EgyptianHieroglyphs = 83,
    Elbasan = 84,
    Elymaic = 85,
    Emoticons = 86,
    EnclosedAlphanumerics = 87,
    EnclosedAlphanumericSupplement = 88,
    EnclosedIdeographicSupplement = 89,
    Ethiopic = 90,
    EthiopicExtended = 91,
    EthiopicExtendedA = 92,
    EthiopicSupplement = 93,
    GeometricShapes = 94,
    GeometricShapesExtended = 95,
    Georgian = 96,
    GeorgianExtended = 97,
    GeorgianSupplement = 98,
    Glagolitic = 99,
    GlagoliticSupplement = 100,
    Gothic = 101,
    Grantha = 102,
    GreekExtended = 103,
    Gujarati = 104,
    GunjalaGondi = 105,
    Gurmukhi = 106,
    CombiningHalfMarks = 107,
    HangulSyllables = 108,
    HanifiRohingya = 109,
    Hanunoo = 110,
    Hatran = 111,
    Hebrew = 112,
    HighPrivateUseSurrogates = 113,
    HighSurrogates = 114,
    Hiragana = 115,
    IdeographicDescriptionCharacters = 116,
    ImperialAramaic = 117,
    CommonIndicNumberForms = 118,
    IndicSiyaqNumbers = 119,
    InscriptionalPahlavi = 120,
    InscriptionalParthian = 121,
    IPAExtensions = 122,
    HangulJamo = 123,
    HangulJamoExtendedA = 124,
    HangulJamoExtendedB = 125,
    Javanese = 126,
    Kaithi = 127,
    KanaExtendedA = 128,
    KanaSupplement = 129,
    Kanbun = 130,
    KangxiRadicals = 131,
    Kannada = 132,
    Katakana = 133,
    KatakanaPhoneticExtensions = 134,
    KayahLi = 135,
    Kharoshthi = 136,
    KhitanSmallScript = 137,
    Khmer = 138,
    KhmerSymbols = 139,
    Khojki = 140,
    Khudawadi = 141,
    Lao = 142,
    Latin1Supplement = 143,
    LatinExtendedA = 144,
    LatinExtendedAdditional = 145,
    LatinExtendedB = 146,
    LatinExtendedC = 147,
    LatinExtendedD = 148,
    LatinExtendedE = 149,
    Lepcha = 150,
    LetterlikeSymbols = 151,
    Limbu = 152,
    LinearA = 153,
    LinearBIdeograms = 154,
    LinearBSyllabary = 155,
    Lisu = 156,
    LisuSupplement = 157,
    LowSurrogates = 158,
    Lycian = 159,
    Lydian = 160,
    Mahajani = 161,
    MahjongTiles = 162,
    Makasar = 163,
    Malayalam = 164,
    Mandaic = 165,
    Manichaean = 166,
    Marchen = 167,
    MasaramGondi = 168,
    MathematicalAlphanumericSymbols = 169,
    MathematicalOperators = 170,
    MayanNumerals = 171,
    Medefaidrin = 172,
    MeeteiMayek = 173,
    MeeteiMayekExtensions = 174,
    MendeKikakui = 175,
    MeroiticCursive = 176,
    MeroiticHieroglyphs = 177,
    Miao = 178,
    MiscellaneousMathematicalSymbolsA = 179,
    MiscellaneousMathematicalSymbolsB = 180,
    MiscellaneousSymbols = 181,
    MiscellaneousTechnical = 182,
    Modi = 183,
    SpacingModifierLetters = 184,
    ModifierToneLetters = 185,
    Mongolian = 186,
    MongolianSupplement = 187,
    Mro = 188,
    Multani = 189,
    MusicalSymbols = 190,
    Myanmar = 191,
    MyanmarExtendedA = 192,
    MyanmarExtendedB = 193,
    Nabataean = 194,
    Nandinagari = 195,
    NoBlock = 196,
    NewTaiLue = 197,
    Newa = 198,
    NKo = 199,
    NumberForms = 200,
    Nushu = 201,
    NyiakengPuachueHmong = 202,
    OpticalCharacterRecognition = 203,
    Ogham = 204,
    OlChiki = 205,
    OldHungarian = 206,
    OldItalic = 207,
    OldNorthArabian = 208,
    OldPermic = 209,
    OldPersian = 210,
    OldSogdian = 211,
    OldSouthArabian = 212,
    OldTurkic = 213,
    Oriya = 214,
    OrnamentalDingbats = 215,
    Osage = 216,
    Osmanya = 217,
    OttomanSiyaqNumbers = 218,
    PahawhHmong = 219,
    Palmyrene = 220,
    PauCinHau = 221,
    PhaistosDisc = 222,
    Phoenician = 223,
    PhoneticExtensions = 224,
    PhoneticExtensionsSupplement = 225,
    PlayingCards = 226,
    PsalterPahlavi = 227,
    PrivateUseArea = 228,
    GeneralPunctuation = 229,
    Rejang = 230,
    RumiNumeralSymbols = 231,
    Runic = 232,
    Samaritan = 233,
    Saurashtra = 234,
    Sharada = 235,
    Shavian = 236,
    ShorthandFormatControls = 237,
    Siddham = 238,
    Sinhala = 239,
    SinhalaArchaicNumbers = 240,
    SmallFormVariants = 241,
    SmallKanaExtension = 242,
    Sogdian = 243,
    SoraSompeng = 244,
    Soyombo = 245,
    Specials = 246,
    Sundanese = 247,
    SundaneseSupplement = 248,
    SupplementalArrowsA = 249,
    SupplementalArrowsB = 250,
    SupplementalArrowsC = 251,
    SupplementalMathematicalOperators = 252,
    SupplementaryPrivateUseAreaA = 253,
    SupplementaryPrivateUseAreaB = 254,
    SupplementalPunctuation = 255,
    SuttonSignWriting = 256,
    SylotiNagri = 257,
    Syriac = 258,
    SyriacSupplement = 259,
    Tagalog = 260,
    Tagbanwa = 261,
    Tags = 262,
    TaiLe = 263,
    TaiTham = 264,
    TaiViet = 265,
    TaiXuanJingSymbols = 266,
    Takri = 267,
    Tamil = 268,
    TamilSupplement = 269,
    Tangut = 270,
    TangutComponents = 271,
    TangutSupplement = 272,
    Telugu = 273,
    Thaana = 274,
    Thai = 275,
    Tibetan = 276,
    Tifinagh = 277,
    Tirhuta = 278,
    UnifiedCanadianAboriginalSyllabics = 279,
    UnifiedCanadianAboriginalSyllabicsExtended = 280,
    Ugaritic = 281,
    Vai = 282,
    VedicExtensions = 283,
    VerticalForms = 284,
    VariationSelectors = 285,
    VariationSelectorsSupplement = 286,
    Wancho = 287,
    WarangCiti = 288,
    Yezidi = 289,
    YiRadicals = 290,
    YiSyllables = 291,
    YijingHexagramSymbols = 292,
    ZanabazarSquare = 293,
    GreekandCoptic = 294,
    SuperscriptsandSubscripts = 295,
    CombiningDiacriticalMarksforSymbols = 296,
    MiscellaneousSymbolsandArrows = 297,
    CJKSymbolsandPunctuation = 298,
    EnclosedCJKLettersandMonths = 299,
    Phagspa = 300,
    HalfwidthandFullwidthForms = 301,
    CuneiformNumbersandPunctuation = 302,
    IdeographicSymbolsandPunctuation = 303,
    MiscellaneousSymbolsandPictographs = 304,
    TransportandMapSymbols = 305,
    SupplementalSymbolsandPictographs = 306,
    SymbolsandPictographsExtendedA = 307,
    SymbolsforLegacyComputing = 308,
}

/// Unicode script property.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum Script {
    Adlam = 0,
    CaucasianAlbanian = 1,
    Ahom = 2,
    Arabic = 3,
    ImperialAramaic = 4,
    Armenian = 5,
    Avestan = 6,
    Balinese = 7,
    Bamum = 8,
    BassaVah = 9,
    Batak = 10,
    Bengali = 11,
    Bhaiksuki = 12,
    Bopomofo = 13,
    Brahmi = 14,
    Braille = 15,
    Buginese = 16,
    Buhid = 17,
    Chakma = 18,
    CanadianAboriginal = 19,
    Carian = 20,
    Cham = 21,
    Cherokee = 22,
    Chorasmian = 23,
    Coptic = 24,
    Cypriot = 25,
    Cyrillic = 26,
    Devanagari = 27,
    DivesAkuru = 28,
    Dogra = 29,
    Deseret = 30,
    Duployan = 31,
    EgyptianHieroglyphs = 32,
    Elbasan = 33,
    Elymaic = 34,
    Ethiopic = 35,
    Georgian = 36,
    Glagolitic = 37,
    GunjalaGondi = 38,
    MasaramGondi = 39,
    Gothic = 40,
    Grantha = 41,
    Greek = 42,
    Gujarati = 43,
    Gurmukhi = 44,
    Hangul = 45,
    Han = 46,
    Hanunoo = 47,
    Hatran = 48,
    Hebrew = 49,
    Hiragana = 50,
    AnatolianHieroglyphs = 51,
    PahawhHmong = 52,
    NyiakengPuachueHmong = 53,
    OldHungarian = 54,
    OldItalic = 55,
    Javanese = 56,
    KayahLi = 57,
    Katakana = 58,
    Kharoshthi = 59,
    Khmer = 60,
    Khojki = 61,
    KhitanSmallScript = 62,
    Kannada = 63,
    Kaithi = 64,
    TaiTham = 65,
    Lao = 66,
    Latin = 67,
    Lepcha = 68,
    Limbu = 69,
    LinearA = 70,
    LinearB = 71,
    Lisu = 72,
    Lycian = 73,
    Lydian = 74,
    Mahajani = 75,
    Makasar = 76,
    Mandaic = 77,
    Manichaean = 78,
    Marchen = 79,
    Medefaidrin = 80,
    MendeKikakui = 81,
    MeroiticCursive = 82,
    MeroiticHieroglyphs = 83,
    Malayalam = 84,
    Modi = 85,
    Mongolian = 86,
    Mro = 87,
    MeeteiMayek = 88,
    Multani = 89,
    Myanmar = 90,
    Nandinagari = 91,
    OldNorthArabian = 92,
    Nabataean = 93,
    Newa = 94,
    Nko = 95,
    Nushu = 96,
    Ogham = 97,
    OlChiki = 98,
    OldTurkic = 99,
    Oriya = 100,
    Osage = 101,
    Osmanya = 102,
    Palmyrene = 103,
    PauCinHau = 104,
    OldPermic = 105,
    PhagsPa = 106,
    InscriptionalPahlavi = 107,
    PsalterPahlavi = 108,
    Phoenician = 109,
    Miao = 110,
    InscriptionalParthian = 111,
    Rejang = 112,
    HanifiRohingya = 113,
    Runic = 114,
    Samaritan = 115,
    OldSouthArabian = 116,
    Saurashtra = 117,
    SignWriting = 118,
    Shavian = 119,
    Sharada = 120,
    Siddham = 121,
    Khudawadi = 122,
    Sinhala = 123,
    Sogdian = 124,
    OldSogdian = 125,
    SoraSompeng = 126,
    Soyombo = 127,
    Sundanese = 128,
    SylotiNagri = 129,
    Syriac = 130,
    Tagbanwa = 131,
    Takri = 132,
    TaiLe = 133,
    NewTaiLue = 134,
    Tamil = 135,
    Tangut = 136,
    TaiViet = 137,
    Telugu = 138,
    Tifinagh = 139,
    Tagalog = 140,
    Thaana = 141,
    Thai = 142,
    Tibetan = 143,
    Tirhuta = 144,
    Ugaritic = 145,
    Vai = 146,
    WarangCiti = 147,
    Wancho = 148,
    OldPersian = 149,
    Cuneiform = 150,
    Yezidi = 151,
    Yi = 152,
    ZanabazarSquare = 153,
    Inherited = 154,
    Common = 155,
    Unknown = 156,
}

/// Canonical combining class.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum CombiningClass {
    NotReordered = 0,
    Overlay = 1,
    HanReading = 6,
    Nukta = 7,
    KanaVoicing = 8,
    Virama = 9,
    Ccc10 = 10,
    Ccc11 = 11,
    Ccc12 = 12,
    Ccc13 = 13,
    Ccc14 = 14,
    Ccc15 = 15,
    Ccc16 = 16,
    Ccc17 = 17,
    Ccc18 = 18,
    Ccc19 = 19,
    Ccc20 = 20,
    Ccc21 = 21,
    Ccc22 = 22,
    Ccc23 = 23,
    Ccc24 = 24,
    Ccc25 = 25,
    Ccc26 = 26,
    Ccc27 = 27,
    Ccc28 = 28,
    Ccc29 = 29,
    Ccc30 = 30,
    Ccc31 = 31,
    Ccc32 = 32,
    Ccc33 = 33,
    Ccc34 = 34,
    Ccc35 = 35,
    Ccc36 = 36,
    Ccc84 = 84,
    Ccc91 = 91,
    Ccc103 = 103,
    Ccc107 = 107,
    Ccc118 = 118,
    Ccc122 = 122,
    Ccc129 = 129,
    Ccc130 = 130,
    Ccc132 = 132,
    Ccc133 = 133,
    AttachedBelowLeft = 200,
    AttachedBelow = 202,
    AttachedAbove = 214,
    AttachedAboveRight = 216,
    BelowLeft = 218,
    Below = 220,
    BelowRight = 222,
    Left = 224,
    Right = 226,
    AboveLeft = 228,
    Above = 230,
    AboveRight = 232,
    DoubleBelow = 233,
    DoubleAbove = 234,
    IotaSubscript = 240,
}

/// Property for the bidirectional algorithm.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum BidiClass {
    AL = 0,
    AN = 1,
    B = 2,
    BN = 3,
    CS = 4,
    EN = 5,
    ES = 6,
    ET = 7,
    FSI = 8,
    L = 9,
    LRE = 10,
    LRI = 11,
    LRO = 12,
    NSM = 13,
    ON = 14,
    PDF = 15,
    PDI = 16,
    R = 17,
    RLE = 18,
    RLI = 19,
    RLO = 20,
    S = 21,
    WS = 22,
}

/// Property for the cluster breaking algorithm.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum ClusterBreak {
    CN = 0,
    CR = 1,
    EX = 2,
    L = 3,
    LF = 4,
    LV = 5,
    LVT = 6,
    PP = 7,
    RI = 8,
    SM = 9,
    T = 10,
    V = 11,
    XX = 12,
    ZWJ = 13,
}

/// Property for the line breaking algorithm.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum LineBreak {
    AI = 0,
    AL = 1,
    B2 = 2,
    BA = 3,
    BB = 4,
    BK = 5,
    CB = 6,
    CJ = 7,
    CL = 8,
    CM = 9,
    CP = 10,
    CR = 11,
    EB = 12,
    EM = 13,
    EX = 14,
    GL = 15,
    H2 = 16,
    H3 = 17,
    HL = 18,
    HY = 19,
    ID = 20,
    IN = 21,
    IS = 22,
    JL = 23,
    JT = 24,
    JV = 25,
    LF = 26,
    NL = 27,
    NS = 28,
    NU = 29,
    OP = 30,
    PO = 31,
    PR = 32,
    QU = 33,
    RI = 34,
    SA = 35,
    SG = 36,
    SP = 37,
    SY = 38,
    WJ = 39,
    XX = 40,
    ZW = 41,
    ZWJ = 42,
}

/// Property for the word breaking algorithm.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum WordBreak {
    CR = 0,
    DQ = 1,
    EX = 2,
    Extend = 3,
    FO = 4,
    HL = 5,
    KA = 6,
    LE = 7,
    LF = 8,
    MB = 9,
    ML = 10,
    MN = 11,
    NL = 12,
    NU = 13,
    RI = 14,
    SQ = 15,
    WSegSpace = 16,
    XX = 17,
    ZWJ = 18,
}

/// Joining type property.
#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum JoiningType {
    U = 0,
    L = 1,
    R = 2,
    D = 3,
    Alaph = 4,
    DalathRish = 5,
    T = 6,
}

#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum UseClass {
    B = 0,
    CGJ = 1,
    CMAbv = 2,
    CMBlw = 3,
    CS = 4,
    FAbv = 5,
    FBlw = 6,
    FPst = 7,
    FM = 8,
    GB = 9,
    H = 10,
    HN = 11,
    IND = 12,
    MAbv = 13,
    MBlw = 14,
    MPre = 15,
    MPst = 16,
    N = 17,
    O = 18,
    R = 19,
    Rsv = 20,
    S = 21,
    SMAbv = 22,
    SMBlw = 23,
    SUB = 24,
    VAbv = 25,
    VBlw = 26,
    VPre = 27,
    VPst = 28,
    VMAbv = 29,
    VMBlw = 30,
    VMPre = 31,
    VMPst = 32,
    VS = 33,
    WJ = 34,
    ZWJ = 35,
    ZWNJ = 36,
}

#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
#[repr(u8)]
pub enum MyanmarClass {
    A = 0,
    As = 1,
    C = 2,
    D = 3,
    D0 = 4,
    DB = 5,
    GB = 6,
    H = 7,
    IV = 8,
    J = 9,
    K = 10,
    MH = 11,
    MR = 12,
    MW = 13,
    MY = 14,
    O = 15,
    P = 16,
    PT = 17,
    R = 18,
    S = 19,
    V = 20,
    VAbv = 21,
    VBlw = 22,
    VPre = 23,
    VPst = 24,
    VS = 25,
    WJ = 26,
}

#[rustfmt::skip]
pub const SCRIPT_TAGS: [u32; 157] = [
    (97<<24|100<<16|108<<8|109), (97<<24|103<<16|104<<8|98), (97<<24|104<<16|111<<8|109),
    (97<<24|114<<16|97<<8|98), (97<<24|114<<16|109<<8|105), (97<<24|114<<16|109<<8|110),
    (97<<24|118<<16|115<<8|116), (98<<24|97<<16|108<<8|105), (98<<24|97<<16|109<<8|117),
    (98<<24|97<<16|115<<8|115), (98<<24|97<<16|116<<8|107), (98<<24|110<<16|103<<8|50),
    (98<<24|104<<16|107<<8|115), (98<<24|111<<16|112<<8|111), (98<<24|114<<16|97<<8|104),
    (98<<24|114<<16|97<<8|105), (98<<24|117<<16|103<<8|105), (98<<24|117<<16|104<<8|100),
    (99<<24|97<<16|107<<8|109), (99<<24|97<<16|110<<8|115), (99<<24|97<<16|114<<8|105),
    (99<<24|104<<16|97<<8|109), (99<<24|104<<16|101<<8|114), (99<<24|104<<16|114<<8|115),
    (99<<24|111<<16|112<<8|116), (99<<24|112<<16|114<<8|116), (99<<24|121<<16|114<<8|108),
    (100<<24|101<<16|118<<8|50), (100<<24|105<<16|97<<8|107), (100<<24|111<<16|103<<8|114),
    (100<<24|115<<16|114<<8|116), (100<<24|117<<16|112<<8|108), (101<<24|103<<16|121<<8|112),
    (101<<24|108<<16|98<<8|97), (101<<24|108<<16|121<<8|109), (101<<24|116<<16|104<<8|105),
    (103<<24|101<<16|111<<8|114), (103<<24|108<<16|97<<8|103), (103<<24|111<<16|110<<8|103),
    (103<<24|111<<16|110<<8|109), (103<<24|111<<16|116<<8|104), (103<<24|114<<16|97<<8|110),
    (103<<24|114<<16|101<<8|107), (103<<24|106<<16|114<<8|50), (103<<24|117<<16|114<<8|50),
    (104<<24|97<<16|110<<8|103), (104<<24|97<<16|110<<8|105), (104<<24|97<<16|110<<8|111),
    (104<<24|97<<16|116<<8|114), (104<<24|101<<16|98<<8|114), (104<<24|105<<16|114<<8|97),
    (104<<24|108<<16|117<<8|119), (104<<24|109<<16|110<<8|103), (104<<24|109<<16|110<<8|112),
    (104<<24|117<<16|110<<8|103), (105<<24|116<<16|97<<8|108), (106<<24|97<<16|118<<8|97),
    (107<<24|97<<16|108<<8|105), (107<<24|97<<16|110<<8|97), (107<<24|104<<16|97<<8|114),
    (107<<24|104<<16|109<<8|114), (107<<24|104<<16|111<<8|106), (107<<24|105<<16|116<<8|115),
    (107<<24|110<<16|100<<8|50), (107<<24|116<<16|104<<8|105), (108<<24|97<<16|110<<8|97),
    (108<<24|97<<16|111<<8|111), (108<<24|97<<16|116<<8|110), (108<<24|101<<16|112<<8|99),
    (108<<24|105<<16|109<<8|98), (108<<24|105<<16|110<<8|97), (108<<24|105<<16|110<<8|98),
    (108<<24|105<<16|115<<8|117), (108<<24|121<<16|99<<8|105), (108<<24|121<<16|100<<8|105),
    (109<<24|97<<16|104<<8|106), (109<<24|97<<16|107<<8|97), (109<<24|97<<16|110<<8|100),
    (109<<24|97<<16|110<<8|105), (109<<24|97<<16|114<<8|99), (109<<24|101<<16|100<<8|102),
    (109<<24|101<<16|110<<8|100), (109<<24|101<<16|114<<8|99), (109<<24|101<<16|114<<8|111),
    (109<<24|108<<16|109<<8|50), (109<<24|111<<16|100<<8|105), (109<<24|111<<16|110<<8|103),
    (109<<24|114<<16|111<<8|111), (109<<24|116<<16|101<<8|105), (109<<24|117<<16|108<<8|116),
    (109<<24|121<<16|109<<8|50), (110<<24|97<<16|110<<8|100), (110<<24|97<<16|114<<8|98),
    (110<<24|98<<16|97<<8|116), (110<<24|101<<16|119<<8|97), (110<<24|107<<16|111<<8|111),
    (110<<24|115<<16|104<<8|117), (111<<24|103<<16|97<<8|109), (111<<24|108<<16|99<<8|107),
    (111<<24|114<<16|107<<8|104), (111<<24|114<<16|121<<8|50), (111<<24|115<<16|103<<8|101),
    (111<<24|115<<16|109<<8|97), (112<<24|97<<16|108<<8|109), (112<<24|97<<16|117<<8|99),
    (112<<24|101<<16|114<<8|109), (112<<24|104<<16|97<<8|103), (112<<24|104<<16|108<<8|105),
    (112<<24|104<<16|108<<8|112), (112<<24|104<<16|110<<8|120), (109<<24|105<<16|97<<8|111),
    (112<<24|114<<16|116<<8|105), (114<<24|106<<16|110<<8|103), (114<<24|111<<16|104<<8|103),
    (114<<24|117<<16|110<<8|114), (115<<24|97<<16|109<<8|114), (115<<24|97<<16|114<<8|98),
    (115<<24|97<<16|117<<8|114), (115<<24|103<<16|110<<8|119), (115<<24|104<<16|97<<8|119),
    (115<<24|104<<16|114<<8|100), (115<<24|105<<16|100<<8|100), (115<<24|105<<16|110<<8|100),
    (115<<24|105<<16|110<<8|104), (115<<24|111<<16|103<<8|100), (115<<24|111<<16|103<<8|111),
    (115<<24|111<<16|114<<8|97), (115<<24|111<<16|121<<8|111), (115<<24|117<<16|110<<8|100),
    (115<<24|121<<16|108<<8|111), (115<<24|121<<16|114<<8|99), (116<<24|97<<16|103<<8|98),
    (116<<24|97<<16|107<<8|114), (116<<24|97<<16|108<<8|101), (116<<24|97<<16|108<<8|117),
    (116<<24|109<<16|108<<8|50), (116<<24|97<<16|110<<8|103), (116<<24|97<<16|118<<8|116),
    (116<<24|101<<16|108<<8|117), (116<<24|102<<16|110<<8|103), (116<<24|103<<16|108<<8|103),
    (116<<24|104<<16|97<<8|97), (116<<24|104<<16|97<<8|105), (116<<24|105<<16|98<<8|116),
    (116<<24|105<<16|114<<8|104), (117<<24|103<<16|97<<8|114), (118<<24|97<<16|105<<8|105),
    (119<<24|97<<16|114<<8|97), (119<<24|99<<16|104<<8|111), (120<<24|112<<16|101<<8|111),
    (120<<24|115<<16|117<<8|120), (121<<24|101<<16|122<<8|105), (121<<24|105<<16|105<<8|105),
    (122<<24|97<<16|110<<8|98), (122<<24|105<<16|110<<8|104), (122<<24|121<<16|121<<8|121),
    (122<<24|122<<16|122<<8|122),
];

#[rustfmt::skip]
pub const SCRIPTS_BY_TAG: [(u32, Script); 157] = [
    ((97<<24|100<<16|108<<8|109), Script::Adlam),
    ((97<<24|103<<16|104<<8|98), Script::CaucasianAlbanian),
    ((97<<24|104<<16|111<<8|109), Script::Ahom), ((97<<24|114<<16|97<<8|98), Script::Arabic),
    ((97<<24|114<<16|109<<8|105), Script::ImperialAramaic),
    ((97<<24|114<<16|109<<8|110), Script::Armenian),
    ((97<<24|118<<16|115<<8|116), Script::Avestan), ((98<<24|97<<16|108<<8|105), Script::Balinese),
    ((98<<24|97<<16|109<<8|117), Script::Bamum), ((98<<24|97<<16|115<<8|115), Script::BassaVah),
    ((98<<24|97<<16|116<<8|107), Script::Batak), ((98<<24|110<<16|103<<8|50), Script::Bengali),
    ((98<<24|104<<16|107<<8|115), Script::Bhaiksuki),
    ((98<<24|111<<16|112<<8|111), Script::Bopomofo), ((98<<24|114<<16|97<<8|104), Script::Brahmi),
    ((98<<24|114<<16|97<<8|105), Script::Braille), ((98<<24|117<<16|103<<8|105), Script::Buginese),
    ((98<<24|117<<16|104<<8|100), Script::Buhid), ((99<<24|97<<16|107<<8|109), Script::Chakma),
    ((99<<24|97<<16|110<<8|115), Script::CanadianAboriginal),
    ((99<<24|97<<16|114<<8|105), Script::Carian), ((99<<24|104<<16|97<<8|109), Script::Cham),
    ((99<<24|104<<16|101<<8|114), Script::Cherokee),
    ((99<<24|104<<16|114<<8|115), Script::Chorasmian),
    ((99<<24|111<<16|112<<8|116), Script::Coptic), ((99<<24|112<<16|114<<8|116), Script::Cypriot),
    ((99<<24|121<<16|114<<8|108), Script::Cyrillic),
    ((100<<24|101<<16|118<<8|50), Script::Devanagari),
    ((100<<24|105<<16|97<<8|107), Script::DivesAkuru),
    ((100<<24|111<<16|103<<8|114), Script::Dogra), ((100<<24|115<<16|114<<8|116), Script::Deseret),
    ((100<<24|117<<16|112<<8|108), Script::Duployan),
    ((101<<24|103<<16|121<<8|112), Script::EgyptianHieroglyphs),
    ((101<<24|108<<16|98<<8|97), Script::Elbasan), ((101<<24|108<<16|121<<8|109), Script::Elymaic),
    ((101<<24|116<<16|104<<8|105), Script::Ethiopic),
    ((103<<24|101<<16|111<<8|114), Script::Georgian),
    ((103<<24|108<<16|97<<8|103), Script::Glagolitic),
    ((103<<24|111<<16|110<<8|103), Script::GunjalaGondi),
    ((103<<24|111<<16|110<<8|109), Script::MasaramGondi),
    ((103<<24|111<<16|116<<8|104), Script::Gothic), ((103<<24|114<<16|97<<8|110), Script::Grantha),
    ((103<<24|114<<16|101<<8|107), Script::Greek), ((103<<24|106<<16|114<<8|50), Script::Gujarati),
    ((103<<24|117<<16|114<<8|50), Script::Gurmukhi), ((104<<24|97<<16|110<<8|103), Script::Hangul),
    ((104<<24|97<<16|110<<8|105), Script::Han), ((104<<24|97<<16|110<<8|111), Script::Hanunoo),
    ((104<<24|97<<16|116<<8|114), Script::Hatran), ((104<<24|101<<16|98<<8|114), Script::Hebrew),
    ((104<<24|105<<16|114<<8|97), Script::Hiragana),
    ((104<<24|108<<16|117<<8|119), Script::AnatolianHieroglyphs),
    ((104<<24|109<<16|110<<8|103), Script::PahawhHmong),
    ((104<<24|109<<16|110<<8|112), Script::NyiakengPuachueHmong),
    ((104<<24|117<<16|110<<8|103), Script::OldHungarian),
    ((105<<24|116<<16|97<<8|108), Script::OldItalic),
    ((106<<24|97<<16|118<<8|97), Script::Javanese), ((107<<24|97<<16|108<<8|105), Script::KayahLi),
    ((107<<24|97<<16|110<<8|97), Script::Katakana),
    ((107<<24|104<<16|97<<8|114), Script::Kharoshthi),
    ((107<<24|104<<16|109<<8|114), Script::Khmer), ((107<<24|104<<16|111<<8|106), Script::Khojki),
    ((107<<24|105<<16|116<<8|115), Script::KhitanSmallScript),
    ((107<<24|110<<16|100<<8|50), Script::Kannada), ((107<<24|116<<16|104<<8|105), Script::Kaithi),
    ((108<<24|97<<16|110<<8|97), Script::TaiTham), ((108<<24|97<<16|111<<8|111), Script::Lao),
    ((108<<24|97<<16|116<<8|110), Script::Latin), ((108<<24|101<<16|112<<8|99), Script::Lepcha),
    ((108<<24|105<<16|109<<8|98), Script::Limbu), ((108<<24|105<<16|110<<8|97), Script::LinearA),
    ((108<<24|105<<16|110<<8|98), Script::LinearB), ((108<<24|105<<16|115<<8|117), Script::Lisu),
    ((108<<24|121<<16|99<<8|105), Script::Lycian), ((108<<24|121<<16|100<<8|105), Script::Lydian),
    ((109<<24|97<<16|104<<8|106), Script::Mahajani), ((109<<24|97<<16|107<<8|97), Script::Makasar),
    ((109<<24|97<<16|110<<8|100), Script::Mandaic),
    ((109<<24|97<<16|110<<8|105), Script::Manichaean),
    ((109<<24|97<<16|114<<8|99), Script::Marchen),
    ((109<<24|101<<16|100<<8|102), Script::Medefaidrin),
    ((109<<24|101<<16|110<<8|100), Script::MendeKikakui),
    ((109<<24|101<<16|114<<8|99), Script::MeroiticCursive),
    ((109<<24|101<<16|114<<8|111), Script::MeroiticHieroglyphs),
    ((109<<24|108<<16|109<<8|50), Script::Malayalam), ((109<<24|111<<16|100<<8|105), Script::Modi),
    ((109<<24|111<<16|110<<8|103), Script::Mongolian), ((109<<24|114<<16|111<<8|111), Script::Mro),
    ((109<<24|116<<16|101<<8|105), Script::MeeteiMayek),
    ((109<<24|117<<16|108<<8|116), Script::Multani),
    ((109<<24|121<<16|109<<8|50), Script::Myanmar),
    ((110<<24|97<<16|110<<8|100), Script::Nandinagari),
    ((110<<24|97<<16|114<<8|98), Script::OldNorthArabian),
    ((110<<24|98<<16|97<<8|116), Script::Nabataean), ((110<<24|101<<16|119<<8|97), Script::Newa),
    ((110<<24|107<<16|111<<8|32), Script::Nko), ((110<<24|115<<16|104<<8|117), Script::Nushu),
    ((111<<24|103<<16|97<<8|109), Script::Ogham), ((111<<24|108<<16|99<<8|107), Script::OlChiki),
    ((111<<24|114<<16|107<<8|104), Script::OldTurkic),
    ((111<<24|114<<16|121<<8|50), Script::Oriya), ((111<<24|115<<16|103<<8|101), Script::Osage),
    ((111<<24|115<<16|109<<8|97), Script::Osmanya),
    ((112<<24|97<<16|108<<8|109), Script::Palmyrene),
    ((112<<24|97<<16|117<<8|99), Script::PauCinHau),
    ((112<<24|101<<16|114<<8|109), Script::OldPermic),
    ((112<<24|104<<16|97<<8|103), Script::PhagsPa),
    ((112<<24|104<<16|108<<8|105), Script::InscriptionalPahlavi),
    ((112<<24|104<<16|108<<8|112), Script::PsalterPahlavi),
    ((112<<24|104<<16|110<<8|120), Script::Phoenician),
    ((109<<24|105<<16|97<<8|111), Script::Miao),
    ((112<<24|114<<16|116<<8|105), Script::InscriptionalParthian),
    ((114<<24|106<<16|110<<8|103), Script::Rejang),
    ((114<<24|111<<16|104<<8|103), Script::HanifiRohingya),
    ((114<<24|117<<16|110<<8|114), Script::Runic),
    ((115<<24|97<<16|109<<8|114), Script::Samaritan),
    ((115<<24|97<<16|114<<8|98), Script::OldSouthArabian),
    ((115<<24|97<<16|117<<8|114), Script::Saurashtra),
    ((115<<24|103<<16|110<<8|119), Script::SignWriting),
    ((115<<24|104<<16|97<<8|119), Script::Shavian),
    ((115<<24|104<<16|114<<8|100), Script::Sharada),
    ((115<<24|105<<16|100<<8|100), Script::Siddham),
    ((115<<24|105<<16|110<<8|100), Script::Khudawadi),
    ((115<<24|105<<16|110<<8|104), Script::Sinhala),
    ((115<<24|111<<16|103<<8|100), Script::Sogdian),
    ((115<<24|111<<16|103<<8|111), Script::OldSogdian),
    ((115<<24|111<<16|114<<8|97), Script::SoraSompeng),
    ((115<<24|111<<16|121<<8|111), Script::Soyombo),
    ((115<<24|117<<16|110<<8|100), Script::Sundanese),
    ((115<<24|121<<16|108<<8|111), Script::SylotiNagri),
    ((115<<24|121<<16|114<<8|99), Script::Syriac), ((116<<24|97<<16|103<<8|98), Script::Tagbanwa),
    ((116<<24|97<<16|107<<8|114), Script::Takri), ((116<<24|97<<16|108<<8|101), Script::TaiLe),
    ((116<<24|97<<16|108<<8|117), Script::NewTaiLue), ((116<<24|109<<16|108<<8|50), Script::Tamil),
    ((116<<24|97<<16|110<<8|103), Script::Tangut), ((116<<24|97<<16|118<<8|116), Script::TaiViet),
    ((116<<24|101<<16|108<<8|117), Script::Telugu),
    ((116<<24|102<<16|110<<8|103), Script::Tifinagh),
    ((116<<24|103<<16|108<<8|103), Script::Tagalog), ((116<<24|104<<16|97<<8|97), Script::Thaana),
    ((116<<24|104<<16|97<<8|105), Script::Thai), ((116<<24|105<<16|98<<8|116), Script::Tibetan),
    ((116<<24|105<<16|114<<8|104), Script::Tirhuta),
    ((117<<24|103<<16|97<<8|114), Script::Ugaritic), ((118<<24|97<<16|105<<8|105), Script::Vai),
    ((119<<24|97<<16|114<<8|97), Script::WarangCiti),
    ((119<<24|99<<16|104<<8|111), Script::Wancho),
    ((120<<24|112<<16|101<<8|111), Script::OldPersian),
    ((120<<24|115<<16|117<<8|120), Script::Cuneiform),
    ((121<<24|101<<16|122<<8|105), Script::Yezidi), ((121<<24|105<<16|105<<8|105), Script::Yi),
    ((122<<24|97<<16|110<<8|98), Script::ZanabazarSquare),
    ((122<<24|105<<16|110<<8|104), Script::Inherited),
    ((122<<24|121<<16|121<<8|121), Script::Common),
    ((122<<24|122<<16|122<<8|122), Script::Unknown),
];

#[rustfmt::skip]
pub const SCRIPT_NAMES: [&'static str; 157] = [
    "Adlam", "Caucasian Albanian", "Ahom", "Arabic", "Imperial Aramaic", "Armenian", "Avestan",
    "Balinese", "Bamum", "Bassa Vah", "Batak", "Bengali", "Bhaiksuki", "Bopomofo", "Brahmi",
    "Braille", "Buginese", "Buhid", "Chakma", "Canadian Aboriginal", "Carian", "Cham", "Cherokee",
    "Chorasmian", "Coptic", "Cypriot", "Cyrillic", "Devanagari", "Dives Akuru", "Dogra", "Deseret",
    "Duployan", "Egyptian Hieroglyphs", "Elbasan", "Elymaic", "Ethiopic", "Georgian", "Glagolitic",
    "Gunjala Gondi", "Masaram Gondi", "Gothic", "Grantha", "Greek", "Gujarati", "Gurmukhi",
    "Hangul", "Han", "Hanunoo", "Hatran", "Hebrew", "Hiragana", "Anatolian Hieroglyphs",
    "Pahawh Hmong", "Nyiakeng Puachue Hmong", "Old Hungarian", "Old Italic", "Javanese",
    "Kayah Li", "Katakana", "Kharoshthi", "Khmer", "Khojki", "Khitan Small Script", "Kannada",
    "Kaithi", "Tai Tham", "Lao", "Latin", "Lepcha", "Limbu", "Linear A", "Linear B", "Lisu",
    "Lycian", "Lydian", "Mahajani", "Makasar", "Mandaic", "Manichaean", "Marchen", "Medefaidrin",
    "Mende Kikakui", "Meroitic Cursive", "Meroitic Hieroglyphs", "Malayalam", "Modi", "Mongolian",
    "Mro", "Meetei Mayek", "Multani", "Myanmar", "Nandinagari", "Old North Arabian", "Nabataean",
    "Newa", "Nko", "Nushu", "Ogham", "Ol Chiki", "Old Turkic", "Oriya", "Osage", "Osmanya",
    "Palmyrene", "Pau Cin Hau", "Old Permic", "Phags Pa", "Inscriptional Pahlavi",
    "Psalter Pahlavi", "Phoenician", "Miao", "Inscriptional Parthian", "Rejang", "Hanifi Rohingya",
    "Runic", "Samaritan", "Old South Arabian", "Saurashtra", "SignWriting", "Shavian", "Sharada",
    "Siddham", "Khudawadi", "Sinhala", "Sogdian", "Old Sogdian", "Sora Sompeng", "Soyombo",
    "Sundanese", "Syloti Nagri", "Syriac", "Tagbanwa", "Takri", "Tai Le", "New Tai Lue", "Tamil",
    "Tangut", "Tai Viet", "Telugu", "Tifinagh", "Tagalog", "Thaana", "Thai", "Tibetan", "Tirhuta",
    "Ugaritic", "Vai", "Warang Citi", "Wancho", "Old Persian", "Cuneiform", "Yezidi", "Yi",
    "Zanabazar Square", "Inherited", "Common", "Unknown",
];

#[rustfmt::skip]
pub const SCRIPT_COMPLEXITY: [bool; 157] = [
    true, false, true, false, false, false, false, true, false, false, true, true, true, false,
    true, false, true, true, true, false, false, true, false, false, false, false, false, true,
    false, true, false, true, true, false, true, false, false, false, true, true, false, true,
    false, true, true, false, false, true, false, false, false, false, true, true, false, false,
    true, false, false, true, true, true, false, true, true, true, false, false, true, true, false,
    false, false, false, false, true, true, true, true, true, true, false, false, false, true,
    true, false, false, false, true, true, true, false, false, true, false, false, false, false,
    false, true, false, false, false, false, false, false, false, true, false, true, false, true,
    true, false, false, false, true, false, false, true, true, true, true, true, true, false, true,
    true, true, false, true, true, false, false, true, false, true, true, true, true, false, false,
    true, true, false, false, false, true, false, false, false, false, true, false, false, false,
];

#[rustfmt::skip]
pub const BRACKETS: [(u16, u16); 60] = [
    (0x0028, 0x0029), (0x005B, 0x005D), (0x007B, 0x007D), (0x0F3A, 0x0F3B), (0x0F3C, 0x0F3D),
    (0x169B, 0x169C), (0x2045, 0x2046), (0x207D, 0x207E), (0x208D, 0x208E), (0x2308, 0x2309),
    (0x230A, 0x230B), (0x2329, 0x232A), (0x2768, 0x2769), (0x276A, 0x276B), (0x276C, 0x276D),
    (0x276E, 0x276F), (0x2770, 0x2771), (0x2772, 0x2773), (0x2774, 0x2775), (0x27C5, 0x27C6),
    (0x27E6, 0x27E7), (0x27E8, 0x27E9), (0x27EA, 0x27EB), (0x27EC, 0x27ED), (0x27EE, 0x27EF),
    (0x2983, 0x2984), (0x2985, 0x2986), (0x2987, 0x2988), (0x2989, 0x298A), (0x298B, 0x298C),
    (0x298D, 0x2990), (0x298F, 0x298E), (0x2991, 0x2992), (0x2993, 0x2994), (0x2995, 0x2996),
    (0x2997, 0x2998), (0x29D8, 0x29D9), (0x29DA, 0x29DB), (0x29FC, 0x29FD), (0x2E22, 0x2E23),
    (0x2E24, 0x2E25), (0x2E26, 0x2E27), (0x2E28, 0x2E29), (0x3008, 0x3009), (0x300A, 0x300B),
    (0x300C, 0x300D), (0x300E, 0x300F), (0x3010, 0x3011), (0x3014, 0x3015), (0x3016, 0x3017),
    (0x3018, 0x3019), (0x301A, 0x301B), (0xFE59, 0xFE5A), (0xFE5B, 0xFE5C), (0xFE5D, 0xFE5E),
    (0xFF08, 0xFF09), (0xFF3B, 0xFF3D), (0xFF5B, 0xFF5D), (0xFF5F, 0xFF60), (0xFF62, 0xFF63),
];

#[rustfmt::skip]
pub const MIRRORS: [(u16, u16); 420] = [
    (0x0028, 0x0029), (0x0029, 0x0028), (0x003C, 0x003E), (0x003E, 0x003C), (0x005B, 0x005D),
    (0x005D, 0x005B), (0x007B, 0x007D), (0x007D, 0x007B), (0x00AB, 0x00BB), (0x00BB, 0x00AB),
    (0x0F3A, 0x0F3B), (0x0F3B, 0x0F3A), (0x0F3C, 0x0F3D), (0x0F3D, 0x0F3C), (0x169B, 0x169C),
    (0x169C, 0x169B), (0x2039, 0x203A), (0x203A, 0x2039), (0x2045, 0x2046), (0x2046, 0x2045),
    (0x207D, 0x207E), (0x207E, 0x207D), (0x208D, 0x208E), (0x208E, 0x208D), (0x2208, 0x220B),
    (0x2209, 0x220C), (0x220A, 0x220D), (0x220B, 0x2208), (0x220C, 0x2209), (0x220D, 0x220A),
    (0x2215, 0x29F5), (0x221F, 0x2BFE), (0x2220, 0x29A3), (0x2221, 0x299B), (0x2222, 0x29A0),
    (0x2224, 0x2AEE), (0x223C, 0x223D), (0x223D, 0x223C), (0x2243, 0x22CD), (0x2245, 0x224C),
    (0x224C, 0x2245), (0x2252, 0x2253), (0x2253, 0x2252), (0x2254, 0x2255), (0x2255, 0x2254),
    (0x2264, 0x2265), (0x2265, 0x2264), (0x2266, 0x2267), (0x2267, 0x2266), (0x2268, 0x2269),
    (0x2269, 0x2268), (0x226A, 0x226B), (0x226B, 0x226A), (0x226E, 0x226F), (0x226F, 0x226E),
    (0x2270, 0x2271), (0x2271, 0x2270), (0x2272, 0x2273), (0x2273, 0x2272), (0x2274, 0x2275),
    (0x2275, 0x2274), (0x2276, 0x2277), (0x2277, 0x2276), (0x2278, 0x2279), (0x2279, 0x2278),
    (0x227A, 0x227B), (0x227B, 0x227A), (0x227C, 0x227D), (0x227D, 0x227C), (0x227E, 0x227F),
    (0x227F, 0x227E), (0x2280, 0x2281), (0x2281, 0x2280), (0x2282, 0x2283), (0x2283, 0x2282),
    (0x2284, 0x2285), (0x2285, 0x2284), (0x2286, 0x2287), (0x2287, 0x2286), (0x2288, 0x2289),
    (0x2289, 0x2288), (0x228A, 0x228B), (0x228B, 0x228A), (0x228F, 0x2290), (0x2290, 0x228F),
    (0x2291, 0x2292), (0x2292, 0x2291), (0x2298, 0x29B8), (0x22A2, 0x22A3), (0x22A3, 0x22A2),
    (0x22A6, 0x2ADE), (0x22A8, 0x2AE4), (0x22A9, 0x2AE3), (0x22AB, 0x2AE5), (0x22B0, 0x22B1),
    (0x22B1, 0x22B0), (0x22B2, 0x22B3), (0x22B3, 0x22B2), (0x22B4, 0x22B5), (0x22B5, 0x22B4),
    (0x22B6, 0x22B7), (0x22B7, 0x22B6), (0x22B8, 0x27DC), (0x22C9, 0x22CA), (0x22CA, 0x22C9),
    (0x22CB, 0x22CC), (0x22CC, 0x22CB), (0x22CD, 0x2243), (0x22D0, 0x22D1), (0x22D1, 0x22D0),
    (0x22D6, 0x22D7), (0x22D7, 0x22D6), (0x22D8, 0x22D9), (0x22D9, 0x22D8), (0x22DA, 0x22DB),
    (0x22DB, 0x22DA), (0x22DC, 0x22DD), (0x22DD, 0x22DC), (0x22DE, 0x22DF), (0x22DF, 0x22DE),
    (0x22E0, 0x22E1), (0x22E1, 0x22E0), (0x22E2, 0x22E3), (0x22E3, 0x22E2), (0x22E4, 0x22E5),
    (0x22E5, 0x22E4), (0x22E6, 0x22E7), (0x22E7, 0x22E6), (0x22E8, 0x22E9), (0x22E9, 0x22E8),
    (0x22EA, 0x22EB), (0x22EB, 0x22EA), (0x22EC, 0x22ED), (0x22ED, 0x22EC), (0x22F0, 0x22F1),
    (0x22F1, 0x22F0), (0x22F2, 0x22FA), (0x22F3, 0x22FB), (0x22F4, 0x22FC), (0x22F6, 0x22FD),
    (0x22F7, 0x22FE), (0x22FA, 0x22F2), (0x22FB, 0x22F3), (0x22FC, 0x22F4), (0x22FD, 0x22F6),
    (0x22FE, 0x22F7), (0x2308, 0x2309), (0x2309, 0x2308), (0x230A, 0x230B), (0x230B, 0x230A),
    (0x2329, 0x232A), (0x232A, 0x2329), (0x2768, 0x2769), (0x2769, 0x2768), (0x276A, 0x276B),
    (0x276B, 0x276A), (0x276C, 0x276D), (0x276D, 0x276C), (0x276E, 0x276F), (0x276F, 0x276E),
    (0x2770, 0x2771), (0x2771, 0x2770), (0x2772, 0x2773), (0x2773, 0x2772), (0x2774, 0x2775),
    (0x2775, 0x2774), (0x27C3, 0x27C4), (0x27C4, 0x27C3), (0x27C5, 0x27C6), (0x27C6, 0x27C5),
    (0x27C8, 0x27C9), (0x27C9, 0x27C8), (0x27CB, 0x27CD), (0x27CD, 0x27CB), (0x27D5, 0x27D6),
    (0x27D6, 0x27D5), (0x27DC, 0x22B8), (0x27DD, 0x27DE), (0x27DE, 0x27DD), (0x27E2, 0x27E3),
    (0x27E3, 0x27E2), (0x27E4, 0x27E5), (0x27E5, 0x27E4), (0x27E6, 0x27E7), (0x27E7, 0x27E6),
    (0x27E8, 0x27E9), (0x27E9, 0x27E8), (0x27EA, 0x27EB), (0x27EB, 0x27EA), (0x27EC, 0x27ED),
    (0x27ED, 0x27EC), (0x27EE, 0x27EF), (0x27EF, 0x27EE), (0x2983, 0x2984), (0x2984, 0x2983),
    (0x2985, 0x2986), (0x2986, 0x2985), (0x2987, 0x2988), (0x2988, 0x2987), (0x2989, 0x298A),
    (0x298A, 0x2989), (0x298B, 0x298C), (0x298C, 0x298B), (0x298D, 0x2990), (0x298E, 0x298F),
    (0x298F, 0x298E), (0x2990, 0x298D), (0x2991, 0x2992), (0x2992, 0x2991), (0x2993, 0x2994),
    (0x2994, 0x2993), (0x2995, 0x2996), (0x2996, 0x2995), (0x2997, 0x2998), (0x2998, 0x2997),
    (0x299B, 0x2221), (0x29A0, 0x2222), (0x29A3, 0x2220), (0x29A4, 0x29A5), (0x29A5, 0x29A4),
    (0x29A8, 0x29A9), (0x29A9, 0x29A8), (0x29AA, 0x29AB), (0x29AB, 0x29AA), (0x29AC, 0x29AD),
    (0x29AD, 0x29AC), (0x29AE, 0x29AF), (0x29AF, 0x29AE), (0x29B8, 0x2298), (0x29C0, 0x29C1),
    (0x29C1, 0x29C0), (0x29C4, 0x29C5), (0x29C5, 0x29C4), (0x29CF, 0x29D0), (0x29D0, 0x29CF),
    (0x29D1, 0x29D2), (0x29D2, 0x29D1), (0x29D4, 0x29D5), (0x29D5, 0x29D4), (0x29D8, 0x29D9),
    (0x29D9, 0x29D8), (0x29DA, 0x29DB), (0x29DB, 0x29DA), (0x29E8, 0x29E9), (0x29E9, 0x29E8),
    (0x29F5, 0x2215), (0x29F8, 0x29F9), (0x29F9, 0x29F8), (0x29FC, 0x29FD), (0x29FD, 0x29FC),
    (0x2A2B, 0x2A2C), (0x2A2C, 0x2A2B), (0x2A2D, 0x2A2E), (0x2A2E, 0x2A2D), (0x2A34, 0x2A35),
    (0x2A35, 0x2A34), (0x2A3C, 0x2A3D), (0x2A3D, 0x2A3C), (0x2A64, 0x2A65), (0x2A65, 0x2A64),
    (0x2A79, 0x2A7A), (0x2A7A, 0x2A79), (0x2A7B, 0x2A7C), (0x2A7C, 0x2A7B), (0x2A7D, 0x2A7E),
    (0x2A7E, 0x2A7D), (0x2A7F, 0x2A80), (0x2A80, 0x2A7F), (0x2A81, 0x2A82), (0x2A82, 0x2A81),
    (0x2A83, 0x2A84), (0x2A84, 0x2A83), (0x2A85, 0x2A86), (0x2A86, 0x2A85), (0x2A87, 0x2A88),
    (0x2A88, 0x2A87), (0x2A89, 0x2A8A), (0x2A8A, 0x2A89), (0x2A8B, 0x2A8C), (0x2A8C, 0x2A8B),
    (0x2A8D, 0x2A8E), (0x2A8E, 0x2A8D), (0x2A8F, 0x2A90), (0x2A90, 0x2A8F), (0x2A91, 0x2A92),
    (0x2A92, 0x2A91), (0x2A93, 0x2A94), (0x2A94, 0x2A93), (0x2A95, 0x2A96), (0x2A96, 0x2A95),
    (0x2A97, 0x2A98), (0x2A98, 0x2A97), (0x2A99, 0x2A9A), (0x2A9A, 0x2A99), (0x2A9B, 0x2A9C),
    (0x2A9C, 0x2A9B), (0x2A9D, 0x2A9E), (0x2A9E, 0x2A9D), (0x2A9F, 0x2AA0), (0x2AA0, 0x2A9F),
    (0x2AA1, 0x2AA2), (0x2AA2, 0x2AA1), (0x2AA6, 0x2AA7), (0x2AA7, 0x2AA6), (0x2AA8, 0x2AA9),
    (0x2AA9, 0x2AA8), (0x2AAA, 0x2AAB), (0x2AAB, 0x2AAA), (0x2AAC, 0x2AAD), (0x2AAD, 0x2AAC),
    (0x2AAF, 0x2AB0), (0x2AB0, 0x2AAF), (0x2AB1, 0x2AB2), (0x2AB2, 0x2AB1), (0x2AB3, 0x2AB4),
    (0x2AB4, 0x2AB3), (0x2AB5, 0x2AB6), (0x2AB6, 0x2AB5), (0x2AB7, 0x2AB8), (0x2AB8, 0x2AB7),
    (0x2AB9, 0x2ABA), (0x2ABA, 0x2AB9), (0x2ABB, 0x2ABC), (0x2ABC, 0x2ABB), (0x2ABD, 0x2ABE),
    (0x2ABE, 0x2ABD), (0x2ABF, 0x2AC0), (0x2AC0, 0x2ABF), (0x2AC1, 0x2AC2), (0x2AC2, 0x2AC1),
    (0x2AC3, 0x2AC4), (0x2AC4, 0x2AC3), (0x2AC5, 0x2AC6), (0x2AC6, 0x2AC5), (0x2AC7, 0x2AC8),
    (0x2AC8, 0x2AC7), (0x2AC9, 0x2ACA), (0x2ACA, 0x2AC9), (0x2ACB, 0x2ACC), (0x2ACC, 0x2ACB),
    (0x2ACD, 0x2ACE), (0x2ACE, 0x2ACD), (0x2ACF, 0x2AD0), (0x2AD0, 0x2ACF), (0x2AD1, 0x2AD2),
    (0x2AD2, 0x2AD1), (0x2AD3, 0x2AD4), (0x2AD4, 0x2AD3), (0x2AD5, 0x2AD6), (0x2AD6, 0x2AD5),
    (0x2ADE, 0x22A6), (0x2AE3, 0x22A9), (0x2AE4, 0x22A8), (0x2AE5, 0x22AB), (0x2AEC, 0x2AED),
    (0x2AED, 0x2AEC), (0x2AEE, 0x2224), (0x2AF7, 0x2AF8), (0x2AF8, 0x2AF7), (0x2AF9, 0x2AFA),
    (0x2AFA, 0x2AF9), (0x2BFE, 0x221F), (0x2E02, 0x2E03), (0x2E03, 0x2E02), (0x2E04, 0x2E05),
    (0x2E05, 0x2E04), (0x2E09, 0x2E0A), (0x2E0A, 0x2E09), (0x2E0C, 0x2E0D), (0x2E0D, 0x2E0C),
    (0x2E1C, 0x2E1D), (0x2E1D, 0x2E1C), (0x2E20, 0x2E21), (0x2E21, 0x2E20), (0x2E22, 0x2E23),
    (0x2E23, 0x2E22), (0x2E24, 0x2E25), (0x2E25, 0x2E24), (0x2E26, 0x2E27), (0x2E27, 0x2E26),
    (0x2E28, 0x2E29), (0x2E29, 0x2E28), (0x3008, 0x3009), (0x3009, 0x3008), (0x300A, 0x300B),
    (0x300B, 0x300A), (0x300C, 0x300D), (0x300D, 0x300C), (0x300E, 0x300F), (0x300F, 0x300E),
    (0x3010, 0x3011), (0x3011, 0x3010), (0x3014, 0x3015), (0x3015, 0x3014), (0x3016, 0x3017),
    (0x3017, 0x3016), (0x3018, 0x3019), (0x3019, 0x3018), (0x301A, 0x301B), (0x301B, 0x301A),
    (0xFE59, 0xFE5A), (0xFE5A, 0xFE59), (0xFE5B, 0xFE5C), (0xFE5C, 0xFE5B), (0xFE5D, 0xFE5E),
    (0xFE5E, 0xFE5D), (0xFE64, 0xFE65), (0xFE65, 0xFE64), (0xFF08, 0xFF09), (0xFF09, 0xFF08),
    (0xFF1C, 0xFF1E), (0xFF1E, 0xFF1C), (0xFF3B, 0xFF3D), (0xFF3D, 0xFF3B), (0xFF5B, 0xFF5D),
    (0xFF5D, 0xFF5B), (0xFF5F, 0xFF60), (0xFF60, 0xFF5F), (0xFF62, 0xFF63), (0xFF63, 0xFF62),
];

#[rustfmt::skip]
const RECORD_INDEX0: [u8; 4352] = [
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
    26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
    50, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
    52, 52, 52, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
    54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
    54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
    54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 56, 57, 57, 57, 58, 59, 60, 61, 62, 63,
    64, 65, 66, 67, 68, 69, 70, 71, 72, 66, 67, 68, 69, 70, 71, 72, 66, 67, 68, 69, 70, 71, 72, 66,
    67, 68, 69, 70, 71, 72, 66, 67, 68, 69, 70, 71, 72, 66, 67, 68, 69, 70, 71, 72, 66, 73, 74, 74,
    74, 75, 76, 76, 76, 76, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
    77, 77, 77, 77, 77, 77, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94,
    95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114,
    115, 116, 117, 117, 117, 118, 119, 120, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 121,
    121, 122, 123, 124, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    125, 126, 127, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 128, 128,
    129, 130, 112, 112, 131, 132, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133,
    133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 134, 135, 135, 135, 136, 137, 138, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 139, 140, 141, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 142, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 143, 144, 145, 146, 147, 148, 149, 150, 151, 151, 152, 112,
    112, 112, 112, 112, 153, 154, 155, 112, 112, 112, 112, 112, 156, 157, 112, 112, 158, 159, 160,
    112, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 173, 173, 174, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 176, 177, 177, 177, 177, 177, 177,
    177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 178, 179, 180, 180, 180, 180, 180, 180, 180,
    180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 181, 182, 182, 182, 182,
    182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182,
    182, 182, 182, 182, 182, 183, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 185,
    185, 186, 184, 184, 184, 184, 187, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188,
    188, 188, 188, 188, 188, 188, 188, 189, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184,
    184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 184, 187, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 190, 191, 192, 192, 192, 192, 192, 192,
    192, 192, 192, 192, 192, 192, 192, 192, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
    112, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193, 193, 193, 193, 193, 194, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 196,
];

#[rustfmt::skip]
const RECORD_INDEX1: [u16; 6304] = [
    0, 1, 0, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 14, 14, 15, 16, 17, 18, 19, 19, 20,
    21, 22, 22, 23, 22, 24, 24, 24, 24, 24, 24, 24, 25, 25, 26, 24, 24, 24, 24, 24, 27, 28, 29, 30,
    31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 40, 41, 40, 40, 40, 40, 40, 40, 40, 42, 43, 44, 40, 45,
    45, 45, 45, 45, 45, 45, 45, 46, 45, 45, 45, 47, 48, 49, 50, 51, 52, 53, 54, 55, 55, 56, 56, 57,
    58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 56, 68, 69, 70, 71, 72, 73, 74, 75, 76, 76, 76, 77, 78,
    79, 80, 81, 82, 83, 84, 84, 84, 84, 84, 84, 85, 85, 85, 85, 85, 85, 86, 86, 86, 86, 87, 88, 86,
    86, 86, 86, 86, 86, 89, 90, 86, 86, 86, 86, 86, 86, 91, 91, 91, 91, 91, 91, 92, 93, 93, 93, 94,
    95, 96, 96, 96, 96, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 106, 106, 107, 108, 105,
    109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 116, 116, 124, 124,
    125, 116, 116, 116, 116, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
    140, 141, 142, 143, 144, 145, 144, 146, 147, 148, 149, 149, 149, 149, 150, 151, 152, 153, 154,
    155, 156, 156, 156, 157, 158, 159, 160, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170,
    171, 172, 173, 173, 173, 173, 173, 173, 174, 175, 176, 177, 174, 178, 179, 180, 181, 182, 183,
    184, 185, 186, 186, 186, 186, 186, 186, 187, 188, 189, 190, 186, 191, 192, 193, 186, 194, 195,
    196, 197, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 212,
    213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 227, 228, 229, 230,
    231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 242, 243, 244, 245, 246, 247, 248,
    249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 255, 259, 260, 261, 262, 263, 264, 265, 266,
    267, 268, 269, 270, 271, 272, 272, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282,
    283, 284, 285, 285, 284, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
    299, 299, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 310, 310, 313,
    314, 311, 315, 316, 317, 318, 319, 320, 321, 322, 323, 323, 323, 323, 324, 325, 326, 327, 328,
    329, 330, 331, 331, 331, 331, 332, 333, 334, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
    343, 343, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 352, 352, 352, 354, 355, 356,
    357, 358, 359, 360, 359, 359, 359, 361, 362, 363, 364, 365, 366, 366, 366, 366, 367, 367, 367,
    367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 367, 379, 380, 381, 382, 383, 383,
    383, 383, 384, 385, 386, 386, 386, 386, 386, 387, 388, 388, 388, 388, 388, 388, 388, 388, 388,
    388, 388, 388, 389, 389, 389, 389, 389, 389, 389, 389, 389, 390, 390, 390, 390, 390, 390, 390,
    390, 390, 390, 390, 391, 391, 391, 391, 391, 391, 391, 391, 391, 392, 393, 392, 391, 391, 391,
    391, 391, 392, 391, 391, 391, 391, 392, 393, 392, 391, 393, 391, 391, 391, 391, 391, 391, 391,
    392, 391, 391, 391, 391, 391, 391, 391, 391, 394, 395, 396, 397, 398, 399, 399, 400, 401, 402,
    402, 402, 402, 402, 402, 402, 402, 402, 402, 403, 404, 405, 406, 406, 406, 406, 406, 406, 406,
    406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406,
    406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406,
    406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406,
    406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 407, 406, 406, 408, 409, 409, 410,
    411, 411, 411, 411, 411, 411, 411, 411, 411, 412, 413, 414, 415, 416, 417, 418, 419, 419, 420,
    421, 422, 422, 423, 424, 425, 426, 427, 428, 429, 429, 429, 429, 429, 429, 430, 431, 432, 433,
    434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 444, 444, 444, 445, 446, 446, 446, 446,
    446, 446, 447, 448, 446, 446, 446, 446, 449, 450, 450, 450, 450, 450, 450, 450, 450, 451, 452,
    453, 454, 454, 455, 456, 457, 458, 459, 460, 461, 462, 462, 462, 463, 464, 465, 466, 466, 466,
    466, 466, 467, 466, 466, 466, 468, 469, 470, 471, 471, 471, 471, 472, 472, 473, 474, 475, 475,
    475, 475, 475, 475, 476, 477, 478, 479, 480, 481, 482, 483, 482, 483, 484, 485, 486, 487, 488,
    489, 489, 489, 489, 489, 489, 489, 490, 491, 491, 491, 491, 491, 492, 493, 494, 495, 496, 497,
    498, 499, 500, 501, 502, 503, 503, 503, 504, 505, 506, 507, 508, 508, 508, 508, 509, 510, 511,
    512, 513, 513, 513, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 522, 522, 523, 524, 525,
    526, 526, 526, 526, 526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 536, 536, 536, 537,
    538, 539, 539, 539, 539, 539, 540, 541, 542, 536, 543, 544, 544, 544, 545, 546, 546, 546, 547,
    548, 549, 550, 551, 551, 551, 552, 553, 554, 554, 554, 554, 554, 554, 554, 554, 554, 554, 554,
    554, 554, 554, 554, 554, 554, 554, 555, 556, 554, 554, 554, 554, 554, 554, 554, 554, 554, 554,
    554, 554, 557, 558, 559, 560, 557, 558, 557, 558, 559, 560, 557, 561, 557, 558, 557, 559, 557,
    562, 557, 562, 557, 562, 563, 564, 565, 566, 567, 568, 557, 569, 570, 571, 572, 573, 574, 575,
    576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594,
    595, 596, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612,
    613, 614, 615, 616, 615, 617, 618, 619, 620, 621, 622, 623, 624, 624, 624, 625, 626, 624, 624,
    624, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 637, 640, 641, 637, 637,
    641, 637, 642, 643, 642, 637, 637, 644, 637, 637, 637, 637, 637, 645, 637, 637, 646, 647, 648,
    649, 650, 651, 652, 653, 653, 653, 653, 653, 653, 653, 653, 654, 646, 655, 656, 657, 658, 658,
    659, 646, 646, 660, 646, 661, 650, 662, 663, 664, 665, 665, 665, 665, 666, 667, 667, 667, 668,
    669, 670, 670, 671, 671, 671, 671, 671, 672, 672, 673, 674, 674, 675, 676, 677, 676, 676, 676,
    676, 678, 671, 679, 680, 680, 680, 680, 680, 680, 680, 680, 680, 681, 680, 680, 680, 680, 682,
    683, 684, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 694, 697, 698, 699,
    700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 711, 704, 712, 713, 714, 715, 716, 717,
    718, 719, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736,
    737, 738, 739, 740, 741, 742, 743, 744, 744, 744, 745, 736, 733, 736, 734, 746, 747, 748, 748,
    748, 749, 750, 751, 751, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752,
    752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 752, 753,
    753, 753, 753, 753, 753, 754, 753, 753, 753, 753, 753, 753, 753, 753, 753, 755, 756, 757, 758,
    759, 759, 759, 759, 759, 759, 759, 760, 759, 759, 759, 761, 762, 762, 762, 762, 762, 762, 762,
    762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762, 762,
    762, 762, 762, 762, 762, 762, 763, 764, 764, 765, 764, 764, 766, 766, 767, 768, 769, 770, 764,
    764, 771, 764, 764, 764, 772, 764, 764, 764, 764, 764, 764, 764, 764, 764, 764, 764, 764, 764,
    773, 773, 773, 773, 773, 774, 775, 775, 775, 775, 775, 776, 777, 778, 779, 780, 781, 781, 781,
    781, 781, 781, 781, 781, 781, 781, 781, 781, 782, 783, 784, 785, 786, 786, 786, 786, 787, 788,
    789, 789, 789, 789, 789, 789, 789, 790, 791, 792, 793, 793, 794, 795, 794, 794, 794, 794, 794,
    794, 794, 794, 796, 796, 796, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808,
    808, 808, 808, 808, 809, 809, 809, 810, 809, 809, 809, 809, 809, 809, 809, 809, 809, 809, 811,
    812, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813, 813,
    813, 813, 813, 813, 813, 813, 813, 813, 814, 815, 173, 173, 816, 817, 818, 819, 820, 821, 822,
    823, 824, 825, 826, 827, 828, 828, 829, 828, 828, 828, 830, 831, 832, 833, 834, 835, 836, 836,
    837, 836, 836, 836, 838, 839, 840, 841, 842, 843, 843, 843, 843, 843, 844, 845, 845, 845, 845,
    845, 845, 845, 845, 845, 845, 846, 847, 848, 849, 849, 849, 849, 850, 850, 850, 850, 851, 852,
    853, 853, 854, 854, 854, 855, 856, 857, 858, 858, 858, 859, 860, 861, 854, 854, 854, 862, 856,
    857, 863, 864, 858, 858, 865, 861, 858, 866, 867, 867, 867, 867, 867, 868, 869, 869, 869, 869,
    869, 869, 869, 869, 869, 869, 869, 870, 870, 870, 871, 872, 870, 870, 870, 870, 870, 870, 870,
    870, 870, 870, 870, 873, 870, 870, 870, 871, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874,
    874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874,
    874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874,
    874, 874, 874, 874, 874, 874, 874, 874, 875, 875, 875, 875, 875, 875, 875, 875, 876, 876, 876,
    876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876,
    876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876,
    876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876,
    876, 876, 876, 877, 878, 878, 879, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878,
    878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878,
    878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878,
    878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878, 878,
    878, 878, 878, 878, 878, 878, 878, 878, 878, 880, 881, 881, 881, 881, 881, 881, 882, 883, 884,
    884, 884, 884, 884, 885, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886,
    886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886,
    887, 886, 886, 888, 889, 890, 890, 891, 891, 891, 891, 891, 892, 893, 894, 891, 891, 891, 895,
    896, 896, 896, 896, 896, 896, 896, 896, 897, 898, 899, 900, 901, 902, 903, 904, 905, 906, 907,
    906, 906, 906, 906, 906, 906, 906, 908, 909, 906, 910, 911, 906, 906, 912, 913, 906, 914, 915,
    916, 916, 916, 916, 917, 918, 919, 920, 921, 921, 922, 923, 924, 925, 926, 926, 926, 926, 926,
    926, 927, 928, 929, 930, 930, 930, 930, 930, 931, 932, 933, 934, 935, 936, 937, 937, 938, 939,
    940, 941, 942, 942, 943, 944, 945, 945, 946, 947, 948, 949, 950, 950, 950, 951, 952, 953, 953,
    953, 953, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 964, 964, 964, 964, 965,
    966, 967, 968, 969, 970, 971, 972, 972, 973, 974, 975, 975, 975, 975, 975, 975, 976, 977, 978,
    979, 979, 980, 981, 982, 983, 984, 985, 985, 985, 986, 987, 987, 988, 988, 988, 988, 988, 989,
    990, 991, 992, 992, 992, 992, 992, 992, 992, 992, 992, 992, 993, 993, 993, 993, 994, 995, 996,
    997, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999,
    1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999,
    998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000,
    999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998,
    999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999,
    999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999,
    999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999,
    999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999,
    1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999,
    998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000,
    999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998,
    999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1000, 999,
    999, 999, 998, 999, 999, 1000, 999, 999, 999, 999, 999, 999, 998, 999, 999, 1000, 999, 999,
    999, 998, 999, 999, 1000, 999, 999, 999, 998, 999, 999, 1001, 1002, 1003, 1003, 1004, 1005,
    1006, 1006, 1006, 1006, 1006, 1007, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
    1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
    1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
    1008, 1008, 1008, 1008, 1008, 1008, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
    1009, 1009, 1009, 1009, 1009, 1009, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
    1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
    1010, 1010, 1010, 1010, 1010, 1010, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
    1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
    1011, 1011, 1011, 1011, 1011, 1011, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
    1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
    1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
    1012, 1012, 1012, 1013, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
    1012, 1014, 1015, 1015, 1015, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024, 1020,
    1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1026, 1027, 1028, 1029,
    1030, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025,
    1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025,
    1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1031, 1029, 1029,
    1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1032, 1025, 1025, 1025, 1025, 1025, 1025, 1029,
    1029, 1029, 1029, 1029, 1025, 1033, 1034, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042,
    1043, 1044, 1045, 1046, 1047, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
    1048, 1048, 1048, 1048, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1055, 1056, 1057, 1058,
    1058, 1059, 1060, 1061, 1062, 1063, 1063, 1063, 1063, 1064, 1065, 1065, 1065, 1066, 1067, 1067,
    1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 1073, 1073, 1075, 1073, 1073, 1076, 1073, 1077,
    1073, 1077, 1078, 1078, 1078, 1078, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079,
    1079, 1079, 1079, 1079, 1079, 1080, 1081, 1082, 1082, 1082, 1082, 1082, 1083, 1084, 1085, 1085,
    1085, 1085, 1085, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1093, 1093, 1093, 1093,
    1094, 1094, 1094, 1094, 1094, 1095, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 1096, 1096, 1096, 1097, 1098, 1098, 1098, 1098, 1098, 1098, 1099, 1100,
    1101, 1102, 1102, 1103, 1104, 1104, 1104, 1104, 1105, 1106, 1107, 1107, 1108, 1109, 1110, 1110,
    1110, 1110, 1111, 1112, 1113, 1113, 1113, 1114, 1115, 1115, 1115, 1115, 1116, 1115, 1117, 1118,
    173, 173, 173, 173, 1119, 1119, 1119, 1119, 1119, 1120, 1120, 1120, 1120, 1120, 1121, 1121,
    1121, 1121, 1121, 1121, 1122, 1122, 1122, 1123, 1124, 1125, 1126, 1126, 1126, 1126, 1127, 1128,
    1128, 1128, 1128, 1129, 1130, 1130, 1130, 1130, 1130, 1131, 1132, 1132, 1132, 1132, 1132, 1132,
    1133, 1134, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135,
    1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135,
    1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 1136, 1137, 1135, 1135, 1138, 1137, 1135, 1137,
    1137, 1137, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    1139, 1140, 1141, 1141, 1141, 1141, 1142, 1143, 1144, 1144, 1145, 1146, 1147, 1147, 1148, 1149,
    1150, 1150, 1150, 1151, 1152, 1153, 173, 173, 173, 173, 173, 173, 1154, 1154, 1155, 1156, 1157,
    1157, 1158, 1159, 1160, 1160, 1160, 1161, 173, 173, 173, 173, 173, 173, 173, 173, 1162, 1162,
    1162, 1162, 1163, 1163, 1163, 1164, 1165, 1165, 1166, 1165, 1165, 1165, 1165, 1165, 1167, 1168,
    1169, 1170, 1171, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1178, 1178, 1179, 1180, 1180,
    1180, 1181, 173, 173, 173, 173, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 1190,
    1190, 1190, 1190, 1190, 1191, 1192, 1193, 1193, 1194, 1195, 1196, 1196, 1197, 1198, 1199, 1200,
    1201, 1202, 1203, 1204, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1205, 1205, 1205,
    1205, 1205, 1205, 1205, 1205, 1205, 1206, 173, 173, 173, 173, 173, 173, 1207, 1207, 1207, 1207,
    1207, 1207, 1208, 1209, 1210, 1210, 1210, 1210, 1210, 1210, 1211, 1212, 1213, 1214, 1214, 1214,
    1215, 1216, 1217, 1218, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 1219, 1219, 1219, 1220, 1221, 1221, 1221, 1221, 1221, 1222, 1223, 1224, 173,
    173, 173, 173, 173, 173, 173, 173, 1225, 1225, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232,
    1233, 1234, 1235, 1235, 173, 173, 173, 173, 173, 173, 173, 173, 1236, 1237, 1238, 1239, 1240,
    1240, 1241, 1241, 1242, 1243, 1244, 1245, 1245, 1245, 1245, 1245, 1245, 1246, 1247, 1248, 1249,
    1250, 1251, 1252, 1253, 1254, 1255, 1256, 1256, 1256, 1256, 1256, 1257, 1258, 1259, 1260, 1261,
    1261, 1261, 1262, 1263, 1264, 1265, 1266, 1266, 1266, 1267, 1268, 1269, 1270, 1271, 1272, 1273,
    1273, 1273, 1273, 1274, 1275, 1276, 1277, 1277, 1277, 1277, 1277, 1278, 1279, 1280, 1281, 1282,
    1283, 1284, 1285, 1286, 1287, 1288, 1288, 1289, 1288, 1288, 1290, 1291, 1292, 1293, 1293, 173,
    173, 173, 173, 173, 173, 1294, 1295, 1296, 1297, 1296, 1298, 1299, 1299, 1299, 1299, 1299,
    1300, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 1308, 1308, 1309, 1310, 1311, 1312, 1313, 1314,
    1315, 1316, 1317, 1317, 1318, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 1319, 1319, 1319, 1319, 1319, 1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326,
    1327, 1327, 1327, 1328, 1329, 1329, 1329, 1329, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    1336, 1336, 1336, 1336, 1336, 1337, 1338, 1339, 1340, 1341, 1342, 1343, 1344, 1344, 1344, 1344,
    1345, 1345, 1345, 1345, 1345, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1354,
    1355, 1355, 1355, 1355, 1355, 1356, 1357, 1358, 1359, 1360, 173, 173, 173, 173, 173, 173, 1361,
    1361, 1361, 1362, 1363, 1364, 1365, 1366, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1367, 1367, 1367, 1367,
    1367, 1368, 1369, 1370, 1371, 1371, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1372,
    1372, 1372, 1372, 1373, 1373, 1373, 1373, 1374, 1375, 1376, 1377, 1378, 1379, 1380, 1381, 1381,
    1381, 1382, 1383, 1384, 1385, 1386, 1387, 173, 173, 173, 173, 173, 173, 173, 173, 1388, 1389,
    1388, 1388, 1388, 1388, 1390, 1391, 1392, 1393, 1393, 1393, 1394, 1395, 1396, 1396, 1396, 1396,
    1397, 1398, 1399, 1400, 1401, 1402, 1403, 1403, 1403, 1403, 1404, 1405, 1406, 1407, 1408, 1409,
    173, 173, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1411, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 1412, 1413, 1412, 1412, 1412, 1414, 1415, 1416, 1417, 1418, 1419,
    1420, 1421, 1422, 1423, 1424, 1424, 1424, 1425, 1426, 1426, 1427, 1428, 1429, 173, 173, 173,
    173, 173, 173, 173, 173, 1430, 1431, 1432, 1432, 1432, 1432, 1433, 1434, 1435, 1436, 1437,
    1438, 1439, 1440, 1441, 1441, 1441, 1442, 1443, 1444, 1445, 1446, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1447, 1447, 1448, 1449, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 1450, 1451, 1452, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1459, 1459, 1459,
    1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
    1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
    1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1460,
    1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 1463, 1464, 1465, 1466, 1466, 1466, 1466,
    1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
    1466, 1466, 1466, 1466, 1467, 1468, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
    1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
    1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
    1469, 1469, 1469, 1469, 1470, 1469, 1469, 1469, 1469, 1471, 1472, 1469, 1469, 1469, 1469, 1469,
    1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
    1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1473, 1469, 1469, 1469, 1469, 1469, 1469, 1469,
    1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1469, 1474, 1475,
    1476, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477,
    1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477,
    1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477,
    1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1478, 1477,
    1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1479, 1480, 1480,
    1480, 1480, 1480, 1480, 1480, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
    1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
    1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1482, 1483, 1483, 1483, 1484, 1485,
    1486, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1487, 1487, 1487, 1488, 1489,
    1490, 1491, 1491, 1491, 1491, 1491, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1499,
    1500, 1499, 1499, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 1501, 1501, 1501, 1501, 1502, 1502, 1502, 1502, 1503, 1503,
    1504, 1505, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1506, 1506, 1506, 1506,
    1506, 1506, 1506, 1506, 1507, 1508, 1509, 1510, 1510, 1510, 1510, 1510, 1510, 1511, 1512, 1513,
    173, 173, 173, 173, 173, 173, 173, 173, 1514, 1515, 1516, 1515, 1517, 1517, 1517, 1517, 1517,
    1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517,
    1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517,
    1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517,
    1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1517, 1518, 1519, 1519, 1519, 1519, 1519,
    1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519,
    1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1519, 1520, 1520, 1520, 1520, 1520,
    1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520,
    1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520,
    1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520, 1520,
    1520, 1520, 1520, 1520, 1520, 1521, 1522, 1522, 1522, 1522, 1522, 1523, 1524, 1525, 1525, 1525,
    1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1526, 1527, 1527, 1527, 1527, 1527,
    1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527,
    1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 1528, 1528, 1528, 1529, 1530, 1530,
    1531, 1531, 1531, 1531, 1532, 1531, 1533, 1531, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
    1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
    1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
    1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1535, 1536, 1536, 1536, 1536, 1536, 1536,
    1536, 1536, 1536, 1536, 1536, 1536, 1536, 1537, 1536, 1538, 1536, 1539, 1536, 1540, 1541, 1542,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
    1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
    1543, 1543, 1543, 1543, 1543, 1543, 1543, 1544, 1545, 1546, 1546, 1546, 1546, 1547, 1548, 1546,
    1546, 1546, 1546, 1546, 1546, 1549, 1550, 1551, 1552, 1553, 1554, 1546, 1546, 1546, 1555, 1546,
    1546, 1546, 1546, 1546, 1546, 1546, 1556, 1557, 1557, 1558, 1558, 1558, 1558, 1558, 1558, 1558,
    1558, 1559, 1560, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 1561, 1561, 1562, 1563, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
    1564, 1565, 1566, 1567, 1567, 1567, 1568, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 1569, 1569, 1569, 1570, 1571, 1571, 1572, 1569, 1569, 1573, 1574,
    1571, 1571, 1569, 1569, 1569, 1570, 1571, 1571, 1575, 1576, 1577, 1573, 1578, 1579, 1571, 1569,
    1569, 1569, 1570, 1571, 1571, 1580, 1581, 1582, 1583, 1571, 1571, 1571, 1584, 1585, 1586, 1587,
    1571, 1571, 1572, 1569, 1569, 1573, 1571, 1571, 1571, 1569, 1569, 1569, 1570, 1571, 1571, 1572,
    1569, 1569, 1573, 1571, 1571, 1571, 1569, 1569, 1569, 1570, 1571, 1571, 1572, 1569, 1569, 1573,
    1571, 1571, 1571, 1569, 1569, 1569, 1570, 1571, 1571, 1588, 1569, 1569, 1569, 1589, 1571, 1571,
    1590, 1591, 1569, 1569, 1592, 1571, 1571, 1593, 1572, 1569, 1569, 1594, 1571, 1571, 1595, 1596,
    1569, 1569, 1597, 1571, 1571, 1571, 1598, 1569, 1569, 1569, 1589, 1571, 1571, 1590, 1599, 1600,
    1600, 1600, 1600, 1600, 1600, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601,
    1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601, 1601,
    1601, 1601, 1601, 1601, 1601, 1602, 1602, 1602, 1602, 1602, 1602, 1603, 1604, 1602, 1602, 1602,
    1602, 1602, 1605, 1606, 1601, 1607, 1608, 1609, 1610, 1611, 1602, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 1612, 1613, 1613, 1614, 1615, 1616, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1617,
    1617, 1617, 1617, 1617, 1618, 1619, 1620, 1621, 1622, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    1623, 1623, 1623, 1623, 1623, 1624, 1625, 1626, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
    1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
    1628, 1629, 1630, 1631, 173, 173, 173, 173, 1632, 1632, 1632, 1632, 1633, 1634, 1634, 1634,
    1635, 1636, 1637, 1638, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 1639, 1640, 1640, 1640, 1640, 1640, 1640, 1641, 1642, 1643, 173, 173, 173, 173, 173, 173,
    173, 173, 1644, 1645, 1645, 1645, 1645, 1646, 1645, 1647, 1648, 1648, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 1649,
    1650, 1650, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1651, 1657, 1651, 1653, 1653, 1658, 1650,
    1659, 1650, 1660, 1661, 1659, 1650, 1660, 1662, 1662, 1662, 1662, 1662, 1662, 1663, 1662, 1664,
    1665, 1665, 1665, 1665, 1666, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667,
    1667, 1668, 1669, 1670, 1671, 1672, 1670, 1672, 1673, 1672, 1670, 1670, 1670, 1674, 1675, 1676,
    1677, 1678, 1678, 1678, 1679, 1680, 1680, 1680, 1681, 1680, 1680, 1680, 1682, 1683, 1684, 1680,
    1685, 1686, 1687, 1678, 1688, 1689, 1689, 1689, 1689, 1689, 1689, 1690, 1691, 1691, 1691, 1692,
    1693, 1694, 1695, 1694, 1696, 1697, 1698, 1694, 1699, 1700, 1693, 1701, 1693, 1693, 1693, 1693,
    1693, 1693, 1693, 1693, 1693, 1693, 1693, 1693, 1693, 1693, 1693, 1693, 1693, 1693, 1693, 1702,
    1702, 1702, 1702, 1703, 1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702, 1704,
    1702, 1705, 1706, 1702, 1702, 1707, 1708, 1709, 1710, 1702, 1702, 1702, 1702, 1711, 1712, 1702,
    1702, 1702, 1702, 1702, 1702, 1702, 1702, 1713, 1714, 1715, 1702, 1716, 1714, 1714, 1717, 1718,
    1719, 1720, 1702, 1721, 1722, 1723, 1702, 1702, 1702, 1702, 1702, 1702, 1702, 1702, 1724, 1725,
    1702, 1726, 1727, 1728, 1702, 1729, 1730, 1731, 1732, 1702, 1702, 1702, 1733, 1734, 1735, 1733,
    1736, 1737, 1738, 1739, 1740, 1741, 1742, 1743, 1738, 1744, 1745, 1746, 1747, 1748, 1749, 1750,
    1750, 1750, 1750, 1750, 1750, 1750, 1750, 1751, 1752, 1753, 1753, 1753, 1753, 1754, 1755, 1756,
    1756, 1756, 1756, 1757, 1756, 1758, 1756, 1759, 1760, 1761, 1762, 1763, 1764, 1765, 1766, 1767,
    1767, 1767, 1767, 1767, 1767, 1767, 1767, 1767, 1767, 1767, 1767, 1767, 1767, 1768, 1769, 1770,
    1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1770, 1771, 1772, 1773, 1774, 1775, 1775, 1776,
    1777, 1776, 1776, 1776, 1776, 1776, 1776, 1776, 1778, 1776, 1779, 1776, 1776, 1776, 1776, 1776,
    1778, 1776, 1776, 1776, 1780, 1781, 1778, 1778, 1778, 1778, 1778, 1778, 1778, 1778, 1778, 1782,
    1783, 1784, 1785, 1786, 1784, 1785, 1787, 1788, 1784, 1784, 1784, 1784, 1784, 1789, 1790, 1784,
    1784, 1784, 1784, 1784, 1784, 1791, 1792, 1784, 1793, 1794, 1795, 1784, 1784, 1784, 1784, 1796,
    1796, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1797, 1798, 1799, 1800, 1801, 1802, 1803,
    1804, 1805, 1805, 1805, 1806, 1803, 1804, 1802, 1804, 1803, 1804, 1804, 1804, 1804, 1804, 1807,
    1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807, 1807,
    1807, 1808, 1807, 1807, 1807, 1807, 1807, 1807, 1809, 1810, 1810, 1810, 1810, 1811, 1812, 1813,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813,
    1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1813, 1814, 1815,
    1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815,
    1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815,
    1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815,
    1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1816, 1817, 1817, 1817, 1817, 1818,
    1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    1818, 1818, 1818, 1818, 1818, 1819, 1820, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
    1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821, 1821,
    1821, 1821, 1822, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
    1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
    1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
    1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
    1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823, 1823,
    1823, 1823, 1823, 1824, 1825, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
    1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
    1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
    1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826,
    1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1827, 1828, 1817, 1817, 1817,
    1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
    1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1829,
    1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,
    1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829, 1829,
    1829, 1829, 1830, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
    1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
    1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
    1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1831, 1832,
    1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
    1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832,
    1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1833, 1817, 1817, 1817, 1817, 1817, 1817, 1817,
    1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1817, 1834,
    1835, 1835, 1835, 1836, 1836, 1836, 1836, 1836, 1836, 1836, 1836, 1836, 1836, 1836, 1836, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1837, 1839,
    1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,
    1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,
    1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839,
    1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1839, 1840, 1841,
    1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
    1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
    1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841,
    1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1841, 1842,
];

#[rustfmt::skip]
const RECORD_INDEX2: [u16; 14744] = [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 0, 0, 0, 0, 0, 0, 6, 6, 6, 7, 8, 9, 10, 11, 12, 13,
    14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 26, 27, 27,
    27, 9, 14, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 16, 29, 17,
    30, 31, 30, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 16, 33, 34,
    27, 0, 35, 35, 35, 35, 35, 36, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 37, 38, 39, 40, 40, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 44, 49, 50, 51, 52, 52, 53, 54, 42, 55, 43, 56, 45, 57, 58, 58,
    58, 38, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 60, 59, 59, 59, 59, 59, 59,
    59, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 62, 63, 64, 63, 64, 63, 64,
    63, 64, 64, 63, 64, 63, 64, 63, 64, 63, 64, 64, 63, 64, 63, 64, 63, 64, 63, 63, 64, 63, 64, 63,
    64, 64, 65, 66, 66, 65, 66, 65, 66, 66, 65, 66, 66, 66, 65, 65, 66, 66, 66, 66, 65, 66, 66, 65,
    66, 66, 66, 65, 65, 65, 66, 66, 65, 66, 66, 65, 66, 65, 66, 65, 66, 66, 65, 66, 65, 65, 66, 65,
    66, 66, 65, 66, 66, 66, 65, 66, 65, 66, 66, 65, 65, 67, 66, 65, 65, 65, 67, 67, 67, 67, 66, 68,
    65, 66, 68, 65, 66, 68, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 65,
    66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 65, 66, 68, 65, 66, 65, 66, 66, 66, 65, 66, 65, 65, 65,
    65, 65, 65, 65, 66, 66, 65, 66, 66, 65, 65, 66, 65, 66, 66, 66, 66, 65, 69, 69, 69, 69, 69, 69,
    69, 69, 69, 69, 69, 69, 70, 69, 69, 69, 71, 71, 71, 71, 71, 71, 71, 71, 71, 72, 72, 73, 73, 73,
    73, 73, 73, 73, 74, 74, 74, 74, 72, 75, 76, 75, 75, 75, 76, 75, 72, 72, 77, 73, 74, 74, 74, 74,
    74, 74, 78, 78, 78, 78, 79, 78, 74, 80, 71, 71, 71, 71, 71, 74, 74, 74, 74, 74, 81, 81, 72, 74,
    73, 74, 74, 74, 74, 74, 74, 74, 74, 74, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 83,
    84, 84, 84, 84, 83, 85, 84, 84, 84, 84, 84, 86, 86, 84, 84, 84, 84, 86, 86, 84, 84, 84, 84, 84,
    84, 84, 84, 84, 84, 84, 87, 87, 87, 87, 87, 84, 84, 84, 84, 82, 82, 82, 82, 82, 82, 82, 82, 88,
    82, 84, 84, 84, 82, 82, 82, 84, 84, 89, 82, 82, 82, 84, 84, 84, 84, 82, 83, 84, 84, 82, 90, 91,
    91, 90, 91, 91, 90, 82, 82, 82, 82, 82, 92, 93, 92, 93, 94, 95, 92, 93, 96, 96, 97, 93, 93, 93,
    98, 92, 96, 96, 96, 96, 95, 99, 92, 100, 92, 92, 92, 96, 92, 96, 92, 92, 93, 92, 92, 92, 92,
    92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 96, 92, 92, 92, 92, 92, 92, 92, 92, 92, 93,
    93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 92, 93, 93, 92, 92, 92,
    93, 93, 93, 92, 93, 92, 93, 92, 93, 92, 93, 92, 93, 101, 102, 101, 102, 101, 102, 101, 102,
    101, 102, 101, 102, 101, 102, 93, 93, 93, 93, 92, 93, 103, 92, 93, 92, 92, 93, 93, 92, 92, 92,
    104, 104, 104, 104, 104, 104, 104, 104, 105, 105, 105, 105, 105, 105, 105, 105, 104, 105, 104,
    105, 104, 105, 104, 105, 104, 105, 106, 107, 107, 108, 108, 107, 109, 109, 104, 105, 104, 105,
    104, 105, 104, 104, 105, 104, 105, 104, 105, 104, 105, 104, 105, 104, 105, 104, 105, 105, 110,
    111, 110, 111, 110, 111, 110, 111, 112, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113,
    113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 112, 112, 114, 115, 115, 115, 116, 115,
    117, 118, 118, 118, 118, 118, 118, 118, 118, 118, 119, 120, 112, 112, 121, 121, 122, 123, 124,
    125, 125, 125, 125, 124, 125, 125, 125, 126, 124, 125, 125, 125, 125, 125, 125, 124, 124, 124,
    124, 124, 124, 125, 125, 124, 125, 125, 126, 127, 125, 128, 129, 130, 131, 132, 133, 134, 135,
    136, 137, 137, 138, 139, 140, 141, 142, 143, 144, 145, 143, 125, 124, 146, 136, 123, 123, 123,
    123, 123, 123, 123, 123, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 123, 123, 123,
    123, 147, 147, 147, 147, 148, 149, 123, 123, 123, 150, 150, 150, 150, 150, 151, 152, 152, 153,
    154, 154, 155, 156, 157, 158, 158, 159, 159, 159, 159, 159, 159, 159, 159, 160, 161, 162, 163,
    164, 165, 166, 163, 167, 168, 169, 169, 169, 169, 167, 169, 167, 169, 167, 167, 167, 167, 167,
    169, 169, 169, 169, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 170, 167,
    167, 167, 167, 167, 167, 167, 169, 167, 167, 171, 172, 173, 174, 175, 176, 177, 178, 179, 179,
    180, 181, 159, 159, 159, 159, 159, 181, 159, 159, 181, 182, 182, 182, 182, 182, 182, 182, 182,
    182, 182, 154, 183, 184, 185, 167, 167, 186, 169, 169, 169, 168, 169, 169, 169, 169, 169, 169,
    169, 169, 169, 169, 169, 169, 169, 167, 167, 167, 167, 167, 167, 169, 167, 167, 169, 169, 169,
    169, 169, 169, 169, 169, 169, 167, 169, 167, 169, 167, 167, 169, 169, 166, 169, 159, 159, 159,
    159, 159, 159, 159, 151, 158, 159, 159, 159, 159, 181, 159, 187, 187, 159, 159, 158, 181, 159,
    159, 181, 169, 169, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 167, 167, 167, 189, 189,
    167, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190, 191, 192, 193, 194,
    195, 195, 195, 196, 196, 197, 197, 197, 195, 195, 195, 195, 197, 195, 195, 195, 195, 195, 195,
    195, 195, 195, 197, 195, 196, 195, 197, 195, 195, 196, 198, 199, 198, 198, 199, 198, 198, 199,
    199, 199, 198, 199, 199, 198, 199, 198, 198, 198, 199, 198, 199, 198, 199, 198, 199, 198, 198,
    191, 191, 197, 195, 195, 200, 200, 200, 200, 200, 200, 200, 200, 200, 201, 201, 201, 200, 200,
    200, 200, 200, 200, 200, 201, 201, 200, 200, 200, 200, 201, 200, 201, 201, 200, 200, 200, 201,
    201, 200, 200, 200, 200, 200, 200, 202, 202, 202, 202, 202, 202, 202, 202, 202, 202, 202, 202,
    202, 202, 203, 203, 203, 203, 203, 203, 203, 203, 203, 203, 203, 202, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
    206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 207, 207,
    207, 207, 207, 207, 207, 208, 207, 209, 209, 210, 211, 212, 213, 214, 215, 215, 216, 217, 217,
    218, 218, 218, 218, 218, 218, 218, 218, 218, 218, 218, 218, 218, 218, 219, 219, 219, 219, 220,
    219, 219, 219, 219, 219, 219, 219, 219, 219, 220, 219, 219, 219, 220, 219, 219, 219, 219, 219,
    221, 221, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 222, 221, 223,
    224, 224, 224, 224, 224, 223, 223, 224, 223, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
    223, 224, 223, 223, 223, 225, 225, 225, 226, 226, 227, 226, 228, 229, 228, 228, 228, 228, 229,
    230, 228, 230, 230, 231, 231, 231, 231, 231, 232, 232, 232, 232, 232, 232, 232, 232, 233, 233,
    233, 233, 233, 233, 233, 233, 233, 233, 234, 234, 234, 235, 234, 233, 233, 234, 234, 233, 233,
    236, 233, 233, 233, 234, 233, 233, 233, 233, 233, 233, 236, 236, 236, 236, 236, 236, 236, 236,
    236, 236, 236, 237, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 239,
    237, 238, 238, 237, 238, 238, 237, 238, 238, 238, 237, 237, 237, 240, 241, 242, 238, 238, 238,
    237, 238, 238, 237, 237, 238, 238, 238, 238, 238, 243, 243, 243, 244, 245, 245, 245, 245, 245,
    245, 245, 245, 245, 245, 245, 245, 245, 245, 246, 247, 248, 245, 247, 249, 247, 250, 250, 250,
    250, 246, 246, 246, 246, 247, 247, 247, 247, 251, 249, 247, 252, 253, 254, 255, 255, 246, 250,
    250, 245, 245, 250, 250, 256, 256, 257, 257, 257, 257, 257, 257, 257, 257, 257, 257, 258, 259,
    245, 245, 245, 245, 245, 245, 260, 261, 262, 262, 263, 264, 264, 264, 264, 264, 264, 264, 264,
    263, 263, 264, 264, 263, 263, 264, 264, 264, 264, 264, 264, 264, 264, 264, 264, 264, 264, 264,
    264, 263, 264, 264, 264, 264, 264, 264, 264, 263, 264, 263, 263, 263, 264, 264, 264, 264, 263,
    263, 265, 264, 266, 267, 268, 269, 269, 269, 269, 263, 263, 267, 267, 263, 263, 270, 270, 271,
    272, 263, 263, 263, 263, 263, 263, 263, 263, 266, 263, 263, 263, 263, 264, 264, 263, 264, 264,
    264, 269, 269, 263, 263, 273, 273, 273, 273, 273, 273, 273, 273, 273, 273, 264, 264, 274, 274,
    275, 275, 275, 275, 275, 276, 277, 278, 264, 279, 280, 263, 281, 282, 282, 283, 281, 284, 284,
    284, 284, 284, 284, 281, 281, 281, 281, 284, 284, 281, 281, 284, 284, 284, 284, 284, 284, 284,
    284, 284, 284, 284, 284, 284, 284, 281, 284, 284, 284, 284, 284, 284, 284, 281, 284, 284, 281,
    284, 284, 281, 284, 284, 281, 281, 285, 281, 286, 287, 286, 288, 288, 281, 281, 281, 281, 289,
    289, 281, 281, 289, 289, 290, 281, 281, 281, 291, 281, 281, 281, 281, 281, 281, 281, 284, 284,
    284, 284, 281, 284, 281, 281, 281, 281, 281, 281, 281, 292, 292, 292, 292, 292, 292, 292, 292,
    292, 292, 282, 293, 294, 294, 295, 296, 297, 281, 281, 281, 281, 281, 281, 281, 281, 281, 298,
    299, 299, 300, 298, 301, 301, 301, 301, 301, 301, 301, 301, 301, 298, 301, 301, 301, 298, 301,
    301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 298, 301, 301, 301, 301, 301,
    301, 301, 298, 301, 301, 298, 301, 301, 301, 301, 301, 298, 298, 302, 301, 303, 304, 303, 305,
    305, 305, 305, 306, 298, 306, 306, 307, 298, 303, 303, 308, 298, 298, 309, 298, 298, 298, 298,
    298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 301, 301, 305, 305, 298, 298, 310, 310,
    310, 310, 310, 310, 310, 310, 310, 310, 311, 312, 298, 298, 298, 298, 298, 298, 298, 301, 299,
    299, 299, 313, 313, 313, 314, 315, 316, 316, 314, 317, 317, 317, 317, 317, 317, 317, 317, 314,
    314, 317, 317, 314, 314, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317,
    314, 317, 317, 317, 317, 317, 317, 317, 314, 317, 317, 314, 317, 317, 317, 317, 317, 314, 314,
    318, 317, 319, 320, 321, 322, 322, 322, 322, 314, 314, 323, 324, 314, 314, 324, 324, 325, 314,
    314, 314, 314, 314, 314, 314, 320, 320, 326, 314, 314, 314, 314, 317, 317, 314, 317, 317, 317,
    322, 322, 314, 314, 327, 327, 327, 327, 327, 327, 327, 327, 327, 327, 328, 317, 329, 329, 329,
    329, 329, 329, 314, 314, 314, 314, 314, 314, 314, 314, 330, 330, 331, 332, 330, 333, 333, 333,
    333, 333, 333, 330, 330, 330, 333, 333, 333, 330, 333, 333, 333, 333, 330, 330, 330, 333, 333,
    330, 333, 330, 333, 333, 330, 330, 330, 333, 333, 330, 330, 330, 333, 333, 333, 333, 333, 333,
    333, 333, 333, 333, 330, 330, 330, 330, 334, 335, 336, 335, 335, 330, 330, 330, 337, 337, 337,
    330, 338, 338, 338, 339, 330, 330, 340, 330, 330, 330, 330, 330, 330, 334, 330, 330, 330, 330,
    330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 341, 341, 341, 341, 341, 341, 341, 341, 341,
    341, 342, 342, 342, 343, 343, 343, 343, 343, 343, 344, 343, 330, 330, 330, 330, 330, 345, 346,
    346, 346, 345, 347, 347, 347, 347, 347, 347, 347, 347, 348, 347, 347, 347, 348, 347, 347, 347,
    347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 348, 348, 348, 347, 349, 349,
    349, 350, 350, 350, 350, 348, 349, 349, 351, 348, 349, 349, 349, 352, 348, 348, 348, 348, 348,
    348, 348, 353, 354, 348, 347, 347, 347, 348, 348, 348, 348, 348, 347, 347, 355, 355, 348, 348,
    356, 356, 356, 356, 356, 356, 356, 356, 356, 356, 348, 348, 348, 348, 348, 348, 348, 357, 358,
    358, 358, 358, 358, 358, 358, 359, 360, 361, 362, 362, 363, 360, 360, 360, 360, 360, 360, 360,
    360, 364, 360, 360, 360, 364, 360, 360, 360, 360, 360, 360, 360, 360, 360, 360, 360, 360, 360,
    360, 360, 360, 360, 360, 364, 360, 360, 360, 360, 360, 364, 364, 365, 360, 366, 367, 368, 366,
    369, 366, 366, 364, 367, 368, 368, 364, 368, 368, 370, 371, 364, 364, 364, 364, 364, 364, 364,
    369, 369, 364, 364, 364, 364, 364, 364, 364, 360, 364, 360, 360, 372, 372, 364, 364, 373, 373,
    373, 373, 373, 373, 373, 373, 373, 373, 364, 374, 374, 364, 364, 364, 364, 364, 364, 364, 364,
    364, 364, 364, 364, 364, 375, 375, 376, 376, 377, 377, 377, 377, 377, 377, 377, 377, 377, 378,
    377, 377, 377, 378, 377, 377, 377, 377, 377, 377, 377, 377, 377, 377, 377, 377, 377, 377, 377,
    377, 377, 379, 379, 377, 380, 381, 381, 382, 382, 383, 383, 378, 384, 384, 384, 378, 385, 385,
    385, 386, 387, 388, 378, 378, 378, 378, 389, 389, 389, 380, 390, 390, 390, 390, 390, 390, 390,
    377, 377, 377, 383, 383, 378, 378, 391, 391, 391, 391, 391, 391, 391, 391, 391, 391, 390, 390,
    390, 390, 390, 390, 390, 390, 390, 392, 389, 389, 389, 389, 389, 389, 393, 394, 395, 395, 393,
    396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 393,
    393, 393, 396, 396, 396, 396, 396, 396, 396, 396, 393, 396, 396, 396, 396, 396, 396, 396, 396,
    396, 393, 396, 393, 393, 393, 393, 397, 393, 393, 393, 393, 398, 399, 399, 400, 400, 401, 393,
    401, 393, 399, 402, 403, 402, 403, 403, 403, 398, 393, 393, 393, 393, 393, 393, 404, 404, 404,
    404, 404, 404, 404, 404, 404, 404, 393, 393, 399, 399, 405, 393, 393, 393, 393, 393, 393, 393,
    393, 393, 393, 393, 406, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407, 407,
    407, 407, 407, 407, 407, 407, 407, 407, 408, 407, 409, 407, 410, 409, 409, 409, 409, 411, 411,
    412, 406, 406, 406, 406, 413, 407, 407, 407, 407, 407, 407, 414, 409, 415, 415, 415, 415, 416,
    417, 409, 418, 419, 419, 419, 419, 419, 419, 419, 419, 419, 419, 420, 420, 406, 406, 406, 406,
    406, 406, 406, 406, 406, 406, 406, 406, 421, 422, 422, 421, 422, 421, 422, 422, 422, 422, 422,
    421, 422, 422, 422, 422, 422, 422, 422, 422, 422, 422, 422, 422, 422, 422, 422, 422, 421, 422,
    421, 422, 422, 422, 422, 422, 422, 422, 422, 423, 422, 424, 422, 425, 424, 424, 424, 424, 426,
    426, 427, 424, 428, 422, 421, 421, 422, 422, 422, 422, 422, 421, 429, 421, 430, 430, 430, 430,
    431, 432, 421, 421, 433, 433, 433, 433, 433, 433, 433, 433, 433, 433, 421, 421, 422, 422, 422,
    422, 421, 421, 421, 421, 421, 421, 421, 421, 434, 435, 436, 436, 437, 438, 437, 439, 440, 439,
    439, 441, 440, 442, 442, 442, 442, 442, 440, 443, 442, 443, 443, 443, 444, 444, 443, 443, 443,
    443, 443, 443, 445, 445, 445, 445, 445, 445, 445, 445, 445, 445, 446, 446, 446, 446, 446, 446,
    446, 446, 446, 446, 447, 448, 443, 448, 443, 449, 450, 451, 450, 451, 452, 452, 434, 434, 434,
    434, 434, 434, 434, 434, 453, 434, 434, 434, 434, 434, 434, 434, 434, 434, 434, 434, 434, 453,
    453, 453, 453, 454, 455, 456, 457, 458, 456, 459, 456, 459, 455, 455, 455, 455, 460, 461, 455,
    456, 462, 462, 463, 441, 462, 462, 434, 434, 434, 434, 434, 464, 464, 464, 464, 464, 464, 464,
    464, 464, 464, 464, 453, 464, 464, 464, 464, 464, 464, 464, 464, 464, 464, 464, 464, 453, 447,
    447, 443, 443, 443, 443, 443, 443, 448, 443, 443, 443, 443, 443, 443, 453, 443, 443, 439, 439,
    441, 439, 465, 466, 466, 466, 466, 440, 440, 453, 453, 453, 453, 453, 453, 453, 453, 453, 453,
    453, 453, 453, 467, 467, 467, 467, 467, 467, 467, 467, 467, 468, 468, 468, 468, 468, 468, 468,
    468, 468, 468, 469, 469, 470, 470, 471, 471, 472, 473, 470, 470, 470, 474, 475, 476, 477, 478,
    479, 480, 481, 482, 467, 483, 484, 484, 484, 484, 484, 484, 484, 484, 484, 485, 486, 487, 487,
    488, 489, 467, 467, 468, 468, 468, 468, 490, 490, 471, 471, 467, 467, 467, 467, 491, 491, 482,
    467, 469, 492, 492, 467, 467, 469, 469, 492, 492, 492, 492, 492, 467, 467, 467, 470, 470, 470,
    470, 467, 467, 467, 467, 467, 481, 469, 472, 470, 470, 476, 476, 476, 476, 476, 476, 493, 467,
    476, 484, 484, 484, 484, 484, 484, 484, 484, 484, 484, 476, 476, 494, 470, 495, 495, 496, 496,
    496, 496, 496, 496, 496, 496, 496, 496, 496, 496, 496, 496, 497, 496, 497, 497, 497, 497, 497,
    496, 497, 497, 498, 498, 498, 498, 498, 498, 498, 498, 498, 498, 498, 499, 500, 498, 498, 498,
    501, 501, 501, 501, 501, 501, 501, 501, 502, 502, 502, 502, 502, 502, 502, 502, 503, 503, 503,
    503, 503, 503, 503, 503, 504, 504, 504, 504, 504, 504, 504, 504, 504, 505, 504, 504, 504, 504,
    505, 505, 504, 504, 504, 504, 504, 504, 504, 505, 504, 504, 504, 505, 505, 506, 506, 506, 507,
    508, 507, 507, 507, 507, 507, 507, 507, 509, 509, 509, 509, 509, 509, 509, 509, 509, 509, 509,
    509, 509, 509, 509, 509, 509, 509, 509, 509, 505, 505, 505, 510, 510, 510, 510, 510, 510, 510,
    510, 511, 511, 511, 511, 511, 511, 511, 511, 511, 511, 512, 512, 512, 512, 512, 512, 513, 513,
    513, 513, 513, 513, 513, 513, 513, 513, 513, 513, 513, 513, 514, 514, 515, 515, 515, 515, 515,
    515, 514, 514, 516, 517, 517, 517, 517, 517, 517, 517, 517, 517, 517, 517, 517, 517, 517, 517,
    517, 517, 517, 517, 517, 518, 519, 517, 520, 521, 521, 521, 521, 521, 521, 521, 521, 521, 521,
    521, 521, 521, 521, 521, 521, 521, 521, 522, 523, 524, 524, 524, 525, 525, 525, 525, 525, 525,
    525, 525, 525, 525, 525, 526, 526, 526, 527, 527, 527, 525, 525, 525, 525, 525, 525, 525, 525,
    528, 528, 528, 528, 528, 528, 528, 529, 529, 529, 529, 529, 529, 529, 529, 529, 529, 529, 529,
    529, 530, 529, 529, 529, 529, 531, 532, 533, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530,
    530, 534, 534, 534, 534, 534, 534, 534, 534, 534, 534, 535, 536, 537, 538, 538, 539, 539, 539,
    539, 539, 539, 539, 539, 539, 540, 540, 540, 540, 540, 540, 540, 540, 540, 540, 541, 542, 543,
    543, 543, 543, 543, 543, 543, 543, 543, 543, 543, 543, 544, 544, 544, 544, 544, 544, 544, 544,
    544, 544, 544, 544, 544, 545, 544, 544, 544, 545, 546, 547, 545, 545, 545, 545, 545, 545, 545,
    545, 545, 545, 545, 545, 548, 548, 548, 548, 548, 548, 548, 548, 548, 548, 548, 548, 549, 549,
    550, 551, 551, 551, 551, 552, 552, 552, 550, 550, 550, 553, 553, 553, 550, 550, 554, 555, 550,
    554, 554, 556, 557, 558, 556, 554, 556, 551, 559, 556, 560, 560, 561, 562, 560, 563, 560, 564,
    548, 565, 566, 566, 567, 567, 567, 567, 567, 567, 567, 567, 567, 567, 566, 566, 566, 566, 566,
    566, 568, 568, 568, 568, 568, 568, 568, 568, 568, 568, 566, 566, 566, 566, 566, 566, 569, 570,
    571, 571, 572, 573, 574, 575, 576, 576, 575, 577, 577, 577, 578, 579, 580, 580, 580, 580, 580,
    580, 580, 580, 580, 580, 579, 579, 579, 579, 579, 579, 581, 581, 581, 581, 581, 581, 581, 581,
    581, 581, 581, 582, 583, 583, 583, 583, 583, 583, 583, 583, 583, 583, 583, 583, 583, 579, 579,
    579, 579, 579, 579, 579, 584, 584, 584, 584, 584, 585, 585, 583, 583, 586, 583, 579, 579, 579,
    579, 579, 587, 587, 587, 587, 587, 587, 587, 587, 587, 587, 587, 587, 587, 587, 588, 588, 588,
    588, 588, 588, 588, 588, 588, 588, 589, 590, 590, 590, 590, 590, 590, 590, 590, 590, 590, 590,
    590, 590, 590, 590, 590, 590, 590, 590, 590, 590, 590, 591, 592, 592, 593, 594, 594, 595, 595,
    592, 592, 596, 596, 596, 591, 591, 591, 591, 597, 597, 598, 597, 597, 597, 597, 597, 597, 599,
    600, 601, 591, 591, 591, 591, 602, 591, 591, 591, 603, 603, 604, 604, 604, 604, 604, 604, 604,
    604, 604, 604, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 606, 606,
    605, 605, 605, 605, 605, 606, 606, 606, 606, 606, 606, 606, 606, 606, 606, 606, 607, 607, 607,
    607, 607, 607, 607, 607, 607, 607, 607, 607, 608, 608, 608, 608, 609, 609, 608, 608, 608, 608,
    608, 608, 610, 610, 610, 610, 610, 610, 610, 610, 610, 610, 611, 608, 608, 608, 612, 612, 613,
    613, 613, 613, 613, 613, 613, 613, 614, 614, 614, 614, 614, 614, 614, 614, 614, 614, 614, 614,
    614, 614, 614, 615, 616, 617, 618, 619, 620, 620, 621, 621, 622, 622, 622, 622, 622, 622, 622,
    622, 622, 622, 622, 622, 622, 623, 624, 625, 626, 626, 627, 628, 628, 628, 628, 629, 630, 631,
    632, 631, 631, 632, 632, 632, 632, 633, 633, 632, 633, 634, 635, 635, 635, 635, 635, 632, 636,
    637, 637, 637, 637, 637, 638, 637, 637, 629, 629, 639, 640, 640, 640, 640, 640, 640, 640, 640,
    640, 640, 629, 629, 629, 629, 629, 629, 641, 641, 641, 641, 641, 641, 641, 642, 641, 641, 641,
    641, 641, 641, 629, 629, 643, 643, 643, 643, 643, 644, 644, 644, 644, 644, 644, 643, 643, 644,
    645, 644, 644, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 646, 647,
    647, 647, 648, 649, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650,
    651, 652, 653, 653, 654, 654, 654, 655, 653, 656, 657, 657, 658, 658, 653, 656, 659, 650, 650,
    650, 650, 650, 650, 650, 660, 660, 660, 660, 661, 661, 661, 661, 661, 661, 661, 661, 661, 661,
    662, 662, 663, 662, 662, 662, 662, 664, 664, 664, 664, 664, 664, 664, 664, 664, 664, 665, 666,
    665, 665, 665, 665, 665, 665, 665, 664, 664, 664, 664, 664, 664, 664, 664, 664, 660, 660, 660,
    667, 668, 669, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 671, 672,
    672, 673, 674, 675, 676, 673, 673, 677, 678, 672, 672, 670, 670, 679, 679, 679, 679, 679, 679,
    679, 679, 679, 679, 670, 670, 670, 670, 670, 670, 680, 680, 680, 680, 680, 680, 680, 680, 680,
    680, 680, 680, 680, 680, 681, 682, 683, 683, 682, 682, 682, 683, 682, 683, 684, 684, 685, 685,
    686, 686, 686, 686, 686, 686, 686, 686, 687, 687, 687, 687, 688, 688, 688, 688, 688, 688, 688,
    688, 688, 688, 688, 688, 689, 689, 690, 691, 691, 691, 690, 690, 692, 693, 693, 693, 693, 693,
    693, 693, 694, 694, 695, 696, 697, 697, 697, 698, 698, 698, 698, 698, 699, 699, 699, 699, 699,
    699, 699, 699, 699, 699, 697, 697, 697, 688, 688, 688, 700, 700, 700, 700, 700, 700, 700, 700,
    700, 700, 701, 701, 701, 701, 701, 701, 701, 701, 701, 701, 701, 701, 701, 701, 702, 702, 702,
    702, 702, 702, 703, 703, 704, 704, 704, 704, 704, 704, 704, 704, 704, 705, 705, 705, 705, 705,
    705, 705, 706, 706, 706, 706, 706, 706, 706, 706, 706, 706, 706, 707, 707, 706, 706, 706, 708,
    708, 708, 708, 708, 708, 708, 708, 709, 709, 709, 709, 709, 709, 709, 709, 710, 710, 710, 711,
    712, 713, 713, 713, 713, 713, 710, 710, 713, 713, 713, 713, 710, 714, 715, 715, 715, 715, 715,
    715, 715, 716, 716, 716, 716, 717, 716, 716, 716, 716, 718, 718, 710, 719, 719, 714, 720, 720,
    721, 722, 722, 722, 722, 722, 723, 723, 723, 723, 723, 723, 723, 723, 723, 723, 723, 723, 723,
    723, 724, 724, 724, 724, 724, 725, 726, 726, 726, 726, 726, 726, 726, 726, 726, 726, 726, 726,
    726, 726, 726, 726, 726, 727, 727, 727, 727, 727, 726, 726, 726, 726, 727, 727, 727, 727, 727,
    723, 723, 723, 723, 723, 728, 723, 723, 723, 723, 723, 723, 723, 729, 729, 729, 729, 729, 729,
    729, 729, 729, 729, 729, 730, 730, 730, 730, 730, 730, 730, 730, 730, 730, 730, 730, 730, 730,
    730, 730, 730, 730, 730, 730, 731, 732, 732, 733, 732, 732, 732, 732, 732, 732, 732, 733, 732,
    732, 734, 735, 733, 736, 732, 732, 732, 732, 732, 732, 732, 732, 732, 732, 732, 732, 732, 732,
    732, 732, 732, 732, 732, 732, 732, 737, 738, 738, 733, 739, 740, 741, 733, 732, 733, 742, 743,
    742, 743, 742, 743, 742, 743, 742, 743, 742, 743, 742, 743, 743, 743, 743, 743, 743, 743, 743,
    743, 742, 743, 744, 744, 744, 744, 744, 744, 744, 744, 745, 745, 745, 745, 745, 745, 745, 745,
    744, 744, 744, 744, 744, 744, 746, 746, 745, 745, 745, 745, 745, 745, 746, 746, 746, 745, 746,
    745, 746, 745, 746, 745, 747, 747, 747, 747, 747, 747, 747, 747, 744, 744, 744, 744, 744, 746,
    744, 744, 745, 745, 745, 745, 747, 748, 744, 748, 748, 748, 744, 744, 744, 746, 744, 744, 745,
    745, 745, 745, 747, 748, 748, 748, 744, 744, 744, 744, 746, 746, 744, 744, 745, 745, 745, 745,
    746, 748, 748, 748, 745, 745, 745, 745, 745, 748, 748, 748, 746, 746, 744, 744, 744, 746, 744,
    744, 745, 745, 745, 745, 747, 749, 748, 746, 750, 750, 750, 750, 750, 750, 750, 751, 750, 750,
    750, 752, 753, 754, 755, 756, 757, 758, 759, 759, 760, 761, 762, 763, 764, 765, 766, 767, 767,
    768, 766, 767, 762, 762, 769, 763, 770, 771, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780,
    781, 781, 781, 781, 781, 782, 782, 782, 763, 767, 768, 762, 783, 784, 763, 785, 785, 763, 763,
    763, 786, 787, 788, 784, 784, 783, 763, 763, 763, 763, 763, 763, 763, 763, 789, 763, 785, 763,
    790, 763, 790, 790, 790, 790, 763, 790, 790, 750, 791, 792, 792, 792, 792, 793, 794, 795, 796,
    797, 798, 798, 798, 798, 798, 798, 799, 800, 801, 801, 802, 799, 799, 799, 799, 799, 803, 803,
    804, 805, 806, 807, 799, 808, 802, 802, 802, 799, 799, 799, 799, 799, 803, 803, 804, 805, 806,
    801, 800, 800, 800, 800, 800, 800, 800, 800, 800, 800, 800, 800, 800, 801, 801, 801, 809, 809,
    809, 809, 809, 809, 809, 810, 809, 809, 809, 809, 809, 809, 809, 809, 809, 809, 809, 809, 809,
    809, 810, 809, 809, 809, 809, 810, 809, 809, 810, 809, 811, 811, 811, 811, 811, 811, 811, 811,
    812, 812, 813, 813, 812, 812, 812, 812, 813, 813, 813, 812, 812, 814, 814, 814, 814, 812, 814,
    814, 814, 813, 813, 812, 815, 812, 813, 813, 815, 815, 815, 815, 816, 817, 817, 817, 817, 817,
    817, 817, 817, 817, 817, 817, 817, 817, 817, 817, 818, 818, 819, 820, 818, 821, 818, 819, 818,
    820, 822, 819, 819, 819, 822, 822, 819, 819, 819, 823, 818, 819, 824, 818, 825, 819, 819, 819,
    819, 819, 818, 818, 818, 821, 826, 818, 819, 818, 827, 818, 819, 818, 828, 829, 819, 819, 830,
    822, 819, 819, 828, 819, 822, 831, 831, 831, 831, 832, 818, 818, 822, 822, 819, 819, 825, 825,
    825, 825, 825, 819, 822, 822, 822, 822, 818, 825, 818, 818, 833, 834, 835, 835, 835, 835, 836,
    836, 835, 835, 835, 835, 835, 836, 835, 835, 836, 835, 837, 837, 837, 837, 837, 837, 837, 837,
    837, 837, 837, 837, 838, 838, 838, 838, 837, 837, 838, 838, 838, 838, 838, 838, 838, 838, 838,
    839, 840, 838, 838, 838, 838, 836, 841, 841, 842, 842, 842, 842, 843, 843, 843, 843, 844, 845,
    845, 845, 845, 845, 846, 846, 847, 847, 847, 847, 846, 847, 847, 846, 847, 847, 846, 847, 847,
    848, 848, 847, 847, 847, 846, 847, 847, 847, 847, 847, 847, 847, 847, 847, 847, 847, 847, 847,
    847, 847, 846, 846, 847, 847, 843, 847, 843, 847, 847, 847, 847, 847, 847, 847, 846, 846, 846,
    846, 846, 846, 846, 846, 846, 846, 846, 846, 849, 850, 849, 849, 850, 850, 850, 849, 849, 850,
    850, 849, 850, 850, 850, 849, 850, 849, 851, 852, 850, 849, 850, 850, 850, 850, 849, 850, 850,
    849, 849, 849, 849, 850, 850, 849, 850, 849, 850, 849, 849, 849, 849, 849, 849, 850, 849, 850,
    850, 850, 850, 850, 849, 849, 849, 849, 850, 850, 850, 850, 849, 849, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 849, 850, 850, 850, 849, 850, 850, 850, 850, 850, 849, 850, 850, 850,
    850, 850, 849, 849, 850, 850, 849, 849, 849, 849, 850, 850, 849, 849, 850, 850, 849, 849, 850,
    850, 850, 850, 850, 849, 850, 850, 850, 849, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 849, 850, 850, 850, 850, 850, 850, 850, 853, 854, 854, 854, 854, 854, 854, 854,
    854, 855, 856, 855, 856, 854, 854, 854, 854, 854, 854, 857, 854, 854, 854, 854, 854, 854, 854,
    858, 858, 854, 854, 854, 854, 859, 859, 854, 854, 854, 854, 854, 854, 860, 855, 856, 854, 854,
    854, 854, 854, 854, 854, 854, 854, 854, 854, 861, 861, 861, 861, 861, 861, 861, 861, 861, 861,
    861, 861, 861, 854, 859, 854, 854, 854, 862, 854, 854, 854, 854, 854, 854, 854, 854, 854, 854,
    854, 854, 861, 854, 854, 854, 854, 854, 859, 859, 859, 859, 859, 859, 859, 859, 859, 859, 859,
    859, 859, 859, 859, 859, 859, 854, 854, 854, 854, 854, 854, 854, 854, 854, 854, 854, 860, 854,
    854, 854, 854, 859, 859, 859, 859, 854, 860, 860, 860, 860, 860, 860, 860, 858, 858, 858, 858,
    854, 854, 854, 854, 860, 860, 860, 854, 854, 854, 854, 854, 863, 863, 863, 863, 863, 863, 863,
    863, 863, 863, 863, 863, 863, 863, 863, 864, 864, 864, 864, 864, 864, 864, 864, 864, 865, 865,
    865, 865, 865, 865, 865, 865, 865, 865, 865, 866, 866, 866, 866, 866, 866, 866, 866, 866, 866,
    866, 866, 866, 867, 867, 867, 867, 867, 867, 867, 867, 868, 868, 868, 868, 868, 868, 868, 868,
    868, 868, 868, 868, 869, 869, 869, 869, 869, 869, 869, 869, 869, 869, 869, 869, 869, 869, 869,
    869, 869, 869, 870, 870, 870, 870, 870, 870, 870, 870, 870, 870, 870, 870, 871, 870, 870, 870,
    870, 870, 870, 870, 867, 867, 867, 867, 867, 867, 867, 867, 867, 867, 867, 867, 867, 872, 873,
    873, 873, 873, 873, 873, 873, 873, 873, 873, 873, 873, 874, 874, 874, 874, 873, 873, 873, 873,
    873, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 874, 875, 875, 875, 875, 875, 875, 875,
    875, 876, 876, 875, 875, 875, 875, 876, 876, 876, 876, 876, 876, 876, 876, 876, 876, 877, 877,
    878, 877, 877, 877, 877, 877, 877, 877, 879, 879, 878, 878, 878, 878, 878, 878, 877, 877, 878,
    878, 880, 881, 878, 878, 878, 878, 877, 877, 878, 878, 880, 881, 878, 878, 878, 878, 877, 877,
    877, 878, 878, 877, 882, 878, 877, 877, 877, 877, 878, 878, 878, 878, 878, 878, 878, 878, 878,
    878, 878, 878, 878, 878, 878, 878, 877, 877, 877, 877, 878, 878, 878, 878, 878, 878, 878, 878,
    878, 877, 883, 883, 883, 884, 884, 884, 884, 883, 885, 885, 885, 885, 886, 887, 888, 889, 889,
    887, 889, 889, 889, 889, 890, 887, 889, 886, 889, 891, 885, 885, 887, 887, 885, 889, 892, 892,
    892, 893, 892, 892, 886, 889, 886, 886, 889, 889, 886, 889, 889, 889, 886, 889, 889, 889, 886,
    886, 889, 889, 889, 889, 889, 889, 889, 889, 886, 885, 885, 892, 889, 889, 889, 889, 890, 889,
    890, 889, 889, 889, 889, 889, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 886, 889,
    889, 889, 889, 889, 889, 889, 889, 889, 889, 889, 886, 890, 887, 889, 890, 887, 890, 886, 887,
    885, 887, 887, 889, 887, 887, 889, 894, 889, 889, 889, 886, 889, 889, 886, 885, 889, 889, 889,
    889, 889, 889, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 889, 889, 886, 886, 886, 886,
    886, 886, 889, 886, 889, 886, 886, 889, 887, 887, 886, 886, 889, 889, 889, 889, 889, 886, 889,
    889, 886, 886, 895, 889, 889, 889, 886, 886, 889, 889, 889, 889, 889, 889, 889, 889, 889, 889,
    889, 885, 885, 892, 892, 892, 892, 892, 885, 885, 892, 892, 885, 887, 887, 887, 887, 892, 886,
    885, 892, 885, 887, 885, 885, 887, 887, 887, 892, 892, 887, 887, 892, 887, 887, 892, 892, 892,
    889, 887, 889, 889, 889, 889, 887, 890, 885, 887, 887, 887, 887, 887, 890, 885, 885, 885, 885,
    885, 887, 885, 885, 893, 885, 887, 887, 885, 892, 892, 896, 896, 897, 896, 896, 898, 899, 899,
    897, 897, 900, 900, 900, 900, 901, 898, 901, 901, 898, 899, 898, 899, 898, 899, 899, 899, 899,
    899, 899, 898, 899, 899, 899, 898, 899, 899, 899, 899, 899, 899, 898, 899, 899, 899, 899, 899,
    899, 899, 899, 899, 899, 898, 898, 899, 899, 899, 899, 899, 899, 899, 899, 899, 899, 899, 899,
    899, 899, 899, 898, 899, 899, 898, 899, 899, 899, 899, 898, 899, 898, 899, 899, 899, 899, 898,
    898, 898, 899, 902, 899, 899, 899, 903, 903, 903, 903, 903, 903, 899, 904, 905, 897, 901, 901,
    901, 906, 907, 906, 907, 906, 907, 906, 907, 906, 907, 906, 907, 906, 907, 908, 908, 908, 908,
    908, 908, 908, 908, 908, 908, 908, 908, 908, 908, 899, 898, 898, 898, 899, 899, 899, 899, 899,
    899, 899, 898, 909, 909, 909, 909, 909, 910, 911, 909, 909, 909, 909, 909, 909, 909, 909, 909,
    909, 909, 909, 909, 909, 909, 910, 911, 910, 911, 910, 911, 910, 911, 910, 911, 912, 912, 912,
    912, 912, 912, 912, 912, 913, 913, 913, 913, 913, 913, 913, 913, 914, 914, 914, 914, 914, 914,
    914, 914, 914, 914, 914, 914, 915, 915, 914, 914, 916, 916, 916, 917, 918, 917, 918, 917, 918,
    917, 918, 917, 918, 917, 919, 917, 918, 917, 918, 917, 918, 917, 918, 917, 918, 916, 916, 916,
    916, 916, 916, 916, 916, 916, 916, 916, 916, 916, 916, 916, 917, 918, 917, 918, 916, 916, 916,
    916, 916, 916, 916, 916, 917, 918, 916, 916, 920, 920, 920, 920, 920, 920, 920, 920, 921, 921,
    921, 921, 921, 922, 922, 922, 921, 921, 921, 921, 921, 921, 921, 921, 921, 921, 921, 922, 922,
    921, 921, 921, 923, 923, 923, 923, 923, 923, 923, 923, 923, 923, 923, 923, 923, 921, 921, 923,
    923, 923, 923, 923, 923, 921, 921, 921, 922, 921, 921, 921, 921, 924, 925, 925, 925, 925, 921,
    921, 921, 921, 921, 921, 921, 921, 921, 921, 926, 926, 921, 921, 921, 921, 921, 921, 921, 921,
    926, 921, 927, 927, 927, 927, 927, 927, 927, 927, 927, 927, 927, 927, 927, 927, 927, 928, 929,
    929, 929, 929, 929, 929, 929, 929, 929, 929, 929, 929, 929, 929, 929, 928, 930, 931, 930, 930,
    930, 931, 931, 930, 931, 930, 931, 930, 931, 930, 930, 930, 930, 931, 930, 931, 931, 930, 931,
    931, 931, 931, 931, 931, 932, 932, 930, 930, 933, 934, 933, 934, 933, 934, 933, 934, 933, 934,
    933, 934, 934, 935, 935, 935, 935, 935, 935, 933, 934, 933, 934, 936, 936, 936, 933, 934, 937,
    937, 937, 937, 937, 938, 939, 939, 939, 940, 938, 939, 941, 941, 941, 941, 941, 941, 941, 941,
    941, 941, 941, 941, 941, 941, 942, 941, 942, 942, 942, 942, 942, 941, 942, 942, 943, 943, 943,
    943, 943, 943, 943, 943, 944, 944, 944, 944, 944, 944, 944, 945, 946, 944, 944, 944, 944, 944,
    944, 944, 944, 944, 944, 944, 944, 944, 944, 947, 948, 948, 948, 948, 948, 948, 948, 948, 948,
    948, 948, 948, 948, 948, 948, 949, 949, 949, 949, 949, 949, 949, 949, 949, 950, 950, 950, 950,
    950, 950, 950, 950, 951, 951, 952, 953, 952, 953, 951, 951, 951, 952, 953, 951, 952, 953, 954,
    954, 954, 954, 954, 954, 954, 954, 955, 956, 957, 954, 958, 955, 952, 953, 955, 955, 952, 953,
    959, 960, 959, 960, 959, 960, 959, 960, 954, 954, 954, 954, 961, 962, 954, 954, 955, 954, 954,
    955, 955, 955, 955, 955, 963, 963, 954, 954, 954, 955, 956, 954, 964, 954, 954, 954, 954, 954,
    954, 954, 954, 955, 954, 955, 954, 954, 965, 965, 955, 966, 966, 966, 966, 966, 966, 966, 966,
    966, 966, 966, 966, 966, 967, 967, 967, 967, 967, 967, 967, 967, 967, 967, 968, 967, 967, 967,
    967, 967, 967, 967, 967, 967, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 968, 969,
    969, 969, 969, 969, 969, 969, 969, 969, 969, 969, 969, 969, 969, 970, 970, 970, 970, 970, 970,
    970, 970, 970, 970, 971, 971, 971, 971, 971, 971, 971, 971, 971, 971, 971, 971, 972, 972, 972,
    972, 973, 974, 974, 975, 976, 977, 978, 979, 980, 981, 980, 981, 980, 981, 980, 981, 980, 981,
    976, 976, 980, 981, 980, 981, 980, 981, 980, 981, 982, 983, 984, 984, 976, 979, 979, 979, 979,
    979, 979, 979, 979, 979, 985, 986, 987, 988, 989, 989, 990, 991, 991, 991, 991, 992, 976, 976,
    979, 979, 979, 977, 993, 994, 976, 976, 995, 996, 997, 996, 997, 996, 997, 996, 997, 996, 997,
    997, 997, 997, 997, 997, 997, 997, 997, 997, 997, 997, 997, 997, 997, 997, 997, 996, 997, 997,
    997, 997, 997, 997, 997, 996, 997, 996, 997, 996, 997, 997, 997, 997, 997, 997, 996, 997, 997,
    997, 997, 997, 997, 996, 996, 995, 995, 998, 998, 999, 999, 1000, 1000, 997, 1001, 1002, 1003,
    1002, 1003, 1002, 1003, 1002, 1003, 1002, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
    1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1002, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
    1002, 1003, 1002, 1003, 1002, 1003, 1003, 1003, 1003, 1003, 1003, 1002, 1003, 1003, 1003, 1003,
    1003, 1003, 1002, 1002, 1003, 1003, 1003, 1003, 1004, 1005, 1006, 1006, 1003, 1007, 1007, 1007,
    1007, 1007, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1009, 1010, 1010,
    1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
    1010, 1010, 1010, 1010, 1009, 1011, 1011, 1012, 1012, 1012, 1012, 1011, 1011, 1011, 1011, 1011,
    1011, 1011, 1011, 1011, 1011, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1014, 1014, 1014,
    1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
    1015, 1015, 1015, 1015, 1015, 1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016, 1017, 1017, 1017,
    1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 1018, 1018, 1019, 1020, 1020, 1020,
    1020, 1020, 1020, 1020, 1020, 1020, 1020, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
    1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1023, 1024, 1024,
    1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1017, 1017, 1017,
    1017, 1018, 1018, 1018, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1025, 1021, 1025, 1021,
    1021, 1021, 1021, 1021, 1021, 1021, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1021, 1021, 1021,
    1021, 1023, 1023, 1023, 1023, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026,
    1026, 1026, 1026, 1026, 1021, 1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027, 1028, 1028, 1028,
    1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1029, 1029, 1029, 1029,
    1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1029, 1029, 1030, 1030, 1030,
    1030, 1030, 1030, 1030, 1030, 1031, 1031, 1031, 1031, 1031, 1031, 1031, 1031, 1032, 1032, 1032,
    1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 1033, 1033, 1033, 1034, 1034, 1034,
    1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1035, 1034, 1034, 1034, 1034, 1034,
    1034, 1034, 1036, 1036, 1036, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037,
    1037, 1037, 1037, 1037, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1039, 1039, 1039,
    1039, 1039, 1039, 1039, 1039, 1040, 1040, 1040, 1040, 1040, 1040, 1041, 1041, 1042, 1042, 1042,
    1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1043, 1044, 1045, 1044, 1046, 1046, 1046,
    1046, 1046, 1046, 1046, 1046, 1046, 1046, 1042, 1042, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
    1047, 1047, 1047, 1047, 1047, 1048, 1049, 1048, 1049, 1048, 1049, 1048, 1049, 1048, 1049, 1048,
    1049, 1048, 1049, 1050, 1051, 1052, 1052, 1052, 1053, 1051, 1051, 1051, 1051, 1051, 1051, 1051,
    1051, 1051, 1051, 1053, 1054, 1048, 1049, 1048, 1049, 1055, 1055, 1051, 1051, 1056, 1056, 1056,
    1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 1057, 1057, 1057, 1057, 1057,
    1057, 1057, 1057, 1057, 1057, 1058, 1058, 1059, 1060, 1060, 1060, 1060, 1060, 1061, 1061, 1061,
    1061, 1061, 1061, 1061, 1061, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1063, 1063, 1063,
    1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1064, 1064, 1064, 1064,
    1064, 1064, 1064, 1064, 1064, 1065, 1065, 1066, 1067, 1066, 1067, 1066, 1067, 1066, 1067, 1066,
    1067, 1066, 1067, 1066, 1067, 1067, 1067, 1066, 1067, 1066, 1067, 1066, 1067, 1068, 1067, 1067,
    1067, 1067, 1067, 1067, 1067, 1067, 1066, 1067, 1066, 1067, 1066, 1066, 1067, 1069, 1070, 1070,
    1066, 1067, 1066, 1067, 1071, 1066, 1067, 1066, 1067, 1067, 1067, 1066, 1067, 1066, 1067, 1066,
    1066, 1066, 1066, 1066, 1067, 1066, 1066, 1066, 1066, 1066, 1067, 1066, 1067, 1072, 1072, 1066,
    1067, 1066, 1066, 1066, 1066, 1067, 1066, 1067, 1072, 1072, 1072, 1072, 1072, 1072, 1072, 1072,
    1072, 1072, 1072, 1072, 1072, 1072, 1072, 1072, 1072, 1072, 1066, 1067, 1071, 1068, 1068, 1067,
    1071, 1071, 1071, 1071, 1071, 1073, 1073, 1074, 1073, 1073, 1073, 1075, 1073, 1073, 1073, 1073,
    1076, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073,
    1077, 1077, 1078, 1074, 1077, 1079, 1079, 1079, 1079, 1080, 1081, 1081, 1081, 1082, 1082, 1082,
    1082, 1082, 1082, 1083, 1083, 1084, 1085, 1086, 1086, 1086, 1086, 1086, 1086, 1087, 1087, 1087,
    1087, 1087, 1087, 1087, 1087, 1087, 1087, 1088, 1089, 1090, 1090, 1091, 1091, 1092, 1092, 1092,
    1092, 1092, 1092, 1092, 1092, 1093, 1093, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094,
    1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 1094, 1095, 1096, 1096, 1096, 1096, 1096, 1096,
    1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 1097, 1098, 1099, 1099, 1099, 1099, 1099,
    1099, 1099, 1099, 1100, 1100, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 1099,
    1099, 1099, 1099, 1099, 1099, 1102, 1102, 1102, 1102, 1102, 1102, 1102, 1102, 1102, 1102, 1103,
    1103, 1104, 1104, 1104, 1104, 1105, 1105, 1105, 1104, 1106, 1104, 1103, 1107, 1108, 1108, 1108,
    1108, 1108, 1108, 1108, 1108, 1108, 1108, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109,
    1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1110, 1110, 1110, 1110, 1110,
    1111, 1111, 1111, 1112, 1113, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,
    1114, 1114, 1114, 1114, 1115, 1115, 1115, 1116, 1115, 1115, 1115, 1115, 1117, 1117, 1117, 1118,
    1119, 1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120, 1121, 1122, 1122, 1122,
    1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1123, 1123, 1123, 1124, 1124, 1124,
    1125, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126, 1126,
    1127, 1128, 1128, 1129, 1129, 1130, 1130, 1131, 1131, 1129, 1132, 1133, 1134, 1135, 1136, 1136,
    1136, 1136, 1136, 1136, 1137, 1137, 1137, 1136, 1136, 1136, 1136, 1138, 1139, 1140, 1140, 1140,
    1140, 1140, 1140, 1140, 1140, 1140, 1140, 1138, 1138, 1138, 1138, 1136, 1136, 1141, 1141, 1141,
    1141, 1141, 1142, 1143, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 1144, 1144, 1144,
    1144, 1144, 1144, 1144, 1144, 1144, 1144, 1141, 1141, 1141, 1141, 1141, 1145, 1146, 1146, 1146,
    1146, 1146, 1146, 1146, 1146, 1146, 1147, 1148, 1148, 1148, 1149, 1148, 1150, 1150, 1148, 1149,
    1151, 1152, 1153, 1154, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 1146, 1146, 1146,
    1156, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1156, 1157, 1155, 1155, 1158, 1158, 1158,
    1158, 1158, 1158, 1158, 1158, 1158, 1158, 1155, 1155, 1159, 1160, 1160, 1160, 1161, 1161, 1161,
    1161, 1161, 1161, 1161, 1161, 1162, 1161, 1161, 1161, 1163, 1163, 1163, 1164, 1164, 1164, 1161,
    1165, 1166, 1167, 1168, 1168, 1169, 1169, 1169, 1169, 1169, 1169, 1169, 1169, 1170, 1169, 1170,
    1170, 1171, 1169, 1169, 1170, 1170, 1169, 1169, 1169, 1169, 1169, 1170, 1172, 1169, 1172, 1169,
    1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173, 1173,
    1174, 1174, 1175, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177,
    1178, 1179, 1180, 1178, 1181, 1182, 1182, 1183, 1184, 1184, 1185, 1186, 1187, 1187, 1187, 1187,
    1187, 1187, 1187, 1187, 1187, 1188, 1189, 1189, 1189, 1189, 1189, 1189, 1188, 1188, 1188, 1188,
    1188, 1188, 1188, 1188, 1188, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 1188, 1190, 1190, 1190,
    1190, 1190, 1190, 1190, 1190, 1190, 1190, 1190, 1191, 1192, 1192, 1192, 1192, 1190, 1190, 1190,
    1190, 1190, 1193, 1190, 1190, 1190, 1192, 1194, 1194, 1195, 1195, 1195, 1195, 1196, 1196, 1196,
    1196, 1196, 1196, 1196, 1196, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197,
    1198, 1198, 1199, 1198, 1198, 1200, 1198, 1198, 1201, 1202, 1203, 1204, 1204, 1205, 1205, 1205,
    1205, 1205, 1205, 1205, 1205, 1205, 1205, 1204, 1204, 1204, 1204, 1204, 1204, 1206, 1207, 1207,
    1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207,
    1207, 1206, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 1208, 1208, 1208, 1208, 1208, 1208, 1208,
    1208, 1208, 1208, 1208, 1208, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209,
    1209, 1209, 1209, 1209, 1210, 1210, 1210, 1210, 1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211,
    1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211, 1210, 1210, 1210, 1210, 1212, 1212, 1212,
    1212, 1212, 1212, 1212, 1212, 1213, 1213, 1213, 1213, 1213, 1213, 1213, 1213, 1214, 1214, 1214,
    1214, 1214, 1214, 1214, 1214, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1216, 1216, 1216,
    1216, 1216, 1216, 1216, 1216, 1216, 1216, 1216, 1216, 1216, 1216, 1217, 1217, 1216, 1216, 1217,
    1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1218, 1218, 1218,
    1218, 1218, 1218, 1218, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
    1220, 1220, 1220, 1220, 1220, 1219, 1219, 1219, 1219, 1219, 1221, 1222, 1221, 1221, 1221, 1221,
    1221, 1221, 1221, 1221, 1221, 1221, 1223, 1221, 1221, 1221, 1221, 1221, 1221, 1221, 1221, 1221,
    1221, 1221, 1221, 1221, 1219, 1221, 1221, 1221, 1221, 1221, 1219, 1221, 1219, 1221, 1221, 1219,
    1221, 1221, 1219, 1221, 1221, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1225,
    1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 1225, 1226,
    1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226,
    1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1227, 1228, 1226, 1226, 1224,
    1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 1229, 1230, 1226, 1226, 1231, 1231, 1231,
    1231, 1231, 1231, 1231, 1231, 1232, 1233, 1233, 1234, 1232, 1235, 1235, 1236, 1237, 1238, 1239,
    1239, 1239, 1239, 1239, 1239, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1241, 1241, 1241, 1241,
    1241, 1241, 1241, 1242, 1242, 1243, 1244, 1244, 1245, 1245, 1246, 1247, 1246, 1247, 1246, 1247,
    1246, 1247, 1246, 1247, 1246, 1247, 1246, 1247, 1246, 1247, 1243, 1243, 1246, 1247, 1243, 1243,
    1243, 1243, 1245, 1245, 1245, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1254, 1255, 1256, 1257,
    1256, 1257, 1256, 1257, 1258, 1249, 1249, 1259, 1260, 1261, 1261, 1261, 1251, 1249, 1262, 1263,
    1249, 1251, 1251, 1251, 1251, 1264, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1264, 1264,
    1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1265, 1265, 1266, 1267, 1268, 1269,
    1270, 1271, 1272, 1269, 1273, 1274, 1275, 1269, 1276, 1277, 1278, 1279, 1280, 1281, 1281, 1281,
    1281, 1281, 1281, 1281, 1281, 1281, 1281, 1282, 1283, 1284, 1284, 1284, 1268, 1269, 1285, 1285,
    1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285,
    1274, 1269, 1275, 1286, 1287, 1286, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288,
    1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1274, 1284, 1275, 1284, 1274, 1275, 1289, 1274,
    1275, 1289, 1290, 1291, 1292, 1292, 1292, 1292, 1292, 1292, 1292, 1292, 1292, 1293, 1291, 1291,
    1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291, 1291,
    1291, 1291, 1291, 1294, 1294, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295,
    1295, 1295, 1295, 1295, 1267, 1267, 1267, 1295, 1295, 1295, 1295, 1295, 1295, 1267, 1267, 1295,
    1295, 1295, 1267, 1267, 1267, 1296, 1271, 1284, 1286, 1297, 1271, 1271, 1267, 1298, 1299, 1299,
    1299, 1299, 1298, 1298, 1267, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1301, 1301,
    1301, 1302, 1303, 1304, 1304, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305,
    1305, 1306, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1306, 1305, 1305, 1305,
    1306, 1305, 1305, 1306, 1305, 1305, 1305, 1305, 1305, 1305, 1305, 1306, 1306, 1306, 1306, 1306,
    1306, 1306, 1306, 1306, 1306, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307,
    1308, 1308, 1308, 1308, 1308, 1309, 1310, 1309, 1311, 1311, 1311, 1311, 1312, 1312, 1312, 1312,
    1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 1311, 1311, 1311, 1313, 1313, 1313, 1313,
    1313, 1313, 1313, 1313, 1313, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314,
    1314, 1314, 1315, 1315, 1315, 1315, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316, 1316,
    1316, 1316, 1316, 1316, 1316, 1316, 1316, 1315, 1315, 1316, 1317, 1317, 1318, 1319, 1319, 1319,
    1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 1319, 1320, 1320, 1320, 1321, 1320, 1320,
    1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 1322, 1322, 1322,
    1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1323, 1324, 1324, 1325, 1325, 1325,
    1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 1326, 1326, 1326, 1327, 1327, 1327,
    1327, 1327, 1327, 1327, 1327, 1327, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328, 1328,
    1328, 1328, 1328, 1328, 1328, 1329, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330,
    1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1331, 1331, 1331, 1331, 1332, 1332, 1332,
    1332, 1332, 1332, 1332, 1332, 1333, 1333, 1333, 1333, 1334, 1334, 1334, 1334, 1334, 1334, 1334,
    1334, 1334, 1332, 1332, 1332, 1335, 1335, 1335, 1335, 1335, 1335, 1335, 1335, 1335, 1336, 1335,
    1335, 1335, 1335, 1335, 1335, 1335, 1335, 1336, 1337, 1337, 1337, 1337, 1337, 1338, 1338, 1338,
    1338, 1338, 1338, 1338, 1338, 1338, 1338, 1338, 1338, 1338, 1338, 1339, 1339, 1339, 1339, 1339,
    1340, 1340, 1340, 1340, 1340, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1342, 1343, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344,
    1344, 1345, 1345, 1345, 1345, 1346, 1347, 1347, 1347, 1347, 1347, 1345, 1345, 1345, 1345, 1345,
    1345, 1345, 1345, 1345, 1345, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 1348, 1349, 1349, 1349,
    1349, 1349, 1349, 1349, 1349, 1350, 1350, 1350, 1350, 1350, 1350, 1350, 1350, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1352, 1352, 1353, 1353, 1353,
    1353, 1353, 1353, 1353, 1353, 1353, 1353, 1352, 1352, 1352, 1352, 1352, 1352, 1354, 1354, 1354,
    1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1355, 1355, 1355, 1355, 1356, 1356, 1356,
    1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1355, 1355, 1355, 1355, 1357, 1357, 1357,
    1357, 1357, 1357, 1357, 1357, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1359, 1359, 1359,
    1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
    1360, 1360, 1360, 1360, 1361, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362,
    1362, 1362, 1362, 1362, 1363, 1363, 1363, 1363, 1363, 1363, 1363, 1363, 1363, 1362, 1362, 1362,
    1362, 1362, 1362, 1363, 1363, 1364, 1364, 1364, 1364, 1364, 1364, 1365, 1365, 1364, 1365, 1364,
    1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364,
    1364, 1364, 1364, 1365, 1364, 1364, 1365, 1365, 1365, 1364, 1365, 1365, 1364, 1366, 1366, 1366,
    1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 1367, 1368, 1369, 1369, 1369,
    1369, 1369, 1369, 1369, 1369, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370,
    1370, 1370, 1370, 1370, 1371, 1371, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1373, 1373, 1373,
    1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1374, 1374, 1374, 1374,
    1374, 1374, 1374, 1374, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1376, 1376, 1376,
    1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 1377, 1376, 1376, 1377, 1377, 1377, 1377, 1377,
    1378, 1378, 1378, 1378, 1378, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
    1379, 1379, 1379, 1380, 1380, 1380, 1380, 1380, 1380, 1381, 1381, 1381, 1382, 1383, 1383, 1383,
    1383, 1383, 1383, 1383, 1383, 1383, 1383, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1386, 1386,
    1386, 1386, 1386, 1386, 1386, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1388, 1388,
    1388, 1389, 1389, 1387, 1387, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1388, 1388, 1389,
    1389, 1389, 1389, 1389, 1389, 1390, 1391, 1391, 1391, 1392, 1393, 1391, 1392, 1392, 1392, 1392,
    1392, 1394, 1395, 1396, 1397, 1390, 1390, 1390, 1390, 1392, 1390, 1390, 1390, 1392, 1390, 1390,
    1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390,
    1390, 1390, 1390, 1392, 1392, 1398, 1399, 1400, 1392, 1392, 1392, 1392, 1401, 1402, 1402, 1402,
    1402, 1402, 1402, 1402, 1402, 1402, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1403, 1403, 1403,
    1403, 1403, 1403, 1403, 1403, 1404, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1405, 1405, 1405,
    1405, 1405, 1405, 1405, 1405, 1405, 1405, 1405, 1405, 1405, 1406, 1406, 1407, 1408, 1408, 1408,
    1408, 1408, 1408, 1408, 1408, 1408, 1408, 1408, 1408, 1408, 1409, 1409, 1409, 1410, 1410, 1410,
    1410, 1410, 1411, 1412, 1411, 1413, 1411, 1411, 1412, 1412, 1414, 1411, 1411, 1411, 1411, 1411,
    1410, 1410, 1410, 1410, 1414, 1410, 1410, 1410, 1410, 1410, 1411, 1410, 1410, 1410, 1411, 1412,
    1412, 1411, 1415, 1416, 1417, 1417, 1417, 1417, 1418, 1418, 1418, 1418, 1419, 1420, 1420, 1420,
    1420, 1420, 1420, 1421, 1417, 1417, 1417, 1417, 1417, 1417, 1417, 1417, 1417, 1422, 1422, 1422,
    1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 1423, 1423, 1423, 1424, 1424,
    1424, 1424, 1424, 1424, 1424, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425,
    1425, 1425, 1425, 1426, 1426, 1427, 1427, 1427, 1427, 1427, 1427, 1427, 1427, 1428, 1428, 1428,
    1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1429, 1429, 1429, 1429, 1429, 1430, 1430, 1430,
    1430, 1430, 1430, 1430, 1430, 1431, 1432, 1431, 1432, 1432, 1432, 1431, 1431, 1431, 1432, 1431,
    1431, 1432, 1431, 1432, 1432, 1431, 1432, 1433, 1433, 1433, 1433, 1433, 1433, 1433, 1434, 1434,
    1434, 1434, 1433, 1433, 1433, 1433, 1433, 1433, 1433, 1433, 1433, 1433, 1433, 1433, 1435, 1435,
    1435, 1435, 1436, 1436, 1437, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1439, 1439,
    1439, 1439, 1439, 1439, 1439, 1440, 1440, 1440, 1440, 1440, 1440, 1440, 1440, 1440, 1440, 1440,
    1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1442, 1442, 1442,
    1442, 1442, 1442, 1442, 1442, 1442, 1442, 1442, 1441, 1441, 1441, 1441, 1441, 1441, 1441, 1443,
    1443, 1443, 1443, 1443, 1443, 1444, 1445, 1445, 1445, 1445, 1445, 1445, 1445, 1445, 1445, 1445,
    1445, 1445, 1445, 1445, 1445, 1445, 1445, 1446, 1445, 1447, 1447, 1447, 1448, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450, 1449,
    1449, 1449, 1449, 1449, 1449, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1452, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1454,
    1455, 1455, 1456, 1454, 1454, 1453, 1453, 1454, 1454, 1454, 1454, 1454, 1454, 1454, 1454, 1454,
    1454, 1454, 1454, 1454, 1454, 1457, 1457, 1457, 1457, 1457, 1457, 1457, 1457, 1457, 1457, 1457,
    1457, 1457, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1457, 1459, 1459, 1459,
    1459, 1459, 1459, 1459, 1459, 1460, 1460, 1460, 1461, 1460, 1460, 1460, 1460, 1460, 1460, 1460,
    1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1462, 1463, 1463, 1464, 1464, 1464,
    1463, 1464, 1463, 1463, 1463, 1463, 1465, 1465, 1465, 1466, 1467, 1467, 1467, 1467, 1467, 1468,
    1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468, 1468, 1469, 1470, 1469,
    1469, 1471, 1471, 1471, 1470, 1469, 1471, 1471, 1469, 1469, 1471, 1469, 1469, 1470, 1469, 1471,
    1471, 1469, 1472, 1472, 1472, 1472, 1473, 1474, 1475, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
    1476, 1476, 1476, 1476, 1476, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477, 1477,
    1477, 1477, 1477, 1477, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1479, 1480, 1479,
    1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1482, 1482, 1482,
    1482, 1483, 1483, 1483, 1483, 1483, 1483, 1482, 1482, 1482, 1482, 1484, 1485, 1485, 1486, 1486,
    1486, 1486, 1486, 1487, 1487, 1487, 1487, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488,
    1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1489, 1489, 1489, 1489, 1489,
    1489, 1489, 1489, 1489, 1489, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487, 1487,
    1487, 1487, 1487, 1487, 1490, 1491, 1491, 1492, 1493, 1493, 1493, 1493, 1493, 1493, 1493, 1493,
    1493, 1493, 1493, 1493, 1493, 1494, 1495, 1494, 1496, 1496, 1497, 1497, 1494, 1494, 1498, 1499,
    1500, 1500, 1501, 1502, 1502, 1502, 1502, 1503, 1503, 1503, 1503, 1503, 1503, 1503, 1503, 1503,
    1503, 1503, 1501, 1503, 1503, 1504, 1504, 1504, 1504, 1504, 1504, 1504, 1504, 1504, 1505, 1505,
    1505, 1505, 1505, 1505, 1505, 1506, 1506, 1506, 1506, 1506, 1506, 1506, 1506, 1506, 1506, 1505,
    1505, 1505, 1505, 1505, 1505, 1507, 1507, 1507, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508,
    1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1509, 1509, 1509, 1509,
    1509, 1510, 1509, 1511, 1511, 1509, 1509, 1509, 1512, 1513, 1514, 1515, 1515, 1515, 1515, 1515,
    1515, 1515, 1515, 1515, 1515, 1516, 1516, 1516, 1516, 1508, 1517, 1517, 1508, 1514, 1514, 1514,
    1514, 1514, 1514, 1514, 1514, 1518, 1518, 1518, 1518, 1518, 1518, 1518, 1518, 1518, 1518, 1518,
    1519, 1520, 1521, 1522, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 1523, 1524, 1524, 1525,
    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,
    1527, 1528, 1527, 1529, 1529, 1529, 1529, 1529, 1529, 1530, 1530, 1530, 1531, 1532, 1526, 1533,
    1533, 1534, 1535, 1535, 1536, 1535, 1537, 1538, 1530, 1529, 1536, 1528, 1524, 1539, 1539, 1539,
    1539, 1539, 1539, 1539, 1539, 1539, 1539, 1526, 1540, 1534, 1535, 1535, 1535, 1541, 1542, 1542,
    1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542, 1542,
    1542, 1542, 1541, 1541, 1541, 1541, 1541, 1541, 1541, 1541, 1541, 1541, 1541, 1543, 1543, 1543,
    1543, 1543, 1543, 1543, 1543, 1543, 1543, 1544, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
    1543, 1545, 1545, 1545, 1546, 1547, 1547, 1548, 1548, 1549, 1550, 1551, 1552, 1553, 1553, 1554,
    1553, 1553, 1554, 1549, 1544, 1544, 1544, 1544, 1544, 1544, 1544, 1544, 1544, 1555, 1555, 1555,
    1555, 1555, 1555, 1555, 1556, 1555, 1556, 1555, 1555, 1555, 1555, 1556, 1555, 1555, 1555, 1555,
    1555, 1555, 1555, 1555, 1555, 1555, 1555, 1555, 1555, 1555, 1555, 1556, 1555, 1555, 1557, 1556,
    1556, 1556, 1556, 1556, 1556, 1558, 1558, 1558, 1558, 1558, 1558, 1558, 1558, 1558, 1558, 1558,
    1558, 1558, 1558, 1558, 1559, 1560, 1561, 1560, 1562, 1562, 1563, 1563, 1563, 1563, 1564, 1565,
    1566, 1566, 1566, 1566, 1566, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 1566,
    1566, 1566, 1566, 1566, 1566, 1568, 1568, 1569, 1569, 1570, 1571, 1571, 1571, 1571, 1571, 1571,
    1571, 1571, 1570, 1570, 1571, 1571, 1570, 1570, 1571, 1571, 1571, 1571, 1571, 1571, 1571, 1571,
    1571, 1571, 1571, 1571, 1571, 1571, 1570, 1571, 1571, 1571, 1571, 1571, 1571, 1571, 1570, 1571,
    1571, 1570, 1571, 1571, 1571, 1571, 1571, 1570, 1572, 1573, 1571, 1574, 1575, 1576, 1575, 1575,
    1575, 1575, 1570, 1570, 1577, 1577, 1570, 1570, 1578, 1578, 1579, 1570, 1570, 1580, 1570, 1570,
    1570, 1570, 1570, 1570, 1574, 1570, 1570, 1570, 1570, 1570, 1580, 1571, 1571, 1571, 1571, 1575,
    1575, 1570, 1570, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1570, 1570, 1570, 1570, 1570, 1570,
    1570, 1570, 1570, 1570, 1570, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
    1582, 1582, 1583, 1584, 1583, 1585, 1585, 1585, 1585, 1585, 1585, 1586, 1586, 1583, 1583, 1587,
    1588, 1588, 1589, 1590, 1582, 1591, 1591, 1591, 1592, 1592, 1592, 1592, 1593, 1594, 1594, 1594,
    1594, 1594, 1594, 1594, 1594, 1594, 1594, 1592, 1592, 1595, 1593, 1596, 1582, 1597, 1597, 1595,
    1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1598, 1599, 1599,
    1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1600, 1601, 1602,
    1603, 1603, 1603, 1603, 1603, 1603, 1601, 1604, 1605, 1605, 1600, 1605, 1606, 1606, 1607, 1608,
    1609, 1599, 1598, 1610, 1598, 1611, 1611, 1611, 1611, 1611, 1611, 1611, 1611, 1612, 1612, 1612,
    1612, 1612, 1612, 1612, 1612, 1612, 1612, 1611, 1611, 1611, 1611, 1611, 1611, 1613, 1613, 1613,
    1613, 1613, 1613, 1613, 1613, 1613, 1613, 1613, 1613, 1613, 1613, 1613, 1614, 1615, 1616, 1617,
    1617, 1617, 1617, 1618, 1618, 1615, 1616, 1619, 1619, 1620, 1620, 1621, 1622, 1623, 1624, 1625,
    1625, 1626, 1626, 1627, 1627, 1627, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
    1625, 1625, 1625, 1625, 1625, 1613, 1613, 1613, 1613, 1617, 1617, 1618, 1618, 1618, 1618, 1618,
    1618, 1618, 1618, 1618, 1618, 1628, 1628, 1628, 1628, 1628, 1628, 1628, 1628, 1629, 1629, 1629,
    1630, 1630, 1630, 1630, 1630, 1630, 1631, 1631, 1629, 1629, 1632, 1633, 1634, 1631, 1635, 1635,
    1636, 1637, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1638, 1638, 1638, 1638, 1638, 1638, 1640, 1640, 1640,
    1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1641, 1641, 1641, 1641, 1641, 1641,
    1641, 1641, 1641, 1641, 1641, 1642, 1642, 1642, 1642, 1642, 1642, 1642, 1642, 1642, 1642, 1642,
    1643, 1644, 1645, 1646, 1647, 1648, 1648, 1645, 1645, 1645, 1645, 1649, 1650, 1642, 1651, 1651,
    1651, 1651, 1651, 1651, 1651, 1652, 1652, 1652, 1652, 1652, 1652, 1652, 1652, 1652, 1652, 1651,
    1651, 1651, 1651, 1651, 1651, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653,
    1654, 1654, 1655, 1656, 1657, 1658, 1658, 1659, 1659, 1660, 1660, 1661, 1659, 1660, 1659, 1659,
    1662, 1654, 1654, 1654, 1654, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 1663, 1664,
    1664, 1665, 1665, 1665, 1666, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667,
    1667, 1668, 1669, 1668, 1670, 1670, 1670, 1670, 1671, 1671, 1671, 1671, 1672, 1673, 1674, 1675,
    1676, 1677, 1677, 1677, 1677, 1677, 1677, 1677, 1677, 1677, 1677, 1677, 1677, 1678, 1678, 1678,
    1678, 1678, 1678, 1678, 1678, 1679, 1679, 1679, 1679, 1679, 1679, 1679, 1679, 1680, 1680, 1680,
    1680, 1680, 1680, 1680, 1680, 1680, 1680, 1681, 1681, 1681, 1681, 1681, 1681, 1681, 1681, 1681,
    1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682, 1683, 1684, 1684, 1684,
    1684, 1684, 1684, 1684, 1685, 1685, 1684, 1685, 1685, 1684, 1684, 1684, 1684, 1684, 1684, 1684,
    1684, 1685, 1684, 1684, 1685, 1684, 1684, 1684, 1684, 1684, 1684, 1684, 1684, 1686, 1687, 1687,
    1687, 1687, 1688, 1685, 1688, 1689, 1685, 1685, 1690, 1690, 1691, 1692, 1693, 1694, 1695, 1696,
    1697, 1698, 1698, 1698, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 1699, 1699, 1699,
    1699, 1699, 1699, 1699, 1699, 1699, 1699, 1685, 1685, 1685, 1685, 1685, 1685, 1700, 1700, 1700,
    1700, 1700, 1700, 1700, 1700, 1701, 1701, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1702, 1703,
    1702, 1704, 1704, 1704, 1704, 1701, 1701, 1705, 1705, 1702, 1702, 1706, 1706, 1707, 1700, 1708,
    1709, 1703, 1701, 1701, 1701, 1701, 1701, 1701, 1701, 1701, 1701, 1701, 1701, 1710, 1711, 1712,
    1712, 1711, 1711, 1711, 1713, 1713, 1711, 1712, 1710, 1710, 1710, 1710, 1710, 1710, 1710, 1710,
    1710, 1710, 1710, 1710, 1710, 1710, 1710, 1710, 1714, 1715, 1716, 1716, 1716, 1716, 1717, 1718,
    1719, 1719, 1719, 1719, 1720, 1721, 1722, 1722, 1722, 1722, 1720, 1721, 1723, 1724, 1724, 1724,
    1724, 1724, 1724, 1724, 1724, 1725, 1726, 1727, 1727, 1726, 1726, 1726, 1728, 1728, 1727, 1727,
    1727, 1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725, 1725,
    1725, 1729, 1729, 1729, 1729, 1729, 1729, 1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730, 1730,
    1730, 1730, 1730, 1731, 1732, 1733, 1734, 1735, 1735, 1735, 1725, 1736, 1736, 1736, 1735, 1735,
    1737, 1737, 1737, 1737, 1737, 1737, 1737, 1737, 1737, 1737, 1737, 1737, 1737, 1738, 1738, 1738,
    1738, 1738, 1738, 1738, 1738, 1738, 1739, 1739, 1739, 1739, 1739, 1739, 1739, 1740, 1740, 1740,
    1740, 1740, 1740, 1740, 1740, 1740, 1741, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
    1740, 1740, 1740, 1740, 1742, 1743, 1743, 1744, 1744, 1744, 1744, 1744, 1741, 1743, 1743, 1743,
    1743, 1745, 1745, 1746, 1747, 1740, 1748, 1748, 1748, 1748, 1748, 1741, 1741, 1741, 1741, 1741,
    1741, 1741, 1741, 1741, 1741, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1750,
    1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750, 1750,
    1750, 1750, 1741, 1741, 1741, 1751, 1752, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
    1753, 1753, 1753, 1753, 1753, 1754, 1754, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
    1755, 1755, 1755, 1755, 1755, 1754, 1756, 1755, 1755, 1755, 1755, 1755, 1755, 1757, 1758, 1757,
    1759, 1760, 1761, 1761, 1754, 1754, 1754, 1754, 1754, 1754, 1754, 1754, 1754, 1762, 1762, 1762,
    1762, 1762, 1762, 1762, 1763, 1762, 1762, 1763, 1762, 1762, 1762, 1762, 1762, 1762, 1762, 1762,
    1762, 1762, 1762, 1762, 1762, 1762, 1764, 1764, 1764, 1764, 1764, 1765, 1763, 1763, 1763, 1764,
    1763, 1764, 1764, 1763, 1764, 1766, 1766, 1767, 1764, 1768, 1769, 1770, 1771, 1763, 1763, 1763,
    1763, 1763, 1763, 1763, 1763, 1772, 1772, 1772, 1772, 1772, 1772, 1772, 1772, 1772, 1772, 1763,
    1763, 1763, 1763, 1763, 1763, 1773, 1773, 1773, 1773, 1773, 1773, 1774, 1773, 1773, 1774, 1773,
    1773, 1773, 1773, 1773, 1773, 1773, 1773, 1773, 1773, 1773, 1773, 1773, 1773, 1773, 1773, 1775,
    1775, 1775, 1775, 1775, 1774, 1776, 1776, 1774, 1775, 1775, 1777, 1778, 1779, 1780, 1774, 1774,
    1774, 1774, 1774, 1774, 1774, 1781, 1781, 1781, 1781, 1781, 1781, 1781, 1781, 1781, 1781, 1774,
    1774, 1774, 1774, 1774, 1774, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1783,
    1784, 1785, 1786, 1787, 1788, 1788, 1789, 1789, 1789, 1789, 1789, 1789, 1789, 1790, 1791, 1791,
    1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791, 1792, 1792, 1792,
    1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792, 1792, 1793, 1793, 1793, 1793, 1793, 1793,
    1793, 1793, 1794, 1794, 1794, 1794, 1793, 1793, 1793, 1793, 1793, 1793, 1793, 1793, 1793, 1793,
    1793, 1793, 1793, 1793, 1793, 1793, 1793, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1795,
    1795, 1795, 1795, 1795, 1796, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1798,
    1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1798, 1799, 1799, 1799,
    1799, 1799, 1799, 1799, 1799, 1799, 1799, 1799, 1799, 1799, 1799, 1799, 1800, 1801, 1801, 1801,
    1801, 1801, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1802, 1802, 1802,
    1802, 1802, 1802, 1802, 1802, 1802, 1802, 1802, 1802, 1803, 1803, 1803, 1803, 1803, 1803, 1803,
    1803, 1803, 1803, 1803, 1803, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1805, 1805, 1805,
    1806, 1806, 1806, 1804, 1804, 1804, 1804, 1806, 1804, 1804, 1804, 1805, 1806, 1805, 1806, 1804,
    1804, 1804, 1804, 1804, 1804, 1804, 1805, 1806, 1806, 1804, 1804, 1804, 1804, 1804, 1804, 1804,
    1804, 1804, 1804, 1804, 1807, 1808, 1808, 1808, 1808, 1808, 1808, 1808, 1809, 1810, 1811, 1811,
    1811, 1811, 1811, 1811, 1811, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1812,
    1812, 1812, 1812, 1813, 1814, 1812, 1812, 1812, 1812, 1812, 1812, 1812, 1815, 1815, 1815, 1815,
    1815, 1815, 1815, 1815, 1815, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1817, 1817,
    1817, 1817, 1817, 1817, 1817, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818, 1818,
    1818, 1818, 1818, 1818, 1819, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1820, 1819,
    1819, 1819, 1819, 1821, 1821, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822, 1822,
    1822, 1822, 1822, 1823, 1823, 1824, 1824, 1824, 1824, 1824, 1825, 1823, 1823, 1823, 1823, 1823,
    1823, 1823, 1823, 1823, 1823, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1826, 1827, 1827, 1827,
    1827, 1827, 1827, 1827, 1828, 1828, 1828, 1829, 1829, 1830, 1830, 1830, 1830, 1831, 1831, 1831,
    1831, 1828, 1830, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1832, 1833, 1833, 1833,
    1833, 1833, 1833, 1833, 1833, 1833, 1833, 1832, 1834, 1834, 1834, 1834, 1834, 1834, 1834, 1832,
    1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1835, 1832, 1832, 1832,
    1832, 1832, 1835, 1835, 1835, 1836, 1836, 1836, 1836, 1836, 1836, 1836, 1836, 1837, 1837, 1837,
    1837, 1837, 1837, 1837, 1837, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838, 1838,
    1838, 1838, 1838, 1838, 1839, 1839, 1840, 1840, 1841, 1841, 1841, 1841, 1841, 1842, 1842, 1842,
    1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1842, 1843, 1843, 1843, 1843, 1843, 1843,
    1844, 1844, 1844, 1844, 1845, 1842, 1846, 1846, 1846, 1846, 1846, 1846, 1846, 1846, 1846, 1846,
    1846, 1846, 1846, 1846, 1846, 1844, 1844, 1844, 1844, 1844, 1844, 1844, 1847, 1847, 1847, 1847,
    1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1848, 1849, 1850, 1851,
    1852, 1853, 1854, 1854, 1854, 1854, 1854, 1854, 1854, 1854, 1854, 1854, 1854, 1855, 1855, 1854,
    1854, 1854, 1854, 1854, 1854, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1856, 1857, 1857, 1857,
    1857, 1857, 1857, 1857, 1857, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1858, 1859, 1859, 1859,
    1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1859, 1860, 1860, 1860, 1860, 1860,
    1860, 1860, 1860, 1860, 1860, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1861, 1862, 1862,
    1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1862, 1863, 1864, 1864,
    1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1864, 1865, 1865, 1865,
    1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1865, 1866, 1866, 1866, 1866,
    1866, 1866, 1866, 1866, 1866, 1867, 1867, 1867, 1867, 1867, 1867, 1867, 1867, 1868, 1868, 1868,
    1867, 1867, 1867, 1867, 1867, 1867, 1867, 1867, 1867, 1869, 1869, 1869, 1869, 1870, 1870, 1870,
    1870, 1870, 1870, 1870, 1870, 1870, 1870, 1870, 1870, 1871, 1871, 1871, 1871, 1872, 1872, 1872,
    1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1873, 1873, 1873, 1873, 1873, 1872, 1872, 1872,
    1872, 1872, 1873, 1873, 1873, 1872, 1873, 1873, 1873, 1873, 1873, 1873, 1873, 1872, 1872, 1874,
    1874, 1875, 1876, 1877, 1878, 1879, 1879, 1879, 1879, 1880, 1880, 1880, 1880, 1880, 1880, 1880,
    1880, 1880, 1880, 1880, 1880, 1881, 1881, 1881, 1881, 1881, 1881, 1881, 1881, 1881, 1881, 1881,
    1881, 1881, 1881, 1882, 1882, 1882, 1882, 1882, 1882, 1882, 1882, 1882, 1882, 1883, 1883, 1883,
    1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883, 1884, 1884, 1883, 1883,
    1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883, 1883, 1885, 1886, 1887, 1887, 1887, 1883,
    1883, 1883, 1888, 1885, 1885, 1885, 1885, 1885, 1889, 1889, 1889, 1889, 1889, 1889, 1889, 1889,
    1890, 1890, 1890, 1890, 1890, 1890, 1890, 1890, 1883, 1883, 1891, 1891, 1891, 1891, 1891, 1890,
    1890, 1883, 1883, 1883, 1883, 1883, 1883, 1891, 1891, 1891, 1891, 1883, 1883, 1883, 1884, 1884,
    1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1884, 1892, 1892, 1892,
    1892, 1892, 1892, 1892, 1892, 1892, 1892, 1893, 1893, 1893, 1892, 1894, 1894, 1894, 1894, 1894,
    1894, 1894, 1894, 1894, 1894, 1895, 1895, 1895, 1895, 1895, 1895, 1895, 1895, 1895, 1895, 1895,
    1895, 1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896, 1896, 1897, 1897, 1897,
    1897, 1897, 1897, 1897, 1897, 1897, 1897, 1897, 1897, 1897, 1897, 1897, 1898, 1898, 1898, 1898,
    1898, 1898, 1898, 1898, 1898, 1899, 1899, 1899, 1899, 1899, 1899, 1899, 1899, 1899, 1900, 1900,
    1900, 1900, 1900, 1900, 1900, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1902,
    1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902,
    1902, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1902, 1902, 1902, 1902, 1902,
    1902, 1902, 1903, 1902, 1902, 1902, 1902, 1902, 1902, 1901, 1903, 1901, 1901, 1903, 1903, 1901,
    1903, 1903, 1901, 1901, 1903, 1903, 1901, 1901, 1901, 1901, 1903, 1901, 1901, 1902, 1902, 1903,
    1902, 1903, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1903, 1902, 1902, 1902, 1902, 1902, 1902,
    1902, 1901, 1901, 1903, 1901, 1901, 1901, 1901, 1903, 1903, 1901, 1901, 1901, 1901, 1901, 1901,
    1901, 1901, 1903, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1903, 1902, 1902, 1901, 1901, 1903,
    1901, 1901, 1901, 1901, 1903, 1901, 1901, 1901, 1901, 1901, 1903, 1901, 1903, 1903, 1903, 1901,
    1901, 1901, 1901, 1901, 1901, 1901, 1903, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902,
    1902, 1902, 1902, 1903, 1903, 1901, 1904, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902,
    1905, 1902, 1902, 1902, 1902, 1902, 1902, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901,
    1904, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1905, 1902, 1902, 1901, 1901, 1901,
    1901, 1901, 1904, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1902, 1905, 1902, 1902, 1902,
    1902, 1902, 1902, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1901, 1904, 1902, 1905, 1902,
    1902, 1902, 1902, 1902, 1902, 1902, 1902, 1901, 1902, 1903, 1903, 1906, 1906, 1906, 1906, 1906,
    1906, 1906, 1906, 1906, 1906, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 1908, 1908, 1908,
    1908, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1907, 1907, 1907, 1907,
    1908, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1907, 1907, 1907, 1907, 1907, 1907,
    1907, 1907, 1908, 1907, 1907, 1907, 1907, 1907, 1907, 1908, 1907, 1907, 1909, 1909, 1909, 1909,
    1910, 1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911, 1911,
    1908, 1908, 1908, 1908, 1908, 1911, 1908, 1908, 1908, 1908, 1908, 1908, 1908, 1912, 1912, 1912,
    1912, 1912, 1912, 1912, 1913, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 1913, 1913,
    1912, 1912, 1912, 1912, 1912, 1912, 1912, 1913, 1912, 1912, 1913, 1912, 1912, 1912, 1912, 1912,
    1913, 1913, 1913, 1913, 1913, 1914, 1914, 1914, 1914, 1914, 1914, 1914, 1914, 1914, 1914, 1914,
    1914, 1914, 1915, 1915, 1915, 1916, 1916, 1916, 1916, 1916, 1916, 1916, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1915, 1915, 1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918, 1918, 1915,
    1915, 1915, 1915, 1914, 1919, 1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920, 1920,
    1920, 1921, 1921, 1921, 1921, 1922, 1922, 1922, 1922, 1922, 1922, 1922, 1922, 1922, 1922, 1923,
    1923, 1923, 1923, 1923, 1924, 1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 1925, 1926, 1926, 1927, 1927, 1927, 1927, 1927, 1927, 1927, 1927, 1927, 1928, 1928, 1928,
    1928, 1928, 1928, 1928, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1929, 1929, 1929,
    1929, 1929, 1929, 1929, 1929, 1929, 1929, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930, 1931, 1931, 1931, 1931, 1931, 1931, 1932,
    1933, 1934, 1934, 1934, 1934, 1935, 1935, 1935, 1935, 1935, 1935, 1935, 1935, 1935, 1935, 1934,
    1934, 1934, 1934, 1936, 1936, 1937, 1938, 1938, 1938, 1938, 1938, 1938, 1938, 1938, 1938, 1938,
    1938, 1938, 1938, 1938, 1938, 1938, 1938, 1938, 1938, 1939, 1938, 1938, 1938, 1940, 1938, 1938,
    1938, 1938, 1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937, 1937, 1941, 1942, 1942,
    1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942,
    1942, 1942, 1942, 1943, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1941, 1941, 1941, 1941, 1941,
    1941, 1941, 1941, 1941, 1941, 1944, 1944, 1944, 1944, 1945, 1944, 1944, 1944, 1944, 1944, 1944,
    1944, 1944, 1944, 1944, 1944, 1945, 1944, 1944, 1945, 1944, 1945, 1945, 1944, 1945, 1944, 1944,
    1944, 1944, 1944, 1944, 1944, 1944, 1944, 1944, 1945, 1944, 1944, 1944, 1944, 1945, 1944, 1945,
    1944, 1945, 1945, 1945, 1945, 1945, 1945, 1944, 1945, 1945, 1945, 1945, 1944, 1945, 1944, 1945,
    1944, 1945, 1944, 1944, 1944, 1945, 1944, 1945, 1944, 1945, 1944, 1945, 1944, 1945, 1944, 1944,
    1944, 1944, 1945, 1944, 1945, 1944, 1944, 1945, 1944, 1944, 1944, 1944, 1944, 1944, 1944, 1944,
    1944, 1945, 1945, 1945, 1945, 1945, 1944, 1944, 1944, 1945, 1944, 1944, 1944, 1945, 1945, 1945,
    1945, 1945, 1945, 1945, 1945, 1946, 1946, 1945, 1945, 1945, 1945, 1945, 1945, 1947, 1947, 1947,
    1947, 1948, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1949, 1949, 1949, 1949, 1950, 1950, 1950, 1950, 1950, 1950, 1950, 1950, 1950, 1950, 1950,
    1950, 1951, 1951, 1951, 1951, 1951, 1951, 1951, 1951, 1951, 1951, 1951, 1951, 1952, 1952, 1952,
    1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1953, 1953, 1952, 1952,
    1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1952, 1954, 1952, 1952, 1952,
    1952, 1952, 1952, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1955, 1955, 1955,
    1955, 1955, 1955, 1955, 1955, 1955, 1955, 1955, 1956, 1956, 1957, 1957, 1957, 1958, 1958, 1958,
    1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1959, 1960, 1961, 1961, 1961,
    1961, 1961, 1961, 1961, 1961, 1961, 1961, 1958, 1958, 1958, 1958, 1958, 1958, 1961, 1961, 1962,
    1962, 1960, 1957, 1957, 1957, 1963, 1963, 1961, 1961, 1961, 1961, 1961, 1961, 1961, 1961, 1961,
    1961, 1961, 1961, 1963, 1963, 1961, 1961, 1958, 1958, 1958, 1958, 1964, 1958, 1958, 1964, 1964,
    1964, 1964, 1964, 1964, 1964, 1964, 1964, 1964, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958,
    1958, 1958, 1957, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965, 1965,
    1965, 1965, 1965, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1966, 1967, 1968, 1968,
    1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1970, 1970, 1970,
    1970, 1970, 1970, 1970, 1970, 1970, 1970, 1968, 1970, 1970, 1970, 1970, 1970, 1970, 1970, 1970,
    1970, 1970, 1970, 1970, 1968, 1970, 1970, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968, 1968,
    1970, 1969, 1969, 1969, 1969, 1970, 1969, 1969, 1969, 1969, 1969, 1969, 1969, 1968, 1968, 1969,
    1969, 1969, 1969, 1969, 1969, 1971, 1971, 1971, 1971, 1971, 1971, 1969, 1969, 1972, 1972, 1972,
    1972, 1972, 1972, 1972, 1972, 1972, 1972, 1973, 1973, 1972, 1972, 1972, 1972, 1972, 1972, 1972,
    1972, 1972, 1974, 1972, 1972, 1972, 1972, 1972, 1972, 1973, 1973, 1972, 1972, 1973, 1972, 1972,
    1972, 1975, 1975, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1976, 1976, 1972, 1972, 1972, 1972,
    1972, 1976, 1972, 1972, 1972, 1972, 1972, 1974, 1974, 1974, 1972, 1972, 1974, 1972, 1972, 1974,
    1974, 1974, 1972, 1972, 1972, 1972, 1973, 1973, 1972, 1972, 1972, 1973, 1972, 1972, 1972, 1972,
    1977, 1977, 1977, 1977, 1977, 1972, 1972, 1974, 1974, 1972, 1972, 1974, 1974, 1974, 1974, 1974,
    1974, 1974, 1974, 1974, 1974, 1974, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1972,
    1972, 1972, 1972, 1974, 1974, 1974, 1972, 1972, 1972, 1974, 1972, 1972, 1972, 1972, 1974, 1974,
    1974, 1972, 1974, 1974, 1974, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1974, 1972, 1974, 1972,
    1972, 1972, 1972, 1972, 1972, 1976, 1972, 1976, 1972, 1976, 1972, 1972, 1972, 1972, 1972, 1974,
    1972, 1972, 1972, 1972, 1976, 1972, 1976, 1976, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1972,
    1972, 1972, 1972, 1973, 1972, 1976, 1976, 1976, 1976, 1976, 1976, 1976, 1972, 1972, 1972, 1972,
    1972, 1972, 1972, 1972, 1976, 1976, 1976, 1976, 1976, 1976, 1976, 1976, 1976, 1976, 1976, 1976,
    1976, 1976, 1972, 1972, 1972, 1972, 1972, 1976, 1976, 1976, 1976, 1976, 1976, 1976, 1976, 1976,
    1976, 1976, 1976, 1978, 1978, 1978, 1978, 1978, 1978, 1978, 1978, 1975, 1975, 1975, 1976, 1972,
    1972, 1972, 1972, 1972, 1973, 1973, 1973, 1973, 1973, 1973, 1973, 1973, 1972, 1972, 1973, 1973,
    1972, 1974, 1974, 1972, 1972, 1972, 1972, 1974, 1973, 1973, 1973, 1973, 1973, 1973, 1973, 1972,
    1972, 1972, 1972, 1973, 1973, 1974, 1973, 1973, 1973, 1973, 1974, 1974, 1973, 1973, 1973, 1973,
    1973, 1973, 1973, 1973, 1973, 1973, 1973, 1973, 1973, 1972, 1972, 1973, 1973, 1972, 1973, 1973,
    1973, 1973, 1973, 1973, 1973, 1973, 1972, 1972, 1973, 1973, 1973, 1973, 1973, 1973, 1973, 1973,
    1973, 1972, 1973, 1973, 1973, 1973, 1973, 1972, 1972, 1972, 1973, 1973, 1973, 1973, 1972, 1972,
    1972, 1975, 1975, 1975, 1975, 1975, 1975, 1975, 1975, 1972, 1972, 1972, 1973, 1973, 1972, 1973,
    1972, 1973, 1973, 1973, 1973, 1972, 1973, 1973, 1973, 1973, 1973, 1973, 1972, 1973, 1973, 1973,
    1972, 1975, 1975, 1975, 1975, 1975, 1975, 1972, 1972, 1972, 1972, 1972, 1972, 1979, 1979, 1979,
    1979, 1979, 1979, 1979, 1979, 1979, 1979, 1979, 1979, 1979, 1980, 1980, 1980, 1979, 1979, 1979,
    1980, 1980, 1980, 1980, 1980, 1981, 1981, 1981, 1981, 1981, 1981, 1981, 1981, 1981, 1981, 1981,
    1981, 1981, 1981, 1982, 1982, 1982, 1983, 1983, 1983, 1981, 1981, 1981, 1981, 1984, 1984, 1984,
    1984, 1984, 1984, 1984, 1984, 1984, 1984, 1984, 1985, 1984, 1984, 1984, 1984, 1984, 1984, 1984,
    1984, 1985, 1985, 1985, 1984, 1985, 1984, 1984, 1984, 1984, 1984, 1986, 1986, 1986, 1986, 1986,
    1984, 1985, 1984, 1984, 1984, 1984, 1984, 1984, 1986, 1986, 1984, 1984, 1984, 1987, 1987, 1987,
    1987, 1987, 1987, 1987, 1987, 1984, 1984, 1984, 1984, 1984, 1984, 1986, 1986, 1986, 1984, 1986,
    1984, 1984, 1987, 1987, 1987, 1984, 1986, 1986, 1984, 1984, 1984, 1984, 1984, 1984, 1984, 1984,
    1984, 1984, 1987, 1987, 1987, 1988, 1988, 1988, 1988, 1988, 1988, 1988, 1988, 1988, 1988, 1988,
    1988, 1989, 1989, 1989, 1989, 1989, 1989, 1989, 1989, 1989, 1989, 1989, 1989, 1990, 1990, 1990,
    1990, 1990, 1990, 1990, 1990, 1990, 1990, 1990, 1990, 1990, 1991, 1991, 1991, 1991, 1992, 1992,
    1992, 1992, 1992, 1992, 1992, 1993, 1993, 1993, 1993, 1993, 1993, 1993, 1993, 1993, 1993, 1993,
    1993, 1992, 1992, 1992, 1992, 1992, 1992, 1992, 1992, 1992, 1992, 1992, 1992, 1994, 1994, 1994,
    1994, 1994, 1994, 1994, 1994, 1994, 1994, 1994, 1994, 1995, 1995, 1995, 1995, 1995, 1995, 1995,
    1995, 1995, 1995, 1995, 1995, 1994, 1994, 1995, 1995, 1995, 1995, 1995, 1995, 1994, 1994, 1994,
    1994, 1994, 1994, 1995, 1995, 1996, 1996, 1995, 1995, 1995, 1995, 1995, 1995, 1997, 1997, 1997,
    1997, 1997, 1997, 1997, 1997, 1997, 1997, 1997, 1997, 1998, 1999, 1999, 1998, 1999, 1999, 1999,
    1999, 1999, 1999, 1999, 1999, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1999, 1999, 1999,
    1999, 1999, 1999, 1998, 1999, 1998, 1998, 1999, 2000, 1998, 1998, 1998, 1999, 1999, 1999, 1999,
    1999, 1999, 1999, 2000, 1999, 1999, 1999, 1999, 1999, 1999, 1999, 1999, 1998, 1999, 2001, 1999,
    1999, 1999, 1999, 1999, 1999, 1999, 1999, 1999, 1999, 1999, 1998, 1998, 1999, 1998, 1998, 1999,
    1998, 1999, 1999, 1999, 1999, 1999, 1999, 1999, 1999, 2001, 1998, 1998, 1998, 1999, 1998, 1998,
    1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1999, 1999, 2002, 2002, 2002,
    2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 2003, 2003, 2003, 2003, 2003, 2003, 2003,
    2003, 2003, 2003, 2003, 2003, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004,
    2004, 2004, 2004, 2003, 2003, 2005, 2005, 2005, 2005, 2005, 2006, 2006, 2006, 2005, 2005, 2005,
    2006, 2006, 2006, 2006, 2006, 2005, 2005, 2005, 2005, 2005, 2005, 2005, 2006, 2006, 2006, 2006,
    2006, 2006, 2006, 2006, 2006, 2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005, 2006, 2006,
    2006, 2006, 2006, 2006, 2006, 2007, 2007, 2007, 2007, 2007, 2007, 2007, 2007, 2007, 2007, 2007,
    2008, 2007, 2007, 2007, 2007, 2007, 2007, 2007, 2008, 2008, 2008, 2008, 2008, 2008, 2008, 2008,
    2008, 2008, 2008, 2008, 2008, 2009, 2009, 2009, 2009, 2009, 2009, 2009, 2009, 2009, 2009, 2008,
    2008, 2008, 2008, 2008, 2008, 2010, 2010, 2010, 2010, 2010, 2010, 2010, 2010, 2010, 2010, 2010,
    2010, 2010, 2010, 232, 232, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 2011,
    2011, 2011, 2011, 2012, 2012, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2014, 2014, 2014,
    2014, 2014, 2014, 2014, 2014, 2014, 2014, 2014, 2014, 2014, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2016, 2016, 2016, 2016, 2016, 2016, 2016, 2016, 2016, 2016, 2016,
    2016, 2016, 2016, 2017, 2017, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 2019,
    2019, 2019, 2019, 2019, 2019, 2019, 2019, 2019, 2019, 2019, 2019, 2019, 2019, 2020, 2020, 2020,
    2020, 2020, 2020, 2020, 2020, 2020, 2021, 2021, 2021, 2021, 2021, 2021, 2021, 2021, 2021, 2021,
    2021, 2021, 2021, 2021, 2021, 2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2023, 2023, 2013, 2013, 2013, 2013, 2013, 2013, 232, 232, 2024, 2024, 2024,
    2024, 2024, 2024, 2024, 2024, 2024, 2024, 2024, 2025, 2025, 2025, 2025, 2025, 2026, 2027, 2026,
    2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026, 2028, 2028, 2028,
    2028, 2028, 2028, 2028, 2028, 2029, 2029, 2029, 2029, 2029, 2029, 2029, 2029, 2030, 2030, 2030,
    2030, 2030, 2030, 2030, 2030, 2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,
    2031, 2031, 2031, 2032, 2032, 2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,
    2033, 2033, 2033, 2034, 2034,
];

pub fn get_record_index(x: usize) -> usize {
    const SHIFT1: usize = 5;
    const SHIFT2: usize = 3;
    if x >= 1114112 {
        return 0;
    }
    let mut index = (RECORD_INDEX0[x >> (SHIFT1 + SHIFT2)] as usize) << SHIFT1;
    let mut offset = (x >> SHIFT2) & ((1 << SHIFT1) - 1);
    index = (RECORD_INDEX1[index + offset] as usize) << SHIFT2;
    offset = x & ((1 << SHIFT2) - 1);
    RECORD_INDEX2[index + offset] as usize
}

#[derive(Copy, Clone)]
pub struct Record {
    pub flags: Flags,
    pub category: Category,
    pub block: Block,
    pub script: Script,
    pub combining_class: u8,
    pub bidi_class: BidiClass,
    pub joining_type: JoiningType,
    pub cluster_break: ClusterBreak,
    pub word_break: WordBreak,
    pub line_break: LineBreak,
    pub use_class: UseClass,
    pub myanmar_class: MyanmarClass,
}

#[derive(Copy, Clone)]
#[repr(transparent)]
pub struct Flags(pub u8);

impl Flags {
    pub fn is_emoji(self) -> bool {
        self.0 & 1 != 0
    }

    pub fn is_extended_pictographic(self) -> bool {
        self.0 & 2 != 0
    }

    pub fn is_open_bracket(self) -> bool {
        self.0 & 4 != 0
    }

    pub fn is_close_bracket(self) -> bool {
        self.0 & 8 != 0
    }

    pub fn is_variation_selector(self) -> bool {
        self.0 & 16 != 0
    }

    pub fn is_ignorable(self) -> bool {
        self.0 & 32 != 0
    }

    pub fn contributes_to_shaping(self) -> bool {
        self.0 & 64 != 0
    }

    pub fn needs_decomp(self) -> bool {
        self.0 & 128 != 0
    }
}

const fn r(
    flags: u8,
    category: Category,
    block: Block,
    script: Script,
    combining_class: u8,
    bidi_class: BidiClass,
    joining_type: JoiningType,
    cluster_break: ClusterBreak,
    word_break: WordBreak,
    line_break: LineBreak,
    use_class: UseClass,
    myanmar_class: MyanmarClass,
) -> Record {
    Record {
        flags: Flags(flags),
        category,
        block,
        script,
        combining_class,
        bidi_class,
        joining_type,
        cluster_break,
        word_break,
        line_break,
        use_class,
        myanmar_class,
    }
}

use self::{
    BidiClass as Bc, Block as B, Category as C, ClusterBreak as Cb, JoiningType as Jt,
    LineBreak as Lb, MyanmarClass as Mc, Script as S, UseClass as Uc, WordBreak as Wb,
};

#[rustfmt::skip]
pub const RECORDS: [Record; 2035] = [
    r(32,C::Control,B::BasicLatin,S::Common,0,Bc::BN,Jt::U,Cb::CN,Wb::XX,Lb::CM,Uc::O,Mc::O), r(32,C::Control,B::BasicLatin,S::Common,0,Bc::S,Jt::U,Cb::CN,Wb::XX,Lb::BA,Uc::O,Mc::O),
    r(32,C::Control,B::BasicLatin,S::Common,0,Bc::B,Jt::U,Cb::LF,Wb::LF,Lb::LF,Uc::O,Mc::O), r(32,C::Control,B::BasicLatin,S::Common,0,Bc::S,Jt::U,Cb::CN,Wb::NL,Lb::BK,Uc::O,Mc::O),
    r(32,C::Control,B::BasicLatin,S::Common,0,Bc::WS,Jt::U,Cb::CN,Wb::NL,Lb::BK,Uc::O,Mc::O), r(32,C::Control,B::BasicLatin,S::Common,0,Bc::B,Jt::U,Cb::CR,Wb::CR,Lb::CR,Uc::O,Mc::O),
    r(32,C::Control,B::BasicLatin,S::Common,0,Bc::B,Jt::U,Cb::CN,Wb::XX,Lb::CM,Uc::O,Mc::O), r(32,C::Control,B::BasicLatin,S::Common,0,Bc::S,Jt::U,Cb::CN,Wb::XX,Lb::CM,Uc::O,Mc::O),
    r(64,C::SpaceSeparator,B::BasicLatin,S::Common,0,Bc::WS,Jt::U,Cb::XX,Wb::WSegSpace,Lb::SP,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::DQ,Lb::QU,Uc::IND,Mc::O), r(65,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::CurrencySymbol,B::BasicLatin,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O), r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::SQ,Lb::QU,Uc::IND,Mc::O),
    r(68,C::OpenPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O), r(72,C::ClosePunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CP,Uc::O,Mc::O),
    r(65,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::MathSymbol,B::BasicLatin,S::Common,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::IND,Mc::O), r(64,C::DashPunctuation,B::BasicLatin,S::Common,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::HY,Uc::GB,Mc::O),
    r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::MB,Lb::IS,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::XX,Lb::SY,Uc::IND,Mc::O),
    r(65,C::DecimalNumber,B::BasicLatin,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::ML,Lb::IS,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::IND,Mc::O), r(64,C::MathSymbol,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::BasicLatin,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::IND,Mc::O),
    r(64,C::ModifierSymbol,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::ConnectorPunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::EX,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::BasicLatin,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::MathSymbol,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::BasicLatin,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(32,C::Control,B::Latin1Supplement,S::Common,0,Bc::BN,Jt::U,Cb::CN,Wb::XX,Lb::CM,Uc::O,Mc::O),
    r(32,C::Control,B::Latin1Supplement,S::Common,0,Bc::B,Jt::U,Cb::CN,Wb::NL,Lb::NL,Uc::O,Mc::O), r(64,C::SpaceSeparator,B::Latin1Supplement,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::XX,Lb::GL,Uc::GB,Mc::GB),
    r(64,C::OtherPunctuation,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::IND,Mc::O), r(64,C::CurrencySymbol,B::Latin1Supplement,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O),
    r(64,C::CurrencySymbol,B::Latin1Supplement,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O), r(64,C::OtherSymbol,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherPunctuation,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::IND,Mc::O), r(64,C::ModifierSymbol,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O),
    r(67,C::OtherSymbol,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::OtherLetter,B::Latin1Supplement,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::O,Mc::O),
    r(64,C::InitialPunctuation,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::O,Mc::O), r(64,C::MathSymbol,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(32,C::Format,B::Latin1Supplement,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::FO,Lb::BA,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::Latin1Supplement,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O), r(64,C::MathSymbol,B::Latin1Supplement,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::Latin1Supplement,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::FM,Mc::O), r(64,C::ModifierSymbol,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::Latin1Supplement,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::ML,Lb::AI,Uc::IND,Mc::O),
    r(64,C::OtherNumber,B::Latin1Supplement,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::FinalPunctuation,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::Latin1Supplement,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::GB,Mc::GB), r(64,C::LowercaseLetter,B::Latin1Supplement,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::Latin1Supplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::LatinExtendedA,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::LatinExtendedA,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::LatinExtendedB,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::LatinExtendedB,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::LatinExtendedB,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::TitlecaseLetter,B::LatinExtendedB,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::IPAExtensions,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::IPAExtensions,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::SpacingModifierLetters,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::SpacingModifierLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::SpacingModifierLetters,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::SpacingModifierLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::SpacingModifierLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::SpacingModifierLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::BB,Uc::O,Mc::O), r(64,C::ModifierLetter,B::SpacingModifierLetters,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::SpacingModifierLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::SpacingModifierLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::SpacingModifierLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::BB,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::SpacingModifierLetters,S::Bopomofo,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,232,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,216,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,202,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,1,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,240,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::GL,Uc::CGJ,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,233,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::GL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarks,S::Inherited,234,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::GL,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::GreekandCoptic,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::GreekandCoptic,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::GreekandCoptic,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::GreekandCoptic,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::GreekandCoptic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::GreekandCoptic,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::GreekandCoptic,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::IND,Mc::O),
    r(64,C::ModifierSymbol,B::GreekandCoptic,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::GreekandCoptic,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::ML,Lb::AL,Uc::IND,Mc::O),
    r(64,C::UppercaseLetter,B::GreekandCoptic,S::Coptic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::GreekandCoptic,S::Coptic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::GreekandCoptic,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::Cyrillic,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::Cyrillic,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::Cyrillic,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::Cyrillic,S::Cyrillic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Cyrillic,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::EnclosingMark,B::Cyrillic,S::Cyrillic,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::CyrillicSupplement,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::CyrillicSupplement,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Armenian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::Armenian,S::Armenian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::Armenian,S::Armenian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Armenian,S::Armenian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Armenian,S::Armenian,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Armenian,S::Armenian,0,Bc::L,Jt::U,Cb::XX,Wb::ML,Lb::AL,Uc::IND,Mc::O), r(64,C::LowercaseLetter,B::Armenian,S::Armenian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Armenian,S::Armenian,0,Bc::L,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::IND,Mc::O), r(64,C::DashPunctuation,B::Armenian,S::Armenian,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::BA,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::Armenian,S::Armenian,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::CurrencySymbol,B::Armenian,S::Armenian,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O),
    r(64,C::Other,B::Hebrew,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,222,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,228,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,10,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,11,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,12,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,13,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,14,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,15,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,16,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,17,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,18,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,19,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,20,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,21,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,22,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::DashPunctuation,B::Hebrew,S::Hebrew,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,23,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Hebrew,S::Hebrew,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,24,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hebrew,S::Hebrew,25,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Hebrew,S::Hebrew,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Hebrew,S::Hebrew,0,Bc::R,Jt::U,Cb::XX,Wb::HL,Lb::HL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Hebrew,S::Hebrew,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Hebrew,S::Hebrew,0,Bc::R,Jt::U,Cb::XX,Wb::ML,Lb::AL,Uc::IND,Mc::O), r(32,C::Format,B::Arabic,S::Arabic,0,Bc::AN,Jt::U,Cb::PP,Wb::FO,Lb::AL,Uc::O,Mc::O),
    r(32,C::Format,B::Arabic,S::Common,0,Bc::AN,Jt::U,Cb::PP,Wb::FO,Lb::AL,Uc::O,Mc::O), r(64,C::MathSymbol,B::Arabic,S::Arabic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::Arabic,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Arabic,S::Arabic,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::IND,Mc::O),
    r(64,C::CurrencySymbol,B::Arabic,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O), r(64,C::OtherPunctuation,B::Arabic,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Arabic,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::IND,Mc::O), r(64,C::OtherSymbol,B::Arabic,S::Arabic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::Arabic,S::Arabic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Arabic,S::Arabic,30,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Arabic,S::Arabic,31,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Arabic,S::Arabic,32,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Arabic,S::Common,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O), r(32,C::Format,B::Arabic,S::Arabic,0,Bc::AL,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(64,C::Other,B::Arabic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Arabic,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Arabic,S::Arabic,0,Bc::AL,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Arabic,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Arabic,S::Arabic,0,Bc::AL,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::Arabic,S::Common,0,Bc::AL,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Arabic,S::Inherited,27,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Arabic,S::Inherited,28,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Arabic,S::Inherited,29,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Arabic,S::Inherited,30,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Arabic,S::Inherited,31,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Arabic,S::Inherited,32,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Arabic,S::Inherited,33,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Arabic,S::Inherited,34,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Arabic,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Arabic,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Arabic,S::Arabic,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Arabic,S::Arabic,0,Bc::AN,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Arabic,S::Arabic,0,Bc::AN,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Arabic,S::Arabic,0,Bc::AN,Jt::U,Cb::XX,Wb::MN,Lb::NU,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Arabic,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::NonspacingMark,B::Arabic,S::Inherited,35,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::Arabic,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Arabic,S::Arabic,0,Bc::EN,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::Arabic,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::OtherPunctuation,B::Syriac,S::Syriac,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::Other,B::Syriac,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(32,C::Format,B::Syriac,S::Syriac,0,Bc::AL,Jt::T,Cb::PP,Wb::FO,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Syriac,S::Syriac,0,Bc::AL,Jt::Alaph,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Syriac,S::Syriac,36,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Syriac,S::Syriac,0,Bc::AL,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Syriac,S::Syriac,0,Bc::AL,Jt::DalathRish,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Syriac,S::Syriac,0,Bc::AL,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Syriac,S::Syriac,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Syriac,S::Syriac,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherLetter,B::ArabicSupplement,S::Arabic,0,Bc::AL,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::ArabicSupplement,S::Arabic,0,Bc::AL,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Thaana,S::Thaana,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Thaana,S::Thaana,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::Other,B::Thaana,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::NKo,S::Nko,0,Bc::R,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O), r(64,C::OtherLetter,B::NKo,S::Nko,0,Bc::R,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::NKo,S::Nko,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::NonspacingMark,B::NKo,S::Nko,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::ModifierLetter,B::NKo,S::Nko,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::NKo,S::Nko,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherPunctuation,B::NKo,S::Nko,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::NKo,S::Nko,0,Bc::ON,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::NKo,S::Nko,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O), r(64,C::ModifierLetter,B::NKo,S::Nko,0,Bc::R,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::NKo,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::NKo,S::Nko,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FM,Mc::O),
    r(64,C::CurrencySymbol,B::NKo,S::Nko,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O), r(64,C::OtherLetter,B::Samaritan,S::Samaritan,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Samaritan,S::Samaritan,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::ModifierLetter,B::Samaritan,S::Samaritan,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Samaritan,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Samaritan,S::Samaritan,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Mandaic,S::Mandaic,0,Bc::R,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::OtherLetter,B::Mandaic,S::Mandaic,0,Bc::R,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Mandaic,S::Mandaic,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::Other,B::Mandaic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Mandaic,S::Mandaic,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherLetter,B::SyriacSupplement,S::Syriac,0,Bc::AL,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::SyriacSupplement,S::Syriac,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::SyriacSupplement,S::Syriac,0,Bc::AL,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::SyriacSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::Other,B::NoBlock,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::ArabicExtendedA,S::Arabic,0,Bc::AL,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::ArabicExtendedA,S::Arabic,0,Bc::AL,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::ArabicExtendedA,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::ArabicExtendedA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::ArabicExtendedA,S::Arabic,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::ArabicExtendedA,S::Arabic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(32,C::Format,B::ArabicExtendedA,S::Common,0,Bc::AN,Jt::U,Cb::PP,Wb::FO,Lb::AL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::ArabicExtendedA,S::Arabic,27,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::ArabicExtendedA,S::Arabic,28,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::ArabicExtendedA,S::Arabic,29,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Devanagari,S::Devanagari,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Devanagari,S::Devanagari,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Devanagari,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Devanagari,S::Devanagari,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Devanagari,S::Devanagari,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Devanagari,S::Devanagari,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::SpacingMark,B::Devanagari,S::Devanagari,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::NonspacingMark,B::Devanagari,S::Devanagari,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Devanagari,S::Devanagari,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherLetter,B::Devanagari,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Devanagari,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::NonspacingMark,B::Devanagari,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O),
    r(64,C::NonspacingMark,B::Devanagari,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Devanagari,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::DecimalNumber,B::Devanagari,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Devanagari,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::ModifierLetter,B::Devanagari,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::GB,Mc::O),
    r(64,C::NonspacingMark,B::Bengali,S::Bengali,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::Other,B::Bengali,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Bengali,S::Bengali,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::SpacingMark,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::SpacingMark,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::SpacingMark,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Bengali,S::Bengali,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(192,C::SpacingMark,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Bengali,S::Bengali,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherLetter,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::IND,Mc::O),
    r(64,C::DecimalNumber,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::CurrencySymbol,B::Bengali,S::Bengali,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O),
    r(64,C::OtherNumber,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherNumber,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::CurrencySymbol,B::Bengali,S::Bengali,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O),
    r(64,C::OtherPunctuation,B::Bengali,S::Bengali,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::NonspacingMark,B::Bengali,S::Bengali,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FM,Mc::O),
    r(64,C::Other,B::Gurmukhi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::OtherLetter,B::Gurmukhi,S::Gurmukhi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Gurmukhi,S::Gurmukhi,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::SpacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::SpacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::NonspacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Gurmukhi,S::Gurmukhi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::NonspacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O), r(64,C::DecimalNumber,B::Gurmukhi,S::Gurmukhi,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O), r(64,C::OtherLetter,B::Gurmukhi,S::Gurmukhi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::GB,Mc::O),
    r(64,C::OtherLetter,B::Gurmukhi,S::Gurmukhi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Gurmukhi,S::Gurmukhi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::MBlw,Mc::O),
    r(64,C::OtherPunctuation,B::Gurmukhi,S::Gurmukhi,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::Gujarati,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Gujarati,S::Gujarati,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Gujarati,S::Gujarati,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Gujarati,S::Gujarati,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Gujarati,S::Gujarati,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::SpacingMark,B::Gujarati,S::Gujarati,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Gujarati,S::Gujarati,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::Gujarati,S::Gujarati,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Gujarati,S::Gujarati,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Gujarati,S::Gujarati,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Gujarati,S::Gujarati,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherLetter,B::Gujarati,S::Gujarati,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Gujarati,S::Gujarati,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Gujarati,S::Gujarati,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::CurrencySymbol,B::Gujarati,S::Gujarati,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::Gujarati,S::Gujarati,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O), r(64,C::Other,B::Oriya,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Oriya,S::Oriya,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Oriya,S::Oriya,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::SpacingMark,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Oriya,S::Oriya,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Oriya,S::Oriya,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(192,C::SpacingMark,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Oriya,S::Oriya,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::SpacingMark,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::DecimalNumber,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherSymbol,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherNumber,B::Oriya,S::Oriya,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Tamil,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Tamil,S::Tamil,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::OtherLetter,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::SpacingMark,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::SpacingMark,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Tamil,S::Tamil,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(192,C::SpacingMark,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Tamil,S::Tamil,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherLetter,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherNumber,B::Tamil,S::Tamil,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::Tamil,S::Tamil,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::CurrencySymbol,B::Tamil,S::Tamil,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::Telugu,S::Telugu,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Telugu,S::Telugu,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Telugu,S::Telugu,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::Telugu,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Telugu,S::Telugu,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::SpacingMark,B::Telugu,S::Telugu,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(192,C::NonspacingMark,B::Telugu,S::Telugu,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Telugu,S::Telugu,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::NonspacingMark,B::Telugu,S::Telugu,84,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Telugu,S::Telugu,91,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Telugu,S::Telugu,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::DecimalNumber,B::Telugu,S::Telugu,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Telugu,S::Telugu,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::OtherNumber,B::Telugu,S::Telugu,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::Telugu,S::Telugu,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::OtherLetter,B::Kannada,S::Kannada,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Kannada,S::Kannada,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Kannada,S::Kannada,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherPunctuation,B::Kannada,S::Kannada,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::Other,B::Kannada,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Kannada,S::Kannada,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::SpacingMark,B::Kannada,S::Kannada,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Kannada,S::Kannada,0,Bc::L,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(192,C::SpacingMark,B::Kannada,S::Kannada,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Kannada,S::Kannada,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Kannada,S::Kannada,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Kannada,S::Kannada,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::NonspacingMark,B::Kannada,S::Kannada,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::DecimalNumber,B::Kannada,S::Kannada,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::Kannada,S::Kannada,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::CS,Mc::O),
    r(64,C::NonspacingMark,B::Malayalam,S::Malayalam,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::Malayalam,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Malayalam,S::Malayalam,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::SpacingMark,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::SpacingMark,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Malayalam,S::Malayalam,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Malayalam,S::Malayalam,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::SpacingMark,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(192,C::SpacingMark,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Malayalam,S::Malayalam,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherLetter,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::PP,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherLetter,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherNumber,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherSymbol,B::Malayalam,S::Malayalam,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O),
    r(64,C::Other,B::Sinhala,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Sinhala,S::Sinhala,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Sinhala,S::Sinhala,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::OtherLetter,B::Sinhala,S::Sinhala,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Sinhala,S::Sinhala,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::SpacingMark,B::Sinhala,S::Sinhala,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::SpacingMark,B::Sinhala,S::Sinhala,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Sinhala,S::Sinhala,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Sinhala,S::Sinhala,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::SpacingMark,B::Sinhala,S::Sinhala,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(192,C::SpacingMark,B::Sinhala,S::Sinhala,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::DecimalNumber,B::Sinhala,S::Sinhala,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Sinhala,S::Sinhala,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::Thai,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Thai,S::Thai,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O), r(64,C::OtherLetter,B::Thai,S::Thai,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Thai,S::Thai,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O), r(64,C::OtherLetter,B::Thai,S::Thai,0,Bc::L,Jt::U,Cb::SM,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Thai,S::Thai,103,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Thai,S::Thai,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::O),
    r(64,C::CurrencySymbol,B::Thai,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O), r(64,C::ModifierLetter,B::Thai,S::Thai,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Thai,S::Thai,107,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::O), r(64,C::NonspacingMark,B::Thai,S::Thai,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::CMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Thai,S::Thai,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::O), r(64,C::OtherPunctuation,B::Thai,S::Thai,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::DecimalNumber,B::Thai,S::Thai,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Thai,S::Thai,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::Other,B::Lao,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Lao,S::Lao,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Lao,S::Lao,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Lao,S::Lao,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O),
    r(64,C::OtherLetter,B::Lao,S::Lao,0,Bc::L,Jt::U,Cb::SM,Wb::XX,Lb::SA,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Lao,S::Lao,118,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Lao,S::Lao,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Lao,S::Lao,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::MBlw,Mc::O),
    r(64,C::ModifierLetter,B::Lao,S::Lao,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Lao,S::Lao,122,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Lao,S::Lao,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Lao,S::Lao,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::O),
    r(64,C::DecimalNumber,B::Lao,S::Lao,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherSymbol,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::B,Mc::O), r(64,C::OtherSymbol,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::S,Mc::O),
    r(64,C::OtherPunctuation,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::GL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::OtherSymbol,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherNumber,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherSymbol,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::S,Mc::O), r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FBlw,Mc::O),
    r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,216,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O), r(68,C::OpenPunctuation,B::Tibetan,S::Tibetan,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::Tibetan,S::Tibetan,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::SpacingMark,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::Other,B::Tibetan,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,129,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,130,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(192,C::NonspacingMark,B::Tibetan,S::Tibetan,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,132,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(192,C::NonspacingMark,B::Tibetan,S::Tibetan,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::BA,Uc::IND,Mc::O), r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Tibetan,S::Tibetan,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::SUB,Mc::O),
    r(64,C::OtherPunctuation,B::Tibetan,S::Tibetan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherSymbol,B::Tibetan,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherLetter,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::C), r(64,C::OtherLetter,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::IV),
    r(64,C::SpacingMark,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::Extend,Lb::SA,Uc::VPst,Mc::VPst), r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::VAbv),
    r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::VBlw), r(64,C::SpacingMark,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VPre,Mc::VPre),
    r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::A), r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::A),
    r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMBlw,Mc::DB), r(64,C::SpacingMark,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::Extend,Lb::SA,Uc::VMPst,Mc::V),
    r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::H,Mc::H), r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::As),
    r(64,C::SpacingMark,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::MPst,Mc::MY), r(64,C::SpacingMark,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::MPre,Mc::MR),
    r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::MBlw,Mc::MW), r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::MBlw,Mc::MH),
    r(64,C::DecimalNumber,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::D0), r(64,C::DecimalNumber,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::D),
    r(64,C::OtherPunctuation,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::P), r(64,C::OtherPunctuation,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::GB,Mc::P),
    r(64,C::OtherPunctuation,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::S), r(64,C::OtherPunctuation,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::GB,Mc::C),
    r(64,C::OtherPunctuation,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::SpacingMark,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VPst,Mc::VPst),
    r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::MBlw,Mc::MY), r(64,C::SpacingMark,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::Extend,Lb::SA,Uc::VMPst,Mc::PT),
    r(64,C::NonspacingMark,B::Myanmar,S::Myanmar,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMBlw,Mc::V), r(64,C::SpacingMark,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::Extend,Lb::SA,Uc::VPst,Mc::V),
    r(64,C::OtherSymbol,B::Myanmar,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::S,Mc::S), r(64,C::UppercaseLetter,B::Georgian,S::Georgian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Georgian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::Georgian,S::Georgian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Georgian,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::ModifierLetter,B::Georgian,S::Georgian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::HangulJamo,S::Hangul,0,Bc::L,Jt::U,Cb::L,Wb::LE,Lb::JL,Uc::O,Mc::O), r(64,C::OtherLetter,B::HangulJamo,S::Hangul,0,Bc::L,Jt::U,Cb::V,Wb::LE,Lb::JV,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::HangulJamo,S::Hangul,0,Bc::L,Jt::U,Cb::T,Wb::LE,Lb::JT,Uc::O,Mc::O), r(64,C::OtherLetter,B::Ethiopic,S::Ethiopic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Ethiopic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Ethiopic,S::Ethiopic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Ethiopic,S::Ethiopic,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Ethiopic,S::Ethiopic,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherNumber,B::Ethiopic,S::Ethiopic,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::EthiopicSupplement,S::Ethiopic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::EthiopicSupplement,S::Ethiopic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::Other,B::EthiopicSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::Cherokee,S::Cherokee,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Cherokee,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::Cherokee,S::Cherokee,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::DashPunctuation,B::UnifiedCanadianAboriginalSyllabics,S::CanadianAboriginal,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::UnifiedCanadianAboriginalSyllabics,S::CanadianAboriginal,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::UnifiedCanadianAboriginalSyllabics,S::CanadianAboriginal,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherPunctuation,B::UnifiedCanadianAboriginalSyllabics,S::CanadianAboriginal,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::SpaceSeparator,B::Ogham,S::Ogham,0,Bc::WS,Jt::U,Cb::XX,Wb::WSegSpace,Lb::BA,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Ogham,S::Ogham,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(68,C::OpenPunctuation,B::Ogham,S::Ogham,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::Ogham,S::Ogham,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::Other,B::Ogham,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Runic,S::Runic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Runic,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::LetterNumber,B::Runic,S::Runic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Runic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Tagalog,S::Tagalog,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::Tagalog,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Tagalog,S::Tagalog,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Tagalog,S::Tagalog,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Tagalog,S::Tagalog,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::OtherLetter,B::Hanunoo,S::Hanunoo,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Hanunoo,S::Hanunoo,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Hanunoo,S::Hanunoo,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Hanunoo,S::Hanunoo,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::OtherPunctuation,B::Hanunoo,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::Other,B::Hanunoo,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Buhid,S::Buhid,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Buhid,S::Buhid,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Buhid,S::Buhid,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::Other,B::Buhid,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Tagbanwa,S::Tagbanwa,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::Other,B::Tagbanwa,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Tagbanwa,S::Tagbanwa,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Tagbanwa,S::Tagbanwa,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::OtherLetter,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Khmer,S::Khmer,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::O,Mc::O), r(64,C::SpacingMark,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Khmer,S::Khmer,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Khmer,S::Khmer,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VPre,Mc::O), r(64,C::NonspacingMark,B::Khmer,S::Khmer,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VMPst,Mc::O), r(64,C::NonspacingMark,B::Khmer,S::Khmer,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::FM,Mc::O),
    r(64,C::NonspacingMark,B::Khmer,S::Khmer,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::FAbv,Mc::O), r(64,C::NonspacingMark,B::Khmer,S::Khmer,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::CMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Khmer,S::Khmer,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::H,Mc::O), r(64,C::OtherPunctuation,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::IND,Mc::O), r(64,C::ModifierLetter,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::CurrencySymbol,B::Khmer,S::Khmer,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::Khmer,S::Khmer,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::FM,Mc::O), r(64,C::Other,B::Khmer,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Khmer,S::Khmer,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherNumber,B::Khmer,S::Khmer,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Mongolian,S::Mongolian,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Mongolian,S::Mongolian,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Mongolian,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Mongolian,S::Mongolian,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Mongolian,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::DashPunctuation,B::Mongolian,S::Mongolian,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Mongolian,S::Mongolian,0,Bc::ON,Jt::D,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Mongolian,S::Mongolian,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::NonspacingMark,B::Mongolian,S::Mongolian,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(32,C::Format,B::Mongolian,S::Mongolian,0,Bc::BN,Jt::U,Cb::CN,Wb::FO,Lb::GL,Uc::O,Mc::O),
    r(64,C::Other,B::Mongolian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Mongolian,S::Mongolian,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Mongolian,S::Mongolian,0,Bc::L,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::ModifierLetter,B::Mongolian,S::Mongolian,0,Bc::L,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Mongolian,S::Mongolian,0,Bc::L,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Mongolian,S::Mongolian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::GB,Mc::O),
    r(64,C::NonspacingMark,B::Mongolian,S::Mongolian,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O), r(64,C::NonspacingMark,B::Mongolian,S::Mongolian,228,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::OtherLetter,B::UnifiedCanadianAboriginalSyllabicsExtended,S::CanadianAboriginal,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::UnifiedCanadianAboriginalSyllabicsExtended,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Limbu,S::Limbu,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::GB,Mc::O),
    r(64,C::OtherLetter,B::Limbu,S::Limbu,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::Limbu,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Limbu,S::Limbu,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Limbu,S::Limbu,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::Limbu,S::Limbu,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Limbu,S::Limbu,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Limbu,S::Limbu,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::SUB,Mc::O), r(64,C::SpacingMark,B::Limbu,S::Limbu,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::FPst,Mc::O),
    r(64,C::NonspacingMark,B::Limbu,S::Limbu,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O), r(64,C::NonspacingMark,B::Limbu,S::Limbu,222,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FBlw,Mc::O),
    r(64,C::NonspacingMark,B::Limbu,S::Limbu,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Limbu,S::Limbu,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FM,Mc::O),
    r(64,C::OtherSymbol,B::Limbu,S::Limbu,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::OtherPunctuation,B::Limbu,S::Limbu,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::DecimalNumber,B::Limbu,S::Limbu,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::TaiLe,S::TaiLe,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::Other,B::TaiLe,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::NewTaiLue,S::NewTaiLue,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::Other,B::NewTaiLue,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::NewTaiLue,S::NewTaiLue,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::VMPst,Mc::O),
    r(64,C::DecimalNumber,B::NewTaiLue,S::NewTaiLue,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherNumber,B::NewTaiLue,S::NewTaiLue,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::OtherSymbol,B::NewTaiLue,S::NewTaiLue,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::S,Mc::O), r(64,C::OtherSymbol,B::KhmerSymbols,S::Khmer,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherLetter,B::Buginese,S::Buginese,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Buginese,S::Buginese,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Buginese,S::Buginese,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::SpacingMark,B::Buginese,S::Buginese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::SpacingMark,B::Buginese,S::Buginese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Buginese,S::Buginese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::Other,B::Buginese,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Buginese,S::Buginese,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O), r(64,C::SpacingMark,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::MPre,Mc::O),
    r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::MBlw,Mc::O), r(64,C::SpacingMark,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::SUB,Mc::O),
    r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::FAbv,Mc::O), r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::SUB,Mc::O), r(64,C::Other,B::TaiTham,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::H,Mc::O), r(64,C::SpacingMark,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::XX,Wb::Extend,Lb::SA,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::O), r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::O),
    r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::TaiTham,S::TaiTham,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O),
    r(64,C::DecimalNumber,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::IND,Mc::O),
    r(64,C::ModifierLetter,B::TaiTham,S::TaiTham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O), r(64,C::NonspacingMark,B::CombiningDiacriticalMarksExtended,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksExtended,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::EnclosingMark,B::CombiningDiacriticalMarksExtended,S::Inherited,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::Other,B::CombiningDiacriticalMarksExtended,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Balinese,S::Balinese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Balinese,S::Balinese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FAbv,Mc::O), r(64,C::SpacingMark,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Balinese,S::Balinese,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::SpacingMark,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Balinese,S::Balinese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Balinese,S::Balinese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(192,C::SpacingMark,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(192,C::SpacingMark,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::SpacingMark,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(192,C::SpacingMark,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Balinese,S::Balinese,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::Other,B::Balinese,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherSymbol,B::Balinese,S::Balinese,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::NonspacingMark,B::Balinese,S::Balinese,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Balinese,S::Balinese,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::NonspacingMark,B::Sundanese,S::Sundanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Sundanese,S::Sundanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FAbv,Mc::O), r(64,C::SpacingMark,B::Sundanese,S::Sundanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Sundanese,S::Sundanese,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::SpacingMark,B::Sundanese,S::Sundanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::SUB,Mc::O),
    r(64,C::NonspacingMark,B::Sundanese,S::Sundanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::SUB,Mc::O), r(64,C::NonspacingMark,B::Sundanese,S::Sundanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Sundanese,S::Sundanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::SpacingMark,B::Sundanese,S::Sundanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::SpacingMark,B::Sundanese,S::Sundanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Sundanese,S::Sundanese,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Sundanese,S::Sundanese,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::DecimalNumber,B::Sundanese,S::Sundanese,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Batak,S::Batak,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Batak,S::Batak,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::SpacingMark,B::Batak,S::Batak,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Batak,S::Batak,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Batak,S::Batak,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FAbv,Mc::O), r(64,C::SpacingMark,B::Batak,S::Batak,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::Other,B::Batak,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Batak,S::Batak,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Lepcha,S::Lepcha,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::SpacingMark,B::Lepcha,S::Lepcha,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::SUB,Mc::O),
    r(64,C::SpacingMark,B::Lepcha,S::Lepcha,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Lepcha,S::Lepcha,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::Lepcha,S::Lepcha,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Lepcha,S::Lepcha,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FAbv,Mc::O),
    r(64,C::SpacingMark,B::Lepcha,S::Lepcha,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPre,Mc::O), r(64,C::NonspacingMark,B::Lepcha,S::Lepcha,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Lepcha,S::Lepcha,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::Other,B::Lepcha,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Lepcha,S::Lepcha,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::DecimalNumber,B::Lepcha,S::Lepcha,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::DecimalNumber,B::OlChiki,S::OlChiki,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O), r(64,C::OtherLetter,B::OlChiki,S::OlChiki,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::OlChiki,S::OlChiki,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::OlChiki,S::OlChiki,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::LowercaseLetter,B::CyrillicExtendedC,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::CyrillicExtendedC,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::GeorgianExtended,S::Georgian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::GeorgianExtended,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::SundaneseSupplement,S::Sundanese,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::SundaneseSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::VedicExtensions,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::OtherPunctuation,B::VedicExtensions,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::NonspacingMark,B::VedicExtensions,S::Inherited,1,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O), r(64,C::NonspacingMark,B::VedicExtensions,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O),
    r(64,C::SpacingMark,B::VedicExtensions,S::Common,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::NonspacingMark,B::VedicExtensions,S::Inherited,1,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::VedicExtensions,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::VedicExtensions,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::VedicExtensions,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherLetter,B::VedicExtensions,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::CS,Mc::O),
    r(64,C::NonspacingMark,B::VedicExtensions,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherLetter,B::VedicExtensions,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::GB,Mc::O),
    r(64,C::Other,B::VedicExtensions,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::PhoneticExtensions,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::PhoneticExtensions,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::PhoneticExtensions,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::PhoneticExtensions,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::PhoneticExtensions,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::PhoneticExtensions,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::PhoneticExtensionsSupplement,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::PhoneticExtensionsSupplement,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::PhoneticExtensionsSupplement,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,234,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,214,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,202,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,232,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,228,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::Other,B::CombiningDiacriticalMarksSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FM,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksSupplement,S::Inherited,233,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::LatinExtendedAdditional,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::LatinExtendedAdditional,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::GreekExtended,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::GreekExtended,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::GreekExtended,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::TitlecaseLetter,B::GreekExtended,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::GreekExtended,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::GreekExtended,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::O,Mc::O),
    r(64,C::SpaceSeparator,B::GeneralPunctuation,S::Common,0,Bc::WS,Jt::U,Cb::XX,Wb::WSegSpace,Lb::BA,Uc::O,Mc::O), r(64,C::SpaceSeparator,B::GeneralPunctuation,S::Common,0,Bc::WS,Jt::U,Cb::XX,Wb::XX,Lb::GL,Uc::O,Mc::O),
    r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::XX,Lb::ZW,Uc::O,Mc::O), r(96,C::Format,B::GeneralPunctuation,S::Inherited,0,Bc::BN,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::ZWNJ,Mc::J),
    r(96,C::Format,B::GeneralPunctuation,S::Inherited,0,Bc::BN,Jt::D,Cb::ZWJ,Wb::ZWJ,Lb::ZWJ,Uc::ZWJ,Mc::J), r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::L,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::R,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O), r(64,C::DashPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::GB,Mc::O),
    r(64,C::DashPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::GL,Uc::GB,Mc::O), r(64,C::DashPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::GB,Mc::GB),
    r(64,C::DashPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::B2,Uc::GB,Mc::GB), r(64,C::DashPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::GB,Mc::GB),
    r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::InitialPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MB,Lb::QU,Uc::O,Mc::O), r(64,C::FinalPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MB,Lb::QU,Uc::O,Mc::O),
    r(64,C::OpenPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O), r(64,C::InitialPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::O,Mc::O),
    r(64,C::FinalPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::GB,Mc::GB),
    r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MB,Lb::IN,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::IN,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::ML,Lb::BA,Uc::IND,Mc::O), r(64,C::LineSeparator,B::GeneralPunctuation,S::Common,0,Bc::WS,Jt::U,Cb::CN,Wb::NL,Lb::BK,Uc::O,Mc::O),
    r(64,C::ParagraphSeparator,B::GeneralPunctuation,S::Common,0,Bc::B,Jt::U,Cb::CN,Wb::NL,Lb::BK,Uc::O,Mc::O), r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::LRE,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::RLE,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O), r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::PDF,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::LRO,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O), r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::RLO,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(64,C::SpaceSeparator,B::GeneralPunctuation,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::EX,Lb::GL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::IND,Mc::O), r(67,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::IND,Mc::O), r(64,C::ConnectorPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::EX,Lb::AL,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::GeneralPunctuation,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::O,Mc::O), r(68,C::OpenPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::MathSymbol,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::GeneralPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::FO,Lb::WJ,Uc::WJ,Mc::WJ),
    r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::FO,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::GeneralPunctuation,S::Unknown,0,Bc::L,Jt::U,Cb::CN,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::LRI,Jt::U,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O), r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::RLI,Jt::U,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::FSI,Jt::U,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O), r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::PDI,Jt::U,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(32,C::Format,B::GeneralPunctuation,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O), r(64,C::OtherNumber,B::SuperscriptsandSubscripts,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::SuperscriptsandSubscripts,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::SuperscriptsandSubscripts,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::SuperscriptsandSubscripts,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::FM,Mc::O), r(64,C::MathSymbol,B::SuperscriptsandSubscripts,S::Common,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::SuperscriptsandSubscripts,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(68,C::OpenPunctuation,B::SuperscriptsandSubscripts,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::SuperscriptsandSubscripts,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::SuperscriptsandSubscripts,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::SuperscriptsandSubscripts,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::CurrencySymbol,B::CurrencySymbols,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O),
    r(64,C::CurrencySymbol,B::CurrencySymbols,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O), r(64,C::Other,B::CurrencySymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksforSymbols,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksforSymbols,S::Inherited,1,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::EnclosingMark,B::CombiningDiacriticalMarksforSymbols,S::Inherited,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksforSymbols,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningDiacriticalMarksforSymbols,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::Other,B::CombiningDiacriticalMarksforSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::LetterlikeSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::UppercaseLetter,B::LetterlikeSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::LetterlikeSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::LetterlikeSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::LowercaseLetter,B::LetterlikeSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::LetterlikeSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::O,Mc::O), r(64,C::OtherSymbol,B::LetterlikeSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O),
    r(64,C::MathSymbol,B::LetterlikeSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(67,C::OtherSymbol,B::LetterlikeSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O),
    r(64,C::UppercaseLetter,B::LetterlikeSymbols,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::LetterlikeSymbols,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::LetterlikeSymbols,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::O,Mc::O), r(64,C::OtherSymbol,B::LetterlikeSymbols,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherLetter,B::LetterlikeSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(67,C::LowercaseLetter,B::LetterlikeSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::LetterlikeSymbols,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::LetterlikeSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherNumber,B::NumberForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherNumber,B::NumberForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O),
    r(64,C::LetterNumber,B::NumberForms,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::O,Mc::O), r(64,C::LetterNumber,B::NumberForms,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::NumberForms,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::NumberForms,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::NumberForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::Other,B::NumberForms,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::Arrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(67,C::MathSymbol,B::Arrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O),
    r(67,C::OtherSymbol,B::Arrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::MathSymbol,B::Arrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::Arrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(67,C::OtherSymbol,B::Arrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::MathSymbol,B::MathematicalOperators,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::MathSymbol,B::MathematicalOperators,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::MathematicalOperators,S::Common,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::O,Mc::O), r(64,C::MathSymbol,B::MathematicalOperators,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::MathematicalOperators,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::IN,Uc::O,Mc::O), r(64,C::OtherSymbol,B::MiscellaneousTechnical,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(68,C::OpenPunctuation,B::MiscellaneousTechnical,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O), r(72,C::ClosePunctuation,B::MiscellaneousTechnical,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::MiscellaneousTechnical,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(67,C::OtherSymbol,B::MiscellaneousTechnical,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::MathSymbol,B::MiscellaneousTechnical,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(67,C::OtherSymbol,B::MiscellaneousTechnical,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::MiscellaneousTechnical,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(66,C::OtherSymbol,B::MiscellaneousTechnical,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::ControlPictures,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::Other,B::ControlPictures,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::OpticalCharacterRecognition,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::Other,B::OpticalCharacterRecognition,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::EnclosedAlphanumerics,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::OtherNumber,B::EnclosedAlphanumerics,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::EnclosedAlphanumerics,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::OtherSymbol,B::EnclosedAlphanumerics,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::EnclosedAlphanumerics,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::S,Mc::O), r(64,C::OtherNumber,B::EnclosedAlphanumerics,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::BoxDrawing,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::OtherSymbol,B::BoxDrawing,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::BlockElements,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::OtherSymbol,B::BlockElements,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::GeometricShapes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::OtherSymbol,B::GeometricShapes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::GeometricShapes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(67,C::OtherSymbol,B::GeometricShapes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O),
    r(64,C::MathSymbol,B::GeometricShapes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::OtherSymbol,B::GeometricShapes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::GB),
    r(64,C::MathSymbol,B::GeometricShapes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(67,C::MathSymbol,B::GeometricShapes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::GB,Mc::GB),
    r(67,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(67,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(66,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O),
    r(66,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(67,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(66,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EB,Uc::S,Mc::O), r(66,C::MathSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O),
    r(66,C::OtherSymbol,B::MiscellaneousSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(66,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(67,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(67,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EB,Uc::S,Mc::O),
    r(66,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(67,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::S,Mc::O), r(64,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::S,Mc::O), r(68,C::OpenPunctuation,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::OtherNumber,B::Dingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::MiscellaneousMathematicalSymbolsA,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(68,C::OpenPunctuation,B::MiscellaneousMathematicalSymbolsA,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::MiscellaneousMathematicalSymbolsA,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::MathSymbol,B::SupplementalArrowsA,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::BraillePatterns,S::Braille,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::MathSymbol,B::SupplementalArrowsB,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(67,C::MathSymbol,B::SupplementalArrowsB,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::MathSymbol,B::MiscellaneousMathematicalSymbolsB,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(68,C::OpenPunctuation,B::MiscellaneousMathematicalSymbolsB,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::MiscellaneousMathematicalSymbolsB,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O),
    r(64,C::ClosePunctuation,B::MiscellaneousMathematicalSymbolsB,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::SupplementalMathematicalOperators,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::MiscellaneousSymbolsandArrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::MiscellaneousSymbolsandArrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::MathSymbol,B::MiscellaneousSymbolsandArrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(67,C::OtherSymbol,B::MiscellaneousSymbolsandArrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::OtherSymbol,B::MiscellaneousSymbolsandArrows,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O),
    r(64,C::Other,B::MiscellaneousSymbolsandArrows,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::Glagolitic,S::Glagolitic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Glagolitic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::Glagolitic,S::Glagolitic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::LatinExtendedC,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::LatinExtendedC,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::LatinExtendedC,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::Coptic,S::Coptic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::Coptic,S::Coptic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::Coptic,S::Coptic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::Coptic,S::Coptic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::Other,B::Coptic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Coptic,S::Coptic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Coptic,S::Coptic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherNumber,B::Coptic,S::Coptic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::GeorgianSupplement,S::Georgian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::GeorgianSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Tifinagh,S::Tifinagh,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Tifinagh,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::ModifierLetter,B::Tifinagh,S::Tifinagh,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Tifinagh,S::Tifinagh,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::NonspacingMark,B::Tifinagh,S::Tifinagh,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherLetter,B::EthiopicExtended,S::Ethiopic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::EthiopicExtended,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CyrillicExtendedA,S::Cyrillic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::IND,Mc::O),
    r(64,C::InitialPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::O,Mc::O), r(64,C::FinalPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::DashPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::IND,Mc::O),
    r(64,C::DashPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(68,C::OpenPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::ModifierLetter,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::DashPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::B2,Uc::O,Mc::O),
    r(64,C::OpenPunctuation,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O), r(64,C::OtherSymbol,B::SupplementalPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::Other,B::SupplementalPunctuation,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::CJKRadicalsSupplement,S::Han,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::Other,B::CJKRadicalsSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::KangxiRadicals,S::Han,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::Other,B::KangxiRadicals,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::IdeographicDescriptionCharacters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::Other,B::IdeographicDescriptionCharacters,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::SpaceSeparator,B::CJKSymbolsandPunctuation,S::Common,0,Bc::WS,Jt::U,Cb::XX,Wb::WSegSpace,Lb::BA,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::IND,Mc::O),
    r(64,C::OtherSymbol,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(64,C::ModifierLetter,B::CJKSymbolsandPunctuation,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::NS,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CJKSymbolsandPunctuation,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::LetterNumber,B::CJKSymbolsandPunctuation,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(68,C::OpenPunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O), r(72,C::ClosePunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O),
    r(64,C::DashPunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::O,Mc::O), r(64,C::OpenPunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(64,C::ClosePunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::CJKSymbolsandPunctuation,S::Inherited,218,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CJKSymbolsandPunctuation,S::Inherited,228,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CJKSymbolsandPunctuation,S::Inherited,232,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CJKSymbolsandPunctuation,S::Inherited,222,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::SpacingMark,B::CJKSymbolsandPunctuation,S::Hangul,224,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(67,C::DashPunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::ModifierLetter,B::CJKSymbolsandPunctuation,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::ID,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::CJKSymbolsandPunctuation,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::CM,Uc::O,Mc::O), r(64,C::OtherLetter,B::CJKSymbolsandPunctuation,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::NS,Uc::O,Mc::O),
    r(67,C::OtherPunctuation,B::CJKSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::IND,Mc::O), r(64,C::Other,B::Hiragana,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Hiragana,S::Hiragana,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::CJ,Uc::O,Mc::O), r(64,C::OtherLetter,B::Hiragana,S::Hiragana,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Hiragana,S::Inherited,8,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::Hiragana,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::KA,Lb::NS,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::Hiragana,S::Hiragana,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::O,Mc::O), r(64,C::DashPunctuation,B::Katakana,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::KA,Lb::NS,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Katakana,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::CJ,Uc::O,Mc::O), r(64,C::OtherLetter,B::Katakana,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Katakana,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::IND,Mc::O), r(64,C::ModifierLetter,B::Katakana,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::CJ,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::Katakana,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::NS,Uc::O,Mc::O), r(64,C::Other,B::Bopomofo,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Bopomofo,S::Bopomofo,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::HangulCompatibilityJamo,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::HangulCompatibilityJamo,S::Hangul,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::ID,Uc::O,Mc::O), r(64,C::OtherSymbol,B::Kanbun,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherNumber,B::Kanbun,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::OtherLetter,B::BopomofoExtended,S::Bopomofo,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::CJKStrokes,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(64,C::Other,B::CJKStrokes,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::KatakanaPhoneticExtensions,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::CJ,Uc::O,Mc::O), r(64,C::OtherSymbol,B::EnclosedCJKLettersandMonths,S::Hangul,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::EnclosedCJKLettersandMonths,S::Hangul,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(64,C::Other,B::EnclosedCJKLettersandMonths,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::EnclosedCJKLettersandMonths,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::OtherSymbol,B::EnclosedCJKLettersandMonths,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherNumber,B::EnclosedCJKLettersandMonths,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(64,C::OtherSymbol,B::EnclosedCJKLettersandMonths,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherNumber,B::EnclosedCJKLettersandMonths,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(67,C::OtherSymbol,B::EnclosedCJKLettersandMonths,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::EnclosedCJKLettersandMonths,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::ID,Uc::S,Mc::O), r(64,C::OtherSymbol,B::CJKCompatibility,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::CJKCompatibility,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(64,C::OtherSymbol,B::CJKCompatibility,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherLetter,B::CJKUnifiedIdeographsExtensionA,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::OtherSymbol,B::YijingHexagramSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherLetter,B::CJKUnifiedIdeographs,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::CJKUnifiedIdeographs,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::YiSyllables,S::Yi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::ID,Uc::O,Mc::O), r(64,C::ModifierLetter,B::YiSyllables,S::Yi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::NS,Uc::O,Mc::O),
    r(64,C::Other,B::YiSyllables,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::YiRadicals,S::Yi,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::Other,B::YiRadicals,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Lisu,S::Lisu,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::Lisu,S::Lisu,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Lisu,S::Lisu,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Vai,S::Vai,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::Vai,S::Vai,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Vai,S::Vai,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Vai,S::Vai,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::DecimalNumber,B::Vai,S::Vai,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O), r(64,C::Other,B::Vai,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::CyrillicExtendedB,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::CyrillicExtendedB,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CyrillicExtendedB,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::CyrillicExtendedB,S::Cyrillic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::EnclosingMark,B::CyrillicExtendedB,S::Cyrillic,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::CyrillicExtendedB,S::Cyrillic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::ModifierLetter,B::CyrillicExtendedB,S::Cyrillic,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::CyrillicExtendedB,S::Cyrillic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Bamum,S::Bamum,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LetterNumber,B::Bamum,S::Bamum,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Bamum,S::Bamum,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Bamum,S::Bamum,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Bamum,S::Bamum,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::Other,B::Bamum,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::ModifierToneLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::ModifierToneLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::ModifierToneLetters,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::LatinExtendedD,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::LatinExtendedD,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::LatinExtendedD,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::LatinExtendedD,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::LatinExtendedD,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::LatinExtendedD,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::LatinExtendedD,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::LatinExtendedD,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::SylotiNagri,S::SylotiNagri,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::SylotiNagri,S::SylotiNagri,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::SylotiNagri,S::SylotiNagri,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::NonspacingMark,B::SylotiNagri,S::SylotiNagri,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::SylotiNagri,S::SylotiNagri,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::SylotiNagri,S::SylotiNagri,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::OtherSymbol,B::SylotiNagri,S::SylotiNagri,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::SylotiNagri,S::SylotiNagri,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::Other,B::SylotiNagri,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::CommonIndicNumberForms,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::CommonIndicNumberForms,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::CurrencySymbol,B::CommonIndicNumberForms,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O), r(64,C::OtherSymbol,B::CommonIndicNumberForms,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::Other,B::CommonIndicNumberForms,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Phagspa,S::PhagsPa,0,Bc::L,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Phagspa,S::PhagsPa,0,Bc::L,Jt::L,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::OtherLetter,B::Phagspa,S::PhagsPa,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Phagspa,S::PhagsPa,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Phagspa,S::PhagsPa,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::Other,B::Phagspa,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::SpacingMark,B::Saurashtra,S::Saurashtra,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Saurashtra,S::Saurashtra,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::SpacingMark,B::Saurashtra,S::Saurashtra,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::MPst,Mc::O),
    r(64,C::SpacingMark,B::Saurashtra,S::Saurashtra,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Saurashtra,S::Saurashtra,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::NonspacingMark,B::Saurashtra,S::Saurashtra,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::Other,B::Saurashtra,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Saurashtra,S::Saurashtra,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::DecimalNumber,B::Saurashtra,S::Saurashtra,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::DevanagariExtended,S::Devanagari,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::OtherLetter,B::DevanagariExtended,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::DevanagariExtended,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::DevanagariExtended,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::DevanagariExtended,S::Devanagari,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::NonspacingMark,B::DevanagariExtended,S::Devanagari,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::DecimalNumber,B::KayahLi,S::KayahLi,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::KayahLi,S::KayahLi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::KayahLi,S::KayahLi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::KayahLi,S::KayahLi,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O),
    r(64,C::OtherPunctuation,B::KayahLi,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::KayahLi,S::KayahLi,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Rejang,S::Rejang,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Rejang,S::Rejang,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Rejang,S::Rejang,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Rejang,S::Rejang,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FAbv,Mc::O),
    r(64,C::SpacingMark,B::Rejang,S::Rejang,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::FPst,Mc::O), r(64,C::SpacingMark,B::Rejang,S::Rejang,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::Other,B::Rejang,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Rejang,S::Rejang,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::HangulJamoExtendedA,S::Hangul,0,Bc::L,Jt::U,Cb::L,Wb::LE,Lb::JL,Uc::O,Mc::O), r(64,C::Other,B::HangulJamoExtendedA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Javanese,S::Javanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Javanese,S::Javanese,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::SpacingMark,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Javanese,S::Javanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Javanese,S::Javanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::SpacingMark,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::Javanese,S::Javanese,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::MBlw,Mc::O), r(64,C::SpacingMark,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::MPst,Mc::O),
    r(64,C::SpacingMark,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::SpacingMark,B::Javanese,S::Javanese,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherPunctuation,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::Other,B::Javanese,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::ModifierLetter,B::Javanese,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Javanese,S::Javanese,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::MyanmarExtendedB,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::MyanmarExtendedB,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O), r(64,C::ModifierLetter,B::MyanmarExtendedB,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::MyanmarExtendedB,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::Other,B::MyanmarExtendedB,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Cham,S::Cham,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Cham,S::Cham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Cham,S::Cham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Cham,S::Cham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::Cham,S::Cham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::SpacingMark,B::Cham,S::Cham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::MPst,Mc::O),
    r(64,C::SpacingMark,B::Cham,S::Cham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::MPre,Mc::O), r(64,C::NonspacingMark,B::Cham,S::Cham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::MAbv,Mc::O),
    r(64,C::NonspacingMark,B::Cham,S::Cham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::MBlw,Mc::O), r(64,C::Other,B::Cham,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Cham,S::Cham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FAbv,Mc::O), r(64,C::SpacingMark,B::Cham,S::Cham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::FPst,Mc::O),
    r(64,C::DecimalNumber,B::Cham,S::Cham,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Cham,S::Cham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Cham,S::Cham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherLetter,B::MyanmarExtendedA,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::C),
    r(64,C::ModifierLetter,B::MyanmarExtendedA,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::S), r(64,C::OtherLetter,B::MyanmarExtendedA,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::GB,Mc::C),
    r(64,C::OtherSymbol,B::MyanmarExtendedA,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::S,Mc::S), r(64,C::SpacingMark,B::MyanmarExtendedA,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::Extend,Lb::SA,Uc::VMPst,Mc::PT),
    r(64,C::NonspacingMark,B::MyanmarExtendedA,S::Myanmar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::R), r(64,C::SpacingMark,B::MyanmarExtendedA,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::Extend,Lb::SA,Uc::VMPst,Mc::R),
    r(64,C::OtherLetter,B::MyanmarExtendedA,S::Myanmar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::R), r(64,C::OtherLetter,B::TaiViet,S::TaiViet,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::TaiViet,S::TaiViet,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::TaiViet,S::TaiViet,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::TaiViet,S::TaiViet,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VMAbv,Mc::O), r(64,C::Other,B::TaiViet,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::TaiViet,S::TaiViet,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O), r(64,C::ModifierLetter,B::TaiViet,S::TaiViet,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::TaiViet,S::TaiViet,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::IND,Mc::O), r(64,C::OtherLetter,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::SpacingMark,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::OtherPunctuation,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::SpacingMark,B::MeeteiMayekExtensions,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::NonspacingMark,B::MeeteiMayekExtensions,S::MeeteiMayek,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::Other,B::MeeteiMayekExtensions,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::Other,B::EthiopicExtendedA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::EthiopicExtendedA,S::Ethiopic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::LatinExtendedE,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::LatinExtendedE,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::LatinExtendedE,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::LatinExtendedE,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::LatinExtendedE,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::LatinExtendedE,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::CherokeeSupplement,S::Cherokee,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::MeeteiMayek,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::SpacingMark,B::MeeteiMayek,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::MeeteiMayek,S::MeeteiMayek,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::MeeteiMayek,S::MeeteiMayek,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::OtherPunctuation,B::MeeteiMayek,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::SpacingMark,B::MeeteiMayek,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::NonspacingMark,B::MeeteiMayek,S::MeeteiMayek,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::Other,B::MeeteiMayek,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::MeeteiMayek,S::MeeteiMayek,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::HangulSyllables,S::Hangul,0,Bc::L,Jt::U,Cb::LV,Wb::LE,Lb::H2,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::HangulSyllables,S::Hangul,0,Bc::L,Jt::U,Cb::LVT,Wb::LE,Lb::H3,Uc::O,Mc::O), r(64,C::Other,B::HangulSyllables,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::HangulJamoExtendedB,S::Hangul,0,Bc::L,Jt::U,Cb::V,Wb::LE,Lb::JV,Uc::O,Mc::O), r(64,C::Other,B::HangulJamoExtendedB,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::HangulJamoExtendedB,S::Hangul,0,Bc::L,Jt::U,Cb::T,Wb::LE,Lb::JT,Uc::O,Mc::O), r(64,C::Surrogate,B::HighSurrogates,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SG,Uc::O,Mc::O),
    r(64,C::Surrogate,B::HighPrivateUseSurrogates,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SG,Uc::O,Mc::O), r(64,C::Surrogate,B::LowSurrogates,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SG,Uc::O,Mc::O),
    r(64,C::PrivateUse,B::PrivateUseArea,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::CJKCompatibilityIdeographs,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::Other,B::CJKCompatibilityIdeographs,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::AlphabeticPresentationForms,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::AlphabeticPresentationForms,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::AlphabeticPresentationForms,S::Armenian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::AlphabeticPresentationForms,S::Hebrew,0,Bc::R,Jt::U,Cb::XX,Wb::HL,Lb::HL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::AlphabeticPresentationForms,S::Hebrew,26,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::AlphabeticPresentationForms,S::Hebrew,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::ArabicPresentationFormsA,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::ModifierSymbol,B::ArabicPresentationFormsA,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::ArabicPresentationFormsA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::ClosePunctuation,B::ArabicPresentationFormsA,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::OpenPunctuation,B::ArabicPresentationFormsA,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(64,C::CurrencySymbol,B::ArabicPresentationFormsA,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O), r(64,C::OtherSymbol,B::ArabicPresentationFormsA,S::Arabic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(80,C::NonspacingMark,B::VariationSelectors,S::Inherited,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::IND,Mc::VS), r(64,C::OtherPunctuation,B::VerticalForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MN,Lb::IS,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::VerticalForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::VerticalForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::ML,Lb::IS,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::VerticalForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O), r(64,C::OpenPunctuation,B::VerticalForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(64,C::ClosePunctuation,B::VerticalForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::VerticalForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::IN,Uc::IND,Mc::O),
    r(64,C::Other,B::VerticalForms,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::CombiningHalfMarks,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CombiningHalfMarks,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::CombiningHalfMarks,S::Cyrillic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::CJKCompatibilityForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::IND,Mc::O), r(64,C::DashPunctuation,B::CJKCompatibilityForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::ConnectorPunctuation,B::CJKCompatibilityForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::EX,Lb::ID,Uc::O,Mc::O), r(64,C::OpenPunctuation,B::CJKCompatibilityForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(64,C::ClosePunctuation,B::CJKCompatibilityForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::SmallFormVariants,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::MN,Lb::CL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::SmallFormVariants,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::SmallFormVariants,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::MB,Lb::CL,Uc::IND,Mc::O),
    r(64,C::Other,B::SmallFormVariants,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::SmallFormVariants,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MN,Lb::NS,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::SmallFormVariants,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::ML,Lb::NS,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::SmallFormVariants,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::DashPunctuation,B::SmallFormVariants,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(68,C::OpenPunctuation,B::SmallFormVariants,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::SmallFormVariants,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::SmallFormVariants,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::IND,Mc::O),
    r(64,C::MathSymbol,B::SmallFormVariants,S::Common,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::DashPunctuation,B::SmallFormVariants,S::Common,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::SmallFormVariants,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::CurrencySymbol,B::SmallFormVariants,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O),
    r(64,C::OtherPunctuation,B::SmallFormVariants,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::IND,Mc::O), r(64,C::OtherLetter,B::ArabicPresentationFormsB,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::ArabicPresentationFormsB,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(32,C::Format,B::ArabicPresentationFormsB,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::FO,Lb::WJ,Uc::O,Mc::O),
    r(64,C::Other,B::HalfwidthandFullwidthForms,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::IND,Mc::O),
    r(64,C::CurrencySymbol,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O), r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MB,Lb::ID,Uc::IND,Mc::O), r(68,C::OpenPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::O,Mc::O),
    r(72,C::ClosePunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::O,Mc::O), r(64,C::MathSymbol,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::MN,Lb::CL,Uc::IND,Mc::O), r(64,C::DashPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ES,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::MB,Lb::CL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::IND,Mc::O),
    r(64,C::DecimalNumber,B::HalfwidthandFullwidthForms,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::NU,Lb::ID,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::CS,Jt::U,Cb::XX,Wb::ML,Lb::NS,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::MN,Lb::NS,Uc::IND,Mc::O), r(64,C::MathSymbol,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::HalfwidthandFullwidthForms,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::ID,Uc::O,Mc::O), r(64,C::ModifierSymbol,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::ConnectorPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::EX,Lb::ID,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::HalfwidthandFullwidthForms,S::Latin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::HalfwidthandFullwidthForms,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::ID,Uc::O,Mc::O), r(64,C::OtherLetter,B::HalfwidthandFullwidthForms,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::CJ,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::HalfwidthandFullwidthForms,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::CJ,Uc::O,Mc::O), r(64,C::ModifierLetter,B::HalfwidthandFullwidthForms,S::Common,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::NS,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::HalfwidthandFullwidthForms,S::Hangul,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::ID,Uc::O,Mc::O), r(64,C::CurrencySymbol,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(64,C::OtherSymbol,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::MathSymbol,B::HalfwidthandFullwidthForms,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Specials,S::Unknown,0,Bc::L,Jt::U,Cb::CN,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(32,C::Format,B::Specials,S::Common,0,Bc::ON,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O), r(64,C::OtherSymbol,B::Specials,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::CB,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::Specials,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::Other,B::Specials,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::LinearBSyllabary,S::LinearB,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::LinearBSyllabary,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::LinearBIdeograms,S::LinearB,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::LinearBIdeograms,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::AegeanNumbers,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::AegeanNumbers,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::Other,B::AegeanNumbers,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherNumber,B::AegeanNumbers,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::AegeanNumbers,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::LetterNumber,B::AncientGreekNumbers,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::AncientGreekNumbers,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::AncientGreekNumbers,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::AncientGreekNumbers,S::Greek,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::Other,B::AncientGreekNumbers,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::AncientSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::Other,B::AncientSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::AncientSymbols,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::OtherSymbol,B::PhaistosDisc,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::PhaistosDisc,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::Other,B::PhaistosDisc,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Lycian,S::Lycian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Lycian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Carian,S::Carian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Carian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::CopticEpactNumbers,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherNumber,B::CopticEpactNumbers,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::CopticEpactNumbers,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::OldItalic,S::OldItalic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::OldItalic,S::OldItalic,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::OldItalic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Gothic,S::Gothic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LetterNumber,B::Gothic,S::Gothic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Gothic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::OldPermic,S::OldPermic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::OldPermic,S::OldPermic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::Other,B::OldPermic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Ugaritic,S::Ugaritic,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Ugaritic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Ugaritic,S::Ugaritic,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherLetter,B::OldPersian,S::OldPersian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::OldPersian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::OldPersian,S::OldPersian,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::LetterNumber,B::OldPersian,S::OldPersian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::Deseret,S::Deseret,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::Deseret,S::Deseret,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Shavian,S::Shavian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Osmanya,S::Osmanya,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Osmanya,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Osmanya,S::Osmanya,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::Osage,S::Osage,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Osage,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::Osage,S::Osage,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Elbasan,S::Elbasan,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Elbasan,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CaucasianAlbanian,S::CaucasianAlbanian,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::CaucasianAlbanian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::CaucasianAlbanian,S::CaucasianAlbanian,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherLetter,B::LinearA,S::LinearA,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::LinearA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::CypriotSyllabary,S::Cypriot,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::CypriotSyllabary,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::ImperialAramaic,S::ImperialAramaic,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::ImperialAramaic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::ImperialAramaic,S::ImperialAramaic,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherNumber,B::ImperialAramaic,S::ImperialAramaic,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Palmyrene,S::Palmyrene,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::Palmyrene,S::Palmyrene,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::OtherNumber,B::Palmyrene,S::Palmyrene,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Nabataean,S::Nabataean,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Nabataean,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::Nabataean,S::Nabataean,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Hatran,S::Hatran,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Hatran,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherNumber,B::Hatran,S::Hatran,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Phoenician,S::Phoenician,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherNumber,B::Phoenician,S::Phoenician,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Phoenician,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Phoenician,S::Phoenician,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Lydian,S::Lydian,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Lydian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Lydian,S::Lydian,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherLetter,B::MeroiticHieroglyphs,S::MeroiticHieroglyphs,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::MeroiticCursive,S::MeroiticCursive,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::MeroiticCursive,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::MeroiticCursive,S::MeroiticCursive,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Kharoshthi,S::Kharoshthi,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::Other,B::Kharoshthi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O), r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O),
    r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,1,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::NonspacingMark,B::Kharoshthi,S::Kharoshthi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherNumber,B::Kharoshthi,S::Kharoshthi,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Kharoshthi,S::Kharoshthi,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Kharoshthi,S::Kharoshthi,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::OldSouthArabian,S::OldSouthArabian,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherNumber,B::OldSouthArabian,S::OldSouthArabian,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::OldSouthArabian,S::OldSouthArabian,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherLetter,B::OldNorthArabian,S::OldNorthArabian,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::OldNorthArabian,S::OldNorthArabian,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Manichaean,S::Manichaean,0,Bc::R,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Manichaean,S::Manichaean,0,Bc::R,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::OtherLetter,B::Manichaean,S::Manichaean,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherSymbol,B::Manichaean,S::Manichaean,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::OtherLetter,B::Manichaean,S::Manichaean,0,Bc::R,Jt::L,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Manichaean,S::Manichaean,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O), r(64,C::NonspacingMark,B::Manichaean,S::Manichaean,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::Other,B::Manichaean,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherNumber,B::Manichaean,S::Manichaean,0,Bc::R,Jt::D,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::Manichaean,S::Manichaean,0,Bc::R,Jt::R,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Manichaean,S::Manichaean,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Manichaean,S::Manichaean,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::IN,Uc::IND,Mc::O), r(64,C::OtherLetter,B::Avestan,S::Avestan,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Avestan,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Avestan,S::Avestan,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::InscriptionalParthian,S::InscriptionalParthian,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::InscriptionalParthian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::InscriptionalParthian,S::InscriptionalParthian,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::InscriptionalPahlavi,S::InscriptionalPahlavi,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::InscriptionalPahlavi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherNumber,B::InscriptionalPahlavi,S::InscriptionalPahlavi,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::PsalterPahlavi,S::PsalterPahlavi,0,Bc::R,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::PsalterPahlavi,S::PsalterPahlavi,0,Bc::R,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::PsalterPahlavi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::PsalterPahlavi,S::PsalterPahlavi,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherNumber,B::PsalterPahlavi,S::PsalterPahlavi,0,Bc::R,Jt::R,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherNumber,B::PsalterPahlavi,S::PsalterPahlavi,0,Bc::R,Jt::D,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::PsalterPahlavi,S::PsalterPahlavi,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::OldTurkic,S::OldTurkic,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::OldTurkic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::OldHungarian,S::OldHungarian,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::OldHungarian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::OldHungarian,S::OldHungarian,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::OldHungarian,S::OldHungarian,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::HanifiRohingya,S::HanifiRohingya,0,Bc::AL,Jt::L,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::HanifiRohingya,S::HanifiRohingya,0,Bc::AL,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::OtherLetter,B::HanifiRohingya,S::HanifiRohingya,0,Bc::AL,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::HanifiRohingya,S::HanifiRohingya,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::NonspacingMark,B::HanifiRohingya,S::HanifiRohingya,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O), r(64,C::Other,B::HanifiRohingya,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::HanifiRohingya,S::HanifiRohingya,0,Bc::AN,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherNumber,B::RumiNumeralSymbols,S::Arabic,0,Bc::AN,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::RumiNumeralSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Yezidi,S::Yezidi,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Yezidi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Yezidi,S::Yezidi,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::DashPunctuation,B::Yezidi,S::Yezidi,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::O,Mc::O), r(64,C::OtherLetter,B::OldSogdian,S::OldSogdian,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::OldSogdian,S::OldSogdian,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::OldSogdian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Sogdian,S::Sogdian,0,Bc::AL,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::OtherLetter,B::Sogdian,S::Sogdian,0,Bc::AL,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Sogdian,S::Sogdian,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Sogdian,S::Sogdian,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O),
    r(64,C::NonspacingMark,B::Sogdian,S::Sogdian,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMBlw,Mc::O), r(64,C::OtherNumber,B::Sogdian,S::Sogdian,0,Bc::AL,Jt::D,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherNumber,B::Sogdian,S::Sogdian,0,Bc::AL,Jt::R,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Sogdian,S::Sogdian,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::Other,B::Sogdian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Chorasmian,S::Chorasmian,0,Bc::R,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Chorasmian,S::Chorasmian,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Chorasmian,S::Chorasmian,0,Bc::R,Jt::R,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::Chorasmian,S::Chorasmian,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherNumber,B::Chorasmian,S::Chorasmian,0,Bc::R,Jt::R,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::Chorasmian,S::Chorasmian,0,Bc::R,Jt::D,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherNumber,B::Chorasmian,S::Chorasmian,0,Bc::R,Jt::L,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Chorasmian,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Elymaic,S::Elymaic,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Elymaic,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::SpacingMark,B::Brahmi,S::Brahmi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::NonspacingMark,B::Brahmi,S::Brahmi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::OtherLetter,B::Brahmi,S::Brahmi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Brahmi,S::Brahmi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Brahmi,S::Brahmi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Brahmi,S::Brahmi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherPunctuation,B::Brahmi,S::Brahmi,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Brahmi,S::Brahmi,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::Brahmi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::Brahmi,S::Brahmi,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::N,Mc::O), r(64,C::DecimalNumber,B::Brahmi,S::Brahmi,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Brahmi,S::Brahmi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::HN,Mc::O), r(64,C::NonspacingMark,B::Kaithi,S::Kaithi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Kaithi,S::Kaithi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::OtherLetter,B::Kaithi,S::Kaithi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::SpacingMark,B::Kaithi,S::Kaithi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Kaithi,S::Kaithi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::Kaithi,S::Kaithi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Kaithi,S::Kaithi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Kaithi,S::Kaithi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::NonspacingMark,B::Kaithi,S::Kaithi,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::OtherPunctuation,B::Kaithi,S::Kaithi,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(32,C::Format,B::Kaithi,S::Kaithi,0,Bc::L,Jt::U,Cb::PP,Wb::FO,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Kaithi,S::Kaithi,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::Other,B::Kaithi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::SoraSompeng,S::SoraSompeng,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::SoraSompeng,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::SoraSompeng,S::SoraSompeng,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Chakma,S::Chakma,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::OtherLetter,B::Chakma,S::Chakma,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Chakma,S::Chakma,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::Chakma,S::Chakma,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(192,C::NonspacingMark,B::Chakma,S::Chakma,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Chakma,S::Chakma,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::NonspacingMark,B::Chakma,S::Chakma,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::Other,B::Chakma,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Chakma,S::Chakma,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Chakma,S::Chakma,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::SpacingMark,B::Chakma,S::Chakma,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::OtherLetter,B::Mahajani,S::Mahajani,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Mahajani,S::Mahajani,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::OtherPunctuation,B::Mahajani,S::Mahajani,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Mahajani,S::Mahajani,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Mahajani,S::Mahajani,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Mahajani,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Sharada,S::Sharada,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::SpacingMark,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::SpacingMark,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::NonspacingMark,B::Sharada,S::Sharada,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Sharada,S::Sharada,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::SpacingMark,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Sharada,S::Sharada,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherLetter,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::PP,Wb::LE,Lb::AL,Uc::R,Mc::O),
    r(64,C::OtherLetter,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::NonspacingMark,B::Sharada,S::Sharada,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FM,Mc::O),
    r(64,C::NonspacingMark,B::Sharada,S::Sharada,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::DecimalNumber,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Sharada,S::Sharada,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::Other,B::SinhalaArchaicNumbers,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::SinhalaArchaicNumbers,S::Sinhala,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O), r(64,C::OtherLetter,B::Khojki,S::Khojki,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::Other,B::Khojki,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::SpacingMark,B::Khojki,S::Khojki,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Khojki,S::Khojki,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Khojki,S::Khojki,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Khojki,S::Khojki,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Khojki,S::Khojki,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Khojki,S::Khojki,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::NonspacingMark,B::Khojki,S::Khojki,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Khojki,S::Khojki,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O), r(64,C::OtherPunctuation,B::Khojki,S::Khojki,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Khojki,S::Khojki,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherLetter,B::Multani,S::Multani,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::Other,B::Multani,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Multani,S::Multani,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Khudawadi,S::Khudawadi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Khudawadi,S::Khudawadi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Khudawadi,S::Khudawadi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Khudawadi,S::Khudawadi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::Khudawadi,S::Khudawadi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Khudawadi,S::Khudawadi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Khudawadi,S::Khudawadi,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::NonspacingMark,B::Khudawadi,S::Khudawadi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::Other,B::Khudawadi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Khudawadi,S::Khudawadi,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Grantha,S::Grantha,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Grantha,S::Grantha,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::Other,B::Grantha,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Grantha,S::Grantha,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Grantha,S::Inherited,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::NonspacingMark,B::Grantha,S::Grantha,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::SpacingMark,B::Grantha,S::Grantha,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Grantha,S::Grantha,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Grantha,S::Grantha,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::SpacingMark,B::Grantha,S::Grantha,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(192,C::SpacingMark,B::Grantha,S::Grantha,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Grantha,S::Grantha,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherLetter,B::Grantha,S::Grantha,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Grantha,S::Grantha,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::OtherLetter,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::SpacingMark,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::SpacingMark,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::NonspacingMark,B::Newa,S::Newa,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Newa,S::Newa,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Newa,S::Newa,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::NonspacingMark,B::Newa,S::Newa,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::NonspacingMark,B::Newa,S::Newa,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::OtherLetter,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::DecimalNumber,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::Other,B::Newa,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::Newa,S::Newa,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FM,Mc::O), r(64,C::OtherLetter,B::Newa,S::Newa,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::CS,Mc::O),
    r(64,C::OtherLetter,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::SpacingMark,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::SpacingMark,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Tirhuta,S::Tirhuta,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::Tirhuta,S::Tirhuta,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(192,C::SpacingMark,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Tirhuta,S::Tirhuta,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::NonspacingMark,B::Tirhuta,S::Tirhuta,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::NonspacingMark,B::Tirhuta,S::Tirhuta,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::OtherPunctuation,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::Tirhuta,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Tirhuta,S::Tirhuta,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::SpacingMark,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::SpacingMark,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Siddham,S::Siddham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::Other,B::Siddham,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(192,C::SpacingMark,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Siddham,S::Siddham,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::NonspacingMark,B::Siddham,S::Siddham,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::NonspacingMark,B::Siddham,S::Siddham,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::OtherPunctuation,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::Siddham,S::Siddham,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::Modi,S::Modi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::SpacingMark,B::Modi,S::Modi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Modi,S::Modi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Modi,S::Modi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Modi,S::Modi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Modi,S::Modi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::NonspacingMark,B::Modi,S::Modi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherPunctuation,B::Modi,S::Modi,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Modi,S::Modi,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::OtherLetter,B::Modi,S::Modi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Modi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Modi,S::Modi,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::MongolianSupplement,S::Mongolian,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::Other,B::MongolianSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Takri,S::Takri,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Takri,S::Takri,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Takri,S::Takri,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::NonspacingMark,B::Takri,S::Takri,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Takri,S::Takri,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::SpacingMark,B::Takri,S::Takri,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::Takri,S::Takri,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::SpacingMark,B::Takri,S::Takri,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::NonspacingMark,B::Takri,S::Takri,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O), r(64,C::Other,B::Takri,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Takri,S::Takri,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::Ahom,S::Ahom,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O),
    r(64,C::Other,B::Ahom,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Ahom,S::Ahom,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::MBlw,Mc::O),
    r(64,C::NonspacingMark,B::Ahom,S::Ahom,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Ahom,S::Ahom,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::MAbv,Mc::O),
    r(64,C::SpacingMark,B::Ahom,S::Ahom,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Ahom,S::Ahom,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Ahom,S::Ahom,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VBlw,Mc::O), r(64,C::SpacingMark,B::Ahom,S::Ahom,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::SA,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::Ahom,S::Ahom,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::SA,Uc::VAbv,Mc::O), r(64,C::DecimalNumber,B::Ahom,S::Ahom,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherNumber,B::Ahom,S::Ahom,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Ahom,S::Ahom,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherSymbol,B::Ahom,S::Ahom,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::SA,Uc::S,Mc::O), r(64,C::OtherLetter,B::Dogra,S::Dogra,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::SpacingMark,B::Dogra,S::Dogra,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Dogra,S::Dogra,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::Dogra,S::Dogra,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Dogra,S::Dogra,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Dogra,S::Dogra,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::Dogra,S::Dogra,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::NonspacingMark,B::Dogra,S::Dogra,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::NonspacingMark,B::Dogra,S::Dogra,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::OtherPunctuation,B::Dogra,S::Dogra,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::Dogra,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::WarangCiti,S::WarangCiti,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::WarangCiti,S::WarangCiti,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::WarangCiti,S::WarangCiti,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O), r(64,C::OtherNumber,B::WarangCiti,S::WarangCiti,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::WarangCiti,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::WarangCiti,S::WarangCiti,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::DivesAkuru,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::SpacingMark,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::SpacingMark,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(192,C::SpacingMark,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::DivesAkuru,S::DivesAkuru,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::DivesAkuru,S::DivesAkuru,9,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::DivesAkuru,S::DivesAkuru,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherLetter,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::PP,Wb::LE,Lb::AL,Uc::R,Mc::O),
    r(64,C::SpacingMark,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::MPst,Mc::O), r(64,C::OtherLetter,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::PP,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::SpacingMark,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::DivesAkuru,S::DivesAkuru,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::OtherPunctuation,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::DecimalNumber,B::DivesAkuru,S::DivesAkuru,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Nandinagari,S::Nandinagari,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::Nandinagari,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::SpacingMark,B::Nandinagari,S::Nandinagari,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::SpacingMark,B::Nandinagari,S::Nandinagari,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O),
    r(64,C::NonspacingMark,B::Nandinagari,S::Nandinagari,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Nandinagari,S::Nandinagari,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Nandinagari,S::Nandinagari,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::NonspacingMark,B::Nandinagari,S::Nandinagari,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherPunctuation,B::Nandinagari,S::Nandinagari,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::OtherLetter,B::Nandinagari,S::Nandinagari,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::L,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FM,Mc::O), r(64,C::NonspacingMark,B::ZanabazarSquare,S::ZanabazarSquare,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::SpacingMark,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O),
    r(64,C::OtherLetter,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::L,Jt::U,Cb::PP,Wb::LE,Lb::AL,Uc::R,Mc::O), r(64,C::NonspacingMark,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::MBlw,Mc::O),
    r(64,C::OtherPunctuation,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::GB,Mc::O), r(64,C::OtherPunctuation,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::ZanabazarSquare,S::ZanabazarSquare,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::NonspacingMark,B::ZanabazarSquare,S::ZanabazarSquare,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::Other,B::ZanabazarSquare,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::Soyombo,S::Soyombo,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::NonspacingMark,B::Soyombo,S::Soyombo,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Soyombo,S::Soyombo,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::Soyombo,S::Soyombo,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::OtherLetter,B::Soyombo,S::Soyombo,0,Bc::L,Jt::U,Cb::PP,Wb::LE,Lb::AL,Uc::R,Mc::O),
    r(64,C::NonspacingMark,B::Soyombo,S::Soyombo,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::FBlw,Mc::O), r(64,C::NonspacingMark,B::Soyombo,S::Soyombo,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Soyombo,S::Soyombo,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::NonspacingMark,B::Soyombo,S::Soyombo,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Soyombo,S::Soyombo,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O), r(64,C::OtherPunctuation,B::Soyombo,S::Soyombo,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Soyombo,S::Soyombo,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O), r(64,C::Other,B::Soyombo,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::PauCinHau,S::PauCinHau,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::PauCinHau,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Bhaiksuki,S::Bhaiksuki,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::Bhaiksuki,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::SpacingMark,B::Bhaiksuki,S::Bhaiksuki,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Bhaiksuki,S::Bhaiksuki,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::NonspacingMark,B::Bhaiksuki,S::Bhaiksuki,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::Bhaiksuki,S::Bhaiksuki,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::Bhaiksuki,S::Bhaiksuki,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::NonspacingMark,B::Bhaiksuki,S::Bhaiksuki,9,Bc::L,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherPunctuation,B::Bhaiksuki,S::Bhaiksuki,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::DecimalNumber,B::Bhaiksuki,S::Bhaiksuki,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherNumber,B::Bhaiksuki,S::Bhaiksuki,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O), r(64,C::OtherPunctuation,B::Marchen,S::Marchen,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BB,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Marchen,S::Marchen,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::EX,Uc::IND,Mc::O), r(64,C::OtherLetter,B::Marchen,S::Marchen,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::Other,B::Marchen,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Marchen,S::Marchen,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::SUB,Mc::O),
    r(64,C::SpacingMark,B::Marchen,S::Marchen,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::SUB,Mc::O), r(64,C::NonspacingMark,B::Marchen,S::Marchen,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::Marchen,S::Marchen,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::NonspacingMark,B::Marchen,S::Marchen,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O),
    r(64,C::SpacingMark,B::Marchen,S::Marchen,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O), r(64,C::NonspacingMark,B::Marchen,S::Marchen,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::OtherLetter,B::MasaramGondi,S::MasaramGondi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::MasaramGondi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::MasaramGondi,S::MasaramGondi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::MasaramGondi,S::MasaramGondi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::NonspacingMark,B::MasaramGondi,S::MasaramGondi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O), r(64,C::NonspacingMark,B::MasaramGondi,S::MasaramGondi,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::NonspacingMark,B::MasaramGondi,S::MasaramGondi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O), r(64,C::NonspacingMark,B::MasaramGondi,S::MasaramGondi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherLetter,B::MasaramGondi,S::MasaramGondi,0,Bc::L,Jt::U,Cb::PP,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::NonspacingMark,B::MasaramGondi,S::MasaramGondi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::MBlw,Mc::O),
    r(64,C::DecimalNumber,B::MasaramGondi,S::MasaramGondi,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherLetter,B::GunjalaGondi,S::GunjalaGondi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::Other,B::GunjalaGondi,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::SpacingMark,B::GunjalaGondi,S::GunjalaGondi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::NonspacingMark,B::GunjalaGondi,S::GunjalaGondi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::GunjalaGondi,S::GunjalaGondi,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::SpacingMark,B::GunjalaGondi,S::GunjalaGondi,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VMPst,Mc::O), r(64,C::NonspacingMark,B::GunjalaGondi,S::GunjalaGondi,9,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::H,Mc::O),
    r(64,C::OtherLetter,B::GunjalaGondi,S::GunjalaGondi,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::DecimalNumber,B::GunjalaGondi,S::GunjalaGondi,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Makasar,S::Makasar,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::OtherLetter,B::Makasar,S::Makasar,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::GB,Mc::O),
    r(64,C::NonspacingMark,B::Makasar,S::Makasar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VAbv,Mc::O), r(64,C::NonspacingMark,B::Makasar,S::Makasar,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VBlw,Mc::O),
    r(64,C::SpacingMark,B::Makasar,S::Makasar,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPre,Mc::O), r(64,C::SpacingMark,B::Makasar,S::Makasar,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::VPst,Mc::O),
    r(64,C::OtherPunctuation,B::Makasar,S::Makasar,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::Makasar,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::LisuSupplement,S::Lisu,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::LisuSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::TamilSupplement,S::Tamil,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::TamilSupplement,S::Tamil,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::CurrencySymbol,B::TamilSupplement,S::Tamil,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O), r(64,C::Other,B::TamilSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::TamilSupplement,S::Tamil,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherLetter,B::Cuneiform,S::Cuneiform,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::Cuneiform,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::LetterNumber,B::CuneiformNumbersandPunctuation,S::Cuneiform,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::CuneiformNumbersandPunctuation,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::CuneiformNumbersandPunctuation,S::Cuneiform,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::EarlyDynasticCuneiform,S::Cuneiform,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::EarlyDynasticCuneiform,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::EgyptianHieroglyphs,S::EgyptianHieroglyphs,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::EgyptianHieroglyphs,S::EgyptianHieroglyphs,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::OP,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::EgyptianHieroglyphs,S::EgyptianHieroglyphs,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::CL,Uc::O,Mc::O), r(64,C::Other,B::EgyptianHieroglyphs,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(32,C::Format,B::EgyptianHieroglyphFormatControls,S::EgyptianHieroglyphs,0,Bc::L,Jt::T,Cb::CN,Wb::FO,Lb::GL,Uc::O,Mc::O),
    r(32,C::Format,B::EgyptianHieroglyphFormatControls,S::EgyptianHieroglyphs,0,Bc::L,Jt::T,Cb::CN,Wb::FO,Lb::OP,Uc::O,Mc::O),
    r(32,C::Format,B::EgyptianHieroglyphFormatControls,S::EgyptianHieroglyphs,0,Bc::L,Jt::T,Cb::CN,Wb::FO,Lb::CL,Uc::O,Mc::O), r(64,C::Other,B::EgyptianHieroglyphFormatControls,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::AnatolianHieroglyphs,S::AnatolianHieroglyphs,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::AnatolianHieroglyphs,S::AnatolianHieroglyphs,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::OP,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::AnatolianHieroglyphs,S::AnatolianHieroglyphs,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::CL,Uc::O,Mc::O), r(64,C::Other,B::AnatolianHieroglyphs,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::BamumSupplement,S::Bamum,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::BamumSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Mro,S::Mro,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::Mro,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::Mro,S::Mro,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Mro,S::Mro,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::BassaVah,S::BassaVah,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::BassaVah,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::BassaVah,S::BassaVah,1,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::BassaVah,S::BassaVah,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherLetter,B::PahawhHmong,S::PahawhHmong,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::PahawhHmong,S::PahawhHmong,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::OtherPunctuation,B::PahawhHmong,S::PahawhHmong,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(64,C::OtherPunctuation,B::PahawhHmong,S::PahawhHmong,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O),
    r(64,C::OtherSymbol,B::PahawhHmong,S::PahawhHmong,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::ModifierLetter,B::PahawhHmong,S::PahawhHmong,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::PahawhHmong,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::DecimalNumber,B::PahawhHmong,S::PahawhHmong,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::PahawhHmong,S::PahawhHmong,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::PahawhHmong,S::PahawhHmong,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::UppercaseLetter,B::Medefaidrin,S::Medefaidrin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::LowercaseLetter,B::Medefaidrin,S::Medefaidrin,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::Medefaidrin,S::Medefaidrin,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::Medefaidrin,S::Medefaidrin,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::Medefaidrin,S::Medefaidrin,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::Medefaidrin,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Miao,S::Miao,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::OtherLetter,B::Miao,S::Miao,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::Other,B::Miao,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Miao,S::Miao,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMBlw,Mc::O),
    r(64,C::SpacingMark,B::Miao,S::Miao,0,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Miao,S::Miao,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::Miao,S::Miao,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::ModifierLetter,B::IdeographicSymbolsandPunctuation,S::Tangut,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::NS,Uc::O,Mc::O),
    r(64,C::ModifierLetter,B::IdeographicSymbolsandPunctuation,S::Nushu,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::NS,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::IdeographicSymbolsandPunctuation,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::IND,Mc::O),
    r(64,C::ModifierLetter,B::IdeographicSymbolsandPunctuation,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::NS,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::IdeographicSymbolsandPunctuation,S::KhitanSmallScript,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::GL,Uc::O,Mc::O),
    r(64,C::Other,B::IdeographicSymbolsandPunctuation,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::SpacingMark,B::IdeographicSymbolsandPunctuation,S::Han,6,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Tangut,S::Tangut,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::Tangut,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::TangutComponents,S::Tangut,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::OtherLetter,B::KhitanSmallScript,S::KhitanSmallScript,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::KhitanSmallScript,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::TangutSupplement,S::Tangut,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::Other,B::TangutSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherLetter,B::KanaSupplement,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::KanaSupplement,S::Hiragana,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::OtherLetter,B::KanaExtendedA,S::Hiragana,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::Other,B::KanaExtendedA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::Other,B::SmallKanaExtension,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::SmallKanaExtension,S::Hiragana,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::CJ,Uc::O,Mc::O), r(64,C::OtherLetter,B::SmallKanaExtension,S::Katakana,0,Bc::L,Jt::U,Cb::XX,Wb::KA,Lb::CJ,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Nushu,S::Nushu,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::Nushu,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::Duployan,S::Duployan,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::Duployan,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::B,Mc::O),
    r(64,C::Other,B::Duployan,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::Duployan,S::Duployan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::Duployan,S::Duployan,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::Duployan,S::Duployan,1,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherPunctuation,B::Duployan,S::Duployan,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O), r(32,C::Format,B::ShorthandFormatControls,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(64,C::Other,B::ShorthandFormatControls,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::ByzantineMusicalSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::Other,B::ByzantineMusicalSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::MusicalSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::Other,B::MusicalSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::SpacingMark,B::MusicalSymbols,S::Common,216,Bc::L,Jt::U,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::SpacingMark,B::MusicalSymbols,S::Common,216,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::MusicalSymbols,S::Inherited,1,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::SpacingMark,B::MusicalSymbols,S::Common,226,Bc::L,Jt::U,Cb::SM,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(32,C::Format,B::MusicalSymbols,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::MusicalSymbols,S::Inherited,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::NonspacingMark,B::MusicalSymbols,S::Inherited,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::AncientGreekMusicalNotation,S::Greek,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::NonspacingMark,B::AncientGreekMusicalNotation,S::Greek,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O),
    r(64,C::Other,B::AncientGreekMusicalNotation,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherNumber,B::MayanNumerals,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::MayanNumerals,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherSymbol,B::TaiXuanJingSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::Other,B::TaiXuanJingSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherNumber,B::CountingRodNumerals,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::CountingRodNumerals,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::MathematicalAlphanumericSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::LowercaseLetter,B::MathematicalAlphanumericSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::MathematicalAlphanumericSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::MathematicalAlphanumericSymbols,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::MathSymbol,B::MathematicalAlphanumericSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::DecimalNumber,B::MathematicalAlphanumericSymbols,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O), r(64,C::OtherSymbol,B::SuttonSignWriting,S::SignWriting,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::NonspacingMark,B::SuttonSignWriting,S::SignWriting,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::OtherPunctuation,B::SuttonSignWriting,S::SignWriting,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::BA,Uc::IND,Mc::O),
    r(64,C::OtherPunctuation,B::SuttonSignWriting,S::SignWriting,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::IND,Mc::O), r(64,C::Other,B::SuttonSignWriting,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::GlagoliticSupplement,S::Glagolitic,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::Other,B::GlagoliticSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::NyiakengPuachueHmong,S::NyiakengPuachueHmong,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::Other,B::NyiakengPuachueHmong,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::NyiakengPuachueHmong,S::NyiakengPuachueHmong,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::ModifierLetter,B::NyiakengPuachueHmong,S::NyiakengPuachueHmong,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::DecimalNumber,B::NyiakengPuachueHmong,S::NyiakengPuachueHmong,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::OtherSymbol,B::NyiakengPuachueHmong,S::NyiakengPuachueHmong,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::B,Mc::O),
    r(64,C::OtherLetter,B::Wancho,S::Wancho,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Wancho,S::Wancho,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::VMAbv,Mc::O),
    r(64,C::DecimalNumber,B::Wancho,S::Wancho,0,Bc::L,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O), r(64,C::Other,B::Wancho,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::CurrencySymbol,B::Wancho,S::Wancho,0,Bc::ET,Jt::U,Cb::XX,Wb::XX,Lb::PR,Uc::S,Mc::O), r(64,C::OtherLetter,B::MendeKikakui,S::MendeKikakui,0,Bc::R,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O),
    r(64,C::Other,B::MendeKikakui,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::OtherNumber,B::MendeKikakui,S::MendeKikakui,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O),
    r(64,C::NonspacingMark,B::MendeKikakui,S::MendeKikakui,220,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::UppercaseLetter,B::Adlam,S::Adlam,0,Bc::R,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::LowercaseLetter,B::Adlam,S::Adlam,0,Bc::R,Jt::D,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O), r(64,C::NonspacingMark,B::Adlam,S::Adlam,230,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O),
    r(64,C::NonspacingMark,B::Adlam,S::Adlam,7,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::CMAbv,Mc::O), r(64,C::ModifierLetter,B::Adlam,S::Adlam,0,Bc::R,Jt::T,Cb::XX,Wb::LE,Lb::AL,Uc::B,Mc::O),
    r(64,C::Other,B::Adlam,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::DecimalNumber,B::Adlam,S::Adlam,0,Bc::R,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::B,Mc::O),
    r(64,C::OtherPunctuation,B::Adlam,S::Adlam,0,Bc::R,Jt::U,Cb::XX,Wb::XX,Lb::OP,Uc::IND,Mc::O), r(64,C::Other,B::IndicSiyaqNumbers,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::IndicSiyaqNumbers,S::Common,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::IndicSiyaqNumbers,S::Common,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O),
    r(64,C::CurrencySymbol,B::IndicSiyaqNumbers,S::Common,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::PO,Uc::S,Mc::O), r(64,C::Other,B::OttomanSiyaqNumbers,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::OttomanSiyaqNumbers,S::Common,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(64,C::OtherSymbol,B::OttomanSiyaqNumbers,S::Common,0,Bc::AL,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherLetter,B::ArabicMathematicalAlphabeticSymbols,S::Arabic,0,Bc::AL,Jt::U,Cb::XX,Wb::LE,Lb::AL,Uc::O,Mc::O), r(64,C::Other,B::ArabicMathematicalAlphabeticSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::MathSymbol,B::ArabicMathematicalAlphabeticSymbols,S::Arabic,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::O,Mc::O), r(66,C::OtherSymbol,B::MahjongTiles,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::MahjongTiles,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(66,C::Other,B::MahjongTiles,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(66,C::OtherSymbol,B::DominoTiles,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(66,C::Other,B::DominoTiles,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(66,C::OtherSymbol,B::PlayingCards,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(66,C::Other,B::PlayingCards,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(67,C::OtherSymbol,B::PlayingCards,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(64,C::OtherNumber,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O),
    r(64,C::OtherNumber,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::O,Mc::O), r(66,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(64,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(66,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(64,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(67,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::LE,Lb::AI,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::AI,Uc::S,Mc::O), r(66,C::Other,B::EnclosedAlphanumericSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(65,C::OtherSymbol,B::EnclosedAlphanumericSupplement,S::Common,0,Bc::L,Jt::U,Cb::RI,Wb::RI,Lb::RI,Uc::S,Mc::O), r(64,C::OtherSymbol,B::EnclosedIdeographicSupplement,S::Hiragana,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::EnclosedIdeographicSupplement,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(66,C::Other,B::EnclosedIdeographicSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::EnclosedIdeographicSupplement,S::Common,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(66,C::OtherSymbol,B::EnclosedIdeographicSupplement,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::MiscellaneousSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(66,C::OtherSymbol,B::MiscellaneousSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::MiscellaneousSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EB,Uc::S,Mc::O), r(66,C::OtherSymbol,B::MiscellaneousSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::MiscellaneousSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(65,C::ModifierSymbol,B::MiscellaneousSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::EX,Wb::Extend,Lb::EM,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::MiscellaneousSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(67,C::OtherSymbol,B::Emoticons,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::Emoticons,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EB,Uc::S,Mc::O), r(64,C::OtherSymbol,B::OrnamentalDingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::OrnamentalDingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::QU,Uc::S,Mc::O), r(64,C::OtherSymbol,B::OrnamentalDingbats,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::NS,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::TransportandMapSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(67,C::OtherSymbol,B::TransportandMapSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EB,Uc::S,Mc::O),
    r(66,C::OtherSymbol,B::TransportandMapSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(66,C::Other,B::TransportandMapSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::AlchemicalSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(66,C::Other,B::AlchemicalSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherSymbol,B::GeometricShapesExtended,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(66,C::OtherSymbol,B::GeometricShapesExtended,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(66,C::Other,B::GeometricShapesExtended,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(67,C::OtherSymbol,B::GeometricShapesExtended,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::SupplementalArrowsC,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(66,C::Other,B::SupplementalArrowsC,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(66,C::OtherSymbol,B::SupplementalArrowsC,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(64,C::OtherSymbol,B::SupplementalSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(67,C::OtherSymbol,B::SupplementalSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::EB,Uc::S,Mc::O), r(67,C::OtherSymbol,B::SupplementalSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(64,C::OtherSymbol,B::SupplementalSymbolsandPictographs,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(66,C::Other,B::SupplementalSymbolsandPictographs,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(66,C::OtherSymbol,B::ChessSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O), r(66,C::Other,B::ChessSymbols,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(66,C::OtherSymbol,B::ChessSymbols,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O), r(67,C::OtherSymbol,B::SymbolsandPictographsExtendedA,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::S,Mc::O),
    r(66,C::Other,B::SymbolsandPictographsExtendedA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::OtherSymbol,B::SymbolsforLegacyComputing,S::Common,0,Bc::ON,Jt::U,Cb::XX,Wb::XX,Lb::AL,Uc::S,Mc::O),
    r(64,C::Other,B::SymbolsforLegacyComputing,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::DecimalNumber,B::SymbolsforLegacyComputing,S::Common,0,Bc::EN,Jt::U,Cb::XX,Wb::NU,Lb::NU,Uc::O,Mc::O),
    r(66,C::Other,B::NoBlock,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::OtherLetter,B::CJKUnifiedIdeographsExtensionB,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::Other,B::CJKUnifiedIdeographsExtensionB,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::NoBlock,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CJKUnifiedIdeographsExtensionC,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::CJKUnifiedIdeographsExtensionC,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CJKUnifiedIdeographsExtensionD,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::CJKUnifiedIdeographsExtensionD,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CJKUnifiedIdeographsExtensionE,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::CJKUnifiedIdeographsExtensionE,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CJKUnifiedIdeographsExtensionF,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::CJKUnifiedIdeographsExtensionF,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CJKCompatibilityIdeographsSupplement,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::CJKCompatibilityIdeographsSupplement,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::OtherLetter,B::CJKUnifiedIdeographsExtensionG,S::Han,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O), r(64,C::Other,B::CJKUnifiedIdeographsExtensionG,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::ID,Uc::O,Mc::O),
    r(64,C::Other,B::Tags,S::Unknown,0,Bc::L,Jt::U,Cb::CN,Wb::XX,Lb::XX,Uc::O,Mc::O), r(32,C::Format,B::Tags,S::Common,0,Bc::BN,Jt::T,Cb::CN,Wb::FO,Lb::CM,Uc::O,Mc::O),
    r(32,C::Format,B::Tags,S::Common,0,Bc::BN,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::Other,B::NoBlock,S::Unknown,0,Bc::L,Jt::U,Cb::CN,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(80,C::NonspacingMark,B::VariationSelectorsSupplement,S::Inherited,0,Bc::NSM,Jt::T,Cb::EX,Wb::Extend,Lb::CM,Uc::O,Mc::O), r(64,C::PrivateUse,B::SupplementaryPrivateUseAreaA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::Other,B::SupplementaryPrivateUseAreaA,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O), r(64,C::PrivateUse,B::SupplementaryPrivateUseAreaB,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
    r(64,C::Other,B::SupplementaryPrivateUseAreaB,S::Unknown,0,Bc::L,Jt::U,Cb::XX,Wb::XX,Lb::XX,Uc::O,Mc::O),
];

pub const COMPOSE0_COUNT: usize = 377;
pub const COMPOSE1_COUNT: usize = 63;

#[rustfmt::skip]
pub const COMPOSE0: [(u32, u16, u16); 212] = [
    (60,2,0), (65,15,3), (82,8,19), (97,15,28), (114,8,44), (168,0,53), (194,0,54), (196,3,55),
    (202,0,59), (207,0,60), (212,2,61), (216,0,64), (220,0,65), (226,0,66), (228,3,67), (234,0,71),
    (239,0,72), (244,2,73), (248,0,76), (252,0,77), (258,1,78), (274,1,80), (332,1,82), (346,1,84),
    (352,1,86), (360,3,88), (383,0,92), (416,1,93), (431,1,95), (439,0,97), (490,1,98),
    (550,3,100), (558,1,104), (658,0,106), (913,0,107), (917,0,108), (919,0,109), (921,0,110),
    (927,0,111), (929,0,112), (933,0,113), (937,0,114), (940,0,115), (942,0,116), (945,0,117),
    (949,0,118), (951,0,119), (953,0,120), (959,0,121), (961,0,122), (965,0,123), (969,2,124),
    (974,0,127), (978,0,128), (1030,0,129), (1040,0,130), (1043,0,131), (1045,3,132), (1050,0,136),
    (1054,0,137), (1059,0,138), (1063,0,139), (1067,0,140), (1069,0,141), (1072,0,142),
    (1075,0,143), (1077,3,144), (1082,0,148), (1086,0,149), (1091,0,150), (1095,0,151),
    (1099,0,152), (1101,0,153), (1110,0,154), (1140,1,155), (1240,1,157), (1256,1,159),
    (1575,0,161), (1608,0,162), (1610,0,163), (1729,0,164), (1746,0,165), (1749,0,166),
    (2344,0,167), (2352,0,168), (2355,0,169), (2503,0,170), (2887,0,171), (2962,0,172),
    (3014,1,173), (3142,0,175), (3263,0,176), (3270,0,177), (3274,0,178), (3398,1,179),
    (3545,0,181), (3548,0,182), (4133,0,183), (6917,0,184), (6919,0,185), (6921,0,186),
    (6923,0,187), (6925,0,188), (6929,0,189), (6970,0,190), (6972,0,191), (6974,1,192),
    (6978,0,194), (7734,1,195), (7770,1,197), (7778,1,199), (7840,1,201), (7864,1,203),
    (7884,1,205), (7936,17,207), (7960,1,225), (7968,17,227), (7992,1,245), (8000,1,247),
    (8008,1,249), (8016,1,251), (8025,0,253), (8032,16,254), (8052,0,271), (8060,0,272),
    (8118,0,273), (8127,0,274), (8134,0,275), (8182,0,276), (8190,0,277), (8592,0,278),
    (8594,0,279), (8596,0,280), (8656,0,281), (8658,0,282), (8660,0,283), (8707,0,284),
    (8712,0,285), (8715,0,286), (8739,0,287), (8741,0,288), (8764,0,289), (8771,0,290),
    (8773,0,291), (8776,0,292), (8781,0,293), (8801,0,294), (8804,1,295), (8818,1,297),
    (8822,1,299), (8826,3,301), (8834,1,305), (8838,1,307), (8849,1,309), (8866,0,311),
    (8872,1,312), (8875,0,314), (8882,3,315), (12358,0,319), (12363,0,320), (12365,0,321),
    (12367,0,322), (12369,0,323), (12371,0,324), (12373,0,325), (12375,0,326), (12377,0,327),
    (12379,0,328), (12381,0,329), (12383,0,330), (12385,0,331), (12388,0,332), (12390,0,333),
    (12392,0,334), (12399,0,335), (12402,0,336), (12405,0,337), (12408,0,338), (12411,0,339),
    (12445,0,340), (12454,0,341), (12459,0,342), (12461,0,343), (12463,0,344), (12465,0,345),
    (12467,0,346), (12469,0,347), (12471,0,348), (12473,0,349), (12475,0,350), (12477,0,351),
    (12479,0,352), (12481,0,353), (12484,0,354), (12486,0,355), (12488,0,356), (12495,0,357),
    (12498,0,358), (12501,0,359), (12504,0,360), (12507,0,361), (12527,3,362), (12541,0,366),
    (69785,0,367), (69787,0,368), (69797,0,369), (69937,1,370), (70471,0,372), (70841,0,373),
    (71096,1,374), (71989,0,376), (0,0,0),
];

#[rustfmt::skip]
pub const COMPOSE1: [(u32, u16, u16); 41] = [
    (768,4,0), (774,6,5), (783,0,12), (785,0,13), (787,1,14), (795,0,16), (803,5,17), (813,1,23),
    (816,1,25), (824,0,27), (834,0,28), (837,0,29), (1619,2,30), (2364,0,33), (2494,0,34),
    (2519,0,35), (2878,0,36), (2902,1,37), (3006,0,39), (3031,0,40), (3158,0,41), (3266,0,42),
    (3285,1,43), (3390,0,45), (3415,0,46), (3530,0,47), (3535,0,48), (3551,0,49), (4142,0,50),
    (6965,0,51), (12441,1,52), (69818,0,54), (69927,0,55), (70462,0,56), (70487,0,57),
    (70832,0,58), (70842,0,59), (70845,0,60), (71087,0,61), (71984,0,62), (0,0,0),
];

#[rustfmt::skip]
const COMPOSE_INDEX0: [u16; 2969] = [
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 4, 5, 6, 7, 0, 0, 0, 0, 0,
    8, 9, 10, 0, 0, 0, 0, 11, 12, 0, 13, 0, 0, 0, 0, 0, 14, 15, 16, 0, 0, 0, 0, 17, 18, 19, 20, 0,
    0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 22, 23, 24, 0, 0, 0, 0, 0, 25, 26, 27, 0, 0, 0, 0, 28, 29,
    30, 31, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 33, 34, 35, 36, 0, 0, 0, 0, 37, 38, 39, 40, 0, 0,
    0, 0, 41, 0, 42, 0, 0, 0, 0, 0, 43, 44, 45, 46, 0, 0, 0, 47, 48, 49, 50, 0, 0, 0, 0, 51, 52, 0,
    0, 0, 0, 0, 0, 53, 54, 55, 56, 0, 0, 0, 0, 57, 58, 59, 60, 0, 0, 0, 0, 0, 61, 62, 63, 0, 0, 0,
    0, 64, 65, 66, 67, 0, 0, 0, 0, 68, 0, 69, 0, 0, 0, 0, 0, 70, 0, 71, 0, 0, 0, 0, 0, 72, 0, 0, 0,
    0, 0, 0, 73, 74, 75, 0, 0, 0, 0, 0, 76, 77, 78, 79, 0, 0, 0, 0, 80, 81, 82, 83, 0, 0, 0, 0, 0,
    84, 85, 86, 0, 0, 0, 0, 87, 88, 89, 0, 0, 0, 0, 0, 90, 91, 92, 93, 0, 0, 0, 0, 94, 95, 96, 97,
    0, 0, 0, 0, 98, 0, 0, 0, 0, 0, 0, 99, 100, 101, 102, 0, 0, 0, 0, 103, 104, 105, 106, 0, 0, 0,
    0, 107, 108, 109, 110, 0, 0, 0, 0, 111, 112, 0, 0, 0, 0, 0, 0, 113, 114, 115, 116, 0, 0, 0, 0,
    117, 118, 119, 120, 0, 0, 0, 0, 121, 0, 122, 0, 0, 0, 0, 123, 124, 125, 126, 127, 0, 0, 0, 128,
    129, 130, 131, 0, 0, 0, 0, 132, 133, 0, 0, 0, 0, 0, 0, 134, 135, 136, 137, 0, 0, 0, 0, 138,
    139, 140, 141, 0, 0, 0, 0, 0, 142, 143, 144, 0, 0, 0, 0, 145, 146, 147, 148, 0, 0, 0, 0, 149,
    0, 150, 0, 0, 0, 0, 151, 152, 153, 154, 0, 0, 0, 0, 0, 155, 0, 0, 0, 0, 0, 0, 156, 157, 158, 0,
    0, 0, 0, 0, 159, 160, 161, 162, 0, 0, 0, 0, 163, 0, 0, 164, 0, 0, 0, 0, 165, 166, 0, 0, 0, 0,
    0, 0, 167, 0, 0, 0, 0, 0, 0, 0, 168, 0, 0, 0, 0, 0, 0, 0, 169, 0, 0, 0, 0, 0, 0, 170, 0, 0, 0,
    0, 0, 0, 0, 171, 172, 0, 0, 0, 0, 0, 0, 173, 0, 0, 0, 0, 0, 0, 0, 174, 175, 0, 0, 0, 0, 0, 0,
    176, 177, 0, 0, 0, 0, 0, 0, 178, 0, 0, 0, 0, 0, 0, 0, 179, 0, 0, 0, 0, 0, 0, 180, 181, 182, 0,
    0, 0, 0, 0, 183, 184, 0, 0, 0, 0, 0, 0, 0, 185, 0, 0, 0, 0, 0, 0, 186, 0, 0, 0, 0, 0, 0, 0,
    187, 0, 0, 0, 0, 0, 0, 0, 188, 0, 0, 0, 0, 0, 0, 0, 189, 190, 0, 0, 0, 0, 0, 0, 191, 0, 0, 0,
    0, 0, 0, 192, 193, 0, 0, 0, 0, 0, 0, 194, 195, 0, 0, 0, 0, 0, 0, 0, 196, 0, 0, 0, 0, 0, 0, 197,
    0, 0, 0, 0, 0, 0, 0, 198, 199, 0, 0, 0, 0, 0, 0, 200, 201, 0, 0, 0, 0, 0, 0, 202, 203, 0, 0, 0,
    0, 0, 0, 204, 0, 0, 0, 0, 0, 0, 205, 206, 0, 0, 0, 0, 0, 0, 207, 0, 0, 0, 0, 0, 0, 0, 208, 0,
    0, 0, 0, 0, 0, 0, 0, 209, 0, 0, 0, 0, 0, 0, 0, 210, 0, 0, 0, 0, 0, 0, 0, 211, 0, 0, 0, 0, 0, 0,
    212, 0, 0, 0, 0, 0, 0, 0, 213, 0, 0, 0, 0, 0, 0, 0, 214, 0, 0, 0, 0, 0, 0, 0, 215, 0, 0, 0, 0,
    0, 0, 0, 216, 0, 0, 0, 0, 0, 0, 0, 217, 0, 0, 0, 0, 0, 0, 218, 219, 220, 0, 0, 0, 0, 0, 221,
    222, 223, 0, 0, 0, 0, 0, 224, 225, 226, 0, 0, 0, 0, 0, 227, 228, 229, 0, 0, 0, 0, 0, 0, 230, 0,
    0, 0, 0, 0, 0, 231, 0, 0, 0, 0, 0, 0, 0, 232, 0, 0, 0, 0, 0, 0, 0, 233, 0, 0, 0, 0, 0, 0, 234,
    0, 0, 0, 0, 0, 0, 0, 235, 0, 0, 0, 0, 0, 0, 0, 236, 0, 0, 0, 0, 0, 0, 0, 237, 0, 0, 0, 0, 0, 0,
    0, 238, 0, 0, 0, 0, 0, 0, 0, 0, 239, 0, 0, 0, 0, 0, 240, 241, 242, 0, 243, 0, 0, 0, 244, 0,
    245, 0, 0, 0, 0, 0, 246, 0, 247, 0, 248, 0, 0, 0, 249, 250, 251, 0, 0, 0, 0, 0, 252, 253, 254,
    0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 256, 257, 258, 0, 0, 0, 0, 0, 259, 0, 260, 0, 261, 0, 0,
    0, 0, 0, 0, 0, 262, 0, 0, 0, 0, 0, 0, 0, 263, 0, 0, 0, 264, 265, 266, 267, 268, 0, 0, 0, 269,
    0, 270, 0, 0, 0, 0, 0, 271, 272, 273, 274, 0, 0, 0, 0, 275, 276, 0, 277, 0, 0, 0, 278, 279,
    280, 0, 0, 0, 0, 0, 0, 0, 281, 0, 0, 0, 0, 0, 282, 283, 284, 0, 285, 0, 0, 0, 286, 0, 287, 0,
    288, 0, 0, 0, 289, 0, 0, 290, 0, 0, 0, 0, 291, 0, 0, 292, 0, 0, 0, 0, 0, 0, 0, 293, 0, 0, 0, 0,
    294, 0, 0, 0, 0, 0, 0, 0, 295, 0, 0, 0, 0, 0, 0, 0, 296, 0, 0, 0, 0, 0, 0, 297, 0, 0, 0, 0, 0,
    0, 0, 298, 299, 0, 0, 0, 0, 0, 0, 0, 300, 0, 0, 0, 0, 0, 0, 0, 301, 0, 0, 0, 0, 0, 0, 302, 303,
    0, 0, 0, 0, 0, 0, 304, 0, 0, 0, 0, 0, 0, 0, 305, 0, 0, 0, 0, 0, 0, 0, 306, 307, 0, 0, 0, 0, 0,
    0, 308, 0, 0, 0, 0, 0, 0, 0, 309, 0, 0, 0, 0, 0, 0, 0, 310, 0, 0, 0, 0, 0, 0, 311, 312, 0, 0,
    0, 0, 0, 0, 313, 0, 0, 0, 0, 0, 0, 0, 314, 0, 0, 0, 0, 0, 0, 0, 315, 0, 0, 0, 0, 0, 0, 0, 316,
    0, 0, 0, 0, 0, 0, 317, 318, 0, 0, 0, 0, 0, 0, 319, 0, 0, 0, 0, 0, 0, 0, 0, 320, 0, 0, 0, 0, 0,
    0, 321, 322, 0, 0, 0, 0, 0, 0, 0, 323, 0, 0, 0, 0, 0, 0, 324, 0, 0, 0, 0, 0, 0, 0, 325, 0, 0,
    0, 0, 0, 0, 0, 326, 0, 0, 0, 0, 0, 0, 0, 0, 327, 0, 0, 0, 0, 0, 0, 0, 328, 0, 0, 0, 0, 0, 0,
    329, 0, 0, 0, 0, 0, 0, 0, 330, 0, 0, 0, 0, 0, 0, 0, 331, 0, 0, 0, 0, 0, 0, 332, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 333, 0, 0, 0, 0, 0, 0, 0, 334, 0, 0, 0, 0, 0, 0, 0, 335, 0, 0, 0, 0, 0, 0, 0,
    336, 0, 0, 0, 0, 0, 0, 0, 337, 0, 0, 0, 0, 0, 0, 0, 338, 0, 0, 0, 0, 0, 0, 0, 339, 0, 0, 0, 0,
    0, 0, 0, 340, 0, 0, 0, 0, 0, 0, 0, 341, 0, 0, 0, 0, 0, 0, 0, 342, 0, 0, 0, 0, 0, 0, 0, 343, 0,
    0, 0, 0, 0, 0, 0, 344, 0, 0, 0, 0, 0, 0, 0, 345, 0, 0, 0, 0, 0, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0,
    347, 0, 0, 0, 0, 0, 0, 0, 348, 0, 0, 0, 0, 0, 0, 0, 349, 0, 0, 0, 0, 0, 0, 0, 350, 0, 0, 0, 0,
    0, 0, 0, 351, 0, 0, 0, 0, 0, 0, 0, 352, 0, 0, 0, 0, 0, 0, 0, 353, 0, 0, 0, 0, 0, 0, 0, 354, 0,
    0, 0, 0, 0, 0, 0, 355, 0, 0, 0, 0, 0, 0, 0, 356, 0, 0, 0, 0, 0, 0, 0, 357, 0, 0, 0, 0, 0, 0, 0,
    358, 0, 0, 0, 0, 0, 0, 0, 359, 0, 0, 0, 0, 0, 0, 360, 0, 0, 0, 0, 0, 0, 0, 361, 0, 0, 0, 0, 0,
    0, 0, 362, 0, 0, 0, 0, 0, 0, 0, 363, 0, 0, 0, 0, 0, 0, 0, 364, 0, 0, 0, 0, 0, 0, 0, 365, 0, 0,
    0, 0, 0, 0, 0, 366, 0, 367, 0, 0, 0, 0, 0, 0, 0, 368, 0, 0, 0, 0, 0, 0, 369, 0, 0, 0, 0, 0, 0,
    0, 370, 0, 0, 0, 0, 0, 0, 0, 371, 0, 0, 0, 0, 0, 0, 0, 372, 0, 0, 0, 0, 0, 0, 0, 373, 0, 0, 0,
    0, 0, 0, 0, 374, 0, 0, 0, 0, 0, 0, 375, 0, 0, 0, 0, 0, 0, 0, 376, 0, 0, 0, 0, 0, 0, 0, 377, 0,
    0, 0, 0, 0, 0, 0, 378, 0, 0, 0, 0, 0, 0, 0, 379, 0, 0, 380, 0, 0, 0, 0, 381, 0, 0, 382, 0, 0,
    0, 0, 0, 0, 0, 383, 0, 0, 0, 0, 0, 0, 0, 384, 0, 0, 0, 0, 0, 0, 0, 385, 0, 0, 0, 0, 0, 0, 0,
    386, 0, 0, 0, 0, 0, 0, 0, 387, 0, 0, 0, 0, 0, 0, 388, 0, 0, 0, 0, 389, 0, 0, 390, 0, 0, 0, 0,
    391, 0, 0, 392, 0, 0, 0, 0, 0, 0, 0, 393, 0, 0, 0, 0, 0, 0, 0, 394, 0, 0, 0, 0, 0, 0, 0, 395,
    0, 0, 0, 0, 0, 0, 0, 396, 0, 0, 0, 0, 0, 0, 0, 397, 0, 0, 0, 0, 0, 0, 398, 0, 0, 0, 0, 399, 0,
    0, 0, 0, 0, 0, 0, 400, 0, 0, 0, 0, 0, 0, 401, 402, 0, 0, 0, 0, 0, 0, 403, 0, 0, 0, 0, 0, 0, 0,
    404, 0, 0, 0, 405, 0, 0, 0, 406, 0, 0, 0, 407, 0, 0, 0, 0, 0, 0, 0, 408, 0, 0, 0, 0, 0, 0, 409,
    0, 0, 0, 0, 0, 0, 0, 410, 0, 0, 0, 0, 0, 0, 0, 411, 0, 0, 0, 0, 0, 0, 0, 412, 0, 0, 0, 0, 0, 0,
    0, 413, 0, 0, 0, 414, 0, 0, 0, 415, 0, 0, 0, 416, 0, 0, 0, 417, 0, 0, 0, 0, 0, 0, 0, 418, 0, 0,
    0, 0, 0, 0, 419, 0, 0, 0, 0, 0, 0, 0, 420, 0, 0, 0, 0, 0, 0, 0, 421, 0, 0, 0, 0, 0, 0, 0, 422,
    0, 0, 0, 0, 0, 0, 0, 423, 0, 0, 0, 424, 0, 0, 0, 425, 0, 0, 0, 426, 0, 0, 0, 427, 0, 0, 0, 428,
    0, 0, 429, 0, 0, 0, 0, 430, 0, 0, 431, 0, 0, 0, 0, 432, 0, 0, 0, 0, 0, 0, 0, 433, 0, 0, 0, 0,
    0, 0, 434, 435, 0, 0, 0, 0, 0, 0, 436, 0, 0, 0, 0, 0, 0, 0, 437, 0, 0, 0, 438, 0, 0, 0, 439, 0,
    0, 0, 440, 0, 0, 0, 441, 0, 0, 442, 0, 0, 0, 0, 443, 0, 0, 444, 0, 0, 0, 0, 445, 0, 0, 446, 0,
    0, 0, 0, 0, 0, 0, 447, 0, 0, 0, 0, 0, 0, 0, 448, 0, 0, 0, 0, 0, 0, 0, 449, 0, 0, 0, 0, 0, 0, 0,
    450, 0, 0, 0, 0, 0, 0, 0, 451, 0, 0, 0, 0, 0, 0, 0, 452, 0, 0, 0, 453, 0, 0, 454, 0, 0, 0, 0,
    455, 0, 0, 456, 0, 0, 0, 0, 0, 0, 0, 457, 0, 0, 0, 0, 0, 0, 0, 458, 0, 0, 0, 0, 0, 0, 0, 459,
    0, 0, 0, 0, 0, 0, 0, 460, 0, 0, 0, 0, 0, 0, 0, 461, 0, 0, 0, 0, 0, 0, 0, 462, 0, 0, 0, 0, 0, 0,
    463, 0, 0, 0, 0, 0, 0, 0, 464, 0, 0, 0, 0, 0, 0, 0, 465, 0, 0, 0, 0, 0, 0, 0, 466, 0, 0, 0,
    467, 0, 0, 0, 468, 0, 0, 0, 0, 0, 0, 0, 469, 0, 0, 0, 0, 0, 0, 0, 470, 0, 0, 0, 471, 0, 0, 472,
    0, 0, 0, 0, 0, 0, 0, 473, 0, 0, 0, 0, 0, 0, 0, 474, 0, 0, 0, 0, 0, 0, 0, 475, 0, 0, 0, 0, 0, 0,
    0, 476, 0, 0, 0, 0, 0, 0, 0, 477, 0, 0, 0, 0, 0, 0, 0, 478, 0, 0, 0, 0, 0, 0, 479, 0, 0, 0, 0,
    0, 0, 0, 480, 0, 0, 0, 0, 0, 0, 0, 481, 0, 0, 0, 0, 0, 0, 0, 482, 0, 0, 0, 0, 0, 0, 0, 483, 0,
    0, 0, 0, 0, 0, 0, 484, 0, 0, 0, 0, 0, 0, 0, 485, 0, 0, 0, 0, 0, 0, 0, 486, 0, 0, 0, 0, 0, 0,
    487, 0, 0, 0, 0, 0, 0, 0, 488, 0, 0, 0, 0, 0, 0, 0, 489, 0, 0, 0, 0, 0, 0, 0, 490, 0, 0, 0, 0,
    0, 0, 0, 491, 0, 0, 0, 0, 0, 0, 0, 492, 0, 0, 0, 0, 0, 0, 0, 493, 0, 0, 0, 0, 0, 0, 0, 494, 0,
    0, 0, 0, 0, 0, 495, 0, 0, 0, 0, 0, 0, 0, 496, 0, 0, 0, 0, 0, 0, 0, 497, 0, 0, 0, 0, 0, 0, 0,
    498, 0, 0, 0, 0, 0, 0, 0, 499, 0, 0, 0, 0, 0, 0, 0, 500, 0, 0, 0, 0, 0, 0, 0, 501, 0, 0, 0, 0,
    0, 0, 0, 502, 0, 0, 0, 0, 0, 0, 503, 0, 0, 0, 0, 0, 0, 0, 504, 0, 0, 0, 0, 0, 0, 0, 505, 0, 0,
    0, 0, 0, 0, 0, 506, 0, 0, 0, 0, 0, 0, 0, 507, 0, 0, 0, 0, 0, 0, 0, 508, 0, 0, 0, 0, 0, 0, 0,
    509, 0, 0, 0, 0, 0, 0, 0, 510, 0, 0, 0, 0, 0, 0, 511, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0,
    0, 0, 513, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 514, 0, 0, 0, 0, 0, 0, 0, 515, 0, 0, 0, 0, 0, 0, 0,
    516, 0, 0, 0, 0, 0, 0, 0, 517, 0, 0, 0, 0, 0, 0, 0, 518, 0, 0, 0, 0, 0, 0, 0, 519, 0, 0, 0, 0,
    0, 0, 520, 0, 0, 0, 0, 0, 0, 0, 521, 0, 0, 0, 0, 0, 0, 0, 522, 0, 0, 0, 0, 0, 0, 0, 523, 0, 0,
    0, 0, 0, 0, 0, 524, 0, 0, 0, 0, 0, 0, 0, 525, 0, 0, 0, 0, 0, 0, 0, 526, 0, 0, 0, 0, 0, 0, 0,
    527, 0, 0, 0, 0, 0, 0, 528, 0, 0, 0, 0, 0, 0, 0, 529, 0, 0, 0, 0, 0, 0, 0, 530, 0, 0, 0, 0, 0,
    0, 0, 531, 0, 0, 0, 0, 0, 0, 0, 532, 0, 0, 0, 0, 0, 0, 0, 533, 0, 0, 0, 0, 0, 0, 0, 534, 0, 0,
    0, 0, 0, 0, 0, 535, 0, 0, 0, 0, 0, 0, 536, 0, 0, 0, 0, 0, 0, 0, 537, 0, 0, 0, 0, 0, 0, 0, 538,
    0, 0, 0, 0, 0, 0, 0, 539, 0, 0, 0, 0, 0, 0, 0, 540, 0, 0, 0, 0, 0, 0, 0, 541, 0, 0, 0, 0, 0, 0,
    0, 542, 0, 0, 0, 0, 0, 0, 0, 543, 0, 0, 0, 0, 0, 0, 544, 0, 0, 0, 0, 0, 0, 0, 545, 0, 0, 0, 0,
    0, 0, 0, 546, 0, 0, 0, 0, 0, 0, 0, 547, 0, 0, 0, 0, 0, 0, 0, 548, 0, 0, 0, 0, 0, 0, 0, 549, 0,
    0, 0, 0, 0, 0, 0, 550, 0, 0, 0, 0, 0, 0, 0, 551, 0, 0, 0, 0, 0, 0, 552, 553, 0, 0, 0, 0, 0, 0,
    554, 0, 0, 0, 0, 0, 0, 0, 555, 0, 0, 0, 0, 0, 0, 0, 556, 0, 0, 0, 0, 0, 0, 0, 557, 0, 0, 0, 0,
    0, 0, 0, 558, 0, 0, 0, 0, 0, 0, 0, 559, 0, 0, 0, 0, 0, 0, 0, 560, 0, 0, 0, 0, 0, 0, 561, 0, 0,
    0, 0, 0, 0, 0, 562, 0, 0, 0, 0, 0, 0, 0, 563, 0, 0, 0, 0, 0, 0, 0, 564, 0, 0, 0, 0, 0, 0, 0,
    565, 0, 0, 0, 0, 0, 0, 0, 566, 0, 0, 0, 0, 0, 0, 0, 567, 0, 0, 0, 0, 0, 0, 0, 568, 0, 0, 0, 0,
    0, 0, 0, 569, 0, 0, 0, 0, 0, 0, 0, 570, 0, 0, 0, 0, 0, 0, 0, 571, 0, 0, 0, 0, 0, 0, 0, 572,
];

#[rustfmt::skip]
const COMPOSE_INDEX1: [u16; 2292] = [
    0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 3, 0, 0, 0, 0, 0, 4, 5, 6, 7, 8, 9, 10, 11, 0, 12, 13, 14,
    0, 0, 0, 15, 0, 0, 0, 0, 16, 0, 0, 0, 0, 17, 0, 0, 18, 0, 19, 0, 0, 20, 21, 0, 0, 0, 22, 0, 23,
    0, 0, 24, 0, 25, 26, 0, 27, 0, 28, 29, 30, 31, 32, 0, 33, 34, 0, 35, 0, 36, 37, 38, 0, 0, 0, 0,
    0, 39, 40, 41, 42, 0, 0, 43, 0, 0, 0, 0, 44, 0, 45, 0, 46, 0, 47, 0, 0, 48, 0, 49, 0, 50, 0, 0,
    51, 52, 53, 54, 55, 0, 56, 57, 0, 58, 0, 59, 0, 60, 0, 0, 0, 61, 0, 0, 62, 0, 0, 0, 0, 63, 0,
    0, 64, 0, 65, 0, 66, 0, 0, 67, 0, 0, 0, 0, 68, 0, 0, 69, 0, 70, 71, 0, 72, 0, 0, 73, 0, 74, 0,
    75, 0, 0, 76, 77, 0, 78, 0, 79, 0, 0, 80, 0, 81, 82, 0, 83, 0, 0, 0, 0, 0, 84, 85, 86, 87, 88,
    89, 90, 91, 92, 93, 0, 94, 0, 0, 0, 0, 95, 0, 0, 96, 0, 0, 0, 0, 97, 0, 98, 0, 0, 99, 100, 0,
    101, 0, 102, 0, 103, 0, 0, 104, 105, 0, 106, 0, 107, 0, 0, 108, 0, 109, 0, 0, 0, 110, 0, 0,
    111, 0, 0, 112, 113, 114, 115, 116, 0, 0, 117, 118, 119, 120, 121, 122, 123, 0, 124, 125, 0,
    126, 127, 0, 0, 0, 0, 128, 0, 0, 129, 0, 0, 130, 131, 0, 132, 133, 0, 0, 0, 0, 0, 134, 135, 0,
    0, 0, 136, 137, 138, 139, 140, 0, 0, 0, 141, 0, 0, 0, 142, 0, 143, 0, 0, 144, 0, 0, 145, 0, 0,
    0, 146, 0, 0, 147, 148, 149, 150, 151, 152, 153, 0, 154, 155, 0, 156, 0, 0, 157, 0, 0, 0, 0, 0,
    158, 0, 0, 0, 159, 0, 0, 160, 161, 0, 162, 0, 163, 0, 0, 0, 0, 164, 0, 0, 0, 165, 0, 0, 166, 0,
    0, 167, 0, 168, 169, 170, 0, 0, 171, 172, 173, 174, 175, 176, 177, 0, 178, 0, 179, 180, 181, 0,
    0, 0, 0, 0, 182, 0, 0, 0, 0, 183, 184, 185, 186, 0, 187, 0, 0, 0, 0, 188, 0, 0, 0, 0, 0, 189,
    0, 190, 191, 0, 192, 0, 0, 193, 0, 194, 195, 196, 0, 0, 197, 198, 199, 200, 201, 202, 203, 0,
    204, 0, 0, 205, 206, 0, 0, 0, 207, 0, 0, 0, 0, 208, 0, 209, 0, 0, 0, 0, 210, 0, 0, 211, 0, 212,
    0, 0, 213, 0, 0, 214, 0, 0, 0, 0, 215, 0, 0, 216, 0, 217, 218, 219, 0, 0, 220, 0, 0, 221, 222,
    0, 0, 0, 0, 0, 0, 223, 224, 225, 226, 0, 0, 227, 0, 0, 228, 0, 229, 230, 231, 0, 0, 0, 0, 0, 0,
    232, 233, 234, 235, 236, 237, 238, 0, 239, 0, 0, 240, 0, 0, 0, 0, 241, 0, 242, 0, 0, 0, 0, 243,
    0, 0, 244, 0, 245, 246, 0, 247, 0, 248, 0, 0, 249, 0, 0, 250, 0, 251, 0, 0, 252, 0, 0, 253,
    254, 255, 0, 0, 0, 256, 0, 257, 0, 0, 258, 0, 259, 260, 0, 261, 0, 262, 263, 264, 265, 266,
    267, 268, 269, 270, 271, 0, 272, 273, 274, 0, 0, 0, 275, 0, 0, 276, 0, 0, 0, 0, 0, 0, 277, 278,
    0, 279, 280, 281, 0, 0, 0, 282, 0, 0, 0, 0, 0, 283, 0, 0, 0, 284, 285, 286, 287, 288, 289, 0,
    0, 0, 290, 0, 0, 291, 292, 0, 293, 0, 294, 0, 0, 295, 0, 0, 0, 0, 296, 0, 297, 298, 0, 0, 0, 0,
    299, 0, 300, 301, 0, 0, 302, 0, 0, 0, 0, 303, 0, 304, 0, 0, 0, 305, 306, 0, 0, 0, 0, 0, 307, 0,
    0, 308, 309, 310, 0, 311, 0, 0, 0, 312, 0, 0, 313, 314, 315, 0, 316, 0, 0, 0, 317, 0, 318, 319,
    0, 0, 0, 0, 0, 320, 0, 321, 0, 0, 0, 0, 0, 0, 322, 323, 324, 0, 0, 0, 325, 0, 0, 0, 0, 0, 326,
    327, 0, 0, 328, 329, 0, 0, 0, 0, 0, 330, 0, 0, 0, 331, 332, 0, 333, 0, 0, 334, 335, 336, 0,
    337, 0, 0, 0, 338, 0, 0, 0, 0, 0, 0, 339, 340, 341, 0, 342, 0, 0, 0, 343, 0, 344, 345, 0, 346,
    0, 0, 0, 0, 0, 347, 0, 0, 348, 349, 350, 0, 0, 0, 351, 0, 352, 353, 0, 0, 354, 0, 0, 355, 356,
    357, 0, 358, 0, 0, 0, 359, 0, 0, 0, 0, 0, 0, 360, 361, 0, 0, 0, 0, 0, 0, 362, 0, 0, 363, 364,
    0, 365, 0, 0, 366, 0, 0, 0, 367, 0, 0, 0, 0, 0, 0, 368, 369, 0, 0, 0, 370, 0, 0, 0, 0, 0, 371,
    0, 0, 0, 372, 0, 0, 373, 0, 0, 0, 374, 375, 376, 0, 377, 0, 0, 0, 0, 378, 0, 0, 379, 380, 0, 0,
    381, 0, 0, 0, 382, 0, 0, 383, 384, 385, 0, 386, 0, 0, 0, 0, 387, 0, 0, 388, 389, 0, 0, 390, 0,
    0, 0, 391, 0, 0, 0, 0, 392, 0, 0, 0, 393, 0, 0, 394, 0, 0, 0, 395, 0, 0, 0, 0, 0, 0, 396, 0, 0,
    0, 397, 0, 0, 0, 398, 0, 0, 399, 0, 0, 400, 0, 0, 401, 0, 0, 0, 0, 0, 402, 403, 404, 405, 0, 0,
    0, 406, 407, 0, 0, 408, 0, 0, 0, 0, 409, 0, 0, 410, 0, 0, 0, 411, 412, 0, 413, 414, 0, 0, 415,
    0, 0, 0, 0, 416, 0, 417, 418, 0, 0, 0, 419, 0, 0, 0, 420, 421, 0, 0, 0, 0, 0, 422, 423, 0, 0,
    0, 0, 0, 0, 424, 0, 0, 0, 425, 426, 427, 428, 429, 0, 0, 0, 430, 0, 0, 0, 431, 0, 0, 432, 0, 0,
    433, 0, 0, 0, 434, 0, 0, 435, 0, 0, 0, 0, 436, 437, 438, 439, 0, 0, 0, 440, 441, 0, 0, 0, 0, 0,
    442, 443, 0, 0, 0, 0, 444, 0, 0, 445, 0, 0, 0, 446, 447, 0, 0, 0, 0, 0, 448, 449, 0, 0, 0, 0,
    0, 450, 451, 452, 0, 453, 454, 0, 0, 0, 455, 0, 0, 456, 0, 0, 0, 0, 457, 458, 0, 0, 0, 0, 0,
    459, 460, 0, 0, 461, 0, 0, 0, 462, 463, 464, 465, 466, 0, 0, 467, 468, 0, 469, 0, 0, 0, 0, 0,
    470, 0, 0, 471, 0, 0, 472, 0, 0, 0, 0, 473, 474, 0, 0, 0, 0, 475, 0, 476, 0, 0, 0, 0, 0, 477,
    0, 0, 0, 478, 479, 0, 0, 480, 0, 0, 0, 481, 0, 482, 483, 0, 0, 0, 0, 484, 0, 0, 485, 0, 486,
    487, 0, 0, 488, 489, 0, 0, 490, 0, 0, 0, 491, 0, 492, 493, 494, 0, 0, 0, 495, 0, 0, 0, 0, 0, 0,
    496, 0, 497, 498, 0, 499, 0, 0, 0, 0, 0, 500, 0, 0, 501, 0, 0, 0, 502, 0, 0, 0, 0, 0, 503, 504,
    0, 0, 0, 0, 505, 0, 0, 506, 0, 507, 508, 0, 0, 509, 510, 0, 0, 511, 0, 0, 0, 512, 0, 513, 514,
    515, 0, 0, 0, 516, 0, 0, 517, 0, 0, 0, 0, 0, 518, 519, 0, 520, 0, 521, 0, 0, 0, 0, 0, 0, 522,
    0, 0, 0, 523, 0, 0, 524, 0, 525, 0, 0, 0, 526, 0, 0, 0, 0, 527, 0, 0, 528, 0, 0, 0, 529, 0, 0,
    0, 0, 0, 0, 530, 0, 0, 531, 532, 0, 0, 533, 0, 0, 0, 534, 0, 0, 535, 0, 0, 0, 536, 0, 0, 537,
    0, 0, 0, 0, 538, 0, 0, 539, 0, 0, 0, 540, 0, 0, 0, 541, 0, 0, 0, 542, 543, 0, 0, 0, 0, 544, 0,
    0, 545, 0, 0, 546, 0, 0, 0, 0, 547, 0, 0, 0, 548, 0, 0, 549, 550, 0, 0, 551, 0, 0, 0, 0, 552,
    0, 0, 553, 0, 0, 0, 0, 554, 555, 0, 556, 0, 0, 0, 0, 557, 0, 0, 0, 558, 0, 0, 0, 559, 0, 0,
    560, 0, 0, 0, 561, 0, 0, 0, 0, 0, 0, 562, 0, 0, 0, 563, 0, 0, 564, 0, 0, 0, 565, 0, 0, 566, 0,
    0, 0, 567, 0, 0, 568, 0, 0, 0, 569, 0, 0, 0, 570, 0, 0, 0, 0, 0, 0, 571, 0, 0, 0, 572, 0, 0, 0,
    573, 0, 0, 0, 574, 575, 0, 576, 0, 577, 578, 0, 0, 0, 0, 0, 579, 0, 0, 0, 580, 0, 0, 581, 0, 0,
    0, 582, 0, 583, 584, 0, 0, 0, 0, 585, 586, 587, 0, 0, 0, 0, 0, 588, 0, 0, 0, 589, 0, 0, 590, 0,
    0, 0, 591, 0, 0, 592, 0, 0, 0, 593, 0, 0, 0, 0, 0, 0, 594, 595, 596, 0, 0, 0, 0, 597, 598, 599,
    0, 0, 0, 0, 0, 600, 0, 0, 0, 601, 0, 0, 602, 0, 0, 0, 603, 0, 0, 604, 0, 0, 0, 605, 0, 0, 0, 0,
    0, 0, 606, 607, 608, 0, 0, 609, 0, 0, 0, 0, 0, 0, 610, 611, 0, 0, 0, 0, 0, 0, 612, 0, 0, 613,
    614, 615, 616, 0, 0, 0, 0, 617, 0, 618, 0, 0, 0, 619, 0, 0, 0, 0, 0, 0, 620, 0, 0, 0, 621, 0,
    0, 622, 0, 0, 0, 623, 0, 0, 624, 0, 0, 0, 0, 625, 626, 627, 628, 0, 0, 0, 0, 629, 0, 630, 0, 0,
    0, 631, 0, 0, 0, 0, 0, 0, 632, 0, 0, 0, 633, 0, 0, 634, 0, 0, 0, 635, 0, 0, 636, 0, 0, 0, 0,
    637, 638, 639, 0, 0, 0, 0, 0, 640, 0, 641, 0, 0, 0, 0, 642, 643, 0, 0, 0, 0, 644, 0, 645, 0, 0,
    0, 0, 0, 646, 647, 648, 0, 0, 649, 0, 0, 0, 0, 0, 0, 650, 651, 0, 0, 0, 0, 0, 0, 652, 0, 0,
    653, 654, 655, 0, 0, 0, 0, 0, 656, 0, 657, 0, 0, 0, 0, 658, 659, 0, 0, 0, 0, 660, 0, 661, 0, 0,
    0, 0, 0, 662, 663, 664, 0, 0, 0, 0, 665, 666, 0, 0, 667, 0, 0, 0, 668, 0, 0, 669, 0, 0, 0, 670,
    0, 0, 671, 0, 0, 0, 672, 0, 0, 0, 0, 673, 0, 0, 0, 0, 0, 674, 675, 676, 0, 0, 0, 0, 677, 678,
    0, 0, 679, 0, 0, 0, 680, 0, 0, 681, 0, 0, 0, 682, 0, 0, 683, 0, 0, 0, 684, 0, 0, 0, 0, 0, 0,
    685, 0, 0, 0, 686, 0, 0, 687, 0, 0, 0, 688, 0, 0, 0, 0, 689, 0, 690, 0, 0, 0, 691, 0, 0, 692,
    0, 0, 0, 0, 693, 694, 0, 0, 0, 0, 695, 0, 0, 696, 0, 0, 0, 697, 0, 0, 698, 0, 0, 0, 699, 0, 0,
    700, 0, 0, 0, 701, 0, 0, 0, 0, 0, 0, 702, 0, 0, 0, 703, 0, 0, 704, 0, 0, 0, 705, 0, 0, 706, 0,
    0, 0, 707, 0, 0, 708, 0, 0, 0, 709, 0, 0, 0, 0, 0, 0, 710, 0, 0, 0, 711, 0, 0, 712, 0, 0, 0,
    713, 0, 0, 714, 0, 0, 0, 715, 0, 0, 716, 0, 0, 0, 717, 0, 0, 0, 0, 0, 0, 718, 0, 0, 0, 719, 0,
    0, 720, 0, 0, 0, 721, 0, 0, 722, 0, 0, 0, 723, 0, 0, 724, 0, 0, 0, 725, 0, 0, 0, 0, 0, 0, 726,
    0, 0, 0, 727, 0, 0, 728, 0, 0, 0, 729, 0, 0, 730, 0, 0, 0, 731, 0, 0, 732, 0, 0, 0, 733, 0, 0,
    0, 0, 0, 0, 734, 0, 0, 0, 735, 0, 0, 736, 0, 0, 0, 737, 0, 0, 0, 738, 0, 0, 739, 0, 0, 0, 740,
    0, 0, 741, 0, 0, 0, 742, 0, 0, 0, 0, 0, 0, 743, 0, 0, 0, 744, 0, 0, 745, 0, 0, 0, 746, 0, 0,
    747, 0, 0, 0, 748, 0, 0, 749, 0, 0, 0, 750, 0, 0, 0, 0, 0, 0, 751, 0, 0, 0, 752, 0, 0, 753,
    754, 0, 0, 755, 0, 0, 756, 757, 0, 0, 758, 0, 0, 759, 760, 0, 0, 761, 0, 0, 0, 0, 0, 0, 762, 0,
    0, 0, 763, 0, 0, 764, 0, 0, 0, 765, 0, 0, 766, 0, 0, 0, 767, 0, 0, 768, 0, 0, 0, 769, 0, 0, 0,
    0, 0, 0, 770, 0, 0, 0, 771, 0, 0, 772, 0, 0, 0, 773, 0, 0, 774, 0, 0, 0, 775, 0, 0, 776, 0, 0,
    0, 777, 0, 0, 0, 0, 0, 0, 778, 779, 0, 0, 0, 0, 0, 0, 780, 0, 0, 781, 782, 0, 0, 783, 0, 0,
    784, 785, 0, 0, 786, 0, 0, 787, 0, 0, 0, 788, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 790, 0, 0, 0,
    791, 0, 0, 0, 792, 0, 0, 793, 0, 0, 0, 794, 0, 0, 0, 795, 0, 0, 0, 796, 0, 0, 0, 797, 798, 0,
    0, 0, 799, 0, 0, 0, 800, 0, 0, 0, 801,
];

#[rustfmt::skip]
const COMPOSE_INDEX2: [u32; 1603] = [
    0, 0, 0, 8814, 8800, 0, 0, 8815, 0, 192, 193, 194, 195, 256, 258, 550, 196, 7842, 197, 0, 461,
    512, 514, 0, 7840, 0, 7680, 0, 0, 260, 7682, 0, 0, 7684, 7686, 0, 262, 264, 0, 266, 268, 0,
    199, 0, 7690, 0, 0, 270, 0, 7692, 0, 7696, 0, 7698, 7694, 0, 0, 200, 201, 202, 7868, 274, 276,
    278, 203, 7866, 282, 516, 518, 0, 7864, 0, 552, 280, 7704, 0, 7706, 0, 7710, 0, 500, 284, 0,
    7712, 286, 288, 486, 0, 290, 0, 292, 0, 7714, 7718, 0, 542, 0, 7716, 0, 7720, 7722, 0, 0, 204,
    205, 206, 296, 298, 300, 304, 207, 7880, 463, 520, 522, 0, 7882, 0, 0, 302, 7724, 0, 308, 0,
    7728, 0, 488, 0, 7730, 0, 310, 0, 0, 7732, 0, 313, 0, 317, 0, 7734, 0, 315, 0, 7740, 7738, 0,
    7742, 0, 0, 7744, 7746, 0, 504, 323, 0, 209, 7748, 0, 0, 327, 0, 7750, 0, 325, 0, 7754, 7752,
    0, 0, 210, 211, 212, 213, 332, 334, 558, 214, 7886, 0, 336, 465, 524, 526, 0, 0, 416, 7884, 0,
    0, 490, 0, 7764, 7766, 0, 340, 0, 0, 7768, 344, 528, 530, 0, 7770, 0, 342, 0, 0, 7774, 0, 346,
    348, 0, 7776, 0, 0, 352, 0, 7778, 536, 350, 0, 7786, 356, 0, 7788, 0, 0, 538, 354, 0, 7792, 0,
    0, 7790, 217, 218, 219, 360, 362, 364, 0, 220, 7910, 366, 368, 467, 532, 534, 431, 7908, 7794,
    0, 370, 7798, 0, 7796, 7804, 0, 7806, 0, 7808, 7810, 372, 0, 7814, 7812, 0, 7816, 0, 7818,
    7820, 0, 7922, 221, 374, 7928, 562, 0, 7822, 376, 7926, 0, 0, 7924, 377, 7824, 0, 379, 381, 0,
    7826, 0, 0, 7828, 224, 225, 226, 227, 257, 259, 551, 228, 7843, 229, 0, 462, 513, 515, 0, 7841,
    0, 7681, 261, 0, 0, 7683, 7685, 0, 0, 7687, 0, 263, 265, 0, 267, 0, 0, 269, 0, 231, 0, 7691,
    271, 0, 7693, 0, 7697, 0, 7699, 0, 0, 7695, 232, 233, 234, 7869, 275, 277, 279, 235, 7867, 0,
    0, 283, 517, 519, 0, 7865, 0, 553, 281, 7705, 0, 7707, 0, 7711, 0, 501, 285, 0, 7713, 287, 289,
    0, 0, 487, 0, 291, 0, 293, 0, 7715, 7719, 0, 543, 0, 7717, 0, 7721, 0, 0, 7723, 0, 7830, 236,
    237, 238, 297, 299, 301, 0, 239, 7881, 0, 0, 464, 521, 523, 0, 7883, 303, 0, 0, 7725, 0, 309,
    496, 0, 0, 7729, 0, 489, 0, 7731, 0, 311, 7733, 0, 314, 0, 318, 0, 7735, 0, 316, 0, 7741, 0, 0,
    7739, 0, 7743, 7745, 0, 0, 7747, 0, 505, 324, 0, 241, 0, 0, 7749, 328, 0, 7751, 0, 326, 0,
    7755, 0, 0, 7753, 242, 243, 244, 245, 333, 335, 559, 246, 7887, 0, 337, 466, 525, 527, 417,
    7885, 491, 0, 7765, 0, 0, 7767, 0, 341, 7769, 0, 0, 345, 529, 531, 0, 7771, 0, 343, 7775, 0,
    347, 349, 0, 7777, 353, 0, 7779, 0, 0, 537, 351, 0, 7787, 7831, 0, 357, 0, 7789, 539, 355, 0,
    7793, 7791, 0, 0, 249, 250, 251, 361, 363, 365, 0, 252, 7911, 367, 369, 468, 533, 535, 0, 0,
    432, 7909, 7795, 0, 371, 7799, 0, 7797, 0, 0, 7805, 0, 7807, 0, 7809, 7811, 373, 0, 7815, 7813,
    0, 7832, 0, 7817, 0, 7819, 7821, 0, 7923, 253, 375, 7929, 563, 0, 7823, 255, 7927, 7833, 0,
    7925, 0, 0, 378, 7825, 0, 380, 0, 0, 382, 0, 7827, 7829, 0, 0, 8173, 901, 0, 0, 8129, 7846,
    7844, 0, 7850, 7848, 0, 0, 478, 0, 506, 508, 0, 0, 482, 0, 7688, 0, 7872, 7870, 0, 7876, 0, 0,
    7874, 0, 7726, 0, 7890, 7888, 0, 7894, 0, 0, 7892, 0, 7756, 556, 0, 0, 7758, 0, 554, 0, 510, 0,
    475, 471, 0, 0, 469, 473, 0, 7847, 7845, 0, 7851, 7849, 0, 0, 479, 0, 507, 509, 0, 0, 483, 0,
    7689, 0, 7873, 7871, 0, 7877, 0, 0, 7875, 0, 7727, 0, 7891, 7889, 0, 7895, 0, 0, 7893, 0, 7757,
    557, 0, 0, 7759, 0, 555, 0, 511, 0, 476, 472, 0, 0, 470, 474, 0, 7856, 7854, 0, 7860, 7858, 0,
    0, 7857, 7855, 0, 7861, 0, 0, 7859, 7700, 7702, 0, 7701, 7703, 0, 7760, 7762, 0, 7761, 7763, 0,
    7780, 0, 0, 7781, 7782, 0, 0, 7783, 0, 7800, 7801, 0, 0, 7802, 7803, 0, 7835, 0, 0, 7900, 7898,
    0, 7904, 0, 0, 7902, 7906, 0, 7901, 7899, 0, 7905, 7903, 0, 0, 7907, 0, 7914, 7912, 0, 7918, 0,
    0, 7916, 7920, 0, 7915, 7913, 0, 7919, 7917, 0, 0, 7921, 494, 0, 492, 0, 0, 493, 480, 0, 0,
    481, 0, 7708, 7709, 0, 560, 0, 0, 561, 0, 495, 0, 8122, 902, 0, 0, 8121, 8120, 0, 0, 7944,
    7945, 0, 8124, 0, 8136, 904, 7960, 7961, 0, 8138, 905, 0, 0, 7976, 7977, 0, 8140, 0, 8154, 906,
    8153, 8152, 0, 938, 7992, 7993, 0, 8184, 908, 0, 0, 8008, 8009, 0, 0, 8172, 0, 8170, 910, 0, 0,
    8169, 8168, 0, 939, 0, 8025, 0, 8186, 911, 8040, 8041, 0, 8188, 8116, 0, 0, 8132, 0, 8048, 940,
    0, 0, 8113, 8112, 0, 0, 7936, 7937, 0, 0, 8118, 8115, 0, 8050, 941, 7952, 7953, 0, 8052, 942,
    0, 0, 7968, 7969, 0, 0, 8134, 8131, 0, 8054, 943, 8145, 8144, 0, 970, 7984, 7985, 8150, 0, 0,
    8056, 972, 0, 0, 8000, 8001, 0, 8164, 8165, 0, 8058, 973, 0, 0, 8161, 8160, 0, 971, 0, 0, 8016,
    8017, 0, 0, 8166, 8060, 974, 8032, 8033, 8182, 8179, 0, 8146, 912, 0, 0, 8151, 8162, 944, 8167,
    0, 8180, 0, 0, 979, 0, 980, 1031, 0, 0, 1232, 0, 1234, 1027, 0, 1024, 0, 0, 1238, 0, 1025,
    1217, 0, 1244, 0, 0, 1246, 0, 1037, 0, 1250, 1049, 0, 1252, 0, 0, 1036, 1254, 0, 1262, 1038, 0,
    1264, 1266, 0, 1268, 0, 0, 1272, 1260, 0, 0, 1233, 0, 1235, 1107, 0, 1104, 0, 0, 1239, 0, 1105,
    1218, 0, 1245, 0, 0, 1247, 0, 1117, 0, 1251, 1081, 0, 1253, 0, 0, 1116, 1255, 0, 1263, 1118, 0,
    1265, 1267, 0, 1269, 0, 0, 1273, 1261, 0, 0, 1111, 0, 1142, 1143, 0, 1242, 0, 0, 1243, 1258, 0,
    0, 1259, 0, 1570, 1571, 1573, 0, 1572, 1574, 0, 0, 1730, 1747, 0, 0, 1728, 2345, 0, 0, 2353,
    2356, 0, 2507, 2508, 0, 2891, 2888, 2892, 2964, 0, 3018, 3020, 0, 3019, 3144, 0, 0, 3264, 0,
    3274, 3271, 3272, 0, 3275, 3402, 3404, 0, 3403, 3546, 3548, 3550, 0, 0, 3549, 0, 4134, 0, 6918,
    6920, 0, 0, 6922, 6924, 0, 0, 6926, 6930, 0, 0, 6971, 6973, 0, 0, 6976, 6977, 0, 0, 6979, 0,
    7736, 7737, 0, 0, 7772, 7773, 0, 0, 7784, 7785, 0, 0, 7852, 7862, 0, 7853, 0, 0, 7863, 0, 7878,
    7879, 0, 0, 7896, 7897, 0, 0, 7938, 7940, 0, 0, 7942, 8064, 0, 7939, 7941, 7943, 8065, 8066, 0,
    0, 8067, 8068, 0, 0, 8069, 8070, 0, 0, 8071, 0, 7946, 7948, 0, 0, 7950, 8072, 0, 7947, 7949,
    7951, 8073, 8074, 0, 0, 8075, 8076, 0, 0, 8077, 8078, 0, 0, 8079, 0, 7954, 7956, 0, 7955, 7957,
    0, 7962, 7964, 0, 7963, 7965, 0, 7970, 7972, 0, 0, 7974, 8080, 0, 7971, 7973, 7975, 8081, 8082,
    0, 0, 8083, 8084, 0, 0, 8085, 8086, 0, 0, 8087, 0, 7978, 7980, 0, 0, 7982, 8088, 0, 7979, 7981,
    7983, 8089, 8090, 0, 0, 8091, 8092, 0, 0, 8093, 8094, 0, 0, 8095, 0, 7986, 7988, 0, 0, 7990,
    7987, 7989, 7991, 0, 0, 7994, 7996, 0, 0, 7998, 7995, 7997, 7999, 0, 0, 8002, 8004, 0, 8003,
    8005, 0, 8010, 8012, 0, 8011, 8013, 0, 8018, 8020, 0, 0, 8022, 8019, 8021, 8023, 0, 0, 8027,
    8029, 0, 0, 8031, 8034, 8036, 8038, 8096, 0, 8035, 8037, 0, 0, 8039, 8097, 0, 0, 8098, 8099, 0,
    0, 8100, 8101, 0, 0, 8102, 8103, 0, 8042, 8044, 8046, 8104, 0, 8043, 8045, 0, 0, 8047, 8105, 0,
    0, 8106, 8107, 0, 0, 8108, 8109, 0, 0, 8110, 8111, 0, 0, 8114, 8130, 0, 0, 8178, 8119, 0, 8141,
    8142, 8143, 0, 8135, 0, 0, 8183, 0, 8157, 8158, 0, 0, 8159, 0, 8602, 8603, 0, 0, 8622, 8653, 0,
    0, 8655, 8654, 0, 0, 8708, 8713, 0, 0, 8716, 8740, 0, 0, 8742, 8769, 0, 0, 8772, 8775, 0, 0,
    8777, 8813, 0, 0, 8802, 8816, 0, 0, 8817, 8820, 0, 0, 8821, 8824, 0, 0, 8825, 8832, 0, 0, 8833,
    8928, 0, 0, 8929, 8836, 0, 0, 8837, 8840, 0, 0, 8841, 8930, 0, 0, 8931, 8876, 0, 0, 8877, 8878,
    0, 0, 8879, 8938, 0, 0, 8939, 8940, 0, 0, 8941, 0, 12436, 12364, 0, 0, 12366, 12368, 0, 0,
    12370, 12372, 0, 0, 12374, 12376, 0, 0, 12378, 12380, 0, 0, 12382, 12384, 0, 0, 12386, 12389,
    0, 0, 12391, 12393, 0, 0, 12400, 12401, 0, 12403, 12404, 0, 12406, 12407, 0, 12409, 12410, 0,
    12412, 12413, 0, 12446, 0, 0, 12532, 12460, 0, 0, 12462, 12464, 0, 0, 12466, 12468, 0, 0,
    12470, 12472, 0, 0, 12474, 12476, 0, 0, 12478, 12480, 0, 0, 12482, 12485, 0, 0, 12487, 12489,
    0, 0, 12496, 12497, 0, 12499, 12500, 0, 12502, 12503, 0, 12505, 12506, 0, 12508, 12509, 0,
    12535, 0, 0, 12536, 12537, 0, 0, 12538, 12542, 0, 0, 69786, 69788, 0, 0, 69803, 0, 69934,
    69935, 0, 70475, 70476, 0, 70844, 70843, 70846, 0, 71098, 71099, 0, 71992,
];

pub fn compose_index(x: usize) -> usize {
    const SHIFT1: usize = 2;
    const SHIFT2: usize = 1;
    if x >= 23751 {
        return 0;
    }
    let mut index = (COMPOSE_INDEX0[x >> (SHIFT1 + SHIFT2)] as usize) << SHIFT1;
    let mut offset = (x >> SHIFT2) & ((1 << SHIFT1) - 1);
    index = (COMPOSE_INDEX1[index + offset] as usize) << SHIFT2;
    offset = x & ((1 << SHIFT2) - 1);
    COMPOSE_INDEX2[index + offset] as usize
}
#[rustfmt::skip]
const DECOMPOSE_INDEX0: [u8; 1088] = [
    0, 1, 2, 3, 4, 5, 6, 7, 8, 5, 9, 5, 10, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    11, 5, 5, 5, 5, 5, 12, 13, 14, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 15, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 16, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5,
];

#[rustfmt::skip]
const DECOMPOSE_INDEX1: [u8; 1088] = [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 0, 0, 13, 14, 15,
    16, 17, 18, 19, 20, 21, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 24, 25,
    26, 27, 28, 29, 30, 0, 0, 31, 32, 0, 33, 0, 34, 0, 35, 0, 0, 0, 0, 36, 37, 38, 39, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 42, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    43, 44, 0, 45, 0, 0, 0, 0, 0, 0, 46, 47, 0, 0, 0, 0, 0, 48, 0, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 52, 0, 0, 53, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 55,
    0, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 0, 0, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 58, 59, 60, 61, 62, 63, 64, 65, 0, 0, 0, 0, 0, 0, 66, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 67, 68, 0, 69, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 72, 73, 74, 75,
    76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
    100, 101, 102, 103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 0, 0, 0, 0, 0, 0,
    105, 106, 0, 107, 0, 0, 0, 108, 0, 109, 0, 110, 0, 111, 112, 113, 0, 114, 0, 0, 0, 115, 0, 0,
    0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 119, 120, 121, 0, 122, 123,
    124, 125, 126, 0, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141,
    142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 0, 0, 0, 158,
    159, 160, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 163, 0, 0, 0,
    0, 0, 0, 0, 164, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 165, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    166, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 169, 170, 0, 0, 0, 0, 171, 172, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173, 174, 175,
    176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
    195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];

#[rustfmt::skip]
const DECOMPOSE_INDEX2: [u16; 3312] = [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 8, 11, 14, 17, 0, 20, 23, 26, 29, 32, 35,
    38, 41, 44, 0, 47, 50, 53, 56, 59, 62, 0, 0, 65, 68, 71, 74, 77, 0, 0, 80, 83, 86, 89, 92, 95,
    0, 98, 101, 104, 107, 110, 113, 116, 119, 122, 0, 125, 128, 131, 134, 137, 140, 0, 0, 143, 146,
    149, 152, 155, 0, 158, 161, 164, 167, 170, 173, 176, 179, 182, 185, 188, 191, 194, 197, 200,
    203, 206, 0, 0, 209, 212, 215, 218, 221, 224, 227, 230, 233, 236, 239, 242, 245, 248, 251, 254,
    257, 260, 263, 266, 0, 0, 269, 272, 275, 278, 281, 284, 287, 290, 293, 0, 0, 0, 296, 299, 302,
    305, 0, 308, 311, 314, 317, 320, 323, 0, 0, 0, 0, 326, 329, 332, 335, 338, 341, 0, 0, 0, 344,
    347, 350, 353, 356, 359, 0, 0, 362, 365, 368, 371, 374, 377, 380, 383, 386, 389, 392, 395, 398,
    401, 404, 407, 410, 413, 0, 0, 416, 419, 422, 425, 428, 431, 434, 437, 440, 443, 446, 449, 452,
    455, 458, 461, 464, 467, 470, 473, 476, 479, 482, 0, 485, 488, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 491, 494, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 497, 500, 503, 506, 509, 512, 515, 518, 521, 525, 529, 533, 537, 541, 545, 549, 0, 553,
    557, 561, 565, 569, 572, 0, 0, 575, 578, 581, 584, 587, 590, 593, 597, 601, 604, 607, 0, 0, 0,
    610, 613, 0, 0, 616, 619, 622, 626, 630, 633, 636, 639, 642, 645, 648, 651, 654, 657, 660, 663,
    666, 669, 672, 675, 678, 681, 684, 687, 690, 693, 696, 699, 702, 705, 708, 711, 714, 717, 720,
    723, 0, 0, 726, 729, 0, 0, 0, 0, 0, 0, 732, 735, 738, 741, 744, 748, 752, 756, 760, 763, 766,
    770, 774, 777, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 780, 782, 0, 784, 786, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 789, 0, 0, 0, 0, 0, 0, 0, 0, 0, 791, 0, 0, 0, 0, 0, 0, 793, 796, 799,
    801, 804, 807, 0, 810, 0, 813, 816, 819, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 823, 826, 829, 832, 835, 838, 841, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 845, 848, 851, 854, 857, 0, 0, 0, 0, 860, 863, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 866, 869, 0, 872, 0, 0, 0, 875, 0, 0, 0, 0, 878, 881, 884, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 887, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 890, 0, 0, 0, 0, 0, 0, 893,
    896, 0, 899, 0, 0, 0, 902, 0, 0, 0, 0, 905, 908, 911, 0, 0, 0, 0, 0, 0, 0, 914, 917, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 920, 923, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 926, 929, 932, 935, 0, 0,
    938, 941, 0, 0, 944, 947, 950, 953, 956, 959, 0, 0, 962, 965, 968, 971, 974, 977, 0, 0, 980,
    983, 986, 989, 992, 995, 998, 1001, 1004, 1007, 1010, 1013, 0, 0, 1016, 1019, 0, 0, 0, 0, 0, 0,
    0, 0, 1022, 1025, 1028, 1031, 1034, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1037, 0, 1040, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1046, 0, 0, 0, 0, 0, 0, 0, 1049, 0, 0, 1052, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1055, 1058, 1061, 1064, 1067, 1070, 1073, 1076, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1079,
    1082, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1085, 1088, 0, 1091, 0, 0, 0, 1094, 0, 0,
    1097, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1100, 1103, 1106, 0, 0, 1109, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1112, 0, 0, 1115, 1118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1121,
    1124, 0, 0, 0, 0, 0, 0, 1127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1130, 1133, 1136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1139, 0, 0, 0, 0, 0, 0, 0, 1142, 0, 0, 0, 0,
    0, 0, 1145, 1148, 0, 1151, 1154, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1158, 1161, 1164, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1167, 0, 1170, 1173, 1177, 0, 0, 0, 0, 1180, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1183, 0, 0, 0, 0, 1186, 0, 0, 0, 0, 1189, 0, 0, 0, 0, 1192, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1198, 0, 1201, 1204, 0, 1207, 0, 0, 0, 0, 0, 0, 0,
    0, 1210, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1213, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1216, 0, 0, 0, 0, 1219, 0, 0, 0, 0, 1222, 0, 0, 0, 0, 1225, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1228, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1231, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1234, 0, 1237, 0, 1240, 0, 1243, 0, 1246, 0, 0, 0, 1249, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1252, 0, 1255, 0, 0, 1258, 1261, 0, 1264, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1267, 1270, 1273, 1276, 1279, 1282, 1285, 1288, 1291, 1295, 1299, 1302, 1305,
    1308, 1311, 1314, 1317, 1320, 1323, 1326, 1329, 1333, 1337, 1341, 1345, 1348, 1351, 1354, 1357,
    1361, 1365, 1368, 1371, 1374, 1377, 1380, 1383, 1386, 1389, 1392, 1395, 1398, 1401, 1404, 1407,
    1410, 1413, 1417, 1421, 1424, 1427, 1430, 1433, 1436, 1439, 1442, 1445, 1449, 1453, 1456, 1459,
    1462, 1465, 1468, 1471, 1474, 1477, 1480, 1483, 1486, 1489, 1492, 1495, 1498, 1501, 1504, 1507,
    1511, 1515, 1519, 1523, 1527, 1531, 1535, 1539, 1542, 1545, 1548, 1551, 1554, 1557, 1560, 1563,
    1567, 1571, 1574, 1577, 1580, 1583, 1586, 1589, 1593, 1597, 1601, 1605, 1609, 1613, 1616, 1619,
    1622, 1625, 1628, 1631, 1634, 1637, 1640, 1643, 1646, 1649, 1652, 1655, 1659, 1663, 1667, 1671,
    1674, 1677, 1680, 1683, 1686, 1689, 1692, 1695, 1698, 1701, 1704, 1707, 1710, 1713, 1716, 1719,
    1722, 1725, 1728, 1731, 1734, 1737, 1740, 1743, 1746, 1749, 1752, 1755, 1758, 0, 1761, 0, 0, 0,
    0, 1764, 1767, 1770, 1773, 1776, 1780, 1784, 1788, 1792, 1796, 1800, 1804, 1808, 1812, 1816,
    1820, 1824, 1828, 1832, 1836, 1840, 1844, 1848, 1852, 1856, 1859, 1862, 1865, 1868, 1871, 1874,
    1878, 1882, 1886, 1890, 1894, 1898, 1902, 1906, 1910, 1914, 1917, 1920, 1923, 1926, 1929, 1932,
    1935, 1938, 1942, 1946, 1950, 1954, 1958, 1962, 1966, 1970, 1974, 1978, 1982, 1986, 1990, 1994,
    1998, 2002, 2006, 2010, 2014, 2018, 2021, 2024, 2027, 2030, 2034, 2038, 2042, 2046, 2050, 2054,
    2058, 2062, 2066, 2070, 2073, 2076, 2079, 2082, 2085, 2088, 2091, 0, 0, 0, 0, 0, 0, 2094, 2097,
    2100, 2104, 2108, 2112, 2116, 2120, 2124, 2127, 2130, 2134, 2138, 2142, 2146, 2150, 2154, 2157,
    2160, 2164, 2168, 2172, 0, 0, 2176, 2179, 2182, 2186, 2190, 2194, 0, 0, 2198, 2201, 2204, 2208,
    2212, 2216, 2220, 2224, 2228, 2231, 2234, 2238, 2242, 2246, 2250, 2254, 2258, 2261, 2264, 2268,
    2272, 2276, 2280, 2284, 2288, 2291, 2294, 2298, 2302, 2306, 2310, 2314, 2318, 2321, 2324, 2328,
    2332, 2336, 0, 0, 2340, 2343, 2346, 2350, 2354, 2358, 0, 0, 2362, 2365, 2368, 2372, 2376, 2380,
    2384, 2388, 0, 2392, 0, 2395, 0, 2399, 0, 2403, 2407, 2410, 2413, 2417, 2421, 2425, 2429, 2433,
    2437, 2440, 2443, 2447, 2451, 2455, 2459, 2463, 2467, 2470, 2473, 2476, 2479, 2482, 2485, 2488,
    2491, 2494, 2497, 2500, 2503, 2506, 0, 0, 2509, 2513, 2517, 2522, 2527, 2532, 2537, 2542, 2547,
    2551, 2555, 2560, 2565, 2570, 2575, 2580, 2585, 2589, 2593, 2598, 2603, 2608, 2613, 2618, 2623,
    2627, 2631, 2636, 2641, 2646, 2651, 2656, 2661, 2665, 2669, 2674, 2679, 2684, 2689, 2694, 2699,
    2703, 2707, 2712, 2717, 2722, 2727, 2732, 2737, 2740, 2743, 2747, 2750, 0, 2754, 2757, 2761,
    2764, 2767, 2770, 2773, 0, 2776, 0, 0, 2778, 2781, 2785, 2788, 0, 2792, 2795, 2799, 2802, 2805,
    2808, 2811, 2814, 2817, 2820, 2823, 2826, 2829, 2833, 0, 0, 2837, 2840, 2844, 2847, 2850, 2853,
    0, 2856, 2859, 2862, 2865, 2868, 2871, 2875, 2879, 2882, 2885, 2888, 2892, 2895, 2898, 2901,
    2904, 2907, 2910, 2913, 0, 0, 2915, 2919, 2922, 0, 2926, 2929, 2933, 2936, 2939, 2942, 2945,
    2948, 0, 0, 2950, 2952, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2954, 0, 0,
    0, 2956, 2958, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2961, 2964, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2970, 2973, 2976, 0,
    0, 0, 0, 2979, 0, 0, 0, 0, 2982, 0, 0, 2985, 0, 0, 0, 0, 0, 0, 0, 2988, 0, 2991, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2994, 0, 0, 2997, 0, 0, 3000, 0, 3003, 0, 0, 0, 0, 0, 0, 3006, 0, 3009, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3012, 3015, 3018, 3021, 3024, 0, 0, 3027, 3030, 0, 0, 3033, 3036, 0, 0, 0,
    0, 0, 0, 3039, 3042, 0, 0, 3045, 3048, 0, 0, 3051, 3054, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3057, 3060, 3063, 3066, 3069, 3072, 3075, 3078, 0, 0, 0, 0, 0, 0, 3081, 3084,
    3087, 3090, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3093, 3095, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3097, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3100, 0, 3103, 0, 3106, 0, 3109,
    0, 3112, 0, 3115, 0, 3118, 0, 3121, 0, 3124, 0, 3127, 0, 3130, 0, 3133, 0, 0, 3136, 0, 3139, 0,
    3142, 0, 0, 0, 0, 0, 0, 3145, 3148, 0, 3151, 3154, 0, 3157, 3160, 0, 3163, 3166, 0, 3169, 3172,
    0, 0, 0, 0, 0, 0, 3175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3178, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    3181, 0, 3184, 0, 3187, 0, 3190, 0, 3193, 0, 3196, 0, 3199, 0, 3202, 0, 3205, 0, 3208, 0, 3211,
    0, 3214, 0, 0, 3217, 0, 3220, 0, 3223, 0, 0, 0, 0, 0, 0, 3226, 3229, 0, 3232, 3235, 0, 3238,
    3241, 0, 3244, 3247, 0, 3250, 3253, 0, 0, 0, 0, 0, 0, 3256, 0, 0, 3259, 3262, 3265, 3268, 0, 0,
    0, 3271, 0, 3274, 3276, 3278, 3280, 3282, 3284, 3286, 3288, 3290, 3292, 3294, 3296, 3298, 3300,
    3302, 3304, 3306, 3308, 3310, 3312, 3314, 3316, 3318, 3320, 3322, 3324, 3326, 3328, 3330, 3332,
    3334, 3336, 3338, 3340, 3342, 3344, 3346, 3348, 3350, 3352, 3354, 3356, 3358, 3360, 3362, 3364,
    3366, 3368, 3370, 3372, 3374, 3376, 3378, 3380, 3382, 3384, 3386, 3388, 3390, 3392, 3394, 3396,
    3398, 3400, 3402, 3404, 3406, 3408, 3410, 3412, 3414, 3416, 3418, 3420, 3422, 3424, 3426, 3428,
    3430, 3432, 3434, 3436, 3438, 3440, 3442, 3444, 3446, 3448, 3450, 3452, 3454, 3456, 3458, 3460,
    3462, 3464, 3466, 3468, 3470, 3472, 3474, 3476, 3478, 3480, 3482, 3484, 3486, 3488, 3490, 3492,
    3494, 3496, 3498, 3500, 3502, 3504, 3506, 3508, 3510, 3512, 3514, 3516, 3518, 3520, 3522, 3524,
    3526, 3528, 3530, 3532, 3534, 3536, 3538, 3540, 3542, 3544, 3546, 3548, 3550, 3552, 3554, 3556,
    3558, 3560, 3562, 3564, 3566, 3568, 3570, 3572, 3574, 3576, 3578, 3580, 3582, 3584, 3586, 3588,
    3590, 3592, 3594, 3596, 3598, 3600, 3602, 3604, 3606, 3608, 3610, 3612, 3614, 3616, 3618, 3620,
    3622, 3624, 3626, 3628, 3630, 3632, 3634, 3636, 3638, 3640, 3642, 3644, 3646, 3648, 3650, 3652,
    3654, 3656, 3658, 3660, 3662, 3664, 3666, 3668, 3670, 3672, 3674, 3676, 3678, 3680, 3682, 3684,
    3686, 3688, 3690, 3692, 3694, 3696, 3698, 3700, 3702, 3704, 3706, 3708, 3710, 3712, 3714, 3716,
    3718, 3720, 3722, 3724, 3726, 3728, 3730, 3732, 3734, 3736, 3738, 3740, 3742, 3744, 3746, 3748,
    3750, 3752, 3754, 3756, 3758, 3760, 3762, 3764, 3766, 3768, 3770, 3772, 3774, 3776, 3778, 3780,
    3782, 3784, 3786, 3788, 3790, 3792, 3794, 3796, 3798, 3800, 3802, 3804, 3806, 3808, 3810, 3812,
    0, 0, 3814, 0, 3816, 0, 0, 3818, 3820, 3822, 3824, 3826, 3828, 3830, 3832, 3834, 3836, 0, 3838,
    0, 3840, 0, 0, 3842, 3844, 0, 0, 0, 3846, 3848, 3850, 3852, 3854, 3856, 3858, 3860, 3862, 3864,
    3866, 3868, 3870, 3872, 3874, 3876, 3878, 3880, 3882, 3884, 3886, 3888, 3890, 3892, 3894, 3896,
    3898, 3900, 3902, 3904, 3906, 3908, 3910, 3912, 3914, 3916, 3918, 3920, 3922, 3924, 3926, 3928,
    3930, 3932, 3934, 3936, 3938, 3940, 3942, 3944, 3946, 3948, 3950, 3952, 3954, 3956, 3958, 3960,
    3962, 3964, 3966, 3968, 3970, 3972, 3974, 3976, 3978, 3980, 0, 0, 3982, 3984, 3986, 3988, 3990,
    3992, 3994, 3996, 3998, 4000, 4002, 4004, 4006, 4008, 4010, 4012, 4014, 4016, 4018, 4020, 4022,
    4024, 4026, 4028, 4030, 4032, 4034, 4036, 4038, 4040, 4042, 4044, 4046, 4048, 4050, 4052, 4054,
    4056, 4058, 4060, 4062, 4064, 4066, 4068, 4070, 4072, 4074, 4076, 4078, 4080, 4082, 4084, 4086,
    4088, 4090, 4092, 4094, 4096, 4098, 4100, 4102, 4104, 4106, 4108, 4110, 4112, 4114, 4116, 4118,
    4120, 4122, 4124, 4126, 4128, 4130, 4132, 4134, 4136, 4138, 4140, 4142, 4144, 4146, 4148, 4150,
    4152, 4154, 4156, 4158, 4160, 4162, 4164, 4166, 4168, 4170, 4172, 4174, 4176, 4178, 4180, 4182,
    4184, 4186, 4188, 4190, 4192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4194, 0,
    4197, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4200, 4203, 4206, 4210, 4214, 4217, 4220, 4223, 4226, 4229,
    4232, 4235, 4238, 0, 4241, 4244, 4247, 4250, 4253, 0, 4256, 0, 4259, 4262, 0, 4265, 4268, 0,
    4271, 4274, 4277, 4280, 4283, 4286, 4289, 4292, 4295, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4298, 0,
    4301, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4307, 4310, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4313, 4316, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4319, 4322, 0, 4325, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4328, 4331, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4337,
    4340, 4343, 4347, 4351, 4355, 4359, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4363, 4366, 4369, 4373, 4377, 4381, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4385,
    4387, 4389, 4391, 4393, 4395, 4397, 4399, 4401, 4403, 4405, 4407, 4409, 4411, 4413, 4415, 4417,
    4419, 4421, 4423, 4425, 4427, 4429, 4431, 4433, 4435, 4437, 4439, 4441, 4443, 4445, 4447, 4449,
    4451, 4453, 4455, 4457, 4459, 4461, 4463, 4465, 4467, 4469, 4471, 4473, 4475, 4477, 4479, 4481,
    4483, 4485, 4487, 4489, 4491, 4493, 4495, 4497, 4499, 4501, 4503, 4505, 4507, 4509, 4511, 4513,
    4515, 4517, 4519, 4521, 4523, 4525, 4527, 4529, 4531, 4533, 4535, 4537, 4539, 4541, 4543, 4545,
    4547, 4549, 4551, 4553, 4555, 4557, 4559, 4561, 4563, 4565, 4567, 4569, 4571, 4573, 4575, 4577,
    4579, 4581, 4583, 4585, 4587, 4589, 4591, 4593, 4595, 4597, 4599, 4601, 4603, 4605, 4607, 4609,
    4611, 4613, 4615, 4617, 4619, 4621, 4623, 4625, 4627, 4629, 4631, 4633, 4635, 4637, 4639, 4641,
    4643, 4645, 4647, 4649, 4651, 4653, 4655, 4657, 4659, 4661, 4663, 4665, 4667, 4669, 4671, 4673,
    4675, 4677, 4679, 4681, 4683, 4685, 4687, 4689, 4691, 4693, 4695, 4697, 4699, 4701, 4703, 4705,
    4707, 4709, 4711, 4713, 4715, 4717, 4719, 4721, 4723, 4725, 4727, 4729, 4731, 4733, 4735, 4737,
    4739, 4741, 4743, 4745, 4747, 4749, 4751, 4753, 4755, 4757, 4759, 4761, 4763, 4765, 4767, 4769,
    4771, 4773, 4775, 4777, 4779, 4781, 4783, 4785, 4787, 4789, 4791, 4793, 4795, 4797, 4799, 4801,
    4803, 4805, 4807, 4809, 4811, 4813, 4815, 4817, 4819, 4821, 4823, 4825, 4827, 4829, 4831, 4833,
    4835, 4837, 4839, 4841, 4843, 4845, 4847, 4849, 4851, 4853, 4855, 4857, 4859, 4861, 4863, 4865,
    4867, 4869, 4871, 4873, 4875, 4877, 4879, 4881, 4883, 4885, 4887, 4889, 4891, 4893, 4895, 4897,
    4899, 4901, 4903, 4905, 4907, 4909, 4911, 4913, 4915, 4917, 4919, 4921, 4923, 4925, 4927, 4929,
    4931, 4933, 4935, 4937, 4939, 4941, 4943, 4945, 4947, 4949, 4951, 4953, 4955, 4957, 4959, 4961,
    4963, 4965, 4967, 4969, 4971, 4973, 4975, 4977, 4979, 4981, 4983, 4985, 4987, 4989, 4991, 4993,
    4995, 4997, 4999, 5001, 5003, 5005, 5007, 5009, 5011, 5013, 5015, 5017, 5019, 5021, 5023, 5025,
    5027, 5029, 5031, 5033, 5035, 5037, 5039, 5041, 5043, 5045, 5047, 5049, 5051, 5053, 5055, 5057,
    5059, 5061, 5063, 5065, 5067, 5069, 5071, 5073, 5075, 5077, 5079, 5081, 5083, 5085, 5087, 5089,
    5091, 5093, 5095, 5097, 5099, 5101, 5103, 5105, 5107, 5109, 5111, 5113, 5115, 5117, 5119, 5121,
    5123, 5125, 5127, 5129, 5131, 5133, 5135, 5137, 5139, 5141, 5143, 5145, 5147, 5149, 5151, 5153,
    5155, 5157, 5159, 5161, 5163, 5165, 5167, 5169, 5171, 5173, 5175, 5177, 5179, 5181, 5183, 5185,
    5187, 5189, 5191, 5193, 5195, 5197, 5199, 5201, 5203, 5205, 5207, 5209, 5211, 5213, 5215, 5217,
    5219, 5221, 5223, 5225, 5227, 5229, 5231, 5233, 5235, 5237, 5239, 5241, 5243, 5245, 5247, 5249,
    5251, 5253, 5255, 5257, 5259, 5261, 5263, 5265, 5267, 5269, 5271, 5273, 5275, 5277, 5279, 5281,
    5283, 5285, 5287, 5289, 5291, 5293, 5295, 5297, 5299, 5301, 5303, 5305, 5307, 5309, 5311, 5313,
    5315, 5317, 5319, 5321, 5323, 5325, 5327, 5329, 5331, 5333, 5335, 5337, 5339, 5341, 5343, 5345,
    5347, 5349, 5351, 5353, 5355, 5357, 5359, 5361, 5363, 5365, 5367, 5369, 5371, 5373, 5375, 5377,
    5379, 5381, 5383, 5385, 5387, 5389, 5391, 5393, 5395, 5397, 5399, 5401, 5403, 5405, 5407, 5409,
    5411, 5413, 5415, 5417, 5419, 5421, 5423, 5425, 5427, 5429, 5431, 5433, 5435, 5437, 5439, 5441,
    5443, 5445, 5447, 5449, 5451, 5453, 5455, 5457, 5459, 5461, 5463, 5465, 5467, 0, 0,
];

pub fn decompose_index(x: usize) -> usize {
    const SHIFT1: usize = 6;
    const SHIFT2: usize = 4;
    if x >= 1114112 {
        return 0;
    }
    let mut index = (DECOMPOSE_INDEX0[x >> (SHIFT1 + SHIFT2)] as usize) << SHIFT1;
    let mut offset = (x >> SHIFT2) & ((1 << SHIFT1) - 1);
    index = (DECOMPOSE_INDEX1[index + offset] as usize) << SHIFT2;
    offset = x & ((1 << SHIFT2) - 1);
    DECOMPOSE_INDEX2[index + offset] as usize
}
#[rustfmt::skip]
const DECOMPOSE_COMPAT_INDEX0: [u8; 1088] = [
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 13, 14, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    15, 16, 5, 5, 5, 5, 17, 18, 19, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 20, 21, 5, 5, 5, 5, 5,
    22, 23, 5, 24, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 25, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5,
];

#[rustfmt::skip]
const DECOMPOSE_COMPAT_INDEX1: [u16; 1664] = [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 3, 5, 6, 7, 8, 9, 10, 11, 8, 12, 0, 0, 13, 14, 15,
    16, 17, 18, 6, 19, 20, 21, 0, 0, 0, 0, 0, 0, 0, 22, 0, 23, 24, 0, 0, 0, 0, 0, 25, 0, 0, 26, 27,
    14, 28, 14, 29, 30, 0, 31, 32, 33, 0, 33, 0, 32, 0, 34, 0, 0, 0, 0, 35, 36, 37, 38, 0, 0, 0, 0,
    0, 0, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0, 0, 41, 0, 0, 0, 0, 42, 43, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    33, 44, 0, 45, 0, 0, 0, 0, 0, 0, 46, 47, 0, 0, 0, 0, 0, 48, 0, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 50, 51, 0, 0, 0, 52, 0, 0, 53, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 55,
    0, 0, 0, 0, 0, 0, 0, 53, 0, 0, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0,
    58, 0, 59, 0, 0, 60, 0, 0, 0, 61, 62, 33, 63, 64, 61, 62, 33, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 68, 0, 69, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 72, 73, 74, 75, 76, 0, 77, 78, 79, 0, 0, 0, 0, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 80, 6, 6, 6, 6, 6, 81, 6, 82, 6, 6, 82, 83, 6, 84, 6, 6, 6, 85, 86, 87,
    88, 89, 90, 91, 92, 93, 94, 95, 0, 96, 97, 98, 99, 0, 0, 0, 0, 0, 100, 101, 102, 103, 104, 105,
    106, 107, 108, 109, 110, 0, 111, 0, 0, 0, 112, 0, 113, 114, 115, 0, 116, 117, 117, 0, 118, 0,
    0, 0, 119, 0, 0, 0, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 122,
    123, 124, 125, 126, 127, 128, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130, 0,
    0, 0, 0, 0, 0, 131, 0, 0, 0, 0, 0, 132, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 133, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 0, 0, 0, 0, 0, 136, 137, 138, 139, 140, 141, 142, 143,
    144, 145, 146, 147, 148, 149, 150, 0, 0, 151, 0, 0, 152, 153, 154, 155, 156, 0, 157, 153, 154,
    155, 156, 0, 158, 0, 0, 0, 159, 160, 161, 162, 163, 164, 165, 0, 0, 0, 0, 0, 0, 166, 167, 168,
    169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187,
    188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 199, 0, 0, 0, 0, 0, 0, 0, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 201, 202, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 84, 203, 204, 6, 6, 6, 84, 6,
    6, 6, 6, 6, 6, 81, 0, 0, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 0, 217,
    218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236,
    237, 238, 239, 0, 240, 241, 242, 243, 244, 245, 246, 247, 0, 0, 248, 0, 249, 0, 250, 251, 252,
    253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271,
    272, 273, 274, 275, 276, 277, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 278, 279, 0, 0, 0, 0, 0, 0, 0, 280,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 281, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 280, 282, 0, 0, 0, 0, 283, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 284, 285, 286, 287, 288, 289, 290,
    291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309,
    310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328,
    329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 360, 361, 362, 363,
    364, 0, 365, 0, 0, 366, 0, 0, 0, 0, 0, 0, 367, 368, 369, 370, 371, 372, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 373, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];

#[rustfmt::skip]
const DECOMPOSE_COMPAT_INDEX2: [u16; 5984] = [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 4, 0, 7, 0, 0, 0, 0, 9,
    0, 0, 12, 14, 16, 19, 0, 0, 21, 24, 26, 0, 28, 32, 36, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 40, 43, 1, 1, 1, 1, 0, 1, 1,
    1, 1, 1, 1, 46, 49, 0, 0, 1, 1, 1, 1, 1, 1, 52, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 55, 1, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 61, 65,
    69, 72, 75, 78, 81, 84, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0,
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 87, 90, 93, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 98, 100, 102, 104, 106, 108, 110, 112, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 117, 120, 123, 126, 129, 0, 0, 132, 134, 136, 138, 140, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 142, 0, 0, 0, 1, 0, 0, 0, 0, 0, 145, 148, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 152, 154,
    156, 158, 161, 164, 166, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 170, 172, 0, 174, 176, 0, 0, 0, 178,
    0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 186,
    189, 192, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 195,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 201, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 1, 0, 1, 1, 209, 1, 213, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 221, 223, 0, 225, 227, 229, 231, 233, 235, 237,
    239, 241, 243, 245, 0, 247, 249, 251, 253, 255, 257, 259, 261, 263, 265, 267, 269, 271, 273,
    275, 277, 279, 281, 0, 283, 285, 287, 289, 291, 293, 295, 297, 299, 301, 303, 305, 307, 309,
    311, 313, 315, 317, 319, 321, 323, 325, 327, 329, 331, 333, 335, 337, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 339, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 341, 343, 345, 347,
    349, 351, 353, 355, 357, 359, 361, 363, 365, 367, 369, 371, 373, 375, 377, 379, 381, 383, 385,
    387, 389, 391, 393, 395, 397, 399, 401, 403, 405, 407, 409, 411, 413, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 415, 418, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 421, 1, 424, 427, 430, 1,
    1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 434, 438, 442, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 446, 450,
    454, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 458, 462, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1,
    466, 469, 0, 472, 474, 476, 478, 480, 482, 484, 486, 488, 490, 492, 0, 0, 0, 0, 0, 0, 494, 0,
    0, 0, 0, 0, 496, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 499, 501, 504, 0, 0, 0, 0, 0, 0, 0, 0,
    508, 0, 0, 0, 510, 513, 0, 517, 520, 0, 0, 0, 0, 524, 0, 527, 0, 0, 0, 0, 0, 0, 0, 0, 530, 533,
    536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 539, 0, 0, 0, 0, 0, 0, 0, 544, 546, 548, 0, 0, 550,
    552, 554, 556, 558, 560, 562, 564, 566, 568, 570, 572, 574, 576, 578, 580, 582, 584, 586, 588,
    590, 592, 594, 596, 598, 600, 602, 0, 604, 606, 608, 610, 612, 614, 616, 618, 620, 622, 624,
    626, 628, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 630, 0, 0, 0, 0, 0, 0, 0, 633, 637, 641, 643, 0,
    646, 650, 654, 0, 656, 659, 661, 663, 665, 667, 669, 671, 673, 675, 677, 0, 679, 681, 0, 0,
    684, 686, 688, 690, 692, 0, 0, 694, 697, 701, 0, 704, 0, 1, 0, 706, 0, 1, 1, 708, 710, 0, 712,
    714, 716, 0, 718, 720, 722, 724, 726, 728, 730, 0, 732, 736, 738, 740, 742, 744, 0, 0, 0, 0,
    746, 748, 750, 752, 754, 0, 0, 0, 0, 0, 0, 756, 760, 764, 769, 773, 777, 781, 785, 789, 793,
    797, 801, 805, 809, 813, 817, 820, 822, 825, 829, 832, 834, 837, 841, 846, 849, 851, 854, 858,
    860, 862, 864, 866, 868, 871, 875, 878, 880, 883, 887, 892, 895, 897, 900, 904, 906, 908, 910,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
    1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 916,
    919, 0, 923, 926, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1,
    1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 930, 932, 934, 936, 938, 940,
    942, 944, 946, 948, 951, 954, 957, 960, 963, 966, 969, 972, 975, 978, 981, 985, 989, 993, 997,
    1001, 1005, 1009, 1013, 1017, 1022, 1027, 1032, 1037, 1042, 1047, 1052, 1057, 1062, 1067, 1072,
    1075, 1078, 1081, 1084, 1087, 1090, 1093, 1096, 1099, 1103, 1107, 1111, 1115, 1119, 1123, 1127,
    1131, 1135, 1139, 1143, 1147, 1151, 1155, 1159, 1163, 1167, 1171, 1175, 1179, 1183, 1187, 1191,
    1195, 1199, 1203, 1207, 1211, 1215, 1219, 1223, 1227, 1231, 1235, 1239, 1243, 1247, 1249, 1251,
    1253, 1255, 1257, 1259, 1261, 1263, 1265, 1267, 1269, 1271, 1273, 1275, 1277, 1279, 1281, 1283,
    1285, 1287, 1289, 1291, 1293, 1295, 1297, 1299, 1301, 1303, 1305, 1307, 1309, 1311, 1313, 1315,
    1317, 1319, 1321, 1323, 1325, 1327, 1329, 1331, 1333, 1335, 1337, 1339, 1341, 1343, 1345, 1347,
    1349, 1351, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1353, 0, 0, 0, 0, 0, 0, 0, 1358,
    1362, 1365, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1369, 1371, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1373,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1375, 0, 0, 0, 1377, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1379, 1381, 1383, 1385, 1387, 1389, 1391, 1393, 1395, 1397, 1399, 1401, 1403, 1405, 1407,
    1409, 1411, 1413, 1415, 1417, 1419, 1421, 1423, 1425, 1427, 1429, 1431, 1433, 1435, 1437, 1439,
    1441, 1443, 1445, 1447, 1449, 1451, 1453, 1455, 1457, 1459, 1461, 1463, 1465, 1467, 1469, 1471,
    1473, 1475, 1477, 1479, 1481, 1483, 1485, 1487, 1489, 1491, 1493, 1495, 1497, 1499, 1501, 1503,
    1505, 1507, 1509, 1511, 1513, 1515, 1517, 1519, 1521, 1523, 1525, 1527, 1529, 1531, 1533, 1535,
    1537, 1539, 1541, 1543, 1545, 1547, 1549, 1551, 1553, 1555, 1557, 1559, 1561, 1563, 1565, 1567,
    1569, 1571, 1573, 1575, 1577, 1579, 1581, 1583, 1585, 1587, 1589, 1591, 1593, 1595, 1597, 1599,
    1601, 1603, 1605, 1607, 1609, 1611, 1613, 1615, 1617, 1619, 1621, 1623, 1625, 1627, 1629, 1631,
    1633, 1635, 1637, 1639, 1641, 1643, 1645, 1647, 1649, 1651, 1653, 1655, 1657, 1659, 1661, 1663,
    1665, 1667, 1669, 1671, 1673, 1675, 1677, 1679, 1681, 1683, 1685, 1687, 1689, 1691, 1693, 1695,
    1697, 1699, 1701, 1703, 1705, 1707, 1709, 1711, 1713, 1715, 1717, 1719, 1721, 1723, 1725, 1727,
    1729, 1731, 1733, 1735, 1737, 1739, 1741, 1743, 1745, 1747, 1749, 1751, 1753, 1755, 1757, 1759,
    1761, 1763, 1765, 1767, 1769, 1771, 1773, 1775, 1777, 1779, 1781, 1783, 1785, 1787, 1789, 1791,
    1793, 1795, 1797, 1799, 1801, 1803, 1805, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1807, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1809, 0, 1811, 1813, 1815, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 1817, 1820, 0, 1, 1823, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1,
    1826, 0, 1829, 1831, 1833, 1835, 1837, 1839, 1841, 1843, 1845, 1847, 1849, 1851, 1853, 1855,
    1857, 1859, 1861, 1863, 1865, 1867, 1869, 1871, 1873, 1875, 1877, 1879, 1881, 1883, 1885, 1887,
    1889, 1891, 1893, 1895, 1897, 1899, 1901, 1903, 1905, 1907, 1909, 1911, 1913, 1915, 1917, 1919,
    1921, 1923, 1925, 1927, 1929, 1931, 1933, 1935, 1937, 1939, 1941, 1943, 1945, 1947, 1949, 1951,
    1953, 1955, 1957, 1959, 1961, 1963, 1965, 1967, 1969, 1971, 1973, 1975, 1977, 1979, 1981, 1983,
    1985, 1987, 1989, 1991, 1993, 1995, 1997, 1999, 2001, 2003, 2005, 2007, 2009, 2011, 2013, 2015,
    0, 0, 0, 2017, 2019, 2021, 2023, 2025, 2027, 2029, 2031, 2033, 2035, 2037, 2039, 2041, 2043,
    2045, 2049, 2053, 2057, 2061, 2065, 2069, 2073, 2077, 2081, 2085, 2089, 2093, 2097, 2101, 2106,
    2111, 2116, 2121, 2126, 2131, 2136, 2141, 2146, 2151, 2156, 2161, 2166, 2171, 2176, 2184, 0,
    2191, 2195, 2199, 2203, 2207, 2211, 2215, 2219, 2223, 2227, 2231, 2235, 2239, 2243, 2247, 2251,
    2255, 2259, 2263, 2267, 2271, 2275, 2279, 2283, 2287, 2291, 2295, 2299, 2303, 2307, 2311, 2315,
    2319, 2323, 2327, 2331, 2335, 2337, 2339, 2341, 0, 0, 0, 0, 0, 0, 0, 0, 2343, 2347, 2350, 2353,
    2356, 2359, 2362, 2365, 2368, 2371, 2374, 2377, 2380, 2383, 2386, 2389, 2392, 2394, 2396, 2398,
    2400, 2402, 2404, 2406, 2408, 2410, 2412, 2414, 2416, 2418, 2420, 2423, 2426, 2429, 2432, 2435,
    2438, 2441, 2444, 2447, 2450, 2453, 2456, 2459, 2462, 2468, 2473, 0, 2476, 2478, 2480, 2482,
    2484, 2486, 2488, 2490, 2492, 2494, 2496, 2498, 2500, 2502, 2504, 2506, 2508, 2510, 2512, 2514,
    2516, 2518, 2520, 2522, 2524, 2526, 2528, 2530, 2532, 2534, 2536, 2538, 2540, 2542, 2544, 2546,
    2548, 2550, 2552, 2554, 2556, 2558, 2560, 2562, 2564, 2566, 2568, 2570, 2572, 2574, 2577, 2580,
    2583, 2586, 2589, 2592, 2595, 2598, 2601, 2604, 2607, 2610, 2613, 2616, 2619, 2622, 2625, 2628,
    2631, 2634, 2637, 2640, 2643, 2646, 2650, 2654, 2658, 2661, 2665, 2668, 2672, 2674, 2676, 2678,
    2680, 2682, 2684, 2686, 2688, 2690, 2692, 2694, 2696, 2698, 2700, 2702, 2704, 2706, 2708, 2710,
    2712, 2714, 2716, 2718, 2720, 2722, 2724, 2726, 2728, 2730, 2732, 2734, 2736, 2738, 2740, 2742,
    2744, 2746, 2748, 2750, 2752, 2754, 2756, 2758, 2760, 2762, 2764, 2766, 2769, 2775, 2780, 2786,
    2790, 2796, 2800, 2804, 2811, 2816, 2820, 2824, 2828, 2833, 2838, 2843, 2848, 2853, 2858, 2863,
    2870, 2873, 2880, 2887, 2893, 2898, 2905, 2912, 2917, 2921, 2925, 2930, 2935, 2941, 2947, 2951,
    2955, 2960, 2964, 2968, 2971, 2974, 2978, 2982, 2989, 2994, 3000, 3007, 3012, 3016, 3020, 3027,
    3032, 3039, 3043, 3049, 3053, 3058, 3062, 3067, 3073, 3078, 3084, 3089, 3092, 3098, 3102, 3106,
    3111, 3115, 3119, 3123, 3129, 3134, 3137, 3144, 3148, 3154, 3159, 3164, 3168, 3172, 3177, 3180,
    3185, 3191, 3194, 3201, 3205, 3208, 3211, 3214, 3217, 3220, 3223, 3226, 3229, 3232, 3235, 3239,
    3243, 3247, 3251, 3255, 3259, 3263, 3267, 3271, 3275, 3279, 3283, 3287, 3291, 3295, 3299, 3302,
    3305, 3309, 3312, 3315, 3318, 3322, 3326, 3329, 3332, 3335, 3338, 3341, 3346, 3349, 3352, 3355,
    3358, 3361, 3364, 3367, 3370, 3374, 3379, 3382, 3385, 3388, 3391, 3394, 3397, 3400, 3404, 3408,
    3412, 3416, 3419, 3422, 3425, 3428, 3431, 3434, 3437, 3440, 3443, 3446, 3450, 3454, 3457, 3461,
    3465, 3469, 3472, 3476, 3480, 3485, 3488, 3492, 3496, 3500, 3504, 3510, 3517, 3520, 3523, 3526,
    3529, 3532, 3535, 3538, 3541, 3544, 3547, 3550, 3553, 3556, 3559, 3562, 3565, 3568, 3571, 3576,
    3579, 3582, 3585, 3590, 3594, 3597, 3600, 3603, 3606, 3609, 3612, 3615, 3618, 3621, 3624, 3628,
    3631, 3634, 3638, 3642, 3645, 3650, 3654, 3657, 3660, 3663, 3666, 3670, 3674, 3677, 3680, 3683,
    3686, 3689, 3692, 3695, 3698, 3701, 3705, 3709, 3713, 3717, 3721, 3725, 3729, 3733, 3737, 3741,
    3745, 3749, 3753, 3757, 3761, 3765, 3769, 3773, 3777, 3781, 3785, 3789, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3793, 3795, 0, 0, 3797, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3799, 3801, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3803, 3805, 3807,
    3809, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3811, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3813, 3816, 3819, 3822, 3826, 3830,
    3833, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3836, 3839, 3842, 3845, 3848, 0, 0, 0, 0, 0, 1, 0, 1,
    3851, 3853, 3855, 3857, 3859, 3861, 3863, 3865, 3867, 3869, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3871, 3874, 3876,
    3878, 3880, 3882, 3884, 3886, 3888, 3890, 3892, 3894, 3896, 3898, 3900, 3902, 3904, 3906, 3908,
    3910, 3912, 3914, 3916, 3918, 3920, 3922, 3924, 3926, 3928, 3930, 3932, 3934, 3936, 3938, 3940,
    3942, 3944, 3946, 3948, 3950, 3952, 3954, 3956, 3958, 3960, 3962, 3964, 3966, 3968, 3970, 3972,
    3974, 3976, 3978, 3980, 3982, 3984, 3986, 3988, 3990, 3992, 3994, 3996, 3998, 4000, 4002, 4004,
    4006, 4008, 4010, 4012, 4014, 4016, 4018, 4020, 4022, 4024, 4026, 4028, 4030, 4032, 4034, 4036,
    4038, 4040, 4042, 4045, 4048, 4050, 4052, 4054, 4056, 4058, 4060, 4062, 4064, 4066, 4068, 4071,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4074, 4076, 4078, 4080, 4082, 4084, 4086,
    4088, 4090, 4092, 4094, 4097, 4099, 4101, 4103, 4105, 4107, 4109, 4111, 4113, 4115, 4117, 4119,
    4121, 4125, 4129, 4133, 4137, 4141, 4145, 4149, 4153, 4157, 4161, 4165, 4169, 4173, 4177, 4181,
    4185, 4189, 4193, 4195, 4197, 4199, 4201, 4205, 4209, 4213, 4217, 4221, 4224, 4227, 4230, 4233,
    4236, 4239, 4242, 4245, 4248, 4251, 4254, 4257, 4260, 4263, 4266, 4269, 4272, 4275, 4278, 4281,
    4284, 4287, 4290, 4293, 4296, 4299, 4302, 4305, 4308, 4311, 4314, 4317, 4320, 4323, 4326, 4329,
    4332, 4335, 4338, 4341, 4344, 4347, 4350, 4353, 4356, 4359, 4362, 4365, 4368, 4371, 4374, 4377,
    4380, 4383, 4386, 4389, 4392, 4395, 4398, 4401, 4404, 4407, 4410, 4413, 4416, 4419, 4422, 4425,
    4428, 4431, 4434, 4437, 4440, 4443, 4446, 4449, 4452, 4455, 4458, 4461, 4464, 4467, 4470, 4473,
    4476, 4479, 4482, 4485, 4488, 4492, 4496, 4500, 4504, 4508, 4512, 4516, 4520, 4524, 4528, 4532,
    4536, 4539, 4542, 4545, 4548, 4551, 4554, 4557, 4560, 4563, 4566, 4569, 4572, 4575, 4578, 4581,
    4584, 4587, 4590, 4593, 4596, 4599, 4602, 4605, 4608, 4611, 4614, 4617, 4620, 4623, 4626, 4629,
    4632, 4635, 4638, 4641, 4644, 4647, 4650, 4653, 4656, 4659, 4662, 4665, 4668, 4671, 4675, 4679,
    4683, 4687, 4691, 4694, 4697, 4700, 4703, 4706, 4709, 4712, 4715, 4718, 4721, 4724, 4727, 4730,
    4733, 4736, 4739, 4742, 4745, 4748, 4751, 4754, 4757, 4760, 4763, 4766, 4769, 4772, 4775, 4778,
    4781, 4784, 4787, 4790, 4793, 4796, 4799, 4802, 4805, 4808, 4811, 4814, 4817, 4820, 4823, 4826,
    4829, 4832, 4835, 4838, 4841, 4844, 4847, 4850, 4853, 4856, 4859, 4862, 4865, 4868, 4871, 4874,
    4877, 4880, 4883, 4886, 4889, 4892, 4896, 4900, 4903, 4906, 4909, 4912, 4915, 4918, 4921, 4924,
    4927, 4930, 4933, 4936, 4939, 4942, 4945, 4948, 4951, 4955, 4959, 4963, 4966, 4969, 4972, 4975,
    4978, 4981, 4984, 4987, 4990, 4993, 4996, 4999, 5002, 5005, 5008, 5011, 5014, 5017, 5020, 5023,
    5026, 5029, 5032, 5035, 5038, 5041, 5044, 5047, 5050, 5053, 5056, 5059, 5062, 5065, 5068, 5071,
    5074, 5077, 5080, 5083, 5086, 5089, 5092, 5095, 5098, 5101, 5104, 5107, 5110, 5113, 5116, 5119,
    5122, 5125, 5128, 5131, 5134, 5137, 5140, 5143, 5146, 5149, 5152, 5155, 5158, 5161, 5164, 5167,
    5170, 5173, 5176, 5179, 0, 0, 5182, 5186, 5190, 5194, 5198, 5202, 5206, 5210, 5214, 5218, 5222,
    5226, 5230, 5234, 5238, 5242, 5246, 5250, 5254, 5258, 5262, 5266, 5270, 5274, 5278, 5282, 5286,
    5290, 5294, 5298, 5302, 5306, 5310, 5314, 5318, 5322, 5326, 5330, 5334, 5338, 5342, 5346, 5350,
    5354, 5358, 5362, 5366, 5370, 5374, 5378, 5382, 5386, 5390, 5394, 5398, 5402, 5406, 5410, 5414,
    5418, 5422, 5426, 5430, 5434, 0, 0, 5438, 5442, 5446, 5450, 5454, 5458, 5462, 5466, 5470, 5474,
    5478, 5482, 5486, 5490, 5494, 5498, 5502, 5506, 5510, 5514, 5518, 5522, 5526, 5530, 5534, 5538,
    5542, 5546, 5550, 5554, 5558, 5562, 5566, 5570, 5574, 5578, 5582, 5586, 5590, 5594, 5598, 5602,
    5606, 5610, 5614, 5618, 5622, 5626, 5630, 5634, 5638, 5642, 5646, 5650, 0, 0, 0, 0, 0, 0, 0, 0,
    5654, 5658, 5662, 5667, 5672, 5677, 5682, 5687, 5692, 5697, 5701, 5720, 5729, 0, 0, 0, 5734,
    5736, 5738, 5740, 5742, 5744, 5746, 5748, 5750, 5752, 0, 0, 0, 0, 0, 0, 5756, 5759, 5761, 5763,
    5765, 5767, 5769, 5771, 5773, 5775, 5777, 5779, 5781, 5783, 5785, 5787, 5789, 5791, 5793, 5795,
    5797, 0, 0, 5799, 5801, 5803, 5806, 5809, 5812, 5815, 5817, 5819, 5821, 5823, 5825, 0, 5827,
    5829, 5831, 5833, 5835, 5837, 5839, 5841, 5843, 5845, 5847, 5849, 5851, 5853, 5855, 5857, 5859,
    5861, 5863, 0, 5865, 5867, 5869, 5871, 0, 0, 0, 0, 5873, 5876, 5879, 0, 5882, 0, 5885, 5888,
    5891, 5894, 5897, 5900, 5903, 5906, 5909, 5912, 5915, 5917, 5920, 5923, 5926, 5929, 5932, 5935,
    5938, 5941, 5944, 5947, 5950, 5953, 5955, 5957, 5959, 5961, 5963, 5965, 5967, 5969, 5971, 5973,
    5975, 5977, 5979, 5981, 5983, 5985, 5987, 5989, 5991, 5993, 5995, 5997, 5999, 6001, 6003, 6005,
    6007, 6009, 6011, 6013, 6015, 6017, 6019, 6021, 6023, 6025, 6027, 6029, 6031, 6033, 6035, 6037,
    6039, 6041, 6043, 6045, 6047, 6049, 6051, 6053, 6055, 6057, 6059, 6061, 6063, 6065, 6067, 6069,
    6071, 6073, 6075, 6077, 6079, 6081, 6083, 6085, 6087, 6089, 6091, 6093, 6095, 6097, 6099, 6101,
    6103, 6105, 6107, 6109, 6111, 6113, 6115, 6117, 6119, 6121, 6123, 6125, 6127, 6129, 6131, 6133,
    6135, 6137, 6139, 6141, 6143, 6145, 6147, 6149, 6151, 6153, 6155, 6157, 6159, 6161, 6165, 6169,
    6173, 6177, 6181, 6185, 6188, 0, 0, 0, 0, 6191, 6193, 6195, 6197, 6199, 6201, 6203, 6205, 6207,
    6209, 6211, 6213, 6215, 6217, 6219, 6221, 6223, 6225, 6227, 6229, 6231, 6233, 6235, 6237, 6239,
    6241, 6243, 6245, 6247, 6249, 6251, 6253, 6255, 6257, 6259, 6261, 6263, 6265, 6267, 6269, 6271,
    6273, 6275, 6277, 6279, 6281, 6283, 6285, 6287, 6289, 6291, 6293, 6295, 6297, 6299, 6301, 6303,
    6305, 6307, 6309, 6311, 6313, 6315, 6317, 6319, 6321, 6323, 6325, 6327, 6329, 6331, 6333, 6335,
    6337, 6339, 6341, 6343, 6345, 6347, 6349, 6351, 6353, 6355, 6357, 6359, 6361, 6363, 6365, 6367,
    6369, 6371, 6373, 6375, 6377, 6379, 6381, 6383, 6385, 6387, 6389, 6391, 6393, 6395, 6397, 6399,
    6401, 6403, 6405, 6407, 6409, 6411, 6413, 6415, 6417, 6419, 6421, 6423, 6425, 6427, 6429, 6431,
    6433, 6435, 6437, 6439, 6441, 6443, 6445, 6447, 6449, 6451, 6453, 6455, 6457, 6459, 6461, 6463,
    6465, 6467, 6469, 6471, 6473, 6475, 6477, 6479, 6481, 6483, 6485, 6487, 6489, 6491, 6493, 6495,
    6497, 6499, 6501, 6503, 6505, 6507, 6509, 6511, 6513, 6515, 6517, 6519, 6521, 6523, 6525, 6527,
    6529, 6531, 6533, 6535, 6537, 6539, 6541, 6543, 6545, 6547, 6549, 6551, 6553, 6555, 6557, 6559,
    6561, 6563, 6565, 6567, 6569, 0, 0, 0, 6571, 6573, 6575, 6577, 6579, 6581, 0, 0, 6583, 6585,
    6587, 6589, 6591, 6593, 0, 0, 6595, 6597, 6599, 6601, 6603, 6605, 0, 0, 6607, 6609, 6611, 0, 0,
    0, 6613, 6615, 6617, 6619, 6622, 6624, 6626, 0, 6628, 6630, 6632, 6634, 6636, 6638, 6640, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1,
    1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
    6642, 6644, 6646, 6648, 6650, 6652, 6654, 6656, 6658, 6660, 6662, 6664, 6666, 6668, 6670, 6672,
    6674, 6676, 6678, 6680, 6682, 6684, 6686, 6688, 6690, 6692, 6694, 6696, 6698, 6700, 6702, 6704,
    6706, 6708, 6710, 6712, 6714, 6716, 6718, 6720, 6722, 6724, 6726, 6728, 6730, 6732, 6734, 6736,
    6738, 6740, 6742, 6744, 6746, 6748, 6750, 6752, 6754, 6756, 6758, 6760, 6762, 6764, 6766, 6768,
    6770, 6772, 6774, 6776, 6778, 6780, 6782, 6784, 6786, 6788, 6790, 6792, 6794, 6796, 6798, 6800,
    6802, 6804, 6806, 6808, 6810, 0, 6812, 6814, 6816, 6818, 6820, 6822, 6824, 6826, 6828, 6830,
    6832, 6834, 6836, 6838, 6840, 6842, 6844, 6846, 6848, 6850, 6852, 6854, 6856, 6858, 6860, 6862,
    6864, 6866, 6868, 6870, 6872, 6874, 6876, 6878, 6880, 6882, 6884, 6886, 6888, 6890, 6892, 6894,
    6896, 6898, 6900, 6902, 6904, 6906, 6908, 6910, 6912, 6914, 6916, 6918, 6920, 6922, 6924, 6926,
    6928, 6930, 6932, 6934, 6936, 6938, 6940, 6942, 6944, 6946, 6948, 6950, 6952, 0, 6954, 6956, 0,
    0, 6958, 0, 0, 6960, 6962, 0, 0, 6964, 6966, 6968, 6970, 0, 6972, 6974, 6976, 6978, 6980, 6982,
    6984, 6986, 6988, 6990, 6992, 6994, 0, 6996, 0, 6998, 7000, 7002, 7004, 7006, 7008, 7010, 0,
    7012, 7014, 7016, 7018, 7020, 7022, 7024, 7026, 7028, 7030, 7032, 7034, 7036, 7038, 7040, 7042,
    7044, 7046, 7048, 7050, 7052, 7054, 7056, 7058, 7060, 7062, 7064, 7066, 7068, 7070, 7072, 7074,
    7076, 7078, 7080, 7082, 7084, 7086, 7088, 7090, 7092, 7094, 7096, 7098, 7100, 7102, 7104, 7106,
    7108, 7110, 7112, 7114, 7116, 7118, 7120, 7122, 7124, 7126, 7128, 7130, 7132, 7134, 7136, 7138,
    7140, 0, 7142, 7144, 7146, 7148, 0, 0, 7150, 7152, 7154, 7156, 7158, 7160, 7162, 7164, 0, 7166,
    7168, 7170, 7172, 7174, 7176, 7178, 0, 7180, 7182, 7184, 7186, 7188, 7190, 7192, 7194, 7196,
    7198, 7200, 7202, 7204, 7206, 7208, 7210, 7212, 7214, 7216, 7218, 7220, 7222, 7224, 7226, 7228,
    7230, 7232, 7234, 0, 7236, 7238, 7240, 7242, 0, 7244, 7246, 7248, 7250, 7252, 0, 7254, 0, 0, 0,
    7256, 7258, 7260, 7262, 7264, 7266, 7268, 0, 7270, 7272, 7274, 7276, 7278, 7280, 7282, 7284,
    7286, 7288, 7290, 7292, 7294, 7296, 7298, 7300, 7302, 7304, 7306, 7308, 7310, 7312, 7314, 7316,
    7318, 7320, 7322, 7324, 7326, 7328, 7330, 7332, 7334, 7336, 7338, 7340, 7342, 7344, 7346, 7348,
    7350, 7352, 7354, 7356, 7358, 7360, 7362, 7364, 7366, 7368, 7370, 7372, 7374, 7376, 7378, 7380,
    7382, 7384, 7386, 7388, 7390, 7392, 7394, 7396, 7398, 7400, 7402, 7404, 7406, 7408, 7410, 7412,
    7414, 7416, 7418, 7420, 7422, 7424, 7426, 7428, 7430, 7432, 7434, 7436, 7438, 7440, 7442, 7444,
    7446, 7448, 7450, 7452, 7454, 7456, 7458, 7460, 7462, 7464, 7466, 7468, 7470, 7472, 7474, 7476,
    7478, 7480, 7482, 7484, 7486, 7488, 7490, 7492, 7494, 7496, 7498, 7500, 7502, 7504, 7506, 7508,
    7510, 7512, 7514, 7516, 7518, 7520, 7522, 7524, 7526, 7528, 7530, 7532, 7534, 7536, 7538, 7540,
    7542, 7544, 7546, 7548, 7550, 7552, 7554, 7556, 7558, 7560, 7562, 7564, 7566, 7568, 7570, 7572,
    7574, 7576, 7578, 7580, 7582, 7584, 7586, 7588, 7590, 7592, 7594, 7596, 7598, 7600, 7602, 7604,
    7606, 7608, 7610, 7612, 7614, 7616, 7618, 7620, 7622, 7624, 7626, 7628, 7630, 7632, 7634, 7636,
    7638, 7640, 7642, 7644, 7646, 7648, 7650, 7652, 7654, 7656, 7658, 7660, 7662, 7664, 7666, 7668,
    7670, 7672, 7674, 7676, 7678, 7680, 7682, 7684, 7686, 7688, 7690, 7692, 7694, 7696, 7698, 7700,
    7702, 7704, 7706, 7708, 7710, 7712, 7714, 7716, 7718, 7720, 7722, 7724, 7726, 7728, 7730, 7732,
    7734, 7736, 7738, 7740, 7742, 7744, 7746, 7748, 7750, 7752, 7754, 7756, 7758, 7760, 7762, 7764,
    7766, 7768, 7770, 7772, 7774, 7776, 7778, 7780, 7782, 7784, 7786, 7788, 7790, 7792, 7794, 7796,
    7798, 7800, 7802, 7804, 7806, 7808, 7810, 7812, 7814, 7816, 7818, 7820, 7822, 7824, 7826, 7828,
    7830, 7832, 7834, 7836, 7838, 7840, 7842, 7844, 7846, 7848, 7850, 7852, 7854, 7856, 7858, 7860,
    7862, 7864, 7866, 7868, 7870, 7872, 7874, 7876, 7878, 7880, 7882, 7884, 7886, 7888, 7890, 7892,
    7894, 7896, 7898, 7900, 7902, 7904, 7906, 7908, 7910, 7912, 7914, 7916, 7918, 7920, 7922, 7924,
    7926, 7928, 7930, 7932, 7934, 7936, 7938, 7940, 7942, 7944, 7946, 7948, 0, 0, 7950, 7952, 7954,
    7956, 7958, 7960, 7962, 7964, 7966, 7968, 7970, 7972, 7974, 7976, 7978, 7980, 7982, 7984, 7986,
    7988, 7990, 7992, 7994, 7996, 7998, 8000, 8002, 8004, 8006, 8008, 8010, 8012, 8014, 8016, 8018,
    8020, 8022, 8024, 8026, 8028, 8030, 8032, 8034, 8036, 8038, 8040, 8042, 8044, 8046, 8048, 8050,
    8052, 8054, 8056, 8058, 8060, 8062, 8064, 8066, 8068, 8070, 8072, 8074, 8076, 8078, 8080, 8082,
    8084, 8086, 8088, 8090, 8092, 8094, 8096, 8098, 8100, 8102, 8104, 8106, 8108, 8110, 8112, 8114,
    8116, 8118, 8120, 8122, 8124, 8126, 8128, 8130, 8132, 8134, 8136, 8138, 8140, 8142, 8144, 8146,
    8148, 8150, 8152, 8154, 8156, 8158, 8160, 8162, 8164, 8166, 8168, 8170, 8172, 8174, 8176, 8178,
    8180, 8182, 8184, 8186, 8188, 8190, 8192, 8194, 8196, 8198, 8200, 8202, 8204, 8206, 8208, 8210,
    8212, 8214, 8216, 8218, 8220, 8222, 8224, 8226, 8228, 8230, 8232, 8234, 8236, 8238, 8240, 8242,
    8244, 8246, 8248, 8250, 8252, 8254, 8256, 8258, 8260, 8262, 8264, 8266, 8268, 8270, 8272, 8274,
    8276, 8278, 8280, 8282, 8284, 8286, 8288, 8290, 8292, 8294, 8296, 8298, 8300, 8302, 8304, 8306,
    8308, 8310, 8312, 8314, 8316, 8318, 8320, 8322, 8324, 8326, 8328, 8330, 8332, 8334, 8336, 8338,
    8340, 8342, 8344, 8346, 8348, 8350, 8352, 8354, 8356, 8358, 8360, 8362, 8364, 8366, 8368, 8370,
    8372, 8374, 8376, 8378, 8380, 8382, 8384, 8386, 8388, 8390, 8392, 8394, 8396, 8398, 8400, 8402,
    8404, 8406, 8408, 8410, 8412, 8414, 8416, 8418, 8420, 8422, 8424, 8426, 8428, 8430, 8432, 8434,
    8436, 8438, 8440, 8442, 8444, 8446, 8448, 8450, 8452, 8454, 8456, 8458, 8460, 8462, 8464, 8466,
    8468, 8470, 8472, 8474, 8476, 8478, 8480, 8482, 8484, 8486, 8488, 8490, 8492, 8494, 8496, 8498,
    8500, 8502, 8504, 8506, 8508, 8510, 8512, 8514, 8516, 8518, 8520, 8522, 8524, 8526, 8528, 8530,
    8532, 0, 0, 8534, 8536, 8538, 8540, 8542, 8544, 8546, 8548, 8550, 8552, 8554, 8556, 8558, 8560,
    8562, 8564, 8566, 8568, 8570, 8572, 8574, 8576, 8578, 8580, 8582, 8584, 8586, 8588, 8590, 8592,
    8594, 8596, 8598, 8600, 8602, 8604, 8606, 8608, 8610, 8612, 8614, 8616, 8618, 8620, 8622, 8624,
    8626, 8628, 8630, 8632, 8634, 8636, 8638, 8640, 0, 8642, 8644, 8646, 8648, 8650, 8652, 8654,
    8656, 8658, 8660, 8662, 8664, 8666, 8668, 8670, 8672, 8674, 8676, 8678, 8680, 8682, 8684, 8686,
    8688, 8690, 8692, 8694, 0, 8696, 8698, 0, 8700, 0, 0, 8702, 0, 8704, 8706, 8708, 8710, 8712,
    8714, 8716, 8718, 8720, 8722, 0, 8724, 8726, 8728, 8730, 0, 8732, 0, 8734, 0, 0, 0, 0, 0, 0,
    8736, 0, 0, 0, 0, 8738, 0, 8740, 0, 8742, 0, 8744, 8746, 8748, 0, 8750, 8752, 0, 8754, 0, 0,
    8756, 0, 8758, 0, 8760, 0, 8762, 0, 8764, 0, 8766, 8768, 0, 8770, 0, 0, 8772, 8774, 8776, 8778,
    0, 8780, 8782, 8784, 8786, 8788, 8790, 8792, 0, 8794, 8796, 8798, 8800, 0, 8802, 8804, 8806,
    8808, 0, 8810, 0, 8812, 8814, 8816, 8818, 8820, 8822, 8824, 8826, 8828, 8830, 0, 8832, 8834,
    8836, 8838, 8840, 8842, 8844, 8846, 8848, 8850, 8852, 8854, 8856, 8858, 8860, 8862, 8864, 0, 0,
    0, 0, 0, 8866, 8868, 8870, 0, 8872, 8874, 8876, 8878, 8880, 0, 8882, 8884, 8886, 8888, 8890,
    8892, 8894, 8896, 8898, 8900, 8902, 8904, 8906, 8908, 8910, 8912, 8914, 0, 0, 0, 0, 8916, 8919,
    8922, 8925, 8928, 8931, 8934, 8937, 8940, 8943, 8946, 0, 0, 0, 0, 0, 8949, 8953, 8957, 8961,
    8965, 8969, 8973, 8977, 8981, 8985, 8989, 8993, 8997, 9001, 9005, 9009, 9013, 9017, 9021, 9025,
    9029, 9033, 9037, 9041, 9045, 9049, 9053, 9057, 9059, 9061, 9064, 0, 9067, 9069, 9071, 9073,
    9075, 9077, 9079, 9081, 9083, 9085, 9087, 9089, 9091, 9093, 9095, 9097, 9099, 9101, 9103, 9105,
    9107, 9109, 9111, 9113, 9115, 9117, 9119, 9122, 9125, 9128, 9131, 9135, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9138, 9141, 9144, 0, 0, 0, 9147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9150, 9153,
    9156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9158, 9160, 9162, 9164, 9167, 9169, 9171, 9173,
    9175, 9177, 9179, 9181, 9183, 9185, 9187, 9189, 9191, 9193, 9195, 9197, 9199, 9201, 9203, 9205,
    9207, 9209, 9211, 9213, 9215, 9217, 9219, 9221, 9223, 9225, 9227, 9229, 9231, 9233, 9235, 9237,
    9239, 9241, 9243, 9245, 0, 0, 0, 0, 9247, 9251, 9255, 9259, 9263, 9267, 9271, 9275, 9279, 0, 0,
    0, 0, 0, 0, 0, 9283, 9285, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9287, 9289, 9291, 9293,
    9295, 9297, 9299, 9301, 9303, 9305, 0, 0, 0, 0, 0, 0,
];

pub fn decompose_compat_index(x: usize) -> usize {
    const SHIFT1: usize = 6;
    const SHIFT2: usize = 4;
    if x >= 1114112 {
        return 0;
    }
    let mut index = (DECOMPOSE_COMPAT_INDEX0[x >> (SHIFT1 + SHIFT2)] as usize) << SHIFT1;
    let mut offset = (x >> SHIFT2) & ((1 << SHIFT1) - 1);
    index = (DECOMPOSE_COMPAT_INDEX1[index + offset] as usize) << SHIFT2;
    offset = x & ((1 << SHIFT2) - 1);
    DECOMPOSE_COMPAT_INDEX2[index + offset] as usize
}
#[rustfmt::skip]
pub const DECOMPOSE: [u32; 5469] = [
    0, 255, 2, 65, 768, 2, 65, 769, 2, 65, 770, 2, 65, 771, 2, 65, 776, 2, 65, 778, 2, 67, 807, 2,
    69, 768, 2, 69, 769, 2, 69, 770, 2, 69, 776, 2, 73, 768, 2, 73, 769, 2, 73, 770, 2, 73, 776, 2,
    78, 771, 2, 79, 768, 2, 79, 769, 2, 79, 770, 2, 79, 771, 2, 79, 776, 2, 85, 768, 2, 85, 769, 2,
    85, 770, 2, 85, 776, 2, 89, 769, 2, 97, 768, 2, 97, 769, 2, 97, 770, 2, 97, 771, 2, 97, 776, 2,
    97, 778, 2, 99, 807, 2, 101, 768, 2, 101, 769, 2, 101, 770, 2, 101, 776, 2, 105, 768, 2, 105,
    769, 2, 105, 770, 2, 105, 776, 2, 110, 771, 2, 111, 768, 2, 111, 769, 2, 111, 770, 2, 111, 771,
    2, 111, 776, 2, 117, 768, 2, 117, 769, 2, 117, 770, 2, 117, 776, 2, 121, 769, 2, 121, 776, 2,
    65, 772, 2, 97, 772, 2, 65, 774, 2, 97, 774, 2, 65, 808, 2, 97, 808, 2, 67, 769, 2, 99, 769, 2,
    67, 770, 2, 99, 770, 2, 67, 775, 2, 99, 775, 2, 67, 780, 2, 99, 780, 2, 68, 780, 2, 100, 780,
    2, 69, 772, 2, 101, 772, 2, 69, 774, 2, 101, 774, 2, 69, 775, 2, 101, 775, 2, 69, 808, 2, 101,
    808, 2, 69, 780, 2, 101, 780, 2, 71, 770, 2, 103, 770, 2, 71, 774, 2, 103, 774, 2, 71, 775, 2,
    103, 775, 2, 71, 807, 2, 103, 807, 2, 72, 770, 2, 104, 770, 2, 73, 771, 2, 105, 771, 2, 73,
    772, 2, 105, 772, 2, 73, 774, 2, 105, 774, 2, 73, 808, 2, 105, 808, 2, 73, 775, 2, 74, 770, 2,
    106, 770, 2, 75, 807, 2, 107, 807, 2, 76, 769, 2, 108, 769, 2, 76, 807, 2, 108, 807, 2, 76,
    780, 2, 108, 780, 2, 78, 769, 2, 110, 769, 2, 78, 807, 2, 110, 807, 2, 78, 780, 2, 110, 780, 2,
    79, 772, 2, 111, 772, 2, 79, 774, 2, 111, 774, 2, 79, 779, 2, 111, 779, 2, 82, 769, 2, 114,
    769, 2, 82, 807, 2, 114, 807, 2, 82, 780, 2, 114, 780, 2, 83, 769, 2, 115, 769, 2, 83, 770, 2,
    115, 770, 2, 83, 807, 2, 115, 807, 2, 83, 780, 2, 115, 780, 2, 84, 807, 2, 116, 807, 2, 84,
    780, 2, 116, 780, 2, 85, 771, 2, 117, 771, 2, 85, 772, 2, 117, 772, 2, 85, 774, 2, 117, 774, 2,
    85, 778, 2, 117, 778, 2, 85, 779, 2, 117, 779, 2, 85, 808, 2, 117, 808, 2, 87, 770, 2, 119,
    770, 2, 89, 770, 2, 121, 770, 2, 89, 776, 2, 90, 769, 2, 122, 769, 2, 90, 775, 2, 122, 775, 2,
    90, 780, 2, 122, 780, 2, 79, 795, 2, 111, 795, 2, 85, 795, 2, 117, 795, 2, 65, 780, 2, 97, 780,
    2, 73, 780, 2, 105, 780, 2, 79, 780, 2, 111, 780, 2, 85, 780, 2, 117, 780, 3, 85, 776, 772, 3,
    117, 776, 772, 3, 85, 776, 769, 3, 117, 776, 769, 3, 85, 776, 780, 3, 117, 776, 780, 3, 85,
    776, 768, 3, 117, 776, 768, 3, 65, 776, 772, 3, 97, 776, 772, 3, 65, 775, 772, 3, 97, 775, 772,
    2, 198, 772, 2, 230, 772, 2, 71, 780, 2, 103, 780, 2, 75, 780, 2, 107, 780, 2, 79, 808, 2, 111,
    808, 3, 79, 808, 772, 3, 111, 808, 772, 2, 439, 780, 2, 658, 780, 2, 106, 780, 2, 71, 769, 2,
    103, 769, 2, 78, 768, 2, 110, 768, 3, 65, 778, 769, 3, 97, 778, 769, 2, 198, 769, 2, 230, 769,
    2, 216, 769, 2, 248, 769, 2, 65, 783, 2, 97, 783, 2, 65, 785, 2, 97, 785, 2, 69, 783, 2, 101,
    783, 2, 69, 785, 2, 101, 785, 2, 73, 783, 2, 105, 783, 2, 73, 785, 2, 105, 785, 2, 79, 783, 2,
    111, 783, 2, 79, 785, 2, 111, 785, 2, 82, 783, 2, 114, 783, 2, 82, 785, 2, 114, 785, 2, 85,
    783, 2, 117, 783, 2, 85, 785, 2, 117, 785, 2, 83, 806, 2, 115, 806, 2, 84, 806, 2, 116, 806, 2,
    72, 780, 2, 104, 780, 2, 65, 775, 2, 97, 775, 2, 69, 807, 2, 101, 807, 3, 79, 776, 772, 3, 111,
    776, 772, 3, 79, 771, 772, 3, 111, 771, 772, 2, 79, 775, 2, 111, 775, 3, 79, 775, 772, 3, 111,
    775, 772, 2, 89, 772, 2, 121, 772, 1, 768, 1, 769, 1, 787, 2, 776, 769, 1, 697, 1, 59, 2, 168,
    769, 2, 913, 769, 1, 183, 2, 917, 769, 2, 919, 769, 2, 921, 769, 2, 927, 769, 2, 933, 769, 2,
    937, 769, 3, 953, 776, 769, 2, 921, 776, 2, 933, 776, 2, 945, 769, 2, 949, 769, 2, 951, 769, 2,
    953, 769, 3, 965, 776, 769, 2, 953, 776, 2, 965, 776, 2, 959, 769, 2, 965, 769, 2, 969, 769, 2,
    978, 769, 2, 978, 776, 2, 1045, 768, 2, 1045, 776, 2, 1043, 769, 2, 1030, 776, 2, 1050, 769, 2,
    1048, 768, 2, 1059, 774, 2, 1048, 774, 2, 1080, 774, 2, 1077, 768, 2, 1077, 776, 2, 1075, 769,
    2, 1110, 776, 2, 1082, 769, 2, 1080, 768, 2, 1091, 774, 2, 1140, 783, 2, 1141, 783, 2, 1046,
    774, 2, 1078, 774, 2, 1040, 774, 2, 1072, 774, 2, 1040, 776, 2, 1072, 776, 2, 1045, 774, 2,
    1077, 774, 2, 1240, 776, 2, 1241, 776, 2, 1046, 776, 2, 1078, 776, 2, 1047, 776, 2, 1079, 776,
    2, 1048, 772, 2, 1080, 772, 2, 1048, 776, 2, 1080, 776, 2, 1054, 776, 2, 1086, 776, 2, 1256,
    776, 2, 1257, 776, 2, 1069, 776, 2, 1101, 776, 2, 1059, 772, 2, 1091, 772, 2, 1059, 776, 2,
    1091, 776, 2, 1059, 779, 2, 1091, 779, 2, 1063, 776, 2, 1095, 776, 2, 1067, 776, 2, 1099, 776,
    2, 1575, 1619, 2, 1575, 1620, 2, 1608, 1620, 2, 1575, 1621, 2, 1610, 1620, 2, 1749, 1620, 2,
    1729, 1620, 2, 1746, 1620, 2, 2344, 2364, 2, 2352, 2364, 2, 2355, 2364, 2, 2325, 2364, 2, 2326,
    2364, 2, 2327, 2364, 2, 2332, 2364, 2, 2337, 2364, 2, 2338, 2364, 2, 2347, 2364, 2, 2351, 2364,
    2, 2503, 2494, 2, 2503, 2519, 2, 2465, 2492, 2, 2466, 2492, 2, 2479, 2492, 2, 2610, 2620, 2,
    2616, 2620, 2, 2582, 2620, 2, 2583, 2620, 2, 2588, 2620, 2, 2603, 2620, 2, 2887, 2902, 2, 2887,
    2878, 2, 2887, 2903, 2, 2849, 2876, 2, 2850, 2876, 2, 2962, 3031, 2, 3014, 3006, 2, 3015, 3006,
    2, 3014, 3031, 2, 3142, 3158, 2, 3263, 3285, 2, 3270, 3285, 2, 3270, 3286, 2, 3270, 3266, 3,
    3270, 3266, 3285, 2, 3398, 3390, 2, 3399, 3390, 2, 3398, 3415, 2, 3545, 3530, 2, 3545, 3535, 3,
    3545, 3535, 3530, 2, 3545, 3551, 2, 3906, 4023, 2, 3916, 4023, 2, 3921, 4023, 2, 3926, 4023, 2,
    3931, 4023, 2, 3904, 4021, 2, 3953, 3954, 2, 3953, 3956, 2, 4018, 3968, 2, 4019, 3968, 2, 3953,
    3968, 2, 3986, 4023, 2, 3996, 4023, 2, 4001, 4023, 2, 4006, 4023, 2, 4011, 4023, 2, 3984, 4021,
    2, 4133, 4142, 2, 6917, 6965, 2, 6919, 6965, 2, 6921, 6965, 2, 6923, 6965, 2, 6925, 6965, 2,
    6929, 6965, 2, 6970, 6965, 2, 6972, 6965, 2, 6974, 6965, 2, 6975, 6965, 2, 6978, 6965, 2, 65,
    805, 2, 97, 805, 2, 66, 775, 2, 98, 775, 2, 66, 803, 2, 98, 803, 2, 66, 817, 2, 98, 817, 3, 67,
    807, 769, 3, 99, 807, 769, 2, 68, 775, 2, 100, 775, 2, 68, 803, 2, 100, 803, 2, 68, 817, 2,
    100, 817, 2, 68, 807, 2, 100, 807, 2, 68, 813, 2, 100, 813, 3, 69, 772, 768, 3, 101, 772, 768,
    3, 69, 772, 769, 3, 101, 772, 769, 2, 69, 813, 2, 101, 813, 2, 69, 816, 2, 101, 816, 3, 69,
    807, 774, 3, 101, 807, 774, 2, 70, 775, 2, 102, 775, 2, 71, 772, 2, 103, 772, 2, 72, 775, 2,
    104, 775, 2, 72, 803, 2, 104, 803, 2, 72, 776, 2, 104, 776, 2, 72, 807, 2, 104, 807, 2, 72,
    814, 2, 104, 814, 2, 73, 816, 2, 105, 816, 3, 73, 776, 769, 3, 105, 776, 769, 2, 75, 769, 2,
    107, 769, 2, 75, 803, 2, 107, 803, 2, 75, 817, 2, 107, 817, 2, 76, 803, 2, 108, 803, 3, 76,
    803, 772, 3, 108, 803, 772, 2, 76, 817, 2, 108, 817, 2, 76, 813, 2, 108, 813, 2, 77, 769, 2,
    109, 769, 2, 77, 775, 2, 109, 775, 2, 77, 803, 2, 109, 803, 2, 78, 775, 2, 110, 775, 2, 78,
    803, 2, 110, 803, 2, 78, 817, 2, 110, 817, 2, 78, 813, 2, 110, 813, 3, 79, 771, 769, 3, 111,
    771, 769, 3, 79, 771, 776, 3, 111, 771, 776, 3, 79, 772, 768, 3, 111, 772, 768, 3, 79, 772,
    769, 3, 111, 772, 769, 2, 80, 769, 2, 112, 769, 2, 80, 775, 2, 112, 775, 2, 82, 775, 2, 114,
    775, 2, 82, 803, 2, 114, 803, 3, 82, 803, 772, 3, 114, 803, 772, 2, 82, 817, 2, 114, 817, 2,
    83, 775, 2, 115, 775, 2, 83, 803, 2, 115, 803, 3, 83, 769, 775, 3, 115, 769, 775, 3, 83, 780,
    775, 3, 115, 780, 775, 3, 83, 803, 775, 3, 115, 803, 775, 2, 84, 775, 2, 116, 775, 2, 84, 803,
    2, 116, 803, 2, 84, 817, 2, 116, 817, 2, 84, 813, 2, 116, 813, 2, 85, 804, 2, 117, 804, 2, 85,
    816, 2, 117, 816, 2, 85, 813, 2, 117, 813, 3, 85, 771, 769, 3, 117, 771, 769, 3, 85, 772, 776,
    3, 117, 772, 776, 2, 86, 771, 2, 118, 771, 2, 86, 803, 2, 118, 803, 2, 87, 768, 2, 119, 768, 2,
    87, 769, 2, 119, 769, 2, 87, 776, 2, 119, 776, 2, 87, 775, 2, 119, 775, 2, 87, 803, 2, 119,
    803, 2, 88, 775, 2, 120, 775, 2, 88, 776, 2, 120, 776, 2, 89, 775, 2, 121, 775, 2, 90, 770, 2,
    122, 770, 2, 90, 803, 2, 122, 803, 2, 90, 817, 2, 122, 817, 2, 104, 817, 2, 116, 776, 2, 119,
    778, 2, 121, 778, 2, 383, 775, 2, 65, 803, 2, 97, 803, 2, 65, 777, 2, 97, 777, 3, 65, 770, 769,
    3, 97, 770, 769, 3, 65, 770, 768, 3, 97, 770, 768, 3, 65, 770, 777, 3, 97, 770, 777, 3, 65,
    770, 771, 3, 97, 770, 771, 3, 65, 803, 770, 3, 97, 803, 770, 3, 65, 774, 769, 3, 97, 774, 769,
    3, 65, 774, 768, 3, 97, 774, 768, 3, 65, 774, 777, 3, 97, 774, 777, 3, 65, 774, 771, 3, 97,
    774, 771, 3, 65, 803, 774, 3, 97, 803, 774, 2, 69, 803, 2, 101, 803, 2, 69, 777, 2, 101, 777,
    2, 69, 771, 2, 101, 771, 3, 69, 770, 769, 3, 101, 770, 769, 3, 69, 770, 768, 3, 101, 770, 768,
    3, 69, 770, 777, 3, 101, 770, 777, 3, 69, 770, 771, 3, 101, 770, 771, 3, 69, 803, 770, 3, 101,
    803, 770, 2, 73, 777, 2, 105, 777, 2, 73, 803, 2, 105, 803, 2, 79, 803, 2, 111, 803, 2, 79,
    777, 2, 111, 777, 3, 79, 770, 769, 3, 111, 770, 769, 3, 79, 770, 768, 3, 111, 770, 768, 3, 79,
    770, 777, 3, 111, 770, 777, 3, 79, 770, 771, 3, 111, 770, 771, 3, 79, 803, 770, 3, 111, 803,
    770, 3, 79, 795, 769, 3, 111, 795, 769, 3, 79, 795, 768, 3, 111, 795, 768, 3, 79, 795, 777, 3,
    111, 795, 777, 3, 79, 795, 771, 3, 111, 795, 771, 3, 79, 795, 803, 3, 111, 795, 803, 2, 85,
    803, 2, 117, 803, 2, 85, 777, 2, 117, 777, 3, 85, 795, 769, 3, 117, 795, 769, 3, 85, 795, 768,
    3, 117, 795, 768, 3, 85, 795, 777, 3, 117, 795, 777, 3, 85, 795, 771, 3, 117, 795, 771, 3, 85,
    795, 803, 3, 117, 795, 803, 2, 89, 768, 2, 121, 768, 2, 89, 803, 2, 121, 803, 2, 89, 777, 2,
    121, 777, 2, 89, 771, 2, 121, 771, 2, 945, 787, 2, 945, 788, 3, 945, 787, 768, 3, 945, 788,
    768, 3, 945, 787, 769, 3, 945, 788, 769, 3, 945, 787, 834, 3, 945, 788, 834, 2, 913, 787, 2,
    913, 788, 3, 913, 787, 768, 3, 913, 788, 768, 3, 913, 787, 769, 3, 913, 788, 769, 3, 913, 787,
    834, 3, 913, 788, 834, 2, 949, 787, 2, 949, 788, 3, 949, 787, 768, 3, 949, 788, 768, 3, 949,
    787, 769, 3, 949, 788, 769, 2, 917, 787, 2, 917, 788, 3, 917, 787, 768, 3, 917, 788, 768, 3,
    917, 787, 769, 3, 917, 788, 769, 2, 951, 787, 2, 951, 788, 3, 951, 787, 768, 3, 951, 788, 768,
    3, 951, 787, 769, 3, 951, 788, 769, 3, 951, 787, 834, 3, 951, 788, 834, 2, 919, 787, 2, 919,
    788, 3, 919, 787, 768, 3, 919, 788, 768, 3, 919, 787, 769, 3, 919, 788, 769, 3, 919, 787, 834,
    3, 919, 788, 834, 2, 953, 787, 2, 953, 788, 3, 953, 787, 768, 3, 953, 788, 768, 3, 953, 787,
    769, 3, 953, 788, 769, 3, 953, 787, 834, 3, 953, 788, 834, 2, 921, 787, 2, 921, 788, 3, 921,
    787, 768, 3, 921, 788, 768, 3, 921, 787, 769, 3, 921, 788, 769, 3, 921, 787, 834, 3, 921, 788,
    834, 2, 959, 787, 2, 959, 788, 3, 959, 787, 768, 3, 959, 788, 768, 3, 959, 787, 769, 3, 959,
    788, 769, 2, 927, 787, 2, 927, 788, 3, 927, 787, 768, 3, 927, 788, 768, 3, 927, 787, 769, 3,
    927, 788, 769, 2, 965, 787, 2, 965, 788, 3, 965, 787, 768, 3, 965, 788, 768, 3, 965, 787, 769,
    3, 965, 788, 769, 3, 965, 787, 834, 3, 965, 788, 834, 2, 933, 788, 3, 933, 788, 768, 3, 933,
    788, 769, 3, 933, 788, 834, 2, 969, 787, 2, 969, 788, 3, 969, 787, 768, 3, 969, 788, 768, 3,
    969, 787, 769, 3, 969, 788, 769, 3, 969, 787, 834, 3, 969, 788, 834, 2, 937, 787, 2, 937, 788,
    3, 937, 787, 768, 3, 937, 788, 768, 3, 937, 787, 769, 3, 937, 788, 769, 3, 937, 787, 834, 3,
    937, 788, 834, 2, 945, 768, 2, 945, 769, 2, 949, 768, 2, 949, 769, 2, 951, 768, 2, 951, 769, 2,
    953, 768, 2, 953, 769, 2, 959, 768, 2, 959, 769, 2, 965, 768, 2, 965, 769, 2, 969, 768, 2, 969,
    769, 3, 945, 787, 837, 3, 945, 788, 837, 4, 945, 787, 768, 837, 4, 945, 788, 768, 837, 4, 945,
    787, 769, 837, 4, 945, 788, 769, 837, 4, 945, 787, 834, 837, 4, 945, 788, 834, 837, 3, 913,
    787, 837, 3, 913, 788, 837, 4, 913, 787, 768, 837, 4, 913, 788, 768, 837, 4, 913, 787, 769,
    837, 4, 913, 788, 769, 837, 4, 913, 787, 834, 837, 4, 913, 788, 834, 837, 3, 951, 787, 837, 3,
    951, 788, 837, 4, 951, 787, 768, 837, 4, 951, 788, 768, 837, 4, 951, 787, 769, 837, 4, 951,
    788, 769, 837, 4, 951, 787, 834, 837, 4, 951, 788, 834, 837, 3, 919, 787, 837, 3, 919, 788,
    837, 4, 919, 787, 768, 837, 4, 919, 788, 768, 837, 4, 919, 787, 769, 837, 4, 919, 788, 769,
    837, 4, 919, 787, 834, 837, 4, 919, 788, 834, 837, 3, 969, 787, 837, 3, 969, 788, 837, 4, 969,
    787, 768, 837, 4, 969, 788, 768, 837, 4, 969, 787, 769, 837, 4, 969, 788, 769, 837, 4, 969,
    787, 834, 837, 4, 969, 788, 834, 837, 3, 937, 787, 837, 3, 937, 788, 837, 4, 937, 787, 768,
    837, 4, 937, 788, 768, 837, 4, 937, 787, 769, 837, 4, 937, 788, 769, 837, 4, 937, 787, 834,
    837, 4, 937, 788, 834, 837, 2, 945, 774, 2, 945, 772, 3, 945, 768, 837, 2, 945, 837, 3, 945,
    769, 837, 2, 945, 834, 3, 945, 834, 837, 2, 913, 774, 2, 913, 772, 2, 913, 768, 2, 913, 769, 2,
    913, 837, 1, 953, 2, 168, 834, 3, 951, 768, 837, 2, 951, 837, 3, 951, 769, 837, 2, 951, 834, 3,
    951, 834, 837, 2, 917, 768, 2, 917, 769, 2, 919, 768, 2, 919, 769, 2, 919, 837, 2, 8127, 768,
    2, 8127, 769, 2, 8127, 834, 2, 953, 774, 2, 953, 772, 3, 953, 776, 768, 3, 953, 776, 769, 2,
    953, 834, 3, 953, 776, 834, 2, 921, 774, 2, 921, 772, 2, 921, 768, 2, 921, 769, 2, 8190, 768,
    2, 8190, 769, 2, 8190, 834, 2, 965, 774, 2, 965, 772, 3, 965, 776, 768, 3, 965, 776, 769, 2,
    961, 787, 2, 961, 788, 2, 965, 834, 3, 965, 776, 834, 2, 933, 774, 2, 933, 772, 2, 933, 768, 2,
    933, 769, 2, 929, 788, 2, 168, 768, 2, 168, 769, 1, 96, 3, 969, 768, 837, 2, 969, 837, 3, 969,
    769, 837, 2, 969, 834, 3, 969, 834, 837, 2, 927, 768, 2, 927, 769, 2, 937, 768, 2, 937, 769, 2,
    937, 837, 1, 180, 1, 8194, 1, 8195, 1, 937, 1, 75, 2, 65, 778, 2, 8592, 824, 2, 8594, 824, 2,
    8596, 824, 2, 8656, 824, 2, 8660, 824, 2, 8658, 824, 2, 8707, 824, 2, 8712, 824, 2, 8715, 824,
    2, 8739, 824, 2, 8741, 824, 2, 8764, 824, 2, 8771, 824, 2, 8773, 824, 2, 8776, 824, 2, 61, 824,
    2, 8801, 824, 2, 8781, 824, 2, 60, 824, 2, 62, 824, 2, 8804, 824, 2, 8805, 824, 2, 8818, 824,
    2, 8819, 824, 2, 8822, 824, 2, 8823, 824, 2, 8826, 824, 2, 8827, 824, 2, 8834, 824, 2, 8835,
    824, 2, 8838, 824, 2, 8839, 824, 2, 8866, 824, 2, 8872, 824, 2, 8873, 824, 2, 8875, 824, 2,
    8828, 824, 2, 8829, 824, 2, 8849, 824, 2, 8850, 824, 2, 8882, 824, 2, 8883, 824, 2, 8884, 824,
    2, 8885, 824, 1, 12296, 1, 12297, 2, 10973, 824, 2, 12363, 12441, 2, 12365, 12441, 2, 12367,
    12441, 2, 12369, 12441, 2, 12371, 12441, 2, 12373, 12441, 2, 12375, 12441, 2, 12377, 12441, 2,
    12379, 12441, 2, 12381, 12441, 2, 12383, 12441, 2, 12385, 12441, 2, 12388, 12441, 2, 12390,
    12441, 2, 12392, 12441, 2, 12399, 12441, 2, 12399, 12442, 2, 12402, 12441, 2, 12402, 12442, 2,
    12405, 12441, 2, 12405, 12442, 2, 12408, 12441, 2, 12408, 12442, 2, 12411, 12441, 2, 12411,
    12442, 2, 12358, 12441, 2, 12445, 12441, 2, 12459, 12441, 2, 12461, 12441, 2, 12463, 12441, 2,
    12465, 12441, 2, 12467, 12441, 2, 12469, 12441, 2, 12471, 12441, 2, 12473, 12441, 2, 12475,
    12441, 2, 12477, 12441, 2, 12479, 12441, 2, 12481, 12441, 2, 12484, 12441, 2, 12486, 12441, 2,
    12488, 12441, 2, 12495, 12441, 2, 12495, 12442, 2, 12498, 12441, 2, 12498, 12442, 2, 12501,
    12441, 2, 12501, 12442, 2, 12504, 12441, 2, 12504, 12442, 2, 12507, 12441, 2, 12507, 12442, 2,
    12454, 12441, 2, 12527, 12441, 2, 12528, 12441, 2, 12529, 12441, 2, 12530, 12441, 2, 12541,
    12441, 1, 35912, 1, 26356, 1, 36554, 1, 36040, 1, 28369, 1, 20018, 1, 21477, 1, 40860, 1,
    40860, 1, 22865, 1, 37329, 1, 21895, 1, 22856, 1, 25078, 1, 30313, 1, 32645, 1, 34367, 1,
    34746, 1, 35064, 1, 37007, 1, 27138, 1, 27931, 1, 28889, 1, 29662, 1, 33853, 1, 37226, 1,
    39409, 1, 20098, 1, 21365, 1, 27396, 1, 29211, 1, 34349, 1, 40478, 1, 23888, 1, 28651, 1,
    34253, 1, 35172, 1, 25289, 1, 33240, 1, 34847, 1, 24266, 1, 26391, 1, 28010, 1, 29436, 1,
    37070, 1, 20358, 1, 20919, 1, 21214, 1, 25796, 1, 27347, 1, 29200, 1, 30439, 1, 32769, 1,
    34310, 1, 34396, 1, 36335, 1, 38706, 1, 39791, 1, 40442, 1, 30860, 1, 31103, 1, 32160, 1,
    33737, 1, 37636, 1, 40575, 1, 35542, 1, 22751, 1, 24324, 1, 31840, 1, 32894, 1, 29282, 1,
    30922, 1, 36034, 1, 38647, 1, 22744, 1, 23650, 1, 27155, 1, 28122, 1, 28431, 1, 32047, 1,
    32311, 1, 38475, 1, 21202, 1, 32907, 1, 20956, 1, 20940, 1, 31260, 1, 32190, 1, 33777, 1,
    38517, 1, 35712, 1, 25295, 1, 27138, 1, 35582, 1, 20025, 1, 23527, 1, 24594, 1, 29575, 1,
    30064, 1, 21271, 1, 30971, 1, 20415, 1, 24489, 1, 19981, 1, 27852, 1, 25976, 1, 32034, 1,
    21443, 1, 22622, 1, 30465, 1, 33865, 1, 35498, 1, 27578, 1, 36784, 1, 27784, 1, 25342, 1,
    33509, 1, 25504, 1, 30053, 1, 20142, 1, 20841, 1, 20937, 1, 26753, 1, 31975, 1, 33391, 1,
    35538, 1, 37327, 1, 21237, 1, 21570, 1, 22899, 1, 24300, 1, 26053, 1, 28670, 1, 31018, 1,
    38317, 1, 39530, 1, 40599, 1, 40654, 1, 21147, 1, 26310, 1, 27511, 1, 36706, 1, 24180, 1,
    24976, 1, 25088, 1, 25754, 1, 28451, 1, 29001, 1, 29833, 1, 31178, 1, 32244, 1, 32879, 1,
    36646, 1, 34030, 1, 36899, 1, 37706, 1, 21015, 1, 21155, 1, 21693, 1, 28872, 1, 35010, 1,
    35498, 1, 24265, 1, 24565, 1, 25467, 1, 27566, 1, 31806, 1, 29557, 1, 20196, 1, 22265, 1,
    23527, 1, 23994, 1, 24604, 1, 29618, 1, 29801, 1, 32666, 1, 32838, 1, 37428, 1, 38646, 1,
    38728, 1, 38936, 1, 20363, 1, 31150, 1, 37300, 1, 38584, 1, 24801, 1, 20102, 1, 20698, 1,
    23534, 1, 23615, 1, 26009, 1, 27138, 1, 29134, 1, 30274, 1, 34044, 1, 36988, 1, 40845, 1,
    26248, 1, 38446, 1, 21129, 1, 26491, 1, 26611, 1, 27969, 1, 28316, 1, 29705, 1, 30041, 1,
    30827, 1, 32016, 1, 39006, 1, 20845, 1, 25134, 1, 38520, 1, 20523, 1, 23833, 1, 28138, 1,
    36650, 1, 24459, 1, 24900, 1, 26647, 1, 29575, 1, 38534, 1, 21033, 1, 21519, 1, 23653, 1,
    26131, 1, 26446, 1, 26792, 1, 27877, 1, 29702, 1, 30178, 1, 32633, 1, 35023, 1, 35041, 1,
    37324, 1, 38626, 1, 21311, 1, 28346, 1, 21533, 1, 29136, 1, 29848, 1, 34298, 1, 38563, 1,
    40023, 1, 40607, 1, 26519, 1, 28107, 1, 33256, 1, 31435, 1, 31520, 1, 31890, 1, 29376, 1,
    28825, 1, 35672, 1, 20160, 1, 33590, 1, 21050, 1, 20999, 1, 24230, 1, 25299, 1, 31958, 1,
    23429, 1, 27934, 1, 26292, 1, 36667, 1, 34892, 1, 38477, 1, 35211, 1, 24275, 1, 20800, 1,
    21952, 1, 22618, 1, 26228, 1, 20958, 1, 29482, 1, 30410, 1, 31036, 1, 31070, 1, 31077, 1,
    31119, 1, 38742, 1, 31934, 1, 32701, 1, 34322, 1, 35576, 1, 36920, 1, 37117, 1, 39151, 1,
    39164, 1, 39208, 1, 40372, 1, 37086, 1, 38583, 1, 20398, 1, 20711, 1, 20813, 1, 21193, 1,
    21220, 1, 21329, 1, 21917, 1, 22022, 1, 22120, 1, 22592, 1, 22696, 1, 23652, 1, 23662, 1,
    24724, 1, 24936, 1, 24974, 1, 25074, 1, 25935, 1, 26082, 1, 26257, 1, 26757, 1, 28023, 1,
    28186, 1, 28450, 1, 29038, 1, 29227, 1, 29730, 1, 30865, 1, 31038, 1, 31049, 1, 31048, 1,
    31056, 1, 31062, 1, 31069, 1, 31117, 1, 31118, 1, 31296, 1, 31361, 1, 31680, 1, 32244, 1,
    32265, 1, 32321, 1, 32626, 1, 32773, 1, 33261, 1, 33401, 1, 33401, 1, 33879, 1, 35088, 1,
    35222, 1, 35585, 1, 35641, 1, 36051, 1, 36104, 1, 36790, 1, 36920, 1, 38627, 1, 38911, 1,
    38971, 1, 24693, 1, 148206, 1, 33304, 1, 20006, 1, 20917, 1, 20840, 1, 20352, 1, 20805, 1,
    20864, 1, 21191, 1, 21242, 1, 21917, 1, 21845, 1, 21913, 1, 21986, 1, 22618, 1, 22707, 1,
    22852, 1, 22868, 1, 23138, 1, 23336, 1, 24274, 1, 24281, 1, 24425, 1, 24493, 1, 24792, 1,
    24910, 1, 24840, 1, 24974, 1, 24928, 1, 25074, 1, 25140, 1, 25540, 1, 25628, 1, 25682, 1,
    25942, 1, 26228, 1, 26391, 1, 26395, 1, 26454, 1, 27513, 1, 27578, 1, 27969, 1, 28379, 1,
    28363, 1, 28450, 1, 28702, 1, 29038, 1, 30631, 1, 29237, 1, 29359, 1, 29482, 1, 29809, 1,
    29958, 1, 30011, 1, 30237, 1, 30239, 1, 30410, 1, 30427, 1, 30452, 1, 30538, 1, 30528, 1,
    30924, 1, 31409, 1, 31680, 1, 31867, 1, 32091, 1, 32244, 1, 32574, 1, 32773, 1, 33618, 1,
    33775, 1, 34681, 1, 35137, 1, 35206, 1, 35222, 1, 35519, 1, 35576, 1, 35531, 1, 35585, 1,
    35582, 1, 35565, 1, 35641, 1, 35722, 1, 36104, 1, 36664, 1, 36978, 1, 37273, 1, 37494, 1,
    38524, 1, 38627, 1, 38742, 1, 38875, 1, 38911, 1, 38923, 1, 38971, 1, 39698, 1, 40860, 1,
    141386, 1, 141380, 1, 144341, 1, 15261, 1, 16408, 1, 16441, 1, 152137, 1, 154832, 1, 163539, 1,
    40771, 1, 40846, 2, 1497, 1460, 2, 1522, 1463, 2, 1513, 1473, 2, 1513, 1474, 3, 1513, 1468,
    1473, 3, 1513, 1468, 1474, 2, 1488, 1463, 2, 1488, 1464, 2, 1488, 1468, 2, 1489, 1468, 2, 1490,
    1468, 2, 1491, 1468, 2, 1492, 1468, 2, 1493, 1468, 2, 1494, 1468, 2, 1496, 1468, 2, 1497, 1468,
    2, 1498, 1468, 2, 1499, 1468, 2, 1500, 1468, 2, 1502, 1468, 2, 1504, 1468, 2, 1505, 1468, 2,
    1507, 1468, 2, 1508, 1468, 2, 1510, 1468, 2, 1511, 1468, 2, 1512, 1468, 2, 1513, 1468, 2, 1514,
    1468, 2, 1493, 1465, 2, 1489, 1471, 2, 1499, 1471, 2, 1508, 1471, 2, 69785, 69818, 2, 69787,
    69818, 2, 69797, 69818, 2, 69937, 69927, 2, 69938, 69927, 2, 70471, 70462, 2, 70471, 70487, 2,
    70841, 70842, 2, 70841, 70832, 2, 70841, 70845, 2, 71096, 71087, 2, 71097, 71087, 2, 71989,
    71984, 2, 119127, 119141, 2, 119128, 119141, 3, 119128, 119141, 119150, 3, 119128, 119141,
    119151, 3, 119128, 119141, 119152, 3, 119128, 119141, 119153, 3, 119128, 119141, 119154, 2,
    119225, 119141, 2, 119226, 119141, 3, 119225, 119141, 119150, 3, 119226, 119141, 119150, 3,
    119225, 119141, 119151, 3, 119226, 119141, 119151, 1, 20029, 1, 20024, 1, 20033, 1, 131362, 1,
    20320, 1, 20398, 1, 20411, 1, 20482, 1, 20602, 1, 20633, 1, 20711, 1, 20687, 1, 13470, 1,
    132666, 1, 20813, 1, 20820, 1, 20836, 1, 20855, 1, 132380, 1, 13497, 1, 20839, 1, 20877, 1,
    132427, 1, 20887, 1, 20900, 1, 20172, 1, 20908, 1, 20917, 1, 168415, 1, 20981, 1, 20995, 1,
    13535, 1, 21051, 1, 21062, 1, 21106, 1, 21111, 1, 13589, 1, 21191, 1, 21193, 1, 21220, 1,
    21242, 1, 21253, 1, 21254, 1, 21271, 1, 21321, 1, 21329, 1, 21338, 1, 21363, 1, 21373, 1,
    21375, 1, 21375, 1, 21375, 1, 133676, 1, 28784, 1, 21450, 1, 21471, 1, 133987, 1, 21483, 1,
    21489, 1, 21510, 1, 21662, 1, 21560, 1, 21576, 1, 21608, 1, 21666, 1, 21750, 1, 21776, 1,
    21843, 1, 21859, 1, 21892, 1, 21892, 1, 21913, 1, 21931, 1, 21939, 1, 21954, 1, 22294, 1,
    22022, 1, 22295, 1, 22097, 1, 22132, 1, 20999, 1, 22766, 1, 22478, 1, 22516, 1, 22541, 1,
    22411, 1, 22578, 1, 22577, 1, 22700, 1, 136420, 1, 22770, 1, 22775, 1, 22790, 1, 22810, 1,
    22818, 1, 22882, 1, 136872, 1, 136938, 1, 23020, 1, 23067, 1, 23079, 1, 23000, 1, 23142, 1,
    14062, 1, 14076, 1, 23304, 1, 23358, 1, 23358, 1, 137672, 1, 23491, 1, 23512, 1, 23527, 1,
    23539, 1, 138008, 1, 23551, 1, 23558, 1, 24403, 1, 23586, 1, 14209, 1, 23648, 1, 23662, 1,
    23744, 1, 23693, 1, 138724, 1, 23875, 1, 138726, 1, 23918, 1, 23915, 1, 23932, 1, 24033, 1,
    24034, 1, 14383, 1, 24061, 1, 24104, 1, 24125, 1, 24169, 1, 14434, 1, 139651, 1, 14460, 1,
    24240, 1, 24243, 1, 24246, 1, 24266, 1, 172946, 1, 24318, 1, 140081, 1, 140081, 1, 33281, 1,
    24354, 1, 24354, 1, 14535, 1, 144056, 1, 156122, 1, 24418, 1, 24427, 1, 14563, 1, 24474, 1,
    24525, 1, 24535, 1, 24569, 1, 24705, 1, 14650, 1, 14620, 1, 24724, 1, 141012, 1, 24775, 1,
    24904, 1, 24908, 1, 24910, 1, 24908, 1, 24954, 1, 24974, 1, 25010, 1, 24996, 1, 25007, 1,
    25054, 1, 25074, 1, 25078, 1, 25104, 1, 25115, 1, 25181, 1, 25265, 1, 25300, 1, 25424, 1,
    142092, 1, 25405, 1, 25340, 1, 25448, 1, 25475, 1, 25572, 1, 142321, 1, 25634, 1, 25541, 1,
    25513, 1, 14894, 1, 25705, 1, 25726, 1, 25757, 1, 25719, 1, 14956, 1, 25935, 1, 25964, 1,
    143370, 1, 26083, 1, 26360, 1, 26185, 1, 15129, 1, 26257, 1, 15112, 1, 15076, 1, 20882, 1,
    20885, 1, 26368, 1, 26268, 1, 32941, 1, 17369, 1, 26391, 1, 26395, 1, 26401, 1, 26462, 1,
    26451, 1, 144323, 1, 15177, 1, 26618, 1, 26501, 1, 26706, 1, 26757, 1, 144493, 1, 26766, 1,
    26655, 1, 26900, 1, 15261, 1, 26946, 1, 27043, 1, 27114, 1, 27304, 1, 145059, 1, 27355, 1,
    15384, 1, 27425, 1, 145575, 1, 27476, 1, 15438, 1, 27506, 1, 27551, 1, 27578, 1, 27579, 1,
    146061, 1, 138507, 1, 146170, 1, 27726, 1, 146620, 1, 27839, 1, 27853, 1, 27751, 1, 27926, 1,
    27966, 1, 28023, 1, 27969, 1, 28009, 1, 28024, 1, 28037, 1, 146718, 1, 27956, 1, 28207, 1,
    28270, 1, 15667, 1, 28363, 1, 28359, 1, 147153, 1, 28153, 1, 28526, 1, 147294, 1, 147342, 1,
    28614, 1, 28729, 1, 28702, 1, 28699, 1, 15766, 1, 28746, 1, 28797, 1, 28791, 1, 28845, 1,
    132389, 1, 28997, 1, 148067, 1, 29084, 1, 148395, 1, 29224, 1, 29237, 1, 29264, 1, 149000, 1,
    29312, 1, 29333, 1, 149301, 1, 149524, 1, 29562, 1, 29579, 1, 16044, 1, 29605, 1, 16056, 1,
    16056, 1, 29767, 1, 29788, 1, 29809, 1, 29829, 1, 29898, 1, 16155, 1, 29988, 1, 150582, 1,
    30014, 1, 150674, 1, 30064, 1, 139679, 1, 30224, 1, 151457, 1, 151480, 1, 151620, 1, 16380, 1,
    16392, 1, 30452, 1, 151795, 1, 151794, 1, 151833, 1, 151859, 1, 30494, 1, 30495, 1, 30495, 1,
    30538, 1, 16441, 1, 30603, 1, 16454, 1, 16534, 1, 152605, 1, 30798, 1, 30860, 1, 30924, 1,
    16611, 1, 153126, 1, 31062, 1, 153242, 1, 153285, 1, 31119, 1, 31211, 1, 16687, 1, 31296, 1,
    31306, 1, 31311, 1, 153980, 1, 154279, 1, 154279, 1, 31470, 1, 16898, 1, 154539, 1, 31686, 1,
    31689, 1, 16935, 1, 154752, 1, 31954, 1, 17056, 1, 31976, 1, 31971, 1, 32000, 1, 155526, 1,
    32099, 1, 17153, 1, 32199, 1, 32258, 1, 32325, 1, 17204, 1, 156200, 1, 156231, 1, 17241, 1,
    156377, 1, 32634, 1, 156478, 1, 32661, 1, 32762, 1, 32773, 1, 156890, 1, 156963, 1, 32864, 1,
    157096, 1, 32880, 1, 144223, 1, 17365, 1, 32946, 1, 33027, 1, 17419, 1, 33086, 1, 23221, 1,
    157607, 1, 157621, 1, 144275, 1, 144284, 1, 33281, 1, 33284, 1, 36766, 1, 17515, 1, 33425, 1,
    33419, 1, 33437, 1, 21171, 1, 33457, 1, 33459, 1, 33469, 1, 33510, 1, 158524, 1, 33509, 1,
    33565, 1, 33635, 1, 33709, 1, 33571, 1, 33725, 1, 33767, 1, 33879, 1, 33619, 1, 33738, 1,
    33740, 1, 33756, 1, 158774, 1, 159083, 1, 158933, 1, 17707, 1, 34033, 1, 34035, 1, 34070, 1,
    160714, 1, 34148, 1, 159532, 1, 17757, 1, 17761, 1, 159665, 1, 159954, 1, 17771, 1, 34384, 1,
    34396, 1, 34407, 1, 34409, 1, 34473, 1, 34440, 1, 34574, 1, 34530, 1, 34681, 1, 34600, 1,
    34667, 1, 34694, 1, 17879, 1, 34785, 1, 34817, 1, 17913, 1, 34912, 1, 34915, 1, 161383, 1,
    35031, 1, 35038, 1, 17973, 1, 35066, 1, 13499, 1, 161966, 1, 162150, 1, 18110, 1, 18119, 1,
    35488, 1, 35565, 1, 35722, 1, 35925, 1, 162984, 1, 36011, 1, 36033, 1, 36123, 1, 36215, 1,
    163631, 1, 133124, 1, 36299, 1, 36284, 1, 36336, 1, 133342, 1, 36564, 1, 36664, 1, 165330, 1,
    165357, 1, 37012, 1, 37105, 1, 37137, 1, 165678, 1, 37147, 1, 37432, 1, 37591, 1, 37592, 1,
    37500, 1, 37881, 1, 37909, 1, 166906, 1, 38283, 1, 18837, 1, 38327, 1, 167287, 1, 18918, 1,
    38595, 1, 23986, 1, 38691, 1, 168261, 1, 168474, 1, 19054, 1, 19062, 1, 38880, 1, 168970, 1,
    19122, 1, 169110, 1, 38923, 1, 38923, 1, 38953, 1, 169398, 1, 39138, 1, 19251, 1, 39209, 1,
    39335, 1, 39362, 1, 39422, 1, 19406, 1, 170800, 1, 39698, 1, 40000, 1, 40189, 1, 19662, 1,
    19693, 1, 40295, 1, 172238, 1, 19704, 1, 172293, 1, 172558, 1, 172689, 1, 40635, 1, 19798, 1,
    40697, 1, 40702, 1, 40709, 1, 40719, 1, 40726, 1, 40763, 1, 173568,
];

#[rustfmt::skip]
pub const DECOMPOSE_COMPAT: [u32; 9307] = [
    0, 255, 1, 32, 2, 32, 776, 1, 97, 2, 32, 772, 1, 50, 1, 51, 2, 32, 769, 1, 956, 2, 32, 807, 1,
    49, 1, 111, 3, 49, 8260, 52, 3, 49, 8260, 50, 3, 51, 8260, 52, 2, 73, 74, 2, 105, 106, 2, 76,
    183, 2, 108, 183, 2, 700, 110, 1, 115, 3, 68, 90, 780, 3, 68, 122, 780, 3, 100, 122, 780, 2,
    76, 74, 2, 76, 106, 2, 108, 106, 2, 78, 74, 2, 78, 106, 2, 110, 106, 2, 68, 90, 2, 68, 122, 2,
    100, 122, 1, 104, 1, 614, 1, 106, 1, 114, 1, 633, 1, 635, 1, 641, 1, 119, 1, 121, 2, 32, 774,
    2, 32, 775, 2, 32, 778, 2, 32, 808, 2, 32, 771, 2, 32, 779, 1, 611, 1, 108, 1, 115, 1, 120, 1,
    661, 2, 32, 837, 2, 32, 769, 3, 32, 776, 769, 1, 946, 1, 952, 1, 933, 2, 933, 769, 2, 933, 776,
    1, 966, 1, 960, 1, 954, 1, 961, 1, 962, 1, 920, 1, 949, 1, 931, 2, 1381, 1410, 2, 1575, 1652,
    2, 1608, 1652, 2, 1735, 1652, 2, 1610, 1652, 2, 3661, 3634, 2, 3789, 3762, 2, 3755, 3737, 2,
    3755, 3745, 1, 3851, 3, 4018, 3953, 3968, 3, 4019, 3953, 3968, 1, 4316, 1, 65, 1, 198, 1, 66,
    1, 68, 1, 69, 1, 398, 1, 71, 1, 72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 546, 1,
    80, 1, 82, 1, 84, 1, 85, 1, 87, 1, 97, 1, 592, 1, 593, 1, 7426, 1, 98, 1, 100, 1, 101, 1, 601,
    1, 603, 1, 604, 1, 103, 1, 107, 1, 109, 1, 331, 1, 111, 1, 596, 1, 7446, 1, 7447, 1, 112, 1,
    116, 1, 117, 1, 7453, 1, 623, 1, 118, 1, 7461, 1, 946, 1, 947, 1, 948, 1, 966, 1, 967, 1, 105,
    1, 114, 1, 117, 1, 118, 1, 946, 1, 947, 1, 961, 1, 966, 1, 967, 1, 1085, 1, 594, 1, 99, 1, 597,
    1, 240, 1, 604, 1, 102, 1, 607, 1, 609, 1, 613, 1, 616, 1, 617, 1, 618, 1, 7547, 1, 669, 1,
    621, 1, 7557, 1, 671, 1, 625, 1, 624, 1, 626, 1, 627, 1, 628, 1, 629, 1, 632, 1, 642, 1, 643,
    1, 427, 1, 649, 1, 650, 1, 7452, 1, 651, 1, 652, 1, 122, 1, 656, 1, 657, 1, 658, 1, 952, 2, 97,
    702, 2, 115, 775, 2, 32, 787, 2, 32, 787, 2, 32, 834, 3, 32, 776, 834, 3, 32, 787, 768, 3, 32,
    787, 769, 3, 32, 787, 834, 3, 32, 788, 768, 3, 32, 788, 769, 3, 32, 788, 834, 3, 32, 776, 768,
    3, 32, 776, 769, 2, 32, 769, 2, 32, 788, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1,
    32, 1, 32, 1, 32, 1, 32, 1, 8208, 2, 32, 819, 1, 46, 2, 46, 46, 3, 46, 46, 46, 1, 32, 2, 8242,
    8242, 3, 8242, 8242, 8242, 2, 8245, 8245, 3, 8245, 8245, 8245, 2, 33, 33, 2, 32, 773, 2, 63,
    63, 2, 63, 33, 2, 33, 63, 4, 8242, 8242, 8242, 8242, 1, 32, 1, 48, 1, 105, 1, 52, 1, 53, 1, 54,
    1, 55, 1, 56, 1, 57, 1, 43, 1, 8722, 1, 61, 1, 40, 1, 41, 1, 110, 1, 48, 1, 49, 1, 50, 1, 51,
    1, 52, 1, 53, 1, 54, 1, 55, 1, 56, 1, 57, 1, 43, 1, 8722, 1, 61, 1, 40, 1, 41, 1, 97, 1, 101,
    1, 111, 1, 120, 1, 601, 1, 104, 1, 107, 1, 108, 1, 109, 1, 110, 1, 112, 1, 115, 1, 116, 2, 82,
    115, 3, 97, 47, 99, 3, 97, 47, 115, 1, 67, 2, 176, 67, 3, 99, 47, 111, 3, 99, 47, 117, 1, 400,
    2, 176, 70, 1, 103, 1, 72, 1, 72, 1, 72, 1, 104, 1, 295, 1, 73, 1, 73, 1, 76, 1, 108, 1, 78, 2,
    78, 111, 1, 80, 1, 81, 1, 82, 1, 82, 1, 82, 2, 83, 77, 3, 84, 69, 76, 2, 84, 77, 1, 90, 1, 90,
    1, 66, 1, 67, 1, 101, 1, 69, 1, 70, 1, 77, 1, 111, 1, 1488, 1, 1489, 1, 1490, 1, 1491, 1, 105,
    3, 70, 65, 88, 1, 960, 1, 947, 1, 915, 1, 928, 1, 8721, 1, 68, 1, 100, 1, 101, 1, 105, 1, 106,
    3, 49, 8260, 55, 3, 49, 8260, 57, 4, 49, 8260, 49, 48, 3, 49, 8260, 51, 3, 50, 8260, 51, 3, 49,
    8260, 53, 3, 50, 8260, 53, 3, 51, 8260, 53, 3, 52, 8260, 53, 3, 49, 8260, 54, 3, 53, 8260, 54,
    3, 49, 8260, 56, 3, 51, 8260, 56, 3, 53, 8260, 56, 3, 55, 8260, 56, 2, 49, 8260, 1, 73, 2, 73,
    73, 3, 73, 73, 73, 2, 73, 86, 1, 86, 2, 86, 73, 3, 86, 73, 73, 4, 86, 73, 73, 73, 2, 73, 88, 1,
    88, 2, 88, 73, 3, 88, 73, 73, 1, 76, 1, 67, 1, 68, 1, 77, 1, 105, 2, 105, 105, 3, 105, 105,
    105, 2, 105, 118, 1, 118, 2, 118, 105, 3, 118, 105, 105, 4, 118, 105, 105, 105, 2, 105, 120, 1,
    120, 2, 120, 105, 3, 120, 105, 105, 1, 108, 1, 99, 1, 100, 1, 109, 3, 48, 8260, 51, 2, 8747,
    8747, 3, 8747, 8747, 8747, 2, 8750, 8750, 3, 8750, 8750, 8750, 1, 49, 1, 50, 1, 51, 1, 52, 1,
    53, 1, 54, 1, 55, 1, 56, 1, 57, 2, 49, 48, 2, 49, 49, 2, 49, 50, 2, 49, 51, 2, 49, 52, 2, 49,
    53, 2, 49, 54, 2, 49, 55, 2, 49, 56, 2, 49, 57, 2, 50, 48, 3, 40, 49, 41, 3, 40, 50, 41, 3, 40,
    51, 41, 3, 40, 52, 41, 3, 40, 53, 41, 3, 40, 54, 41, 3, 40, 55, 41, 3, 40, 56, 41, 3, 40, 57,
    41, 4, 40, 49, 48, 41, 4, 40, 49, 49, 41, 4, 40, 49, 50, 41, 4, 40, 49, 51, 41, 4, 40, 49, 52,
    41, 4, 40, 49, 53, 41, 4, 40, 49, 54, 41, 4, 40, 49, 55, 41, 4, 40, 49, 56, 41, 4, 40, 49, 57,
    41, 4, 40, 50, 48, 41, 2, 49, 46, 2, 50, 46, 2, 51, 46, 2, 52, 46, 2, 53, 46, 2, 54, 46, 2, 55,
    46, 2, 56, 46, 2, 57, 46, 3, 49, 48, 46, 3, 49, 49, 46, 3, 49, 50, 46, 3, 49, 51, 46, 3, 49,
    52, 46, 3, 49, 53, 46, 3, 49, 54, 46, 3, 49, 55, 46, 3, 49, 56, 46, 3, 49, 57, 46, 3, 50, 48,
    46, 3, 40, 97, 41, 3, 40, 98, 41, 3, 40, 99, 41, 3, 40, 100, 41, 3, 40, 101, 41, 3, 40, 102,
    41, 3, 40, 103, 41, 3, 40, 104, 41, 3, 40, 105, 41, 3, 40, 106, 41, 3, 40, 107, 41, 3, 40, 108,
    41, 3, 40, 109, 41, 3, 40, 110, 41, 3, 40, 111, 41, 3, 40, 112, 41, 3, 40, 113, 41, 3, 40, 114,
    41, 3, 40, 115, 41, 3, 40, 116, 41, 3, 40, 117, 41, 3, 40, 118, 41, 3, 40, 119, 41, 3, 40, 120,
    41, 3, 40, 121, 41, 3, 40, 122, 41, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71, 1, 72, 1,
    73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86,
    1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1, 104, 1,
    105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1, 116, 1,
    117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 48, 4, 8747, 8747, 8747, 8747, 3, 58, 58, 61,
    2, 61, 61, 3, 61, 61, 61, 1, 106, 1, 86, 1, 11617, 1, 27597, 1, 40863, 1, 19968, 1, 20008, 1,
    20022, 1, 20031, 1, 20057, 1, 20101, 1, 20108, 1, 20128, 1, 20154, 1, 20799, 1, 20837, 1,
    20843, 1, 20866, 1, 20886, 1, 20907, 1, 20960, 1, 20981, 1, 20992, 1, 21147, 1, 21241, 1,
    21269, 1, 21274, 1, 21304, 1, 21313, 1, 21340, 1, 21353, 1, 21378, 1, 21430, 1, 21448, 1,
    21475, 1, 22231, 1, 22303, 1, 22763, 1, 22786, 1, 22794, 1, 22805, 1, 22823, 1, 22899, 1,
    23376, 1, 23424, 1, 23544, 1, 23567, 1, 23586, 1, 23608, 1, 23662, 1, 23665, 1, 24027, 1,
    24037, 1, 24049, 1, 24062, 1, 24178, 1, 24186, 1, 24191, 1, 24308, 1, 24318, 1, 24331, 1,
    24339, 1, 24400, 1, 24417, 1, 24435, 1, 24515, 1, 25096, 1, 25142, 1, 25163, 1, 25903, 1,
    25908, 1, 25991, 1, 26007, 1, 26020, 1, 26041, 1, 26080, 1, 26085, 1, 26352, 1, 26376, 1,
    26408, 1, 27424, 1, 27490, 1, 27513, 1, 27571, 1, 27595, 1, 27604, 1, 27611, 1, 27663, 1,
    27668, 1, 27700, 1, 28779, 1, 29226, 1, 29238, 1, 29243, 1, 29247, 1, 29255, 1, 29273, 1,
    29275, 1, 29356, 1, 29572, 1, 29577, 1, 29916, 1, 29926, 1, 29976, 1, 29983, 1, 29992, 1,
    30000, 1, 30091, 1, 30098, 1, 30326, 1, 30333, 1, 30382, 1, 30399, 1, 30446, 1, 30683, 1,
    30690, 1, 30707, 1, 31034, 1, 31160, 1, 31166, 1, 31348, 1, 31435, 1, 31481, 1, 31859, 1,
    31992, 1, 32566, 1, 32593, 1, 32650, 1, 32701, 1, 32769, 1, 32780, 1, 32786, 1, 32819, 1,
    32895, 1, 32905, 1, 33251, 1, 33258, 1, 33267, 1, 33276, 1, 33292, 1, 33307, 1, 33311, 1,
    33390, 1, 33394, 1, 33400, 1, 34381, 1, 34411, 1, 34880, 1, 34892, 1, 34915, 1, 35198, 1,
    35211, 1, 35282, 1, 35328, 1, 35895, 1, 35910, 1, 35925, 1, 35960, 1, 35997, 1, 36196, 1,
    36208, 1, 36275, 1, 36523, 1, 36554, 1, 36763, 1, 36784, 1, 36789, 1, 37009, 1, 37193, 1,
    37318, 1, 37324, 1, 37329, 1, 38263, 1, 38272, 1, 38428, 1, 38582, 1, 38585, 1, 38632, 1,
    38737, 1, 38750, 1, 38754, 1, 38761, 1, 38859, 1, 38893, 1, 38899, 1, 38913, 1, 39080, 1,
    39131, 1, 39135, 1, 39318, 1, 39321, 1, 39340, 1, 39592, 1, 39640, 1, 39647, 1, 39717, 1,
    39727, 1, 39730, 1, 39740, 1, 39770, 1, 40165, 1, 40565, 1, 40575, 1, 40613, 1, 40635, 1,
    40643, 1, 40653, 1, 40657, 1, 40697, 1, 40701, 1, 40718, 1, 40723, 1, 40736, 1, 40763, 1,
    40778, 1, 40786, 1, 40845, 1, 40860, 1, 40864, 1, 32, 1, 12306, 1, 21313, 1, 21316, 1, 21317,
    2, 32, 12441, 2, 32, 12442, 2, 12424, 12426, 2, 12467, 12488, 1, 4352, 1, 4353, 1, 4522, 1,
    4354, 1, 4524, 1, 4525, 1, 4355, 1, 4356, 1, 4357, 1, 4528, 1, 4529, 1, 4530, 1, 4531, 1, 4532,
    1, 4533, 1, 4378, 1, 4358, 1, 4359, 1, 4360, 1, 4385, 1, 4361, 1, 4362, 1, 4363, 1, 4364, 1,
    4365, 1, 4366, 1, 4367, 1, 4368, 1, 4369, 1, 4370, 1, 4449, 1, 4450, 1, 4451, 1, 4452, 1, 4453,
    1, 4454, 1, 4455, 1, 4456, 1, 4457, 1, 4458, 1, 4459, 1, 4460, 1, 4461, 1, 4462, 1, 4463, 1,
    4464, 1, 4465, 1, 4466, 1, 4467, 1, 4468, 1, 4469, 1, 4448, 1, 4372, 1, 4373, 1, 4551, 1, 4552,
    1, 4556, 1, 4558, 1, 4563, 1, 4567, 1, 4569, 1, 4380, 1, 4573, 1, 4575, 1, 4381, 1, 4382, 1,
    4384, 1, 4386, 1, 4387, 1, 4391, 1, 4393, 1, 4395, 1, 4396, 1, 4397, 1, 4398, 1, 4399, 1, 4402,
    1, 4406, 1, 4416, 1, 4423, 1, 4428, 1, 4593, 1, 4594, 1, 4439, 1, 4440, 1, 4441, 1, 4484, 1,
    4485, 1, 4488, 1, 4497, 1, 4498, 1, 4500, 1, 4510, 1, 4513, 1, 19968, 1, 20108, 1, 19977, 1,
    22235, 1, 19978, 1, 20013, 1, 19979, 1, 30002, 1, 20057, 1, 19993, 1, 19969, 1, 22825, 1,
    22320, 1, 20154, 3, 40, 4352, 41, 3, 40, 4354, 41, 3, 40, 4355, 41, 3, 40, 4357, 41, 3, 40,
    4358, 41, 3, 40, 4359, 41, 3, 40, 4361, 41, 3, 40, 4363, 41, 3, 40, 4364, 41, 3, 40, 4366, 41,
    3, 40, 4367, 41, 3, 40, 4368, 41, 3, 40, 4369, 41, 3, 40, 4370, 41, 4, 40, 4352, 4449, 41, 4,
    40, 4354, 4449, 41, 4, 40, 4355, 4449, 41, 4, 40, 4357, 4449, 41, 4, 40, 4358, 4449, 41, 4, 40,
    4359, 4449, 41, 4, 40, 4361, 4449, 41, 4, 40, 4363, 4449, 41, 4, 40, 4364, 4449, 41, 4, 40,
    4366, 4449, 41, 4, 40, 4367, 4449, 41, 4, 40, 4368, 4449, 41, 4, 40, 4369, 4449, 41, 4, 40,
    4370, 4449, 41, 4, 40, 4364, 4462, 41, 7, 40, 4363, 4457, 4364, 4453, 4523, 41, 6, 40, 4363,
    4457, 4370, 4462, 41, 3, 40, 19968, 41, 3, 40, 20108, 41, 3, 40, 19977, 41, 3, 40, 22235, 41,
    3, 40, 20116, 41, 3, 40, 20845, 41, 3, 40, 19971, 41, 3, 40, 20843, 41, 3, 40, 20061, 41, 3,
    40, 21313, 41, 3, 40, 26376, 41, 3, 40, 28779, 41, 3, 40, 27700, 41, 3, 40, 26408, 41, 3, 40,
    37329, 41, 3, 40, 22303, 41, 3, 40, 26085, 41, 3, 40, 26666, 41, 3, 40, 26377, 41, 3, 40,
    31038, 41, 3, 40, 21517, 41, 3, 40, 29305, 41, 3, 40, 36001, 41, 3, 40, 31069, 41, 3, 40,
    21172, 41, 3, 40, 20195, 41, 3, 40, 21628, 41, 3, 40, 23398, 41, 3, 40, 30435, 41, 3, 40,
    20225, 41, 3, 40, 36039, 41, 3, 40, 21332, 41, 3, 40, 31085, 41, 3, 40, 20241, 41, 3, 40,
    33258, 41, 3, 40, 33267, 41, 1, 21839, 1, 24188, 1, 25991, 1, 31631, 3, 80, 84, 69, 2, 50, 49,
    2, 50, 50, 2, 50, 51, 2, 50, 52, 2, 50, 53, 2, 50, 54, 2, 50, 55, 2, 50, 56, 2, 50, 57, 2, 51,
    48, 2, 51, 49, 2, 51, 50, 2, 51, 51, 2, 51, 52, 2, 51, 53, 1, 4352, 1, 4354, 1, 4355, 1, 4357,
    1, 4358, 1, 4359, 1, 4361, 1, 4363, 1, 4364, 1, 4366, 1, 4367, 1, 4368, 1, 4369, 1, 4370, 2,
    4352, 4449, 2, 4354, 4449, 2, 4355, 4449, 2, 4357, 4449, 2, 4358, 4449, 2, 4359, 4449, 2, 4361,
    4449, 2, 4363, 4449, 2, 4364, 4449, 2, 4366, 4449, 2, 4367, 4449, 2, 4368, 4449, 2, 4369, 4449,
    2, 4370, 4449, 5, 4366, 4449, 4535, 4352, 4457, 4, 4364, 4462, 4363, 4468, 2, 4363, 4462, 1,
    19968, 1, 20108, 1, 19977, 1, 22235, 1, 20116, 1, 20845, 1, 19971, 1, 20843, 1, 20061, 1,
    21313, 1, 26376, 1, 28779, 1, 27700, 1, 26408, 1, 37329, 1, 22303, 1, 26085, 1, 26666, 1,
    26377, 1, 31038, 1, 21517, 1, 29305, 1, 36001, 1, 31069, 1, 21172, 1, 31192, 1, 30007, 1,
    22899, 1, 36969, 1, 20778, 1, 21360, 1, 27880, 1, 38917, 1, 20241, 1, 20889, 1, 27491, 1,
    19978, 1, 20013, 1, 19979, 1, 24038, 1, 21491, 1, 21307, 1, 23447, 1, 23398, 1, 30435, 1,
    20225, 1, 36039, 1, 21332, 1, 22812, 2, 51, 54, 2, 51, 55, 2, 51, 56, 2, 51, 57, 2, 52, 48, 2,
    52, 49, 2, 52, 50, 2, 52, 51, 2, 52, 52, 2, 52, 53, 2, 52, 54, 2, 52, 55, 2, 52, 56, 2, 52, 57,
    2, 53, 48, 2, 49, 26376, 2, 50, 26376, 2, 51, 26376, 2, 52, 26376, 2, 53, 26376, 2, 54, 26376,
    2, 55, 26376, 2, 56, 26376, 2, 57, 26376, 3, 49, 48, 26376, 3, 49, 49, 26376, 3, 49, 50, 26376,
    2, 72, 103, 3, 101, 114, 103, 2, 101, 86, 3, 76, 84, 68, 1, 12450, 1, 12452, 1, 12454, 1,
    12456, 1, 12458, 1, 12459, 1, 12461, 1, 12463, 1, 12465, 1, 12467, 1, 12469, 1, 12471, 1,
    12473, 1, 12475, 1, 12477, 1, 12479, 1, 12481, 1, 12484, 1, 12486, 1, 12488, 1, 12490, 1,
    12491, 1, 12492, 1, 12493, 1, 12494, 1, 12495, 1, 12498, 1, 12501, 1, 12504, 1, 12507, 1,
    12510, 1, 12511, 1, 12512, 1, 12513, 1, 12514, 1, 12516, 1, 12518, 1, 12520, 1, 12521, 1,
    12522, 1, 12523, 1, 12524, 1, 12525, 1, 12527, 1, 12528, 1, 12529, 1, 12530, 2, 20196, 21644,
    5, 12450, 12495, 12442, 12540, 12488, 4, 12450, 12523, 12501, 12449, 5, 12450, 12531, 12504,
    12442, 12450, 3, 12450, 12540, 12523, 5, 12452, 12491, 12531, 12463, 12441, 3, 12452, 12531,
    12481, 3, 12454, 12457, 12531, 6, 12456, 12473, 12463, 12540, 12488, 12441, 4, 12456, 12540,
    12459, 12540, 3, 12458, 12531, 12473, 3, 12458, 12540, 12512, 3, 12459, 12452, 12522, 4, 12459,
    12521, 12483, 12488, 4, 12459, 12525, 12522, 12540, 4, 12459, 12441, 12525, 12531, 4, 12459,
    12441, 12531, 12510, 4, 12461, 12441, 12459, 12441, 4, 12461, 12441, 12491, 12540, 4, 12461,
    12517, 12522, 12540, 6, 12461, 12441, 12523, 12479, 12441, 12540, 2, 12461, 12525, 6, 12461,
    12525, 12463, 12441, 12521, 12512, 6, 12461, 12525, 12513, 12540, 12488, 12523, 5, 12461,
    12525, 12527, 12483, 12488, 4, 12463, 12441, 12521, 12512, 6, 12463, 12441, 12521, 12512,
    12488, 12531, 6, 12463, 12523, 12475, 12441, 12452, 12525, 4, 12463, 12525, 12540, 12493, 3,
    12465, 12540, 12473, 3, 12467, 12523, 12490, 4, 12467, 12540, 12507, 12442, 4, 12469, 12452,
    12463, 12523, 5, 12469, 12531, 12481, 12540, 12512, 5, 12471, 12522, 12531, 12463, 12441, 3,
    12475, 12531, 12481, 3, 12475, 12531, 12488, 4, 12479, 12441, 12540, 12473, 3, 12486, 12441,
    12471, 3, 12488, 12441, 12523, 2, 12488, 12531, 2, 12490, 12494, 3, 12494, 12483, 12488, 3,
    12495, 12452, 12484, 6, 12495, 12442, 12540, 12475, 12531, 12488, 4, 12495, 12442, 12540,
    12484, 5, 12495, 12441, 12540, 12524, 12523, 6, 12498, 12442, 12450, 12473, 12488, 12523, 4,
    12498, 12442, 12463, 12523, 3, 12498, 12442, 12467, 3, 12498, 12441, 12523, 6, 12501, 12449,
    12521, 12483, 12488, 12441, 4, 12501, 12451, 12540, 12488, 6, 12501, 12441, 12483, 12471,
    12455, 12523, 3, 12501, 12521, 12531, 5, 12504, 12463, 12479, 12540, 12523, 3, 12504, 12442,
    12477, 4, 12504, 12442, 12491, 12498, 3, 12504, 12523, 12484, 4, 12504, 12442, 12531, 12473, 5,
    12504, 12442, 12540, 12471, 12441, 4, 12504, 12441, 12540, 12479, 5, 12507, 12442, 12452,
    12531, 12488, 4, 12507, 12441, 12523, 12488, 2, 12507, 12531, 5, 12507, 12442, 12531, 12488,
    12441, 3, 12507, 12540, 12523, 3, 12507, 12540, 12531, 4, 12510, 12452, 12463, 12525, 3, 12510,
    12452, 12523, 3, 12510, 12483, 12495, 3, 12510, 12523, 12463, 5, 12510, 12531, 12471, 12519,
    12531, 4, 12511, 12463, 12525, 12531, 2, 12511, 12522, 6, 12511, 12522, 12495, 12441, 12540,
    12523, 3, 12513, 12459, 12441, 5, 12513, 12459, 12441, 12488, 12531, 4, 12513, 12540, 12488,
    12523, 4, 12516, 12540, 12488, 12441, 3, 12516, 12540, 12523, 3, 12518, 12450, 12531, 4, 12522,
    12483, 12488, 12523, 2, 12522, 12521, 4, 12523, 12498, 12442, 12540, 5, 12523, 12540, 12501,
    12441, 12523, 2, 12524, 12512, 6, 12524, 12531, 12488, 12465, 12441, 12531, 3, 12527, 12483,
    12488, 2, 48, 28857, 2, 49, 28857, 2, 50, 28857, 2, 51, 28857, 2, 52, 28857, 2, 53, 28857, 2,
    54, 28857, 2, 55, 28857, 2, 56, 28857, 2, 57, 28857, 3, 49, 48, 28857, 3, 49, 49, 28857, 3, 49,
    50, 28857, 3, 49, 51, 28857, 3, 49, 52, 28857, 3, 49, 53, 28857, 3, 49, 54, 28857, 3, 49, 55,
    28857, 3, 49, 56, 28857, 3, 49, 57, 28857, 3, 50, 48, 28857, 3, 50, 49, 28857, 3, 50, 50,
    28857, 3, 50, 51, 28857, 3, 50, 52, 28857, 3, 104, 80, 97, 2, 100, 97, 2, 65, 85, 3, 98, 97,
    114, 2, 111, 86, 2, 112, 99, 2, 100, 109, 3, 100, 109, 50, 3, 100, 109, 51, 2, 73, 85, 2,
    24179, 25104, 2, 26157, 21644, 2, 22823, 27491, 2, 26126, 27835, 4, 26666, 24335, 20250, 31038,
    2, 112, 65, 2, 110, 65, 2, 956, 65, 2, 109, 65, 2, 107, 65, 2, 75, 66, 2, 77, 66, 2, 71, 66, 3,
    99, 97, 108, 4, 107, 99, 97, 108, 2, 112, 70, 2, 110, 70, 2, 956, 70, 2, 956, 103, 2, 109, 103,
    2, 107, 103, 2, 72, 122, 3, 107, 72, 122, 3, 77, 72, 122, 3, 71, 72, 122, 3, 84, 72, 122, 2,
    956, 108, 2, 109, 108, 2, 100, 108, 2, 107, 108, 2, 102, 109, 2, 110, 109, 2, 956, 109, 2, 109,
    109, 2, 99, 109, 2, 107, 109, 3, 109, 109, 50, 3, 99, 109, 50, 2, 109, 50, 3, 107, 109, 50, 3,
    109, 109, 51, 3, 99, 109, 51, 2, 109, 51, 3, 107, 109, 51, 3, 109, 8725, 115, 4, 109, 8725,
    115, 50, 2, 80, 97, 3, 107, 80, 97, 3, 77, 80, 97, 3, 71, 80, 97, 3, 114, 97, 100, 5, 114, 97,
    100, 8725, 115, 6, 114, 97, 100, 8725, 115, 50, 2, 112, 115, 2, 110, 115, 2, 956, 115, 2, 109,
    115, 2, 112, 86, 2, 110, 86, 2, 956, 86, 2, 109, 86, 2, 107, 86, 2, 77, 86, 2, 112, 87, 2, 110,
    87, 2, 956, 87, 2, 109, 87, 2, 107, 87, 2, 77, 87, 2, 107, 937, 2, 77, 937, 4, 97, 46, 109, 46,
    2, 66, 113, 2, 99, 99, 2, 99, 100, 4, 67, 8725, 107, 103, 3, 67, 111, 46, 2, 100, 66, 2, 71,
    121, 2, 104, 97, 2, 72, 80, 2, 105, 110, 2, 75, 75, 2, 75, 77, 2, 107, 116, 2, 108, 109, 2,
    108, 110, 3, 108, 111, 103, 2, 108, 120, 2, 109, 98, 3, 109, 105, 108, 3, 109, 111, 108, 2, 80,
    72, 4, 112, 46, 109, 46, 3, 80, 80, 77, 2, 80, 82, 2, 115, 114, 2, 83, 118, 2, 87, 98, 3, 86,
    8725, 109, 3, 65, 8725, 109, 2, 49, 26085, 2, 50, 26085, 2, 51, 26085, 2, 52, 26085, 2, 53,
    26085, 2, 54, 26085, 2, 55, 26085, 2, 56, 26085, 2, 57, 26085, 3, 49, 48, 26085, 3, 49, 49,
    26085, 3, 49, 50, 26085, 3, 49, 51, 26085, 3, 49, 52, 26085, 3, 49, 53, 26085, 3, 49, 54,
    26085, 3, 49, 55, 26085, 3, 49, 56, 26085, 3, 49, 57, 26085, 3, 50, 48, 26085, 3, 50, 49,
    26085, 3, 50, 50, 26085, 3, 50, 51, 26085, 3, 50, 52, 26085, 3, 50, 53, 26085, 3, 50, 54,
    26085, 3, 50, 55, 26085, 3, 50, 56, 26085, 3, 50, 57, 26085, 3, 51, 48, 26085, 3, 51, 49,
    26085, 3, 103, 97, 108, 1, 1098, 1, 1100, 1, 42863, 1, 294, 1, 339, 1, 42791, 1, 43831, 1, 619,
    1, 43858, 1, 653, 2, 102, 102, 2, 102, 105, 2, 102, 108, 3, 102, 102, 105, 3, 102, 102, 108, 2,
    115, 116, 2, 115, 116, 2, 1396, 1398, 2, 1396, 1381, 2, 1396, 1387, 2, 1406, 1398, 2, 1396,
    1389, 1, 1506, 1, 1488, 1, 1491, 1, 1492, 1, 1499, 1, 1500, 1, 1501, 1, 1512, 1, 1514, 1, 43,
    2, 1488, 1500, 1, 1649, 1, 1649, 1, 1659, 1, 1659, 1, 1659, 1, 1659, 1, 1662, 1, 1662, 1, 1662,
    1, 1662, 1, 1664, 1, 1664, 1, 1664, 1, 1664, 1, 1658, 1, 1658, 1, 1658, 1, 1658, 1, 1663, 1,
    1663, 1, 1663, 1, 1663, 1, 1657, 1, 1657, 1, 1657, 1, 1657, 1, 1700, 1, 1700, 1, 1700, 1, 1700,
    1, 1702, 1, 1702, 1, 1702, 1, 1702, 1, 1668, 1, 1668, 1, 1668, 1, 1668, 1, 1667, 1, 1667, 1,
    1667, 1, 1667, 1, 1670, 1, 1670, 1, 1670, 1, 1670, 1, 1671, 1, 1671, 1, 1671, 1, 1671, 1, 1677,
    1, 1677, 1, 1676, 1, 1676, 1, 1678, 1, 1678, 1, 1672, 1, 1672, 1, 1688, 1, 1688, 1, 1681, 1,
    1681, 1, 1705, 1, 1705, 1, 1705, 1, 1705, 1, 1711, 1, 1711, 1, 1711, 1, 1711, 1, 1715, 1, 1715,
    1, 1715, 1, 1715, 1, 1713, 1, 1713, 1, 1713, 1, 1713, 1, 1722, 1, 1722, 1, 1723, 1, 1723, 1,
    1723, 1, 1723, 2, 1749, 1620, 2, 1749, 1620, 1, 1729, 1, 1729, 1, 1729, 1, 1729, 1, 1726, 1,
    1726, 1, 1726, 1, 1726, 1, 1746, 1, 1746, 2, 1746, 1620, 2, 1746, 1620, 1, 1709, 1, 1709, 1,
    1709, 1, 1709, 1, 1735, 1, 1735, 1, 1734, 1, 1734, 1, 1736, 1, 1736, 2, 1735, 1652, 1, 1739, 1,
    1739, 1, 1733, 1, 1733, 1, 1737, 1, 1737, 1, 1744, 1, 1744, 1, 1744, 1, 1744, 1, 1609, 1, 1609,
    3, 1610, 1620, 1575, 3, 1610, 1620, 1575, 3, 1610, 1620, 1749, 3, 1610, 1620, 1749, 3, 1610,
    1620, 1608, 3, 1610, 1620, 1608, 3, 1610, 1620, 1735, 3, 1610, 1620, 1735, 3, 1610, 1620, 1734,
    3, 1610, 1620, 1734, 3, 1610, 1620, 1736, 3, 1610, 1620, 1736, 3, 1610, 1620, 1744, 3, 1610,
    1620, 1744, 3, 1610, 1620, 1744, 3, 1610, 1620, 1609, 3, 1610, 1620, 1609, 3, 1610, 1620, 1609,
    1, 1740, 1, 1740, 1, 1740, 1, 1740, 3, 1610, 1620, 1580, 3, 1610, 1620, 1581, 3, 1610, 1620,
    1605, 3, 1610, 1620, 1609, 3, 1610, 1620, 1610, 2, 1576, 1580, 2, 1576, 1581, 2, 1576, 1582, 2,
    1576, 1605, 2, 1576, 1609, 2, 1576, 1610, 2, 1578, 1580, 2, 1578, 1581, 2, 1578, 1582, 2, 1578,
    1605, 2, 1578, 1609, 2, 1578, 1610, 2, 1579, 1580, 2, 1579, 1605, 2, 1579, 1609, 2, 1579, 1610,
    2, 1580, 1581, 2, 1580, 1605, 2, 1581, 1580, 2, 1581, 1605, 2, 1582, 1580, 2, 1582, 1581, 2,
    1582, 1605, 2, 1587, 1580, 2, 1587, 1581, 2, 1587, 1582, 2, 1587, 1605, 2, 1589, 1581, 2, 1589,
    1605, 2, 1590, 1580, 2, 1590, 1581, 2, 1590, 1582, 2, 1590, 1605, 2, 1591, 1581, 2, 1591, 1605,
    2, 1592, 1605, 2, 1593, 1580, 2, 1593, 1605, 2, 1594, 1580, 2, 1594, 1605, 2, 1601, 1580, 2,
    1601, 1581, 2, 1601, 1582, 2, 1601, 1605, 2, 1601, 1609, 2, 1601, 1610, 2, 1602, 1581, 2, 1602,
    1605, 2, 1602, 1609, 2, 1602, 1610, 2, 1603, 1575, 2, 1603, 1580, 2, 1603, 1581, 2, 1603, 1582,
    2, 1603, 1604, 2, 1603, 1605, 2, 1603, 1609, 2, 1603, 1610, 2, 1604, 1580, 2, 1604, 1581, 2,
    1604, 1582, 2, 1604, 1605, 2, 1604, 1609, 2, 1604, 1610, 2, 1605, 1580, 2, 1605, 1581, 2, 1605,
    1582, 2, 1605, 1605, 2, 1605, 1609, 2, 1605, 1610, 2, 1606, 1580, 2, 1606, 1581, 2, 1606, 1582,
    2, 1606, 1605, 2, 1606, 1609, 2, 1606, 1610, 2, 1607, 1580, 2, 1607, 1605, 2, 1607, 1609, 2,
    1607, 1610, 2, 1610, 1580, 2, 1610, 1581, 2, 1610, 1582, 2, 1610, 1605, 2, 1610, 1609, 2, 1610,
    1610, 2, 1584, 1648, 2, 1585, 1648, 2, 1609, 1648, 3, 32, 1612, 1617, 3, 32, 1613, 1617, 3, 32,
    1614, 1617, 3, 32, 1615, 1617, 3, 32, 1616, 1617, 3, 32, 1617, 1648, 3, 1610, 1620, 1585, 3,
    1610, 1620, 1586, 3, 1610, 1620, 1605, 3, 1610, 1620, 1606, 3, 1610, 1620, 1609, 3, 1610, 1620,
    1610, 2, 1576, 1585, 2, 1576, 1586, 2, 1576, 1605, 2, 1576, 1606, 2, 1576, 1609, 2, 1576, 1610,
    2, 1578, 1585, 2, 1578, 1586, 2, 1578, 1605, 2, 1578, 1606, 2, 1578, 1609, 2, 1578, 1610, 2,
    1579, 1585, 2, 1579, 1586, 2, 1579, 1605, 2, 1579, 1606, 2, 1579, 1609, 2, 1579, 1610, 2, 1601,
    1609, 2, 1601, 1610, 2, 1602, 1609, 2, 1602, 1610, 2, 1603, 1575, 2, 1603, 1604, 2, 1603, 1605,
    2, 1603, 1609, 2, 1603, 1610, 2, 1604, 1605, 2, 1604, 1609, 2, 1604, 1610, 2, 1605, 1575, 2,
    1605, 1605, 2, 1606, 1585, 2, 1606, 1586, 2, 1606, 1605, 2, 1606, 1606, 2, 1606, 1609, 2, 1606,
    1610, 2, 1609, 1648, 2, 1610, 1585, 2, 1610, 1586, 2, 1610, 1605, 2, 1610, 1606, 2, 1610, 1609,
    2, 1610, 1610, 3, 1610, 1620, 1580, 3, 1610, 1620, 1581, 3, 1610, 1620, 1582, 3, 1610, 1620,
    1605, 3, 1610, 1620, 1607, 2, 1576, 1580, 2, 1576, 1581, 2, 1576, 1582, 2, 1576, 1605, 2, 1576,
    1607, 2, 1578, 1580, 2, 1578, 1581, 2, 1578, 1582, 2, 1578, 1605, 2, 1578, 1607, 2, 1579, 1605,
    2, 1580, 1581, 2, 1580, 1605, 2, 1581, 1580, 2, 1581, 1605, 2, 1582, 1580, 2, 1582, 1605, 2,
    1587, 1580, 2, 1587, 1581, 2, 1587, 1582, 2, 1587, 1605, 2, 1589, 1581, 2, 1589, 1582, 2, 1589,
    1605, 2, 1590, 1580, 2, 1590, 1581, 2, 1590, 1582, 2, 1590, 1605, 2, 1591, 1581, 2, 1592, 1605,
    2, 1593, 1580, 2, 1593, 1605, 2, 1594, 1580, 2, 1594, 1605, 2, 1601, 1580, 2, 1601, 1581, 2,
    1601, 1582, 2, 1601, 1605, 2, 1602, 1581, 2, 1602, 1605, 2, 1603, 1580, 2, 1603, 1581, 2, 1603,
    1582, 2, 1603, 1604, 2, 1603, 1605, 2, 1604, 1580, 2, 1604, 1581, 2, 1604, 1582, 2, 1604, 1605,
    2, 1604, 1607, 2, 1605, 1580, 2, 1605, 1581, 2, 1605, 1582, 2, 1605, 1605, 2, 1606, 1580, 2,
    1606, 1581, 2, 1606, 1582, 2, 1606, 1605, 2, 1606, 1607, 2, 1607, 1580, 2, 1607, 1605, 2, 1607,
    1648, 2, 1610, 1580, 2, 1610, 1581, 2, 1610, 1582, 2, 1610, 1605, 2, 1610, 1607, 3, 1610, 1620,
    1605, 3, 1610, 1620, 1607, 2, 1576, 1605, 2, 1576, 1607, 2, 1578, 1605, 2, 1578, 1607, 2, 1579,
    1605, 2, 1579, 1607, 2, 1587, 1605, 2, 1587, 1607, 2, 1588, 1605, 2, 1588, 1607, 2, 1603, 1604,
    2, 1603, 1605, 2, 1604, 1605, 2, 1606, 1605, 2, 1606, 1607, 2, 1610, 1605, 2, 1610, 1607, 3,
    1600, 1614, 1617, 3, 1600, 1615, 1617, 3, 1600, 1616, 1617, 2, 1591, 1609, 2, 1591, 1610, 2,
    1593, 1609, 2, 1593, 1610, 2, 1594, 1609, 2, 1594, 1610, 2, 1587, 1609, 2, 1587, 1610, 2, 1588,
    1609, 2, 1588, 1610, 2, 1581, 1609, 2, 1581, 1610, 2, 1580, 1609, 2, 1580, 1610, 2, 1582, 1609,
    2, 1582, 1610, 2, 1589, 1609, 2, 1589, 1610, 2, 1590, 1609, 2, 1590, 1610, 2, 1588, 1580, 2,
    1588, 1581, 2, 1588, 1582, 2, 1588, 1605, 2, 1588, 1585, 2, 1587, 1585, 2, 1589, 1585, 2, 1590,
    1585, 2, 1591, 1609, 2, 1591, 1610, 2, 1593, 1609, 2, 1593, 1610, 2, 1594, 1609, 2, 1594, 1610,
    2, 1587, 1609, 2, 1587, 1610, 2, 1588, 1609, 2, 1588, 1610, 2, 1581, 1609, 2, 1581, 1610, 2,
    1580, 1609, 2, 1580, 1610, 2, 1582, 1609, 2, 1582, 1610, 2, 1589, 1609, 2, 1589, 1610, 2, 1590,
    1609, 2, 1590, 1610, 2, 1588, 1580, 2, 1588, 1581, 2, 1588, 1582, 2, 1588, 1605, 2, 1588, 1585,
    2, 1587, 1585, 2, 1589, 1585, 2, 1590, 1585, 2, 1588, 1580, 2, 1588, 1581, 2, 1588, 1582, 2,
    1588, 1605, 2, 1587, 1607, 2, 1588, 1607, 2, 1591, 1605, 2, 1587, 1580, 2, 1587, 1581, 2, 1587,
    1582, 2, 1588, 1580, 2, 1588, 1581, 2, 1588, 1582, 2, 1591, 1605, 2, 1592, 1605, 2, 1575, 1611,
    2, 1575, 1611, 3, 1578, 1580, 1605, 3, 1578, 1581, 1580, 3, 1578, 1581, 1580, 3, 1578, 1581,
    1605, 3, 1578, 1582, 1605, 3, 1578, 1605, 1580, 3, 1578, 1605, 1581, 3, 1578, 1605, 1582, 3,
    1580, 1605, 1581, 3, 1580, 1605, 1581, 3, 1581, 1605, 1610, 3, 1581, 1605, 1609, 3, 1587, 1581,
    1580, 3, 1587, 1580, 1581, 3, 1587, 1580, 1609, 3, 1587, 1605, 1581, 3, 1587, 1605, 1581, 3,
    1587, 1605, 1580, 3, 1587, 1605, 1605, 3, 1587, 1605, 1605, 3, 1589, 1581, 1581, 3, 1589, 1581,
    1581, 3, 1589, 1605, 1605, 3, 1588, 1581, 1605, 3, 1588, 1581, 1605, 3, 1588, 1580, 1610, 3,
    1588, 1605, 1582, 3, 1588, 1605, 1582, 3, 1588, 1605, 1605, 3, 1588, 1605, 1605, 3, 1590, 1581,
    1609, 3, 1590, 1582, 1605, 3, 1590, 1582, 1605, 3, 1591, 1605, 1581, 3, 1591, 1605, 1581, 3,
    1591, 1605, 1605, 3, 1591, 1605, 1610, 3, 1593, 1580, 1605, 3, 1593, 1605, 1605, 3, 1593, 1605,
    1605, 3, 1593, 1605, 1609, 3, 1594, 1605, 1605, 3, 1594, 1605, 1610, 3, 1594, 1605, 1609, 3,
    1601, 1582, 1605, 3, 1601, 1582, 1605, 3, 1602, 1605, 1581, 3, 1602, 1605, 1605, 3, 1604, 1581,
    1605, 3, 1604, 1581, 1610, 3, 1604, 1581, 1609, 3, 1604, 1580, 1580, 3, 1604, 1580, 1580, 3,
    1604, 1582, 1605, 3, 1604, 1582, 1605, 3, 1604, 1605, 1581, 3, 1604, 1605, 1581, 3, 1605, 1581,
    1580, 3, 1605, 1581, 1605, 3, 1605, 1581, 1610, 3, 1605, 1580, 1581, 3, 1605, 1580, 1605, 3,
    1605, 1582, 1580, 3, 1605, 1582, 1605, 3, 1605, 1580, 1582, 3, 1607, 1605, 1580, 3, 1607, 1605,
    1605, 3, 1606, 1581, 1605, 3, 1606, 1581, 1609, 3, 1606, 1580, 1605, 3, 1606, 1580, 1605, 3,
    1606, 1580, 1609, 3, 1606, 1605, 1610, 3, 1606, 1605, 1609, 3, 1610, 1605, 1605, 3, 1610, 1605,
    1605, 3, 1576, 1582, 1610, 3, 1578, 1580, 1610, 3, 1578, 1580, 1609, 3, 1578, 1582, 1610, 3,
    1578, 1582, 1609, 3, 1578, 1605, 1610, 3, 1578, 1605, 1609, 3, 1580, 1605, 1610, 3, 1580, 1581,
    1609, 3, 1580, 1605, 1609, 3, 1587, 1582, 1609, 3, 1589, 1581, 1610, 3, 1588, 1581, 1610, 3,
    1590, 1581, 1610, 3, 1604, 1580, 1610, 3, 1604, 1605, 1610, 3, 1610, 1581, 1610, 3, 1610, 1580,
    1610, 3, 1610, 1605, 1610, 3, 1605, 1605, 1610, 3, 1602, 1605, 1610, 3, 1606, 1581, 1610, 3,
    1602, 1605, 1581, 3, 1604, 1581, 1605, 3, 1593, 1605, 1610, 3, 1603, 1605, 1610, 3, 1606, 1580,
    1581, 3, 1605, 1582, 1610, 3, 1604, 1580, 1605, 3, 1603, 1605, 1605, 3, 1604, 1580, 1605, 3,
    1606, 1580, 1581, 3, 1580, 1581, 1610, 3, 1581, 1580, 1610, 3, 1605, 1580, 1610, 3, 1601, 1605,
    1610, 3, 1576, 1581, 1610, 3, 1603, 1605, 1605, 3, 1593, 1580, 1605, 3, 1589, 1605, 1605, 3,
    1587, 1582, 1610, 3, 1606, 1580, 1610, 3, 1589, 1604, 1746, 3, 1602, 1604, 1746, 4, 1575, 1604,
    1604, 1607, 4, 1575, 1603, 1576, 1585, 4, 1605, 1581, 1605, 1583, 4, 1589, 1604, 1593, 1605, 4,
    1585, 1587, 1608, 1604, 4, 1593, 1604, 1610, 1607, 4, 1608, 1587, 1604, 1605, 3, 1589, 1604,
    1609, 18, 1589, 1604, 1609, 32, 1575, 1604, 1604, 1607, 32, 1593, 1604, 1610, 1607, 32, 1608,
    1587, 1604, 1605, 8, 1580, 1604, 32, 1580, 1604, 1575, 1604, 1607, 4, 1585, 1740, 1575, 1604,
    1, 44, 1, 12289, 1, 12290, 1, 58, 1, 59, 1, 33, 1, 63, 1, 12310, 1, 12311, 3, 46, 46, 46, 2,
    46, 46, 1, 8212, 1, 8211, 1, 95, 1, 95, 1, 40, 1, 41, 1, 123, 1, 125, 1, 12308, 1, 12309, 1,
    12304, 1, 12305, 1, 12298, 1, 12299, 1, 12296, 1, 12297, 1, 12300, 1, 12301, 1, 12302, 1,
    12303, 1, 91, 1, 93, 2, 32, 773, 2, 32, 773, 2, 32, 773, 2, 32, 773, 1, 95, 1, 95, 1, 95, 1,
    44, 1, 12289, 1, 46, 1, 59, 1, 58, 1, 63, 1, 33, 1, 8212, 1, 40, 1, 41, 1, 123, 1, 125, 1,
    12308, 1, 12309, 1, 35, 1, 38, 1, 42, 1, 43, 1, 45, 1, 60, 1, 62, 1, 61, 1, 92, 1, 36, 1, 37,
    1, 64, 2, 32, 1611, 2, 1600, 1611, 2, 32, 1612, 2, 32, 1613, 2, 32, 1614, 2, 1600, 1614, 2, 32,
    1615, 2, 1600, 1615, 2, 32, 1616, 2, 1600, 1616, 2, 32, 1617, 2, 1600, 1617, 2, 32, 1618, 2,
    1600, 1618, 1, 1569, 2, 1575, 1619, 2, 1575, 1619, 2, 1575, 1620, 2, 1575, 1620, 2, 1608, 1620,
    2, 1608, 1620, 2, 1575, 1621, 2, 1575, 1621, 2, 1610, 1620, 2, 1610, 1620, 2, 1610, 1620, 2,
    1610, 1620, 1, 1575, 1, 1575, 1, 1576, 1, 1576, 1, 1576, 1, 1576, 1, 1577, 1, 1577, 1, 1578, 1,
    1578, 1, 1578, 1, 1578, 1, 1579, 1, 1579, 1, 1579, 1, 1579, 1, 1580, 1, 1580, 1, 1580, 1, 1580,
    1, 1581, 1, 1581, 1, 1581, 1, 1581, 1, 1582, 1, 1582, 1, 1582, 1, 1582, 1, 1583, 1, 1583, 1,
    1584, 1, 1584, 1, 1585, 1, 1585, 1, 1586, 1, 1586, 1, 1587, 1, 1587, 1, 1587, 1, 1587, 1, 1588,
    1, 1588, 1, 1588, 1, 1588, 1, 1589, 1, 1589, 1, 1589, 1, 1589, 1, 1590, 1, 1590, 1, 1590, 1,
    1590, 1, 1591, 1, 1591, 1, 1591, 1, 1591, 1, 1592, 1, 1592, 1, 1592, 1, 1592, 1, 1593, 1, 1593,
    1, 1593, 1, 1593, 1, 1594, 1, 1594, 1, 1594, 1, 1594, 1, 1601, 1, 1601, 1, 1601, 1, 1601, 1,
    1602, 1, 1602, 1, 1602, 1, 1602, 1, 1603, 1, 1603, 1, 1603, 1, 1603, 1, 1604, 1, 1604, 1, 1604,
    1, 1604, 1, 1605, 1, 1605, 1, 1605, 1, 1605, 1, 1606, 1, 1606, 1, 1606, 1, 1606, 1, 1607, 1,
    1607, 1, 1607, 1, 1607, 1, 1608, 1, 1608, 1, 1609, 1, 1609, 1, 1610, 1, 1610, 1, 1610, 1, 1610,
    3, 1604, 1575, 1619, 3, 1604, 1575, 1619, 3, 1604, 1575, 1620, 3, 1604, 1575, 1620, 3, 1604,
    1575, 1621, 3, 1604, 1575, 1621, 2, 1604, 1575, 2, 1604, 1575, 1, 33, 1, 34, 1, 35, 1, 36, 1,
    37, 1, 38, 1, 39, 1, 40, 1, 41, 1, 42, 1, 43, 1, 44, 1, 45, 1, 46, 1, 47, 1, 48, 1, 49, 1, 50,
    1, 51, 1, 52, 1, 53, 1, 54, 1, 55, 1, 56, 1, 57, 1, 58, 1, 59, 1, 60, 1, 61, 1, 62, 1, 63, 1,
    64, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71, 1, 72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77,
    1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 90, 1,
    91, 1, 92, 1, 93, 1, 94, 1, 95, 1, 96, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1,
    104, 1, 105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1,
    116, 1, 117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 123, 1, 124, 1, 125, 1, 126, 1, 10629,
    1, 10630, 1, 12290, 1, 12300, 1, 12301, 1, 12289, 1, 12539, 1, 12530, 1, 12449, 1, 12451, 1,
    12453, 1, 12455, 1, 12457, 1, 12515, 1, 12517, 1, 12519, 1, 12483, 1, 12540, 1, 12450, 1,
    12452, 1, 12454, 1, 12456, 1, 12458, 1, 12459, 1, 12461, 1, 12463, 1, 12465, 1, 12467, 1,
    12469, 1, 12471, 1, 12473, 1, 12475, 1, 12477, 1, 12479, 1, 12481, 1, 12484, 1, 12486, 1,
    12488, 1, 12490, 1, 12491, 1, 12492, 1, 12493, 1, 12494, 1, 12495, 1, 12498, 1, 12501, 1,
    12504, 1, 12507, 1, 12510, 1, 12511, 1, 12512, 1, 12513, 1, 12514, 1, 12516, 1, 12518, 1,
    12520, 1, 12521, 1, 12522, 1, 12523, 1, 12524, 1, 12525, 1, 12527, 1, 12531, 1, 12441, 1,
    12442, 1, 4448, 1, 4352, 1, 4353, 1, 4522, 1, 4354, 1, 4524, 1, 4525, 1, 4355, 1, 4356, 1,
    4357, 1, 4528, 1, 4529, 1, 4530, 1, 4531, 1, 4532, 1, 4533, 1, 4378, 1, 4358, 1, 4359, 1, 4360,
    1, 4385, 1, 4361, 1, 4362, 1, 4363, 1, 4364, 1, 4365, 1, 4366, 1, 4367, 1, 4368, 1, 4369, 1,
    4370, 1, 4449, 1, 4450, 1, 4451, 1, 4452, 1, 4453, 1, 4454, 1, 4455, 1, 4456, 1, 4457, 1, 4458,
    1, 4459, 1, 4460, 1, 4461, 1, 4462, 1, 4463, 1, 4464, 1, 4465, 1, 4466, 1, 4467, 1, 4468, 1,
    4469, 1, 162, 1, 163, 1, 172, 2, 32, 772, 1, 166, 1, 165, 1, 8361, 1, 9474, 1, 8592, 1, 8593,
    1, 8594, 1, 8595, 1, 9632, 1, 9675, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71, 1, 72, 1,
    73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86,
    1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1, 104, 1,
    105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1, 116, 1,
    117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71,
    1, 72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1,
    85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1,
    105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1, 116, 1,
    117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71,
    1, 72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1,
    85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1,
    104, 1, 105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1,
    116, 1, 117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 67, 1, 68, 1, 71, 1, 74, 1, 75,
    1, 78, 1, 79, 1, 80, 1, 81, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1,
    98, 1, 99, 1, 100, 1, 102, 1, 104, 1, 105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 112, 1,
    113, 1, 114, 1, 115, 1, 116, 1, 117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 66, 1,
    67, 1, 68, 1, 69, 1, 70, 1, 71, 1, 72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80,
    1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1,
    100, 1, 101, 1, 102, 1, 103, 1, 104, 1, 105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1,
    112, 1, 113, 1, 114, 1, 115, 1, 116, 1, 117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1,
    66, 1, 68, 1, 69, 1, 70, 1, 71, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 83,
    1, 84, 1, 85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103,
    1, 104, 1, 105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115,
    1, 116, 1, 117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 66, 1, 68, 1, 69, 1, 70, 1,
    71, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 79, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87, 1, 88, 1, 89,
    1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1, 104, 1, 105, 1, 106, 1, 107, 1, 108, 1,
    109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1, 116, 1, 117, 1, 118, 1, 119, 1, 120, 1,
    121, 1, 122, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71, 1, 72, 1, 73, 1, 74, 1, 75, 1,
    76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87, 1, 88, 1, 89,
    1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1, 104, 1, 105, 1, 106, 1, 107, 1,
    108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1, 116, 1, 117, 1, 118, 1, 119, 1,
    120, 1, 121, 1, 122, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71, 1, 72, 1, 73, 1, 74, 1,
    75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87, 1, 88,
    1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1, 104, 1, 105, 1, 106, 1,
    107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1, 116, 1, 117, 1, 118, 1,
    119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71, 1, 72, 1, 73, 1,
    74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87,
    1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1, 104, 1, 105, 1,
    106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1, 116, 1, 117, 1,
    118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71, 1, 72, 1,
    73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1, 85, 1, 86,
    1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1, 104, 1,
    105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1, 116, 1,
    117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70, 1, 71,
    1, 72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1, 84, 1,
    85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1, 103, 1,
    104, 1, 105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1, 115, 1,
    116, 1, 117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 65, 1, 66, 1, 67, 1, 68, 1, 69, 1, 70,
    1, 71, 1, 72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81, 1, 82, 1, 83, 1,
    84, 1, 85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 90, 1, 97, 1, 98, 1, 99, 1, 100, 1, 101, 1, 102, 1,
    103, 1, 104, 1, 105, 1, 106, 1, 107, 1, 108, 1, 109, 1, 110, 1, 111, 1, 112, 1, 113, 1, 114, 1,
    115, 1, 116, 1, 117, 1, 118, 1, 119, 1, 120, 1, 121, 1, 122, 1, 305, 1, 567, 1, 913, 1, 914, 1,
    915, 1, 916, 1, 917, 1, 918, 1, 919, 1, 920, 1, 921, 1, 922, 1, 923, 1, 924, 1, 925, 1, 926, 1,
    927, 1, 928, 1, 929, 1, 920, 1, 931, 1, 932, 1, 933, 1, 934, 1, 935, 1, 936, 1, 937, 1, 8711,
    1, 945, 1, 946, 1, 947, 1, 948, 1, 949, 1, 950, 1, 951, 1, 952, 1, 953, 1, 954, 1, 955, 1, 956,
    1, 957, 1, 958, 1, 959, 1, 960, 1, 961, 1, 962, 1, 963, 1, 964, 1, 965, 1, 966, 1, 967, 1, 968,
    1, 969, 1, 8706, 1, 949, 1, 952, 1, 954, 1, 966, 1, 961, 1, 960, 1, 913, 1, 914, 1, 915, 1,
    916, 1, 917, 1, 918, 1, 919, 1, 920, 1, 921, 1, 922, 1, 923, 1, 924, 1, 925, 1, 926, 1, 927, 1,
    928, 1, 929, 1, 920, 1, 931, 1, 932, 1, 933, 1, 934, 1, 935, 1, 936, 1, 937, 1, 8711, 1, 945,
    1, 946, 1, 947, 1, 948, 1, 949, 1, 950, 1, 951, 1, 952, 1, 953, 1, 954, 1, 955, 1, 956, 1, 957,
    1, 958, 1, 959, 1, 960, 1, 961, 1, 962, 1, 963, 1, 964, 1, 965, 1, 966, 1, 967, 1, 968, 1, 969,
    1, 8706, 1, 949, 1, 952, 1, 954, 1, 966, 1, 961, 1, 960, 1, 913, 1, 914, 1, 915, 1, 916, 1,
    917, 1, 918, 1, 919, 1, 920, 1, 921, 1, 922, 1, 923, 1, 924, 1, 925, 1, 926, 1, 927, 1, 928, 1,
    929, 1, 920, 1, 931, 1, 932, 1, 933, 1, 934, 1, 935, 1, 936, 1, 937, 1, 8711, 1, 945, 1, 946,
    1, 947, 1, 948, 1, 949, 1, 950, 1, 951, 1, 952, 1, 953, 1, 954, 1, 955, 1, 956, 1, 957, 1, 958,
    1, 959, 1, 960, 1, 961, 1, 962, 1, 963, 1, 964, 1, 965, 1, 966, 1, 967, 1, 968, 1, 969, 1,
    8706, 1, 949, 1, 952, 1, 954, 1, 966, 1, 961, 1, 960, 1, 913, 1, 914, 1, 915, 1, 916, 1, 917,
    1, 918, 1, 919, 1, 920, 1, 921, 1, 922, 1, 923, 1, 924, 1, 925, 1, 926, 1, 927, 1, 928, 1, 929,
    1, 920, 1, 931, 1, 932, 1, 933, 1, 934, 1, 935, 1, 936, 1, 937, 1, 8711, 1, 945, 1, 946, 1,
    947, 1, 948, 1, 949, 1, 950, 1, 951, 1, 952, 1, 953, 1, 954, 1, 955, 1, 956, 1, 957, 1, 958, 1,
    959, 1, 960, 1, 961, 1, 962, 1, 963, 1, 964, 1, 965, 1, 966, 1, 967, 1, 968, 1, 969, 1, 8706,
    1, 949, 1, 952, 1, 954, 1, 966, 1, 961, 1, 960, 1, 913, 1, 914, 1, 915, 1, 916, 1, 917, 1, 918,
    1, 919, 1, 920, 1, 921, 1, 922, 1, 923, 1, 924, 1, 925, 1, 926, 1, 927, 1, 928, 1, 929, 1, 920,
    1, 931, 1, 932, 1, 933, 1, 934, 1, 935, 1, 936, 1, 937, 1, 8711, 1, 945, 1, 946, 1, 947, 1,
    948, 1, 949, 1, 950, 1, 951, 1, 952, 1, 953, 1, 954, 1, 955, 1, 956, 1, 957, 1, 958, 1, 959, 1,
    960, 1, 961, 1, 962, 1, 963, 1, 964, 1, 965, 1, 966, 1, 967, 1, 968, 1, 969, 1, 8706, 1, 949,
    1, 952, 1, 954, 1, 966, 1, 961, 1, 960, 1, 988, 1, 989, 1, 48, 1, 49, 1, 50, 1, 51, 1, 52, 1,
    53, 1, 54, 1, 55, 1, 56, 1, 57, 1, 48, 1, 49, 1, 50, 1, 51, 1, 52, 1, 53, 1, 54, 1, 55, 1, 56,
    1, 57, 1, 48, 1, 49, 1, 50, 1, 51, 1, 52, 1, 53, 1, 54, 1, 55, 1, 56, 1, 57, 1, 48, 1, 49, 1,
    50, 1, 51, 1, 52, 1, 53, 1, 54, 1, 55, 1, 56, 1, 57, 1, 48, 1, 49, 1, 50, 1, 51, 1, 52, 1, 53,
    1, 54, 1, 55, 1, 56, 1, 57, 1, 1575, 1, 1576, 1, 1580, 1, 1583, 1, 1608, 1, 1586, 1, 1581, 1,
    1591, 1, 1610, 1, 1603, 1, 1604, 1, 1605, 1, 1606, 1, 1587, 1, 1593, 1, 1601, 1, 1589, 1, 1602,
    1, 1585, 1, 1588, 1, 1578, 1, 1579, 1, 1582, 1, 1584, 1, 1590, 1, 1592, 1, 1594, 1, 1646, 1,
    1722, 1, 1697, 1, 1647, 1, 1576, 1, 1580, 1, 1607, 1, 1581, 1, 1610, 1, 1603, 1, 1604, 1, 1605,
    1, 1606, 1, 1587, 1, 1593, 1, 1601, 1, 1589, 1, 1602, 1, 1588, 1, 1578, 1, 1579, 1, 1582, 1,
    1590, 1, 1594, 1, 1580, 1, 1581, 1, 1610, 1, 1604, 1, 1606, 1, 1587, 1, 1593, 1, 1589, 1, 1602,
    1, 1588, 1, 1582, 1, 1590, 1, 1594, 1, 1722, 1, 1647, 1, 1576, 1, 1580, 1, 1607, 1, 1581, 1,
    1591, 1, 1610, 1, 1603, 1, 1605, 1, 1606, 1, 1587, 1, 1593, 1, 1601, 1, 1589, 1, 1602, 1, 1588,
    1, 1578, 1, 1579, 1, 1582, 1, 1590, 1, 1592, 1, 1594, 1, 1646, 1, 1697, 1, 1575, 1, 1576, 1,
    1580, 1, 1583, 1, 1607, 1, 1608, 1, 1586, 1, 1581, 1, 1591, 1, 1610, 1, 1604, 1, 1605, 1, 1606,
    1, 1587, 1, 1593, 1, 1601, 1, 1589, 1, 1602, 1, 1585, 1, 1588, 1, 1578, 1, 1579, 1, 1582, 1,
    1584, 1, 1590, 1, 1592, 1, 1594, 1, 1576, 1, 1580, 1, 1583, 1, 1608, 1, 1586, 1, 1581, 1, 1591,
    1, 1610, 1, 1604, 1, 1605, 1, 1606, 1, 1587, 1, 1593, 1, 1601, 1, 1589, 1, 1602, 1, 1585, 1,
    1588, 1, 1578, 1, 1579, 1, 1582, 1, 1584, 1, 1590, 1, 1592, 1, 1594, 2, 48, 46, 2, 48, 44, 2,
    49, 44, 2, 50, 44, 2, 51, 44, 2, 52, 44, 2, 53, 44, 2, 54, 44, 2, 55, 44, 2, 56, 44, 2, 57, 44,
    3, 40, 65, 41, 3, 40, 66, 41, 3, 40, 67, 41, 3, 40, 68, 41, 3, 40, 69, 41, 3, 40, 70, 41, 3,
    40, 71, 41, 3, 40, 72, 41, 3, 40, 73, 41, 3, 40, 74, 41, 3, 40, 75, 41, 3, 40, 76, 41, 3, 40,
    77, 41, 3, 40, 78, 41, 3, 40, 79, 41, 3, 40, 80, 41, 3, 40, 81, 41, 3, 40, 82, 41, 3, 40, 83,
    41, 3, 40, 84, 41, 3, 40, 85, 41, 3, 40, 86, 41, 3, 40, 87, 41, 3, 40, 88, 41, 3, 40, 89, 41,
    3, 40, 90, 41, 3, 12308, 83, 12309, 1, 67, 1, 82, 2, 67, 68, 2, 87, 90, 1, 65, 1, 66, 1, 67, 1,
    68, 1, 69, 1, 70, 1, 71, 1, 72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 78, 1, 79, 1, 80, 1, 81,
    1, 82, 1, 83, 1, 84, 1, 85, 1, 86, 1, 87, 1, 88, 1, 89, 1, 90, 2, 72, 86, 2, 77, 86, 2, 83, 68,
    2, 83, 83, 3, 80, 80, 86, 2, 87, 67, 2, 77, 67, 2, 77, 68, 2, 77, 82, 2, 68, 74, 2, 12411,
    12363, 2, 12467, 12467, 1, 12469, 1, 25163, 1, 23383, 1, 21452, 2, 12486, 12441, 1, 20108, 1,
    22810, 1, 35299, 1, 22825, 1, 20132, 1, 26144, 1, 28961, 1, 26009, 1, 21069, 1, 24460, 1,
    20877, 1, 26032, 1, 21021, 1, 32066, 1, 29983, 1, 36009, 1, 22768, 1, 21561, 1, 28436, 1,
    25237, 1, 25429, 1, 19968, 1, 19977, 1, 36938, 1, 24038, 1, 20013, 1, 21491, 1, 25351, 1,
    36208, 1, 25171, 1, 31105, 1, 31354, 1, 21512, 1, 28288, 1, 26377, 1, 26376, 1, 30003, 1,
    21106, 1, 21942, 1, 37197, 3, 12308, 26412, 12309, 3, 12308, 19977, 12309, 3, 12308, 20108,
    12309, 3, 12308, 23433, 12309, 3, 12308, 28857, 12309, 3, 12308, 25171, 12309, 3, 12308, 30423,
    12309, 3, 12308, 21213, 12309, 3, 12308, 25943, 12309, 1, 24471, 1, 21487, 1, 48, 1, 49, 1, 50,
    1, 51, 1, 52, 1, 53, 1, 54, 1, 55, 1, 56, 1, 57,
];
