/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IFindReplaceTargetExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.eclipse.ui.internal.findandreplace.IFindReplaceLogic;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.status.FindAllStatus;
import org.eclipse.ui.internal.findandreplace.status.FindStatus;
import org.eclipse.ui.internal.findandreplace.status.IFindReplaceStatus;
import org.eclipse.ui.internal.findandreplace.status.InvalidRegExStatus;
import org.eclipse.ui.internal.findandreplace.status.NoStatus;
import org.eclipse.ui.internal.findandreplace.status.ReplaceAllStatus;
import org.eclipse.ui.internal.texteditor.NLSUtility;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IFindReplaceTargetExtension2;

public class FindReplaceLogic
implements IFindReplaceLogic {
    private IFindReplaceStatus status;
    private IFindReplaceTarget target;
    private Point incrementalBaseLocation;
    private boolean isTargetSupportingRegEx;
    private boolean isTargetEditable;
    private Set<SearchOptions> searchOptions = new HashSet<SearchOptions>();
    private String findString = "";
    private String replaceString = "";

    @Override
    public void setFindString(String findString) {
        this.findString = Objects.requireNonNull(findString);
        if (this.isAvailableAndActive(SearchOptions.INCREMENTAL)) {
            this.performSearch(true);
        }
    }

    @Override
    public void setReplaceString(String replaceString) {
        this.replaceString = Objects.requireNonNull(replaceString);
    }

    @Override
    public void activate(SearchOptions searchOption) {
        if (!this.searchOptions.add(searchOption)) {
            return;
        }
        switch (searchOption) {
            case GLOBAL: {
                this.unsetSearchScope();
                break;
            }
            case FORWARD: 
            case INCREMENTAL: {
                if (!this.shouldInitIncrementalBaseLocation()) break;
                this.resetIncrementalBaseLocation();
                break;
            }
        }
    }

    @Override
    public void deactivate(SearchOptions searchOption) {
        if (!this.searchOptions.remove((Object)searchOption)) {
            return;
        }
        if (searchOption == SearchOptions.GLOBAL) {
            this.initializeSearchScope();
        }
        if (searchOption == SearchOptions.FORWARD && this.shouldInitIncrementalBaseLocation()) {
            this.resetIncrementalBaseLocation();
        }
    }

    @Override
    public boolean isActive(SearchOptions searchOption) {
        return this.searchOptions.contains((Object)searchOption);
    }

    @Override
    public IFindReplaceStatus getStatus() {
        if (this.status == null) {
            return new NoStatus();
        }
        return this.status;
    }

    private void resetStatus() {
        this.status = null;
    }

    @Override
    public boolean isAvailable(SearchOptions searchOption) {
        switch (searchOption) {
            case REGEX: {
                return this.isTargetSupportingRegEx;
            }
            case WHOLE_WORD: {
                return !this.isAvailableAndActive(SearchOptions.REGEX) && FindReplaceLogic.isWord(this.findString);
            }
        }
        return true;
    }

    @Override
    public boolean isAvailableAndActive(SearchOptions searchOption) {
        return this.isAvailable(searchOption) && this.isActive(searchOption);
    }

    private static boolean isWord(String str) {
        return str != null && str.chars().allMatch(Character::isJavaIdentifierPart);
    }

    @Override
    public void resetIncrementalBaseLocation() {
        this.incrementalBaseLocation = this.target != null && this.shouldInitIncrementalBaseLocation() ? this.target.getSelection() : new Point(0, 0);
    }

    public boolean shouldInitIncrementalBaseLocation() {
        return this.isActive(SearchOptions.INCREMENTAL);
    }

    private void initializeSearchScope() {
        if (this.shouldInitIncrementalBaseLocation()) {
            this.resetIncrementalBaseLocation();
        }
        if (this.target == null || !(this.target instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension extensionTarget = (IFindReplaceTargetExtension)this.target;
        Point lineSelection = extensionTarget.getLineSelection();
        Region scope = new Region(lineSelection.x, lineSelection.y);
        int offset = this.isAvailableAndActive(SearchOptions.FORWARD) ? scope.getOffset() : scope.getOffset() + scope.getLength();
        extensionTarget.setSelection(offset, 0);
        extensionTarget.setScope((IRegion)scope);
    }

    private void unsetSearchScope() {
        if (this.target == null || !(this.target instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension extensionTarget = (IFindReplaceTargetExtension)this.target;
        extensionTarget.setScope(null);
    }

    private IEditorStatusLine getStatusLineManager() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
    }

    @Override
    public void performReplaceAll() {
        this.resetStatus();
        if (this.findString != null && !this.findString.isEmpty()) {
            try {
                int replaceCount = this.replaceAll();
                if (replaceCount != 0) {
                    if (replaceCount == 1) {
                        this.statusLineMessage(FindReplaceMessages.FindReplace_Status_replacement_label);
                    } else {
                        String msg = FindReplaceMessages.FindReplace_Status_replacements_label;
                        msg = NLSUtility.format(msg, String.valueOf(replaceCount));
                        this.statusLineMessage(msg);
                    }
                    this.status = new ReplaceAllStatus(replaceCount);
                } else {
                    String msg = NLSUtility.format(FindReplaceMessages.FindReplace_Status_noMatchWithValue_label, this.findString);
                    this.statusLineMessage(false, msg);
                    this.status = new FindStatus(FindStatus.StatusCode.NO_MATCH);
                }
            }
            catch (PatternSyntaxException ex) {
                this.status = new InvalidRegExStatus(ex);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void performSelectAll() {
        this.resetStatus();
        if (this.findString != null && !this.findString.isEmpty()) {
            try {
                int selectCount = this.selectAll();
                if (selectCount != 0) {
                    if (selectCount == 1) {
                        this.statusLineMessage(FindReplaceMessages.FindReplace_Status_selection_label);
                    } else {
                        String msg = FindReplaceMessages.FindReplace_Status_selections_label;
                        msg = NLSUtility.format(msg, String.valueOf(selectCount));
                        this.statusLineMessage(msg);
                    }
                    this.status = new FindAllStatus(selectCount);
                } else {
                    String msg = NLSUtility.format(FindReplaceMessages.FindReplace_Status_noMatchWithValue_label, this.findString);
                    this.statusLineMessage(false, msg);
                    this.status = new FindStatus(FindStatus.StatusCode.NO_MATCH);
                }
            }
            catch (PatternSyntaxException ex) {
                this.status = new InvalidRegExStatus(ex);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private boolean prepareTargetForEditing() {
        IFindReplaceTargetExtension2 extension;
        if (this.target instanceof IFindReplaceTargetExtension2 && !(extension = (IFindReplaceTargetExtension2)this.target).validateTargetState()) {
            this.status = new FindStatus(FindStatus.StatusCode.READONLY);
            return false;
        }
        return this.isEditable();
    }

    @Override
    public boolean performSearch() {
        boolean result = this.performSearch(false);
        this.resetIncrementalBaseLocation();
        return result;
    }

    private boolean performSearch(boolean updateFromIncrementalBaseLocation) {
        this.resetStatus();
        if (this.findString.isEmpty()) {
            return false;
        }
        boolean somethingFound = false;
        try {
            somethingFound = this.findNext(updateFromIncrementalBaseLocation);
            return somethingFound;
        }
        catch (PatternSyntaxException ex) {
            this.status = new InvalidRegExStatus(ex);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return somethingFound;
    }

    private int replaceAll() {
        if (!this.prepareTargetForEditing()) {
            return 0;
        }
        ArrayList replacements = new ArrayList();
        this.executeInForwardMode(() -> this.executeWithReplaceAllEnabled(() -> {
            Point currentSelection = new Point(0, 0);
            while (this.findAndSelect(currentSelection.x + currentSelection.y) != -1) {
                currentSelection = this.replaceSelection();
                replacements.add(currentSelection);
            }
        }));
        return replacements.size();
    }

    private void executeInForwardMode(Runnable runnable) {
        if (this.isActive(SearchOptions.FORWARD)) {
            runnable.run();
        } else {
            this.activate(SearchOptions.FORWARD);
            try {
                runnable.run();
            }
            finally {
                this.deactivate(SearchOptions.FORWARD);
            }
        }
    }

    private void executeWithReplaceAllEnabled(Runnable runnable) {
        IFindReplaceTarget iFindReplaceTarget = this.target;
        if (iFindReplaceTarget instanceof IFindReplaceTargetExtension) {
            IFindReplaceTargetExtension selectableTarget = (IFindReplaceTargetExtension)iFindReplaceTarget;
            selectableTarget.setReplaceAllMode(true);
            try {
                runnable.run();
            }
            finally {
                selectableTarget.setReplaceAllMode(false);
            }
        } else {
            runnable.run();
        }
    }

    private int selectAll() {
        ArrayList selections = new ArrayList();
        this.executeInForwardMode(() -> {
            Point currentSeletion = new Point(0, 0);
            while (this.findAndSelect(currentSeletion.x + currentSeletion.y) != -1) {
                currentSeletion = this.target.getSelection();
                selections.add(currentSeletion);
            }
            IFindReplaceTarget iFindReplaceTarget = this.target;
            if (iFindReplaceTarget instanceof IFindReplaceTargetExtension4) {
                IFindReplaceTargetExtension4 selectableTarget = (IFindReplaceTargetExtension4)iFindReplaceTarget;
                IRegion[] selectedRegions = (IRegion[])selections.stream().map(selection -> new Region(selection.x, selection.y)).toArray(IRegion[]::new);
                selectableTarget.setSelection(selectedRegions);
            }
        });
        return selections.size();
    }

    private int findIndex(int startPosition) {
        int index = 0;
        if (this.isAvailableAndActive(SearchOptions.FORWARD)) {
            index = this.findAndSelect(startPosition);
        } else {
            int n = index = startPosition == 0 ? -1 : this.findAndSelect(startPosition - 1);
        }
        if (index == -1) {
            if (this.isAvailableAndActive(SearchOptions.WRAP)) {
                this.statusLineMessage(FindReplaceMessages.FindReplace_Status_wrapped_label);
                this.status = new FindStatus(FindStatus.StatusCode.WRAPPED);
                index = this.findAndSelect(-1);
            } else {
                this.status = new FindStatus(FindStatus.StatusCode.NO_MATCH);
            }
        }
        return index;
    }

    @Override
    public int findAndSelect(int offset) {
        boolean wholeWordSearch = this.isAvailableAndActive(SearchOptions.WHOLE_WORD);
        boolean forwardSearch = this.isAvailableAndActive(SearchOptions.FORWARD);
        boolean caseSensitiveSearch = this.isAvailableAndActive(SearchOptions.CASE_SENSITIVE);
        boolean regexSearch = this.isAvailableAndActive(SearchOptions.REGEX);
        IFindReplaceTarget iFindReplaceTarget = this.target;
        if (iFindReplaceTarget instanceof IFindReplaceTargetExtension3) {
            IFindReplaceTargetExtension3 regexSupportingTarget = (IFindReplaceTargetExtension3)iFindReplaceTarget;
            return regexSupportingTarget.findAndSelect(offset, this.findString, forwardSearch, caseSensitiveSearch, wholeWordSearch, regexSearch);
        }
        return this.target.findAndSelect(offset, this.findString, forwardSearch, caseSensitiveSearch, wholeWordSearch);
    }

    private Point replaceSelection() {
        if (this.target instanceof IFindReplaceTargetExtension3) {
            ((IFindReplaceTargetExtension3)this.target).replaceSelection(this.replaceString, this.isAvailableAndActive(SearchOptions.REGEX));
        } else {
            this.target.replaceSelection(this.replaceString);
        }
        return this.target.getSelection();
    }

    private boolean findNext(boolean updateFromIncrementalBaseLocation) {
        if (this.target == null) {
            return false;
        }
        int findReplacePosition = this.calculateFindBeginningOffset(updateFromIncrementalBaseLocation);
        int index = this.findIndex(findReplacePosition);
        if (index == -1) {
            String msg = NLSUtility.format(FindReplaceMessages.FindReplace_Status_noMatchWithValue_label, this.findString);
            this.statusLineMessage(false, msg);
            this.status = new FindStatus(FindStatus.StatusCode.NO_MATCH);
            return false;
        }
        if (this.isActive(SearchOptions.FORWARD) && index >= findReplacePosition || !this.isActive(SearchOptions.FORWARD) && index <= findReplacePosition) {
            this.statusLineMessage("");
        }
        return true;
    }

    private int calculateFindBeginningOffset(boolean updateFromExistingBaseLocation) {
        Point r = null;
        r = updateFromExistingBaseLocation ? this.incrementalBaseLocation : this.target.getSelection();
        int findReplacePosition = r.x;
        if (!this.isActive(SearchOptions.FORWARD)) {
            findReplacePosition += r.y;
        }
        if (!updateFromExistingBaseLocation) {
            findReplacePosition = this.isActive(SearchOptions.FORWARD) ? (findReplacePosition += r.y) : (findReplacePosition -= r.y);
        }
        return findReplacePosition;
    }

    @Override
    public boolean performReplaceAndFind() {
        this.resetStatus();
        if (this.performSelectAndReplace()) {
            this.performSearch();
            return true;
        }
        return false;
    }

    @Override
    public boolean performSelectAndReplace() {
        this.resetStatus();
        if (!this.isFindStringSelected()) {
            this.performSearch();
        }
        if (this.getStatus().wasSuccessful()) {
            if (!this.prepareTargetForEditing()) {
                return false;
            }
            try {
                this.replaceSelection();
                return true;
            }
            catch (PatternSyntaxException ex) {
                this.status = new InvalidRegExStatus(ex);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isFindStringSelected() {
        String selectedString = this.getCurrentSelection();
        if (this.isAvailableAndActive(SearchOptions.REGEX)) {
            int patternFlags = 0;
            if (!this.isAvailableAndActive(SearchOptions.CASE_SENSITIVE)) {
                patternFlags |= 0x42;
            }
            Pattern pattern = Pattern.compile(this.findString, patternFlags);
            return pattern.matcher(selectedString).find();
        }
        if (this.isAvailableAndActive(SearchOptions.CASE_SENSITIVE)) {
            return this.getCurrentSelection().equals(this.findString);
        }
        return this.getCurrentSelection().equalsIgnoreCase(this.findString);
    }

    @Override
    public void updateTarget(IFindReplaceTarget newTarget, boolean canEditTarget) {
        this.resetStatus();
        this.isTargetEditable = canEditTarget;
        if (this.target != newTarget) {
            if (this.target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.target).endSession();
            }
            this.target = newTarget;
            this.isTargetSupportingRegEx = newTarget instanceof IFindReplaceTargetExtension3;
            if (newTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)newTarget).beginSession();
                this.activate(SearchOptions.GLOBAL);
            }
        }
        this.resetIncrementalBaseLocation();
    }

    @Override
    public void dispose() {
        if (this.target != null && this.target instanceof IFindReplaceTargetExtension) {
            ((IFindReplaceTargetExtension)this.target).endSession();
        }
        this.target = null;
    }

    private String getCurrentSelection() {
        if (this.target == null) {
            return null;
        }
        return this.target.getSelectionText();
    }

    private boolean isEditable() {
        boolean isEditable;
        boolean bl = isEditable = this.target == null ? false : this.target.isEditable();
        return this.isTargetEditable && isEditable;
    }

    private void statusLineMessage(boolean error, String editorMessage) {
        IEditorStatusLine statusLine = this.getStatusLineManager();
        if (statusLine != null) {
            statusLine.setMessage(error, editorMessage, null);
        }
    }

    private void statusLineMessage(String message) {
        this.statusLineMessage(false, message);
    }

    @Override
    public IFindReplaceTarget getTarget() {
        return this.target;
    }
}

