/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridProcedure;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;

public class CubridProcedureParameter
implements DBSProcedureParameter {
    private String argName;
    private String dataType;
    private String mode;
    private String comment;
    private CubridProcedure procedure;

    public CubridProcedureParameter(@NotNull CubridProcedure procedure, @NotNull String argName, @NotNull String dataType, @NotNull String mode, @Nullable String comment) {
        this.procedure = procedure;
        this.argName = argName;
        this.dataType = dataType;
        this.mode = mode;
        this.comment = comment;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.argName;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getDataType() {
        return this.dataType;
    }

    @Property(viewable=true, order=5)
    @Nullable
    public String getDescription() {
        return this.comment;
    }

    @Nullable
    public DBSTypedObject getParameterType() {
        return (DBSTypedObject)this;
    }

    @NotNull
    public CubridProcedure getParentObject() {
        return this.procedure;
    }

    @Property(viewable=true, order=4)
    @NotNull
    public DBSProcedureParameterKind getParameterKind() {
        switch (this.mode) {
            case "IN": {
                return DBSProcedureParameterKind.IN;
            }
            case "INOUT": {
                return DBSProcedureParameterKind.INOUT;
            }
            case "OUT": {
                return DBSProcedureParameterKind.OUT;
            }
        }
        return DBSProcedureParameterKind.UNKNOWN;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.procedure.getDataSource();
    }

    @NotNull
    public boolean isPersisted() {
        return true;
    }
}

