/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshChangeListener;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public class RefreshSubscriberParticipantJob
extends RefreshParticipantJob {
    private final IResource[] resources;

    public RefreshSubscriberParticipantJob(SubscriberParticipant participant, String jobName, String taskName, IResource[] resources, IRefreshSubscriberListener listener) {
        super(participant, jobName, taskName, listener);
        this.resources = resources;
    }

    protected Subscriber getSubscriber() {
        return ((SubscriberParticipant)this.getParticipant()).getSubscriber();
    }

    private SubscriberSyncInfoCollector getCollector() {
        return ((SubscriberParticipant)this.getParticipant()).getSubscriberSyncInfoCollector();
    }

    @Override
    protected int getChangeCount() {
        int numChanges = 0;
        SubscriberSyncInfoCollector collector = this.getCollector();
        if (collector != null) {
            SyncInfoTree set = collector.getSyncInfoSet();
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                SyncInfo[] infos = set.getSyncInfos(resource, 2);
                if (infos != null && infos.length > 0) {
                    numChanges += infos.length;
                }
                ++n2;
            }
        }
        return numChanges;
    }

    @Override
    protected int getIncomingChangeCount() {
        return this.getChangesInMode(8);
    }

    @Override
    protected int getOutgoingChangeCount() {
        return this.getChangesInMode(4);
    }

    private int getChangesInMode(int kind) {
        int numChanges = 0;
        SubscriberSyncInfoCollector collector = this.getCollector();
        if (collector != null) {
            SyncInfoTree set = collector.getSyncInfoSet();
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                SyncInfo[] infos = set.getSyncInfos(resource, 2);
                if (infos != null && infos.length > 0) {
                    SyncInfo[] syncInfoArray = infos;
                    int n3 = infos.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SyncInfo info = syncInfoArray[n4];
                        if ((info.getKind() & kind) > 0) {
                            ++numChanges;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return numChanges;
    }

    @Override
    protected RefreshParticipantJob.IChangeDescription createChangeDescription() {
        return new RefreshChangeListener(this.resources, this.getCollector());
    }

    @Override
    protected void handleProgressGroupSet(IProgressMonitor group, int ticks) {
        this.getCollector().setProgressGroup(group, ticks);
    }

    public boolean shouldRun() {
        return this.getSubscriber() != null && this.getCollector().getSyncInfoSet() != null;
    }

    @Override
    public boolean belongsTo(Object family) {
        if (family instanceof RefreshSubscriberParticipantJob) {
            return ((RefreshSubscriberParticipantJob)((Object)family)).getSubscriber() == this.getSubscriber();
        }
        return super.belongsTo(family);
    }

    @Override
    protected void doRefresh(RefreshParticipantJob.IChangeDescription changeListener, IProgressMonitor monitor) throws TeamException {
        Subscriber subscriber = this.getSubscriber();
        if (subscriber != null) {
            try {
                subscriber.addListener((ISubscriberChangeListener)((RefreshChangeListener)changeListener));
                subscriber.refresh(this.resources, 2, monitor);
                this.getCollector().waitForCollector(monitor);
            }
            finally {
                subscriber.removeListener((ISubscriberChangeListener)((RefreshChangeListener)changeListener));
            }
        }
    }
}

