// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include "certificates_models.hpp"
#include "key_vault_client_options.hpp"

#include <azure/core/datetime.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/paged_response.hpp>

#include <cstdint>
#include <map>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace Azure { namespace Security { namespace KeyVault { namespace Certificates {
  namespace _detail {
    class KeyVaultClient;

    /**
     * @brief The certificate list result.
     *
     */
    class GetCertificatesPagedResponse final
        : public Core::PagedResponse<GetCertificatesPagedResponse> {
      friend class KeyVaultClient;
      friend class Core::PagedResponse<GetCertificatesPagedResponse>;

    private:
      std::shared_ptr<KeyVaultClient> m_client;
      KeyVaultClientGetCertificatesOptions m_options;

      void OnNextPage(const Core::Context& context);

    public:
      /// A response message containing a list of certificates in the key vault along with a link to
      /// the next page of certificates.
      Nullable<std::vector<Models::CertificateItem>> Value;
    };

    /**
     * @brief The certificate issuer list result.
     *
     */
    class GetCertificateIssuersPagedResponse final
        : public Core::PagedResponse<GetCertificateIssuersPagedResponse> {
      friend class KeyVaultClient;
      friend class Core::PagedResponse<GetCertificateIssuersPagedResponse>;

    private:
      std::shared_ptr<KeyVaultClient> m_client;
      KeyVaultClientGetCertificateIssuersOptions m_options;

      void OnNextPage(const Core::Context& context);

    public:
      /// A response message containing a list of certificate issuers in the key vault along with a
      /// link to the next page of certificate issuers.
      Nullable<std::vector<Models::CertificateIssuerItem>> Value;
    };

    /**
     * @brief The certificate list result.
     *
     */
    class GetCertificateVersionsPagedResponse final
        : public Core::PagedResponse<GetCertificateVersionsPagedResponse> {
      friend class KeyVaultClient;
      friend class Core::PagedResponse<GetCertificateVersionsPagedResponse>;

    private:
      std::shared_ptr<KeyVaultClient> m_client;
      std::string m_certificateName;
      KeyVaultClientGetCertificateVersionsOptions m_options;

      void OnNextPage(const Core::Context& context);

    public:
      /// A response message containing a list of certificates in the key vault along with a link to
      /// the next page of certificates.
      Nullable<std::vector<Models::CertificateItem>> Value;
    };

    /**
     * @brief A list of certificates that have been deleted in this vault.
     *
     */
    class GetDeletedCertificatesPagedResponse final
        : public Core::PagedResponse<GetDeletedCertificatesPagedResponse> {
      friend class KeyVaultClient;
      friend class Core::PagedResponse<GetDeletedCertificatesPagedResponse>;

    private:
      std::shared_ptr<KeyVaultClient> m_client;
      KeyVaultClientGetDeletedCertificatesOptions m_options;

      void OnNextPage(const Core::Context& context);

    public:
      /// A response message containing a list of deleted certificates in the vault along with a
      /// link to the next page of deleted certificates.
      Nullable<std::vector<Models::DeletedCertificateItem>> Value;
    };
}}}}} // namespace Azure::Security::KeyVault::Certificates::_detail
