/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BoundCompositeSearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.CommitChecksKt;
import com.intellij.vcs.commit.CommitOptionsPanel;
import com.intellij.vcs.commit.CommitWorkflowHandler;
import com.intellij.vcs.commit.NullCommitWorkflowHandler;
import com.intellij.vcs.commit.message.CommitMessageInspectionsPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/configurable/CommitDialogConfigurable;", "Lcom/intellij/openapi/options/BoundCompositeSearchableConfigurable;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "postCommitConfigurables", "", "createConfigurables", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "disposeUIResources", "", "SettingsMockCheckinPanel", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCommitDialogConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitDialogConfigurable.kt\ncom/intellij/openapi/vcs/configurable/CommitDialogConfigurable\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n206#2:133\n207#2,7:144\n1617#3,9:134\n1869#3:143\n1870#3:152\n1626#3:153\n1869#3,2:154\n1869#3,2:156\n3301#3,10:158\n1#4:151\n14#5:168\n*S KotlinDebug\n*F\n+ 1 CommitDialogConfigurable.kt\ncom/intellij/openapi/vcs/configurable/CommitDialogConfigurable\n*L\n42#1:133\n42#1:144,7\n42#1:134,9\n42#1:143\n42#1:152\n42#1:153\n80#1:154,2\n86#1:156,2\n76#1:158,10\n42#1:151\n126#1:168\n*E\n"})
public final class CommitDialogConfigurable
extends BoundCompositeSearchableConfigurable<UnnamedConfigurable> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<UnnamedConfigurable> postCommitConfigurables;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String ID = "project.propVCSSupport.CommitDialog";
    @NotNull
    private static final String HELP_ID = "reference.settings.VCS.CommitDialog";

    public CommitDialogConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = VcsBundle.message((String)"commit.dialog.configurable", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, HELP_ID, ID);
        this.project = project;
        this.postCommitConfigurables = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UnnamedConfigurable> createConfigurables() {
        void $this$mapNotNullTo$iv$iv$iv;
        void $this$mapNotNullLoggingErrors$iv;
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)this.project).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        List allVcses = ArraysKt.toList((Object[])abstractVcsArray);
        SettingsMockCheckinPanel checkinPanel = new SettingsMockCheckinPanel(this.project);
        CommitContext commitContext = new CommitContext();
        List<CheckinHandler> checkinHandlers = AbstractCommitWorkflow.Companion.getCommitHandlers(allVcses, checkinPanel, commitContext);
        this.postCommitConfigurables.clear();
        Collection collection = checkinHandlers;
        Logger logger$iv = LOG;
        boolean $i$f$mapNotNullLoggingErrors = false;
        Iterable $this$mapNotNull$iv$iv = (Iterable)$this$mapNotNullLoggingErrors$iv;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnnamedConfigurable it$iv$iv$iv;
            UnnamedConfigurable unnamedConfigurable;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it$iv = element$iv$iv$iv;
            boolean bl2 = false;
            try {
                CheckinHandler handler = (CheckinHandler)it$iv;
                boolean bl3 = false;
                UnnamedConfigurable configurable = handler.getBeforeCheckinSettings();
                if (configurable != null && AbstractCommitWorkflowHandlerKt.isPostCommit(handler)) {
                    this.postCommitConfigurables.add(configurable);
                }
                unnamedConfigurable = configurable;
            }
            catch (Throwable e$iv) {
                logger$iv.error(e$iv);
                unnamedConfigurable = null;
            }
            if (unnamedConfigurable == null) continue;
            boolean bl4 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        return (List)destination$iv$iv$iv;
    }

    @NotNull
    public DialogPanel createPanel() {
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        Disposable disposable2 = disposable;
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.project);
        return BuilderKt.panel(arg_0 -> CommitDialogConfigurable.createPanel$lambda$15(this, settings, disposable2, arg_0));
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.postCommitConfigurables.clear();
    }

    private static final Unit createPanel$lambda$15$lambda$1(VcsConfiguration $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"checkbox.clear.initial.commit.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((VcsConfiguration)this.receiver).CLEAR_INITIAL_COMMIT_MESSAGE;
            }

            public void set(Object value) {
                ((VcsConfiguration)this.receiver).CLEAR_INITIAL_COMMIT_MESSAGE = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$2(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"settings.commit.message.inspections", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$6$lambda$3(CommitMessageInspectionsPanel $inspectionPanel) {
        $inspectionPanel.apply();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$6$lambda$4(CommitMessageInspectionsPanel $inspectionPanel) {
        $inspectionPanel.reset();
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$15$lambda$6$lambda$5(CommitMessageInspectionsPanel $inspectionPanel) {
        return $inspectionPanel.isModified();
    }

    private static final Unit createPanel$lambda$15$lambda$6(CommitDialogConfigurable this$0, Disposable $disposable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        CommitMessageInspectionsPanel inspectionPanel = new CommitMessageInspectionsPanel(this$0.project);
        Disposer.register((Disposable)$disposable, (Disposable)inspectionPanel);
        $this$row.cell(inspectionPanel.getComponent()).align((Align)AlignX.FILL.INSTANCE).onApply(() -> CommitDialogConfigurable.createPanel$lambda$15$lambda$6$lambda$3(inspectionPanel)).onReset(() -> CommitDialogConfigurable.createPanel$lambda$15$lambda$6$lambda$4(inspectionPanel)).onIsModified(() -> CommitDialogConfigurable.createPanel$lambda$15$lambda$6$lambda$5(inspectionPanel));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$9(List $beforeCommitChecks, CommitDialogConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Iterable $this$forEach$iv = $beforeCommitChecks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnnamedConfigurable it = (UnnamedConfigurable)element$iv;
            boolean bl = false;
            this$0.appendDslConfigurable($this$group, it);
        }
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$15$lambda$14$lambda$13$lambda$11(VcsConfiguration $settings) {
        return $settings.NON_MODAL_COMMIT_POSTPONE_SLOW_CHECKS;
    }

    private static final Unit createPanel$lambda$15$lambda$14$lambda$13$lambda$12(CommitDialogConfigurable this$0, boolean it) {
        CommitChecksKt.setRunSlowCommitChecksAfterCommit(this$0.project, it);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$14$lambda$13(VcsConfiguration $settings, CommitDialogConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"settings.commit.postpone.slow.checks", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)Cell.comment$default((Cell)$this$row.checkBox(string), (String)VcsBundle.message((String)"settings.commit.postpone.slow.checks.description", (Object[])new Object[0]), (int)0, null, (int)6, null), () -> CommitDialogConfigurable.createPanel$lambda$15$lambda$14$lambda$13$lambda$11($settings), arg_0 -> CommitDialogConfigurable.createPanel$lambda$15$lambda$14$lambda$13$lambda$12(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$14(List $postCommitChecks, CommitDialogConfigurable this$0, VcsConfiguration $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Iterable $this$forEach$iv = $postCommitChecks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnnamedConfigurable it = (UnnamedConfigurable)element$iv;
            boolean bl = false;
            this$0.appendDslConfigurable($this$group, it);
        }
        Panel.separator$default((Panel)$this$group, null, (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> CommitDialogConfigurable.createPanel$lambda$15$lambda$14$lambda$13($settings, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15(CommitDialogConfigurable this$0, VcsConfiguration $settings, Disposable $disposable, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CommitDialogConfigurable.createPanel$lambda$15$lambda$1($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, CommitDialogConfigurable::createPanel$lambda$15$lambda$2, (int)1, null).topGap(TopGap.MEDIUM);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CommitDialogConfigurable.createPanel$lambda$15$lambda$6(this$0, $disposable, arg_0), (int)1, null);
        String string = UIUtil.removeMnemonic((String)AbstractCommitWorkflowHandler.Companion.getDefaultCommitActionName(CollectionsKt.emptyList()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeMnemonic(...)");
        String actionName = string;
        Iterable $this$partition$iv = this$0.getConfigurables();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            UnnamedConfigurable it = (UnnamedConfigurable)element$iv;
            boolean bl = false;
            boolean bl2 = this$0.postCommitConfigurables.contains(it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List postCommitChecks = (List)pair.component1();
        List beforeCommitChecks = (List)pair.component2();
        if (!((Collection)beforeCommitChecks).isEmpty()) {
            Panel.group$default((Panel)$this$panel, (String)CommitOptionsPanel.Companion.commitChecksGroupTitle(actionName), (boolean)false, arg_0 -> CommitDialogConfigurable.createPanel$lambda$15$lambda$9(beforeCommitChecks, this$0, arg_0), (int)2, null);
        }
        if (!((Collection)postCommitChecks).isEmpty()) {
            Panel.group$default((Panel)$this$panel, (String)CommitOptionsPanel.Companion.postCommitChecksGroupTitle(actionName), (boolean)false, arg_0 -> CommitDialogConfigurable.createPanel$lambda$15$lambda$14(postCommitChecks, this$0, $settings, arg_0), (int)2, null);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommitDialogConfigurable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/configurable/CommitDialogConfigurable$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ID", "", "Lorg/jetbrains/annotations/NonNls;", "HELP_ID", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/vcs/configurable/CommitDialogConfigurable$SettingsMockCheckinPanel;", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getComponent", "", "getPreferredFocusedComponent", "getCommitWorkflowHandler", "Lcom/intellij/vcs/commit/CommitWorkflowHandler;", "getProject", "vcsIsAffected", "", "name", "", "hasDiffs", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFiles", "getSelectedChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "getFiles", "Ljava/io/File;", "getCommitActionName", "setCommitMessage", "", "currentDescription", "getCommitMessage", "saveState", "restoreState", "intellij.platform.vcs.impl"})
    private static final class SettingsMockCheckinPanel
    implements CheckinProjectPanel {
        @NotNull
        private final Project project;

        public SettingsMockCheckinPanel(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Nullable
        public Void getComponent() {
            return null;
        }

        @Nullable
        public Void getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public CommitWorkflowHandler getCommitWorkflowHandler() {
            return NullCommitWorkflowHandler.INSTANCE;
        }

        @NotNull
        public Project getProject() {
            return this.project;
        }

        public boolean vcsIsAffected(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return false;
        }

        public boolean hasDiffs() {
            return false;
        }

        @NotNull
        public List<VirtualFile> getRoots() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<VirtualFile> getVirtualFiles() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<Change> getSelectedChanges() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<File> getFiles() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public String getCommitActionName() {
            return AbstractCommitWorkflowHandler.Companion.getDefaultCommitActionName(CollectionsKt.emptyList());
        }

        public void setCommitMessage(@NotNull String currentDescription) {
            Intrinsics.checkNotNullParameter((Object)currentDescription, (String)"currentDescription");
        }

        @NotNull
        public String getCommitMessage() {
            return "";
        }

        public void saveState() {
        }

        public void restoreState() {
        }
    }
}

