/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitPatchWriter {
    @NonNls
    static final String GIT_DIFF_HEADER = "diff --git %s %s";
    @NonNls
    private static final String FILE_MODE_HEADER = "%s file mode %s";
    @NonNls
    private static final String INDEX_SHA1_HEADER = "index %s..%s";
    @NonNls
    private static final String FILE_RENAME_FROM_HEADER = "rename from %s";
    @NonNls
    private static final String FILE_RENAME_TO_HEADER = "rename to %s";

    @NotNull
    static String getFileModeHeader(@NotNull FileStatus fileStatus, int mode) {
        if (fileStatus == null) {
            GitPatchWriter.$$$reportNull$$$0(0);
        }
        String string = String.format(FILE_MODE_HEADER, fileStatus == FileStatus.DELETED ? "deleted" : "new", mode);
        if (string == null) {
            GitPatchWriter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    static String getIndexHeader(@NotNull String beforeHash, @NotNull String afterHash) {
        if (beforeHash == null) {
            GitPatchWriter.$$$reportNull$$$0(2);
        }
        if (afterHash == null) {
            GitPatchWriter.$$$reportNull$$$0(3);
        }
        String string = String.format(INDEX_SHA1_HEADER, beforeHash, afterHash);
        if (string == null) {
            GitPatchWriter.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void writeGitHeader(@NotNull Writer writer, @Nullable Path basePath, @NotNull FilePatch filePatch, @NotNull @NonNls String lineSeparator) throws IOException {
        if (writer == null) {
            GitPatchWriter.$$$reportNull$$$0(5);
        }
        if (filePatch == null) {
            GitPatchWriter.$$$reportNull$$$0(6);
        }
        if (lineSeparator == null) {
            GitPatchWriter.$$$reportNull$$$0(7);
        }
        writer.write(String.format(GIT_DIFF_HEADER, "a/" + filePatch.getBeforeName(), "b/" + filePatch.getAfterName()));
        writer.write(lineSeparator);
        if (filePatch.isDeletedFile()) {
            writer.write(GitPatchWriter.getFileModeHeader(FileStatus.DELETED, 100644));
            writer.write(lineSeparator);
        } else if (filePatch.isNewFile()) {
            Path afterFile = basePath == null ? Paths.get(filePatch.getAfterName(), new String[0]) : basePath.resolve(filePatch.getAfterName());
            writer.write(GitPatchWriter.getFileModeHeader(FileStatus.ADDED, !SystemInfo.isWindows && afterFile.toFile().canExecute() ? 100755 : 100644));
            writer.write(lineSeparator);
        } else if (!StringUtil.equals((CharSequence)filePatch.getBeforeName(), (CharSequence)filePatch.getAfterName())) {
            writer.write(String.format(FILE_RENAME_FROM_HEADER, filePatch.getBeforeName()));
            writer.write(lineSeparator);
            writer.write(String.format(FILE_RENAME_TO_HEADER, filePatch.getAfterName()));
            writer.write(lineSeparator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatus";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/GitPatchWriter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeHash";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterHash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatch";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/GitPatchWriter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileModeHeader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileModeHeader";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexHeader";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeGitHeader";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

